// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: logs/v1/logs.proto

/*
	Package v1 is a generated protocol buffer package.

	It is generated from these files:
		logs/v1/logs.proto

	It has these top-level messages:
		ExportLogServiceRequest
		ExportLogServiceResponse
		ResourceLogs
		LogRecord
*/
package v1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import opentelemetry_proto_common_v1 "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/common/v1"
import opentelemetry_proto_resource_v1 "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/resource/v1"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type SeverityNumber int32

const (
	SeverityNumber_UNDEFINED_SEVERITY_NUMBER SeverityNumber = 0
	SeverityNumber_TRACE                     SeverityNumber = 1
	SeverityNumber_TRACE2                    SeverityNumber = 2
	SeverityNumber_TRACE3                    SeverityNumber = 3
	SeverityNumber_TRACE4                    SeverityNumber = 4
	SeverityNumber_DEBUG                     SeverityNumber = 5
	SeverityNumber_DEBUG2                    SeverityNumber = 6
	SeverityNumber_DEBUG3                    SeverityNumber = 7
	SeverityNumber_DEBUG4                    SeverityNumber = 8
	SeverityNumber_INFO                      SeverityNumber = 9
	SeverityNumber_INFO2                     SeverityNumber = 10
	SeverityNumber_INFO3                     SeverityNumber = 11
	SeverityNumber_INFO4                     SeverityNumber = 12
	SeverityNumber_WARN                      SeverityNumber = 13
	SeverityNumber_WARN2                     SeverityNumber = 14
	SeverityNumber_WARN3                     SeverityNumber = 15
	SeverityNumber_WARN4                     SeverityNumber = 16
	SeverityNumber_ERROR                     SeverityNumber = 17
	SeverityNumber_ERROR2                    SeverityNumber = 18
	SeverityNumber_ERROR3                    SeverityNumber = 19
	SeverityNumber_ERROR4                    SeverityNumber = 20
	SeverityNumber_FATAL                     SeverityNumber = 21
	SeverityNumber_FATAL2                    SeverityNumber = 22
	SeverityNumber_FATAL3                    SeverityNumber = 23
	SeverityNumber_FATAL4                    SeverityNumber = 24
)

var SeverityNumber_name = map[int32]string{
	0:  "UNDEFINED_SEVERITY_NUMBER",
	1:  "TRACE",
	2:  "TRACE2",
	3:  "TRACE3",
	4:  "TRACE4",
	5:  "DEBUG",
	6:  "DEBUG2",
	7:  "DEBUG3",
	8:  "DEBUG4",
	9:  "INFO",
	10: "INFO2",
	11: "INFO3",
	12: "INFO4",
	13: "WARN",
	14: "WARN2",
	15: "WARN3",
	16: "WARN4",
	17: "ERROR",
	18: "ERROR2",
	19: "ERROR3",
	20: "ERROR4",
	21: "FATAL",
	22: "FATAL2",
	23: "FATAL3",
	24: "FATAL4",
}
var SeverityNumber_value = map[string]int32{
	"UNDEFINED_SEVERITY_NUMBER": 0,
	"TRACE":                     1,
	"TRACE2":                    2,
	"TRACE3":                    3,
	"TRACE4":                    4,
	"DEBUG":                     5,
	"DEBUG2":                    6,
	"DEBUG3":                    7,
	"DEBUG4":                    8,
	"INFO":                      9,
	"INFO2":                     10,
	"INFO3":                     11,
	"INFO4":                     12,
	"WARN":                      13,
	"WARN2":                     14,
	"WARN3":                     15,
	"WARN4":                     16,
	"ERROR":                     17,
	"ERROR2":                    18,
	"ERROR3":                    19,
	"ERROR4":                    20,
	"FATAL":                     21,
	"FATAL2":                    22,
	"FATAL3":                    23,
	"FATAL4":                    24,
}

func (x SeverityNumber) String() string {
	return proto.EnumName(SeverityNumber_name, int32(x))
}
func (SeverityNumber) EnumDescriptor() ([]byte, []int) { return fileDescriptorLogs, []int{0} }

type LogRecordFlags int32

const (
	LogRecordFlags_UNDEFINED_LOG_RECORD_FLAG LogRecordFlags = 0
	LogRecordFlags_TRACE_FLAGS_MASK          LogRecordFlags = 255
)

var LogRecordFlags_name = map[int32]string{
	0:   "UNDEFINED_LOG_RECORD_FLAG",
	255: "TRACE_FLAGS_MASK",
}
var LogRecordFlags_value = map[string]int32{
	"UNDEFINED_LOG_RECORD_FLAG": 0,
	"TRACE_FLAGS_MASK":          255,
}

func (x LogRecordFlags) String() string {
	return proto.EnumName(LogRecordFlags_name, int32(x))
}
func (LogRecordFlags) EnumDescriptor() ([]byte, []int) { return fileDescriptorLogs, []int{1} }

type ExportLogServiceRequest struct {
	// An array of ResourceLogs.
	// For data coming from a single resource this array will typically contain one
	// element. Intermediary nodes (such as OpenTelemetry Collector) that receive
	// data from multiple origins typically batch the data before forwarding further and
	// in that case this array will contain multiple elements.
	ResourceLogs []*ResourceLogs `protobuf:"bytes,1,rep,name=resource_logs,json=resourceLogs" json:"resource_logs,omitempty"`
}

func (m *ExportLogServiceRequest) Reset()                    { *m = ExportLogServiceRequest{} }
func (m *ExportLogServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*ExportLogServiceRequest) ProtoMessage()               {}
func (*ExportLogServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptorLogs, []int{0} }

func (m *ExportLogServiceRequest) GetResourceLogs() []*ResourceLogs {
	if m != nil {
		return m.ResourceLogs
	}
	return nil
}

type ExportLogServiceResponse struct {
}

func (m *ExportLogServiceResponse) Reset()                    { *m = ExportLogServiceResponse{} }
func (m *ExportLogServiceResponse) String() string            { return proto.CompactTextString(m) }
func (*ExportLogServiceResponse) ProtoMessage()               {}
func (*ExportLogServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptorLogs, []int{1} }

// A collection of logs from a Resource.
type ResourceLogs struct {
	// The resource for the logs in this message.
	// If this field is not set then no resource info is known.
	Resource *opentelemetry_proto_resource_v1.Resource `protobuf:"bytes,1,opt,name=resource" json:"resource,omitempty"`
	Logs     []*LogRecord                              `protobuf:"bytes,2,rep,name=logs" json:"logs,omitempty"`
}

func (m *ResourceLogs) Reset()                    { *m = ResourceLogs{} }
func (m *ResourceLogs) String() string            { return proto.CompactTextString(m) }
func (*ResourceLogs) ProtoMessage()               {}
func (*ResourceLogs) Descriptor() ([]byte, []int) { return fileDescriptorLogs, []int{2} }

func (m *ResourceLogs) GetResource() *opentelemetry_proto_resource_v1.Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *ResourceLogs) GetLogs() []*LogRecord {
	if m != nil {
		return m.Logs
	}
	return nil
}

type LogRecord struct {
	// timestamp_unix_nano is the time when the event occurred.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	// Value of 0 indicates unknown or missing timestamp.
	TimestampUnixNano uint64 `protobuf:"fixed64,1,opt,name=timestamp_unix_nano,json=timestampUnixNano,proto3" json:"timestamp_unix_nano,omitempty"`
	// A unique identifier for a trace. All logs from the same trace share
	// the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes
	// is considered invalid. Can be set for logs that are part of request processing
	// and have an assigned trace id. Optional.
	TraceId []byte `protobuf:"bytes,2,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a log within a trace, assigned when the span
	// is created. The ID is an 8-byte array. An ID with all zeroes is considered
	// invalid. Can be set for logs that are part of a particular processing span.
	// If span_id is present trace_id SHOULD be also present. Optional.
	SpanId []byte `protobuf:"bytes,3,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Optional flags, a bit field. 8 least significant bits are the trace flags as
	// defined in W3C Trace Context specification. 24 most significant bits are reserved
	// and must be set to 0. Readers that must not assume that 24 most significant bits
	// will be zero and must correctly mask the bits when reading 8-bit trace flag (use
	// flags & TRACE_FLAGS_MASK). Optional.
	Flags uint32 `protobuf:"varint,4,opt,name=flags,proto3" json:"flags,omitempty"`
	// Numerical value of the severity, normalized to values described in
	// https://github.com/open-telemetry/oteps/pull/97. Optional.
	SeverityNumber SeverityNumber `protobuf:"varint,5,opt,name=severity_number,json=severityNumber,proto3,enum=logsproto.SeverityNumber" json:"severity_number,omitempty"`
	// The severity text (also known as log level). The original string representation as
	// it is known at the source. Optional.
	SeverityText string `protobuf:"bytes,6,opt,name=severity_text,json=severityText,proto3" json:"severity_text,omitempty"`
	// Short event identifier that does not contain varying parts. ShortName describes
	// what happened (e.g. "ProcessStarted"). Recommended to be no longer than 50
	// characters. Not guaranteed to be unique in any way. Optional.
	ShortName string `protobuf:"bytes,7,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// A value containing the body of the log record. Can be for example a human-readable
	// string message (including multi-line) describing the event in a free form or it can
	// be a structured data composed of arrays and maps of other values. Optional.
	// TODO: According to Log Data Model this must be of 'any' type, but we are not yet
	// capable of representing it in memory so we are using string temporarily.
	Body string `protobuf:"bytes,8,opt,name=body,proto3" json:"body,omitempty"`
	// Additional attributes that describe the specific event occurrence. Optional.
	Attributes             []*opentelemetry_proto_common_v1.AttributeKeyValue `protobuf:"bytes,9,rep,name=attributes" json:"attributes,omitempty"`
	DroppedAttributesCount uint32                                             `protobuf:"varint,10,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (m *LogRecord) Reset()                    { *m = LogRecord{} }
func (m *LogRecord) String() string            { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()               {}
func (*LogRecord) Descriptor() ([]byte, []int) { return fileDescriptorLogs, []int{3} }

func (m *LogRecord) GetTimestampUnixNano() uint64 {
	if m != nil {
		return m.TimestampUnixNano
	}
	return 0
}

func (m *LogRecord) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *LogRecord) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *LogRecord) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *LogRecord) GetSeverityNumber() SeverityNumber {
	if m != nil {
		return m.SeverityNumber
	}
	return SeverityNumber_UNDEFINED_SEVERITY_NUMBER
}

func (m *LogRecord) GetSeverityText() string {
	if m != nil {
		return m.SeverityText
	}
	return ""
}

func (m *LogRecord) GetShortName() string {
	if m != nil {
		return m.ShortName
	}
	return ""
}

func (m *LogRecord) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *LogRecord) GetAttributes() []*opentelemetry_proto_common_v1.AttributeKeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *LogRecord) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

func init() {
	proto.RegisterType((*ExportLogServiceRequest)(nil), "logsproto.ExportLogServiceRequest")
	proto.RegisterType((*ExportLogServiceResponse)(nil), "logsproto.ExportLogServiceResponse")
	proto.RegisterType((*ResourceLogs)(nil), "logsproto.ResourceLogs")
	proto.RegisterType((*LogRecord)(nil), "logsproto.LogRecord")
	proto.RegisterEnum("logsproto.SeverityNumber", SeverityNumber_name, SeverityNumber_value)
	proto.RegisterEnum("logsproto.LogRecordFlags", LogRecordFlags_name, LogRecordFlags_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for LogService service

type LogServiceClient interface {
	// For performance reasons, it is recommended to keep this RPC
	// alive for the entire life of the application.
	Export(ctx context.Context, in *ExportLogServiceRequest, opts ...grpc.CallOption) (*ExportLogServiceResponse, error)
}

type logServiceClient struct {
	cc *grpc.ClientConn
}

func NewLogServiceClient(cc *grpc.ClientConn) LogServiceClient {
	return &logServiceClient{cc}
}

func (c *logServiceClient) Export(ctx context.Context, in *ExportLogServiceRequest, opts ...grpc.CallOption) (*ExportLogServiceResponse, error) {
	out := new(ExportLogServiceResponse)
	err := grpc.Invoke(ctx, "/logsproto.LogService/Export", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for LogService service

type LogServiceServer interface {
	// For performance reasons, it is recommended to keep this RPC
	// alive for the entire life of the application.
	Export(context.Context, *ExportLogServiceRequest) (*ExportLogServiceResponse, error)
}

func RegisterLogServiceServer(s *grpc.Server, srv LogServiceServer) {
	s.RegisterService(&_LogService_serviceDesc, srv)
}

func _LogService_Export_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportLogServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LogServiceServer).Export(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/logsproto.LogService/Export",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LogServiceServer).Export(ctx, req.(*ExportLogServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LogService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "logsproto.LogService",
	HandlerType: (*LogServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Export",
			Handler:    _LogService_Export_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "logs/v1/logs.proto",
}

func (m *ExportLogServiceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportLogServiceRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResourceLogs) > 0 {
		for _, msg := range m.ResourceLogs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintLogs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ExportLogServiceResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportLogServiceResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResourceLogs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceLogs) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Resource != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintLogs(dAtA, i, uint64(m.Resource.Size()))
		n1, err := m.Resource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.Logs) > 0 {
		for _, msg := range m.Logs {
			dAtA[i] = 0x12
			i++
			i = encodeVarintLogs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *LogRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogRecord) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TimestampUnixNano != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Logs(dAtA, i, uint64(m.TimestampUnixNano))
	}
	if len(m.TraceId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintLogs(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintLogs(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if m.Flags != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintLogs(dAtA, i, uint64(m.Flags))
	}
	if m.SeverityNumber != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintLogs(dAtA, i, uint64(m.SeverityNumber))
	}
	if len(m.SeverityText) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintLogs(dAtA, i, uint64(len(m.SeverityText)))
		i += copy(dAtA[i:], m.SeverityText)
	}
	if len(m.ShortName) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintLogs(dAtA, i, uint64(len(m.ShortName)))
		i += copy(dAtA[i:], m.ShortName)
	}
	if len(m.Body) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintLogs(dAtA, i, uint64(len(m.Body)))
		i += copy(dAtA[i:], m.Body)
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintLogs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedAttributesCount != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintLogs(dAtA, i, uint64(m.DroppedAttributesCount))
	}
	return i, nil
}

func encodeFixed64Logs(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Logs(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintLogs(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ExportLogServiceRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.ResourceLogs) > 0 {
		for _, e := range m.ResourceLogs {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	return n
}

func (m *ExportLogServiceResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResourceLogs) Size() (n int) {
	var l int
	_ = l
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovLogs(uint64(l))
	}
	if len(m.Logs) > 0 {
		for _, e := range m.Logs {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	return n
}

func (m *LogRecord) Size() (n int) {
	var l int
	_ = l
	if m.TimestampUnixNano != 0 {
		n += 9
	}
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	if m.Flags != 0 {
		n += 1 + sovLogs(uint64(m.Flags))
	}
	if m.SeverityNumber != 0 {
		n += 1 + sovLogs(uint64(m.SeverityNumber))
	}
	l = len(m.SeverityText)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	l = len(m.ShortName)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	l = len(m.Body)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovLogs(uint64(m.DroppedAttributesCount))
	}
	return n
}

func sovLogs(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozLogs(x uint64) (n int) {
	return sovLogs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ExportLogServiceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportLogServiceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportLogServiceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceLogs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceLogs = append(m.ResourceLogs, &ResourceLogs{})
			if err := m.ResourceLogs[len(m.ResourceLogs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportLogServiceResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportLogServiceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportLogServiceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceLogs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceLogs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceLogs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resource == nil {
				m.Resource = &opentelemetry_proto_resource_v1.Resource{}
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logs = append(m.Logs, &LogRecord{})
			if err := m.Logs[len(m.Logs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampUnixNano", wireType)
			}
			m.TimestampUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.TimestampUnixNano = uint64(dAtA[iNdEx-8])
			m.TimestampUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.TimestampUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.TimestampUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.TimestampUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.TimestampUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.TimestampUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.TimestampUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = append(m.TraceId[:0], dAtA[iNdEx:postIndex]...)
			if m.TraceId == nil {
				m.TraceId = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = append(m.SpanId[:0], dAtA[iNdEx:postIndex]...)
			if m.SpanId == nil {
				m.SpanId = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityNumber", wireType)
			}
			m.SeverityNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeverityNumber |= (SeverityNumber(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityText", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SeverityText = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShortName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShortName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &opentelemetry_proto_common_v1.AttributeKeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLogs(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthLogs
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowLogs
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipLogs(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthLogs = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLogs   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("logs/v1/logs.proto", fileDescriptorLogs) }

var fileDescriptorLogs = []byte{
	// 769 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x94, 0x41, 0x6f, 0xe2, 0x46,
	0x14, 0xc7, 0xe3, 0x84, 0x10, 0x78, 0x21, 0xec, 0xec, 0x6c, 0x76, 0xe3, 0x44, 0x5a, 0x84, 0xd8,
	0x0b, 0x8d, 0xb4, 0xb8, 0x31, 0x1c, 0x7a, 0xe8, 0x05, 0x82, 0x89, 0x50, 0x58, 0x53, 0x0d, 0xb0,
	0xab, 0x56, 0xaa, 0x2c, 0x83, 0xa7, 0xd4, 0x12, 0xf6, 0xb8, 0xe3, 0x01, 0xc1, 0xa9, 0x5f, 0xa1,
	0x5f, 0xa4, 0x1f, 0xa2, 0xb7, 0x1e, 0xfb, 0x11, 0xaa, 0xf4, 0x83, 0xb4, 0x9a, 0x01, 0xcf, 0x42,
	0xbb, 0xdd, 0x53, 0x7e, 0xef, 0xbd, 0xff, 0x9b, 0xf9, 0xe7, 0xf1, 0x3c, 0x80, 0x17, 0x6c, 0x9e,
	0x5a, 0xab, 0x3b, 0x4b, 0xfe, 0x6d, 0x24, 0x9c, 0x09, 0x86, 0x8b, 0x92, 0x15, 0xde, 0xdc, 0xb2,
	0x84, 0xc6, 0x82, 0x2e, 0x68, 0x44, 0x05, 0xdf, 0x58, 0x2a, 0x69, 0xcd, 0x58, 0x14, 0xb1, 0x58,
	0x36, 0x6d, 0x69, 0xdb, 0x76, 0xd3, 0xf8, 0x94, 0x96, 0xd3, 0x94, 0x2d, 0xf9, 0x8c, 0x4a, 0x75,
	0xc6, 0x5b, 0x7d, 0xed, 0x03, 0x5c, 0x39, 0xeb, 0x84, 0x71, 0x31, 0x60, 0xf3, 0x11, 0xe5, 0xab,
	0x70, 0x46, 0x09, 0xfd, 0x69, 0x49, 0x53, 0x81, 0xbf, 0x86, 0x8b, 0x4c, 0xec, 0x49, 0x33, 0xa6,
	0x51, 0x3d, 0xa9, 0x9f, 0xdb, 0x57, 0x0d, 0xed, 0xac, 0x41, 0x76, 0xf5, 0x01, 0x9b, 0xa7, 0xa4,
	0xc4, 0xf7, 0xa2, 0xda, 0x0d, 0x98, 0xff, 0x3d, 0x38, 0x4d, 0x58, 0x9c, 0xd2, 0xda, 0xcf, 0x50,
	0xda, 0xef, 0xc4, 0x0e, 0x14, 0xb2, 0x5e, 0xd3, 0xa8, 0x1a, 0xf5, 0x73, 0xfb, 0x8b, 0xc3, 0xff,
	0x63, 0x6b, 0xb6, 0xa1, 0xbd, 0xaf, 0xee, 0xf4, 0xd5, 0x44, 0xb7, 0xe2, 0x3a, 0xe4, 0x94, 0xcf,
	0x63, 0xe5, 0xf3, 0x72, 0xcf, 0xe7, 0x80, 0xcd, 0x09, 0x9d, 0x31, 0x1e, 0x10, 0xa5, 0xa8, 0xfd,
	0x7a, 0x02, 0x45, 0x9d, 0xc3, 0x0d, 0x78, 0x21, 0xc2, 0x88, 0xa6, 0xc2, 0x8f, 0x12, 0x6f, 0x19,
	0x87, 0x6b, 0x2f, 0xf6, 0x63, 0xa6, 0x9c, 0xe4, 0xc9, 0x73, 0x5d, 0x9a, 0xc4, 0xe1, 0xda, 0xf5,
	0x63, 0x86, 0xaf, 0xa1, 0x20, 0xb8, 0x3f, 0xa3, 0x5e, 0x18, 0x98, 0xc7, 0x55, 0xa3, 0x5e, 0x22,
	0x67, 0x2a, 0xee, 0x07, 0xf8, 0x0a, 0xce, 0xd2, 0xc4, 0x8f, 0x65, 0xe5, 0x44, 0x55, 0xf2, 0x32,
	0xec, 0x07, 0xf8, 0x12, 0x4e, 0x7f, 0x58, 0xf8, 0xf3, 0xd4, 0xcc, 0x55, 0x8d, 0xfa, 0x05, 0xd9,
	0x06, 0xb8, 0x03, 0xcf, 0x52, 0xba, 0xa2, 0x3c, 0x14, 0x1b, 0x2f, 0x5e, 0x46, 0x53, 0xca, 0xcd,
	0xd3, 0xaa, 0x51, 0x2f, 0xdb, 0xd7, 0x7b, 0xe6, 0x47, 0x3b, 0x85, 0xab, 0x04, 0xa4, 0x9c, 0x1e,
	0xc4, 0xf8, 0x0d, 0x5c, 0xe8, 0x33, 0x04, 0x5d, 0x0b, 0x33, 0x5f, 0x35, 0xea, 0x45, 0x52, 0xca,
	0x92, 0x63, 0xba, 0x16, 0xf8, 0x35, 0x40, 0xfa, 0x23, 0xe3, 0xc2, 0x8b, 0xfd, 0x88, 0x9a, 0x67,
	0x4a, 0x51, 0x54, 0x19, 0xd7, 0x8f, 0x28, 0xc6, 0x90, 0x9b, 0xb2, 0x60, 0x63, 0x16, 0x54, 0x41,
	0x31, 0xfe, 0x06, 0xc0, 0x17, 0x82, 0x87, 0xd3, 0xa5, 0xa0, 0xa9, 0x59, 0x54, 0x33, 0xfd, 0xf2,
	0x93, 0x3f, 0xcb, 0x6e, 0x01, 0x57, 0x77, 0x8d, 0x76, 0xd6, 0xf0, 0x48, 0x37, 0xef, 0xfd, 0xc5,
	0x92, 0x92, 0xbd, 0x33, 0xf0, 0x57, 0x60, 0x06, 0x9c, 0x25, 0x09, 0x0d, 0xbc, 0x8f, 0x59, 0x6f,
	0xc6, 0x96, 0xb1, 0x30, 0x41, 0x8d, 0xe5, 0xd5, 0xae, 0xae, 0xcf, 0x49, 0xef, 0x65, 0xf5, 0xf6,
	0xb7, 0x63, 0x28, 0x1f, 0x8e, 0x01, 0xbf, 0x86, 0xeb, 0x89, 0xdb, 0x75, 0x7a, 0x7d, 0xd7, 0xe9,
	0x7a, 0x23, 0xe7, 0xbd, 0x43, 0xfa, 0xe3, 0x6f, 0x3d, 0x77, 0xf2, 0xae, 0xe3, 0x10, 0x74, 0x84,
	0x8b, 0x70, 0x3a, 0x26, 0xed, 0x7b, 0x07, 0x19, 0x18, 0x20, 0xaf, 0xd0, 0x46, 0xc7, 0x9a, 0x9b,
	0xe8, 0x44, 0x73, 0x0b, 0xe5, 0xa4, 0xbc, 0xeb, 0x74, 0x26, 0x0f, 0xe8, 0x54, 0xa6, 0x15, 0xda,
	0x28, 0xaf, 0xb9, 0x89, 0xce, 0x34, 0xb7, 0x50, 0x01, 0x17, 0x20, 0xd7, 0x77, 0x7b, 0x43, 0x54,
	0x94, 0x8d, 0x92, 0x6c, 0x04, 0x19, 0x36, 0xd1, 0x79, 0x86, 0x2d, 0x54, 0x92, 0xd2, 0x0f, 0x6d,
	0xe2, 0xa2, 0x0b, 0x99, 0x94, 0x64, 0xa3, 0x72, 0x86, 0x4d, 0xf4, 0x2c, 0xc3, 0x16, 0x42, 0x12,
	0x1d, 0x42, 0x86, 0x04, 0x3d, 0x97, 0x97, 0x29, 0xb4, 0x11, 0xd6, 0xdc, 0x44, 0x2f, 0x34, 0xb7,
	0xd0, 0xa5, 0x94, 0xf7, 0xda, 0xe3, 0xf6, 0x00, 0xbd, 0x94, 0x69, 0x85, 0x36, 0x7a, 0xa5, 0xb9,
	0x89, 0xae, 0x34, 0xb7, 0x90, 0x79, 0xdb, 0x83, 0xb2, 0x5e, 0xf9, 0x9e, 0xda, 0xbe, 0x83, 0x11,
	0x0e, 0x86, 0x0f, 0x1e, 0x71, 0xee, 0x87, 0xa4, 0xeb, 0xf5, 0x06, 0xed, 0x07, 0x74, 0x84, 0x5f,
	0x02, 0x52, 0xf3, 0x51, 0xf1, 0xc8, 0x7b, 0xd7, 0x1e, 0x3d, 0xa2, 0xbf, 0x0d, 0xdb, 0x07, 0xf8,
	0xf8, 0x49, 0xe3, 0x11, 0xe4, 0xb7, 0x9f, 0x39, 0xae, 0xed, 0xad, 0xec, 0xff, 0x3c, 0x29, 0x37,
	0x6f, 0x3e, 0xab, 0xd9, 0xbd, 0x0e, 0x47, 0x9d, 0xef, 0x7f, 0x7f, 0xaa, 0x18, 0x7f, 0x3c, 0x55,
	0x8c, 0x3f, 0x9f, 0x2a, 0xc6, 0x2f, 0x7f, 0x55, 0x8e, 0xbe, 0x7b, 0x9c, 0xb3, 0x7f, 0xad, 0x5e,
	0x28, 0x9f, 0xc0, 0xc5, 0x82, 0xce, 0x04, 0xe3, 0x56, 0x18, 0x0b, 0xca, 0x63, 0x7f, 0x61, 0x05,
	0xbe, 0xf0, 0xad, 0x03, 0xe1, 0x5b, 0x75, 0xdb, 0xdb, 0x39, 0x8d, 0xad, 0xdd, 0x2b, 0x3b, 0xcd,
	0xab, 0x54, 0xf3, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x32, 0x90, 0x92, 0x61, 0x77, 0x05, 0x00,
	0x00,
}
