// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/metrics/v1/metrics.proto

/*
	Package v1 is a generated protocol buffer package.

	It is generated from these files:
		opentelemetry/proto/metrics/v1/metrics.proto

	It has these top-level messages:
		ResourceMetrics
		InstrumentationLibraryMetrics
		Metric
		MetricDescriptor
		Int64DataPoint
		DoubleDataPoint
		HistogramDataPoint
		SummaryDataPoint
*/
package v1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import opentelemetry_proto_common_v1 "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/common/v1"
import opentelemetry_proto_resource_v1 "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/resource/v1"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Type is the type of values a metric has.
type MetricDescriptor_Type int32

const (
	// INVALID_TYPE is the default Type, it MUST not be used.
	MetricDescriptor_INVALID_TYPE MetricDescriptor_Type = 0
	// INT64 values are signed 64-bit integers.
	//
	// A Metric of this Type MUST store its values as Int64DataPoint.
	MetricDescriptor_INT64 MetricDescriptor_Type = 1
	// MONOTONIC_INT64 values are monotonically increasing signed 64-bit
	// integers.
	//
	// A Metric of this Type MUST store its values as Int64DataPoint.
	MetricDescriptor_MONOTONIC_INT64 MetricDescriptor_Type = 2
	// DOUBLE values are double-precision floating-point numbers.
	//
	// A Metric of this Type MUST store its values as DoubleDataPoint.
	MetricDescriptor_DOUBLE MetricDescriptor_Type = 3
	// MONOTONIC_DOUBLE values are monotonically increasing double-precision
	// floating-point numbers.
	//
	// A Metric of this Type MUST store its values as DoubleDataPoint.
	MetricDescriptor_MONOTONIC_DOUBLE MetricDescriptor_Type = 4
	// Histogram measurement.
	// Corresponding values are stored in HistogramDataPoint.
	MetricDescriptor_HISTOGRAM MetricDescriptor_Type = 5
	// Summary value. Some frameworks implemented Histograms as a summary of observations
	// (usually things like request durations and response sizes). While it
	// also provides a total count of observations and a sum of all observed
	// values, it calculates configurable percentiles over a sliding time
	// window.
	// Corresponding values are stored in SummaryDataPoint.
	MetricDescriptor_SUMMARY MetricDescriptor_Type = 6
)

var MetricDescriptor_Type_name = map[int32]string{
	0: "INVALID_TYPE",
	1: "INT64",
	2: "MONOTONIC_INT64",
	3: "DOUBLE",
	4: "MONOTONIC_DOUBLE",
	5: "HISTOGRAM",
	6: "SUMMARY",
}
var MetricDescriptor_Type_value = map[string]int32{
	"INVALID_TYPE":     0,
	"INT64":            1,
	"MONOTONIC_INT64":  2,
	"DOUBLE":           3,
	"MONOTONIC_DOUBLE": 4,
	"HISTOGRAM":        5,
	"SUMMARY":          6,
}

func (x MetricDescriptor_Type) String() string {
	return proto.EnumName(MetricDescriptor_Type_name, int32(x))
}
func (MetricDescriptor_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMetrics, []int{3, 0}
}

// Temporality is the temporal quality values of a metric have. It
// describes how those values relate to the time interval over which they
// are reported.
type MetricDescriptor_Temporality int32

const (
	// INVALID_TEMPORALITY is the default Temporality, it MUST not be
	// used.
	MetricDescriptor_INVALID_TEMPORALITY MetricDescriptor_Temporality = 0
	// INSTANTANEOUS is a metric whose values are measured at a particular
	// instant. The values are not aggregated over any time interval and are
	// unique per timestamp. As such, these metrics are not expected to have
	// an associated start time.
	MetricDescriptor_INSTANTANEOUS MetricDescriptor_Temporality = 1
	// DELTA is a metric whose values are the aggregation of measurements
	// made over a time interval. Successive metrics contain aggregation of
	// values from continuous and non-overlapping intervals.
	//
	// The values for a DELTA metric are based only on the time interval
	// associated with one measurement cycle. There is no dependency on
	// previous measurements like is the case for CUMULATIVE metrics.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// DELTA metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0+1 to
	//      t_0+2 with a value of 2.
	MetricDescriptor_DELTA MetricDescriptor_Temporality = 2
	// CUMULATIVE is a metric whose values are the aggregation of
	// successively made measurements from a fixed start time until the last
	// reported measurement. This means that current values of a CUMULATIVE
	// metric depend on all previous measurements since the start time.
	// Because of this, the sender is required to retain this state in some
	// form. If this state is lost or invalidated, the CUMULATIVE metric
	// values MUST be reset and a new fixed start time following the last
	// reported measurement time sent MUST be used.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// CUMULATIVE metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+2 with a value of 5.
	//   9. The system experiences a fault and loses state.
	//   10. The system recovers and resumes receiving at time=t_1.
	//   11. A request is received, the system measures 1 request.
	//   12. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_1 to
	//      t_0+1 with a value of 1.
	MetricDescriptor_CUMULATIVE MetricDescriptor_Temporality = 3
)

var MetricDescriptor_Temporality_name = map[int32]string{
	0: "INVALID_TEMPORALITY",
	1: "INSTANTANEOUS",
	2: "DELTA",
	3: "CUMULATIVE",
}
var MetricDescriptor_Temporality_value = map[string]int32{
	"INVALID_TEMPORALITY": 0,
	"INSTANTANEOUS":       1,
	"DELTA":               2,
	"CUMULATIVE":          3,
}

func (x MetricDescriptor_Temporality) String() string {
	return proto.EnumName(MetricDescriptor_Temporality_name, int32(x))
}
func (MetricDescriptor_Temporality) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMetrics, []int{3, 1}
}

// A collection of InstrumentationLibraryMetrics from a Resource.
type ResourceMetrics struct {
	// The resource for the metrics in this message.
	// If this field is not set then no resource info is known.
	Resource *opentelemetry_proto_resource_v1.Resource `protobuf:"bytes,1,opt,name=resource" json:"resource,omitempty"`
	// A list of metrics that originate from a resource.
	InstrumentationLibraryMetrics []*InstrumentationLibraryMetrics `protobuf:"bytes,2,rep,name=instrumentation_library_metrics,json=instrumentationLibraryMetrics" json:"instrumentation_library_metrics,omitempty"`
}

func (m *ResourceMetrics) Reset()                    { *m = ResourceMetrics{} }
func (m *ResourceMetrics) String() string            { return proto.CompactTextString(m) }
func (*ResourceMetrics) ProtoMessage()               {}
func (*ResourceMetrics) Descriptor() ([]byte, []int) { return fileDescriptorMetrics, []int{0} }

func (m *ResourceMetrics) GetResource() *opentelemetry_proto_resource_v1.Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *ResourceMetrics) GetInstrumentationLibraryMetrics() []*InstrumentationLibraryMetrics {
	if m != nil {
		return m.InstrumentationLibraryMetrics
	}
	return nil
}

// A collection of Metrics produced by an InstrumentationLibrary.
type InstrumentationLibraryMetrics struct {
	// The instrumentation library information for the metrics in this message.
	// If this field is not set then no library info is known.
	InstrumentationLibrary *opentelemetry_proto_common_v1.InstrumentationLibrary `protobuf:"bytes,1,opt,name=instrumentation_library,json=instrumentationLibrary" json:"instrumentation_library,omitempty"`
	// A list of metrics that originate from an instrumentation library.
	Metrics []*Metric `protobuf:"bytes,2,rep,name=metrics" json:"metrics,omitempty"`
}

func (m *InstrumentationLibraryMetrics) Reset()         { *m = InstrumentationLibraryMetrics{} }
func (m *InstrumentationLibraryMetrics) String() string { return proto.CompactTextString(m) }
func (*InstrumentationLibraryMetrics) ProtoMessage()    {}
func (*InstrumentationLibraryMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptorMetrics, []int{1}
}

func (m *InstrumentationLibraryMetrics) GetInstrumentationLibrary() *opentelemetry_proto_common_v1.InstrumentationLibrary {
	if m != nil {
		return m.InstrumentationLibrary
	}
	return nil
}

func (m *InstrumentationLibraryMetrics) GetMetrics() []*Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// Defines a Metric which has one or more timeseries.
//
// The data model and relation between entities is shown in the diagram below.
//
// - Metric is composed of a MetricDescriptor and a list of data points.
// - MetricDescriptor contains a list of label keys (shown horizontally).
// - Data is a list of DataPoints (shown vertically).
// - DataPoint contains a list of label values and a value.
//
//     Metric
//  +----------+         +------------------------+
//  |descriptor|-------->| MetricDescriptor       |
//  |          |         |+-----+-----+   +-----+ |
//  |          |         ||label|label|...|label| |
//  |      data|--+      ||key1 |key2 |   |keyN | |
//  +----------+  |      |+-----+-----+   +-----+ |
//                |      +------------------------+
//                |
//                |      +---------------------------+
//                |      |DataPoint 1                |
//                v      |+------+------+   +------+ |
//             +-----+   ||label |label |...|label | |
//             |  1  |-->||value1|value2|...|valueN| |
//             +-----+   |+------+------+   +------+ |
//             |  .  |   |+-----+                    |
//             |  .  |   ||value|                    |
//             |  .  |   |+-----+                    |
//             |  .  |   +---------------------------+
//             |  .  |                   .
//             |  .  |                   .
//             |  .  |                   .
//             |  .  |   +---------------------------+
//             |  .  |   |DataPoint M                |
//             +-----+   |+------+------+   +------+ |
//             |  M  |-->||label |label |...|label | |
//             +-----+   ||value1|value2|...|valueN| |
//                       |+------+------+   +------+ |
//                       |+-----+                    |
//                       ||value|                    |
//                       |+-----+                    |
//                       +---------------------------+
//
// -----------------------------------------------------------------------
// DataPoint is a value of specific type corresponding to a given moment in
// time. Each DataPoint is timestamped.
//
// DataPoint is strongly typed: each DataPoint type has a specific Protobuf message
// depending on the value type of the metric and thus there are currently 4 DataPoint
// messages, which correspond to the types of metric values.
type Metric struct {
	// metric_descriptor describes the Metric.
	MetricDescriptor *MetricDescriptor `protobuf:"bytes,1,opt,name=metric_descriptor,json=metricDescriptor" json:"metric_descriptor,omitempty"`
	// Data is a list of one or more DataPoints for a single metric. Only one of the
	// following fields is used for the data, depending on the type of the metric defined
	// by MetricDescriptor.type field.
	Int64DataPoints     []*Int64DataPoint     `protobuf:"bytes,2,rep,name=int64_data_points,json=int64DataPoints" json:"int64_data_points,omitempty"`
	DoubleDataPoints    []*DoubleDataPoint    `protobuf:"bytes,3,rep,name=double_data_points,json=doubleDataPoints" json:"double_data_points,omitempty"`
	HistogramDataPoints []*HistogramDataPoint `protobuf:"bytes,4,rep,name=histogram_data_points,json=histogramDataPoints" json:"histogram_data_points,omitempty"`
	SummaryDataPoints   []*SummaryDataPoint   `protobuf:"bytes,5,rep,name=summary_data_points,json=summaryDataPoints" json:"summary_data_points,omitempty"`
}

func (m *Metric) Reset()                    { *m = Metric{} }
func (m *Metric) String() string            { return proto.CompactTextString(m) }
func (*Metric) ProtoMessage()               {}
func (*Metric) Descriptor() ([]byte, []int) { return fileDescriptorMetrics, []int{2} }

func (m *Metric) GetMetricDescriptor() *MetricDescriptor {
	if m != nil {
		return m.MetricDescriptor
	}
	return nil
}

func (m *Metric) GetInt64DataPoints() []*Int64DataPoint {
	if m != nil {
		return m.Int64DataPoints
	}
	return nil
}

func (m *Metric) GetDoubleDataPoints() []*DoubleDataPoint {
	if m != nil {
		return m.DoubleDataPoints
	}
	return nil
}

func (m *Metric) GetHistogramDataPoints() []*HistogramDataPoint {
	if m != nil {
		return m.HistogramDataPoints
	}
	return nil
}

func (m *Metric) GetSummaryDataPoints() []*SummaryDataPoint {
	if m != nil {
		return m.SummaryDataPoints
	}
	return nil
}

// Defines a metric type and its schema.
type MetricDescriptor struct {
	// name of the metric, including its DNS name prefix. It must be unique.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// description of the metric, which can be used in documentation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// unit in which the metric value is reported. Follows the format
	// described by http://unitsofmeasure.org/ucum.html.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	// type is the type of values this metric has.
	Type MetricDescriptor_Type `protobuf:"varint,4,opt,name=type,proto3,enum=opentelemetry.proto.metrics.v1.MetricDescriptor_Type" json:"type,omitempty"`
	// temporality is the Temporality of values this metric has.
	Temporality MetricDescriptor_Temporality `protobuf:"varint,5,opt,name=temporality,proto3,enum=opentelemetry.proto.metrics.v1.MetricDescriptor_Temporality" json:"temporality,omitempty"`
}

func (m *MetricDescriptor) Reset()                    { *m = MetricDescriptor{} }
func (m *MetricDescriptor) String() string            { return proto.CompactTextString(m) }
func (*MetricDescriptor) ProtoMessage()               {}
func (*MetricDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetrics, []int{3} }

func (m *MetricDescriptor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MetricDescriptor) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *MetricDescriptor) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

func (m *MetricDescriptor) GetType() MetricDescriptor_Type {
	if m != nil {
		return m.Type
	}
	return MetricDescriptor_INVALID_TYPE
}

func (m *MetricDescriptor) GetTemporality() MetricDescriptor_Temporality {
	if m != nil {
		return m.Temporality
	}
	return MetricDescriptor_INVALID_TEMPORALITY
}

// Int64DataPoint is a single data point in a timeseries that describes the time-varying
// values of a int64 metric.
type Int64DataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []*opentelemetry_proto_common_v1.StringKeyValue `protobuf:"bytes,1,rep,name=labels" json:"labels,omitempty"`
	// start_time_unix_nano is the time when the cumulative value was reset to zero.
	// This is used for Counter type only. For Gauge the value is not specified and
	// defaults to 0.
	//
	// The cumulative value is over the time interval (start_time_unix_nano, time_unix_nano].
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the timestamp
	// may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this value was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// value itself.
	Value int64 `protobuf:"varint,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Int64DataPoint) Reset()                    { *m = Int64DataPoint{} }
func (m *Int64DataPoint) String() string            { return proto.CompactTextString(m) }
func (*Int64DataPoint) ProtoMessage()               {}
func (*Int64DataPoint) Descriptor() ([]byte, []int) { return fileDescriptorMetrics, []int{4} }

func (m *Int64DataPoint) GetLabels() []*opentelemetry_proto_common_v1.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Int64DataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *Int64DataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *Int64DataPoint) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// DoubleDataPoint is a single data point in a timeseries that describes the time-varying
// value of a double metric.
type DoubleDataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []*opentelemetry_proto_common_v1.StringKeyValue `protobuf:"bytes,1,rep,name=labels" json:"labels,omitempty"`
	// start_time_unix_nano is the time when the cumulative value was reset to zero.
	// This is used for Counter type only. For Gauge the value is not specified and
	// defaults to 0.
	//
	// The cumulative value is over the time interval (start_time_unix_nano, time_unix_nano].
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the timestamp
	// may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this value was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// value itself.
	Value float64 `protobuf:"fixed64,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *DoubleDataPoint) Reset()                    { *m = DoubleDataPoint{} }
func (m *DoubleDataPoint) String() string            { return proto.CompactTextString(m) }
func (*DoubleDataPoint) ProtoMessage()               {}
func (*DoubleDataPoint) Descriptor() ([]byte, []int) { return fileDescriptorMetrics, []int{5} }

func (m *DoubleDataPoint) GetLabels() []*opentelemetry_proto_common_v1.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *DoubleDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *DoubleDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *DoubleDataPoint) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// HistogramDataPoint is a single data point in a timeseries that describes the time-varying
// values of a Histogram. A Histogram contains summary statistics for a population of values,
// it may optionally contain the distribution of those values across a set of buckets.
type HistogramDataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []*opentelemetry_proto_common_v1.StringKeyValue `protobuf:"bytes,1,rep,name=labels" json:"labels,omitempty"`
	// start_time_unix_nano is the time when the cumulative value was reset to zero.
	//
	// The cumulative value is over the time interval (start_time_unix_nano, time_unix_nano].
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the timestamp
	// may be decided by the backend.
	// Note: this field is always unspecified and ignored if MetricDescriptor.type==GAUGE_HISTOGRAM.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this value was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative. This value
	// must be equal to the sum of the "count" fields in buckets if a histogram is provided.
	Count uint64 `protobuf:"varint,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero. This value must be equal to the sum of the "sum" fields in buckets if
	// a histogram is provided.
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// buckets is an optional field contains the values of histogram for each bucket.
	//
	// The sum of the values in the buckets "count" field must equal the value in the count field.
	//
	// The number of elements in buckets array must be by one greater than the
	// number of elements in bucket_bounds array.
	//
	// Note: if HistogramDataPoint.bucket_options defines bucket bounds then this field
	// must also be present and number of elements in this field must be equal to the
	// number of buckets defined by bucket_options.
	Buckets []*HistogramDataPoint_Bucket `protobuf:"bytes,6,rep,name=buckets" json:"buckets,omitempty"`
	// explicit_bounds specifies buckets with explicitly defined bounds for values.
	// The bucket boundaries are described by "bounds" field.
	//
	// This defines size(bounds) + 1 (= N) buckets. The boundaries for bucket
	// at index i are:
	//
	// [0, bounds[i]) for i == 0
	// [bounds[i-1], bounds[i]) for 0 < i < N-1
	// [bounds[i], +infinity) for i == N-1
	// The values in bounds array must be strictly increasing and > 0.
	//
	// Note: only [a, b) intervals are currently supported for each bucket. If we decides
	// to also support (a, b] intervals we should add support for these by defining a boolean
	// value which decides what type of intervals to use.
	ExplicitBounds []float64 `protobuf:"fixed64,7,rep,packed,name=explicit_bounds,json=explicitBounds" json:"explicit_bounds,omitempty"`
}

func (m *HistogramDataPoint) Reset()                    { *m = HistogramDataPoint{} }
func (m *HistogramDataPoint) String() string            { return proto.CompactTextString(m) }
func (*HistogramDataPoint) ProtoMessage()               {}
func (*HistogramDataPoint) Descriptor() ([]byte, []int) { return fileDescriptorMetrics, []int{6} }

func (m *HistogramDataPoint) GetLabels() []*opentelemetry_proto_common_v1.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *HistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *HistogramDataPoint) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *HistogramDataPoint) GetBuckets() []*HistogramDataPoint_Bucket {
	if m != nil {
		return m.Buckets
	}
	return nil
}

func (m *HistogramDataPoint) GetExplicitBounds() []float64 {
	if m != nil {
		return m.ExplicitBounds
	}
	return nil
}

// Bucket contains values for a bucket.
type HistogramDataPoint_Bucket struct {
	// The number of values in each bucket of the histogram, as described by
	// bucket_options.
	Count uint64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// exemplar is an optional representative value of the bucket.
	Exemplar *HistogramDataPoint_Bucket_Exemplar `protobuf:"bytes,2,opt,name=exemplar" json:"exemplar,omitempty"`
}

func (m *HistogramDataPoint_Bucket) Reset()         { *m = HistogramDataPoint_Bucket{} }
func (m *HistogramDataPoint_Bucket) String() string { return proto.CompactTextString(m) }
func (*HistogramDataPoint_Bucket) ProtoMessage()    {}
func (*HistogramDataPoint_Bucket) Descriptor() ([]byte, []int) {
	return fileDescriptorMetrics, []int{6, 0}
}

func (m *HistogramDataPoint_Bucket) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *HistogramDataPoint_Bucket) GetExemplar() *HistogramDataPoint_Bucket_Exemplar {
	if m != nil {
		return m.Exemplar
	}
	return nil
}

// Exemplars are example points that may be used to annotate aggregated
// Histogram values. They are metadata that gives information about a
// particular value added to a Histogram bucket.
type HistogramDataPoint_Bucket_Exemplar struct {
	// Value of the exemplar point. It determines which bucket the exemplar belongs to.
	// If bucket_options define bounds for this bucket then this value must be within
	// the defined bounds.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// time_unix_nano is the moment when this exemplar was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// exemplar_attachments are contextual information about the example value.
	// Keys in this list must be unique.
	Attachments []*opentelemetry_proto_common_v1.StringKeyValue `protobuf:"bytes,3,rep,name=attachments" json:"attachments,omitempty"`
}

func (m *HistogramDataPoint_Bucket_Exemplar) Reset()         { *m = HistogramDataPoint_Bucket_Exemplar{} }
func (m *HistogramDataPoint_Bucket_Exemplar) String() string { return proto.CompactTextString(m) }
func (*HistogramDataPoint_Bucket_Exemplar) ProtoMessage()    {}
func (*HistogramDataPoint_Bucket_Exemplar) Descriptor() ([]byte, []int) {
	return fileDescriptorMetrics, []int{6, 0, 0}
}

func (m *HistogramDataPoint_Bucket_Exemplar) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *HistogramDataPoint_Bucket_Exemplar) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint_Bucket_Exemplar) GetAttachments() []*opentelemetry_proto_common_v1.StringKeyValue {
	if m != nil {
		return m.Attachments
	}
	return nil
}

// SummaryDataPoint is a single data point in a timeseries that describes the time-varying
// values of a Summary metric.
type SummaryDataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []*opentelemetry_proto_common_v1.StringKeyValue `protobuf:"bytes,1,rep,name=labels" json:"labels,omitempty"`
	// start_time_unix_nano is the time when the cumulative value was reset to zero.
	//
	// The cumulative value is over the time interval (start_time_unix_nano, time_unix_nano].
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the timestamp
	// may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this value was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// The total number of recorded values since start_time. Optional since
	// some systems don't expose this.
	Count uint64 `protobuf:"varint,4,opt,name=count,proto3" json:"count,omitempty"`
	// The total sum of recorded values since start_time. Optional since some
	// systems don't expose this. If count is zero then this field must be zero.
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// A list of values at different percentiles of the distribution calculated
	// from the current snapshot. The percentiles must be strictly increasing.
	PercentileValues []*SummaryDataPoint_ValueAtPercentile `protobuf:"bytes,6,rep,name=percentile_values,json=percentileValues" json:"percentile_values,omitempty"`
}

func (m *SummaryDataPoint) Reset()                    { *m = SummaryDataPoint{} }
func (m *SummaryDataPoint) String() string            { return proto.CompactTextString(m) }
func (*SummaryDataPoint) ProtoMessage()               {}
func (*SummaryDataPoint) Descriptor() ([]byte, []int) { return fileDescriptorMetrics, []int{7} }

func (m *SummaryDataPoint) GetLabels() []*opentelemetry_proto_common_v1.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *SummaryDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *SummaryDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *SummaryDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *SummaryDataPoint) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *SummaryDataPoint) GetPercentileValues() []*SummaryDataPoint_ValueAtPercentile {
	if m != nil {
		return m.PercentileValues
	}
	return nil
}

// Represents the value at a given percentile of a distribution.
//
// To record Min and Max values following conventions are used:
// - The 100th percentile is equivalent to the maximum value observed.
// - The 0th percentile is equivalent to the minimum value observed.
//
// See the following issue for more context:
// https://github.com/open-telemetry/opentelemetry-proto/issues/125
type SummaryDataPoint_ValueAtPercentile struct {
	// The percentile of a distribution. Must be in the interval
	// [0.0, 100.0].
	Percentile float64 `protobuf:"fixed64,1,opt,name=percentile,proto3" json:"percentile,omitempty"`
	// The value at the given percentile of a distribution.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *SummaryDataPoint_ValueAtPercentile) Reset()         { *m = SummaryDataPoint_ValueAtPercentile{} }
func (m *SummaryDataPoint_ValueAtPercentile) String() string { return proto.CompactTextString(m) }
func (*SummaryDataPoint_ValueAtPercentile) ProtoMessage()    {}
func (*SummaryDataPoint_ValueAtPercentile) Descriptor() ([]byte, []int) {
	return fileDescriptorMetrics, []int{7, 0}
}

func (m *SummaryDataPoint_ValueAtPercentile) GetPercentile() float64 {
	if m != nil {
		return m.Percentile
	}
	return 0
}

func (m *SummaryDataPoint_ValueAtPercentile) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func init() {
	proto.RegisterType((*ResourceMetrics)(nil), "opentelemetry.proto.metrics.v1.ResourceMetrics")
	proto.RegisterType((*InstrumentationLibraryMetrics)(nil), "opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics")
	proto.RegisterType((*Metric)(nil), "opentelemetry.proto.metrics.v1.Metric")
	proto.RegisterType((*MetricDescriptor)(nil), "opentelemetry.proto.metrics.v1.MetricDescriptor")
	proto.RegisterType((*Int64DataPoint)(nil), "opentelemetry.proto.metrics.v1.Int64DataPoint")
	proto.RegisterType((*DoubleDataPoint)(nil), "opentelemetry.proto.metrics.v1.DoubleDataPoint")
	proto.RegisterType((*HistogramDataPoint)(nil), "opentelemetry.proto.metrics.v1.HistogramDataPoint")
	proto.RegisterType((*HistogramDataPoint_Bucket)(nil), "opentelemetry.proto.metrics.v1.HistogramDataPoint.Bucket")
	proto.RegisterType((*HistogramDataPoint_Bucket_Exemplar)(nil), "opentelemetry.proto.metrics.v1.HistogramDataPoint.Bucket.Exemplar")
	proto.RegisterType((*SummaryDataPoint)(nil), "opentelemetry.proto.metrics.v1.SummaryDataPoint")
	proto.RegisterType((*SummaryDataPoint_ValueAtPercentile)(nil), "opentelemetry.proto.metrics.v1.SummaryDataPoint.ValueAtPercentile")
	proto.RegisterEnum("opentelemetry.proto.metrics.v1.MetricDescriptor_Type", MetricDescriptor_Type_name, MetricDescriptor_Type_value)
	proto.RegisterEnum("opentelemetry.proto.metrics.v1.MetricDescriptor_Temporality", MetricDescriptor_Temporality_name, MetricDescriptor_Temporality_value)
}
func (m *ResourceMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetrics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Resource != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.Resource.Size()))
		n1, err := m.Resource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.InstrumentationLibraryMetrics) > 0 {
		for _, msg := range m.InstrumentationLibraryMetrics {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *InstrumentationLibraryMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstrumentationLibraryMetrics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.InstrumentationLibrary != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.InstrumentationLibrary.Size()))
		n2, err := m.InstrumentationLibrary.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.Metrics) > 0 {
		for _, msg := range m.Metrics {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Metric) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metric) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MetricDescriptor != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.MetricDescriptor.Size()))
		n3, err := m.MetricDescriptor.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.Int64DataPoints) > 0 {
		for _, msg := range m.Int64DataPoints {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DoubleDataPoints) > 0 {
		for _, msg := range m.DoubleDataPoints {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.HistogramDataPoints) > 0 {
		for _, msg := range m.HistogramDataPoints {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SummaryDataPoints) > 0 {
		for _, msg := range m.SummaryDataPoints {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *MetricDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.Unit) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Unit)))
		i += copy(dAtA[i:], m.Unit)
	}
	if m.Type != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.Type))
	}
	if m.Temporality != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.Temporality))
	}
	return i, nil
}

func (m *Int64DataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Int64DataPoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, msg := range m.Labels {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StartTimeUnixNano != 0 {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.StartTimeUnixNano))
	}
	if m.TimeUnixNano != 0 {
		dAtA[i] = 0x19
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.TimeUnixNano))
	}
	if m.Value != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.Value))
	}
	return i, nil
}

func (m *DoubleDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DoubleDataPoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, msg := range m.Labels {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StartTimeUnixNano != 0 {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.StartTimeUnixNano))
	}
	if m.TimeUnixNano != 0 {
		dAtA[i] = 0x19
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.TimeUnixNano))
	}
	if m.Value != 0 {
		dAtA[i] = 0x21
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(math.Float64bits(float64(m.Value))))
	}
	return i, nil
}

func (m *HistogramDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistogramDataPoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, msg := range m.Labels {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StartTimeUnixNano != 0 {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.StartTimeUnixNano))
	}
	if m.TimeUnixNano != 0 {
		dAtA[i] = 0x19
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.TimeUnixNano))
	}
	if m.Count != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.Count))
	}
	if m.Sum != 0 {
		dAtA[i] = 0x29
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(math.Float64bits(float64(m.Sum))))
	}
	if len(m.Buckets) > 0 {
		for _, msg := range m.Buckets {
			dAtA[i] = 0x32
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ExplicitBounds) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.ExplicitBounds)*8))
		for _, num := range m.ExplicitBounds {
			f4 := math.Float64bits(float64(num))
			dAtA[i] = uint8(f4)
			i++
			dAtA[i] = uint8(f4 >> 8)
			i++
			dAtA[i] = uint8(f4 >> 16)
			i++
			dAtA[i] = uint8(f4 >> 24)
			i++
			dAtA[i] = uint8(f4 >> 32)
			i++
			dAtA[i] = uint8(f4 >> 40)
			i++
			dAtA[i] = uint8(f4 >> 48)
			i++
			dAtA[i] = uint8(f4 >> 56)
			i++
		}
	}
	return i, nil
}

func (m *HistogramDataPoint_Bucket) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistogramDataPoint_Bucket) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Count != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.Count))
	}
	if m.Exemplar != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.Exemplar.Size()))
		n5, err := m.Exemplar.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *HistogramDataPoint_Bucket_Exemplar) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistogramDataPoint_Bucket_Exemplar) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(math.Float64bits(float64(m.Value))))
	}
	if m.TimeUnixNano != 0 {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.TimeUnixNano))
	}
	if len(m.Attachments) > 0 {
		for _, msg := range m.Attachments {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SummaryDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryDataPoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, msg := range m.Labels {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StartTimeUnixNano != 0 {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.StartTimeUnixNano))
	}
	if m.TimeUnixNano != 0 {
		dAtA[i] = 0x19
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(m.TimeUnixNano))
	}
	if m.Count != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMetrics(dAtA, i, uint64(m.Count))
	}
	if m.Sum != 0 {
		dAtA[i] = 0x29
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(math.Float64bits(float64(m.Sum))))
	}
	if len(m.PercentileValues) > 0 {
		for _, msg := range m.PercentileValues {
			dAtA[i] = 0x32
			i++
			i = encodeVarintMetrics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SummaryDataPoint_ValueAtPercentile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryDataPoint_ValueAtPercentile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Percentile != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(math.Float64bits(float64(m.Percentile))))
	}
	if m.Value != 0 {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Metrics(dAtA, i, uint64(math.Float64bits(float64(m.Value))))
	}
	return i, nil
}

func encodeFixed64Metrics(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Metrics(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintMetrics(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ResourceMetrics) Size() (n int) {
	var l int
	_ = l
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if len(m.InstrumentationLibraryMetrics) > 0 {
		for _, e := range m.InstrumentationLibraryMetrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *InstrumentationLibraryMetrics) Size() (n int) {
	var l int
	_ = l
	if m.InstrumentationLibrary != nil {
		l = m.InstrumentationLibrary.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *Metric) Size() (n int) {
	var l int
	_ = l
	if m.MetricDescriptor != nil {
		l = m.MetricDescriptor.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if len(m.Int64DataPoints) > 0 {
		for _, e := range m.Int64DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.DoubleDataPoints) > 0 {
		for _, e := range m.DoubleDataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.HistogramDataPoints) > 0 {
		for _, e := range m.HistogramDataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.SummaryDataPoints) > 0 {
		for _, e := range m.SummaryDataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *MetricDescriptor) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Unit)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovMetrics(uint64(m.Type))
	}
	if m.Temporality != 0 {
		n += 1 + sovMetrics(uint64(m.Temporality))
	}
	return n
}

func (m *Int64DataPoint) Size() (n int) {
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 1 + sovMetrics(uint64(m.Value))
	}
	return n
}

func (m *DoubleDataPoint) Size() (n int) {
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 9
	}
	return n
}

func (m *HistogramDataPoint) Size() (n int) {
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 1 + sovMetrics(uint64(m.Count))
	}
	if m.Sum != 0 {
		n += 9
	}
	if len(m.Buckets) > 0 {
		for _, e := range m.Buckets {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.ExplicitBounds) > 0 {
		n += 1 + sovMetrics(uint64(len(m.ExplicitBounds)*8)) + len(m.ExplicitBounds)*8
	}
	return n
}

func (m *HistogramDataPoint_Bucket) Size() (n int) {
	var l int
	_ = l
	if m.Count != 0 {
		n += 1 + sovMetrics(uint64(m.Count))
	}
	if m.Exemplar != nil {
		l = m.Exemplar.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}

func (m *HistogramDataPoint_Bucket_Exemplar) Size() (n int) {
	var l int
	_ = l
	if m.Value != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if len(m.Attachments) > 0 {
		for _, e := range m.Attachments {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *SummaryDataPoint) Size() (n int) {
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 1 + sovMetrics(uint64(m.Count))
	}
	if m.Sum != 0 {
		n += 9
	}
	if len(m.PercentileValues) > 0 {
		for _, e := range m.PercentileValues {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *SummaryDataPoint_ValueAtPercentile) Size() (n int) {
	var l int
	_ = l
	if m.Percentile != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 9
	}
	return n
}

func sovMetrics(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMetrics(x uint64) (n int) {
	return sovMetrics(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ResourceMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resource == nil {
				m.Resource = &opentelemetry_proto_resource_v1.Resource{}
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibraryMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstrumentationLibraryMetrics = append(m.InstrumentationLibraryMetrics, &InstrumentationLibraryMetrics{})
			if err := m.InstrumentationLibraryMetrics[len(m.InstrumentationLibraryMetrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstrumentationLibraryMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstrumentationLibraryMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstrumentationLibraryMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibrary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InstrumentationLibrary == nil {
				m.InstrumentationLibrary = &opentelemetry_proto_common_v1.InstrumentationLibrary{}
			}
			if err := m.InstrumentationLibrary.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, &Metric{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metric) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metric: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metric: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricDescriptor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetricDescriptor == nil {
				m.MetricDescriptor = &MetricDescriptor{}
			}
			if err := m.MetricDescriptor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Int64DataPoints = append(m.Int64DataPoints, &Int64DataPoint{})
			if err := m.Int64DataPoints[len(m.Int64DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleDataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DoubleDataPoints = append(m.DoubleDataPoints, &DoubleDataPoint{})
			if err := m.DoubleDataPoints[len(m.DoubleDataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistogramDataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistogramDataPoints = append(m.HistogramDataPoints, &HistogramDataPoint{})
			if err := m.HistogramDataPoints[len(m.HistogramDataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SummaryDataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SummaryDataPoints = append(m.SummaryDataPoints, &SummaryDataPoint{})
			if err := m.SummaryDataPoints[len(m.SummaryDataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (MetricDescriptor_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Temporality", wireType)
			}
			m.Temporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Temporality |= (MetricDescriptor_Temporality(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Int64DataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Int64DataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Int64DataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &opentelemetry_proto_common_v1.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.StartTimeUnixNano = uint64(dAtA[iNdEx-8])
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.TimeUnixNano = uint64(dAtA[iNdEx-8])
			m.TimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.TimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.TimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.TimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.TimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.TimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.TimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DoubleDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DoubleDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DoubleDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &opentelemetry_proto_common_v1.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.StartTimeUnixNano = uint64(dAtA[iNdEx-8])
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.TimeUnixNano = uint64(dAtA[iNdEx-8])
			m.TimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.TimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.TimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.TimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.TimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.TimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.TimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistogramDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistogramDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistogramDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &opentelemetry_proto_common_v1.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.StartTimeUnixNano = uint64(dAtA[iNdEx-8])
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.TimeUnixNano = uint64(dAtA[iNdEx-8])
			m.TimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.TimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.TimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.TimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.TimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.TimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.TimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Sum = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Buckets = append(m.Buckets, &HistogramDataPoint_Bucket{})
			if err := m.Buckets[len(m.Buckets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = uint64(dAtA[iNdEx-8])
				v |= uint64(dAtA[iNdEx-7]) << 8
				v |= uint64(dAtA[iNdEx-6]) << 16
				v |= uint64(dAtA[iNdEx-5]) << 24
				v |= uint64(dAtA[iNdEx-4]) << 32
				v |= uint64(dAtA[iNdEx-3]) << 40
				v |= uint64(dAtA[iNdEx-2]) << 48
				v |= uint64(dAtA[iNdEx-1]) << 56
				v2 := float64(math.Float64frombits(v))
				m.ExplicitBounds = append(m.ExplicitBounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = uint64(dAtA[iNdEx-8])
					v |= uint64(dAtA[iNdEx-7]) << 8
					v |= uint64(dAtA[iNdEx-6]) << 16
					v |= uint64(dAtA[iNdEx-5]) << 24
					v |= uint64(dAtA[iNdEx-4]) << 32
					v |= uint64(dAtA[iNdEx-3]) << 40
					v |= uint64(dAtA[iNdEx-2]) << 48
					v |= uint64(dAtA[iNdEx-1]) << 56
					v2 := float64(math.Float64frombits(v))
					m.ExplicitBounds = append(m.ExplicitBounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBounds", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistogramDataPoint_Bucket) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bucket: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bucket: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplar", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Exemplar == nil {
				m.Exemplar = &HistogramDataPoint_Bucket_Exemplar{}
			}
			if err := m.Exemplar.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistogramDataPoint_Bucket_Exemplar) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exemplar: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exemplar: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Value = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.TimeUnixNano = uint64(dAtA[iNdEx-8])
			m.TimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.TimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.TimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.TimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.TimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.TimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.TimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attachments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attachments = append(m.Attachments, &opentelemetry_proto_common_v1.StringKeyValue{})
			if err := m.Attachments[len(m.Attachments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SummaryDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SummaryDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SummaryDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &opentelemetry_proto_common_v1.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.StartTimeUnixNano = uint64(dAtA[iNdEx-8])
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.TimeUnixNano = uint64(dAtA[iNdEx-8])
			m.TimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.TimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.TimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.TimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.TimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.TimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.TimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Sum = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PercentileValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PercentileValues = append(m.PercentileValues, &SummaryDataPoint_ValueAtPercentile{})
			if err := m.PercentileValues[len(m.PercentileValues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SummaryDataPoint_ValueAtPercentile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueAtPercentile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueAtPercentile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Percentile", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Percentile = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetrics(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMetrics
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMetrics(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMetrics = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetrics   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("opentelemetry/proto/metrics/v1/metrics.proto", fileDescriptorMetrics) }

var fileDescriptorMetrics = []byte{
	// 1042 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x57, 0xdf, 0x6e, 0xe3, 0xc4,
	0x17, 0xde, 0x89, 0xd3, 0x74, 0x7b, 0xd2, 0x6d, 0x9d, 0x69, 0x7f, 0xbf, 0x8d, 0x2a, 0x6d, 0x28,
	0x11, 0x82, 0x82, 0xa8, 0x43, 0x4b, 0xa9, 0x84, 0x04, 0x12, 0xc9, 0x26, 0x62, 0x2d, 0xf2, 0x4f,
	0x13, 0xa7, 0x52, 0x57, 0xda, 0x35, 0x4e, 0x3a, 0xb4, 0x23, 0xec, 0x71, 0x64, 0x8f, 0xab, 0xe6,
	0x01, 0xb8, 0x47, 0x02, 0x09, 0x1e, 0x08, 0x24, 0x2e, 0xe1, 0x82, 0xfb, 0x55, 0xb9, 0xe5, 0x8e,
	0x17, 0x40, 0x1e, 0xdb, 0x89, 0x93, 0xa6, 0x0d, 0xe5, 0x0a, 0xb8, 0x3b, 0xfe, 0xe6, 0x9c, 0xef,
	0x7c, 0xe7, 0xcc, 0x99, 0xcc, 0x04, 0xde, 0x75, 0x47, 0x94, 0x0b, 0x6a, 0x53, 0x87, 0x0a, 0x6f,
	0x5c, 0x19, 0x79, 0xae, 0x70, 0x2b, 0xa1, 0xcd, 0x86, 0x7e, 0xe5, 0xf2, 0x20, 0x31, 0x35, 0xb9,
	0x80, 0x4b, 0x33, 0xde, 0x11, 0xa8, 0x25, 0x2e, 0x97, 0x07, 0x3b, 0xef, 0x2c, 0x62, 0x1b, 0xba,
	0x8e, 0xe3, 0xf2, 0x90, 0x2c, 0xb2, 0xa2, 0xb0, 0x1d, 0x6d, 0x91, 0xaf, 0x47, 0x7d, 0x37, 0xf0,
	0x86, 0x34, 0xf4, 0x4e, 0xec, 0xc8, 0xbf, 0xfc, 0x0a, 0xc1, 0x26, 0x89, 0xa1, 0x56, 0x94, 0x12,
	0x37, 0xe0, 0x61, 0xe2, 0x55, 0x44, 0xbb, 0x68, 0x2f, 0x7f, 0xf8, 0xb6, 0xb6, 0x48, 0xe2, 0x84,
	0xea, 0xf2, 0x40, 0x4b, 0x38, 0xc8, 0x24, 0x14, 0x7f, 0x85, 0xe0, 0x35, 0xc6, 0x7d, 0xe1, 0x05,
	0x0e, 0xe5, 0xc2, 0x12, 0xcc, 0xe5, 0xa6, 0xcd, 0x06, 0x9e, 0xe5, 0x8d, 0xcd, 0xb8, 0xba, 0x62,
	0x66, 0x57, 0xd9, 0xcb, 0x1f, 0x7e, 0xac, 0xdd, 0xdd, 0x01, 0x4d, 0x9f, 0xa5, 0x69, 0x46, 0x2c,
	0xb1, 0x5e, 0xf2, 0x84, 0xdd, 0xb5, 0x5c, 0xfe, 0x05, 0xc1, 0x93, 0x3b, 0x09, 0x30, 0x87, 0xc7,
	0xb7, 0x08, 0x8d, 0xeb, 0xff, 0x60, 0xa1, 0xc0, 0xb8, 0xf1, 0xb7, 0xea, 0x23, 0xff, 0x5f, 0x2c,
	0x0c, 0x7f, 0x02, 0xab, 0xb3, 0x0d, 0x78, 0x73, 0x59, 0x03, 0x22, 0xa5, 0x24, 0x09, 0x2b, 0xff,
	0xae, 0x40, 0x2e, 0xc2, 0xf0, 0x0b, 0x28, 0x44, 0xa8, 0x79, 0x46, 0xfd, 0xa1, 0xc7, 0x46, 0xc2,
	0xf5, 0x62, 0xd9, 0xef, 0xfd, 0x35, 0xda, 0xfa, 0x24, 0x8e, 0xa8, 0xce, 0x1c, 0x82, 0x9f, 0x43,
	0x81, 0x71, 0x71, 0x7c, 0x64, 0x9e, 0x59, 0xc2, 0x32, 0x47, 0x2e, 0xe3, 0x22, 0x51, 0xad, 0x2d,
	0xdf, 0x36, 0x71, 0x7c, 0x54, 0xb7, 0x84, 0xd5, 0x0d, 0xc3, 0xc8, 0x26, 0x9b, 0xf9, 0xf6, 0xf1,
	0x0b, 0xc0, 0x67, 0x6e, 0x30, 0xb0, 0xe9, 0x0c, 0xb9, 0x22, 0xc9, 0x2b, 0xcb, 0xc8, 0xeb, 0x32,
	0x72, 0xca, 0xae, 0x9e, 0xcd, 0x02, 0x3e, 0xfe, 0x02, 0xfe, 0x77, 0xc1, 0x7c, 0xe1, 0x9e, 0x7b,
	0x96, 0x33, 0x93, 0x21, 0x2b, 0x33, 0x1c, 0x2e, 0xcb, 0xf0, 0x2c, 0x09, 0x9e, 0x26, 0xd9, 0xba,
	0xb8, 0x81, 0xf9, 0xf8, 0x73, 0xd8, 0xf2, 0x03, 0xc7, 0x09, 0xe7, 0x3a, 0x9d, 0x65, 0x45, 0x66,
	0x59, 0xba, 0x07, 0xbd, 0x28, 0x74, 0x9a, 0xa3, 0xe0, 0xcf, 0x21, 0x7e, 0xf9, 0x57, 0x05, 0xd4,
	0xf9, 0xbd, 0xc2, 0x18, 0xb2, 0xdc, 0x72, 0xa2, 0x23, 0xba, 0x46, 0xa4, 0x8d, 0x77, 0x21, 0x9f,
	0x4c, 0x01, 0x73, 0x79, 0x31, 0x23, 0x97, 0xd2, 0x50, 0x18, 0x15, 0x70, 0x26, 0x8a, 0x4a, 0x14,
	0x15, 0xda, 0x58, 0x87, 0xac, 0x18, 0x8f, 0x68, 0x31, 0xbb, 0x8b, 0xf6, 0x36, 0x6e, 0x19, 0xf6,
	0x3b, 0xa6, 0x46, 0x33, 0xc6, 0x23, 0x4a, 0x24, 0x05, 0x7e, 0x09, 0x79, 0x41, 0x9d, 0x91, 0xeb,
	0x59, 0x36, 0x13, 0xe3, 0xe2, 0x8a, 0x64, 0xfc, 0xe8, 0xfe, 0x8c, 0x53, 0x0e, 0x92, 0x26, 0x2c,
	0x5f, 0x42, 0x36, 0xcc, 0x86, 0x55, 0x58, 0xd7, 0xdb, 0x27, 0xd5, 0xa6, 0x5e, 0x37, 0x8d, 0xd3,
	0x6e, 0x43, 0x7d, 0x80, 0xd7, 0x60, 0x45, 0x6f, 0x1b, 0xc7, 0x47, 0x2a, 0xc2, 0x5b, 0xb0, 0xd9,
	0xea, 0xb4, 0x3b, 0x46, 0xa7, 0xad, 0x3f, 0x35, 0x23, 0x30, 0x83, 0x01, 0x72, 0xf5, 0x4e, 0xbf,
	0xd6, 0x6c, 0xa8, 0x0a, 0xde, 0x06, 0x75, 0xea, 0x10, 0xa3, 0x59, 0xfc, 0x08, 0xd6, 0x9e, 0xe9,
	0x3d, 0xa3, 0xf3, 0x29, 0xa9, 0xb6, 0xd4, 0x15, 0x9c, 0x87, 0xd5, 0x5e, 0xbf, 0xd5, 0xaa, 0x92,
	0x53, 0x35, 0x57, 0x36, 0x20, 0x9f, 0xd2, 0x84, 0x1f, 0xc3, 0xd6, 0x24, 0x7d, 0xa3, 0xd5, 0xed,
	0x90, 0x6a, 0x53, 0x37, 0x4e, 0xd5, 0x07, 0xb8, 0x00, 0x8f, 0xf4, 0x76, 0xcf, 0xa8, 0xb6, 0x8d,
	0x6a, 0xbb, 0xd1, 0xe9, 0xf7, 0x54, 0x14, 0x0a, 0xab, 0x37, 0x9a, 0x46, 0x55, 0xcd, 0xe0, 0x0d,
	0x80, 0xa7, 0xfd, 0x56, 0xbf, 0x59, 0x35, 0xf4, 0x93, 0x86, 0xaa, 0x94, 0x7f, 0x40, 0xb0, 0x31,
	0x7b, 0x48, 0x70, 0x03, 0x72, 0xb6, 0x35, 0xa0, 0xb6, 0x5f, 0x44, 0x72, 0x7e, 0xf6, 0x97, 0xfc,
	0xf4, 0xf4, 0x84, 0xc7, 0xf8, 0xf9, 0x67, 0x74, 0x7c, 0x62, 0xd9, 0x01, 0x25, 0x71, 0x30, 0xae,
	0xc0, 0xb6, 0x2f, 0x2c, 0x4f, 0x98, 0x82, 0x39, 0xd4, 0x0c, 0x38, 0xbb, 0x32, 0xb9, 0xc5, 0x5d,
	0x39, 0x11, 0x39, 0x52, 0x90, 0x6b, 0x06, 0x73, 0x68, 0x9f, 0xb3, 0xab, 0xb6, 0xc5, 0x5d, 0xfc,
	0x06, 0x6c, 0xcc, 0xb9, 0x2a, 0xd2, 0x75, 0x5d, 0xa4, 0xbd, 0xb6, 0x61, 0xe5, 0x32, 0xcc, 0x23,
	0x47, 0x45, 0x21, 0xd1, 0x47, 0xf9, 0x47, 0x04, 0x9b, 0x73, 0xc7, 0xf1, 0xdf, 0x54, 0x07, 0x4a,
	0xea, 0xf8, 0x23, 0x0b, 0xf8, 0xe6, 0xa1, 0xff, 0xe7, 0x97, 0x32, 0x74, 0x03, 0x2e, 0x64, 0x29,
	0x59, 0x12, 0x7d, 0x60, 0x15, 0x14, 0x3f, 0x70, 0xe4, 0xf9, 0x43, 0x24, 0x34, 0x71, 0x0f, 0x56,
	0x07, 0xc1, 0xf0, 0x4b, 0x2a, 0xfc, 0x62, 0x4e, 0x96, 0xf1, 0xe1, 0xfd, 0x7f, 0xff, 0xb4, 0x9a,
	0x64, 0x20, 0x09, 0x13, 0x7e, 0x0b, 0x36, 0xe9, 0xd5, 0xc8, 0x66, 0x43, 0x26, 0xcc, 0x81, 0x1b,
	0xf0, 0x33, 0xbf, 0xb8, 0xba, 0xab, 0xec, 0x21, 0xb2, 0x91, 0xc0, 0x35, 0x89, 0xee, 0x7c, 0x9f,
	0x81, 0x5c, 0x14, 0x3c, 0x15, 0x8c, 0xd2, 0x82, 0x5f, 0xc2, 0x43, 0x7a, 0x45, 0x9d, 0x91, 0x6d,
	0x79, 0xb2, 0x23, 0xf9, 0xc3, 0xda, 0xdf, 0xd6, 0xa7, 0x35, 0x62, 0x26, 0x32, 0xe1, 0xdc, 0xf9,
	0x0e, 0xc1, 0xc3, 0x04, 0x9e, 0x6e, 0x3f, 0x4a, 0x6d, 0xff, 0x82, 0x7e, 0x67, 0x16, 0xf4, 0xbb,
	0x03, 0x79, 0x4b, 0x08, 0x6b, 0x78, 0x11, 0x5e, 0xeb, 0xc9, 0x6d, 0x75, 0xcf, 0x91, 0x48, 0x33,
	0x94, 0xbf, 0x55, 0x40, 0x9d, 0xbf, 0x04, 0xfe, 0x23, 0x33, 0xe7, 0x42, 0x61, 0x44, 0xbd, 0x21,
	0xe5, 0x82, 0xd9, 0xd4, 0x94, 0x5d, 0x4e, 0xa6, 0xaf, 0x76, 0xdf, 0x7b, 0x51, 0x93, 0x95, 0x55,
	0x45, 0x77, 0x42, 0x48, 0xd4, 0x29, 0xb9, 0x5c, 0xf4, 0x77, 0x74, 0x28, 0xdc, 0x70, 0xc3, 0x25,
	0x80, 0xa9, 0x63, 0xbc, 0xe5, 0x29, 0x64, 0x3a, 0x0d, 0x99, 0xd4, 0x34, 0xd4, 0xbe, 0x41, 0x3f,
	0x5d, 0x97, 0xd0, 0xcf, 0xd7, 0x25, 0xf4, 0xea, 0xba, 0x84, 0xbe, 0xfe, 0xad, 0xf4, 0x00, 0x5e,
	0x67, 0xee, 0x12, 0xd5, 0xb5, 0xf5, 0xf8, 0x4d, 0xd9, 0x0d, 0x17, 0xba, 0xe8, 0x79, 0xfb, 0x7c,
	0x3e, 0x84, 0x85, 0x6f, 0x77, 0xdb, 0xa6, 0x43, 0xe1, 0x7a, 0x15, 0xc6, 0x05, 0xf5, 0xb8, 0x65,
	0x57, 0xc2, 0x87, 0x43, 0x65, 0xc6, 0x71, 0x5f, 0x72, 0xef, 0x9f, 0x53, 0x9e, 0xfa, 0xe7, 0x30,
	0xc8, 0x49, 0xf4, 0xfd, 0x3f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x1e, 0xef, 0x70, 0x68, 0x62, 0x0c,
	0x00, 0x00,
}
