// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: logs/v1/logs.proto

package v1

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	v11 "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/common/v1"
	v1 "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/resource/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type SeverityNumber int32

const (
	SeverityNumber_UNDEFINED_SEVERITY_NUMBER SeverityNumber = 0
	SeverityNumber_TRACE                     SeverityNumber = 1
	SeverityNumber_TRACE2                    SeverityNumber = 2
	SeverityNumber_TRACE3                    SeverityNumber = 3
	SeverityNumber_TRACE4                    SeverityNumber = 4
	SeverityNumber_DEBUG                     SeverityNumber = 5
	SeverityNumber_DEBUG2                    SeverityNumber = 6
	SeverityNumber_DEBUG3                    SeverityNumber = 7
	SeverityNumber_DEBUG4                    SeverityNumber = 8
	SeverityNumber_INFO                      SeverityNumber = 9
	SeverityNumber_INFO2                     SeverityNumber = 10
	SeverityNumber_INFO3                     SeverityNumber = 11
	SeverityNumber_INFO4                     SeverityNumber = 12
	SeverityNumber_WARN                      SeverityNumber = 13
	SeverityNumber_WARN2                     SeverityNumber = 14
	SeverityNumber_WARN3                     SeverityNumber = 15
	SeverityNumber_WARN4                     SeverityNumber = 16
	SeverityNumber_ERROR                     SeverityNumber = 17
	SeverityNumber_ERROR2                    SeverityNumber = 18
	SeverityNumber_ERROR3                    SeverityNumber = 19
	SeverityNumber_ERROR4                    SeverityNumber = 20
	SeverityNumber_FATAL                     SeverityNumber = 21
	SeverityNumber_FATAL2                    SeverityNumber = 22
	SeverityNumber_FATAL3                    SeverityNumber = 23
	SeverityNumber_FATAL4                    SeverityNumber = 24
)

var SeverityNumber_name = map[int32]string{
	0:  "UNDEFINED_SEVERITY_NUMBER",
	1:  "TRACE",
	2:  "TRACE2",
	3:  "TRACE3",
	4:  "TRACE4",
	5:  "DEBUG",
	6:  "DEBUG2",
	7:  "DEBUG3",
	8:  "DEBUG4",
	9:  "INFO",
	10: "INFO2",
	11: "INFO3",
	12: "INFO4",
	13: "WARN",
	14: "WARN2",
	15: "WARN3",
	16: "WARN4",
	17: "ERROR",
	18: "ERROR2",
	19: "ERROR3",
	20: "ERROR4",
	21: "FATAL",
	22: "FATAL2",
	23: "FATAL3",
	24: "FATAL4",
}

var SeverityNumber_value = map[string]int32{
	"UNDEFINED_SEVERITY_NUMBER": 0,
	"TRACE":                     1,
	"TRACE2":                    2,
	"TRACE3":                    3,
	"TRACE4":                    4,
	"DEBUG":                     5,
	"DEBUG2":                    6,
	"DEBUG3":                    7,
	"DEBUG4":                    8,
	"INFO":                      9,
	"INFO2":                     10,
	"INFO3":                     11,
	"INFO4":                     12,
	"WARN":                      13,
	"WARN2":                     14,
	"WARN3":                     15,
	"WARN4":                     16,
	"ERROR":                     17,
	"ERROR2":                    18,
	"ERROR3":                    19,
	"ERROR4":                    20,
	"FATAL":                     21,
	"FATAL2":                    22,
	"FATAL3":                    23,
	"FATAL4":                    24,
}

func (x SeverityNumber) String() string {
	return proto.EnumName(SeverityNumber_name, int32(x))
}

func (SeverityNumber) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5e9a98bab354281e, []int{0}
}

type LogRecordFlags int32

const (
	LogRecordFlags_UNDEFINED_LOG_RECORD_FLAG LogRecordFlags = 0
	LogRecordFlags_TRACE_FLAGS_MASK          LogRecordFlags = 255
)

var LogRecordFlags_name = map[int32]string{
	0:   "UNDEFINED_LOG_RECORD_FLAG",
	255: "TRACE_FLAGS_MASK",
}

var LogRecordFlags_value = map[string]int32{
	"UNDEFINED_LOG_RECORD_FLAG": 0,
	"TRACE_FLAGS_MASK":          255,
}

func (x LogRecordFlags) String() string {
	return proto.EnumName(LogRecordFlags_name, int32(x))
}

func (LogRecordFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5e9a98bab354281e, []int{1}
}

type ExportLogServiceRequest struct {
	// An array of ResourceLogs.
	// For data coming from a single resource this array will typically contain one
	// element. Intermediary nodes (such as OpenTelemetry Collector) that receive
	// data from multiple origins typically batch the data before forwarding further and
	// in that case this array will contain multiple elements.
	ResourceLogs []*ResourceLogs `protobuf:"bytes,1,rep,name=resource_logs,json=resourceLogs,proto3" json:"resource_logs,omitempty"`
}

func (m *ExportLogServiceRequest) Reset()         { *m = ExportLogServiceRequest{} }
func (m *ExportLogServiceRequest) String() string { return proto.CompactTextString(m) }
func (*ExportLogServiceRequest) ProtoMessage()    {}
func (*ExportLogServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e9a98bab354281e, []int{0}
}
func (m *ExportLogServiceRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportLogServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExportLogServiceRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExportLogServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportLogServiceRequest.Merge(m, src)
}
func (m *ExportLogServiceRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExportLogServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportLogServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportLogServiceRequest proto.InternalMessageInfo

func (m *ExportLogServiceRequest) GetResourceLogs() []*ResourceLogs {
	if m != nil {
		return m.ResourceLogs
	}
	return nil
}

type ExportLogServiceResponse struct {
}

func (m *ExportLogServiceResponse) Reset()         { *m = ExportLogServiceResponse{} }
func (m *ExportLogServiceResponse) String() string { return proto.CompactTextString(m) }
func (*ExportLogServiceResponse) ProtoMessage()    {}
func (*ExportLogServiceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e9a98bab354281e, []int{1}
}
func (m *ExportLogServiceResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportLogServiceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExportLogServiceResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExportLogServiceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportLogServiceResponse.Merge(m, src)
}
func (m *ExportLogServiceResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExportLogServiceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportLogServiceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportLogServiceResponse proto.InternalMessageInfo

// A collection of logs from a Resource.
type ResourceLogs struct {
	// The resource for the logs in this message.
	// If this field is not set then no resource info is known.
	Resource *v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	Logs     []*LogRecord `protobuf:"bytes,2,rep,name=logs,proto3" json:"logs,omitempty"`
}

func (m *ResourceLogs) Reset()         { *m = ResourceLogs{} }
func (m *ResourceLogs) String() string { return proto.CompactTextString(m) }
func (*ResourceLogs) ProtoMessage()    {}
func (*ResourceLogs) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e9a98bab354281e, []int{2}
}
func (m *ResourceLogs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceLogs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceLogs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceLogs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceLogs.Merge(m, src)
}
func (m *ResourceLogs) XXX_Size() int {
	return m.Size()
}
func (m *ResourceLogs) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceLogs.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceLogs proto.InternalMessageInfo

func (m *ResourceLogs) GetResource() *v1.Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *ResourceLogs) GetLogs() []*LogRecord {
	if m != nil {
		return m.Logs
	}
	return nil
}

type LogRecord struct {
	// timestamp_unix_nano is the time when the event occurred.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	// Value of 0 indicates unknown or missing timestamp.
	TimestampUnixNano uint64 `protobuf:"fixed64,1,opt,name=timestamp_unix_nano,json=timestampUnixNano,proto3" json:"timestamp_unix_nano,omitempty"`
	// A unique identifier for a trace. All logs from the same trace share
	// the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes
	// is considered invalid. Can be set for logs that are part of request processing
	// and have an assigned trace id. Optional.
	TraceId []byte `protobuf:"bytes,2,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array. An ID with all zeroes is considered
	// invalid. Can be set for logs that are part of a particular processing span.
	// If span_id is present trace_id SHOULD be also present. Optional.
	SpanId []byte `protobuf:"bytes,3,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Optional flags, a bit field. 8 least significant bits are the trace flags as
	// defined in W3C Trace Context specification. 24 most significant bits are reserved
	// and must be set to 0. Readers that must not assume that 24 most significant bits
	// will be zero and must correctly mask the bits when reading 8-bit trace flag (use
	// flags & TRACE_FLAGS_MASK). Optional.
	Flags uint32 `protobuf:"varint,4,opt,name=flags,proto3" json:"flags,omitempty"`
	// Numerical value of the severity, normalized to values described in
	// https://github.com/open-telemetry/oteps/pull/97. Optional.
	SeverityNumber SeverityNumber `protobuf:"varint,5,opt,name=severity_number,json=severityNumber,proto3,enum=logsproto.SeverityNumber" json:"severity_number,omitempty"`
	// The severity text (also known as log level). The original string representation as
	// it is known at the source. Optional.
	SeverityText string `protobuf:"bytes,6,opt,name=severity_text,json=severityText,proto3" json:"severity_text,omitempty"`
	// Short event identifier that does not contain varying parts. ShortName describes
	// what happened (e.g. "ProcessStarted"). Recommended to be no longer than 50
	// characters. Not guaranteed to be unique in any way. Optional.
	ShortName string `protobuf:"bytes,7,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// A value containing the body of the log record. Can be for example a human-readable
	// string message (including multi-line) describing the event in a free form or it can
	// be a structured data composed of arrays and maps of other values. Optional.
	// TODO: According to Log Data Model this must be of 'any' type, but we are not yet
	// capable of representing it in memory so we are using string temporarily.
	Body string `protobuf:"bytes,8,opt,name=body,proto3" json:"body,omitempty"`
	// Additional attributes that describe the specific event occurrence. Optional.
	Attributes             []*v11.KeyValue `protobuf:"bytes,9,rep,name=attributes,proto3" json:"attributes,omitempty"`
	DroppedAttributesCount uint32          `protobuf:"varint,10,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e9a98bab354281e, []int{3}
}
func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(m, src)
}
func (m *LogRecord) XXX_Size() int {
	return m.Size()
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimestampUnixNano() uint64 {
	if m != nil {
		return m.TimestampUnixNano
	}
	return 0
}

func (m *LogRecord) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *LogRecord) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *LogRecord) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *LogRecord) GetSeverityNumber() SeverityNumber {
	if m != nil {
		return m.SeverityNumber
	}
	return SeverityNumber_UNDEFINED_SEVERITY_NUMBER
}

func (m *LogRecord) GetSeverityText() string {
	if m != nil {
		return m.SeverityText
	}
	return ""
}

func (m *LogRecord) GetShortName() string {
	if m != nil {
		return m.ShortName
	}
	return ""
}

func (m *LogRecord) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *LogRecord) GetAttributes() []*v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *LogRecord) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

func init() {
	proto.RegisterEnum("logsproto.SeverityNumber", SeverityNumber_name, SeverityNumber_value)
	proto.RegisterEnum("logsproto.LogRecordFlags", LogRecordFlags_name, LogRecordFlags_value)
	proto.RegisterType((*ExportLogServiceRequest)(nil), "logsproto.ExportLogServiceRequest")
	proto.RegisterType((*ExportLogServiceResponse)(nil), "logsproto.ExportLogServiceResponse")
	proto.RegisterType((*ResourceLogs)(nil), "logsproto.ResourceLogs")
	proto.RegisterType((*LogRecord)(nil), "logsproto.LogRecord")
}

func init() { proto.RegisterFile("logs/v1/logs.proto", fileDescriptor_5e9a98bab354281e) }

var fileDescriptor_5e9a98bab354281e = []byte{
	// 773 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x94, 0xc1, 0x6e, 0xe2, 0x46,
	0x18, 0xc7, 0x71, 0x42, 0x08, 0x7c, 0x21, 0xec, 0xec, 0x6c, 0x76, 0xe3, 0x44, 0x5a, 0x84, 0xd8,
	0x43, 0x69, 0xa4, 0xc5, 0x8a, 0xe1, 0xd0, 0x43, 0x2f, 0x24, 0x31, 0x11, 0x0a, 0x6b, 0xa4, 0x01,
	0x76, 0xd5, 0x5e, 0x2c, 0x83, 0xa7, 0xd4, 0x12, 0xf6, 0xb8, 0xe3, 0x01, 0xc1, 0xa9, 0xaf, 0xd0,
	0x87, 0xe8, 0x8b, 0xf4, 0xd6, 0xe3, 0x1e, 0x7b, 0xac, 0x92, 0x07, 0x69, 0x35, 0x03, 0x9e, 0x85,
	0x36, 0xed, 0x89, 0xdf, 0xf7, 0xff, 0xfe, 0x9f, 0xe7, 0xef, 0x61, 0x3c, 0x80, 0xe7, 0x6c, 0x96,
	0x5a, 0xcb, 0x6b, 0x4b, 0xfe, 0x36, 0x13, 0xce, 0x04, 0xc3, 0x25, 0xc9, 0x0a, 0x2f, 0xaf, 0x58,
	0x42, 0x63, 0x41, 0xe7, 0x34, 0xa2, 0x82, 0xaf, 0x2d, 0x25, 0x5a, 0x53, 0x16, 0x45, 0x2c, 0x96,
	0x43, 0x1b, 0xda, 0x8c, 0x5d, 0x36, 0x9f, 0xf3, 0x72, 0x9a, 0xb2, 0x05, 0x9f, 0x52, 0xe9, 0xce,
	0x78, 0xe3, 0xaf, 0x7f, 0x82, 0x73, 0x67, 0x95, 0x30, 0x2e, 0xfa, 0x6c, 0x36, 0xa4, 0x7c, 0x19,
	0x4e, 0x29, 0xa1, 0x3f, 0x2d, 0x68, 0x2a, 0xf0, 0xb7, 0x70, 0x9a, 0x99, 0x3d, 0x19, 0xc6, 0x34,
	0x6a, 0x87, 0x8d, 0x13, 0xfb, 0xbc, 0xa9, 0x93, 0x35, 0xc9, 0xb6, 0xdf, 0x67, 0xb3, 0x94, 0x94,
	0xf9, 0x4e, 0x55, 0xbf, 0x04, 0xf3, 0xdf, 0x0f, 0x4e, 0x13, 0x16, 0xa7, 0xb4, 0xfe, 0x33, 0x94,
	0x77, 0x27, 0xb1, 0x03, 0xc5, 0x6c, 0xd6, 0x34, 0x6a, 0x46, 0xe3, 0xc4, 0xfe, 0x7a, 0xff, 0x3d,
	0x36, 0x61, 0x9b, 0x3a, 0xfb, 0xf2, 0x5a, 0x2f, 0x4d, 0xf4, 0x28, 0x6e, 0x40, 0x5e, 0xe5, 0x3c,
	0x50, 0x39, 0xcf, 0x76, 0x72, 0xf6, 0xd9, 0x8c, 0xd0, 0x29, 0xe3, 0x01, 0x51, 0x8e, 0xfa, 0xaf,
	0x87, 0x50, 0xd2, 0x1a, 0x6e, 0xc2, 0x2b, 0x11, 0x46, 0x34, 0x15, 0x7e, 0x94, 0x78, 0x8b, 0x38,
	0x5c, 0x79, 0xb1, 0x1f, 0x33, 0x95, 0xa4, 0x40, 0x5e, 0xea, 0xd6, 0x38, 0x0e, 0x57, 0xae, 0x1f,
	0x33, 0x7c, 0x01, 0x45, 0xc1, 0xfd, 0x29, 0xf5, 0xc2, 0xc0, 0x3c, 0xa8, 0x19, 0x8d, 0x32, 0x39,
	0x56, 0x75, 0x2f, 0xc0, 0xe7, 0x70, 0x9c, 0x26, 0x7e, 0x2c, 0x3b, 0x87, 0xaa, 0x53, 0x90, 0x65,
	0x2f, 0xc0, 0x67, 0x70, 0xf4, 0xc3, 0xdc, 0x9f, 0xa5, 0x66, 0xbe, 0x66, 0x34, 0x4e, 0xc9, 0xa6,
	0xc0, 0x37, 0xf0, 0x22, 0xa5, 0x4b, 0xca, 0x43, 0xb1, 0xf6, 0xe2, 0x45, 0x34, 0xa1, 0xdc, 0x3c,
	0xaa, 0x19, 0x8d, 0x8a, 0x7d, 0xb1, 0x13, 0x7e, 0xb8, 0x75, 0xb8, 0xca, 0x40, 0x2a, 0xe9, 0x5e,
	0x8d, 0xdf, 0xc1, 0xa9, 0x7e, 0x86, 0xa0, 0x2b, 0x61, 0x16, 0x6a, 0x46, 0xa3, 0x44, 0xca, 0x99,
	0x38, 0xa2, 0x2b, 0x81, 0xdf, 0x02, 0xa4, 0x3f, 0x32, 0x2e, 0xbc, 0xd8, 0x8f, 0xa8, 0x79, 0xac,
	0x1c, 0x25, 0xa5, 0xb8, 0x7e, 0x44, 0x31, 0x86, 0xfc, 0x84, 0x05, 0x6b, 0xb3, 0xa8, 0x1a, 0x8a,
	0xf1, 0x3d, 0x80, 0x2f, 0x04, 0x0f, 0x27, 0x0b, 0x41, 0x53, 0xb3, 0xa4, 0xf6, 0xf4, 0xab, 0x67,
	0xff, 0x96, 0xed, 0x01, 0x5c, 0x5e, 0x37, 0x1f, 0xe8, 0xfa, 0xa3, 0x3f, 0x5f, 0x50, 0xb2, 0x33,
	0x8a, 0xbf, 0x01, 0x33, 0xe0, 0x2c, 0x49, 0x68, 0xe0, 0x7d, 0x51, 0xbd, 0x29, 0x5b, 0xc4, 0xc2,
	0x04, 0xb5, 0x1b, 0x6f, 0xb6, 0xfd, 0x8e, 0x6e, 0xdf, 0xca, 0xee, 0xd5, 0x6f, 0x07, 0x50, 0xd9,
	0x7f, 0x7b, 0xfc, 0x16, 0x2e, 0xc6, 0xee, 0x9d, 0xd3, 0xed, 0xb9, 0xce, 0x9d, 0x37, 0x74, 0x3e,
	0x3a, 0xa4, 0x37, 0xfa, 0xce, 0x73, 0xc7, 0x1f, 0x6e, 0x1c, 0x82, 0x72, 0xb8, 0x04, 0x47, 0x23,
	0xd2, 0xb9, 0x75, 0x90, 0x81, 0x01, 0x0a, 0x0a, 0x6d, 0x74, 0xa0, 0xb9, 0x85, 0x0e, 0x35, 0xb7,
	0x51, 0x5e, 0xda, 0xef, 0x9c, 0x9b, 0xf1, 0x3d, 0x3a, 0x92, 0xb2, 0x42, 0x1b, 0x15, 0x34, 0xb7,
	0xd0, 0xb1, 0xe6, 0x36, 0x2a, 0xe2, 0x22, 0xe4, 0x7b, 0x6e, 0x77, 0x80, 0x4a, 0x72, 0x50, 0x92,
	0x8d, 0x20, 0xc3, 0x16, 0x3a, 0xc9, 0xb0, 0x8d, 0xca, 0xd2, 0xfa, 0xa9, 0x43, 0x5c, 0x74, 0x2a,
	0x45, 0x49, 0x36, 0xaa, 0x64, 0xd8, 0x42, 0x2f, 0x32, 0x6c, 0x23, 0x24, 0xd1, 0x21, 0x64, 0x40,
	0xd0, 0x4b, 0xb9, 0x98, 0x42, 0x1b, 0x61, 0xcd, 0x2d, 0xf4, 0x4a, 0x73, 0x1b, 0x9d, 0x49, 0x7b,
	0xb7, 0x33, 0xea, 0xf4, 0xd1, 0x6b, 0x29, 0x2b, 0xb4, 0xd1, 0x1b, 0xcd, 0x2d, 0x74, 0xae, 0xb9,
	0x8d, 0xcc, 0xab, 0x2e, 0x54, 0xf4, 0x49, 0xef, 0xaa, 0x43, 0xb7, 0xb7, 0x85, 0xfd, 0xc1, 0xbd,
	0x47, 0x9c, 0xdb, 0x01, 0xb9, 0xf3, 0xba, 0xfd, 0xce, 0x3d, 0xca, 0xe1, 0xd7, 0x80, 0xd4, 0xfe,
	0xa8, 0x7a, 0xe8, 0x7d, 0xe8, 0x0c, 0x1f, 0xd0, 0x5f, 0x86, 0xed, 0x03, 0x7c, 0xf9, 0x92, 0xf1,
	0x10, 0x0a, 0x9b, 0xaf, 0x1b, 0xd7, 0x77, 0x4e, 0xea, 0x7f, 0xdc, 0x24, 0x97, 0xef, 0xfe, 0xd7,
	0xb3, 0xbd, 0x14, 0x72, 0x37, 0xf4, 0xf7, 0xc7, 0xaa, 0xf1, 0xf9, 0xb1, 0x6a, 0xfc, 0xf9, 0x58,
	0x35, 0x7e, 0x79, 0xaa, 0xe6, 0x3e, 0x3f, 0x55, 0x73, 0x7f, 0x3c, 0x55, 0x73, 0xdf, 0x3f, 0xcc,
	0xd8, 0x3f, 0x4e, 0x5e, 0x28, 0x6f, 0xc0, 0xf9, 0x9c, 0x4e, 0x05, 0xe3, 0x56, 0x18, 0x0b, 0xca,
	0x63, 0x7f, 0x6e, 0x05, 0xbe, 0xf0, 0xad, 0x3d, 0xe3, 0x7b, 0xb5, 0xea, 0xfb, 0x19, 0x8d, 0xad,
	0xed, 0x25, 0x3b, 0x29, 0x28, 0xa9, 0xf5, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0x64, 0xcc,
	0x08, 0x76, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// LogServiceClient is the client API for LogService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LogServiceClient interface {
	// For performance reasons, it is recommended to keep this RPC
	// alive for the entire life of the application.
	Export(ctx context.Context, in *ExportLogServiceRequest, opts ...grpc.CallOption) (*ExportLogServiceResponse, error)
}

type logServiceClient struct {
	cc *grpc.ClientConn
}

func NewLogServiceClient(cc *grpc.ClientConn) LogServiceClient {
	return &logServiceClient{cc}
}

func (c *logServiceClient) Export(ctx context.Context, in *ExportLogServiceRequest, opts ...grpc.CallOption) (*ExportLogServiceResponse, error) {
	out := new(ExportLogServiceResponse)
	err := c.cc.Invoke(ctx, "/logsproto.LogService/Export", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LogServiceServer is the server API for LogService service.
type LogServiceServer interface {
	// For performance reasons, it is recommended to keep this RPC
	// alive for the entire life of the application.
	Export(context.Context, *ExportLogServiceRequest) (*ExportLogServiceResponse, error)
}

// UnimplementedLogServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLogServiceServer struct {
}

func (*UnimplementedLogServiceServer) Export(ctx context.Context, req *ExportLogServiceRequest) (*ExportLogServiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Export not implemented")
}

func RegisterLogServiceServer(s *grpc.Server, srv LogServiceServer) {
	s.RegisterService(&_LogService_serviceDesc, srv)
}

func _LogService_Export_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportLogServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LogServiceServer).Export(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/logsproto.LogService/Export",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LogServiceServer).Export(ctx, req.(*ExportLogServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LogService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "logsproto.LogService",
	HandlerType: (*LogServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Export",
			Handler:    _LogService_Export_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "logs/v1/logs.proto",
}

func (m *ExportLogServiceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportLogServiceRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExportLogServiceRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceLogs) > 0 {
		for iNdEx := len(m.ResourceLogs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceLogs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExportLogServiceResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportLogServiceResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExportLogServiceResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ResourceLogs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceLogs) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceLogs) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Logs) > 0 {
		for iNdEx := len(m.Logs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Logs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLogs(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LogRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogRecord) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LogRecord) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DroppedAttributesCount != 0 {
		i = encodeVarintLogs(dAtA, i, uint64(m.DroppedAttributesCount))
		i--
		dAtA[i] = 0x50
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLogs(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Body) > 0 {
		i -= len(m.Body)
		copy(dAtA[i:], m.Body)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.Body)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.ShortName) > 0 {
		i -= len(m.ShortName)
		copy(dAtA[i:], m.ShortName)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.ShortName)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.SeverityText) > 0 {
		i -= len(m.SeverityText)
		copy(dAtA[i:], m.SeverityText)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.SeverityText)))
		i--
		dAtA[i] = 0x32
	}
	if m.SeverityNumber != 0 {
		i = encodeVarintLogs(dAtA, i, uint64(m.SeverityNumber))
		i--
		dAtA[i] = 0x28
	}
	if m.Flags != 0 {
		i = encodeVarintLogs(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SpanId) > 0 {
		i -= len(m.SpanId)
		copy(dAtA[i:], m.SpanId)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.SpanId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.TraceId) > 0 {
		i -= len(m.TraceId)
		copy(dAtA[i:], m.TraceId)
		i = encodeVarintLogs(dAtA, i, uint64(len(m.TraceId)))
		i--
		dAtA[i] = 0x12
	}
	if m.TimestampUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimestampUnixNano))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func encodeVarintLogs(dAtA []byte, offset int, v uint64) int {
	offset -= sovLogs(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ExportLogServiceRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ResourceLogs) > 0 {
		for _, e := range m.ResourceLogs {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	return n
}

func (m *ExportLogServiceResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ResourceLogs) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovLogs(uint64(l))
	}
	if len(m.Logs) > 0 {
		for _, e := range m.Logs {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	return n
}

func (m *LogRecord) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimestampUnixNano != 0 {
		n += 9
	}
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	if m.Flags != 0 {
		n += 1 + sovLogs(uint64(m.Flags))
	}
	if m.SeverityNumber != 0 {
		n += 1 + sovLogs(uint64(m.SeverityNumber))
	}
	l = len(m.SeverityText)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	l = len(m.ShortName)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	l = len(m.Body)
	if l > 0 {
		n += 1 + l + sovLogs(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovLogs(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovLogs(uint64(m.DroppedAttributesCount))
	}
	return n
}

func sovLogs(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozLogs(x uint64) (n int) {
	return sovLogs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ExportLogServiceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportLogServiceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportLogServiceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceLogs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceLogs = append(m.ResourceLogs, &ResourceLogs{})
			if err := m.ResourceLogs[len(m.ResourceLogs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportLogServiceResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportLogServiceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportLogServiceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceLogs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceLogs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceLogs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resource == nil {
				m.Resource = &v1.Resource{}
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logs = append(m.Logs, &LogRecord{})
			if err := m.Logs[len(m.Logs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampUnixNano", wireType)
			}
			m.TimestampUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimestampUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = append(m.TraceId[:0], dAtA[iNdEx:postIndex]...)
			if m.TraceId == nil {
				m.TraceId = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = append(m.SpanId[:0], dAtA[iNdEx:postIndex]...)
			if m.SpanId == nil {
				m.SpanId = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityNumber", wireType)
			}
			m.SeverityNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeverityNumber |= SeverityNumber(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityText", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SeverityText = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShortName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShortName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLogs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLogs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLogs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthLogs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLogs(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLogs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLogs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthLogs
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupLogs
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthLogs
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthLogs        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLogs          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupLogs = fmt.Errorf("proto: unexpected end of group")
)
