// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package exportertest // import "go.opentelemetry.io/collector/exporter/exportertest"

import (
	"go.opentelemetry.io/collector/component/componenttest"
)

// NewNopCreateSettings returns a new nop settings for Create*Exporter functions.
var NewNopCreateSettings = componenttest.NewNopExporterCreateSettings //nolint:staticcheck

// NewNopFactory returns an exporter.Factory that constructs nop exporters.
var NewNopFactory = componenttest.NewNopExporterFactory //nolint:staticcheck
