<!-- This file is autogenerated. See CONTRIBUTING.md for instructions to add an entry. -->

# Changelog

Starting with version v0.83.0, this changelog includes only user-facing changes.
If you are looking for developer-facing changes, check out [CHANGELOG-API.md](./CHANGELOG-API.md).

<!-- next version -->

## v1.6.0/v0.99.0

### 🛑 Breaking changes 🛑

- `builder`: Add strict version checking when using the builder. Add the temporary flag `--skip-strict-versioning `for skipping this check. (#9896)
  Strict version checking will error on major and minor version mismatches 
  between the `otelcol_version` configured and the builder version or versions 
  in the go.mod. This check can be temporarily disabled by using the `--skip-strict-versioning` 
  flag. This flag will be removed in a future minor version.
  
- `telemetry`: Distributed internal metrics across different levels. (#7890)
  The internal metrics levels are updated along with reported metrics:
  - The default level is changed from `basic` to `normal`, which can be overridden with `service::telmetry::metrics::level` configuration.
  - Batch processor metrics are updated to be reported starting from `normal` level:
    - `processor_batch_batch_send_size` 
    - `processor_batch_metadata_cardinality`
    - `processor_batch_timeout_trigger_send`
    - `processor_batch_size_trigger_send`
  - GRPC/HTTP server and client metrics are updated to be reported starting from `detailed` level:
    - http.client.* metrics
    - http.server.* metrics
    - rpc.server.* metrics
    - rpc.client.* metrics
  

### 💡 Enhancements 💡

- `confighttp`: Disable concurrency in zstd compression (#8216)
- `cmd/builder`: Allow configuring `confmap.Provider`s in the builder. (#4759)
  If no providers are specified, the defaults are used.
  The default providers are: env, file, http, https, and yaml.
  
  To configure providers, use the `providers` key in your OCB build
  manifest with a list of Go modules for your providers.
  The modules will work the same as other Collector components.
  
- `mdatagen`: enable goleak tests by default via mdatagen (#9959)
- `cmd/mdatagen`: support excluding some metrics based on string and regexes in resource_attributes (#9661)
- `cmd/mdatagen`: Generate config and factory tests covering their requirements. (#9940)
  The tests are moved from cmd/builder.
  
- `confmap`: Add `ProviderSettings`, `ConverterSettings`, `ProviderFactories`, and `ConverterFactories` fields to `confmap.ResolverSettings` (#9516)
  This allows configuring providers and converters, which are instantiated by `NewResolver` using the given factories.

### 🧰 Bug fixes 🧰

- `exporter/otlp`: Allow DNS scheme to be used in endpoint (#4274)
- `service`: fix record sampler configuration (#9968)
- `service`: ensure the tracer provider is configured via go.opentelemetry.io/contrib/config (#9967)
- `otlphttpexporter`: Fixes a bug that was preventing the otlp http exporter from propagating status. (#9892)
- `confmap`: Fix decoding negative configuration values into uints (#9060)

## v1.5.0/v0.98.0

### 🛑 Breaking changes 🛑

- `service`: emit internal collector metrics with _ instead of / with OTLP export (#9774)
  This is addressing an issue w/ the names of the metrics generated by the Collector for its
  internal metrics. Note that this change only impacts users that emit telemetry using OTLP, which
  is currently still in experimental support. The prometheus metrics already replaced `/` with `_`
  and they will do the same with `_`.
  

### 💡 Enhancements 💡

- `mdatagen`: Adds unsupported platforms to the README header (#9794)
- `confmap`: Clarify the use of embedded structs to make unmarshaling composable (#7101)
- `nopexporter`: Promote the nopexporter to beta (#7316)
- `nopreceiver`: Promote the nopreceiver to beta (#7316)
- `otlpexporter`: Checks for port in the config validation for the otlpexporter (#9505)
- `service`: Validate pipeline type against component types (#8007)

### 🧰 Bug fixes 🧰

- `configtls`: Fix issue where `IncludeSystemCACertsPool` was not consistently used between `ServerConfig` and `ClientConfig`. (#9835)
- `component`: Fix issue where the `components` command wasn't properly printing the component type. (#9856)
- `otelcol`: Fix issue where the `validate` command wasn't properly printing valid component type. (#9866)
- `receiver/otlp`: Fix bug where the otlp receiver did not properly respond with a retryable error code when possible for http (#9357)

## v1.4.0/v0.97.0

### 🛑 Breaking changes 🛑

- `telemetry`: Remove telemetry.useOtelForInternalMetrics stable feature gate (#9752)

### 🚀 New components 🚀

- `exporter/nop`: Add the `nopexporter` to serve as a placeholder exporter in a pipeline (#7316)
  This is primarily useful for starting the Collector with only extensions enabled
  or to test Collector pipeline throughput.
  
- `receiver/nop`: Add the `nopreceiver` to serve as a placeholder receiver in a pipeline (#7316)
  This is primarily useful for starting the Collector with only extensions enabled.

### 💡 Enhancements 💡

- `configtls`: Validates TLS min_version and max_version (#9475)
  Introduces `Validate()` method in TLSSetting.
- `configcompression`: Mark module as Stable. (#9571)
- `cmd/mdatagen`: Use go package name for the scope name by default and add an option to provide the scope name in metadata.yaml. (#9693)
- `cmd/mdatagen`: Generate the lifecycle tests for components by default. (#9683)
  It's encouraged to have lifecycle tests for all components enadled, but they can be disabled if needed 
  in metadata.yaml with `skip_lifecycle: true` and `skip_shutdown: true` under `tests` section.
  
- `cmd/mdatagen`: optimize the mdatagen for the case like batchprocessor which use a common struct to implement consumer.Traces, consumer.Metrics, consumer.Logs in the meantime. (#9688)

### 🧰 Bug fixes 🧰

- `exporterhelper`: Fix persistent queue size backup on reads. (#9740)
- `processor/batch`: Prevent starting unnecessary goroutines. (#9739)
- `otlphttpexporter`: prevent error on empty response body when content type is application/json (#9666)
- `confmap`: confmap honors `Unmarshal` methods on config embedded structs. (#6671)
- `otelcol`: Respect telemetry configuration when running as a Windows service (#5300)

## v1.3.0/v0.96.0

### 🛑 Breaking changes 🛑

- `configgrpc`: Remove deprecated `GRPCClientSettings`, `GRPCServerSettings`, and `ServerConfig.ToListenerContext`. (#9616)
- `confighttp`: Remove deprecated `HTTPClientSettings`, `NewDefaultHTTPClientSettings`, and `CORSSettings`. (#9625)
- `confignet`: Removes deprecated `NetAddr` and `TCPAddr` (#9614)

### 💡 Enhancements 💡

- `configtls`: Add `include_system_ca_certs_pool` to configtls, allowing to load system certs and additional custom certs. (#7774)
- `otelcol`: Add `ConfigProviderSettings` to `CollectorSettings` (#4759)
  This allows passing a custom list of `confmap.Provider`s to `otelcol.NewCommand`.
- `pdata`: Update to OTLP v1.1.0 (#9587)
  Introduces Span and SpanLink flags.
- `confmap`: Update mapstructure to use a maintained fork, github.com/go-viper/mapstructure/v2. (#9634)
  See https://github.com/mitchellh/mapstructure/issues/349 for context.
  

### 🧰 Bug fixes 🧰

- `configretry`: Allow max_elapsed_time to be set to 0 for indefinite retries (#9641)
- `client`: Make `Metadata.Get` thread safe (#9595)

## v1.2.0/v0.95.0

### 🛑 Breaking changes 🛑

- `all`: scope name for all generated Meter/Tracer funcs now includes full package name (#9494)

### 💡 Enhancements 💡

- `confighttp`: Adds support for Snappy decompression of HTTP requests. (#7632)
- `configretry`: Validate `max_elapsed_time`, ensure it is larger than `max_interval` and `initial_interval` respectively. (#9489)
- `configopaque`: Mark module as stable (#9167)
- `otlphttpexporter`: Add support for json content encoding when exporting telemetry (#6945)
- `confmap/converter/expandconverter, confmap/provider/envprovider, confmap/provider/fileprovider, confmap/provider/httprovider, confmap/provider/httpsprovider, confmap/provider/yamlprovider`: Split confmap.Converter and confmap.Provider implementation packages out of confmap. (#4759, #9460)

## v1.1.0/v0.94.0

### 🛑 Breaking changes 🛑

- `receiver/otlp`: Update gRPC code from `codes.InvalidArgument` to `codes.Internal` when a permanent error doesn't contain a gRPC status (#9415)

### 🚩 Deprecations 🚩

- `configgrpc`: Deprecate GRPCClientSettings, use ClientConfig instead (#6767)

### 💡 Enhancements 💡

- `mdatagen`: Add a generated test that checks the config struct using `componenttest.CheckConfigStruct` (#9438)
- `component`: Add `component.UseLocalHostAsDefaultHost` feature gate that changes default endpoints from 0.0.0.0 to localhost (#8510)
  The only component in this repository affected by this is the OTLP receiver.
  
- `confighttp`: Add support of Host header (#9395)
- `mdatagen`: Remove use of ReportFatalError in generated tests (#9439)

### 🧰 Bug fixes 🧰

- `service`: fix opencensus bridge configuration in periodic readers (#9361)
- `otlpreceiver`: Fix goroutine leak when GRPC server is started but HTTP server is unsuccessful (#9165)
- `otlpexporter`: PartialSuccess is treated as success, logged as warning. (#9243)

## v0.93.0

### 🛑 Breaking changes 🛑

- `exporterhelper`: remove deprecated exporterhelper.RetrySettings and exporterhelper.NewDefaultRetrySettings (#9256)
- `configopaque`: configopaque.String implements `fmt.Stringer` and `fmt.GoStringer`, outputting [REDACTED] when formatted with the %s, %q or %#v verbs` (#9213)
  This may break applications that rely on the previous behavior of opaque strings with `fmt.Sprintf` to e.g. build URLs or headers.
  Explicitly cast the opaque string to a string before using it in `fmt.Sprintf` to restore the previous behavior.
  

### 🚀 New components 🚀

- `extension/memory_limiter`: Introduce a `memory_limiter` extension which receivers can use to reject incoming requests when collector doesn't have enough memory (#8632)
  The extension has the same configuration interface and behavior as the existing `memory_limiter` processor, which potentially can be deprecated and removed in the future

### 💡 Enhancements 💡

- `configtls`: add `cipher_suites` to configtls. (#8105)
  Users can specify a list of cipher suites to pick from. If left blank, a safe default list is used.
  
- `service`: mark `telemetry.useOtelForInternalMetrics` as stable (#816)
- `exporters`: Cleanup log messages for export failures (#9219)
  1. Ensure an error message is logged every time and only once when data is dropped/rejected due to export failure.
  2. Update the wording. Specifically, don't use "dropped" term when an error is reported back to the pipeline.
     Keep the "dropped" wording for failures happened after the enabled queue.
  3. Properly report any error reported by a queue. For example, a persistent storage error must be reported as a storage error, not as "queue overflow".
  

### 🧰 Bug fixes 🧰

- `configgrpc`: Update dependency to address a potential crash in the grpc instrumentation (#9296)
- `otlpreceiver`: Ensure OTLP receiver handles consume errors correctly (#4335)
  Make sure OTLP receiver returns correct status code and follows the receiver contract (gRPC)
- `zpagesextension`: Remove mention of rpcz page from zpages extension (#9328)

## v1.0.1/v0.92.0

### 🛑 Breaking changes 🛑

- `exporters/sending_queue`: Do not re-enqueue failed batches, rely on the retry_on_failure strategy instead. (#8382)
  The current re-enqueuing behavior is not obvious and cannot be configured. It takes place only for persistent queue
  and only if `retry_on_failure::enabled=true` even if `retry_on_failure` is a setting for a different backoff retry
  strategy. This change removes the re-enqueuing behavior. Consider increasing `retry_on_failure::max_elapsed_time` 
  to reduce chances of data loss or set it to 0 to keep retrying until requests succeed.
  
- `confmap`: Make the option `WithErrorUnused` enabled by default when unmarshaling configuration (#7102)
  The option `WithErrorUnused` is now enabled by default, and a new option `WithIgnoreUnused` is introduced to ignore
  errors about unused fields.
  
- `status`: Deprecate `ReportComponentStatus` in favor of `ReportStatus`. This new function does not return an error. (#9148)

### 🚩 Deprecations 🚩

- `connectortest`: Deprecate connectortest.New[Metrics|Logs|Traces]Router in favour of connector.New[Metrics|Logs|Traces]Router (#9095)
- `exporterhelper`: Deprecate exporterhelper.RetrySettings in favor of configretry.BackOffConfig (#9091)
- `extension/ballast`: Deprecate `memory_ballast` extension. (#8343)
  Use `GOMEMLIMIT` environment variable instead.
  
- `connector`: Deprecate [Metrics|Logs|Traces]Router in favour of [Metrics|Logs|Traces]RouterAndConsumer (#9095)

### 💡 Enhancements 💡

- `exporterhelper`: Add RetrySettings validation function (#9089)
  Validate that time.Duration, multiplier values in configretry are non-negative, and randomization_factor is between 0 and 1
  
- `service`: Enable `telemetry.useOtelForInternalMetrics` by updating the flag to beta (#7454)
  The metrics generated should be consistent with the metrics generated
  previously with OpenCensus. Users can disable the behaviour
  by setting `--feature-gates -telemetry.useOtelForInternalMetrics` at
  collector start.
  
- `mdatagen`: move component from contrib to core (#9172)
- `semconv`: Generated Semantic conventions 1.22.0. (#8686)
- `confignet`: Add `dialer_timeout` config option. (#9066)
- `processor/memory_limiter`: Update config validation errors (#9059)
  - Fix names of the config fields that are validated in the error messages
  - Move the validation from start to the initialization phrase 
  
- `exporterhelper`: Add config Validate for TimeoutSettings (#9104)

### 🧰 Bug fixes 🧰

- `memorylimiterprocessor`: Fixed leaking goroutines from memorylimiterprocessor (#9099)
- `cmd/otelcorecol`: Fix the code detecting if the collector is running as a service on Windows. (#7350)
  Removed the `NO_WINDOWS_SERVICE` environment variable given it is not needed anymore.
- `otlpexporter`: remove dependency of otlphttpreceiver on otlpexporter (#6454)

## v0.91.0

### 💡 Enhancements 💡

- `statusreporting`: Automates status reporting upon the completion of component.Start(). (#7682)
- `service`: add resource attributes as labels to otel metrics to ensures backwards compatibility with OpenCensus metrics. (#9029)
- `semconv`: Generated Semantic conventions 1.21. (#9056)
- `config/confighttp`: Exposes http/2 transport settings to enable health check and workaround golang http/2 issue https://github.com/golang/go/issues/59690 (#9022)
- `cmd/builder`: running builder version on binaries installed with `go install` will output the version specified at the suffix. (#8770)

### 🧰 Bug fixes 🧰

- `exporterhelper`: fix missed metric aggregations (#9048)
  This ensures that context cancellation in the exporter doesn't interfere with metric aggregation. The OTel
  SDK currently returns if there's an error in the context used in `Add`. This means that if there's a
  cancelled context in an export, the metrics are now recorded.
  
- `service`: Fix bug where MutatesData would not correctly propagate through connectors. (#9053)

## v0.90.1

### 🧰 Bug fixes 🧰

- `exporterhelper`: Remove noisy log (#9017)

## v1.0.0/v0.90.0

### 🛑 Breaking changes 🛑

- `service`: To remain backwards compatible w/ the metrics generated today, otel generated metrics will be generated without the `_total` suffix (#7454)
- `service`: use WithNamespace instead of WrapRegistererWithPrefix (#8988)
  Using this functionality in the otel prom exporter fixes a bug where the
  target_info was prefixed as otelcol_target_info previously.
  

### 💡 Enhancements 💡

- `exporter/debug`: Change default `verbosity` from `normal` to `basic` (#8844)
  This change has currently no effect, as `basic` and `normal` verbosity share the same behavior. This might change in the future though, with the `normal` verbosity being more verbose than it currently is (see https://github.com/open-telemetry/opentelemetry-collector/issues/7806). This is why we are changing the default to `basic`, which is expected to stay at the current level of verbosity (one line per batch).
- `exporterhelper`: Fix shutdown logic in persistent queue to not require consumers to be closed first (#8899)
- `confighttp`: Support proxy configuration field in all exporters that support confighttp (#5761)

### 🧰 Bug fixes 🧰

- `exporterhelper`: Fix invalid write index updates in the persistent queue (#8115)

## v1.0.0-rcv0018/v0.89.0

### 💡 Enhancements 💡

- `builder`: remove replace statement in builder template (#8763)
- `service/extensions`: Allow extensions to declare dependencies on other extensions and guarantee start/stop/notification order accordingly. (#8732)
- `exporterhelper`: Log export errors when retry is not used by the component. (#8791)
- `cmd/builder`: Add --verbose flag to log `go` subcommands output that are ran as part of a build (#8715)
- `exporterhelper`: Remove internal goroutine loop for persistent queue (#8868)
- `exporterhelper`: Simplify usage of storage client, avoid unnecessary allocations (#8830)
- `exporterhelper`: Simplify logic in boundedMemoryQueue, use channels len/cap (#8829)

### 🧰 Bug fixes 🧰

- `exporterhelper`: fix bug with queue size and capacity metrics (#8682)
- `obsreporttest`: split handler for otel vs oc test path in TestTelemetry (#8758)
- `builder`: Fix featuregate late initialization (#4967)
- `service`: Fix connector logger zap kind key (#8878)

## v1.0.0-rcv0017/v0.88.0

### 💡 Enhancements 💡

- `fanoutconsumer`: Enable runtime assertions to catch incorrect pdata mutations in the components claiming as non-mutating pdata. (#6794)
  This change enables the runtime assertions to catch unintentional pdata mutations in components that are claimed
  as non-mutating pdata. Without these assertions, runtime errors may still occur, but thrown by unrelated components, 
  making it very difficult to troubleshoot.
  

### 🧰 Bug fixes 🧰

- `exporterhelper`: make enqueue failures available for otel metrics (#8673)
- `exporterhelper`: Fix nil pointer dereference when stopping persistent queue after a start encountered an error (#8718)
- `cmd/builder`: Fix ocb ignoring `otelcol_version` when set to v0.86.0 or later (#8692)

## v1.0.0-rcv0016/v0.87.0

### 💡 Enhancements 💡

- `service/telemetry exporter/exporterhelper`: Enable sampling logging by default and apply it to all components. (#8134)
  The sampled logger configuration can be disabled easily by setting the `service::telemetry::logs::sampling::enabled` to `false`.
- `core`: Adds the ability for components to report status and for extensions to subscribe to status events by implementing an optional StatusWatcher interface. (#7682)

### 🧰 Bug fixes 🧰

- `telemetry`: remove workaround to ignore errors when an instrument includes a `/` (#8346)

## v1.0.0-rcv0015/v0.86.0

### 🚩 Deprecations 🚩

- `loggingexporter`: Mark the logging exporter as deprecated, in favour of debug exporter (#7769)

### 🚀 New components 🚀

- `debugexporter`: Add debug exporter, which replaces the logging exporter (#7769)

### 💡 Enhancements 💡

- `featuregate`: List valid feature gates when failing to load invalid gate (#8505)
- `supported platforms`: Add `linux/s390x` architecture to cross build tests in CI (#8213)

### 🧰 Bug fixes 🧰

- `builder`: fix setting `dist.*` keys from env (#8239)
- `configtls`: fix incorrect use of fsnotify (#8438)

## v0.85.0

### 💡 Enhancements 💡

- `components command`: The "components" command now lists the component's stability levels. (#8289)
  Note that the format of this output is NOT stable and can change between versions.
- `confighttp`: Add option to disable HTTP keep-alives (#8260)

### 🧰 Bug fixes 🧰

- `confmap`: fix bugs of unmarshalling slice values (#4001)
- `exporterhelper`: Stop logging error messages suggesting user to enable `retry_on_failure` or `sending_queue` when they are not available. (#8369)

## v0.84.0

### 💡 Enhancements 💡

- `loggingexporter`: Adds exemplars logging to the logging exporter when `detailed` verbosity level is set. (#7912)
- `configgrpc`: Allow any registered gRPC load balancer name to be used. (#8262)
- `service`: add OTLP export for internal traces (#8106)
- `configgrpc`: Add support for :authority pseudo-header in grpc client (#8228)

### 🧰 Bug fixes 🧰

- `otlphttpexporter`: Fix the handling of the HTTP response to ignore responses not encoded as protobuf (#8263)

## v0.83.0

### 💡 Enhancements 💡

- `extension`: Add optional `ConfigWatcher` interface (#6596)
  Extensions implementing this interface will be notified of the Collector's effective config.
- `otelcol`: Add optional `ConfmapProvider` interface for Config Providers (#6596)
  This allows providing the Collector's configuration as a marshaled confmap.Conf object
  from a ConfigProvider
  
- `service`: Add `CollectorConf` field to `service.Settings` (#6596)
  This field is intended to be used by the Collector to pass its effective configuration to the service.
  

## v1.0.0-rcv0014/v0.82.0

### 🛑 Breaking changes 🛑

- `service`: Enable configuration of collector telemetry through prometheus reader (#7641)
  These options are still experimental. To enable them, users must enable both
  `telemetry.useOtelForInternalMetrics` and `telemetry.useOtelWithSDKConfigurationForInternalTelemetry`
  feature gates. This change updates `metric_readers` to `readers` to align with the configuration
  working group.
  
- `service`: Remove experimental `metric_readers.args` and `metric_reader.type` config options. (#7641)
  These options were experimental and did not have any effect on the configuration of
  the collector's telemetry. The change aligns the configuration with the latest iteration
  of the configuration json schema, which may still change in the future.

### 💡 Enhancements 💡

- `service`: Add support for exporting internal metrics to the console (#7641)
  Internal collector metrics can now be exported to the console
  using the otel-go stdout exporter.
  
- `service`: Add support for `interval` and `timeout` configuration in periodic reader (#7641)
- `service`: Add support for span processor configuration for internal traces (#8106)
  These options are still experimental. To enable them, users must enable both
  `telemetry.useOtelForInternalMetrics` and `telemetry.useOtelWithSDKConfigurationForInternalTelemetry`
  feature gates.
  
- `service`: Add support for OTLP export for internal metrics (#7641)
  Internal collector metrics can now be exported via OTLP
  using the otel-go otlpgrpc and otlphttp exporters.
  
- `scraperhelper`: Adding optional timeout field to scrapers (#7951)
- `otlpreceiver`: Add http url paths per signal config options to otlpreceiver (#7511)
- `otlphttpexporter`: Add support for trailing slash in endpoint URL (#8084)
  URLs like `http://localhost:4318/` will now be treated as if they were `http://localhost:4318`

### 🧰 Bug fixes 🧰

- `connector`: Fix connector validation (#7892)
  Validation of connectors was too aggressive such that a connector that was used in any combination of unsupported roles would fail.
  Instead, validation should pass as long as each use of the connector has a supported corresponding use.
  

## v0.81.0

### 🛑 Breaking changes 🛑

- `service`: Remove 'service.connectors' featuregate (#7952)

### 💡 Enhancements 💡

- `HTTPServerSettings`: Add zstd support to HTTPServerSettings (#7927)
  This adds ability to decompress zstd-compressed HTTP requests to| all receivers that use HTTPServerSettings.
- `cmd/builder`: Add "--skip-generate" option to make builder skip source generation (#7541)
- `confighttp`: Add support for additional content decoders via `WithDecoder` server option (#7977)
- `connectortest`: Add helpers to aid the construction of `connector.TracesRouter`, `connector.MetricsRouter`, and `connector.LogsRouter` instances to `connectortest`. (#7672)
- `confighttp`: Add `response_headers` configuration option on HTTPServerSettings. It allows for additional headers to be attached to each HTTP response sent to the client (#7328)
- `otlpreceiver, otlphttpexporter, otlpexporter, configgrpc`: Upgrade github.com/mostynb/go-grpc-compression and switch to nonclobbering imports (#7920)
  consumers of this library should not have their grpc codecs overridden
- `otlphttpexporter`: Treat partial success responses as errors (#6686)

### 🧰 Bug fixes 🧰

- `HTTPServerSettings`: Ensure requests with unsupported Content-Encoding return HTTP 400 Bad Request (#7927)

## v1.0.0-rcv0013/v0.80.0

### 🚩 Deprecations 🚩

- `service`: Deprecate service.PipelineConfig in favor of pipelines.Config. (#7854)

### 💡 Enhancements 💡

- `service`: Added dry run flag to validate config file without running collector. (#4671)
- `configtls`: Allow TLS Settings to be provided in memory in addition to filepath. (#7313)
- `connector`: Updates the way connector nodes are built to always pass a fanoutconsumer to their factory functions. (#7672, #7673)
- `otlp`: update otlp protos to v0.20.0 (#7839)
- `configauth`: Split config/configauth into its own module (#7895)
- `configgrpc, confighttp, config/internal`: Split confighttp, configgrpc, and config/internal into separate modules (#7895)
- `confignet`: Split config/confignet into its own module (#7895)
- `configopaque`: Split config/configopaque into its own module (#7895)
- `configtelemetry`: Split config/configtelemetry into its own module (#7895)
- `configtls`: Split config/configtls into its own module (#7895)
- `configcompression`: Split config/configcompression into its own module (#7895)
- `extension`: Splitting `extension/auth` into separate module (#7054)
- `connector`: Split connector into its own module (#7895)
- `extension`: split extension module into its own module (#7306)
- `processor`: Split the processor into its own go module (#7307)
- `confighttp`: Avoid re-creating the compressors for every request. (#7859)
- `otlpexporter`: Treat partial success responses as errors (#6686)
- `service/pipelines`: Add pipelines.Config to remove duplicate of the pipelines configuration (#7854)

## v0.79.0

### 🚩 Deprecations 🚩

- `component`: Deprecate Host.GetExporters function (#7370)

### 💡 Enhancements 💡

- `otelcol`: Add connectors to output of the `components` command (#7809)
- `scraperhelper`: Will start calling scrapers on component start. (#7635)
  The change allows scrapes to perform their initial scrape on component start
  and provide an initial delay. This means that scrapes will be delayed by `initial_delay`
  before first scrape and then run on `collection_interval` for each consecutive interval. 
  
- `batchprocessor`: Change multiBatcher to use sync.Map, avoid global lock on fast path (#7714)

### 🧰 Bug fixes 🧰

- `connectors`: When replicating data to connectors, consider whether the next pipeline will mutate data (#7776)

## v0.78.2

### 🧰 Bug fixes 🧰

- `batchprocessor`: Fix return error for batch processor when consuming Metrics and Logs (#7711)

## v0.78.1

### 🧰 Bug fixes 🧰

- `batchprocessor`: Fix start/stop logic for batch processor (#7708)

## v1.0.0-rcv0012/v0.78.0

### 💡 Enhancements 💡

- `batchprocessor`: Add support for batching by metadata keys. (#4544)
- `service`: Add feature gate `telemetry.useOtelWithSDKConfigurationForInternalTelemetry` that will add support for configuring the export of internal telemetry to additional destinations in future releases (#7641)
- `forwardconnector`: Promote to beta (#7579)
- `featuregate`: Promote `featuregate` to the stable module-set (#7693)

### 🧰 Bug fixes 🧰

- `featuregate`: Fix issue where `StageDeprecated` was not usable (#7586)
- `exporterhelper`: Fix persistent storage behaviour with no available space on device (#7198)

## v0.77.0

### 🛑 Breaking changes 🛑

- `exporterhelper`: Reduce the default queue size to 1000 from 5000 (#7359)
  Affects any exporter which enables the queue by default and doesn't set its own default size.
  For example: otlphttp.
  
- `featuregate`: Remove deprecated `RemovalVersion` and `WithRegisterRemovalVersion` functions. (#7587)

### 💡 Enhancements 💡

- `service`: Adds ResourceAttributes map to telemetry settings and thus CreateSettings. (#6599)
- `service`: Allows users to disable high cardinality OTLP attributes behind a feature flag. (#7517)
- `featuregate`: Finalize purpose of `toVersion`.  Allow stable gates to be explicitly set to true, but produce a warning log. (#7626)

### 🧰 Bug fixes 🧰

- `config/confighttp`: Ensure Auth RoundTripper follows compression/header changes (#7574)
- `otlpreceiver`: do not reject requests having 'content-type' header with optional parameters (#7452)

## v1.0.0-rcv0011/v0.76.1

### 🛑 Breaking changes 🛑

- `confmap`: Using an Invalid Scheme in a URI will throw an error. (#7504)

### 🚩 Deprecations 🚩

- `featuregate`: Deprecate Gate.RemovalVersion and WithRegisterRemovalVersion in favor of ToVersion. (#7043)

### 💡 Enhancements 💡

- `batchprocessor`: Support zero timeout. (#7508)
  This allows the batchprocessor to limit request sizes without introducing delay in a pipeline, to act only as a splitter.
- `service`: use the otel opencensus bridge when telemetry.useOtelForInternalMetrics is enabled (#7483)
- `connector`: Mark 'service.connectors' featuregate as stable (#2336)
- `featuregate`: Add a new Deprecated stage for feature gates, when features are abandoned. (#7043)
- `loggingexporter`: Show more counters in not detailed verbosity (#7461)
  The logging exporter now shows more counters when the verbosity is not detailed. The following numbers are added:
  - Number of resource logs
  - Number of resource spans
  - Number of resource metrics
  - Number of data points
  
- `configtls`: Reload mTLS ClientCA certificates on file change (#6524)
- `confmap`: Add support for nested URIs. (#7117)
- `featuregate`: Add concept of gate lifetime, [fromVersion, toVersion]. (#7043)

### 🧰 Bug fixes 🧰

- `obsreport`: fix issue where send_failed_requests counter was reporting an incorrect value. (#7456)

## v1.0.0-rc9/v0.75.0

### 🛑 Breaking changes 🛑

- `featuregate`: Remove deprecated featuregate.FlagValue (#7401)

### 💡 Enhancements 💡

- `provider`: Added userfriendly error on incorrect type. (#7399)

### 🧰 Bug fixes 🧰

- `loggingexporter`: Fix display of bucket boundaries of exponential histograms to correctly reflect inclusive/exclusive bounds. (#7445)
- `exporterhelper`: Fix a deadlock in persistent queue initialization (#7400)

## v1.0.0-rc8/v0.74.0

### 🛑 Breaking changes 🛑

- `consumererror`: Remove deprecated funcs in consumererror (#7357)

### 🚩 Deprecations 🚩

- `featuregate`: Deprecate `FlagValue` in favor of `NewFlag`. (#7042)

### 💡 Enhancements 💡

- `service`: Enable connectors by default by moving service.connectors featuregate to beta (#7369)

## v0.73.0/v1.0.0-rc7

### 🛑 Breaking changes 🛑

- `consumererror`: Remove `Get` prefix from methods returning failed signal data (#7048)
- `service`: Feature gate `service.graph` is now stable and cannot be disabled. It will be removed in the next version. (#2336)

### 💡 Enhancements 💡

- `exporter`: split exporter into its own module (#7239)
- `receiver`: split receiver into its own module (#7174)
- `connectors`: Provide connectors with a mechanism to route data to specific pipelines (#7152)
- `confmap`: Mark `confmap.expandEnabled` as stable (#7323)

## v1.0.0-rc6/v0.72.0

### 🛑 Breaking changes 🛑

- `all`: Remove go 1.18 support, bump minimum to go 1.19 and add testing for 1.20 (#7151)
- `pdata`: Remove deprecated `[Metrics|Traces|Logs]MoveTo` methods. (#7165)
- `featuregate`: Remove deprecated funcs in featuregate. (#7173)

### 💡 Enhancements 💡

- `semconv`: Generated Semantic conventions 1.17 that now contains the `event` type. (#7170)
- `semconv`: Generated Semantic conventions 1.18. (#7168)

### 🧰 Bug fixes 🧰

- `memorylimiterprocessor`: Fix incorrect parsing of cgroups when running Collector with host mount (#6826)
- `confmap`: Clear list of old already closed closers. (#7215)

## v1.0.0-rc5/v0.71.0

### 🛑 Breaking changes 🛑

- `pdata`: Add private method to GrpcServer interface, disallow direct implementation (#6966)
- `featuregate`: Remove deprecated GetRegistry (#7011)
- `pcommon`: Remove deprecated Map.Sort (#6688)

### 🚩 Deprecations 🚩

- `featuregate`: Deprecate Registry.List in favor of Registry.VisitAll. (#7041)
- `featuregate`: Deprecate Apply in favor of Set (#7018)
- `pdata`: Deprecate [Metrics|Logs|Traces].MoveTo methods. (#7091)
- `featuregate`: Deprecate RegistryOption in favor of RegisterOption (#7012)
- `featuregate`: Deprecate featuregate.Registry.[IsEnabled, RegisterID, MustRegister] (#6998)

### 🚀 New components 🚀

- `httpsprovider`: Add the httpsprovider. This component allows the collector to fetch configurations from web servers using the HTTPS protocol. (#6683)

### 💡 Enhancements 💡

- `exporter`: Allow configuration of fields, `RandomizationFactor` and `Multiplier`, for exponential backoff algorithm when retry on failure is enabled (#6610)
- `connectors`: Add "connectors", a new type of pipeline component (#2336)
  - Connectors connect pipelines by acting as an exporter in one or more pipelines and simultaneously
  as a receiver of corresponding data in one or more other pipelines. For example:
    - The `forward` connector can export data to another pipeline of the same type. This allows you
    to merge data from multiple pipelines onto a common pipeline. Or, you can replicate data onto multiple
    pipelines so that it may be processed in different ways and/or exported to different backends.
    - The `count` connector can count data of any type. Regardless of the type of data that is counted, it
    emits counts as metrics onto a metrics pipeline.
  - Connectors are currently disabled by default but can be enabled with the `service.connectors` feature gate.
  - See the [connectors README](https://github.com/open-telemetry/opentelemetry-collector/blob/main/connector/README.md)
  for more details on how to use connectors.
  
- `service`: Enable new pipelines implementation using graphs. Controlled by the `service.graph` featuregate. (#2336)
- `builder`: added ldflags command option (#6940)
- `proctelemetry`: Instrument `proctelemetry.ProcessMetrics` metrics with otel-go (#6886)
- `capabilityconsumer`: If the consumer has already the desired capability, don't wrap (#7116)
- `confmap`: Add support to resolve embedded uris inside a string, concatenate results. (#6932)

### 🧰 Bug fixes 🧰

- `confmap`: Fix bug in confmap validation that allowed the usage of case-insensitive keys in the configurations, despite them failing silently. (#6876)
- `logging`: Fix the attribute key used to identify the receiver data type in logging configuration (#7033)

## v1.0.0-RC4/v0.70.0

### 🛑 Breaking changes 🛑

- `pdata`: Start enforcing grpc server implementation to embed UnimplementedGRPCServer, dissallow client implementation (#6966)
- `config/configgrpc`: Change configgrpc.GRPCClientSettings.Headers type to map[string]configopaque.String (#6852)
  Use `configopaque.String(str)` and `string(opaque)` to turn a string opaque/clear.
- `pdata`: Remove deprecated pcommon.Value.Equal (#6860)

### 🚩 Deprecations 🚩

- `pdata`: Deprecate pcommon.Map.Sort(). (#6688)
- `featuregate`: Deprecate GetRegistry in favor of GlobalRegistry (#6979)

### 💡 Enhancements 💡

- `builder`: Add remote debug option for otel-collector to builder (#6149)
- `connector`: Add Builder (#6867)
- `cmd/builder`: Add support for connector configurations (#6789)
- `exporter/otlphttp`: Retry only on status code 429/502/503/504 (#6845)
- `featuregate`: Reduce contention in featuregate by using sync.Map instead of mutex. (#6980)

### 🧰 Bug fixes 🧰

- `loggingexporter`: Fix undefined symbol errors on building otelcorecol for other platforms than darwin, linux, windows. (#6924)
- `otlpexporter`: Fix a dataloss bug in persistent storage when collector shuts down or restarts (#6771)

## v0.69.1

### 🧰 Bug fixes 🧰

- `various modules`: Fix issue where some collector modules imported previous version of other modules (#6929)

## v1.0.0-RC3/v0.69.0

### 🛑 Breaking changes 🛑

- `component`: Remove deprecated Exporter types (#6880)
- `component`: Remove deprecated Extension types (#6865)
- `component`: Remove deprecated ProcessorFactoryOptions (#6881)
- `component`: Remove deprecated Receiver types (#6882)
- `componenttest`: Remove deprecated funcs from componenttest (#6836)
- `batchprocessor`: Remove deprecated batchprocessor.MetricViews and batchprocessor.OtelMetricViews (#6861)
- `component`: Remove deprecated component.[Factories|MakePorcessorFactoryMap] and componenttest.NewNopFactories (#6835)
- `config`: Remove deprecated cofig.*Settings (#6837)
- `obsereporttest`: Remove deprecated obsereporttest.SetupTelemetryWithID (#6861)
- `component`: Remove deprecated component [Traces|Metrics|Logs]Processor and ProcessorFactory (#6884)
- `service`: Remove deprecated service service.ConfigService and service.ConfigServicePipeline (#6859)

### 💡 Enhancements 💡

- `connector`: Add MakeFactoryMap (#6889)
- `semconv`: Add semantic conventions for specification v1.16.0 (#6714)

### 🧰 Bug fixes 🧰

- `config`: use [REDACTED] when marshaling to text a configopaque.String, instead of disclosing secret length. (#6868)

## v1.0.0-RC2/v0.68.0

### 🛑 Breaking changes 🛑

- `componenttest`: Move NopFactories to otelcoltest (#6792)
- `config/confighttp`: Change confighttp.HTTPClientSettings.Headers type to map[string]configopaque.String (#5653)
- `config`: Remove deprecated `component.Config.[ID|SetIDName]`. (#4714)
- `configauth`: Remove deprecated funcs/types from `configauth` (#6719)
- `component`: Remove deprecated funcs/types from component package (#6769)
  - `component.[Exporter|Processor|Receiver|Extension]Config`
  - `component.Unmarshal[Exporter|Processor|Receiver|Extension]Config`
  - `component.[Exporter|Processor|Receiver|Extension]CreateDefaultConfigFunc`
  - `component.[Exporter|Receiver|Extension]FactoryOption`
  - `component.New[Exporter|Receiver|Extension]Factory`
  - `component.With[Traces|Metrics|Logs][Exporter|Receiver]`
  - `component.Create[Traces|Metrics|Logs][Exporter|Receiver]Func`
  - `component.CreateExtensionFunc`
- `componenttest`: Remove deprecated componenttest.NewNop*CreateSettings (#6761)
- `service`: Remove deprecated `service.[Collector|New|CollectorSettings|ConfigProvider]` (#5564)
- `service`: Remove deprecated funcs `service.NewCommand` and `service.NewSvcHandler`. (#5564)
- `obsreporttest`: Remove deprecate obsreporttest.Check* (#6720)
- `service`: Remove deprecated `service.Config`. (#6774)
- `servicetest`: Remove deprecated `servicetest` package. (#5564)

### 🚩 Deprecations 🚩

- `service`: Deprecate `service.ConfigService` in favor of `service.Config` and `service.ConfigServicePipeline` in favor of `service.PipelineConfig`. (#6787)
- `pdata`: Deprecate `pcommon.Value.Equal` method (#6811)
- `component`: Deprecate `Processor` related structs and functions in favor of `processor` package (#6709)
- `component`: Deprecate component.Factories in favor of otelcol.Factories (#6723)
- `config`: Deprecate `config.[Extension|Exporter|Connector|Receiver|Processor]Settings`. (#6718)
- `batchprocessor`: Deprecate metric views funcs, for OC and Otel. (#6730)
- `obsreporttest`: Deprecate obsreporttest.SetupTelemetryWithID in favor of obsreporttest.SetupTelemetry (#6720)

### 🚀 New components 🚀

- `forwardconnector`: Add forward connector (#6763)

### 💡 Enhancements 💡

- `components`: Add [receiver|processor|exporter|extension].Builder to help with creating components form a set of configs and factories (#6803)
- `configunmarshaler`: Consolidate package into generic implementation (#6801)
- `service`: Shutdown internal telemetry with the Service (every time config changes). (#5564)

### 🧰 Bug fixes 🧰

- `configgrpc`: Fix todo to add MeterProvider to grpc instrumentation (#4030)
- `otlpreceiver`: Fix otlpreceiver transport metrics attribute (#6695)

## v1.0.0-RC1/v0.67.0

We are excited to announce that the `pdata` module is now available as a
v1.0.0 release candidate.  While breaking changes may still happen in this
module before v1.0.0, we believe it is ready for final assessment and validation
and hope to make a v1.0.0 release soon.

### 🛑 Breaking changes 🛑

- `overwritepropertiesconverter`: Remove deprecated package `overwritepropertiesconverter` (#6656)
- `pdata`: Change [...Slice|Map].Sort methods to not return any value (#6660)
- `featuregate`: remove deprecated functions (#6594)
  - `featuregate.GetID()`
  - `featuregate.GetDescription()`
- `obsreport`: remove deprecated functions. (#6595)
  - `obsreport.MustNewExporter`
  - `obsreport.MustNewProcessor`
  - `obsreport.MustNewReceiver`
  - `obsreport.MustNewScraper`
- `service`: Remove deprecated `service.State` enum values. (#6605)
- `component`: Remove deprecated func/types from component (#6606)
- `config`: Remove deprecated config.Pipelines and config.Pipeline (#6664)
- `ballastextension`: Remove deprecated `ballastextension.MemoryBallast` type (#6628)
- `component`: Remove `Validate()` from component.*Config interfaces and make it optional interface (#6544)
- `confmap`: Splitting confmap into its own module (#6185)
  The import path for the confmap module can now be access directly:
  - `go.opentelemetry.io/collector/confmap`

### 🚩 Deprecations 🚩

- `service`: Deprecate service.[Collector|NewSvcHandler|CollectorSettings|State|NewCommand] in favor of otelcol package" (#6608)
  - Deprecate `service.Config` in favor of `otelcol.Config`.
  - Deprecate `service.ConfigProvider` in favor of `otelcol.ConfigProvider`.
  - Deprecate `service.NewConfigProvider` in favor of `otelcol.NewConfigProvider`.
  - Deprecate `service.CollectorSettings` in favor of `otelcol.CollectorSettings`.
  - Deprecate `service.Collector` in favor of `otelcol.Collector`.
  - Deprecate `service.New` in favor of `otelcol.NewCollector`.
  - Deprecate `service.State` in favor of `otelcol.State`.
  - Deprecate `service.NewSvcHandler` in favor of `otelcol.NewSvcHandler`.
  - Deprecate `service.NewCommand` in favor of `otelcol.NewCommand`.
- `obsreporttest`: Deprecate obsreporttest.Check* in favor of TestTelemetry.Check (#6678)
- `component`: Deprecate Exporter related types/funcs from component package in favor of exporter package. (#6578)
  - `component.ExporterCreateSettings` -> `exporter.CreateSettings`
  - `component.CreateTracesExporterFunc` -> `exporter.CreateTracesFunc`
  - `component.CreateMetricsExporterFunc` -> `exporter.CreateMetricsFunc`
  - `component.CreateLogsExporterFunc` -> `exporter.CreateLogsFunc`
  - `component.ExporterFactory` -> `exporter.Factory`
  - `component.NewExporterFactory` -> `exporter.NewFactory`
  - `component.MakeExporterFactoryMap` -> `exporter.MakeFactoryMap`
  - `componenttest.NewNopExporterCreateSettings` -> `exportertest.NewNopCreateSettings`
  - `componenttest.NewNopExporterFactory` -> `exportertest.NewNopFactory`
- `component`: Change Config to be opaque for otel collector core. (#4714)
  - Deprecate `component.Config.ID()` in favor of `component.[*]CreateSettings.ID`.
  - Deprecate `component.Config.SetIDName()`, no replacement needed since ID in settings is public member.
  - Deprecate `obsreporttest.SetupTelemetry` in favor of `obsreporttest.SetupTelemetryWithID`.

- `component`: Deprecate `component.Unmarshal[*]Config` in favor of `component.UnmarshalConfig` (#6613)
- `component`: Deprecate Extension related types/funcs from component package in favor of extension package. (#6578)
  - `component.Extension` -> `extension.Extension`
  - `component.PipelineWatcher` -> extension.PipelineWatcher
  - `component.ExtensionCreateSettings` -> `extension.CreateSettings`
  - `component.CreateExtensionFunc` -> `extension.CreateFunc`
  - `component.ExtensionFactory` -> `extension.Factory`
  - `component.NewExtensionFactory` -> `extension.NewFactory`
  - `component.MakeExtensionFactoryMap` -> `extension.MakeFactoryMap`
  - `componenttest.NewNopExtensionCreateSettings` -> `extensiontest.NewNopCreateSettings`
  - `componenttest.NewNopExtensionFactory` -> `extensiontest.NewNopFactory`
- `component`: Deprecate `Receiver` related structs and functions in favor of `receiver` package (#6687)
- `component`: Deprecate `component.[Exporter|Extension|Processor|Receiver]Config` in favor of `component.Config` (#6578)
- `pdata`: Remove deprecated funcs `pdata.[Span|Trace]ID.HexString` (#6627)

### 💡 Enhancements 💡

- `config/configopaque`: Add new `configopaque.String` type alias for opaque strings. (#5653)
- `service`: Added components sub command which outputs components in collector distribution. (#4671)
- `component`: Define new component type 'connectors' (#6577)
- `connector`: Add connector factory (#6611)
- `connector`: Add connector types (TracesConnector, MetricsConnector, LogsConnector) (#6689)
- `connectortest`: Add connector/connectortest package (#6711)
- `component`: Add recursive validation check for configs (#4584)
- `service`: Improve config error messages, split Validate functionality (#6665)
- `extension/authextension`: Define new authextension package and use new package in collector repo (#6467)
  - configauth.ClientAuthenticator -> auth.Client
  - configauth.NewClientAuthenticator -> auth.NewClient
  - configauth.ClientOption -> auth.ClientOption
  - configauth.WithClientStart -> auth.WithClientStart
  - configauth.WithClientShutdown -> auth.WithClientShutdown
  - configauth.WithClientRoundTripper -> auth.WithClientRoundTripper
  - configauth.WithPerRPCCredentials -> auth.WithClientPerRPCCredentials
  - configauth.ServerAuthenticator -> auth.Server
  - configauth.NewServerAuthenticator -> auth.NewServer
  - configauth.Option -> auth.ServerOption
  - configauth.AuthenticateFunc -> auth.ServerAuthenticateFunc
  - configauth.WithAuthenticate -> auth.WithServerAuthenticate
  - configauth.WithStart -> auth.WithServerStart
  - configauth.WithShutdown -> auth.WithServerShutdown
- `obsreport`: Instrument `obsreport.Processor` metrics with otel-go (#6607)
- `pdata`: Add ability to clear optional fields (#6474)

### 🧰 Bug fixes 🧰

- `otlpexporter`: Fix nil panic from otlp exporter in case of errors during Start. (#6633)
- `service`: Stop notification for signals before shutdown, increase channel size. (#6522)
- `confmap`: Fix support for concatenating envvars with colon (#6580)
- `otlpexporter`: Fix a bug that exporter persistent queue is sending duplicate data after restarting. (#6692)

## v0.65.0

### 🛑 Breaking changes 🛑

- `featuregate`: Capitalize `featuregate.Stage` string values, remove Stage prefix. (#6490)
- `configtelemetry`: Update values returned by `Level.String` and `Level.MarshalText` method. (#6490)
  - All returned strings are capitalized.
  - "" is returned for integers that are out of Level enum range.
  - It also affects `Level.Marshal` output, but it's not a problem because `Unmarshal` method accepts strings in
  all cases, e.g. "normal", "Normal" and "NORMAL".

- `featuregate`: Make impossible to implement RegistryOption outside `featuregate` package (#6532)
- `service/telemetry`: Remove unit suffixes from metrics exported by the otel-go prometheus exporter. (#6403)
- `obsreport`: `obsreport.New[Receiver|Scraper|Processor|Exporter]` returns error now (#6458)
- `configgrpc`: Remove deprecated funcs in `configgrpc`. (#6529)
  - `configgrpc.GRPCClientSettings.ToDialOptions`
  - `configgrpc.GRPCServerSettings.ToServerOption`

- `config/configtest`: Remove deprecated `configtest` package. (#6542)
- `config`: Remove deprecated types and funcs from config. Use `component` package. (#6511)
  - config.ComponentID
  - config.Type
  - config.DataType
  - config.Receiver
  - config.UnmarshalReceiver
  - config.Processor
  - config.UnmarshalProcessor
  - config.Exporter
  - config.UnmarshalExporter
  - config.Extension
  - config.UnmarshalExtension

- `featuregate`: Remove deprecated funcs and struct members from `featuregate` package (#6523)
  - featuregate.Gate.ID
  - featuregate.Gate.Description
  - featuregate.Gate.Enabled
  - featuregate.Registry.Register
  - featuregate.Registry.MustRegister

- `experimental`: Remove experimental configsource code. (#6558)
- `component`: Update values returned by `StabilityLevel.String` method. (#6490)
  - All returned strings are capitalized.
  - "Undefined" is returned only for `StabilityLevelUndefined`.
  - "" is returned for integers that are out of StabilityLevel enum range.


### 🚩 Deprecations 🚩

- `pdata`: Deprecate `pcommon.[Span|Trace]ID.HexString` methods. Call `hex.EncodeToString` explicitly instead. (#6514)
- `obsreport`: deprecate `obsreport.MustNew[Receiver|Scraper|Processor|Exporter]` in favor of `obsreport.New[Receiver|Scraper|Processor|Exporter]` (#6458)
  - Deprecate `obsreport.MustNewReceiver()` in favor of `obsreport.NewReceiver()`
  - Deprecate `obsreport.MustNewScraper()` in favor of `obsreport.NewScraper()`
  - Deprecate `obsreport.MustNewProcessor()` in favor of `obsreport.NewProcessor()`
  - Deprecate `obsreport.MustNewExporter()` in favor of `obsreport.NewExporter()`

- `component`: Deprecate `component.Receiver`, `component.Processor`, and `component.Exporter`. (#6553)
- `featuregate`: Deprecate Get prefix funcs for `featuregate.Gate` (#6528)
  `featuregate.Gate.GetID` -> `featuregate.Gate.ID`
  `featuregate.Gate.GetDescription` -> `featuregate.Gate.Description`

- `component`: Deprecate `component.Config.Validate` in favor of `component.ValidateConfig` (#6572)
- `component`: Deprecate `StabilityLevelInDevelopment` enum const in favor of `StabilityLevelDevelopment`. (#6561)
  Also rename all mentions of "In development" stability level to "Development".
- `service`: Deprecate `service.[Starting|Running|Closing|Closed]` in favor of `service.State[Starting|Running|Closing|Closed]` (#6492)

### 💡 Enhancements 💡

- `component`: `component.Extension` is temporarily set to be an alias of `component.Component` which will be reverted once it's moved to the `extension` package. Change your `component.Host.GetExtensions()` implementation to return `map[ID]component.Component` instead of `map[ID]component.Extension` (#6553)
- `pdata`: Return error from `pcommon.[Value|Map|Slice].FromRaw` when unsupported type. (#6579)
- `batchprocessor`: instrument the `batch` processor with OpenTelemetry Go SDK (#6423)
- `obsreport`: Instrument `obsreport.Scraper` metrics with otel-go (#6460)
- `service/collector`: Support SIGHUP configuration reloading (#5966)
- `component`: Split component into its own package (#6187)
  The import path for the component module can now be access directly:
    - `go.opentelemetry.io/collector/component`
- `consumer`: Split consumer into its own package (#6186)
  The import path for the consumer module can now be accessed directly:
    - `go.opentelemetry.io/collector/consumer`
- `featuregate`: Split featuregate into its own package (#6526)
  The import path for the featuregate module can now be accessed directly:
    - `go.opentelemetry.io/collector/featuregate`

### 🧰 Bug fixes 🧰

- `service`: Disallow duplicate references to processors within a single pipeline (#6540)

## v0.64.1

### 🧰 Bug fixes 🧰

- `loggingexporter`: Fix logging exporter to not mutate the data (#6420)

## 0.64.0

### 🛑 Breaking changes 🛑

- `config`: Remove already deprecates `config.Service`. (#6395)
- `pdata`: Change output of String() method of the following enum types to more a concise form: (#6251)
  - plog.SeverityNumber
  - ptrace.SpanKind
  - ptrace.StatusCode

- `config`: Remove already deprecates `config.Config`. (#6394)
- `pdata`: Remove deprecated code from pdata (#6417)
  - `p[trace|metric|log]otlp.[Request|Response]`
  - `p[trace|metric|log]otlp.New[Request|Response]`
  - `p[trace|metric|log]otlp.NewRequestFrom[Traces|Metrics|Logs]`
  - `p[trace|metric|log]otlp.NewClient`
  - `p[trace|metric|log]New[JSON|Proto][Marshaler|Unmarshale]`

- `extension`: Splitting ballast/zpages extension into their own modules (#6191)
  The import path for the extension modules can now be accessed directly:
  - `go.opentelemetry.io/collector/extension/ballastextension`
  - `go.opentelemetry.io/collector/extension/zpagesextension`

  If using one of these extensions, modify your Collector builder configuration to use `gomod` directly, such as:
  - `gomod: go.opentelemetry.io/collector/extension/ballastextension v0.64.0`
- `processor`: Splitting batch/memorylimiter processors into their own modules (#6188, #6192, #6193)
  The import path for the processor modules can now be access directly:
  - `go.opentelemetry.io/collector/processor/batchprocessor`
  - `go.opentelemetry.io/collector/processor/memorylimiter`

  If using this processor, modify your Collector builder configuration to use `gomod` directly, such as:
  - `gomod: go.opentelemetry.io/collector/processor/batchprocessor v0.64.0`
- `otlpreceiver`: Splitting otlp receiver into its own module (#6190)
  The import path for the OTLP receiver can now be access directly:
  - `go.opentelemetry.io/collector/receiver/otlpreceiver`

  If using this receiver, modify your Collector builder configuration to use `gomod` directly, such as:
  - `gomod: go.opentelemetry.io/collector/receiver/otlpreceiver v0.64.0`

- `confmap`: Remove unused public member `sync.Mutex` from `confmap.Resolver`. (#6489)
  This is an exception from the deprecation rule since this is not used anywhere and it is very unlikely that is used by external users.

### 🚩 Deprecations 🚩

- `config`: Deprecate multiple types and funcs in `config` package (#6422)
  - config.ComponentID => component.ID
  - config.Type => component.Type
  - config.DataType => component.DataType
  - config.[Traces|Metrics|Logs]DataType => component.DataType[Traces|Metrics|Logs]
  - config.Receiver => component.ReceiverConfig
  - config.UnmarshalReceiver => component.UnmarshalReceiverConfig
  - config.Processor => component.ProcessorConfig
  - config.UnmarshalProcessor => component.UnmarshalProcessorConfig
  - config.Exporter => component.ExporterConfig
  - config.UnmarshalExporter => component.UnmarshalExporterConfig
  - config.Extension => component.ExtensionConfig
  - config.UnmarshalExtension => component.UnmarshalExtensionConfig

- `obsreport`: deprecate `obsreport.New[Receiver|Scraper|Processor|Exporter]` in favor of `obsreport.MustNew[Receiver|Scraper|Processor|Exporter]` (#6458)
- `config/configgrpc`: Provide better helpers for configgrpc, consistent with confighttp (#6441)
  - Deprecate `GRPCClientSettings.ToDialOptions` in favor of `GRPCClientSettings.ToClientConn`.
  - Deprecate `GRPCServerSettings.ToServerOption` in favor of `GRPCServerSettings.ToServer`.

- `featuregates`: Removing Gates being configurable externally to the Registry (#6167)
  - Deprecate `Gate.ID` in favour of `Registry.RegisterID`
  - Deprecate `Gate.Enabled` in favour of `Gate.IsEnabled()`
  - Deprecate `Gate.Description` in favour of `WithRegisterDescription` to be used with `Registry.RegisterID`
  - Deprecate `Registry.Register` in favour of `Registry.RegisterID`
  - Deprecate `Registry.MustRegister` in favour of `Registry.MustRegisterID`


### 💡 Enhancements 💡

- `service/telemetry`: Allow to configure sampling config for logs. (#4554)
- `featuregates`: Extend feature gate definition to include support for issue links and expected deprecated version (#6167)
- `receiver/otlp`: Add warning when using unspecified (`0.0.0.0`) address on HTTP or gRPC servers (#6151)
- `obsreport`: Instrument `obsreport.Exporter` metrics with otel-go (#6346)
- `config`: Add validation for empty address [telemetry::metrics::address] (#5661)

### 🧰 Bug fixes 🧰

- `cgroups`: split line into exactly 3 parts while parsing /proc/{pid}/cgroup (#6389)
- `cgroups`: Use int64 for cgroup v1 parsing (#6443)

## v0.63.1

### 🧰 Bug fixes 🧰

- `service`: Fix running collector as a windows service. (#6433)

## v0.63.0

### 🛑 Breaking changes 🛑

- `pdata`: JSON marshaler emits enums as ints per spec reuqirements. This may be a breaking change if receivers were not confirming with the spec. (#6338)
- `confmap`: Remove deprecated `confmap.Conf.UnmarshalExact` API in 0.62.0 (#6315)
- `pdata`: Remove API deprecated in 0.62.0 (#6314)
  - Remove deprecated `pcommon.NewValueString`
  - Remove deprecated `pcommon.Map.PutString`
  - Remove deprecated `plog.SeverityNumberUndefined`
  - Remove deprecated `p[metric|log|trace]otlp.RegisterServer`
  - Remove deprecated `pmetric.[Default]?MetricDataPointFlags`
  - Remove deprecated `pmetric.MetricAggregationTemporality*`
  - Remove deprecated `pmetric.MetricTypeNone`
  - Remove deprecated `pmetric.NumberDataPointValueTypeNone`
  - Remove deprecated `pmetric.ExemplarValueTypeNone`
  - Remove deprecated `pmetric.[New]?Buckets`
  - Remove deprecated `pmetric.[New]?ValueAtQuantile`
  - Remove deprecated `pmetric.[New]?ValueAtQuantileSlice`
  - Remove deprecated `ptrace.[New]?SpanStatus`

- `exporter`: Splitting otlp, otlphttp and logging exporters into their own modules (#6343)
  The import path for these exporters can now be access directly:
  - `go.opentelemetry.io/collector/exporter/loggingexporter`
  - `go.opentelemetry.io/collector/exporter/otlpexporter`
  - `go.opentelemetry.io/collector/exporter/otlphttpexporter`

  If using these exporters, modify your Collector builder configuration to use `gomod` directly, such as:
  - `gomod: go.opentelemetry.io/collector/exporter/otlpexporter v0.63.0`

### 🚩 Deprecations 🚩

- `overwritepropertiesconverter`: Deprecate `overwritepropertiesconverter`, only used by non builder distributions. (#6294)
- `pdata`: Add `Export` prefix to `p[trace|metric|log]otlp.[Request|Response]` (#6365)
  - Deprecate `p[trace|metric|log]otlp.[Request|Response]` in favor of `p[trace|metric|log]otlp.Export[Request|Response]`
  - Deprecate `p[trace|metric|log]otlp.New[Request|Response]` in favor of `p[trace|metric|log]otlp.NewExport[Request|Response]`
  - Deprecate `p[trace|metric|log]otlp.NewRequestFrom[Traces|Metrics|Logs]` in favor of
    `p[trace|metric|log]otlp.NewExportRequestFrom[Traces|Metrics|Logs]`

- `pdata`: Deprecate `p[trace|metric|log]otlp.NewClient` in favor of `p[trace|metric|log]otlp.NewGRPCClient` (#6350)
- `exporter/logging`: Deprecate 'loglevel' in favor of 'verbosity' option (#5878)
- `pdata`: Deprecate `New[JSON|Proto][Marshaler|Unmarshale]` in favor of exposing the underlying structs (#6340)

### 💡 Enhancements 💡

- `pdata`: Introduce partial success fields in ExportResponse. (#5815, #5816, #6365)
- `obsreport`: Instrument `obsreport.Receiver` metrics with otel-go (#6222)
- `service/telemetry`: Move logging and tracing initialization to service/telemetry (#5564)
- `confmap`: Fail fast when a resolver has URIs with unsupported schemes. (#6274)
- `service`: Use the same `prometheus.Registry` for the OpenCensus and OpenTelemetry Go prometheus exporters to act as a bridge for internal telemetry (#6297)

### 🧰 Bug fixes 🧰

- `pdata`: Because of wrong deprecation/rename in proto, services still send the fake 1000 proto id. See https://github.com/open-telemetry/opentelemetry-proto/issues/431 (#6342)
- `confmap`: When a sub-config implements Unmarshaler, do not reinitialized it unless necessary. (#6392)
- `pdata`: Enable enums as ints for otlp messages, switch to jsoniter for responses. (#6345)
- `collector`: Fixed collector service not cleaning up if it failed during Start (#6352)

## v0.62.1 Beta

- Fix support for new line in config URI location. (#6306)

## v0.62.0 Beta

### 🛑 Breaking changes 🛑

- Delete deprecated `go.opentelemetry.io/collector/service/featuregate`. (#6178)
- Delete deprecated `pmetric.OptionalType`. (#6178)
- Delete deprecated `ptrace.Span[Link]?.TraceStateStruct`. (#6178)
- Delete deprecated `pcommon.NewValueBytesEmpty`. (#6178)
- Delete deprecated `pmetric.MetricDataType`. (#6178)
- Delete deprecated `pmetric.Metric.DataType()`. (#6178)
- Delete deprecated `pmetric.NumberDataPoint.[Set]?[Int|Double]Val()`. (#6178)
- Delete deprecated `pmetric.Exemplar.[Set]?[Int|Double]Val()`. (#6178)
- Delete deprecated `p[metric|log|trace]otlp.[Client|Server]`. (#6178)
- Delete deprecated pdata Clone methods. (#6178)
- Delete deprecated `pcommon.Value` getter/setter methods with `Val` suffix. (#6178)
- Delete deprecated `StringVal` and `SetStringVal` methods. (#6178)
- Delete deprecated `ValueTypeString` method. (#6178)
- Change AggregationTemporality.String to simpler, easier to read. (#6117)
- Update `pcommon.ValueType.String` output to string representation of corresponding type identifiers. The following
  values will be returned: (#6247)
  - ValueTypeEmpty.String() -> "Empty"
  - ValueTypeStr.String() -> "Str"
  - ValueTypeBool.String() -> "Bool"
  - ValueTypeInt.String() -> "Int"
  - ValueTypeDouble.String() -> "Double"
  - ValueTypeMap.String() -> "Map"
  - ValueTypeSlice.String() -> "Slice"
  - ValueTypeBytes.String() -> "Bytes"
- Rename output of `[MetricType|NumberDataPointValueType|ExemplarValueType].String()` for zero values from `"None"` to
  `"Empty"` (#6270)

### 🚩 Deprecations 🚩

- Deprecate `p[metric|log|trace]otlp.RegiserServer` in favor of `p[metric|log|trace]otlp.RegiserGRPCServer` (#6182)
- Deprecate `pcommon.Map.PutString` in favor of `pcommon.Map.PutStr` (#6210)
- Deprecate `pcommon.NewValueString` in favor of `pcommon.NewValueStr` (#6209)
- Deprecate `pmetric.MetricAggregationTemporality` enum type in favor of `pmetric.AggregationTemporality` (#6253)
- Deprecate `confmap.Conf.UnmarshalExact` in favor of `confmap.Conf.Unmarshal(.., WithErrorUnused)` (#6231)
- Deprecate `pmetric.[Default]?MetricDataPointFlags` favor of `pmetric.[Default]?DataPointFlags` (#6259)
- Deprecate `ptrace.[New]?SpanStatus` favor of `ptrace.[New]?Status` (#6258)
- Deprecate `pmetric.[New]?Buckets` in favor of `pmetric.[New]?ExponentialHistogramDataPointBuckets` (#6261)
- Deprecate `plog.SeverityNumberUndefined` in favor of `plog.SeverityNumberUnspecified` (#6269)
- Deprecate `pmetric.[New]?ValueAtQuantile[Slice]?` in favor of `pmetric.[New]?SummaryDataPointValueAtQuantile[Slice]?` (#6262)
- Deprecate enum zero constants ending with `None` (#6270)
  - Deprecate `pmetric.MetricTypeNone` in favor of `pmetric.MetricTypeEmpty`
  - Deprecate `pmetric.NumberDataPointValueTypeNone` in favor of `pmetric.NumberDataPointValueTypeEmpty`
  - Deprecate `pmetric.ExemplarValueTypeNone` in favor of `pmetric.ExemplarValueTypeEmpty`

### 💡 Enhancements 💡

- Add config marshaler (#5566)
- Add semantic conventions for specification v1.10-v1.13 (#6213)
- `receiver/otlp`: Make logs related to gRCPC and HTTP server startup clearer (#6174)
- Add prometheus metric prefix to Collector's own telemetry when using OpenTelemetry for internal telemetry (#6223)
- `exporter/logging`: Apply consistent rendering of map values (#6244)
- Add support in the confmap.Resolver to expand embedded config URIs inside configuration. (#6276)

### 🧰 Bug fixes 🧰

- Fixed bug where `telemetryInitializer` is not cleaned up when `newService` errors (#6239)

## v0.61.0 Beta

### 🛑 Breaking changes 🛑

- Change `ptrace.Span[Link]?.TraceState` signature to match `ptrace.Span[Link]?.TraceStateStruct` (#6085)
- Delete deprecated `pmetric.NewMetricDataPointFlagsImmutable` func. (#6097)
- Delete deprecated `pmetric.*DataPoint.[Set]FlagsImmutable()` funcs. (#6097)
- Delete deprecated `config.Unmarshalable` interface. (#6084)
- Delete deprecated `p[metric|log|trace].MarshalerSizer` interfaces (#6083)
- Delete deprecated `pcommon.Map.Insert*` funcs. (#6088)
- Delete deprecated `pcommon.Map.Upsert*` funcs. (#6088)
- Delete deprecated `pcommon.Map.Update*` funcs. (#6088)
- Change `pcommon.NewValueBytes` signature to match `pcommon.NewValueBytesEmpty`. (#6088)
- Delete deprecated `pcommon.Empty[Trace|Span]ID`. (#6098)
- Delete deprecated `pcommon.[Trace|Span]ID.Bytes()`. (#6098)
- Delete deprecated `pcommon.New[Trace|Span]ID()`. (#6098)
- Delete deprecated `pcommon.Value.SetBytesVal`. (#6088)
- Delete deprecated `pmetric.Metric.SetDataType`. (#6095)
- Delete deprecated `plog.LogRecord.[Set]FlagStruct` funcs. (#6100)
- Delete deprecated `pcommon.ImmutableByteSlice` and `pcommon.NewImmutableByteSlice`. (#6107)
- Delete deprecated `pcommon.ImmutableFloat64Slice` and `pcommon.NewImmutableFloat64Slice`. (#6107)
- Delete deprecated `pcommon.ImmutableUInt64Slice` and `pcommon.NewImmutableUInt64Slice`. (#6107)
- Delete deprecated `*DataPoint.SetBucketCounts` and `*DataPoint.SetExplicitBounds`. (#6108)

### 🚩 Deprecations 🚩

- Deprecate `go.opentelemetry.io/collector/service/featuregate` in favor of `go.opentelemetry.io/collector/featuregate`. (#6094)
- Deprecate `pmetric.OptionalType`, unused enum type. (#6096)
- Deprecate `ptrace.Span[Link]?.TraceStateStruct` in favor of `ptrace.Span[Link]?.TraceState` (#6085)
- Deprecate `pcommon.NewValueBytesEmpty` in favor of `pcommon.NewValueBytes` that now has the same signature. (#6105)
- Deprecate `pmetric.MetricDataType` and related constants in favor of `pmetric.MetricType`. (#6127)
- Deprecate `pmetric.Metric.DataType()` in favor of `pmetric.Metric.Type()`. (#6127)
- Deprecate `pmetric.NumberDataPoint.[Set]?[Int|Double]Val()` in favor of `pmetric.NumberDataPoint.[Set]?[Int|Double]Value()`. (#6134)
- Deprecate `pmetric.Exemplar.[Set]?[Int|Double]Val()` in favor of `pmetric.Exemplar.[Set]?[Int|Double]Value()`. (#6134)
- Deprecate `p[metric|log|trace]otlp.[Client|Server]` in favor of `p[metric|log|trace]otlp.GRPC[Client|Server]` (#6165)
- Deprecate pdata Clone methods in favor of CopyTo for consistency with other pdata structs (#6164)
  - `pmetric.Metrics.Clone` is deprecated in favor of `pmetric.Metrics.CopyTo`
  - `ptrace.Traces.Clone` is deprecated in favor of `pmetric.Traces.CopyTo`
  - `plog.Logs.Clone` is deprecated in favor of `plogs.Logs.CopyTo`
- Rename all `pcommon.Value` getter/setter methods by removing `Val` suffix. (#6092)
  - Old methods with `Val` suffix are deprecated.
  - `StringVal` and `SetStringVal` are deprecated in favor of `Str` and `SetStr` to avoid implementing `fmt.Stringer` interface.
  - Therefore, `ValueTypeString` is deprecated in favour of `ValueTypeStr` for consistency.

### 💡 Enhancements 💡

- Add AppendEmpty and EnsureCapacity method to primitive pdata slices (#6060)
- Expose `AsRaw` and `FromRaw` `pcommon.Value` methods (#6090)
- Convert `ValueTypeBytes` attributes in logging exporter (#6153)
- service.name Resource attribute is added to Collector's own telemetry, defaults to the value of `BuildInfo.Command` and can be overridden in the config (#6152)
- Updated how `telemetryInitializer` is created so it's instanced per Collector instance rather than global to the process (#6138)

## v0.60.0 Beta

### 🛑 Breaking changes 🛑

- Replace deprecated `*DataPoint.Flags()` with `*DataPoint.[Set]FlagsImmutable()`. (#6017)
- Remove deprecated `MetricDataPointFlagsStruct` struct and `NewMetricDataPointFlagsStruct` func. (#6017)
- Replace deprecated `MetricDataPointFlags` with `MetricDataPointFlagsImmutable`. (#6017)
- Replace deprecated `LogRecord.[Set]Flags()` with `LogRecord.[Set]FlagsStruct()`. (#6007)
- Remove deprecated components helpers funcs (#6006)
  - `exporterhelper.New[Traces|Metrics|Logs]ExporterWithContext`
  - `processorhelper.New[Traces|Metrics|Logs]ProcessorWithCreateSettings`
  - `component.NewExtensionFactoryWithStabilityLevel`
- Remove deprecated `pcommon.InvalidTraceID` and `pcommon.InvalidSpanID` funcs (#6008)
- Remove deprecated `pcommon.Map` methods: `Update`, `Upsert`, `InsertNull` (#6019)

### 🚩 Deprecations 🚩

- Deprecate pmetric.Metric.SetDataType, in favor of empty setters for each type. (#5979)
- Deprecate `p[metric|log|trace].MarshalerSizer` in favor of `p[metric|log|trace].MarshalSizer`. (#6033)
- Deprecate `pcommon.Map.Update+` in favor of `pcommon.Map.Get` + `pcommon.Value.Set+` (#6013)
- Deprecate `pcommon.Empty[Trace|Span]ID` in favor of `pcommon.New[Trace|Span]IDEmpty` (#6008)
- Deprecate `pcommon.[Trace|Span]ID.Bytes` in favor direct conversion. (#6008)
- Deprecate `pcommon.New[Trace|Span]ID` in favor direct conversion. (#6008)
- Deprecate `MetricDataPointFlagsImmutable` type. (#6017)
- Deprecate `*DataPoint.[Set]FlagsImmutable()` funcs in favor of `*DataPoint.[Set]Flags()`. (#6017)
- Deprecate `LogRecord.FlagsStruct()` and `LogRecord.SetFlagsStruct()` in favor of `LogRecord.Flags()` and `LogRecord.SetFlags()`. (#6007)
- Deprecate `config.Unmarshallable` in favor of `confmap.Unmarshaler`. (#6031)
- Primitive slice wrapper are now mutable (#5971):
  - `pcommon.ImmutableByteSlice` is deprecated in favor of `pcommon.ByteSlice`
  - `pcommon.ImmutableFloat64Slice` is deprecated in favor of `pcommon.Float64Slice`
  - `pcommon.ImmutableUInt64Slice` is deprecated in favor of `pcommon.UInt64Slice`
  - Temporarily deprecate `pcommon.NewValueBytes` that will be replaced with `pcommon.NewValueBytesEmpty` in 0.60.0
  - Deprecate `pcommon.Map.UpsertBytes` in favor of `pcommon.Map.PutEmptyBytes` (#6064)
  - Deprecate `pcommon.Value.SetBytesVal` in favor of `pcommon.Value.SetEmptyBytesVal`
  - Deprecate `pcommon.New[Slice|Map]FromRaw` functions in favor of `New[Slice|Map]().FromRaw` (#6045)
- Deprecate `pcommon.Map.Insert*` methods (#6051)
- Deprecate `pcommon.Map.Upsert*` methods in favor of `pcommon.Map.Put*` (#6064)
- Deprecate `ptrace.TraceState` in favor of `pcommon.TraceState`. (#6052)
  - `ptrace.Span.TraceState` in favor of `ptrace.Span.TraceStateStruct().AsRaw()`
  - `ptrace.Span.SetTraceState` in favor of `ptrace.Span.TraceStateStruct().FromRaw`
  - `ptrace.SpanLink.TraceState` in favor of `ptrace.SpanLink.TraceStateStruct().AsRaw()`
  - `ptrace.SpanLink.SetTraceState` in favor of `ptrace.SpanLink.TraceStateStruct().FromRaw`
  - `TraceStateStruct` is a temporary name that will be replaced back to `TraceState` in the next release.

### 💡 Enhancements 💡

- Add `skip-get-modules` builder flag to support isolated environment executions (#6009)
  - Skip unnecessary Go binary path validation when the builder is used with `skip-compilation` and `skip-get-modules` flags (#6026)
- Make the otlpreceiver support to use jsoniter to unmarshal JSON payloads. (#6040)
- Add mapstructure hook function for confmap.Unmarshaler interface (#6029)
- Add CopyTo and MoveTo methods to primitive slices (#6044)
- Add support to unmarshalls bytes into plogs.Logs with `jsoniter` in jsonUnmarshaler (#6021)
- Instead of exiting, `ocb` now generates a default Collector when no build configuration is supplied (#5752)

### 🧰 Bug fixes 🧰

- otlpjson: Correctly skip unknown JSON value types. (#6038)
- Fix reading resource attributes from trace JSON. (#6023)

## v0.59.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated fields/funcs from `service` (#5907)
  - Remove `ConfigProviderSettings.Location`
  - Remove `ConfigProviderSettings.MapProviders`
  - Remove `ConfigProviderSettings.MapConverters`
  - Remove `featuregate.Registry.MustAppy`
- Remove deprecated funcs from `pdata` module. (#5911)
  - Remove `pmetric.MetricDataPointFlags.String()`
  - Remove `pmetric.NumberDataPoint.FlagsStruct()`
  - Remove `pmetric.HistogramDataPoint.FlagsStruct()`
  - Remove `pmetric.ExponentialHistogramDataPoint.FlagsStruct()`
  - Remove `pmetric.SummaryDataPoint.FlagsStruct()`
- Remove deprecated settings from `obsreport`, `ProcessorSettings.Level` and `ExporterSettings.Level` (#5918)
- Replace `processorhelper.New[Traces|Metrics|Logs]Exporter` with `processorhelper.New[Traces|Metrics|Logs]ProcessorWithCreateSettings` definition (#5915)
- Replace `exporterhelper.New[Traces|Metrics|Logs]Exporter` with `exporterhelper.New[Traces|Metrics|Logs]ExporterWithContext` definition (#5914)
- Replace ``component.NewExtensionFactory`` with `component.NewExtensionFactoryWithStabilityLevel` definition (#5917)
- Set TLS 1.2 as default for `min_version` for TLS configuration in case this property is not defined (affects servers). (#5956)

### 🚩 Deprecations 🚩

- Deprecate `processorhelper.New[Traces|Metrics|Logs]ProcessorWithCreateSettings` in favor of `processorhelper.New[Traces|Metrics|Logs]Exporter` (#5915)
- Deprecates `LogRecord.Flags()` and `LogRecord.SetFlags()` in favor of `LogRecord.FlagsStruct()` and `LogRecord.SetFlagsStruct()`. (#5972)
- Deprecate `exporterhelper.New[Traces|Metrics|Logs]ExporterWithContext` in favor of `exporterhelper.New[Traces|Metrics|Logs]Exporter` (#5914)
- Deprecate `component.NewExtensionFactoryWithStabilityLevel` in favor of `component.NewExtensionFactory` (#5917)
- Deprecate `plog.SeverityNumber[UPPERCASE]` constants (#5927)
- Deprecate `pcommon.Map.InsertNull` method (#5955)
- Deprecate FlagsStruct types (#5933):
  - `MetricDataPointFlagsStruct` -> `MetricDataPointFlags`
  - `NewMetricDataPointFlagsStruct` -> `NewMetricDataPointFlags`
- Deprecate builder distribution flags, use configuration. (#5946)
- Enforce naming conventions for Invalid[Trace|Span]ID: (#5969)
  - Deprecate funcs `pcommon.InvalidTraceID` and `pcommon.InvalidSpanID` in favor of vars `pcommon.EmptyTraceID` and `pcommon.EmptySpanID`
- Deprecate `Update` and `Upsert` methods of `pcommon.Map` (#5975)
- Deprecated the current MetricDataPointFlags API.  The new API provides functions to check and set Flags. (#5999)
  - `NumberDataPoint.Flags` -> `NumberDataPoint.FlagsImmutable`
  - `HistogramDataPoint.Flags` -> `HistogramDataPoint.FlagsImmutable`
  - `ExponentialHistogramDataPoint.Flags` -> `ExponentialHistogramDataPoint.FlagsImmutable`
  - `SummaryDataPoint.Flags` -> `SummaryDataPoint.FlagsImmutable`
  - `MetricDataPointFlags` -> `MetricDataPointFlagsImmutable`
  - `NewMetricDataPointFlags` -> `MetricDataPointFlagsImmutable`

### 💡 Enhancements 💡

- Added `MarshalerSizer` interface to `ptrace`, `plog`, and `pmetric` packages. `NewProtoMarshaler` now returns a `MarshalerSizer` (#5929)
- Add support to unmarshalls bytes into pmetric.Metrics with `jsoniter` in jsonUnmarshaler(#5433)
- Add httpprovider to allow loading config files stored in HTTP (#5810)
- Added `service.telemetry.traces.propagators` configuration to set propagators for collector's internal spans. (#5572)
- Remove unnecessary duplicate code and allocations for reading enums in JSON. (#5928)
- Add "dist.build_tags" configuration option to support passing go build flags to builder. (#5659)
- Add an AsRaw func on the flags, lots of places to encode these flags. (#5934)
- Change pdata generated types to use type definition instead of aliases. (#5936)
  - Improves documentation, and makes code easier to read/understand.
- Log `InstrumentationScope` attributes in `loggingexporter` (#5976)
- Add `UpsertEmpty`, `UpsertEmptyMap` and `UpsertEmptySlice` methods to `pcommon.Map` (#5975)
- Add `SetEmptyMapVal` and `SetEmptySliceVal` methods to `pcommon.Value` (#5975)

### 🧰 Bug fixes 🧰

- Fix reading scope attributes for trace JSON, remove duplicate code. (#5930)
- otlpjson/trace: skip unknown fields instead of error. (#5931)
- Fix bug in setting the correct collector state after a configuration change event. (#5830)
- Fix json trace unmarshalling for numbers (#5924):
  - Accept both string and number for float64.
  - Accept both string and number for int32/uint32.
  - Read uint64 numbers without converting from int64.
- Fix persistent storage client not closing when shutting down (#6003)

## v0.58.0 Beta

### 🛑 Breaking changes 🛑

- Remove the InstrumentationLibrary to Scope translation (part of transition to OTLP 0.19). (#5819)
  - This has a side effect that when sending JSON encoded telemetry using OTLP proto <= 0.15.0, telemetry will be dropped.
- Require the storage to be explicitly set for the (experimental) persistent queue (#5784)
- Remove deprecated `confighttp.HTTPClientSettings.ToClientWithHost` (#5803)
- Remove deprecated component stability helpers (#5802):
  - `component.WithTracesExporterAndStabilityLevel`
  - `component.WithMetricsExporterAndStabilityLevel`
  - `component.WithLogsExporterAndStabilityLevel`
  - `component.WithTracesReceiverAndStabilityLevel`
  - `component.WithMetricsReceiverAndStabilityLevel`
  - `component.WithLogsReceiverAndStabilityLevel`
  - `component.WithTracesProcessorAndStabilityLevel`
  - `component.WithMetricsProcessorAndStabilityLevel`
  - `component.WithLogsProcessorAndStabilityLevel`
- ABI breaking change: `featuregate.Registry.Apply` returns error now.
- Update minimum go version to 1.18 (#5795)
- Remove deprecated `Flags` API from pdata (#5814)
- Change `confmap.Provider` to return pointer to `Retrieved` (#5839)

### 🚩 Deprecations 🚩

- Deprecate duplicate settings in service.ConfigProvider, embed ResolverSettings (#5843)
- Deprecate `featuregate.Registry.MustApply` in favor of `featuregate.Registry.Apply`. (#5801)
- Deprecate the `component.Factory.StabilityLevel(config.DataType)` in favor of Stability per component (#5762):
  - `component.ExporterFactory.TracesExporterStability`
  - `component.ExporterFactory.MetricsExporterStability`
  - `component.ExporterFactory.LogsExporterStability`
  - `component.ProcessorFactory.TracesProcessorStability`
  - `component.ProcessorFactory.MetricsProcessorStability`
  - `component.ProcessorFactory.LogsProcessorStability`
  - `component.ReceiverFactory.TracesReceiverStability`
  - `component.ReceiverFactory.MetricsReceiverStability`
  - `component.ReceiverFactory.LogsReceiverStability`
- Deprecate `obsreport.ProcessorSettings.Level` and `obsreport.ExporterSettings.Level`, use MetricsLevel from CreateSettings (#5824)
- Deprecate `processorhelper.New[Traces|Metrics|Logs]Processor` in favor of `processorhelper.New[Traces|Metrics|Logs]ProcessorWithCreateSettings` (#5833)
- Deprecate MetricDataPointFlags.String(), no other pdata flags have this method (#5868)
- Deprecates `FlagsStruct` in favor of `Flags` (#5842)
  - `FlagsStruct` -> `Flags`
- Deprecate `exporterhelper.New[Traces|Metrics|Logs]Exporter` in favor of `exporterhelper.New[Traces|Metrics|Logs]ExporterWithContext` (#5834)

### 💡 Enhancements 💡

- Enable persistent queue in the build by default (#5828)
- Bump to opentelemetry-proto v0.19.0. (#5823)
- Expose `Scope.Attributes` in pdata (#5826)
- Remove unnecessary limitation on `pcommon.Value.Equal` that slices have only primitive values. (#5865)
- Add support to handle 404, 405 http error code as permanent errors in OTLP exporter (#5827)
- Enforce scheme name restrictions to all `confmap.Provider` implementations. (#5861)

## v0.57.2 Beta

See the changelog for v0.57.0.

## v0.57.1 Beta

This was a failed release.

## v0.57.0 Beta

There isn't a valid core binary for this release. Use v0.57.2 instead.

### 🛑 Breaking changes 🛑

- Remove deprecated funcs/types from service related to `Config` (#5755)
- Change`confighttp.ToClient` to accept a `component.Host` (#5737)
- Remove deprecated funcs from pdata related to mutable slices (#5754)
- Change the following deprecated component functions to ensure a stability level is set:
  - `component.WithTracesExporter`
  - `component.WithMetricsExporter`
  - `component.WithLogsExporter`
  - `component.WithTracesReceiver`
  - `component.WithMetricsReceiver`
  - `component.WithLogsReceiver`
  - `component.WithTracesProcessor`
  - `component.WithMetricsProcessor`
  - `component.WithLogsProcessor`

### 🚩 Deprecations 🚩

- Deprecated the current Flag API.  The new API provides functions to check and set Flags (#5790) (#5602):
  - `NumberDataPoint.Flags` -> `NumberDataPoint.FlagsStruct`
  - `NumberDataPoint.SetFlags` -> `NumberDataPoint.FlagsStruct`
  - `HistogramDataPoint.Flags` -> `HistogramDataPoint.FlagsStruct`
  - `HistogramDataPoint.SetFlags` -> `HistogramDataPoint.FlagsStruct`
  - `ExponentialHistogramDataPoint.Flags` -> `ExponentialHistogramDataPoint.FlagsStruct`
  - `ExponentialHistogramDataPoint.SetFlags` -> `ExponentialHistogramDataPoint.FlagsStruct`
  - `SummaryDataPoint.Flags` -> `SummaryDataPoint.FlagsStruct`
  - `SummaryDataPoint.SetFlags` -> `SummaryDataPoint.FlagsStruct`
  - `MetricDataPointFlags` -> `MetricDataPointFlagsStruct`
  - `NewMetricDataPointFlags` -> `NewMetricDataPointFlagsStruct`
  - `MetricDataPointFlagsNone` -> `MetricDataPointFlagsStruct.NoRecordedValue`
  - `MetricDataPointFlagNoRecordedValue` -> `MetricDataPointFlagsStruct.NoRecordedValue`
  - `MetricDataPointFlag`
- Deprecate the following component functions added to ensure a stability level is set:
  - `component.WithTracesExporterAndStabilityLevel` -> `component.WithTracesExporter`
  - `component.WithMetricsExporterAndStabilityLevel` -> `component.WithMetricsExporter`
  - `component.WithLogsExporterAndStabilityLevel` -> `component.WithLogsExporter`
  - `component.WithTracesReceiverAndStabilityLevel` -> `component.WithTracesReceiver`
  - `component.WithMetricsReceiverAndStabilityLevel` -> `component.WithMetricsReceiver`
  - `component.WithLogsReceiverAndStabilityLevel` -> `component.WithLogsReceiver`
  - `component.WithTracesProcessorAndStabilityLevel` -> `component.WithTracesProcessor`
  - `component.WithMetricsProcessorAndStabilityLevel` -> `component.WithMetricsProcessor`
  - `component.WithLogsProcessorAndStabilityLevel` -> `component.WithLogsProcessor`

### 💡 Enhancements 💡

- Make the in-memory and persistent queues more consistent (#5764)
- `ocb` now exits with an error if it fails to load the build configuration. (#5731)
- Deprecate `HTTPClientSettings.ToClientWithHost` (#5737)

### 🧰 Bug fixes 🧰

- Fix bug in ocb where flags did not take precedence. (#5726)

## v0.56.0 Beta

### 💡 Enhancements 💡

- Add `linux-ppc64le` architecture to cross build tests in CI (#5645)
- `client`: perform case insensitive lookups in case the requested metadata value isn't found (#5646)
- `loggingexporter`: Decouple `loglevel` field from level of logged messages (#5678)
- Expose `pcommon.NewSliceFromRaw` function (#5679)
- `loggingexporter`: create the exporter's logger from the service's logger (#5677)
- Add `otelcol_exporter_queue_capacity` metrics show the collector's exporter queue capacity (#5475)
- Add support to handle 402, 413, 414, 431 http error code as permanent errors in OTLP exporter (#5685)

### 🧰 Bug fixes 🧰

- Fix Collector panic when disabling telemetry metrics (#5642)
- Fix Collector panic when featuregate value is empty (#5663)
- Fix confighttp.compression panic due to nil request.Body. (#5628)

## v0.55.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated `config.ServiceTelemetry` (#5565)
- Remove deprecated `config.ServiceTelemetryLogs` (#5565)
- Remove deprecated `config.ServiceTelemetryMetrics` (#5565)

### 🚩 Deprecations 🚩

- Deprecate `service.ConfigServiceTelemetry`, `service.ConfigServiceTelemetryLogs`, and `service.ConfigServiceTelemetryMetrics` (#5565)
- Deprecate the following component functions to ensure a stability level is set (#5580):
  - `component.WithTracesExporter` -> `component.WithTracesExporterAndStabilityLevel`
  - `component.WithMetricsExporter` -> `component.WithMetricsExporterAndStabilityLevel`
  - `component.WithLogsExporter` -> `component.WithLogsExporterAndStabilityLevel`
  - `component.WithTracesReceiver` -> `component.WithTracesReceiverAndStabilityLevel`
  - `component.WithMetricsReceiver` -> `component.WithMetricsReceiverAndStabilityLevel`
  - `component.WithLogsReceiver` -> `component.WithLogsReceiverAndStabilityLevel`
  - `component.WithTracesProcessor` -> `component.WithTracesProcessorAndStabilityLevel`
  - `component.WithMetricsProcessor` -> `component.WithMetricsProcessorAndStabilityLevel`
  - `component.WithLogsProcessor` -> `component.WithLogsProcessorAndStabilityLevel`
- Deprecate `Registry.Apply` in `service.featuregate` (#5660)

### 💡 Enhancements 💡

- Components stability levels are now logged. By default components which haven't defined their stability levels, or which are
  unmaintained, deprecated or in development will log a message. (#5580)
- `exporter/logging`: Skip "bad file descriptor" sync errors (#5585)

### 🧰 Bug fixes 🧰

- Fix initialization of the OpenTelemetry MetricProvider. (#5571)
- Set log level for `undefined` stability level to debug. (#5635)

## v0.54.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated `GetLogger`. (#5504)
- Remove deprecated `configtest.LoadConfigMap` (#5505)
- Remove deprecated `config.Map` (#5505)
- Remove deprecated `config.MapProvider` (#5505)
- Remove deprecated `config.MapConverter` (#5505)
- Remove deprecated `config.Received` (#5505)
- Remove deprecated `config.CloseFunc` (#5505)
- Deprecated `pcommon.Value.NewValueBytes` is brought back taking `pcommon.ImmutableByteSlice` as an argument instead of `[]byte` (#5299)

### 🚩 Deprecations 🚩

- Use immutable slices for primitive types slices to restrict mutations. (#5299)
  - `Value.NewValueMBytes` func is deprecated in favor of `Value.NewValueBytes` func that takes
    `ImmutableByteSlice` instead of `[]byte`
  - `Value.SetMBytesVal` func is deprecated in favor of `Value.SetBytesVal` func that takes
    `pcommon.ImmutableByteSlice` instead of []byte.
  - `Value.BytesVal` func is deprecated in favor of `Value.BytesVal` func that returns `pcommon.ImmutableByteSlice`
    instead of []byte.
  - `<HistogramDataPoint|Buckets>.SetMBucketCounts` funcs are deprecated in favor of
    `<HistogramDataPoint|Buckets>.SetBucketCounts` funcs that take `pcommon.ImmutableUInt64Slice` instead of []uint64.
  - `<HistogramDataPoint|Buckets>.MBucketCounts` funcs are deprecated in favor of
    `<HistogramDataPoint|Buckets>.BucketCounts` funcs that return `pcommon.ImmutableUInt64Slice` instead of []uint64.
  - `HistogramDataPoint.SetMExplicitBounds` func is deprecated in favor of `HistogramDataPoint.SetExplicitBounds` func
    that takes `pcommon.ImmutableFloat64Slice` instead of []float64.
  - `HistogramDataPoint.MExplicitBounds` func func is deprecated in favor of `HistogramDataPoint.ExplicitBounds`
    returns `pcommon.ImmutableFloat64Slice` instead of []float64.

### 💡 Enhancements 💡

- Deprecate `HTTPClientSettings.ToClient` in favor of `HTTPClientSettings.ToClientWithHost` (#5584)
- Use OpenCensus `metric` package for process metrics instead of `stats` package (#5486)
- Update OTLP to v0.18.0 (#5530)
- Log histogram min/max fields with `logging` exporter (#5520)

### 🧰 Bug fixes 🧰

- Update sum field of exponential histograms to make it optional (#5530)
- Remove redundant extension shutdown call (#5532)
- Refactor pipelines builder, fix some issues (#5512)
  - Unconfigured receivers are not identified, this was not a real problem in final binaries since the validation of the config catch this.
  - Allow configurations to contain "unused" receivers. Receivers that are configured but not used in any pipeline, this was possible already for exporters and processors.
  - Remove the enforcement/check that Receiver factories create the same instance for the same config.

## v0.53.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated `componenterror` package. (#5420)
- Remove deprecated `config.MapConverterFunc`. (#5419)
- Remove `AddCollectorVersionTag`, enabled for long time already. (#5471)

### 🚩 Deprecations 🚩

- Move `config.Map` to its own package `confmap` which does not depend on any component concept (#5237)
  - `config.Map` -> `confmap.ConfMap`
  - `config.MapProvider` -> `confmap.Provider`
  - `config.Received` -> `confmap.Received`
  - `config.NewReceivedFromMap` -> `confmap.NewReceived`
  - `config.CloseFunc` -> `confmap.CloseFunc`
  - `config.ChangeEvent` -> `confmap.ChangeEvent`
  - `config.MapConverter` -> `confmap.Converter`
  - Package `envmapprovider` -> `envprovider`
  - Package `filemapprovider` -> `fileprovider`
  - Package `yamlmapprovider` -> `yamlprovider`
  - Package `expandmapconverter` -> `expandconverter`
  - Package `filemapprovider` -> `fileprovider`
  - Package `overwritepropertiesmapconverter` -> `overwritepropertiesconverter`
- Deprecate `component.ExtensionDefaultConfigFunc` in favor of `component.ExtensionCreateDefaultConfigFunc` (#5451)
- Deprecate `confmap.Received.AsMap` in favor of `confmap.Received.AsConf` (#5465)
- Deprecate `confmap.Conf.Set`, not used anywhere for the moment (#5485)

### 💡 Enhancements 💡

- Move `service.mapResolver` to `confmap.Resolver` (#5444)
- Add `linux-arm` architecture to cross build tests in CI (#5472)

### 🧰 Bug fixes 🧰

- Fixes the "service.version" label value for internal metrics, always was "latest" in core/contrib distros. (#5449).
- Send correct batch stats when SendBatchMaxSize is set (#5385)
- TLS `MinVersion` and `MaxVersion` defaults will be handled by `crypto/tls` (#5480)

## v0.52.0 Beta

### 🛑 Breaking changes 🛑

- Remove `configunmarshaler.Unmarshaler` interface, per deprecation comment (#5348)
- Remove deprecated pdata funcs/structs from v0.50.0 (#5345)
- Remove deprecated pdata getters and setters of primitive slice values: `Value.BytesVal`, `Value.SetBytesVal`,
  `Value.UpdateBytes`, `Value.InsertBytes`, `Value.UpsertBytes`, `<HistogramDataPoint|Buckets>.BucketCounts`,
  `<HistogramDataPoint|Buckets>.SetBucketCounts`, `HistogramDataPoint.ExplicitBounds`,
  `HistogramDataPoint.SetExplicitBounds` (#5347)
- Remove deprecated featuregate funcs/structs from v0.50.0 (#5346)
- Remove access to deprecated members of the config.Retrieved struct (#5363)
- Replace usage of `config.MapConverterFunc` with `config.MapConverter` (#5382)

### 🚩 Deprecations 🚩

- Deprecate `config.Config` and `config.Service`, use `service.Config*` (#4608)
- Deprecate `componenterror` package, move everything to `component` (#5383)
- `pcommon.Value.NewValueBytes` is deprecated in favor of `Value.NewValueMBytes` in preparation of migration to
  immutable slices (#5367)

### 💡 Enhancements 💡

- Update OTLP to v0.17.0 (#5335)
- Add optional min/max fields to histograms (#5399)
- User-defined Resource attributes can be specified under `service.telemetry.resource`
  configuration key and will be included as metric lables for own telemetry.
  If `service.instance.id` is not specified it will be auto-generated. Previously
  `service.instance.id` was always auto-generated, so the default of the new
  behavior matches the old behavior. (#5402)

## v0.51.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated model module, everything is available in `pdata` and `semconv`. (#5281)
  - Old versions of the module are still available, but no new versions will be released.
- Remove deprecated LogRecord.Name field. (#5202)

### 🚩 Deprecations 🚩

- In preparation of migration to immutable slices for primitive type items, the following methods are renamed (#5344)
  - `Value.BytesVal` func is deprecated in favor of `Value.MBytesVal`.
  - `Value.SetBytesVal` func is deprecated in favor of `Value.SetMBytesVal`.
  - `Value.UpdateBytes` func is deprecated in favor of `Value.UpdateMBytes`.
  - `Value.InsertBytes` func is deprecated in favor of `Value.InsertMBytes`.
  - `Value.UpsertBytes` func is deprecated in favor of `Value.UpsertMBytes`.
  - `<HistogramDataPoint|Buckets>.BucketCounts` funcs are deprecated in favor of
    `<HistogramDataPoint|Buckets>.MBucketCounts`.
  - `<HistogramDataPoint|Buckets>.SetBucketCounts` funcs are deprecated in favor of
    `<HistogramDataPoint|Buckets>.SetMBucketCounts`.
  - `HistogramDataPoint.ExplicitBounds` func is deprecated in favor of `HistogramDataPoint.MExplicitBounds`.
  - `HistogramDataPoint.SetExplicitBounds` func is deprecated in favor of `HistogramDataPoint.SetMExplicitBounds`.

### 💡 Enhancements 💡

- `pdata`: Expose `pcommon.NewSliceFromRaw` and `pcommon.Slice.AsRaw` functions (#5311)

### 🧰 Bug fixes 🧰

- Fix Windows Event Logs ignoring user-specified logging options (#5298)

## v0.50.0 Beta

### 🛑 Breaking changes 🛑

- Remove pdata deprecated funcs from 2 versions (v0.48.0) ago. (#5219)
- Remove non pdata deprecated funcs/structs (#5220)
- `pmetric.Exemplar.ValueType()` now returns new type `ExemplarValueType` (#5233)
- Remove deprecated `Delete` pdata func in favor of `pdata.Remove` from (v0.47.0). (#5307)

### 🚩 Deprecations 🚩

- Deprecate `configunmarshaler` package, move it to internal (#5151)
- Deprecate all API in `model/semconv`. The package is moved to a new `semcomv` module (#5196)
- Deprecate access to `config.Retrieved` fields, use the newly added funcs to interact with the internal fields (#5198)
- Deprecate `p<signal>otlp.Request.Set<Logs|Metrics|Traces>` (#5234)
  - `plogotlp.Request.SetLogs` func is deprecated in favor of `plogotlp.NewRequestFromLogs`
  - `pmetricotlp.Request.SetMetrics` func is deprecated in favor of `pmetricotlp.NewRequestFromMetrics`
  - `ptraceotlp.Request.SetTraces` func is deprecated in favor of `ptraceotlp.NewRequestFromTraces`
- `pmetric.NumberDataPoint.ValueType()` now returns new type `NumberDataPointValueType` (#5233)
  - `pmetric.MetricValueType` is deprecated in favor of `NumberDataPointValueType`
  - `pmetric.MetricValueTypeNone` is deprecated in favor of `NumberDataPointValueTypeNone`
  - `pmetric.MetricValueTypeInt` is deprecated in favor of `NumberDataPointValueTypeInt`
  - `pmetric.MetricValueTypeDouble` is deprecated in favor of `NumberDataPointValueTypeDouble`
- Deprecate `plog.LogRecord.SetName()` function (#5230)
- Deprecate global `featuregate` funcs in favor of `GetRegistry` and a public `Registry` type (#5160)

### 💡 Enhancements 💡
- Add `jsoniter` Unmarshaller (#4817)

- Extend config.Map.Unmarshal hook to check map key string to any TextUnmarshaler not only ComponentID (#5244)
- Collector will no longer print error with stack trace when the collector is shutdown due to a context cancel. (#5258)

### 🧰 Bug fixes 🧰
- Fix translation from otlp.Request to pdata representation, changes to the returned pdata not all reflected to the otlp.Request (#5197)
- `exporterhelper` now properly consumes any remaining items on stop (#5203)
- `pdata`: Fix copying of `Value` with `ValueTypeBytes` type (#5267)
- `pdata`: Fix copying of metric fields of primitive items slice type (#5271)

## v0.49.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated structs/funcs from previous versions (#5131)
- Do not set TraceProvider to global otel (#5138)
- Remove deprecated funcs from otlpgrpc (#5144)
- Add Scheme to MapProvider interface (#5068)
- Do not set MeterProvider to global otel (#5146)
- Make `InstrumentationLibrary<signal>ToScope` helper functions unexported (#5164)
- Remove Log's "ShortName" from logging exporter output (#5172)
- `exporter/otlp`: Retry RESOURCE_EXHAUSTED only if the server returns RetryInfo (#5147)

### 🚩 Deprecations 🚩

- All pdata related APIs from model (model/pdata, model/otlp and model/otlpgrpc) are deprecated in
  favor of packages in the new pdata module separated by telemetry signal type (#5168)
  - `model/pdata`, `model/otlp` -> `pdata/pcommon`, `pdata/plog`, `pdata/pmetric`, `pdata/ptrace`
  - `model/otlpgrpc` -> `pdata/plog/plogotlp`, `pdata/pmetric/pmetricotlp`, `pdata/ptrace/ptraceotlp`
- Deprecate configmapprovider package, replace with mapconverter (#5167)
- Deprecate `service.MustNewConfigProvider` and `service.MustNewDefaultConfigProvider`in favor of `service.NewConfigProvider` (#4936)

### 💡 Enhancements 💡

- OTLP HTTP receiver will use HTTP/2 over TLS if client supports it (#5109)
- Add `ObservedTimestamp` field to `pdata.LogRecord` (#5171)

### 🧰 Bug fixes 🧰

- Setup the correct meter provider if telemetry.useOtelForInternalMetrics featuregate enabled (#5146)
- Fix pdata.Value.asRaw() to correctly return elements of Slice and Map type (#5153)
- Update pdata.Slice.asRaw() to return raw representation of Slice and Map elements (#5157)
- The codepath through the OTLP receiver for gRPC was not translating the InstrumentationLibrary* to Scope* (#5189)

## v0.48.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated `consumerhelper` package (#5028)
- Remove pdata `InternalRep` deprecated funcs (#5018)
- Remove service/defaultcomponents deprecated package (#5019)
- Remove deprecated UseOpenTelemetryForInternalMetrics (#5026)
- Change outcome of `pdata.Value.MapVal()` and `pdata.Value.SliceVal()` functions misuse. In case of
  type mismatch, they now return an invalid zero-initialized instance instead of a detached
  collection (#5034)
- OTLP JSON field changes following upgrade to OTLP v0.15.0:
  - "instrumentationLibraryLogs" is now "scopeLogs"
  - "instrumentationLibraryMetrics" is now "scopeMetrics"
  - "instrumentationLibrarySpans" is now "scopeSpans"
  - "instrumentationLibrary" is now "scope"
- AsString for pdata.Value now returns the JSON-encoded string of floats. (#4934)

### 🚩 Deprecations 🚩

- Move MapProvider to config, split providers in their own package (#5030)
- API related to `pdata.AttributeValue` is deprecated in favor of `pdata.Value` (#4978)
  - `pdata.AttributeValue` struct is deprecated in favor of `pdata.Value`
  - `pdata.AttributeValueType` type is deprecated in favor of `pdata.ValueType`
  - `pdata.AttributeValueType...` constants are deprecated in favor of `pdata.ValueType...`
  - `pdata.NewAttributeValue...` funcs are deprecated in favor of `pdata.NewValue...`
- Deprecate featureflags.FlagValue.SetSlice, unnecessary public (#5053)
- Remove "Attribute" part from common pdata collections names (#5001)
  - Deprecate `pdata.AttributeMap` struct in favor of `pdata.Map`
  - Deprecate `pdata.NewAttributeMap` func in favor of `pdata.NewMap`
  - Deprecate `pdata.NewAttributeMapFromMap` func in favor of `pdata.NewMapFromRaw`
  - Deprecate `pdata.AttributeValueSlice` struct in favor of `pdata.Slice`
  - Deprecate `pdata.NewAttributeValueSlice` func in favor of `pdata.NewSlice`
- Deprecate LogRecord.Name(), it was deprecated in the data model (#5054)
- Rename `Array` type of `pdata.Value` to `Slice` (#5066)
  - Deprecate `pdata.AttributeValueTypeArray` type in favor of `pdata.ValueTypeSlice`
  - Deprecate `pdata.NewAttributeValueArray` func in favor of `pdata.NewValueSlice`
- Deprecate global flag in `featuregates` (#5060)
- Deprecate last funcs/structs in componenthelper (#5069)
- Change structs in otlpgrpc to follow standard go encoding interfaces (#5062)
  - Deprecate UnmarshalJSON[Traces|Metrics|Logs][Reques|Response] in favor of `UnmarshalJSON`.
  - Deprecate [Traces|Metrics|Logs][Reques|Response].Marshal in favor of `MarshalProto`.
  - Deprecate UnmarshalJSON[Traces|Metrics|Logs][Reques|Response] in favor of `UnmarshalProto`.
- Deprecating following pdata methods/types following OTLP v0.15.0 upgrade (#5076):
      - InstrumentationLibrary is now InstrumentationScope
      - NewInstrumentationLibrary is now NewInstrumentationScope
      - InstrumentationLibraryLogsSlice is now ScopeLogsSlice
      - NewInstrumentationLibraryLogsSlice is now NewScopeLogsSlice
      - InstrumentationLibraryLogs is now ScopeLogs
      - NewInstrumentationLibraryLogs is now NewScopeLogs
      - InstrumentationLibraryMetricsSlice is now ScopeMetricsSlice
      - NewInstrumentationLibraryMetricsSlice is now NewScopeMetricsSlice
      - InstrumentationLibraryMetrics is now ScopeMetrics
      - NewInstrumentationLibraryMetrics is now NewScopeMetrics
      - InstrumentationLibrarySpansSlice is now ScopeSpansSlice
      - NewInstrumentationLibrarySpansSlice is now NewScopeSpansSlice
      - InstrumentationLibrarySpans is now ScopeSpans
      - NewInstrumentationLibrarySpans is now NewScopeSpans

### 💡 Enhancements 💡

- Add semconv definitions for v1.9.0 (#5090)
- Change outcome of `pdata.Metric.<Gauge|Sum|Histogram|ExponentialHistogram>()` functions misuse.
  In case of type mismatch, they don't panic right away but return an invalid zero-initialized
  instance for consistency with other OneOf field accessors (#5035)
- Update OTLP to v0.15.0 (#5064)
- Adding support for transition from older versions of OTLP to OTLP v0.15.0 (#5085)

### 🧰 Bug fixes 🧰

- Add missing files for semconv definitions v1.7.0 and v1.8.0 (#5091)
- The `featuregates` were not configured from the "--feature-gates" flag on windows service (#5060)
- Fix Semantic Convention Schema URL definition for 1.5.0 and 1.6.1 versions (#5103)

## v0.47.0 Beta

### 🛑 Breaking changes 🛑

- Remove `Type` funcs in pdata (#4933)
- Remove all deprecated funcs/structs from v0.46.0 (#4995)

### 🚩 Deprecations 🚩

- pdata: deprecate funcs working with InternalRep (#4957)
- Deprecate `pdata.AttributeMap.Delete` in favor of `pdata.AttributeMap.Remove` (#4914)
- Deprecate consumerhelper, move helpers to consumer (#5006)

### 💡 Enhancements 💡

- Add `pdata.AttributeMap.RemoveIf`, which is a more performant way to remove multiple keys (#4914)
- Add `pipeline` key with pipeline identifier to processor loggers (#4968)
- Add a new yaml provider, allows providing yaml bytes (#4998)

### 🧰 Bug fixes 🧰

- Collector `Run` will now exit when a context cancels (#4954)
- Add missing droppedAttributesCount to pdata generated resource (#4979)
- Collector `Run` will now set state to `Closed` if startup fails (#4974)

## v0.46.0 Beta

### 🛑 Breaking changes 🛑

- Change otel collector to enable open telemetry metrics through feature gate instead of a constant (#4912)
- Remove support for legacy otlp/http port. (#4916)
- Remove deprecated funcs in pdata (#4809)
- Remove deprecated Retrieve funcs/calls (#4922)
- Remove deprecated NewConfigProvider funcs (#4937)

### 🚩 Deprecations 🚩

- Deprecated funcs `config.DefaultConfig`, `confighttp.DefaultHTTPSettings`, `exporterhelper.DefaultTimeoutSettings`,
  `exporthelper.DefaultQueueSettings`, `exporterhelper.DefaultRetrySettings`, `testcomponents.DefaultFactories`, and
  `scraperhelper.DefaultScraperControllerSettings` in favour for their `NewDefault` method to adhere to contribution guidelines (#4865)
- Deprecated funcs `componenthelper.StartFunc`, `componenthelper.ShutdownFunc` in favour of `component.StartFunc` and `component.ShutdownFunc` (#4803)
- Move helpers from extensionhelper to component (#4805)
  - Deprecated `extensionhelper.CreateDefaultConfig` in favour of `component.ExtensionDefaultConfigFunc`
  - Deprecated `extensionhelper.CreateServiceExtension` in favour of `component.CreateExtensionFunc`
  - Deprecated `extensionhelper.NewFactory` in favour of `component.NewExtensionFactory`
- Move helpers from processorhelper to component (#4889)
  - Deprecated `processorhelper.CreateDefaultConfig` in favour of `component.ProcessorDefaultConfigFunc`
  - Deprecated `processorhelper.WithTraces` in favour of `component.WithTracesProcessor`
  - Deprecated `processorhelper.WithMetrics` in favour of `component.WithMetricsProcessor`
  - Deprecated `processorhelper.WithLogs` in favour of `component.WithLogsProcessor`
  - Deprecated `processorhelper.NewFactory` in favour of `component.NewProcessorFactory`
- Move helpers from exporterhelper to component (#4899)
  - Deprecated `exporterhelper.CreateDefaultConfig` in favour of `component.ExporterDefaultConfigFunc`
  - Deprecated `exporterhelper.WithTraces` in favour of `component.WithTracesExporter`
  - Deprecated `exporterhelper.WithMetrics` in favour of `component.WithMetricsExporter`
  - Deprecated `exporterhelper.WithLogs` in favour of `component.WithLogsExporter`
  - Deprecated `exporterhelper.NewFactory` in favour of `component.NewExporterFactory`
- Move helpers from receiverhelper to component (#4891)
  - Deprecated `receiverhelper.CreateDefaultConfig` in favour of `component.ReceiverDefaultConfigFunc`
  - Deprecated `receiverhelper.WithTraces` in favour of `component.WithTracesReceiver`
  - Deprecated `receiverhelper.WithMetrics` in favour of `component.WithMetricsReceiver`
  - Deprecated `receiverhelper.WithLogs` in favour of `component.WithLogsReceiver`
  - Deprecated `receiverhelper.NewFactory` in favour of `component.NewReceiverFactory`

### 💡 Enhancements 💡

- Add validation to check at least one endpoint is specified in otlphttpexporter's configuration (#4860)
- Implement default client authenticators (#4837)

## 🧰 Bug fixes 🧰

- Initialized logger with collector to avoid potential race condition panic on `Shutdown` (#4827)
- In addition to traces, now logs and metrics processors will start the memory limiter.
  Added thread-safe logic so only the first processor can launch the `checkMemLimits` go-routine and the last processor
  that calls shutdown to terminate it; this is done per memory limiter instance.
  Added memory limiter factory to cache initiated object and be reused by similar config. This guarantees a single
  running `checkMemLimits` per config (#4886)
- Resolved race condition in collector when calling `Shutdown` (#4878)

## v0.45.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated funcs in configtelemetry (#4808)
- `otlphttp` and `otlp` exporters enable gzip compression by default (#4632)

### 🚩 Deprecations 🚩

- Deprecate `service/defaultcomponents` go package (#4622)
- Deprecate `pdata.NumberDataPoint.Type()` and `pdata.Exemplar.Type()` in favor of `NumberDataPoint.ValueType()` and
  `Exemplar.ValueType()` (#4850)

### 💡 Enhancements 💡

- Reject invalid queue size exporterhelper (#4799)
- Transform configmapprovider.Retrieved interface to a struct (#4789)
- Added feature gate summary to zpages extension (#4834)
- Add support for reloading TLS certificates (#4737)

### 🧰 Bug fixes 🧰

- `confighttp`: Allow CORS requests with configured auth (#4869)

## v0.44.0 Beta

### 🛑 Breaking changes 🛑

- Updated to OTLP 0.12.0. Deprecated traces and metrics messages that existed
  in 0.11.0 are no longer converted to the messages and fields that replaced the deprecated ones.
  Received deprecated messages and fields will be now ignored. In OTLP/JSON in the
  instrumentationLibraryLogs object the "logs" field is now named "logRecords" (#4724)
- Deprecate `service.NewWindowsService`, add `service.NewSvcHandler` (#4783).

### 🚩 Deprecations 🚩

- Deprecate `service.NewConfigProvider`, and a new version `service.MustNewConfigProvider` (#4734).

### 💡 Enhancements 💡

- Invalid requests now return an appropriate unsupported (`405`) or method not allowed (`415`) response (#4735)
- `client.Info`: Add Host property for Metadata (#4736)

## v0.43.1 Beta

### 🧰 Bug fixes 🧰

- ExpandStringValues function support to map[string]interface{} (#4748)

## v0.43.0 Beta

### 🛑 Breaking changes 🛑

- Change configmapprovider.Provider to accept a location for retrieve (#4657)
- Change Properties Provider to be a Converter (#4666)
- Define a type `WatcherFunc` for onChange func instead of func pointer (#4656)
- Remove deprecated `configtest.LoadConfig` and `configtest.LoadConfigAndValidate` (#4659)
- Move service.ConfigMapConverterFunc to config.MapConverterFunc (#4673)
  - Add context to config.MapConverterFunc (#4678)
- Builder: the skip compilation should only be supplied as a CLI flag. Previously, it was possible to specify that in the YAML file, contrary to the original intention (#4645)
- Builder: Remove deprecated config option module::core (#4693)
- Remove deprecate flags --metrics-level and --metrics-addr (#4695)
  - Usages of `--metrics-level={VALUE}` can be replaced by `--set=service.telemetry.metrics.level={VALUE}`;
  - Usages of `--metrics-addr={VALUE}` can be replaced by `--set=service.telemetry.metrics.address={VALUE}`;
- Updated confighttp `ToClient` to support passing telemetry settings for instrumenting otlphttp exporter(#4449)
- Remove support to some arches and platforms from `ocb` (opentelemetry-collector-builder) (#4710)
- Remove deprecated legacy path ("v1/trace") support for otlp http receiver (#4720)
- Change the `service.NewDefaultConfigProvider` to accept a slice of location strings (#4727).

### 🚩 Deprecations 🚩

- Deprecate `configtelemetry.Level.Set()` (#4700)

### 🧰 Bug fixes 🧰

- Ensure Windows path (e.g: C:) is recognized as a file path (#4726)
- Fix structured logging issue for windows service (#4686)

### 💡 Enhancements 💡

- Expose experimental API `configmapprovider.NewExpandConverter()` (#4672)
- `service.NewConfigProvider`: copy slice argument, disallow changes from caller to the input slice (#4729)
- `confighttp` and `configgrpc`: New config option `include_metadata` to persist request metadata/headers in `client.Info.Metadata` (experimental) (#4547)
- Remove expand cases that cannot happen with config.Map (#4649)
- Add `max_request_body_size` to confighttp.HTTPServerSettings (#4677)
- Move `compression.go` into `confighttp.go` to internalize functions in `compression.go` file. (#4651)
  - create `configcompression` package to manage compression methods in `confighttp` and `configgrpc`
- Add support for cgroupv2 memory limit (#4654)
- Enable end users to provide multiple files for config location (#4727)

## v0.42.0 Beta

### 🛑 Breaking changes 🛑

- Remove `configmapprovider.NewInMemory()` (#4507)
- Disallow direct implementation of `configmapprovider.Retrieved` (#4577)
- `configauth`: remove interceptor functions from the ServerAuthenticator interface (#4583)
- Replace ConfigMapProvider and ConfigUnmarshaler in collector settings by one simpler ConfigProvider (#4590)
- Remove deprecated consumererror.Combine (#4597)
- Remove `configmapprovider.NewDefault`, `configmapprovider.NewExpand`, `configmapprovider.NewMerge` (#4600)
  - The merge functionality is now embedded into `service.NewConfigProvider` (#4637).
- Move `configtest.LoadConfig` and `configtest.LoadConfigAndValidate` to `servicetest` (#4606)
- Builder: Remove deprecated `include-core` flag (#4616)
- Collector telemetry level must now be accessed through an atomic function. (#4549)

### 💡 Enhancements 💡

- `confighttp`: add client-side compression support. (#4441)
  - Each exporter should remove `compression` field if they have and should use `confighttp.HTTPClientSettings`
- Allow more zap logger configs: `disable_caller`, `disable_stacktrace`, `output_paths`, `error_output_paths`, `initial_fields` (#1048)
- Allow the custom zap logger encoding (#4532)
- Collector self-metrics may now be configured through the configuration file. (#4069)
  - CLI flags for configuring self-metrics are deprecated and will be removed
    in a future release.
  - `service.telemetry.metrics.level` and `service.telemetry.metrics.address`
    should be used to configure collector self-metrics.
- `configauth`: add helpers to create new server authenticators. (#4558)
- Refactor `configgrpc` for compression methods (#4624)
- Add an option to allow `config.Map` conversion in the `service.ConfigProvider` (#4634)
- Added support to expose gRPC framework's logs as part of collector logs (#4501)
- Builder: Enable unmarshal exact to help finding hard to find typos #4644

### 🧰 Bug fixes 🧰

- Fix merge config map provider to close the watchers (#4570)
- Fix expand map provider to call close on the base provider (#4571)
- Fix correct the value of `otelcol_exporter_send_failed_requests` (#4629)
- `otlp` receiver: Fix legacy port cfg value override and HTTP server starting bug (#4631)

## v0.41.0 Beta

### 🛑 Breaking changes 🛑

- Remove reference to `defaultcomponents` in core and deprecate `include_core` flag (#4087)
- Remove `config.NewConfigMapFrom[File|Buffer]`, add testonly version (#4502)
- `configtls`: TLS 1.2 is the new default mininum version (#4503)
- `confighttp`: `ToServer` now accepts a `component.Host`, in line with gRPC's counterpart (#4514)
- CORS configuration for OTLP/HTTP receivers has been moved into a `cors:` block, instead of individual `cors_allowed_origins` and `cors_allowed_headers` settings (#4492)

### 💡 Enhancements 💡

- OTLP/HTTP receivers now support setting the `Access-Control-Max-Age` header for CORS caching. (#4492)
- `client.Info` pre-populated for all receivers using common helpers like `confighttp` and `configgrpc` (#4423)

### 🧰 Bug fixes 🧰

- Fix handling of corrupted records by persistent buffer (experimental) (#4475)

### 💡 Enhancements 💡

- Extending the contribution guide to help clarify what is acceptable defaults and recommendations.

## v0.40.0 Beta

### 🛑 Breaking changes 🛑

- Package `client` refactored (#4416) and auth data included in it (#4422). Final PR to be merged in the next release (#4423)
- Remove `pdata.AttributeMap.InitFromMap` (#4429)
- Updated configgrpc `ToDialOptions` to support passing providers to instrumentation library (#4451)
- Make state information propagation non-blocking on the collector (#4460)

### 💡 Enhancements 💡

- Add semconv 1.7.0 and 1.8.0 (#4452)
- Added `feature-gates` CLI flag for controlling feature gate state. (#4368)
- Add a default user-agent header to the OTLP/gRPC and OTLP/HTTP exporters containing collector build information (#3970)

## v0.39.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated config (already no-op) `ballast_size_mib` in memorylimiterprocessor (#4365)
- Remove `config.Receivers`, `config.Exporters`, `config.Processors`, and `config.Extensions`. Use map directly (#4344)
- Remove `component.BaseProcessorFactory`, use `processorhelper.NewFactory` instead (#4175)
- Force usage of `exporterhelper.NewFactory` to implement `component.ExporterFactory` (#4338)
- Force usage of `receiverhelper.NewFactory` to implement `component.ReceiverFactory` (#4338)
- Force usage of `extensionhelper.NewFactory` to implement `component.ExtensionFactory` (#4338)
- Move `service/parserprovider` package to `config/configmapprovider` (#4206)
  - Rename `MapProvider` interface to `Provider`
  - Remove `MapProvider` from helper names
- Renamed slice-valued `pdata` types and functions for consistency. (#4325)
  - Rename `pdata.AnyValueArray` to `pdata.AttributeValueSlice`
  - Rename `ArrayVal()` to `SliceVal()`
  - Rename `SetArrayVal()` to `SetSliceVal()`
- Remove `config.Pipeline.Name` (#4326)
- Rename `config.Mapprovider` as `configmapprovider.Provider` (#4337)
- Move `config.WatchableRetrieved` and `config.Retrieved` interfaces to `config/configmapprovider` package (#4337)
- Remove `config.Pipeline.InputDataType` (#4343)
- otlpexporter: Do not retry on PermissionDenied and Unauthenticated (#4349)
- Enable configuring collector metrics through service config file. (#4069)
  - New `service::telemetry::metrics` structure added to configuration
  - Existing metrics configuration CLI flags are deprecated and to be
    removed in the future.
  - `--metrics-prefix` is no longer operative; the prefix is determined by
    the value of `service.buildInfo.Command`.
  - `--add-instance-id` is no longer operative; an instance ID will always be added.
- Remove deprecated funcs `consumererror.As[Traces|Metrics|Logs]` (#4364)
- Remove support to expand env variables in default configs (#4366)

### 💡 Enhancements 💡

- Supports more compression methods(`snappy` and `zstd`) for configgrpc, in addition to current `gzip` (#4088)
- Moved the OpenTelemetry Collector Builder to core (#4307)

### 🧰 Bug fixes 🧰

- Fix AggregationTemporality and IsMonotonic when metric descriptors are split in the batch processor (#4389)

## v0.38.0 Beta

### 🛑 Breaking changes 🛑

- Removed `configauth.HTTPClientAuthenticator` and `configauth.GRPCClientAuthenticator` in favor of `configauth.ClientAuthenticator`. (#4255)
- Rename `parserprovider.MapProvider` as `config.MapProvider`. (#4178)
- Rename `parserprovider.Watchable` as `config.WatchableMapProvider`. (#4178)
- Remove deprecated no-op flags to setup Collector's logging "--log-level", "--log-profile", "--log-format". (#4213)
- Move `cmd/pdatagen` as internal package `model/internal/cmd/pdatagen`. (#4243)
- Use directly the ComponentID in configauth. (#4238)
- Refactor configauth, getters use the map instead of iteration. (#4234)
- Change scraperhelper to follow the recommended append model for pdata. (#4202)

### 💡 Enhancements 💡

- Update proto to 0.11.0. (#4209)
- Change pdata to use the newly added [Traces|Metrics|Logs]Data. (#4214)
- Add ExponentialHistogram field to pdata. (#4219)
- Make sure otlphttp exporter tests include TraceID and SpanID. (#4268)
- Use multimod tool in release process. (#4229)
- Change queue metrics to use opencensus metrics instead of stats, close to otel-go. (#4220)
- Make receiver data delivery guarantees explicit (#4262)
- Simplify unmarshal logic by adding more supported hooks. (#4237)
- Add unmarshaler for otlpgrpc.[*]Request and otlpgrp.[*]Response (#4215)

## v0.37.0 Beta

### 🛑 Breaking changes 🛑

- Move `configcheck.ValidateConfigFromFactories` as internal function in service package (#3876)
- Rename `configparser.Parser` as `config.Map` (#4075)
- Rename `component.DefaultBuildInfo()` to `component.NewDefaultBuildInfo()` (#4129)
- Rename `consumererror.Permanent` to `consumererror.NewPermanent` (#4118)
- Rename `config.NewID` to `config.NewComponentID` and `config.NewIDFromString` to `config.NewComponentIDFromString` (#4137)
- Rename `config.NewIDWithName` to `config.NewComponentIDWithName` (#4151)
- Move `extension/storage` to `extension/experimental/storage` (#4082)
- Rename `obsreporttest.SetupRecordedMetricsTest()` to `obsreporttest.SetupTelemetry()` and `obsreporttest.TestTelemetrySettings` to `obsreporttest.TestTelemetry` (#4157)

### 💡 Enhancements 💡

- Add Gen dependabot into CI (#4083)
- Update OTLP to v0.10.0 (#4045).
- Add Flags field to NumberDataPoint, HistogramDataPoint, SummaryDataPoint (#4081).
- Add feature gate library (#4108)
- Add version to the internal telemetry metrics (#4140)

### 🧰 Bug fixes 🧰

- Fix panic when not using `service.NewCommand` (#4139)

## v0.36.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated pdata.AttributeMapToMap (#3994)
- Move ValidateConfig from configcheck to configtest (#3956)
- Remove `mem-ballast-size-mib`, already deprecated and no-op (#4005)
- Remove `semconv.AttributeMessageType` (#4020)
- Remove `semconv.AttributeHTTPStatusText` (#4015)
- Remove squash on `configtls.TLSClientSetting` and move TLS client configs under `tls` (#4063)
- Rename TLS server config `*configtls.TLSServerSetting` from `tls_settings` to `tls` (#4063)
- Split `service.Collector` from the `cobra.Command` (#4074)
- Rename `memorylimiter` to `memorylimiterprocessor` (#4064)

### 💡 Enhancements 💡

- Create new semconv package for v1.6.1 (#3948)
- Add AttributeValueBytes support to AsString (#4002)
- Add AttributeValueTypeBytes support to AttributeMap.AsRaw (#4003)
- Add MeterProvider to TelemetrySettings (#4031)
- Add configuration to setup collector logs via config file. (#4009)

## v0.35.0 Beta

### 🛑 Breaking changes 🛑

- Remove the legacy gRPC port(`55680`) support in OTLP receiver (#3966)
- Rename configparser.Parser to configparser.ConfigMap (#3964)
- Remove obsreport.ScraperContext, embed into StartMetricsOp (#3969)
- Remove dependency on deprecated go.opentelemetry.io/otel/oteltest (#3979)
- Remove deprecated pdata.AttributeValueToString (#3953)
- Remove deprecated pdata.TimestampFromTime. Closes: #3925 (#3935)

### 💡 Enhancements 💡

- Add TelemetryCreateSettings (#3984)
- Only initialize collector telemetry once (#3918)
- Add trace context info to LogRecord log (#3959)
- Add new view for AWS ECS health check extension. (#3776)

## v0.34.0 Beta

### 🛑 Breaking changes 🛑

- Artifacts are no longer published in this repository, check [here](https://github.com/open-telemetry/opentelemetry-collector-releases) (#3941)
- Remove deprecated `tracetranslator.AttributeValueToString` and `tracetranslator.AttributeMapToMap` (#3873)
- Change semantic conventions for status (code, msg) as per specifications (#3872)
- Move `fileexporter` to contrib (#3474)
- Move `jaegerexporter` to contrib (#3474)
- Move `kafkaexporter` to contrib (#3474)
- Move `opencensusexporter` to contrib (#3474)
- Move `prometheusexporter` to contrib (#3474)
- Move `prometheusremotewriteexporter` to contrib (#3474)
- Move `zipkinexporter` to contrib (#3474)
- Move `attributeprocessor` to contrib (#3474)
- Move `filterprocessor` to contrib (#3474)
- Move `probabilisticsamplerprocessor` to contrib (#3474)
- Move `resourceprocessor` to contrib (#3474)
- Move `spanprocessor` to contrib (#3474)
- Move `hostmetricsreceiver` to contrib (#3474)
- Move `jaegerreceiver` to contrib (#3474)
- Move `kafkareceiver` to contrib (#3474)
- Move `opencensusreceiver` to contrib (#3474)
- Move `prometheusreceiver` to contrib (#3474)
- Move `zipkinreceiver` to contrib (#3474)
- Move `bearertokenauthextension` to contrib (#3474)
- Move `healthcheckextension` to contrib (#3474)
- Move `oidcauthextension` to contrib (#3474)
- Move `pprofextension` to contrib (#3474)
- Move `translator/internaldata` to contrib (#3474)
- Move `translator/trace/jaeger` to contrib (#3474)
- Move `translator/trace/zipkin` to contrib (#3474)
- Move `testbed` to contrib (#3474)
- Move `exporter/exporterhelper/resource_to_telemetry` to contrib (#3474)
- Move `processor/processorhelper/attraction` to contrib (#3474)
- Move `translator/conventions` to `model/semconv` (#3901)

### 🚩 Deprecations 🚩

- Add `pdata.NewTimestampFromTime`, deprecate `pdata.TimestampFromTime` (#3868)
- Add `pdata.NewAttributeMapFromMap`, deprecate `pdata.AttributeMap.InitFromMap` (#3936)

## v0.33.0 Beta

### 🛑 Breaking changes 🛑

- Rename `configloader` interface to `configunmarshaler` (#3774)
- Remove `LabelsMap` from all the metrics points (#3706)
- Update generated K8S attribute labels to fix capitalization (#3823)

### 💡 Enhancements 💡

- Collector has now full support for metrics proto v0.9.0.

## v0.32.0 Beta

This release is marked as "bad" since the metrics pipelines will produce bad data.

- See https://github.com/open-telemetry/opentelemetry-collector/issues/3824

### 🛑 Breaking changes 🛑

- Rename `CustomUnmarshable` interface to `Unmarshallable` (#3774)

### 💡 Enhancements 💡

- Change default OTLP/HTTP port number from 55681 to 4318 (#3743)
- Update OTLP proto to v0.9.0 (#3740)
  - Remove `SetValue`/`Value` func for `NumberDataPoint`/`Exemplar` (#3730)
  - Remove `IntGauge`/`IntSum`from pdata (#3731)
  - Remove `IntDataPoint` from pdata (#3735)
  - Add support for `Bytes` attribute type (#3756)
  - Add `SchemaUrl` field (#3759)
  - Add `Attributes` to `NumberDataPoint`, `HistogramDataPoint`, `SummaryDataPoint` (#3761)
- `conventions` translator: Replace with conventions generated from spec v1.5.0 (#3494)
- `prometheus` receiver: Add `ToMetricPdata` method (#3695)
- Make configsource `Watchable` an optional interface (#3792)
- `obsreport` exporter: Change to accept `ExporterCreateSettings` (#3789)

### 🧰 Bug fixes 🧰

- `configgrpc`: Use chained interceptors in the gRPC server (#3744)
- `prometheus` receiver: Use actual interval startTimeMs for cumulative types (#3694)
- `jaeger` translator: Fix bug that could generate empty proto spans (#3808)

## v0.31.0 Beta

### 🛑 Breaking changes 🛑

- Remove Resize() from pdata slice APIs (#3675)
- Remove the ballast allocation when `mem-ballast-size-mib` is set in command line (#3626)
  - Use [`ballast extension`](./extension/ballastextension/README.md) to set memory ballast instead.
- Rename `DoubleDataPoint` to `NumberDataPoint` (#3633)
- Remove `IntHistogram` (#3676)

### 💡 Enhancements 💡

- Update to OTLP 0.8.0:
  - Translate `IntHistogram` to `Histogram` in `otlp_wrappers` (#3676)
  - Translate `IntGauge` to `Gauge` in `otlp_wrappers` (#3619)
  - Translate `IntSum` to `Sum` in `otlp_wrappers` (#3621)
  - Update `NumberDataPoint` to support `DoubleVal` and `IntVal` (#3689)
  - Update `Exemplar` to use `oneOfPrimitiveValue` (#3699)
  - Remove `IntExemplar` and `IntExemplarSlice` from `pdata` (#3705)
  - Mark `IntGauge`/`IntSum`/`IntDataPoint` as deprecated (#3707)
  - Remove `IntGauge`/`IntSum` from `batchprocessor` (#3718)
  - `prometheusremotewrite` exporter: Convert to new Number metrics (#3714)
  - `prometheus` receiver: Convert to new Number metrics (#3716)
  - `prometheus` exporter: Convert to new Number metrics (#3709)
  - `hostmetrics` receiver: Convert to new Number metrics (#3710)
  - `opencensus`: Convert to new Number metrics (#3708)
  - `scraperhelper` receiver: Convert to new Number metrics (#3717)
  - `testbed`: Convert to new Number metrics (#3719)
  - `expoerterhelper`: Convert `resourcetolabel` to new Number metrics (#3723)
- `configauth`: Prepare auth API to return a context (#3618)
- `pdata`:
  - Implement `Equal()` for map-valued `AttributeValues` (#3612)
  - Add `[Type]Slice.Sort(func)` to sort slices (#3671)
- `memorylimiter`:
  - Add validation on ballast size between `memorylimiter` and `ballastextension` (#3532)
  - Access Ballast extension via `Host.GetExtensions` (#3634)
- `prometheusremotewrite` exporter: Add a WAL implementation without wiring up (#3597)
- `prometheus` receiver: Add `metricGroup.toDistributionPoint` pdata conversion (#3667)
- Use `ComponentID` as identifier instead of config (#3696)
- `zpages`: Move config validation from factory to `Validate` (#3697)
- Enable `tracez` z-pages from otel-go, disable opencensus (#3698)
- Convert temporality and monotonicity for deprecated sums (#3729)

### 🧰 Bug fixes 🧰

- `otlpexporter`: Allow endpoint to be configured with a scheme of `http` or `https` (#3575)
- Handle errors when reloading the collector service (#3615)
- Do not report fatal error when `cmux.ErrServerClosed` (#3703)
- Fix bool attribute equality in `pdata` (#3688)

## v0.30.0 Beta

### 🛑 Breaking changes 🛑

- Rename `pdata.DoubleSum` to `pdata.Sum` (#3583)
- Rename `pdata.DoubleGauge` to `pdata.Gauge` (#3599)
- Migrated `pdata` to a dedicated package (#3483)
- Change Marshaler/Unmarshaler to be consistent with other interfaces (#3502)
- Remove consumer/simple package (#3438)
- Remove unnecessary interfaces from pdata (#3506)
- zipkinv1 implement directly Unmarshaler interface (#3504)
- zipkinv2 implement directly Marshaler/Unmarshaler interface (#3505)
- Change exporterhelper to accept ExporterCreateSettings instead of just logger (#3569)
- Use Func pattern in processorhelper, consistent with others (#3570)

### 🚩 Deprecations 🚩

- Deprecate Resize() from pdata slice APIs (#3573)

### 💡 Enhancements 💡

- Update OTLP to v0.8.0 (#3572)
- Migrate from OpenCensus to OpenTelemetry for internal tracing (#3567)
- Move internal/pdatagrpc to model/otlpgrpc (#3507)
- Move internal/otlp to model/otlp (#3508)
- Create http Server via Config, enable cors and decompression (#3513)
- Allow users to set min and max TLS versions (#3591)
- Support setting ballast size in percentage of total Mem in ballast extension (#3456)
- Publish go.opentelemetry.io/collector/model as a separate module (#3530)
- Pass a TracerProvider via construct settings to all the components (#3592)
- Make graceful shutdown optional (#3577)

### 🧰 Bug fixes 🧰

- `scraperhelper`: Include the scraper name in log messages (#3487)
- `scraperhelper`: fix case when returned pdata is empty (#3520)
- Record the correct number of points not metrics in Kafka receiver (#3553)
- Validate the Prometheus configuration (#3589)

## v0.29.0 Beta

### 🛑 Breaking changes 🛑

- Rename `service.Application` to `service.Collector` (#3268)
- Provide case sensitivity in config yaml mappings by using Koanf instead of Viper (#3337)
- Move zipkin constants to an internal package (#3431)
- Disallow renaming metrics using metric relabel configs (#3410)
- Move cgroup and iruntime utils from memory_limiter to internal folder (#3448)
- Move model pdata interfaces to pdata, expose them publicly (#3455)

### 💡 Enhancements 💡

- Change obsreport helpers for scraper to use the same pattern as Processor/Exporter (#3327)
- Convert `otlptext` to implement Marshaler interfaces (#3366)
- Add encoder/decoder and marshaler/unmarshaler for OTLP protobuf (#3401)
- Use the new marshaler/unmarshaler in `kafka` exporter (#3403)
- Convert `zipkinv2` to to/from translator interfaces (#3409)
- `zipkinv1`: Move to translator and encoders interfaces (#3419)
- Use the new marshaler/unmarshaler in `kafka` receiver #3402
- Change `oltp` receiver to use the new unmarshaler, avoid grpc-gateway dependency (#3406)
- Use the new Marshaler in the `otlphttp` exporter (#3433)
- Add grpc response struct for all signals instead of returning interface in `otlp` receiver/exporter (#3437)
- `zipkinv2`: Add encoders, decoders, marshalers (#3426)
- `scrapererror` receiver: Return concrete error type (#3360)
- `kafka` receiver: Add metrics support (#3452)
- `prometheus` receiver:
  - Add store to track stale metrics (#3414)
  - Add `up` and `scrape_xxxx` internal metrics (#3116)

### 🧰 Bug fixes 🧰

- `prometheus` receiver:
  - Reject datapoints with duplicate label keys (#3408)
  - Scrapers are not stopped when receiver is shutdown (#3450)
- `prometheusremotewrite` exporter: Adjust default retry settings (#3416)
- `hostmetrics` receiver: Fix missing startTimestamp for `processes` scraper (#3461)

## v0.28.0 Beta

### 🛑 Breaking changes 🛑

- Remove unused logstest package (#3222)
- Introduce `AppSettings` instead of `Parameters` (#3163)
- Remove unused testutil.TempSocketName (#3291)
- Move BigEndian helper functions in `tracetranslator` to an internal package.(#3298)
- Rename `configtest.LoadConfigFile` to `configtest.LoadConfigAndValidate` (#3306)
- Replace `ExtensionCreateParams` with `ExtensionCreateSettings` (#3294)
- Replace `ProcessorCreateParams` with `ProcessorCreateSettings`. (#3181)
- Replace `ExporterCreateParams` with `ExporterCreateSettings` (#3164)
- Replace `ReceiverCreateParams` with `ReceiverCreateSettings`. (#3167)
- Change `batchprocessor` logic to limit data points rather than metrics (#3141)
- Rename `PrwExporter` to `PRWExporter` and `NewPrwExporter` to `NewPRWExporter` (#3246)
- Avoid exposing OpenCensus reference in public APIs (#3253)
- Move `config.Parser` to `configparser.Parser` (#3304)
- Remove deprecated funcs inside the obsreceiver (#3314)
- Remove `obsreport.GRPCServerWithObservabilityEnabled`, enable observability in config (#3315)
- Remove `obsreport.ProcessorMetricViews`, use `BuildProcessorCustomMetricName` where needed (#3316)
- Remove "Receive" from `obsreport.Receiver` funcs (#3326)
- Remove "Export" from `obsreport.Exporter` funcs (#3333)
- Hide unnecessary public struct `obsreport.StartReceiveOptions` (#3353)
- Avoid exposing internal implementation public in OC/OTEL receivers (#3355)
- Updated configgrpc `ToDialOptions` and confighttp `ToClient` apis to take extensions configuration map (#3340)
- Remove `GenerateSequentialTraceID` and `GenerateSequentialSpanIDin` functions in testbed (#3390)
- Change "grpc" to "GRPC" in configauth function/type names (#3285)

### 💡 Enhancements 💡

- Add `doc.go` files to the consumer package and its subpackages (#3270)
- Improve documentation of consumer package and subpackages (#3269, #3361)
- Automate triggering of doc-update on release (#3234)
- Enable Dependabot for Github Actions (#3312)
- Remove the proto dependency in `goldendataset` for traces (#3322)
- Add telemetry for dropped data due to exporter sending queue overflow (#3328)
- Add initial implementation of `pdatagrcp` (#3231)
- Change receiver obsreport helpers pattern to match the Processor/Exporter (#3227)
- Add model translation and encoding interfaces (#3200)
- Add otlpjson as a serializer implementation (#3238)
- `prometheus` receiver:
  - Add `createNodeAndResourcePdata` for Prometheus->OTLP pdata (#3139)
  - Direct metricfamily Prometheus->OTLP (#3145)
- Add `componenttest.NewNop*CreateSettings` to simplify tests (#3375)
- Add support for markdown generation (#3100)
- Refactor components for the Client Authentication Extensions (#3287)

### 🧰 Bug fixes 🧰

- Use dedicated `zapcore.Core` for Windows service (#3147)
- Hook up start and shutdown functions in fileexporter (#3260)
- Fix oc to pdata translation for sum non-monotonic cumulative (#3272)
- Fix `timeseriesSignature` in prometheus receiver (#3310)

## v0.27.0 Beta

### 🛑 Breaking changes 🛑

- Change `Marshal` signatures in kafkaexporter's Marshalers to directly convert pdata to `sarama.ProducerMessage` (#3162)
- Remove `tracetranslator.DetermineValueType`, only used internally by Zipkin (#3114)
- Remove OpenCensus conventions, should not be used (#3113)
- Remove Zipkin specific translation constants, move to internal (#3112)
- Remove `tracetranslator.TagHTTPStatusCode`, use `conventions.AttributeHTTPStatusCode` (#3111)
- Remove OpenCensus status constants and transformation (#3110)
- Remove `tracetranslator.AttributeArrayToSlice`, not used in core or contrib (#3109)
- Remove `internaldata.MetricsData`, same APIs as for traces (#3156)
- Rename `config.IDFromString` to `NewIDFromString`, remove `MustIDFromString` (#3177)
- Move consumerfanout package to internal (#3207)
- Canonicalize enum names in pdata. Fix usage of uppercase names (#3208)

### 💡 Enhancements 💡

- Use `config.ComponentID` for obsreport receiver/scraper (#3098)
- Add initial implementation of the consumerhelper (#3146)
- Add Collector version to Prometheus Remote Write Exporter user-agent header (#3094)
- Refactor processorhelper to use consumerhelper, split by signal type (#3180)
- Use consumerhelper for exporterhelper, add WithCapabilities (#3186)
- Set capabilities for all core exporters, remove unnecessary funcs (#3190)
- Add an internal sharedcomponent to be shared by receivers with shared resources (#3198)
- Allow users to configure the Prometheus remote write queue (#3046)
- Mark internaldata traces translation as deprecated for external usage (#3176)

### 🧰 Bug fixes 🧰

- Fix Prometheus receiver metric start time and reset determination logic. (#3047)
  - The receiver will no longer drop the first sample for `counter`, `summary`, and `histogram` metrics.
- The Prometheus remote write exporter will no longer force `counter` metrics to have a `_total` suffix. (#2993)
- Remove locking from jaeger receiver start and stop processes (#3070)
- Fix batch processor metrics reorder, improve performance (#3034)
- Fix batch processor traces reorder, improve performance (#3107)
- Fix batch processor logs reorder, improve performance (#3125)
- Avoid one unnecessary allocation in grpc OTLP exporter (#3122)
- `batch` processor: Validate that batch config max size is greater than send size (#3126)
- Add capabilities to consumer, remove from processor (#2770)
- Remove internal protos usage in Prometheusremotewrite exporter (#3184)
- `prometheus` receiver: Honor Prometheus external labels (#3127)
- Validate that remote write queue settings are not negative (#3213)

## v0.26.0 Beta

### 🛑 Breaking changes 🛑

- Change `With*Unmarshallers` signatures in Kafka exporter/receiver (#2973)
- Rename `marshall` to `marshal` in all the occurrences (#2977)
- Remove `componenterror.ErrAlreadyStarted` and `componenterror.ErrAlreadyStopped`, components should not protect against this, Service will start/stop once.
- Rename `ApplicationStartInfo` to `BuildInfo`
- Rename `ApplicationStartInfo.ExeName` to `BuildInfo.Command`
- Rename `ApplicationStartInfo.LongName` to `BuildInfo.Description`

### 🚩 Deprecations 🚩

- Add AppendEmpty and deprecate Append for slices (#2970)

### 💡 Enhancements 💡

- `kafka` exporter: Add logs support (#2943)
- Update mdatagen to create factories of init instead of new (#2978)
- `zipkin` receiver: Reduce the judgment of zipkin v1 version (#2990)
- Custom authenticator logic to accept a `component.Host` which will extract the authenticator to use based on a new authenticator name property (#2767)
- `prometheusremotewrite` exporter: Add `resource_to_telemetry_conversion` config option (#3031)
- `logging` exporter: Extract OTLP text logging (#3082)
- Format timestamps as strings instead of int in otlptext output (#3088)
- Add darwin arm64 build (#3090)

### 🧰 Bug fixes 🧰

- Fix Jaeger receiver to honor TLS Settings (#2866)
- `zipkin` translator: Handle missing starttime case for zipkin json v2 format spans (#2506)
- `prometheus` exporter: Fix OTEL resource label drops (#2899)
- `prometheusremotewrite` exporter:
  - Enable the queue internally (#2974)
  - Don't drop instance and job labels (#2979)
- `jaeger` receiver: Wait for server goroutines exit on shutdown (#2985)
- `logging` exporter: Ignore invalid handle on close (#2994)
- Fix service zpages (#2996)
- `batch` processor: Fix to avoid reordering and send max size (#3029)

## v0.25.0 Beta

### 🛑 Breaking changes 🛑

- Rename ForEach (in pdata) with Range to be consistent with sync.Map (#2931)
- Rename `componenthelper.Start` to `componenthelper.StartFunc` (#2880)
- Rename `componenthelper.Stop` to `componenthelper.StopFunc` (#2880)
- Remove `exporterheleper.WithCustomUnmarshaler`, `processorheleper.WithCustomUnmarshaler`, `receiverheleper.WithCustomUnmarshaler`, `extensionheleper.WithCustomUnmarshaler`, implement `config.CustomUnmarshaler` interface instead (#2867)
- Remove `component.CustomUnmarshaler` implement `config.CustomUnmarshaler` interface instead (#2867)
- Remove `testutil.HostPortFromAddr`, users can write their own parsing helper (#2919)
- Remove `configparser.DecodeTypeAndName`, use `config.IDFromString` (#2869)
- Remove `config.NewViper`, users should use `config.NewParser` (#2917)
- Remove `testutil.WaitFor`, use `testify.Eventually` helper if needed (#2920)
- Remove testutil.WaitForPort, users can use testify.Eventually (#2926)
- Rename `processorhelper.NewTraceProcessor` to `processorhelper.NewTracesProcessor` (#2935)
- Rename `exporterhelper.NewTraceExporter` to `exporterhelper.NewTracesExporter` (#2937)
- Remove InitEmptyWithCapacity, add EnsureCapacity and Clear (#2845)
- Rename traces methods/objects to include Traces in Kafka receiver (#2966)

### 💡 Enhancements 💡

- Add `validatable` interface with `Validate()` to all `config.<component>` (#2898)
  - add the empty `Validate()` implementation for all component configs
- **Experimental**: Add a config source manager that wraps the interaction with config sources (#2857, #2903, #2948)
- `kafka` exporter: Key jaeger messages on traceid (#2855)
- `scraperhelper`: Don't try to count metrics if scraper returns an error (#2902)
- Extract ConfigFactory in a ParserProvider interface (#2868)
- `prometheus` exporter: Allows Summary metrics to be exported to Prometheus (#2900)
- `prometheus` receiver: Optimize `dpgSignature` function (#2945)
- `kafka` receiver: Add logs support (#2944)

### 🧰 Bug fixes 🧰

- `prometheus` receiver:
  - Treat Summary and Histogram metrics without "\_sum" counter as valid metric (#2812)
  - Add `job` and `instance` as well-known labels (#2897)
- `prometheusremotewrite` exporter:
  - Sort Sample by Timestamp to avoid out of order errors (#2941)
  - Remove incompatible queued retry (#2951)
- `kafka` receiver: Fix data race with batchprocessor (#2957)
- `jaeger` receiver: Jaeger agent should not report ErrServerClosed (#2965)

## v0.24.0 Beta

### 🛑 Breaking changes 🛑

- Remove legacy internal metrics for memorylimiter processor, `spans_dropped` and `trace_batches_dropped` (#2841)
  - For `spans_dropped` use `processor/refused_spans` with `processor=memorylimiter`
- Rename pdata._.[Start|End]Time to pdata._.[Start|End]Timestamp (#2847)
- Rename pdata.DoubleExemplar to pdata.Exemplar (#2804)
- Rename pdata.DoubleHistogram to pdata.Histogram (#2797)
- Rename pdata.DoubleSummary to pdata.Summary (#2774)
- Refactor `consumererror` package (#2768)
  - Remove `PartialError` type in favor of signal-specific types
  - Rename `CombineErrors()` to `Combine()`
- Refactor `componenthelper` package (#2778)
  - Remove `ComponentSettings` and `DefaultComponentSettings()`
  - Rename `NewComponent()` to `New()`
- obsReport.NewExporter accepts a settings struct (#2668)
- Remove ErrorWaitingHost from `componenttest` (#2582)
- Move `config.Load` to `configparser.Load` (#2796)
- Remove `configtest.NewViperFromYamlFile()`, use `config.Parser.NewParserFromFile()` (#2806)
- Remove `config.ViperSubExact()`, use `config.Parser.Sub()` (#2806)
- Update LoadReceiver signature to remove unused params (#2823)
- Move `configerror.ErrDataTypeIsNotSupported` to `componenterror.ErrDataTypeIsNotSupported` (#2886)
- Rename`CreateTraceExporter` type to `CreateTracesExporter` in `exporterhelper` (#2779)
- Move `fluentbit` extension to contrib (#2795)
- Move `configmodels` to `config` (#2808)
- Move `fluentforward` receiver to contrib (#2723)

### 🚩 Deprecations 🚩

- Deprecate `consumetest.New[${SIGNAL}]Nop` in favor of `consumetest.NewNop` (#2878)
- Deprecate `consumetest.New[${SIGNAL}]Err` in favor of `consumetest.NewErr` (#2878)

### 💡 Enhancements 💡

- `batch` processor: - Support max batch size for logs (#2736)
- Use `Endpoint` for health check extension (#2782)
- Use `confignet.TCPAddr` for `pprof` and `zpages` extensions (#2829)
- Add watcher to values retrieved via config sources (#2803)
- Updates for cloud semantic conventions (#2809)
  - `cloud.infrastructure_service` -> `cloud.platform`
  - `cloud.zone` -> `cloud.availability_zone`
- Add systemd environment file for deb/rpm packages (#2822)
- Add validate interface in `configmodels` to force each component do configuration validation (#2802, #2856)
- Add `aws.ecs.task.revision` to semantic conventions list (#2816)
- Set unprivileged user to container image (#2838)
- Add New funcs for extension, exporter, processor config settings (#2872)
- Report metric about current size of the exporter retry queue (#2858)
- Allow adding new signals in `ProcessorFactory` by forcing everyone to embed `BaseProcessorFactory` (#2885)

### 🧰 Bug fixes 🧰

- `pdata.TracesFromOtlpProtoBytes`: Fixes to handle backwards compatibility changes in proto (#2798)
- `jaeger` receiver: Escape user input used in output (#2815)
- `prometheus` exporter: Ensure same time is used for updated time (#2745)
- `prometheusremotewrite` exporter: Close HTTP response body (#2875)

## v0.23.0 Beta

### 🛑 Breaking changes 🛑

- Move fanout consumers to fanoutconsumer package (#2615)
- Rename ExporterObsReport to Exporter (#2658)
- Rename ProcessorObsReport to Processor (#2657)
- Remove ValidateConfig and add Validate on the Config struct (#2665)
- Rename pdata Size to OtlpProtoSize (#2726)
- Rename [Traces|Metrics|Logs]Consumer to [Traces|Metrics|Logs] (#2761)
- Remove public access for `componenttest.Example*` components:
  - Users of these structs for testing configs should use the newly added `componenttest.Nop*` (update all components name in the config `example*` -> `nop` and use `componenttest.NopComponents()`).
  - Users of these structs for sink like behavior should use `consumertest.*Sink`.

### 💡 Enhancements 💡

- `hostmetrics` receiver: List labels along with respective metrics in metadata (#2662)
- `exporter` helper: Remove obsreport.ExporterContext, always add exporter name as a tag to the metrics (#2682)
- `jaeger` exporter: Change to not use internal data (#2698)
- `kafka` receiver: Change to not use internal data (#2697)
- `zipkin` receiver: Change to not use internal data (#2699)
- `kafka` exporter: Change to not use internal data (#2696)
- Ensure that extensions can be created and started multiple times (#2679)
- Use otlp request in logs wrapper, hide members in the wrapper (#2692)
- Add MetricsWrapper to dissallow access to internal representation (#2693)
- Add TracesWrapper to dissallow access to internal representation (#2721)
- Allow multiple OTLP receivers to be created (#2743)

### 🧰 Bug fixes 🧰

- `prometheus` exporter: Fix to work with standard labels that follow the naming convention of using periods instead of underscores (#2707)
- Propagate name and transport for `prometheus` receiver and exporter (#2680)
- `zipkin` receiver: Ensure shutdown correctness (#2765)

## v0.22.0 Beta

### 🛑 Breaking changes 🛑

- Rename ServiceExtension to just Extension (#2581)
- Remove `consumerdata.TraceData` (#2551)
- Move `consumerdata.MetricsData` to `internaldata.MetricsData` (#2512)
- Remove custom OpenCensus sematic conventions that have equivalent in otel (#2552)
- Move ScrapeErrors and PartialScrapeError to `scrapererror` (#2580)
- Remove support for deprecated unmarshaler `CustomUnmarshaler`, only `Unmarshal` is supported (#2591)
- Remove deprecated componenterror.CombineErrors (#2598)
- Rename `pdata.TimestampUnixNanos` to `pdata.Timestamp` (#2549)

### 💡 Enhancements 💡

- `prometheus` exporter: Re-implement on top of `github.com/prometheus/client_golang/prometheus` and add `metric_expiration` option
- `logging` exporter: Add support for AttributeMap (#2609)
- Add semantic conventions for instrumentation library (#2602)

### 🧰 Bug fixes 🧰

- `otlp` receiver: Fix `Shutdown()` bug (#2564)
- `batch` processor: Fix Shutdown behavior (#2537)
- `logging` exporter: Fix handling the loop for empty attributes (#2610)
- `prometheusremotewrite` exporter: Fix counter name check (#2613)

## v0.21.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated function `IsValid` from trace/span ID (#2522)
- Remove accessors for deprecated status code (#2521)

### 💡 Enhancements 💡

- `otlphttp` exporter: Add `compression` option for gzip encoding of outgoing http requests (#2502)
- Add `ScrapeErrors` struct to `consumererror` to simplify errors usage (#2414)
- Add `cors_allowed_headers` option to `confighttp` (#2454)
- Add SASL/SCRAM authentication mechanism on `kafka` receiver and exporter (#2503)

### 🧰 Bug fixes 🧰

- `otlp` receiver: Sets the correct deprecated status code before sending data to the pipeline (#2521)
- Fix `IsPermanent` to account for wrapped errors (#2455)
- `otlp` exporter: Preserve original error messages (#2459)

## v0.20.0 Beta

### 🛑 Breaking changes 🛑

- Rename `samplingprocessor/probabilisticsamplerprocessor` to `probabilisticsamplerprocessor` (#2392)

### 💡 Enhancements 💡

- `hostmetrics` receiver: Refactor to use metrics metadata utilities (#2405, #2406, #2421)
- Add k8s.node semantic conventions (#2425)

## v0.19.0 Beta

### 🛑 Breaking changes 🛑

- Remove deprecated `queued_retry` processor
- Remove deprecated configs from `resource` processor: `type` (set "opencensus.type" key in "attributes.upsert" map instead) and `labels` (use "attributes.upsert" instead).

### 💡 Enhancements 💡

- `hostmetrics` receiver: Refactor load metrics to use generated metrics (#2375)
- Add uptime to the servicez debug page (#2385)
- Add new semantic conventions for AWS (#2365)

### 🧰 Bug fixes 🧰

- `jaeger` exporter: Improve connection state logging (#2239)
- `pdatagen`: Fix slice of values generated code (#2403)
- `filterset` processor: Avoid returning always nil error in strict filterset (#2399)

## v0.18.0 Beta

### 🛑 Breaking changes 🛑

- Rename host metrics according to metrics spec and rename `swap` scraper to `paging` (#2311)

### 💡 Enhancements 💡

- Add check for `NO_WINDOWS_SERVICE` environment variable to force interactive mode on Windows (#2272)
- `hostmetrics` receiver: Add `disk/weighted_io_time` metric (Linux only) (#2312)
- `opencensus` exporter: Add queue-retry (#2307)
- `filter` processor: Filter metrics using resource attributes (#2251)

### 🧰 Bug fixes 🧰

- `fluentforward` receiver: Fix string conversions (#2314)
- Fix zipkinv2 translation error tag handling (#2253)

## v0.17.0 Beta

### 💡 Enhancements 💡

- Default config environment variable expansion (#2231)
- `prometheusremotewrite` exporter: Add batched exports (#2249)
- `memorylimiter` processor: Introduce soft and hard limits (#2250)

### 🧰 Bug fixes 🧰

- Fix nits in pdata usage (#2235)
- Convert status to not be a pointer in the Span (#2242)
- Report the error from `pprof.StartCPUProfile` (#2263)
- Rename `service.Application.SignalTestComplete` to `Shutdown` (#2277)

## v0.16.0 Beta

### 🛑 Breaking changes 🛑

- Rename Push functions to be consistent across signals in `exporterhelper` (#2203)

### 💡 Enhancements 💡

- Change default OTLP/gRPC port number to 4317, also continue receiving on legacy port
  55680 during transition period (#2104).
- `kafka` exporter: Add support for exporting metrics as otlp Protobuf. (#1966)
- Move scraper helpers to its own `scraperhelper` package (#2185)
- Add `componenthelper` package to help build components (#2186)
- Remove usage of custom init/stop in `scraper` and use start/shutdown from `component` (#2193)
- Add more trace annotations, so zpages are more useful to determine failures (#2206)
- Add support to skip TLS verification (#2202)
- Expose non-nullable metric types (#2208)
- Expose non-nullable elements from slices of pointers (#2200)

### 🧰 Bug fixes 🧰

- Change InstrumentationLibrary to be non-nullable (#2196)
- Add support for slices to non-pointers, use non-nullable AnyValue (#2192)
- Fix `--set` flag to work with `{}` in configs (#2162)

## v0.15.0 Beta

### 🛑 Breaking changes 🛑

- Remove legacy metrics, they were marked as legacy for ~12 months #2105

### 💡 Enhancements 💡

- Implement conversion between OpenCensus and OpenTelemetry Summary Metric (#2048)
- Add ability to generate non nullable messages (#2005)
- Implement Summary Metric in Prometheus RemoteWrite Exporter (#2083)
- Add `resource_to_telemetry_conversion` to exporter helper expose exporter settings (#2060)
- Add `CustomRoundTripper` function to httpclientconfig (#2085)
- Allow for more logging options to be passed to `service` (#2132)
- Add config parameters for `jaeger` receiver (#2068)
- Map unset status code for `jaegar` translator as per spec (#2134)
- Add more trace annotations to the queue-retry logic (#2136)
- Add config settings for component telemetry (#2148)
- Use net.SplitHostPort for IPv6 support in `prometheus` receiver (#2154)
- Add --log-format command line option (default to "console") #2177.

### 🧰 Bug fixes 🧰

- `logging` exporter: Add Logging for Summary Datapoint (#2084)
- `hostmetrics` receiver: use correct TCP state labels on Unix systems (#2087)
- Fix otlp_log receiver wrong use of trace measurement (#2117)
- Fix "process/memory/rss" metric units (#2112)
- Fix "process/cpu_seconds" metrics (#2113)
- Add check for nil logger in exporterhelper functions (#2141)
- `prometheus` receiver:
  - Upgrade Prometheus version to fix race condition (#2121)
  - Fix the scraper/discover manager coordination (#2089)
  - Fix panic when adjusting buckets (#2168)

## v0.14.0 Beta

### 🚀 New components 🚀

- `otlphttp` exporter which implements OTLP over HTTP protocol.

### 🛑 Breaking changes 🛑

- Rename consumer.TraceConsumer to consumer.TracesConsumer #1974
- Rename component.TraceReceiver to component.TracesReceiver #1975
- Rename component.TraceProcessor to component.TracesProcessor #1976
- Rename component.TraceExporter to component.TracesExporter #1975
- Move `tailsampling` processor to contrib (#2012)
- Remove NewAttributeValueSlice (#2028) and mark NewAttributeValue as deprecated (#2022)
- Remove pdata.StringValue (#2021)
- Remove pdata.InitFromAttributeMap, use CopyTo if needed (#2042)
- Remove SetMapVal and SetArrayVal for pdata.AttributeValue (#2039)

### 🚩 Deprecations 🚩

- Deprecate NopExporter, add NopConsumer (#1972)
- Deprecate SinkExporter, add SinkConsumer (#1973)

### 💡 Enhancements 💡

- `zipkin` exporter: Add queue retry to zipkin (#1971)
- `prometheus` exporter: Add `send_timestamps` option (#1951)
- `filter` processor: Add `expr` pdata.Metric filtering support (#1940, #1996)
- `attribute` processor: Add log support (#1934)
- `logging` exporter: Add index for histogram buckets count (#2009)
- `otlphttp` exporter: Add correct handling of server error responses (#2016)
- `prometheusremotewrite` exporter:
  - Add user agent header to outgoing http request (#2000)
  - Convert histograms to cumulative (#2049)
  - Return permanent errors (#2053)
  - Add external labels (#2044)
- `hostmetrics` receiver: Use scraper controller (#1949)
- Change Span/Trace ID to be byte array (#2001)
- Add `simple` metrics helper to facilitate building pdata.Metrics in receivers (#1540)
- Improve diagnostic logging for exporters (#2020)
- Add obsreport to receiverhelper scrapers (#1961)
- Update OTLP to 0.6.0 and use the new Span Status code (#2031)
- Add support of partial requests for logs and metrics to the exporterhelper (#2059)

### 🧰 Bug fixes 🧰

- `logging` exporter: Added array serialization (#1994)
- `zipkin` receiver: Allow receiver to parse string tags (#1893)
- `batch` processor: Fix shutdown race (#1967)
- Guard for nil data points (#2055)

## v0.13.0 Beta

### 🛑 Breaking changes 🛑

- Host metric `system.disk.time` renamed to `system.disk.operation_time` (#1887)
- Use consumer for sender interface, remove unnecessary receiver address from Runner (#1941)
- Enable sending queue by default in all exporters configured to use it (#1924)
- Removed `groupbytraceprocessor` (#1891)
- Remove ability to configure collection interval per scraper (#1947)

### 💡 Enhancements 💡

- Host Metrics receiver now reports both `system.disk.io_time` and `system.disk.operation_time` (#1887)
- Match spans against the instrumentation library and resource attributes (#928)
- Add `receiverhelper` for creating flexible "scraper" metrics receiver (#1886, #1890, #1945, #1946)
- Migrate `tailsampling` processor to new OTLP-based internal data model and add Composite Sampler (#1894)
- Metadata Generator: Change Metrics fields to implement an interface with new methods (#1912)
- Add unmarshalling for `pdata.Traces` (#1948)
- Add debug-level message on error for `jaeger` exporter (#1964)

### 🧰 Bug fixes 🧰

- Fix bug where the service does not correctly start/stop the log exporters (#1943)
- Fix Queued Retry Unusable without Batch Processor (#1813) - (#1930)
- `prometheus` receiver: Log error message when `process_start_time_seconds` gauge is missing (#1921)
- Fix trace jaeger conversion to internal traces zero time bug (#1957)
- Fix panic in otlp traces to zipkin (#1963)
- Fix OTLP/HTTP receiver's path to be /v1/traces (#1979)

## v0.12.0 Beta

### 🚀 New components 🚀

- `configauth` package with the auth settings that can be used by receivers (#1807, #1808, #1809, #1810)
- `perfcounters` package that uses perflib for host metrics receiver (#1835, #1836, #1868, #1869, #1870)

### 💡 Enhancements 💡

- Remove `queued_retry` and enable `otlp` metrics receiver in default config (#1823, #1838)
- Add `limit_percentage` and `spike_limit_percentage` options to `memorylimiter` processor (#1622)
- `hostmetrics` receiver:
  - Collect additional labels from partitions in the filesystems scraper (#1858)
  - Add filters for mount point and filesystem type (#1866)
- Add cloud.provider semantic conventions (#1865)
- `attribute` processor: Add log support (#1783)
- Introduce SpanID data type, not yet used in Protobuf messages ($1854, #1855)
- Enable `otlp` trace by default in the released docker image (#1883)
- `tailsampling` processor: Combine batches of spans into a single batch (#1864)
- `filter` processor: Update to use pdata (#1885)
- Allow MSI upgrades (#1914)

### 🚩 Deprecations 🚩

- Deprecate OpenCensus-based internal data structures (#1843)

### 🧰 Bug fixes 🧰

- `prometheus` receiver: Print a more informative message about 'up' metric value (#1826)
- Use custom data type and custom JSON serialization for traceid (#1840)
- Skip creation of redundant nil resource in translation from OC if there are no combined metrics (#1803)
- `tailsampling` processor: Only send to next consumer once (#1735)
- Report Windows pagefile usage in bytes (#1837)
- Fix issue where Prometheus SD config cannot be parsed (#1877)

## v0.11.0 Beta

### 🛑 Breaking changes 🛑

- Rename service.Start() to Run() since it's a blocking call
- Fix slice Append to accept by value the element in pdata
- Change CreateTraceProcessor and CreateMetricsProcessor to use the same parameter order as receivers/logs processor and exporters.
- Prevent accidental use of LogsToOtlp and LogsFromOtlp and the OTLP data structs (#1703)
- Remove SetType from configmodels, ensure all registered factories set the type in config (#1798)
- Move process telemetry to service/internal (#1794)

### 💡 Enhancements 💡

- Add map and array attribute value type support (#1656)
- Add authentication support to kafka (#1632)
- Implement InstrumentationLibrary translation to jaeger (#1645)
- Add public functions to export pdata to ExportXServicesRequest Protobuf bytes (#1741)
- Expose telemetry level in the configtelemetry (#1796)
- Add configauth package (#1807)
- Add config to docker image (#1792)

### 🧰 Bug fixes 🧰

- Use zap int argument for int values instead of conversion (#1779)
- Add support for gzip encoded payload in OTLP/HTTP receiver (#1581)
- Return proto status for OTLP receiver when failed (#1788)

## v0.10.0 Beta

### 🛑 Breaking changes 🛑

- **Update OTLP to v0.5.0, incompatible metrics protocol.**
- Remove support for propagating summary metrics in OtelCollector.
  - This is a temporary change, and will affect mostly OpenCensus users who use metrics.

### 💡 Enhancements 💡

- Support zipkin proto in `kafka` receiver (#1646)
- Prometheus Remote Write Exporter supporting Cortex (#1577, #1643)
- Add deployment environment semantic convention (#1722)
- Add logs support to `batch` and `resource` processors (#1723, #1729)

### 🧰 Bug fixes 🧰

- Identify config error when expected map is other value type (#1641)
- Fix Kafka receiver closing ready channel multiple times (#1696)
- Fix a panic issue while processing Zipkin spans with an empty service name (#1742)
- Zipkin Receiver: Always set the endtime (#1750)

## v0.9.0 Beta

### 🛑 Breaking changes 🛑

- **Remove old base factories**:
  - `ReceiverFactoryBase` (#1583)
  - `ProcessorFactoryBase` (#1596)
  - `ExporterFactoryBase` (#1630)
- Remove logs factories and merge with normal factories (#1569)
- Remove `reconnection_delay` from OpenCensus exporter (#1516)
- Remove `ConsumerOld` interfaces (#1631)

### 🚀 New components 🚀

- `prometheusremotewrite` exporter: Send metrics data in Prometheus TimeSeries format to Cortex or any Prometheus (#1544)
- `kafka` receiver: Receive traces from Kafka (#1410)

### 💡 Enhancements 💡

- `kafka` exporter: Enable queueing, retry, timeout (#1455)
- Add `Headers` field in HTTPClientSettings (#1552)
- Change OpenCensus receiver (#1556) and exporter (#1571) to the new interfaces
- Add semantic attribute for `telemetry.auto.version` (#1578)
- Add uptime and RSS memory self-observability metrics (#1549)
- Support conversion for OpenCensus `SameProcessAsParentSpan` (#1629)
- Access application version in components (#1559)
- Make Kafka payload encoding configurable (#1584)

### 🧰 Bug fixes 🧰

- Stop further processing if `filterprocessor` filters all data (#1500)
- `processscraper`: Use same scrape time for all data points coming from same process (#1539)
- Ensure that time conversion for 0 returns nil timestamps or Time where IsZero returns true (#1550)
- Fix multiple exporters panic (#1563)
- Allow `attribute` processor for external use (#1574)
- Do not duplicate filesystem metrics for devices with many mount points (#1617)

## v0.8.0 Beta

### 🚀 New components 🚀

- `groupbytrace` processor that waits for a trace to be completed (#1362)

### 💡 Enhancements 💡

- Migrate `zipkin` receiver/exporter to the new interfaces (#1484)
- Migrate `prometheus` receiver/exporter to the new interfaces (#1477, #1515)
- Add new FactoryUnmarshaler support to all components, deprecate old way (#1468)
- Update `fileexporter` to write data in OTLP (#1488)
- Add extension factory helper (#1485)
- Host scrapers: Use same scrape time for all data points coming from same source (#1473)
- Make logs SeverityNumber publicly available (#1496)
- Add recently included conventions for k8s and container resources (#1519)
- Add new config StartTimeMetricRegex to `prometheus` receiver (#1511)
- Convert Zipkin receiver and exporter to use OTLP (#1446)

### 🧰 Bug fixes 🧰

- Infer OpenCensus resource type based on OpenTelemetry's semantic conventions (#1462)
- Fix log adapter in `prometheus` receiver (#1493)
- Avoid frequent errors for process telemetry on Windows (#1487)

## v0.7.0 Beta

### 🚀 New components 🚀

- Receivers
  - `fluentfoward` runs a TCP server that accepts events via the [Fluent Forward protocol](https://github.com/fluent/fluentd/wiki/Forward-Protocol-Specification-v1) (#1173)
- Exporters
  - `kafka` exports traces to Kafka (#1439)
- Extensions
  - **Experimental** `fluentbit` facilitates running a FluentBit subprocess of the collector (#1381)

### 💡 Enhancements 💡

- Updated `golang/protobuf` from v1.3.5 to v1.4.2 (#1308)
- Updated `opencensus-proto` from v0.2.1 to v0.3.0 (#1308)
- Added round_robin `balancer_name` as an option to gRPC client settings (#1353)
- `hostmetrics` receiver
  - Switch to using perf counters to get disk io metrics on Windows (#1340)
  - Add device filter for file system (#1379) and disk (#1378) scrapers
  - Record process physical & virtual memory stats separately (#1403)
  - Scrape system.disk.time on Windows (#1408)
  - Add disk.pending_operations metric (#1428)
  - Add network interface label to network metrics (#1377)
- Add `exporterhelper` (#1351) and `processorhelper` (#1359) factories
- Update OTLP to latest version (#1384)
- Disable timeout, retry on failure and sending queue for `logging` exporter (#1400)
- Add support for retry and sending queue for `jaeger` exporter (#1401)
- Add batch size bytes metric to `batch` processor (#1270)
- `otlp` receiver: Add Log Support (#1444)
- Allow to configure read/write buffer sizes for http Client (#1447)
- Update DB conventions to latest and add exception conventions (#1452)

### 🧰 Bug fixes 🧰

- Fix `resource` processor for old metrics (#1412)
- `jaeger` receiver: Do not try to stop if failed to start. Collector service will do that (#1434)

## v0.6.0 Beta

### 🛑 Breaking changes 🛑

- Renamed the metrics generated by `hostmetrics` receiver to match the (currently still pending) OpenTelemetry system metric conventions (#1261) (#1269)
- Removed `vmmetrics` receiver (#1282)
- Removed `cpu` scraper `report_per_cpu` config option (#1326)

### 💡 Enhancements 💡

- Added disk merged (#1267) and process count (#1268) metrics to `hostmetrics`
- Log metric data points in `logging` exporter (#1258)
- Changed the `batch` processor to not ignore the errors returned by the exporters (#1259)
- Build and publish MSI (#1153) and DEB/RPM packages (#1278, #1335)
- Added batch size metric to `batch` processor (#1241)
- Added log support for `memorylimiter` processor (#1291) and `logging` exporter (#1298)
- Always add tags for `observability`, other metrics may use them (#1312)
- Added metrics support (#1313) and allow partial retries in `queued_retry` processor (#1297)
- Update `resource` processor: introduce `attributes` config parameter to specify actions on attributes similar to `attributes` processor, old config interface is deprecated (#1315)
- Update memory state labels for non-Linux OSs (#1325)
- Ensure tcp connection value is provided for all states, even when count is 0 (#1329)
- Set `batch` processor channel size to num cpus (#1330)
- Add `send_batch_max_size` config parameter to `batch` processor enforcing hard limit on batch size (#1310)
- Add support for including a per-RPC authentication to gRPC settings (#1250)

### 🧰 Bug fixes 🧰

- Fixed OTLP waitForReady, not set from config (#1254)
- Fixed all translation diffs between OTLP and Jaeger (#1222)
- Disabled `process` scraper for any non Linux/Windows OS (#1328)

## v0.5.0 Beta

### 🛑 Breaking changes 🛑

- **Update OTLP to v0.4.0 (#1142)**: Collector will be incompatible with any other sender or receiver of OTLP protocol
  of different versions
- Make "--new-metrics" command line flag the default (#1148)
- Change `endpoint` to `url` in Zipkin exporter config (#1186)
- Change `tls_credentials` to `tls_settings` in Jaegar receiver config (#1233)
- OTLP receiver config change for `protocols` to support mTLS (#1223)
- Remove `export_resource_labels` flag from Zipkin exporter (#1163)

### 🚀 New components 🚀

- Receivers
  - Added process scraper to the `hostmetrics` receiver (#1047)

### 💡 Enhancements 💡

- otlpexporter: send configured headers in request (#1130)
- Enable Collector to be run as a Windows service (#1120)
- Add config for HttpServer (#1196)
- Allow cors in HTTPServerSettings (#1211)
- Add a generic grpc server settings config, cleanup client config (#1183)
- Rely on gRPC to batch and loadbalance between connections instead of custom logic (#1212)
- Allow to tune the read/write buffers for gRPC clients (#1213)
- Allow to tune the read/write buffers for gRPC server (#1218)

### 🧰 Bug fixes 🧰

- Handle overlapping metrics from different jobs in prometheus exporter (#1096)
- Fix handling of SpanKind INTERNAL in OTLP OC translation (#1143)
- Unify zipkin v1 and v2 annotation/tag parsing logic (#1002)
- mTLS: Add support to configure client CA and enforce ClientAuth (#1185)
- Fixed untyped Prometheus receiver bug (#1194)
- Do not embed ProtocolServerSettings in gRPC (#1210)
- Add Context to the missing CreateMetricsReceiver method (#1216)

## v0.4.0 Beta

Released 2020-06-16

### 🛑 Breaking changes 🛑

- `isEnabled` configuration option removed (#909)
- `thrift_tchannel` protocol moved from `jaeger` receiver to `jaeger_legacy` in contrib (#636)

### ⚠️ Major changes ⚠️

- Switch from `localhost` to `0.0.0.0` by default for all receivers (#1006)
- Internal API Changes (only impacts contributors)
  - Add context to `Start` and `Stop` methods in the component (#790)
  - Rename `AttributeValue` and `AttributeMap` method names (#781)
    (other breaking changes in the internal trace data types)
  - Change entire repo to use the new vanityurl go.opentelemetry.io/collector (#977)

### 🚀 New components 🚀

- Receivers
  - `hostmetrics` receiver with CPU (#862), disk (#921), load (#974), filesystem (#926), memory (#911), network (#930), and virtual memory (#989) support
- Processors
  - `batch` for batching received metrics (#1060)
  - `filter` for filtering (dropping) received metrics (#1001)

### 💡 Enhancements 💡

- `otlp` receiver implement HTTP X-Protobuf (#1021)
- Exporters: Support mTLS in gRPC exporters (#927)
- Extensions: Add `zpages` for service (servicez, pipelinez, extensions) (#894)

### 🧰 Bug fixes 🧰

- Add missing logging for metrics at `debug` level (#1108)
- Fix setting internal status code in `jaeger` receivers (#1105)
- `zipkin` export fails on span without timestamp when used with `queued_retry` (#1068)
- Fix `zipkin` receiver status code conversion (#996)
- Remove extra send/receive annotations with using `zipkin` v1 (#960)
- Fix resource attribute mutation bug when exporting in `jaeger` proto (#907)
- Fix metric/spans count, add tests for nil entries in the slices (#787)

### 🧩 Components 🧩

#### Traces

| Receivers  |   Processors   | Exporters  |
|:----------:|:--------------:|:----------:|
|   Jaeger   |   Attributes   |    File    |
| OpenCensus |     Batch      |   Jaeger   |
|    OTLP    | Memory Limiter |  Logging   |
|   Zipkin   |  Queued Retry  | OpenCensus |
|            |    Resource    |    OTLP    |
|            |    Sampling    |   Zipkin   |
|            |      Span      |            |

#### Metrics

|  Receivers  |   Processors   | Exporters  |
|:-----------:|:--------------:|:----------:|
| HostMetrics |     Batch      |    File    |
| OpenCensus  |     Filter     |  Logging   |
|    OTLP     | Memory Limiter | OpenCensus |
| Prometheus  |                |    OTLP    |
| VM Metrics  |                | Prometheus |

#### Extensions

- Health Check
- Performance Profiler
- zPages

## v0.3.0 Beta

Released 2020-03-30

### Breaking changes

- Make prometheus receiver config loading strict. #697
  Prometheus receiver will now fail fast if the config contains unused keys in it.

### Changes and fixes

- Enable best effort serve by default of Prometheus Exporter (https://github.com/orijtech/prometheus-go-metrics-exporter/pull/6)
- Fix null pointer exception in the logging exporter #743
- Remove unnecessary condition to have at least one processor #744

### Components

| Receivers / Exporters |   Processors   |      Extensions      |
|:---------------------:|:--------------:|:--------------------:|
|        Jaeger         |   Attributes   |     Health Check     |
|      OpenCensus       |     Batch      | Performance Profiler |
|     OpenTelemetry     | Memory Limiter |        zPages        |
|        Zipkin         |  Queued Retry  |                      |
|                       |    Resource    |                      |
|                       |    Sampling    |                      |
|                       |      Span      |                      |

## v0.2.8 Alpha

Alpha v0.2.8 of OpenTelemetry Collector

- Implemented OTLP receiver and exporter.
- Added ability to pass config to the service programmatically (useful for custom builds).
- Improved own metrics / observability.
- Refactored component and factory interface definitions (breaking change #683)

## v0.2.7 Alpha

Alpha v0.2.7 of OpenTelemetry Collector

- Improved error handling on shutdown
- Partial implementation of new metrics (new obsreport package)
- Include resource labels for Zipkin exporter
- New `HASH` action to attribute processor

## v0.2.6 Alpha

Alpha v0.2.6 of OpenTelemetry Collector.

- Update metrics prefix to `otelcol` and expose command line argument to modify the prefix value.
- Extend Span processor to have include/exclude span logic.
- Batch dropped span now emits zero when no spans are dropped.

## v0.2.5 Alpha

Alpha v0.2.5 of OpenTelemetry Collector.

- Regexp-based filtering of spans based on service names.
- Ability to choose strict or regexp matching for include/exclude filters.

## v0.2.4 Alpha

Alpha v0.2.4 of OpenTelemetry Collector.

- Regexp-based filtering of span names.
- Ability to extract attributes from span names and rename span.
- File exporter for debugging.
- Span processor is now enabled by default.

## v0.2.3 Alpha

Alpha v0.2.3 of OpenTelemetry Collector.

Changes:
21a70d6 Add a memory limiter processor (#498)
9778b16 Refactor Jaeger Receiver config (#490)
ec4ad0c Remove workers from OpenCensus receiver implementation (#497)
4e01fa3 Update k8s config to use opentelemetry docker image and configuration (#459)

## v0.2.2 Alpha

Alpha v0.2.2 of OpenTelemetry Collector.

Main changes visible to users since previous release:

- Improved Testbed and added more E2E tests.
- Made component interfaces more uniform (this is a breaking change).

Note: v0.2.1 never existed and is skipped since it was tainted in some dependencies.

## v0.2.0 Alpha

Alpha v0.2 of OpenTelemetry Collector.

Docker image: omnition/opentelemetry-collector:v0.2.0 (we are working on getting this under an OpenTelemetry org)

Main changes visible to users since previous release:

- Rename from `service` to `collector`, the binary is now named `otelcol`

- Configuration reorganized and using strict mode

- Concurrency issues for pipelines transforming data addressed

Commits:

```terminal
0e505d5 Refactor config: pipelines now under service (#376)
402b80c Add Capabilities to Processor and use for Fanout cloning decision (#374)
b27d824 Use strict mode to read config (#375)
d769eb5 Fix concurrency handling when data is fanned out (#367)
dc6b290 Rename all github paths from opentelemtry-service to opentelemetry-collector (#371)
d038801 Rename otelsvc to otelcol (#365)
c264e0e Add Include/Exclude logic for Attributes Processor (#363)
8ce427a Pin a commit for Prometheus dependency in go.mod (#364)
2393774 Bump Jaeger version to 1.14.0 (latest) (#349)
63362d5 Update testbed modules (#360)
c0e2a27 Change dashes to underscores to separate words in config files (#357)
7609eaa Rename OpenTelemetry Service to Collector in docs and comments (#354)
bc5b299 Add common gRPC configuration settings (#340)
b38505c Remove network access popups on macos (#348)
f7727d1 Fixed loop variable pointer bug in jaeger translator (#341)
958beed Ensure that ConsumeMetricsData() is not passed empty metrics in the Prometheus receiver (#345)
0be295f Change log statement in Prometheus receiver from info to debug. (#344)
d205393 Add Owais to codeowners (#339)
8fa6afe Translate OC resource labels to Jaeger process tags (#325)
```

## v0.0.2 Alpha

Alpha release of OpenTelemetry Service.

Docker image: omnition/opentelemetry-service:v0.0.2 (we are working on getting this under an OpenTelemetry org)

Main changes visible to users since previous release:

```terminal
8fa6afe Translate OC resource labels to Jaeger process tags (#325)
047b0f3 Allow environment variables in config (#334)
96c24a3 Add exclude/include spans option to attributes processor (#311)
4db0414 Allow metric processors to be specified in pipelines (#332)
c277569 Add observability instrumentation for Prometheus receiver (#327)
f47aa79 Add common configuration for receiver tls (#288)
a493765 Refactor extensions to new config format (#310)
41a7afa Add Span Processor logic
97a71b3 Use full name for the metrics and spans created for observability (#316)
fed4ed2 Add support to record metrics for metricsexporter (#315)
5edca32 Add include_filter configuration to prometheus receiver (#298)
0068d0a Passthrough CORS allowed origins (#260)
```

## v0.0.1 Alpha

This is the first alpha release of OpenTelemetry Service.

Docker image: omnition/opentelemetry-service:v0.0.1

[v0.3.0]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.10...v0.3.0
[v0.2.10]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.8...v0.2.10
[v0.2.8]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.7...v0.2.8
[v0.2.7]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.6...v0.2.7
[v0.2.6]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.5...v0.2.6
[v0.2.5]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.4...v0.2.5
[v0.2.4]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.3...v0.2.4
[v0.2.3]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.2...v0.2.3
[v0.2.2]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.2.0...v0.2.2
[v0.2.0]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.0.2...v0.2.0
[v0.0.2]: https://github.com/open-telemetry/opentelemetry-collector/compare/v0.0.1...v0.0.2
[v0.0.1]: https://github.com/open-telemetry/opentelemetry-collector/tree/v0.0.1
