07 May 2020

#### Automatic host endpoint management

Calico v3.14 provides a new controller for automatically managing HostEndpoints for your Kubernetes nodes. This makes it easy to use Calico’s host policy enforcement features in dynamic environments where cluster nodes may come and go - for example, AWS instance auto scaling groups.

Related PRs:

 - kube-controllers can now automatically provision host endpoints for nodes in the cluster. [kube-controllers #458](https://github.com/projectcalico/kube-controllers/pull/458) (@lmm)
 - Add a new Profile with allow-all rules named `projectcalico-default-allow`. This profile can be used in host endpoints to provide default-allow in the absence of policy. [libcalico-go #1207](https://github.com/projectcalico/libcalico-go/pull/1207) (@lmm)
 - Configure automatic host endpoints to use the default allow profile [kube-controllers #470](https://github.com/projectcalico/kube-controllers/pull/470) (@lmm)

#### Even more host endpoint policy

Calico host endpoints come in two flavors - interface-specific host endpoints which represent a single interface on a node, or wildcard host endpoints which represent all interfaces on the node. To-date, wildcard host endpoints have supported only pre-DNAT global network policies. In Calico v3.14, we’ve extended support to include other policy types as well, enabling you to more easily apply network policy to your hosts. Combined with the automatic provisioning of host endpoints discussed above, this enables a simple and powerful way to protect both Kubernetes pods and hosts using Calico’s unified policy model.

Note that this feature includes a change to the default behavior for wildcard host endpoints - make sure to read the upgrade documentation if you are currently using wildcard host endpoints in your cluster.

Related PRs:

 - Host endpoints with wildcard interface names now support normal network policy in addition to pre-dnat policy [felix #2228](https://github.com/projectcalico/felix/pull/2228) (@lmm)

#### Encryption using Wireguard technology preview

We’re really excited to share that Calico v3.14 includes the ability to enable host-to-host encryption for pod traffic using Wireguard. While it’s not yet ready for production due to a few gaps and limited testing, it’s a great preview of what’s to come and we’ll be working hard to promote this feature to GA in future releases.

Related PRs:

 - Added Wireguard configuration. [libcalico-go #1215](https://github.com/projectcalico/libcalico-go/pull/1215) (@realgaurav)

#### Configure and monitor IP borrowing

Calico will handle dynamically borrowing addresses from other nodes in order to maximize usage of the IP address space. However, there are times when this behavior is not desirable. For example, if your network infrastructure does not allow advertisement of the resulting /32 routes.

In Calico v3.14, you can now disable IP borrowing by enabling strict IP affinity using calicoctl. You can also use calicoctl to see what, if any, addresses have been borrowed from other nodes.

#### Bug fixes

 - Fix incorrect check of CIDR block size in node startup script. [node #468](https://github.com/projectcalico/node/pull/468) (@tmjd)
 - Release tunnel IP addresses more safely [node #443](https://github.com/projectcalico/node/pull/443) (@caseydavenport)
 - Properly release tunnel addresses even if node object was improperly modified. [node #436](https://github.com/projectcalico/node/pull/436) (@caseydavenport)
 - Fix potential tunnel address leak when upgrading from Calico < v3.6 to Calico  >= v3.8 [node #430](https://github.com/projectcalico/node/pull/430) (@caseydavenport)
 - Exclude kube-ipvs0 from bird routing to reduce CPU usage on node [confd #314](https://github.com/projectcalico/confd/pull/314) (@spikecurtis)
 - Fix IPAM garbage collection in etcd mode on clusters where node name does not match Kubernetes node name. [kube-controllers #467](https://github.com/projectcalico/kube-controllers/pull/467) (@caseydavenport)
 - Fix kube-controllers attempting to clean up non-existent node resources [kube-controllers #461](https://github.com/projectcalico/kube-controllers/pull/461) (@fcuello-fudo)
 - Fix shell stderr redirection in CNI installation script [cni-plugin #842](https://github.com/projectcalico/cni-plugin/pull/842) (@hanxueluo)
 - Use mv to place CNI binaries instead of cp to avoid conflict with running processes [cni-plugin #849](https://github.com/projectcalico/cni-plugin/pull/849) (@caseydavenport)
 - Fix missing hostname binary on ubi-minimal [cni-plugin #848](https://github.com/projectcalico/cni-plugin/pull/848) (@lmm)

#### Other changes

BPF dataplane technology preview improvements:

 - In BPF mode, fix that RPF check was bypassed for traffic to local workloads behind a nodeport. [felix #2283](https://github.com/projectcalico/felix/pull/2283) (@tomastigera)
 - In BPF mode, fix some corner cases in conntrack whitelisting and add additional tests. [felix #2281](https://github.com/projectcalico/felix/pull/2281) (@tomastigera)
 - In BPF mode, upgrade from the previous version may result in connections being silently dropped.  This is due to adjusting the format of the connection tracking BPF map. [felix #2277](https://github.com/projectcalico/felix/pull/2277) (@tomastigera)
 - In BPF mode, fix source address of encapped node port packet when it should differ from original ingress IP [felix #2296](https://github.com/projectcalico/felix/pull/2296) (@fasaxc)
 - Felix now checks the kernel version before enabling BPF mode. [felix #2288](https://github.com/projectcalico/felix/pull/2288) (@fasaxc)
 - In BPF mode, Felix now sets the kernel.unprivileged_bpf_disabled sysctl by default to restrict access to the BPF syscall.  This behaviour is controlled by the BPFDisableUnprivileged configuration parameter. [felix #2261](https://github.com/projectcalico/felix/pull/2261) (@fasaxc)
 - The MTU used by the BPF programs when sending ICMP TOO BIG messages in order to control path MTU is now configured by the VXLANMTU configuration parameter. [felix #2251](https://github.com/projectcalico/felix/pull/2251) (@tomastigera)
 - In BPF mode, fix lack of FIB lookup due to using incorrect endianess. [felix #2250](https://github.com/projectcalico/felix/pull/2250) (@tomastigera)
 - The BPF dataplane now handles ICMP error messages as "related" traffic so that they follow the same path back through the dataplane as the packet they respond to. This improves compatibility with path MTU detection and other non-mainline traffic. [felix #2247](https://github.com/projectcalico/felix/pull/2247) (@tomastigera)
 - In BPF dataplane mode, Felix now handles single-block IPAM pools.  Previously single-block pools resulted in a collision when programming the dataplane routes. [felix #2245](https://github.com/projectcalico/felix/pull/2245) (@fasaxc)
 - Fix GSO handling on the host side of NP [felix #2232](https://github.com/projectcalico/felix/pull/2232) (@tomastigera)
 - Fix FIB lookup for NP tunnels and ICMP error replies [felix #2233](https://github.com/projectcalico/felix/pull/2233) (@tomastigera)
 - Felix can now calculate routes without dependency on Calico IPAM. [felix #2269](https://github.com/projectcalico/felix/pull/2269) (@caseydavenport)

Openstack improvements:

 - Allow DHCP from the workload, on kernels where rp_filter doesn't already [felix #2231](https://github.com/projectcalico/felix/pull/2231) (@neiljerram)

API Changes:

 - Introduce a new KubeControllersConfiguration API resource [libcalico-go #1203](https://github.com/projectcalico/libcalico-go/pull/1203) (@spikecurtis)
 - Add FelixConfiguration option for setting route information source [libcalico-go #1222](https://github.com/projectcalico/libcalico-go/pull/1222) (@caseydavenport)

Misc:

 - Update image to pull in latest CVE fixes. [node #460](https://github.com/projectcalico/node/pull/460) (@lmm)
 - Change ppc64le base image from debian slim to UBI [cni-plugin #846](https://github.com/projectcalico/cni-plugin/pull/846) (@DomDeMarc)
 - Run health checks in parallel [node #423](https://github.com/projectcalico/node/pull/423) (@stamm)
 - Automatically adjust chosen pod CIDR if the default conflicts with the host network [node #421](https://github.com/projectcalico/node/pull/421) (@mhmxs)
 - Kubernetes network tutorials updated for v1.18. [calico #3447](https://github.com/projectcalico/calico/pull/3447) (@tmjd)
 - Enable creation of Calico API objects at cluster creation time for OpenShift [calico #3338](https://github.com/projectcalico/calico/pull/3338) (@tmjd)
