23 Nov 2020

#### MTU auto-detection

Calico v3.17.0 support automatic detection of host MTU and automatic configuration of pod network MTU based on your environment! Calico will now automatically determine the optimal MTU for new pods based on the underlying network MTU and enabled encapsulation methods, providing optimal network performance without the need for any manual configuration.

PRs:
 - Automatic MTU detection [felix #2511](https://github.com/projectcalico/felix/pull/2511) (@caseydavenport)
 - CNI plugin respects the /var/lib/calico/mtu file for picking pod MTU [cni-plugin #962](https://github.com/projectcalico/cni-plugin/pull/962) (@caseydavenport)
 - Add field to configure interfaces for MTU detection [libcalico-go #1331](https://github.com/projectcalico/libcalico-go/pull/1331) (@caseydavenport)

#### Windows BGP networking

Calico now support BGP networking when running on Windows nodes. The initial release of Calico for Windows included VXLAN networking only. In Calico v3.17.0, Windows nodes will

PRs:
 - Add BGP networking support for Calico for Windows. [node #588](https://github.com/projectcalico/node/pull/588) (@song-jiang)

#### Additional platform support for Windows nodes

During the Calico v3.17 release cycle, the Calico team invested in certifying Calico for Windows support for both OpenShift and Rancher clusters with Windows nodes.

#### Bug fixes

 - Fix DNS resolution in calico-node containers. [node #583](https://github.com/projectcalico/node/pull/583) (@NeonSludge)
 - Fix that Typha was unable to deduplicate Calico v3 Node resources.  This caused excessive CPU usage in Felix. [typha #454](https://github.com/projectcalico/typha/pull/454) (@fasaxc)
 - Felix now detects the error from iptables-save when it is run on a system with incompatible nft rules.  This prevents Felix from flooding the iptables NAT table with rules. [felix #2564](https://github.com/projectcalico/felix/pull/2564) (@fasaxc)
 - Fix Wireguard resync processing to properly track deltas [felix #2535](https://github.com/projectcalico/felix/pull/2535) (@robbrockbank)
 - Fix etcd backend watch errors [libcalico-go #1337](https://github.com/projectcalico/libcalico-go/pull/1337) (@robbrockbank)
 - Fix that, in eBPF mode, when using a non-Calico CNI (such as the AWS VPC CNI), the non-Calico CNI's SNAT rules could be skipped.  This fixes access from pods to non-cluster resources in EKS, for example. [felix #2531](https://github.com/projectcalico/felix/pull/2531) (@tomastigera)
 - Fix invalid parsing of some IPv6 addresses [libcalico-go #1275](https://github.com/projectcalico/libcalico-go/pull/1275) (@weizhouBlue)
 - Fix a bug that made the UPDATE_CNI_BINARIES environment variable not behave as expected. [cni-plugin #981](https://github.com/projectcalico/cni-plugin/pull/981) (@mgleung)
 - Fix a bug that prevented failed attempts at unlocking the datastore during IPAM migration from retrying. [cni-plugin #968](https://github.com/projectcalico/cni-plugin/pull/968) (@mgleung)
 - Fix a bug that caused IPAM assignment to throw a nil pointer exception in cases where tunnel address IP assignment failed. [cni-plugin #967](https://github.com/projectcalico/cni-plugin/pull/967) (@mgleung)
 - Fix that installing CNI plugin would fail if binaries were in use [cni-plugin #966](https://github.com/projectcalico/cni-plugin/pull/966) (@caseydavenport)
 - Fix population of etcd certificates in CNI config [cni-plugin #948](https://github.com/projectcalico/cni-plugin/pull/948) (@caseydavenport)
 - Fix Felix crash and set the health status to false when EC2 source-destination-check fails. [felix #2507](https://github.com/projectcalico/felix/pull/2507) (@realgaurav)
 - Fix that broadcast routes weren't filtered out of felix's list of local IPs.  In BPF mode, this caused dataplane route flaps. [felix #2495](https://github.com/projectcalico/felix/pull/2495) (@fasaxc)
 - Fix releasing of improperly formatted handles as a result of host-local IPAM migration bug. [libcalico-go #1346](https://github.com/projectcalico/libcalico-go/pull/1346) (@caseydavenport)
 - Fix that "deleted" was a required field [libcalico-go #1318](https://github.com/projectcalico/libcalico-go/pull/1318) (@caseydavenport)
 - Fix that deleting a node didn't release its wireguard tunnel address [libcalico-go #1310](https://github.com/projectcalico/libcalico-go/pull/1310) (@caseydavenport)
 - Fix to allow IPv6 floating IPs in a dual stack deployment. [cni-plugin #922](https://github.com/projectcalico/cni-plugin/pull/922) (@fionera)
 - Fix issue where Wireguard tunnel IPs on deleted nodes were not garbage collected [kube-controllers #512](https://github.com/projectcalico/kube-controllers/pull/512) (@caseydavenport)
 - Fix flannel migration for clusters with multiple control-plane nodes. [kube-controllers #496](https://github.com/projectcalico/kube-controllers/pull/496) (@caseydavenport)

#### Other changes

Notable behavior changes:

 - Default to Kubernetes datastore. This means calicoctl will default to using `DATASTORE_TYPE=kubernetes` [libcalico-go #1279](https://github.com/projectcalico/libcalico-go/pull/1279) (@frozenprocess)

Windows:

 - restore metadata route for GCE if missing [node #646](https://github.com/projectcalico/node/pull/646) (@lmm)
 - Enable automatic setting of etcd TLS config for Calico for Windows. [node #570](https://github.com/projectcalico/node/pull/570) (@lippertmarkus)

eBPF:

 - In eBPF mode, fix that long-lived connections to nodeports could be incorrectly cleaned up resulting in dropped connections, this particularly impacted AWS load balancers. [felix #2590](https://github.com/projectcalico/felix/pull/2590) (@fasaxc)
 - In eBPF mode, choose the backend randomly for service VIPs with service affinity enabled.  This ensures a more random distribution and good rebalancing (as expected by the k8s conformance tests). [felix #2538](https://github.com/projectcalico/felix/pull/2538) (@tomastigera)
 - In eBPF mode, disable bypass for connections that have moved from one interface to another, allowing the RPF check to be reset. [felix #2523](https://github.com/projectcalico/felix/pull/2523) (@tomastigera)
 - In eBPF mode, Calico now includes all Kubernetes Node IPs in its IP ownership calculations.  This means that NodePorts are honoured on all IPs. [felix #2508](https://github.com/projectcalico/felix/pull/2508) (@tomastigera)
 - In eBPF mode, use mark bits to refine use of accept_local. [felix #2491](https://github.com/projectcalico/felix/pull/2491) (@tomastigera)
 - In eBPF mode, Felix now checks that the mark bits used by the BPF programs are assigned to Felix.  Previously, it would use them without checking, possibly creating conflicts. [felix #2489](https://github.com/projectcalico/felix/pull/2489) (@fasaxc)

Application-layer policy:

 - Update ALP manifests to support Istio versions 1.7 and 1.6 [calico #4169](https://github.com/projectcalico/calico/pull/4169) (@realgaurav)
 - Updated ALP documentation to support recent Istio versions (v1.7 and v1.6). [calico #4141](https://github.com/projectcalico/calico/pull/4141) (@realgaurav)

General:
 - Added monitor-addresses option to calico-node to continually monitor IP addresses. [node #549](https://github.com/projectcalico/node/pull/549) (@realgaurav)
 - Expand the regexes used to detect host interfaces to cover less common and development interfaces. [felix #2555](https://github.com/projectcalico/felix/pull/2555) (@fasaxc)
 - bpf/proxy: add info logging when Syncer iteration start/ends [felix #2497](https://github.com/projectcalico/felix/pull/2497) (@tomastigera)
 - Add knobs to explicitly disable adding drop rules for encapsulated packets originating from workloads. [felix #2484](https://github.com/projectcalico/felix/pull/2484) (@doublek)
 - Change iptables backend default from legacy to auto. [felix #2464](https://github.com/projectcalico/felix/pull/2464) (@tmjd)
 - Enable releasing block affinities even if pool has been deleted. [libcalico-go #1300](https://github.com/projectcalico/libcalico-go/pull/1300) (@caseydavenport)
 - Release affinities for all empty blocks on deleted nodes, even if some still have allocations. [libcalico-go #1299](https://github.com/projectcalico/libcalico-go/pull/1299) (@caseydavenport)
 - Support global configuration for max blocks per node [libcalico-go #1297](https://github.com/projectcalico/libcalico-go/pull/1297) (@caseydavenport)
 - Add FelixConfiguration parameters to explicitly allow encapsulated packets from workloads. [libcalico-go #1296](https://github.com/projectcalico/libcalico-go/pull/1296) (@doublek)
 - Change Unicode apostrophe in API comments to ASCII apostrophe [libcalico-go #1289](https://github.com/projectcalico/libcalico-go/pull/1289) (@neiljerram)
 - Calico can now program ECMP routes into its local kernel, if its BGP daemon (BIRD) learns about a prefix via equally good paths from multiple peers. [confd #379](https://github.com/projectcalico/confd/pull/379) (@misi)
 - apply keepOriginalNextHop to global peerings as well [confd #358](https://github.com/projectcalico/confd/pull/358) (@neiljerram)
 - Prevent routing loops to unused service IPs, when [service IP advertisement is enabled](https://docs.projectcalico.org/networking/advertise-service-ips). [calico #4104](https://github.com/projectcalico/calico/pull/4104) (@neiljerram)
 - It's now possible to specify a password on a BGPPeer resource, and the password will be used to authenticate the peer on BGP sessions generated by that resource. [calico #4033](https://github.com/projectcalico/calico/pull/4033) (@neiljerram)
