30 Apr 2021

#### VPP data plane (tech-preview)

We’re very excited to announce that Calico v3.19 includes tech-preview support for FD.io’s Vector Packet Processing (VPP) data plane, joining Calico’s existing iptables, eBPF, and Windows dataplanes. 

The VPP data plane promises high performance Kubernetes networking with support for network policy, encryption via Wireguard or IPSec, and MagLev service load balancing. 

Interested? Try it out by following the [tech-preview getting started guide](https://docs.projectcalico.org/archive/v3.19/getting-started/kubernetes/vpp/)!

#### Resource management with kubectl (tech-preview)

In previous versions of Calico, the “calicoctl” command line tool was required to properly manage Calico API resources. In Calico v3.19, we’ve introduced a new tech-preview feature that allows you to manage all projectcalico.org API resources directly with kubectl using an optional API server addon.

Try it out on your cluster by [following the guide](https://docs.projectcalico.org/archive/v3.19/getting-started/kubernetes/apiserver-preview)!

#### Windows data plane support for containerd

Calico v3.19 introduces support for Calico for Windows users to deploy containers using containerd in addition to the already supported Docker runtime.

The Calico for Windows quickstart guide has been updated to configure Calico for containerd. Try out the [quickstart guide](https://docs.projectcalico.org/archive/v3.19/getting-started/windows-calico/quickstart)!

**References**:
 - Windows packaging for containerd support [node #933](https://github.com/projectcalico/node/pull/933) (@lmm)

#### Bug fixes

**General**:
 - Fix issue with where pushed node images were not expanded correctly with the common Makefile [node #935](https://github.com/projectcalico/node/pull/935) (@fasaxc)
 - Fixes a bug where IPv6 networks were not handled properly by the failsafe rules [felix #2742](https://github.com/projectcalico/felix/pull/2742) (@mgleung)
 - Fix support for Kubernetes named ports with SCTP. [libcalico-go #1399](https://github.com/projectcalico/libcalico-go/pull/1399) (@fasaxc)
 - When interpreting Kubernetes NetworkPolicy ports, Calico now interprets an empty port struct as "all TCP" as per the NetworkPolicy spec.  Previously, empty structs were ignored. [libcalico-go #1370](https://github.com/projectcalico/libcalico-go/pull/1370) (@mattfenwick)
 - IPPool CIDR permits ipv6 full representation and ipv4 with host bit set. [libcalico-go #1369](https://github.com/projectcalico/libcalico-go/pull/1369) (@halfcrazy)
 - Properly report not found when WorkloadEndpoint doesn't exist. Fixes https://github.com/projectcalico/calico/issues/4235 [libcalico-go #1363](https://github.com/projectcalico/libcalico-go/pull/1363) (@tommasopozzetti)
 - Fix concurrent map access bug in confd [confd #479](https://github.com/projectcalico/confd/pull/479) (@caseydavenport)
 - Fix concurrent map access panic in kube-controllers [kube-controllers #669](https://github.com/projectcalico/kube-controllers/pull/669) (@caseydavenport)
 - Fix potential memory-leak in kube-controllers [kube-controllers #641](https://github.com/projectcalico/kube-controllers/pull/641) (@caseydavenport)

**eBPF data plane**:
 - [eBPF] Fix sctp named port handling [felix #2771](https://github.com/projectcalico/felix/pull/2771) (@sridhartigera)
 - In BPF mode: Fix that changing the type of a service or having multiple services with overlapping external IPs would result in incorrect load balancing, even after the overlap was resolved. [felix #2770](https://github.com/projectcalico/felix/pull/2770) (@fasaxc)
 - Fix externalTrafficPolicy for LB services in eBPF data plane [felix #2686](https://github.com/projectcalico/felix/pull/2686) (@caseydavenport)
 - Fix that, in eBPF mode, a Log rule would result in an error instead of being ignored.  Log rules are not supported but they should be ignored, not cause a failure. [felix #2683](https://github.com/projectcalico/felix/pull/2683) (@fasaxc)
 - Fix that, in eBPF mode, a Log rule would result in an error instead of being ignored.  Log rules are not supported but they should be ignored, not cause a failure. [felix #2682](https://github.com/projectcalico/felix/pull/2682) (@fasaxc)

#### Other changes

**General**:
 - Bump UBI from 8.1 to 8.3 [node #885](https://github.com/projectcalico/node/pull/885) (@PushkarJ)
 - Update ipables version to 1.8.4-15 [node #813](https://github.com/projectcalico/node/pull/813) (@Brian-McM)
 - Fix that, after a netlink read failure, Felix would tight loop reading from a closed channel.  Restart the event poll in that case. [felix #2710](https://github.com/projectcalico/felix/pull/2710) (@fasaxc)
 - Prevent looping through a service external IP when traffic is sent to the wrong port for the external IP. [felix #2690](https://github.com/projectcalico/felix/pull/2690) (@neiljerram)
 - FailsafeInboundHostPorts & FailsafeOutboundHostPorts now support restricting to specific cidrs. New format <protocol>:<net>:<port> [felix #2646](https://github.com/projectcalico/felix/pull/2646) (@kgtw)
 - calicoctl will no longer display Kubernetes network polices when operating in KDD mode [libcalico-go #1398](https://github.com/projectcalico/libcalico-go/pull/1398) (@caseydavenport)
 - CHANGE REVERTED: Fix that Felix would incorrectly treat any deleted pod as immediately finished.  This meant that pods networked with non-Calico CNIs would not have connectivity in the termination grace period. [libcalico-go #1397](https://github.com/projectcalico/libcalico-go/pull/1397) (@fasaxc)
 - Reduce log level on spammy logs in host-local IPAM mode [libcalico-go #1374](https://github.com/projectcalico/libcalico-go/pull/1374) (@caseydavenport)
 - By default, limit each node to 20 IP address blocks. This value can be overridden through IPAM configuration. [libcalico-go #1368](https://github.com/projectcalico/libcalico-go/pull/1368) (@caseydavenport)
 - Kubernetes Network Policy EndPort is now supported [libcalico-go #1357](https://github.com/projectcalico/libcalico-go/pull/1357) (@rikatz)
 - Add support for liveness probes in kube-controllers [kube-controllers #655](https://github.com/projectcalico/kube-controllers/pull/655) (@hakman)

**eBPF data plane**:
 - Add CIDRs to the failsafe rule handling in BPF. [felix #2769](https://github.com/projectcalico/felix/pull/2769) (@mgleung)
 - Introduce a new Felix configuration parameter that can be set to mark packets from external hosts to services.  This is useful for working around an incompatibility with the Amazon VPC CNI's source based routing rules.  In EKS, BPFExtToServiceConnmark should be set to 0x80. [felix #2767](https://github.com/projectcalico/felix/pull/2767) (@tomastigera)
 - [eBPF] Calculate ICMP csum as L4 not to confuse offloading [felix #2705](https://github.com/projectcalico/felix/pull/2705) (@tomastigera)
 - In eBPF mode, ensure that SYN retries to a NATted destination go to the same backing workload to prevent spurious RSTs after a SYN-ACK is lost. [felix #2675](https://github.com/projectcalico/felix/pull/2675) (@fasaxc)
 - [eBPF] For eBPF dataplane, fallback to Kubernetes Node IPs if none auto-detected [libcalico-go #1387](https://github.com/projectcalico/libcalico-go/pull/1387) (@sridhartigera)

**Windows**:
 - Add support for containerd to Windows [cni-plugin #1054](https://github.com/projectcalico/cni-plugin/pull/1054) (@lmm)

