---
title: Generating Certificates for etcd RBAC
canonical_url: https://docs.projectcalico.org/v3.2/reference/advanced/etcd-rbac/certificate-generation
---

The etcd datastore has the concept of users that are linked to roles, where
each role has a defined set of access permissions to the data stored in etcd.
This tutorial walks you through the process of generating the Certificate
Authority (CA), Certificates and Keys that can be used to authenticate a
specific user with etcd. There are many different tools that can be used to
generate these files. This tutorial tries to layout the unique or specific
details that are needed for each of the different certificates but uses the
[hack/tls-setup tool from the etcd repo](https://github.com/coreos/etcd/tree/master/hack/tls-setup),
to make certificate generation easy.

The etcd server links a certificate to a specific user by using the Common
Name (CN) attribute in the certificate. It is important to ensure that the CN
in the certificate for each component that will be accessing etcd match the
username in etcd that has the appropriate etcd roles for accessing its
required keys or paths.

### Using the hack/tls-setup tool

If you use hack/tls-setup too, ensure you have followed the README
and are able to run `make` successfully.

The directories of interest in tls-setup are `config` and `certs`.
As indicated by the names `config` is where the configuration files are that
are used in CA and certificate generation live and `certs` are where the
generated files are written.

Generating certificates with hack/tls-setup:
1. Edit the [etcd certificate config](#configuration-for-the-etcd-certificates).
2. Add the
   [per-user/per-component configuration files](#configuration-for-per-userper-components-etcd-certificates)
3. Run `make`. (Re-running `make` will regenerate the CA and all certificates.)

Generating the certificates creates:
- the CA
- a certificate and key pair for 3 etcd servers
- a certificate and key pair for etcd proxies
- the certificate and key pairs for each user/component

## Configuration for the Certificate Authority

The default CA configuration included with hack/tls-setup works well with no
additional configuration. The file `certs/ca.pem` generated will need to be
provided to all components (etcd, Kubernetes apiserver, and all calico
components).

## Configuration for the etcd certificates

Update the file `config/req-csr.json` by adding the IP addresses of the
servers that will be running the etcd members to the `"hosts"`
section. After generating the certs, three certs are created that can be
used for three etcd member servers (though just using one works, when testing).
These certificate and key files are `certs/etcd[123].pem` and
`certs/etcd[123]-key.pem` and a matching pair will need to be provided to
each etcd member.

If using etcd proxies, the cert/key pair generated by the tool
(the files `certs/proxy1.pem` and `certs/proxy1-key.pem`) can be used with all
proxies or you could create individual cert/key pairs for each proxy too.

## Configuration for per-user/per-component's etcd certificates

The certificates for Calico, Kubernetes, or any other component can be
generated with configuration files similar to the one provided below.
Replace the &lt;etcd_username&gt; placeholder with the username of the etcd user
that has roles allowing access to the paths/prefix keys required by the
associated component.

```
{ 
  "CN": "<etcd_username>",
  "hosts": [
    "localhost"
  ],
  "key": {
    "algo": "ecdsa",           
    "size": 384                
  },  
  "names": [
    { 
      "O": "autogenerated",    
      "OU": "etcd cluster",
      "L": "the internet"
    } 
  ]   
}
```

The additional configuration files you create should be added to the `config`
directory located in your hack/tls-setup folder. To build certificates for
each new configuration add lines similar to those below to
the `req:` target in the Makefile. For each configuration added, make sure the
configuration file name and cert/key file prefix are updated appropriately by
substituting an appropriate name for &lt;component&gt;.

```
    $(CFSSL) gencert \
      -ca certs/ca.pem \
      -ca-key certs/ca-key.pem \
      -config config/ca-config.json \
      config/req-<component>.json | $(JSON) -bare certs/<component>
```

Once the certificate and key files are generated they will need to be provided
to the proper component which is beyond the scope of this particular document.
See [this](kubernetes) for how to provide certificates to Kubernetes and Calico
components.

