30 Jul 2021

#### Service-based egress rules

Calico NetworkPolicy and GlobalNetworkPolicy now support egress rules which match on Kubernetes service names. Service matches in egress rules can be used to allow or deny access to in-cluster services, as well as services typically not backed by pods (for example, the Kubernetes API). Address and port information is learned from the individual endpoints within the service, making it easier to keep your network policy in-sync with your workloads.

Relevant PRs: 

 - Felix support for matching Kubernetes services in egress rules. [felix #2916](https://github.com/projectcalico/felix/pull/2916) (@caseydavenport)
 - Support for Services in NetworkPolicy egress rules [libcalico-go #1468](https://github.com/projectcalico/libcalico-go/pull/1468) (@caseydavenport)

#### Golang API

In Calico v3.19, we introduced a tech-preview API server which allows management of Calico resources directly with kubectl. In v3.20, we’re building upon that with a new Golang API for Calico! 

Install the API server and import the Golang API to manage Calico network policies and more, in your own applications!. See the [projectcalico/api](https://github.com/projectcalico/api) repository for more information.

#### Configurable BGP graceful restart timer

If you’re using BGP in your cluster, the graceful restart timer is used during rolling updates to ensure a graceful upgrade of Calico without disrupting network traffic. For large or heavily burdened clusters, sometimes an update of a particular node can take longer than the 2 minutes BGP typically allows due to load on the Kubernetes control plane. Calico v3.20 now allows configuration of the BGP graceful restart timer to better work in these scenarios. 

See the `maxRestartTime` configuration option in the BGPPeer API.

Relevant PRs:

 - Add support for configuring the BGP graceful restart timer [confd #543](https://github.com/projectcalico/confd/pull/543) (@coutinhop)

#### BPF mode support for DoNotTrack policy for DoS prevention

Calico’s eBPF dataplane has not previously supported any DoNotTrack policy.  Calico v3.20 adds tech preview support for a specific subset of DoNotTrack policy, using XDP to implement that. The specific subset is any DoNotTrack ingress deny policy, i.e. policy whose effect is only to drop certain traffic on ingress, and is useful for preventing denial of service attacks from known malicious IPs.  More general DoNotTrack policy support, for the eBPF dataplane, is in progress and should arrive in a subsequent release in the near future.

Relevant PRs:

 - Use XDP to implement untracked deny policies in BPF mode. [felix #2905](https://github.com/projectcalico/felix/pull/2905) (@neiljerram)

#### Bug fixes

 - Fix that calico/node would fail to set NetworkUnavailable to false for etcd clusters with mismatched node names. [node #944](https://github.com/projectcalico/node/pull/944) (@caseydavenport)
 - Stop ARP traffic being dropped due to RPF check [felix #2820](https://github.com/projectcalico/felix/pull/2820) (@mikestephen)
 - Fix that, with Wireguard enabled, felix would delete and re-add the Wireguard routing rule every 90 seconds causing occasional dropped packets. [felix #2818](https://github.com/projectcalico/felix/pull/2818) (@mikestephen)
 - Disable VXLAN tunnel checksum offload on kernels < v5.7.  Works around https://github.com/projectcalico/calico/issues/3145. [felix #2811](https://github.com/projectcalico/felix/pull/2811) (@fasaxc)
 - Improve routing loop prevention to handle when advertising Service LoadBalancer IPs [felix #2798](https://github.com/projectcalico/felix/pull/2798) (@caseydavenport)
 - Retry setting AWS EC2 source/destination check until successful. [felix #2795](https://github.com/projectcalico/felix/pull/2795) (@hjiawei)
 - Install blackhole routes in VXLAN mode. [felix #2696](https://github.com/projectcalico/felix/pull/2696) (@electricjesus)
 - Fix that podIP annotation could be incorrectly clobbered for stateful set pods: https://github.com/projectcalico/calico/issues/4710 [libcalico-go #1481](https://github.com/projectcalico/libcalico-go/pull/1481) (@fasaxc)
 - Reinstates logic that falls back to the status of the pod during termination if the pod IP annotation is not set by the Calico CNI plugin. [libcalico-go #1446](https://github.com/projectcalico/libcalico-go/pull/1446) (@song-jiang)
 - Fix issue with serviceaccount names larger than 63 characters. [libcalico-go #1422](https://github.com/projectcalico/libcalico-go/pull/1422) (@caseydavenport)
 - Fix error parsing pod deletion updates in kube-controllers [kube-controllers #707](https://github.com/projectcalico/kube-controllers/pull/707) (@caseydavenport)

#### Other changes

**General**

 - Enable management of CNI plugins by default [node #1008](https://github.com/projectcalico/node/pull/1008) (@caseydavenport)
 - calico/node marks nodes with NetworkUnavailable=true on shutdown [node #993](https://github.com/projectcalico/node/pull/993) (@song-jiang)
 - Typha now gives newly connected clients an extra grace period to catch up after sending the snapshot.  Should reduce the possibility of cyclic disconnects. [typha #619](https://github.com/projectcalico/typha/pull/619) (@fasaxc)
 - Wireguard MTU calculation on AKS and ANI allows for underlying network [felix #2840](https://github.com/projectcalico/felix/pull/2840) (@mikestephen)
 - Add basic Wireguard prometheus statistics [felix #2853](https://github.com/projectcalico/felix/pull/2853) (@electricjesus)
 - Wireguard is now compatible with the AKS CNI plugin.  This requires Felix's RouteSource configuration parameter to be set to "WorkloadIPs".  In "workload IP" mode, Wireguard now encrypts all traffic between Calico hosts themselves as well as traffic between Calico hosts and remote pods. [felix #2781](https://github.com/projectcalico/felix/pull/2781) (@mikestephen)
 - Added enhanced error logging for IPAM failures [libcalico-go #1436](https://github.com/projectcalico/libcalico-go/pull/1436) (@coutinhop)
 - Add IPAM GC LeakGracePeriod configuration. [libcalico-go #1429](https://github.com/projectcalico/libcalico-go/pull/1429) (@caseydavenport)
 - Add IP address garbage collection to kube-controllers [kube-controllers #744](https://github.com/projectcalico/kube-controllers/pull/744) (@caseydavenport)
 - Calico will now release empty IPAM blocks from nodes that no longer need them so they can be used elsewhere. [kube-controllers #799](https://github.com/projectcalico/kube-controllers/pull/799) (@caseydavenport)
 - Remove dependence on unmaintained UUID library. [libcalico-go #1427](https://github.com/projectcalico/libcalico-go/pull/1427) (@fasaxc)
 - Adds support for the Envoy v3 API. [app-policy #172](https://github.com/projectcalico/app-policy/pull/172) (@AtkinsChang)
 - Add support for Istio 1.9 and 1.10 [calico #4742](https://github.com/projectcalico/calico/pull/4742) (@mgleung)
 - Adds a helm index to the docs.  Helm users can now install by running `helm repo add projectcalico https://docs.projectcalico.org/charts` and `helm install calico projectcalico/tigera-operator --version=<version>` [calico #4629](https://github.com/projectcalico/calico/pull/4629) (@lwr20)
 - Mount CNI plugin directory into calico/node to enable configuration updates. [calico #4655](https://github.com/projectcalico/calico/pull/4655) (@caseydavenport)

**Windows dataplane**:

 - [Windows] Create VXLAN tunnel address in node - previously this was done in cni-plugin when the first pod is set up [node #1064](https://github.com/projectcalico/node/pull/1064) (@lmm)
 - [Windows] Disable IPv6DualStack in VXLAN mode [node #1018](https://github.com/projectcalico/node/pull/1018) (@lmm)

**BPF dataplane**:
 - In eBPF mode, disable Felix's BPF map repinning logic by default. This logic was intended to avoid the need to mount the BPF filesystem into the calico/node container but it was flawed because program maps are emptied by the kernel when they are not pinned. [felix #2827](https://github.com/projectcalico/felix/pull/2827) (@neiljerram)
 - Reduce log spam from eBPF dataplane and add eBPF dataplane components to loop summary. [felix #2812](https://github.com/projectcalico/felix/pull/2812) (@fasaxc)
