28 Jan 2022

#### Repository restructuring

Calico has moved to a monorepo appraoch to code and release management. All Calico code is now hosted in the github.com/projectcalico/calico
repository on GitHub. This allows for much improved development and release environment. Note that some release artifacts such as calicoctl have been moved to this new location
and will no longer be hosted at the now-depreacted micro-repos.

You can find the artifacts in their new location [on the Calico GitHub](https://github.com/projectcalico/calico/releases/tag/v3.22.0)

#### Convert Kubernetes NetworkPolicy objects to Calico NetworkPolicies

You can now use calicoctl to convert Kubernetes policies directly to their equivalent representation in the projectcalico.org/v3 API. This allows you
to enhance existing policies to make use of the extended Calico NetworkPolicy API feature set without needing to manually translate between API
representations.

Pull requests:

 - 'calicoctl convert' can now be used to convert NetworkPolicy resources from Kubernetes API into Calico v3 API [calico #5307](https://github.com/projectcalico/calico/pull/5307) (@coutinhop)

#### Bug fixes

**General**

 - Fix a serious regression introduced in v3.21 where the datastore watcher could get stuck and report stale information in clusters with >500 policies/pods/etc.  The bug was triggered by needing to do a resync (for example after an etcd compaction) when there were enough resources to trigger the list pager. [calico #5324](https://github.com/projectcalico/calico/pull/5324) (@fasaxc)
 - Add newline to the end of some log lines that were missing it [node #1349](https://github.com/projectcalico/node/pull/1349) (@ripta)
 - Fix potential panic and memory leak in kube-controllers caused by adding and subsequently deleting IPAM blocks [kube-controllers #911](https://github.com/projectcalico/kube-controllers/pull/911) (@caseydavenport)
 - IPAM GC correctly handles multiple IP addresses allocated with the same handle ID. [kube-controllers #901](https://github.com/projectcalico/kube-controllers/pull/901) (@caseydavenport)
 - Enable GC of IPAM blocks which no longer belong to an active IP pool [libcalico-go #1549](https://github.com/projectcalico/libcalico-go/pull/1549) (@caseydavenport)
 - Fix that the IPAM garbage collector could not release blocks that did not belong to active IP pools. [calico #5319](https://github.com/projectcalico/calico/pull/5319) (@caseydavenport)
 - Fix bug where invalid port structures were being sent to Felix, preventing pods with hostPorts specified from working. [libcalico-go #1544](https://github.com/projectcalico/libcalico-go/pull/1544) (@caseydavenport)
 - Dikastes: use gRPC graceful shutdown to exit cleanly after getting signal [calico #5210](https://github.com/projectcalico/calico/pull/5210) (@nohajc)

**eBPF dataplane**

 - Fixed race when creating bpf maps that prevented loading bpf programs. [calico #5511](https://github.com/projectcalico/calico/pull/5511) (@sridhartigera)
 - Fix application of the iptables-mode XDP DoS protection program on devices that support driver mode. [calico #5330](https://github.com/projectcalico/calico/pull/5330) (@fasaxc)
 - Reattach programs when their configuration changes [felix #3073](https://github.com/projectcalico/felix/pull/3073) (@tomastigera)
 - Avoid mixing of CTLB and regular NAT in eBPF [felix #3069](https://github.com/projectcalico/felix/pull/3069) (@tomastigera)

#### Other changes

**General**

 - New autodetection method KubernetesInternalIP added [node #1242](https://github.com/projectcalico/node/pull/1242) (@hanamantagoudvk)
 - Dual-stack support for host-local IPAM [calico #5313](https://github.com/projectcalico/calico/pull/5313) (@manuelbuil)
 - Increase timeout for setting NetworkUnavailable on shutdown [node #1336](https://github.com/projectcalico/node/pull/1336) (@song-jiang)
 - Felix now has a LogDebugFilenameRegex config parameter that allows debug logs to be filtered by filename. [felix #3093](https://github.com/projectcalico/felix/pull/3093) (@fasaxc)
 - When generating iptables chains for network policies, Felix now adds a comment to the first rule in the chain with the name of the policy. [felix #3088](https://github.com/projectcalico/felix/pull/3088) (@fasaxc)
 - Reduce log level on cyclic wireguard logs [felix #3078](https://github.com/projectcalico/felix/pull/3078) (@caseydavenport)
 - Align handling ExternalTrafficPolicy=Local with legacy kube-proxy - apply it only to external traffic. Enable InternalTrafficPolicy. [felix #3076](https://github.com/projectcalico/felix/pull/3076) (@tomastigera)
 - Restrict Typha server to FIPS compliant cipher suites. [typha #694](https://github.com/projectcalico/typha/pull/694) (@caseydavenport)
 - Restrict Calico API server to FIPS compliant cipher suites. https://github.com/golang/go/blob/dev.boringcrypto.go1.13/src/crypto/tls/boring.go [calico #5448](https://github.com/projectcalico/calico/pull/5448) (@strigie)
 - Remove remaining references to unsupported and out-of-date GoBGP backend [calico #5479](https://github.com/projectcalico/calico/pull/5479) (@robbrockbank)
 - Bump UBI base image to 8.5 for all images [calico #5468](https://github.com/projectcalico/calico/pull/5468) (@coutinhop)
 - Handle client creation errors in `calicoctl version`, and print appropriate message [calico #5455](https://github.com/projectcalico/calico/pull/5455) (@turekt)
 - Automatic host endpoints now detect internal IPs from the Kubernetes Node API [calico #5405](https://github.com/projectcalico/calico/pull/5405) (@coutinhop)
 - Allow specification of block size when performing a flannel to Calico migration [calico #5329](https://github.com/projectcalico/calico/pull/5329) (@sooheng)
 - Add debug memory profiling capabilities to kube-controllers [calico #5316](https://github.com/projectcalico/calico/pull/5316) (@caseydavenport)

**helm chart**

 - Add sources to helm chart [calico #5451](https://github.com/projectcalico/calico/pull/5451) (@EugenMayer)

**eBPF dataplane**

 - Calico's BPF programs are now dual Apache/GPL licensed to facilitate code sharing with Felix. [felix #3068](https://github.com/projectcalico/felix/pull/3068) (@fasaxc)
 - When CTLB is enabled, UDP packets from a source targeting a service stick to the same destination and are no longer distributed to random backends. [felix #3067](https://github.com/projectcalico/felix/pull/3067) (@tomastigera)
 - Improve handling of connections that reuse the same TCP source/dest tuple.  Detect reuse and treat as new connection. [calico #5308](https://github.com/projectcalico/calico/pull/5308) (@tomastigera)

**VPP dataplane**

 - VPP dataplane instructions now use operator-based install [calico #5362](https://github.com/projectcalico/calico/pull/5362) (@AloysAugustin)

**OpenStack**

 - When running with OpenStack, avoid a spurious error at start of day about cleaning up non-existent BPF state. [felix #3034](https://github.com/projectcalico/felix/pull/3034) (@neiljerram)
