---
title: BGP peer
description: API for this Calico resource.
canonical_url: '/reference/resources/bgppeer'
---

A BGP peer resource (`BGPPeer`) represents a remote BGP peer with
which the node(s) in a {{site.prodname}} cluster will peer.
Configuring BGP peers allows you to peer a {{site.prodname}} network
with your datacenter fabric (e.g. ToR). For more
information on cluster layouts, see {{site.prodname}}'s documentation on
[{{site.prodname}} over IP fabrics]({{ site.baseurl }}/reference/architecture/design/l3-interconnect-fabric).

### Sample YAML

```yaml
apiVersion: projectcalico.org/v3
kind: BGPPeer
metadata:
  name: some.name
spec:
  node: rack1-host1
  peerIP: 192.168.1.1
  asNumber: 63400
```

### BGP peer definition

#### Metadata

| Field       | Description                 | Accepted Values   | Schema |
|-------------|-----------------------------|-------------------|--------|
| name     | Unique name to describe this resource instance. Must be specified.| Alphanumeric string with optional `.`, `_`, or `-`. | string |

#### Spec

| Field                    | Description                                                                                                                                                                                                                                                                                                                                                                                        | Accepted Values                                                                             | Schema                            | Default                                                           |
|--------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------|-----------------------------------|-------------------------------------------------------------------|
| node                     | If specified, the scope is node level, otherwise the scope is global.                                                                                                                                                                                                                                                                                                                              | The hostname of the node to which this peer applies.                                        | string                            |                                                                   |
| peerIP                   | The IP address of this peer and an optional port number. If port number is not set, and peer is Calico node with `listenPort` set, then `listenPort` is used.                                                                                                                                                                                                                                      | Valid IPv4 or IPv6 address. If port number is set use, `IPv4:port` or `[IPv6]:port` format. | string                            |                                                                   |
| asNumber                 | The remote AS Number of the peer.                                                                                                                                                                                                                                                                                                                                                                  | A valid AS Number, may be specified in dotted notation.                                     | integer/string                    |
| nodeSelector             | Selector for the nodes that should have this peering.  When this is set, the `node` field must be empty.                                                                                                                                                                                                                                                                                           |                                                                                             | [selector](#selectors)            |
| peerSelector             | Selector for the remote nodes to peer with.  When this is set, the `peerIP` and `asNumber` fields must be empty.                                                                                                                                                                                                                                                                                   |                                                                                             | [selector](#selectors)            |
| keepOriginalNextHop      | Maintain and forward the original next hop BGP route attribute to a specific Peer within a different AS.                                                                                                                                                                                                                                                                                           |                                                                                             | boolean                           |
| password                 | BGP password for the peerings generated by this BGPPeer resource.                                                                                                                                                                                                                                                                                                                                  |                                                                                             | [BGPPassword](#bgppassword)       | `nil` (no password)                                               |
| sourceAddress            | Specifies whether and how to configure a source address for the peerings generated by this BGPPeer resource.  Default value "UseNodeIP" means to configure the node IP as the source address.  "None" means not to configure a source address.                                                                                                                                                     | "UseNodeIP", "None"                                                                         | string                            | "UseNodeIP"                                                       |
| maxRestartTime           | Restart time that is announced by BIRD in the BGP graceful restart capability and that specifies how long the neighbor would wait for the BGP session to re-establish after a restart before deleting stale routes. Note: extra care should be taken when changing this configuration, as it may break networking in your cluster. When not specified, BIRD uses the default value of 120 seconds. | `10s`, `120s`, `2m` etc.                                                                    | [Duration string][parse-duration] | `nil` (empty config, BIRD will use the default value of `120s`)   |
| numAllowedLocalASNumbers | The number of local AS numbers to allow in the AS path for received routes. This disables BGP loop prevention and should only be used if necessary.                                                                                                                                                                                                                                                |                                                                                             | integer                           | `nil` (BIRD will default to 0 meaning no change to loop prevention behavior) |
| ttlSecurity              | Enables the generalized TTL security mechanism (GTSM) which protects against spoofed packets by ignoring received packets with a smaller than expected TTL value. The provided value is the number of hops (edges) between the peers.                                                                                                                              | 0 - 255                                                                                     | 8-bit integer                     | `nil` (results in BIRD configuration `ttl security off`)          |
| reachableBy | Adds a static route that may be needed to connect to a peer. In some cases, not having a static route for BGP peering results in route flapping. By adding the address of the gateway that the peer is connected to, a static route is added to prevent route flapping. | The address of the gateway that the peer is connected to | string | |

> **Tip**: the cluster-wide default local AS number used when speaking with a peer is controlled by the
> [BGPConfiguration resource](./bgpconfig).  That value can be overridden per-node by using the `bgp` field of
> the [node resource](./node).
{: .alert .alert-success}

#### BGPPassword

> **Note:** BGP passwords must be 80 characters or fewer.  If a password longer than that
> is configured, the BGP sessions with that password will fail to be established.
{: .alert .alert-info}

| Field        | Description                     | Schema           |
|--------------|---------------------------------|------------------|
| secretKeyRef | Get the password from a secret. | [KeyRef](#keyref) |

#### KeyRef

KeyRef tells {{site.prodname}} where to get a BGP password.  The referenced Kubernetes
secret must be in the same namespace as the {{site.nodecontainer}} pod.

| Field    | Description                         | Schema |
|----------|-------------------------------------|--------|
| name     | The name of the secret              | string |
| key      | The key within the secret           | string |

### Peer scopes

BGP Peers can exist at either global or node-specific scope. A peer's scope
determines which `{{site.nodecontainer}}`s will attempt to establish a BGP session with that peer.
If `{{site.nodecontainer}}` has a `listenPort` set in `BGPConfiguration`, it will be used in peering.

#### Global peer

To assign a BGP peer a global scope, omit the `node` and `nodeSelector` fields. All nodes in
the cluster will attempt to establish BGP connections with it

#### Node-specific peer

A BGP peer can also be node-specific. When the `node` field is included, only the specified node
will peer with it. When the `nodeSelector` field is included, the nodes with labels that match that selector
will peer with it.

### Supported operations

| Datastore type        | Create/Delete | Update | Get/List | Notes
|-----------------------|---------------|--------|----------|------
| etcdv3                | Yes           | Yes    | Yes      |
| Kubernetes API server | Yes           | Yes    | Yes      |

### Selectors

{% include content/selectors.md %}

[parse-duration]: https://golang.org/pkg/time/#ParseDuration
