// Copyright (c) 2023 Tigera, Inc. All rights reserved.

// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package crds

//DO NOT CHANGE. This is a generated file. In order to update, run `make gen-crds`.

const (
	bgpconfigurations             = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: bgpconfigurations.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: BGPConfiguration\n    listKind: BGPConfigurationList\n    plural: bgpconfigurations\n    singular: bgpconfiguration\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        description: BGPConfiguration contains the configuration for any BGP routing.\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: BGPConfigurationSpec contains the values of the BGP configuration.\n            properties:\n              asNumber:\n                description: 'ASNumber is the default AS number used by a node. [Default:\n                  64512]'\n                format: int32\n                type: integer\n              bindMode:\n                description: BindMode indicates whether to listen for BGP connections\n                  on all addresses (None) or only on the node's canonical IP address\n                  Node.Spec.BGP.IPvXAddress (NodeIP). Default behaviour is to listen\n                  for BGP connections on all addresses.\n                type: string\n              communities:\n                description: Communities is a list of BGP community values and their\n                  arbitrary names for tagging routes.\n                items:\n                  description: Community contains standard or large community value\n                    and its name.\n                  properties:\n                    name:\n                      description: Name given to community value.\n                      type: string\n                    value:\n                      description: Value must be of format `aa:nn` or `aa:nn:mm`.\n                        For standard community use `aa:nn` format, where `aa` and\n                        `nn` are 16 bit number. For large community use `aa:nn:mm`\n                        format, where `aa`, `nn` and `mm` are 32 bit number. Where,\n                        `aa` is an AS Number, `nn` and `mm` are per-AS identifier.\n                      pattern: ^(\\d+):(\\d+)$|^(\\d+):(\\d+):(\\d+)$\n                      type: string\n                  type: object\n                type: array\n              ignoredInterfaces:\n                description: IgnoredInterfaces indicates the network interfaces that\n                  needs to be excluded when reading device routes.\n                items:\n                  type: string\n                type: array\n              listenPort:\n                description: ListenPort is the port where BGP protocol should listen.\n                  Defaults to 179\n                maximum: 65535\n                minimum: 1\n                type: integer\n              logSeverityScreen:\n                description: 'LogSeverityScreen is the log severity above which logs\n                  are sent to the stdout. [Default: INFO]'\n                type: string\n              nodeMeshMaxRestartTime:\n                description: Time to allow for software restart for node-to-mesh peerings.  When\n                  specified, this is configured as the graceful restart timeout.  When\n                  not specified, the BIRD default of 120s is used. This field can\n                  only be set on the default BGPConfiguration instance and requires\n                  that NodeMesh is enabled\n                type: string\n              nodeMeshPassword:\n                description: Optional BGP password for full node-to-mesh peerings.\n                  This field can only be set on the default BGPConfiguration instance\n                  and requires that NodeMesh is enabled\n                properties:\n                  secretKeyRef:\n                    description: Selects a key of a secret in the node pod's namespace.\n                    properties:\n                      key:\n                        description: The key of the secret to select from.  Must be\n                          a valid secret key.\n                        type: string\n                      name:\n                        description: 'Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names\n                          TODO: Add other useful fields. apiVersion, kind, uid?'\n                        type: string\n                      optional:\n                        description: Specify whether the Secret or its key must be\n                          defined\n                        type: boolean\n                    required:\n                    - key\n                    type: object\n                type: object\n              nodeToNodeMeshEnabled:\n                description: 'NodeToNodeMeshEnabled sets whether full node to node\n                  BGP mesh is enabled. [Default: true]'\n                type: boolean\n              prefixAdvertisements:\n                description: PrefixAdvertisements contains per-prefix advertisement\n                  configuration.\n                items:\n                  description: PrefixAdvertisement configures advertisement properties\n                    for the specified CIDR.\n                  properties:\n                    cidr:\n                      description: CIDR for which properties should be advertised.\n                      type: string\n                    communities:\n                      description: Communities can be list of either community names\n                        already defined in `Specs.Communities` or community value\n                        of format `aa:nn` or `aa:nn:mm`. For standard community use\n                        `aa:nn` format, where `aa` and `nn` are 16 bit number. For\n                        large community use `aa:nn:mm` format, where `aa`, `nn` and\n                        `mm` are 32 bit number. Where,`aa` is an AS Number, `nn` and\n                        `mm` are per-AS identifier.\n                      items:\n                        type: string\n                      type: array\n                  type: object\n                type: array\n              serviceClusterIPs:\n                description: ServiceClusterIPs are the CIDR blocks from which service\n                  cluster IPs are allocated. If specified, Calico will advertise these\n                  blocks, as well as any cluster IPs within them.\n                items:\n                  description: ServiceClusterIPBlock represents a single allowed ClusterIP\n                    CIDR block.\n                  properties:\n                    cidr:\n                      type: string\n                  type: object\n                type: array\n              serviceExternalIPs:\n                description: ServiceExternalIPs are the CIDR blocks for Kubernetes\n                  Service External IPs. Kubernetes Service ExternalIPs will only be\n                  advertised if they are within one of these blocks.\n                items:\n                  description: ServiceExternalIPBlock represents a single allowed\n                    External IP CIDR block.\n                  properties:\n                    cidr:\n                      type: string\n                  type: object\n                type: array\n              serviceLoadBalancerIPs:\n                description: ServiceLoadBalancerIPs are the CIDR blocks for Kubernetes\n                  Service LoadBalancer IPs. Kubernetes Service status.LoadBalancer.Ingress\n                  IPs will only be advertised if they are within one of these blocks.\n                items:\n                  description: ServiceLoadBalancerIPBlock represents a single allowed\n                    LoadBalancer IP CIDR block.\n                  properties:\n                    cidr:\n                      type: string\n                  type: object\n                type: array\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	bgpfilters                    = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  annotations:\n    controller-gen.kubebuilder.io/version: (devel)\n  creationTimestamp: null\n  name: bgpfilters.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: BGPFilter\n    listKind: BGPFilterList\n    plural: bgpfilters\n    singular: bgpfilter\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: BGPFilterSpec contains the IPv4 and IPv6 filter rules of\n              the BGP Filter.\n            properties:\n              exportV4:\n                description: The ordered set of IPv4 BGPFilter rules acting on exporting\n                  routes to a peer.\n                items:\n                  description: BGPFilterRuleV4 defines a BGP filter rule consisting\n                    a single IPv4 CIDR block and a filter action for this CIDR.\n                  properties:\n                    action:\n                      type: string\n                    cidr:\n                      type: string\n                    matchOperator:\n                      type: string\n                  required:\n                  - action\n                  - cidr\n                  - matchOperator\n                  type: object\n                type: array\n              exportV6:\n                description: The ordered set of IPv6 BGPFilter rules acting on exporting\n                  routes to a peer.\n                items:\n                  description: BGPFilterRuleV6 defines a BGP filter rule consisting\n                    a single IPv6 CIDR block and a filter action for this CIDR.\n                  properties:\n                    action:\n                      type: string\n                    cidr:\n                      type: string\n                    matchOperator:\n                      type: string\n                  required:\n                  - action\n                  - cidr\n                  - matchOperator\n                  type: object\n                type: array\n              importV4:\n                description: The ordered set of IPv4 BGPFilter rules acting on importing\n                  routes from a peer.\n                items:\n                  description: BGPFilterRuleV4 defines a BGP filter rule consisting\n                    a single IPv4 CIDR block and a filter action for this CIDR.\n                  properties:\n                    action:\n                      type: string\n                    cidr:\n                      type: string\n                    matchOperator:\n                      type: string\n                  required:\n                  - action\n                  - cidr\n                  - matchOperator\n                  type: object\n                type: array\n              importV6:\n                description: The ordered set of IPv6 BGPFilter rules acting on importing\n                  routes from a peer.\n                items:\n                  description: BGPFilterRuleV6 defines a BGP filter rule consisting\n                    a single IPv6 CIDR block and a filter action for this CIDR.\n                  properties:\n                    action:\n                      type: string\n                    cidr:\n                      type: string\n                    matchOperator:\n                      type: string\n                  required:\n                  - action\n                  - cidr\n                  - matchOperator\n                  type: object\n                type: array\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	bgppeers                      = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: bgppeers.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: BGPPeer\n    listKind: BGPPeerList\n    plural: bgppeers\n    singular: bgppeer\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: BGPPeerSpec contains the specification for a BGPPeer resource.\n            properties:\n              asNumber:\n                description: The AS Number of the peer.\n                format: int32\n                type: integer\n              filters:\n                description: The ordered set of BGPFilters applied on this BGP peer.\n                items:\n                  type: string\n                type: array\n              keepOriginalNextHop:\n                description: Option to keep the original nexthop field when routes\n                  are sent to a BGP Peer. Setting \"true\" configures the selected BGP\n                  Peers node to use the \"next hop keep;\" instead of \"next hop self;\"(default)\n                  in the specific branch of the Node on \"bird.cfg\".\n                type: boolean\n              maxRestartTime:\n                description: Time to allow for software restart.  When specified,\n                  this is configured as the graceful restart timeout.  When not specified,\n                  the BIRD default of 120s is used.\n                type: string\n              node:\n                description: The node name identifying the Calico node instance that\n                  is targeted by this peer. If this is not set, and no nodeSelector\n                  is specified, then this BGP peer selects all nodes in the cluster.\n                type: string\n              nodeSelector:\n                description: Selector for the nodes that should have this peering.  When\n                  this is set, the Node field must be empty.\n                type: string\n              numAllowedLocalASNumbers:\n                description: Maximum number of local AS numbers that are allowed in\n                  the AS path for received routes. This removes BGP loop prevention\n                  and should only be used if absolutely necesssary.\n                format: int32\n                type: integer\n              password:\n                description: Optional BGP password for the peerings generated by this\n                  BGPPeer resource.\n                properties:\n                  secretKeyRef:\n                    description: Selects a key of a secret in the node pod's namespace.\n                    properties:\n                      key:\n                        description: The key of the secret to select from.  Must be\n                          a valid secret key.\n                        type: string\n                      name:\n                        description: 'Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names\n                          TODO: Add other useful fields. apiVersion, kind, uid?'\n                        type: string\n                      optional:\n                        description: Specify whether the Secret or its key must be\n                          defined\n                        type: boolean\n                    required:\n                    - key\n                    type: object\n                type: object\n              peerIP:\n                description: The IP address of the peer followed by an optional port\n                  number to peer with. If port number is given, format should be `[<IPv6>]:port`\n                  or `<IPv4>:<port>` for IPv4. If optional port number is not set,\n                  and this peer IP and ASNumber belongs to a calico/node with ListenPort\n                  set in BGPConfiguration, then we use that port to peer.\n                type: string\n              peerSelector:\n                description: Selector for the remote nodes to peer with.  When this\n                  is set, the PeerIP and ASNumber fields must be empty.  For each\n                  peering between the local node and selected remote nodes, we configure\n                  an IPv4 peering if both ends have NodeBGPSpec.IPv4Address specified,\n                  and an IPv6 peering if both ends have NodeBGPSpec.IPv6Address specified.  The\n                  remote AS number comes from the remote node's NodeBGPSpec.ASNumber,\n                  or the global default if that is not set.\n                type: string\n              reachableBy:\n                description: Add an exact, i.e. /32, static route toward peer IP in\n                  order to prevent route flapping. ReachableBy contains the address\n                  of the gateway which peer can be reached by.\n                type: string\n              sourceAddress:\n                description: Specifies whether and how to configure a source address\n                  for the peerings generated by this BGPPeer resource.  Default value\n                  \"UseNodeIP\" means to configure the node IP as the source address.  \"None\"\n                  means not to configure a source address.\n                type: string\n              ttlSecurity:\n                description: TTLSecurity enables the generalized TTL security mechanism\n                  (GTSM) which protects against spoofed packets by ignoring received\n                  packets with a smaller than expected TTL value. The provided value\n                  is the number of hops (edges) between the peers.\n                type: integer\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	blockaffinities               = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: blockaffinities.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: BlockAffinity\n    listKind: BlockAffinityList\n    plural: blockaffinities\n    singular: blockaffinity\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: BlockAffinitySpec contains the specification for a BlockAffinity\n              resource.\n            properties:\n              cidr:\n                type: string\n              deleted:\n                description: Deleted indicates that this block affinity is being deleted.\n                  This field is a string for compatibility with older releases that\n                  mistakenly treat this field as a string.\n                type: string\n              node:\n                type: string\n              state:\n                type: string\n            required:\n            - cidr\n            - deleted\n            - node\n            - state\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	caliconodestatuses            = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  annotations:\n    controller-gen.kubebuilder.io/version: (devel)\n  creationTimestamp: null\n  name: caliconodestatuses.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: CalicoNodeStatus\n    listKind: CalicoNodeStatusList\n    plural: caliconodestatuses\n    singular: caliconodestatus\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: CalicoNodeStatusSpec contains the specification for a CalicoNodeStatus\n              resource.\n            properties:\n              classes:\n                description: Classes declares the types of information to monitor\n                  for this calico/node, and allows for selective status reporting\n                  about certain subsets of information.\n                items:\n                  type: string\n                type: array\n              node:\n                description: The node name identifies the Calico node instance for\n                  node status.\n                type: string\n              updatePeriodSeconds:\n                description: UpdatePeriodSeconds is the period at which CalicoNodeStatus\n                  should be updated. Set to 0 to disable CalicoNodeStatus refresh.\n                  Maximum update period is one day.\n                format: int32\n                type: integer\n            type: object\n          status:\n            description: CalicoNodeStatusStatus defines the observed state of CalicoNodeStatus.\n              No validation needed for status since it is updated by Calico.\n            properties:\n              agent:\n                description: Agent holds agent status on the node.\n                properties:\n                  birdV4:\n                    description: BIRDV4 represents the latest observed status of bird4.\n                    properties:\n                      lastBootTime:\n                        description: LastBootTime holds the value of lastBootTime\n                          from bird.ctl output.\n                        type: string\n                      lastReconfigurationTime:\n                        description: LastReconfigurationTime holds the value of lastReconfigTime\n                          from bird.ctl output.\n                        type: string\n                      routerID:\n                        description: Router ID used by bird.\n                        type: string\n                      state:\n                        description: The state of the BGP Daemon.\n                        type: string\n                      version:\n                        description: Version of the BGP daemon\n                        type: string\n                    type: object\n                  birdV6:\n                    description: BIRDV6 represents the latest observed status of bird6.\n                    properties:\n                      lastBootTime:\n                        description: LastBootTime holds the value of lastBootTime\n                          from bird.ctl output.\n                        type: string\n                      lastReconfigurationTime:\n                        description: LastReconfigurationTime holds the value of lastReconfigTime\n                          from bird.ctl output.\n                        type: string\n                      routerID:\n                        description: Router ID used by bird.\n                        type: string\n                      state:\n                        description: The state of the BGP Daemon.\n                        type: string\n                      version:\n                        description: Version of the BGP daemon\n                        type: string\n                    type: object\n                type: object\n              bgp:\n                description: BGP holds node BGP status.\n                properties:\n                  numberEstablishedV4:\n                    description: The total number of IPv4 established bgp sessions.\n                    type: integer\n                  numberEstablishedV6:\n                    description: The total number of IPv6 established bgp sessions.\n                    type: integer\n                  numberNotEstablishedV4:\n                    description: The total number of IPv4 non-established bgp sessions.\n                    type: integer\n                  numberNotEstablishedV6:\n                    description: The total number of IPv6 non-established bgp sessions.\n                    type: integer\n                  peersV4:\n                    description: PeersV4 represents IPv4 BGP peers status on the node.\n                    items:\n                      description: CalicoNodePeer contains the status of BGP peers\n                        on the node.\n                      properties:\n                        peerIP:\n                          description: IP address of the peer whose condition we are\n                            reporting.\n                          type: string\n                        since:\n                          description: Since the state or reason last changed.\n                          type: string\n                        state:\n                          description: State is the BGP session state.\n                          type: string\n                        type:\n                          description: Type indicates whether this peer is configured\n                            via the node-to-node mesh, or via en explicit global or\n                            per-node BGPPeer object.\n                          type: string\n                      type: object\n                    type: array\n                  peersV6:\n                    description: PeersV6 represents IPv6 BGP peers status on the node.\n                    items:\n                      description: CalicoNodePeer contains the status of BGP peers\n                        on the node.\n                      properties:\n                        peerIP:\n                          description: IP address of the peer whose condition we are\n                            reporting.\n                          type: string\n                        since:\n                          description: Since the state or reason last changed.\n                          type: string\n                        state:\n                          description: State is the BGP session state.\n                          type: string\n                        type:\n                          description: Type indicates whether this peer is configured\n                            via the node-to-node mesh, or via en explicit global or\n                            per-node BGPPeer object.\n                          type: string\n                      type: object\n                    type: array\n                required:\n                - numberEstablishedV4\n                - numberEstablishedV6\n                - numberNotEstablishedV4\n                - numberNotEstablishedV6\n                type: object\n              lastUpdated:\n                description: LastUpdated is a timestamp representing the server time\n                  when CalicoNodeStatus object last updated. It is represented in\n                  RFC3339 form and is in UTC.\n                format: date-time\n                nullable: true\n                type: string\n              routes:\n                description: Routes reports routes known to the Calico BGP daemon\n                  on the node.\n                properties:\n                  routesV4:\n                    description: RoutesV4 represents IPv4 routes on the node.\n                    items:\n                      description: CalicoNodeRoute contains the status of BGP routes\n                        on the node.\n                      properties:\n                        destination:\n                          description: Destination of the route.\n                          type: string\n                        gateway:\n                          description: Gateway for the destination.\n                          type: string\n                        interface:\n                          description: Interface for the destination\n                          type: string\n                        learnedFrom:\n                          description: LearnedFrom contains information regarding\n                            where this route originated.\n                          properties:\n                            peerIP:\n                              description: If sourceType is NodeMesh or BGPPeer, IP\n                                address of the router that sent us this route.\n                              type: string\n                            sourceType:\n                              description: Type of the source where a route is learned\n                                from.\n                              type: string\n                          type: object\n                        type:\n                          description: Type indicates if the route is being used for\n                            forwarding or not.\n                          type: string\n                      type: object\n                    type: array\n                  routesV6:\n                    description: RoutesV6 represents IPv6 routes on the node.\n                    items:\n                      description: CalicoNodeRoute contains the status of BGP routes\n                        on the node.\n                      properties:\n                        destination:\n                          description: Destination of the route.\n                          type: string\n                        gateway:\n                          description: Gateway for the destination.\n                          type: string\n                        interface:\n                          description: Interface for the destination\n                          type: string\n                        learnedFrom:\n                          description: LearnedFrom contains information regarding\n                            where this route originated.\n                          properties:\n                            peerIP:\n                              description: If sourceType is NodeMesh or BGPPeer, IP\n                                address of the router that sent us this route.\n                              type: string\n                            sourceType:\n                              description: Type of the source where a route is learned\n                                from.\n                              type: string\n                          type: object\n                        type:\n                          description: Type indicates if the route is being used for\n                            forwarding or not.\n                          type: string\n                      type: object\n                    type: array\n                type: object\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	clusterinformations           = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: clusterinformations.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: ClusterInformation\n    listKind: ClusterInformationList\n    plural: clusterinformations\n    singular: clusterinformation\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        description: ClusterInformation contains the cluster specific information.\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: ClusterInformationSpec contains the values of describing\n              the cluster.\n            properties:\n              calicoVersion:\n                description: CalicoVersion is the version of Calico that the cluster\n                  is running\n                type: string\n              clusterGUID:\n                description: ClusterGUID is the GUID of the cluster\n                type: string\n              clusterType:\n                description: ClusterType describes the type of the cluster\n                type: string\n              datastoreReady:\n                description: DatastoreReady is used during significant datastore migrations\n                  to signal to components such as Felix that it should wait before\n                  accessing the datastore.\n                type: boolean\n              variant:\n                description: Variant declares which variant of Calico should be active.\n                type: string\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	felixconfigurations           = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: felixconfigurations.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: FelixConfiguration\n    listKind: FelixConfigurationList\n    plural: felixconfigurations\n    singular: felixconfiguration\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        description: Felix Configuration contains the configuration for Felix.\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: FelixConfigurationSpec contains the values of the Felix configuration.\n            properties:\n              allowIPIPPacketsFromWorkloads:\n                description: 'AllowIPIPPacketsFromWorkloads controls whether Felix\n                  will add a rule to drop IPIP encapsulated traffic from workloads\n                  [Default: false]'\n                type: boolean\n              allowVXLANPacketsFromWorkloads:\n                description: 'AllowVXLANPacketsFromWorkloads controls whether Felix\n                  will add a rule to drop VXLAN encapsulated traffic from workloads\n                  [Default: false]'\n                type: boolean\n              awsSrcDstCheck:\n                description: 'Set source-destination-check on AWS EC2 instances. Accepted\n                  value must be one of \"DoNothing\", \"Enable\" or \"Disable\". [Default:\n                  DoNothing]'\n                enum:\n                - DoNothing\n                - Enable\n                - Disable\n                type: string\n              bpfConnectTimeLoadBalancingEnabled:\n                description: 'BPFConnectTimeLoadBalancingEnabled when in BPF mode,\n                  controls whether Felix installs the connection-time load balancer.  The\n                  connect-time load balancer is required for the host to be able to\n                  reach Kubernetes services and it improves the performance of pod-to-service\n                  connections.  The only reason to disable it is for debugging purposes.  [Default:\n                  true]'\n                type: boolean\n              bpfDSROptoutCIDRs:\n                description: BPFDSROptoutCIDRs is a list of CIDRs which are excluded\n                  from DSR. That is, clients in those CIDRs will accesses nodeports\n                  as if BPFExternalServiceMode was set to Tunnel.\n                items:\n                  type: string\n                type: array\n              bpfDataIfacePattern:\n                description: BPFDataIfacePattern is a regular expression that controls\n                  which interfaces Felix should attach BPF programs to in order to\n                  catch traffic to/from the network.  This needs to match the interfaces\n                  that Calico workload traffic flows over as well as any interfaces\n                  that handle incoming traffic to nodeports and services from outside\n                  the cluster.  It should not match the workload interfaces (usually\n                  named cali...).\n                type: string\n              bpfDisableUnprivileged:\n                description: 'BPFDisableUnprivileged, if enabled, Felix sets the kernel.unprivileged_bpf_disabled\n                  sysctl to disable unprivileged use of BPF.  This ensures that unprivileged\n                  users cannot access Calico''s BPF maps and cannot insert their own\n                  BPF programs to interfere with Calico''s. [Default: true]'\n                type: boolean\n              bpfEnabled:\n                description: 'BPFEnabled, if enabled Felix will use the BPF dataplane.\n                  [Default: false]'\n                type: boolean\n              bpfEnforceRPF:\n                description: 'BPFEnforceRPF enforce strict RPF on all host interfaces\n                  with BPF programs regardless of what is the per-interfaces or global\n                  setting. Possible values are Disabled, Strict or Loose. [Default:\n                  Loose]'\n                type: string\n              bpfExtToServiceConnmark:\n                description: 'BPFExtToServiceConnmark in BPF mode, control a 32bit\n                  mark that is set on connections from an external client to a local\n                  service. This mark allows us to control how packets of that connection\n                  are routed within the host and how is routing interpreted by RPF\n                  check. [Default: 0]'\n                type: integer\n              bpfExternalServiceMode:\n                description: 'BPFExternalServiceMode in BPF mode, controls how connections\n                  from outside the cluster to services (node ports and cluster IPs)\n                  are forwarded to remote workloads.  If set to \"Tunnel\" then both\n                  request and response traffic is tunneled to the remote node.  If\n                  set to \"DSR\", the request traffic is tunneled but the response traffic\n                  is sent directly from the remote node.  In \"DSR\" mode, the remote\n                  node appears to use the IP of the ingress node; this requires a\n                  permissive L2 network.  [Default: Tunnel]'\n                type: string\n              bpfHostConntrackBypass:\n                description: 'BPFHostConntrackBypass Controls whether to bypass Linux\n                  conntrack in BPF mode for workloads and services. [Default: true\n                  - bypass Linux conntrack]'\n                type: boolean\n              bpfKubeProxyEndpointSlicesEnabled:\n                description: BPFKubeProxyEndpointSlicesEnabled in BPF mode, controls\n                  whether Felix's embedded kube-proxy accepts EndpointSlices or not.\n                type: boolean\n              bpfKubeProxyIptablesCleanupEnabled:\n                description: 'BPFKubeProxyIptablesCleanupEnabled, if enabled in BPF\n                  mode, Felix will proactively clean up the upstream Kubernetes kube-proxy''s\n                  iptables chains.  Should only be enabled if kube-proxy is not running.  [Default:\n                  true]'\n                type: boolean\n              bpfKubeProxyMinSyncPeriod:\n                description: 'BPFKubeProxyMinSyncPeriod, in BPF mode, controls the\n                  minimum time between updates to the dataplane for Felix''s embedded\n                  kube-proxy.  Lower values give reduced set-up latency.  Higher values\n                  reduce Felix CPU usage by batching up more work.  [Default: 1s]'\n                type: string\n              bpfL3IfacePattern:\n                description: BPFL3IfacePattern is a regular expression that allows\n                  to list tunnel devices like wireguard or vxlan (i.e., L3 devices)\n                  in addition to BPFDataIfacePattern. That is, tunnel interfaces not\n                  created by Calico, that Calico workload traffic flows over as well\n                  as any interfaces that handle incoming traffic to nodeports and\n                  services from outside the cluster.\n                type: string\n              bpfLogLevel:\n                description: 'BPFLogLevel controls the log level of the BPF programs\n                  when in BPF dataplane mode.  One of \"Off\", \"Info\", or \"Debug\".  The\n                  logs are emitted to the BPF trace pipe, accessible with the command\n                  `tc exec bpf debug`. [Default: Off].'\n                type: string\n              bpfMapSizeConntrack:\n                description: 'BPFMapSizeConntrack sets the size for the conntrack\n                  map.  This map must be large enough to hold an entry for each active\n                  connection.  Warning: changing the size of the conntrack map can\n                  cause disruption.'\n                type: integer\n              bpfMapSizeIPSets:\n                description: BPFMapSizeIPSets sets the size for ipsets map.  The IP\n                  sets map must be large enough to hold an entry for each endpoint\n                  matched by every selector in the source/destination matches in network\n                  policy.  Selectors such as \"all()\" can result in large numbers of\n                  entries (one entry per endpoint in that case).\n                type: integer\n              bpfMapSizeIfState:\n                description: BPFMapSizeIfState sets the size for ifstate map.  The\n                  ifstate map must be large enough to hold an entry for each device\n                  (host + workloads) on a host.\n                type: integer\n              bpfMapSizeNATAffinity:\n                type: integer\n              bpfMapSizeNATBackend:\n                description: BPFMapSizeNATBackend sets the size for nat back end map.\n                  This is the total number of endpoints. This is mostly more than\n                  the size of the number of services.\n                type: integer\n              bpfMapSizeNATFrontend:\n                description: BPFMapSizeNATFrontend sets the size for nat front end\n                  map. FrontendMap should be large enough to hold an entry for each\n                  nodeport, external IP and each port in each service.\n                type: integer\n              bpfMapSizeRoute:\n                description: BPFMapSizeRoute sets the size for the routes map.  The\n                  routes map should be large enough to hold one entry per workload\n                  and a handful of entries per host (enough to cover its own IPs and\n                  tunnel IPs).\n                type: integer\n              bpfPSNATPorts:\n                anyOf:\n                - type: integer\n                - type: string\n                description: 'BPFPSNATPorts sets the range from which we randomly\n                  pick a port if there is a source port collision. This should be\n                  within the ephemeral range as defined by RFC 6056 (1024–65535) and\n                  preferably outside the  ephemeral ranges used by common operating\n                  systems. Linux uses 32768–60999, while others mostly use the IANA\n                  defined range 49152–65535. It is not necessarily a problem if this\n                  range overlaps with the operating systems. Both ends of the range\n                  are inclusive. [Default: 20000:29999]'\n                pattern: ^.*\n                x-kubernetes-int-or-string: true\n              bpfPolicyDebugEnabled:\n                description: BPFPolicyDebugEnabled when true, Felix records detailed\n                  information about the BPF policy programs, which can be examined\n                  with the calico-bpf command-line tool.\n                type: boolean\n              chainInsertMode:\n                description: 'ChainInsertMode controls whether Felix hooks the kernel''s\n                  top-level iptables chains by inserting a rule at the top of the\n                  chain or by appending a rule at the bottom. insert is the safe default\n                  since it prevents Calico''s rules from being bypassed. If you switch\n                  to append mode, be sure that the other rules in the chains signal\n                  acceptance by falling through to the Calico rules, otherwise the\n                  Calico policy will be bypassed. [Default: insert]'\n                type: string\n              dataplaneDriver:\n                description: DataplaneDriver filename of the external dataplane driver\n                  to use.  Only used if UseInternalDataplaneDriver is set to false.\n                type: string\n              dataplaneWatchdogTimeout:\n                description: \"DataplaneWatchdogTimeout is the readiness/liveness timeout\n                  used for Felix's (internal) dataplane driver. Increase this value\n                  if you experience spurious non-ready or non-live events when Felix\n                  is under heavy load. Decrease the value to get felix to report non-live\n                  or non-ready more quickly. [Default: 90s] \\n Deprecated: replaced\n                  by the generic HealthTimeoutOverrides.\"\n                type: string\n              debugDisableLogDropping:\n                type: boolean\n              debugMemoryProfilePath:\n                type: string\n              debugSimulateCalcGraphHangAfter:\n                type: string\n              debugSimulateDataplaneHangAfter:\n                type: string\n              defaultEndpointToHostAction:\n                description: 'DefaultEndpointToHostAction controls what happens to\n                  traffic that goes from a workload endpoint to the host itself (after\n                  the traffic hits the endpoint egress policy). By default Calico\n                  blocks traffic from workload endpoints to the host itself with an\n                  iptables \"DROP\" action. If you want to allow some or all traffic\n                  from endpoint to host, set this parameter to RETURN or ACCEPT. Use\n                  RETURN if you have your own rules in the iptables \"INPUT\" chain;\n                  Calico will insert its rules at the top of that chain, then \"RETURN\"\n                  packets to the \"INPUT\" chain once it has completed processing workload\n                  endpoint egress policy. Use ACCEPT to unconditionally accept packets\n                  from workloads after processing workload endpoint egress policy.\n                  [Default: Drop]'\n                type: string\n              deviceRouteProtocol:\n                description: This defines the route protocol added to programmed device\n                  routes, by default this will be RTPROT_BOOT when left blank.\n                type: integer\n              deviceRouteSourceAddress:\n                description: This is the IPv4 source address to use on programmed\n                  device routes. By default the source address is left blank, leaving\n                  the kernel to choose the source address used.\n                type: string\n              deviceRouteSourceAddressIPv6:\n                description: This is the IPv6 source address to use on programmed\n                  device routes. By default the source address is left blank, leaving\n                  the kernel to choose the source address used.\n                type: string\n              disableConntrackInvalidCheck:\n                type: boolean\n              endpointReportingDelay:\n                type: string\n              endpointReportingEnabled:\n                type: boolean\n              externalNodesList:\n                description: ExternalNodesCIDRList is a list of CIDR's of external-non-calico-nodes\n                  which may source tunnel traffic and have the tunneled traffic be\n                  accepted at calico nodes.\n                items:\n                  type: string\n                type: array\n              failsafeInboundHostPorts:\n                description: 'FailsafeInboundHostPorts is a list of UDP/TCP ports\n                  and CIDRs that Felix will allow incoming traffic to host endpoints\n                  on irrespective of the security policy. This is useful to avoid\n                  accidentally cutting off a host with incorrect configuration. For\n                  back-compatibility, if the protocol is not specified, it defaults\n                  to \"tcp\". If a CIDR is not specified, it will allow traffic from\n                  all addresses. To disable all inbound host ports, use the value\n                  none. The default value allows ssh access and DHCP. [Default: tcp:22,\n                  udp:68, tcp:179, tcp:2379, tcp:2380, tcp:6443, tcp:6666, tcp:6667]'\n                items:\n                  description: ProtoPort is combination of protocol, port, and CIDR.\n                    Protocol and port must be specified.\n                  properties:\n                    net:\n                      type: string\n                    port:\n                      type: integer\n                    protocol:\n                      type: string\n                  required:\n                  - port\n                  - protocol\n                  type: object\n                type: array\n              failsafeOutboundHostPorts:\n                description: 'FailsafeOutboundHostPorts is a list of UDP/TCP ports\n                  and CIDRs that Felix will allow outgoing traffic from host endpoints\n                  to irrespective of the security policy. This is useful to avoid\n                  accidentally cutting off a host with incorrect configuration. For\n                  back-compatibility, if the protocol is not specified, it defaults\n                  to \"tcp\". If a CIDR is not specified, it will allow traffic from\n                  all addresses. To disable all outbound host ports, use the value\n                  none. The default value opens etcd''s standard ports to ensure that\n                  Felix does not get cut off from etcd as well as allowing DHCP and\n                  DNS. [Default: tcp:179, tcp:2379, tcp:2380, tcp:6443, tcp:6666,\n                  tcp:6667, udp:53, udp:67]'\n                items:\n                  description: ProtoPort is combination of protocol, port, and CIDR.\n                    Protocol and port must be specified.\n                  properties:\n                    net:\n                      type: string\n                    port:\n                      type: integer\n                    protocol:\n                      type: string\n                  required:\n                  - port\n                  - protocol\n                  type: object\n                type: array\n              featureDetectOverride:\n                description: FeatureDetectOverride is used to override feature detection\n                  based on auto-detected platform capabilities.  Values are specified\n                  in a comma separated list with no spaces, example; \"SNATFullyRandom=true,MASQFullyRandom=false,RestoreSupportsLock=\".  \"true\"\n                  or \"false\" will force the feature, empty or omitted values are auto-detected.\n                type: string\n              featureGates:\n                description: FeatureGates is used to enable or disable tech-preview\n                  Calico features. Values are specified in a comma separated list\n                  with no spaces, example; \"BPFConnectTimeLoadBalancingWorkaround=enabled,XyZ=false\".\n                  This is used to enable features that are not fully production ready.\n                type: string\n              floatingIPs:\n                description: FloatingIPs configures whether or not Felix will program\n                  non-OpenStack floating IP addresses.  (OpenStack-derived floating\n                  IPs are always programmed, regardless of this setting.)\n                enum:\n                - Enabled\n                - Disabled\n                type: string\n              genericXDPEnabled:\n                description: 'GenericXDPEnabled enables Generic XDP so network cards\n                  that don''t support XDP offload or driver modes can use XDP. This\n                  is not recommended since it doesn''t provide better performance\n                  than iptables. [Default: false]'\n                type: boolean\n              healthEnabled:\n                type: boolean\n              healthHost:\n                type: string\n              healthPort:\n                type: integer\n              healthTimeoutOverrides:\n                description: HealthTimeoutOverrides allows the internal watchdog timeouts\n                  of individual subcomponents to be overridden.  This is useful for\n                  working around \"false positive\" liveness timeouts that can occur\n                  in particularly stressful workloads or if CPU is constrained.  For\n                  a list of active subcomponents, see Felix's logs.\n                items:\n                  properties:\n                    name:\n                      type: string\n                    timeout:\n                      type: string\n                  required:\n                  - name\n                  - timeout\n                  type: object\n                type: array\n              interfaceExclude:\n                description: 'InterfaceExclude is a comma-separated list of interfaces\n                  that Felix should exclude when monitoring for host endpoints. The\n                  default value ensures that Felix ignores Kubernetes'' IPVS dummy\n                  interface, which is used internally by kube-proxy. If you want to\n                  exclude multiple interface names using a single value, the list\n                  supports regular expressions. For regular expressions you must wrap\n                  the value with ''/''. For example having values ''/^kube/,veth1''\n                  will exclude all interfaces that begin with ''kube'' and also the\n                  interface ''veth1''. [Default: kube-ipvs0]'\n                type: string\n              interfacePrefix:\n                description: 'InterfacePrefix is the interface name prefix that identifies\n                  workload endpoints and so distinguishes them from host endpoint\n                  interfaces. Note: in environments other than bare metal, the orchestrators\n                  configure this appropriately. For example our Kubernetes and Docker\n                  integrations set the ''cali'' value, and our OpenStack integration\n                  sets the ''tap'' value. [Default: cali]'\n                type: string\n              interfaceRefreshInterval:\n                description: InterfaceRefreshInterval is the period at which Felix\n                  rescans local interfaces to verify their state. The rescan can be\n                  disabled by setting the interval to 0.\n                type: string\n              ipipEnabled:\n                description: 'IPIPEnabled overrides whether Felix should configure\n                  an IPIP interface on the host. Optional as Felix determines this\n                  based on the existing IP pools. [Default: nil (unset)]'\n                type: boolean\n              ipipMTU:\n                description: 'IPIPMTU is the MTU to set on the tunnel device. See\n                  Configuring MTU [Default: 1440]'\n                type: integer\n              ipsetsRefreshInterval:\n                description: 'IpsetsRefreshInterval is the period at which Felix re-checks\n                  all iptables state to ensure that no other process has accidentally\n                  broken Calico''s rules. Set to 0 to disable iptables refresh. [Default:\n                  90s]'\n                type: string\n              iptablesBackend:\n                description: IptablesBackend specifies which backend of iptables will\n                  be used. The default is Auto.\n                type: string\n              iptablesFilterAllowAction:\n                type: string\n              iptablesFilterDenyAction:\n                description: IptablesFilterDenyAction controls what happens to traffic\n                  that is denied by network policy. By default Calico blocks traffic\n                  with an iptables \"DROP\" action. If you want to use \"REJECT\" action\n                  instead you can configure it in here.\n                type: string\n              iptablesLockFilePath:\n                description: 'IptablesLockFilePath is the location of the iptables\n                  lock file. You may need to change this if the lock file is not in\n                  its standard location (for example if you have mapped it into Felix''s\n                  container at a different path). [Default: /run/xtables.lock]'\n                type: string\n              iptablesLockProbeInterval:\n                description: 'IptablesLockProbeInterval is the time that Felix will\n                  wait between attempts to acquire the iptables lock if it is not\n                  available. Lower values make Felix more responsive when the lock\n                  is contended, but use more CPU. [Default: 50ms]'\n                type: string\n              iptablesLockTimeout:\n                description: 'IptablesLockTimeout is the time that Felix will wait\n                  for the iptables lock, or 0, to disable. To use this feature, Felix\n                  must share the iptables lock file with all other processes that\n                  also take the lock. When running Felix inside a container, this\n                  requires the /run directory of the host to be mounted into the calico/node\n                  or calico/felix container. [Default: 0s disabled]'\n                type: string\n              iptablesMangleAllowAction:\n                type: string\n              iptablesMarkMask:\n                description: 'IptablesMarkMask is the mask that Felix selects its\n                  IPTables Mark bits from. Should be a 32 bit hexadecimal number with\n                  at least 8 bits set, none of which clash with any other mark bits\n                  in use on the system. [Default: 0xff000000]'\n                format: int32\n                type: integer\n              iptablesNATOutgoingInterfaceFilter:\n                type: string\n              iptablesPostWriteCheckInterval:\n                description: 'IptablesPostWriteCheckInterval is the period after Felix\n                  has done a write to the dataplane that it schedules an extra read\n                  back in order to check the write was not clobbered by another process.\n                  This should only occur if another application on the system doesn''t\n                  respect the iptables lock. [Default: 1s]'\n                type: string\n              iptablesRefreshInterval:\n                description: 'IptablesRefreshInterval is the period at which Felix\n                  re-checks the IP sets in the dataplane to ensure that no other process\n                  has accidentally broken Calico''s rules. Set to 0 to disable IP\n                  sets refresh. Note: the default for this value is lower than the\n                  other refresh intervals as a workaround for a Linux kernel bug that\n                  was fixed in kernel version 4.11. If you are using v4.11 or greater\n                  you may want to set this to, a higher value to reduce Felix CPU\n                  usage. [Default: 10s]'\n                type: string\n              ipv6Support:\n                description: IPv6Support controls whether Felix enables support for\n                  IPv6 (if supported by the in-use dataplane).\n                type: boolean\n              kubeNodePortRanges:\n                description: 'KubeNodePortRanges holds list of port ranges used for\n                  service node ports. Only used if felix detects kube-proxy running\n                  in ipvs mode. Felix uses these ranges to separate host and workload\n                  traffic. [Default: 30000:32767].'\n                items:\n                  anyOf:\n                  - type: integer\n                  - type: string\n                  pattern: ^.*\n                  x-kubernetes-int-or-string: true\n                type: array\n              logDebugFilenameRegex:\n                description: LogDebugFilenameRegex controls which source code files\n                  have their Debug log output included in the logs. Only logs from\n                  files with names that match the given regular expression are included.  The\n                  filter only applies to Debug level logs.\n                type: string\n              logFilePath:\n                description: 'LogFilePath is the full path to the Felix log. Set to\n                  none to disable file logging. [Default: /var/log/calico/felix.log]'\n                type: string\n              logPrefix:\n                description: 'LogPrefix is the log prefix that Felix uses when rendering\n                  LOG rules. [Default: calico-packet]'\n                type: string\n              logSeverityFile:\n                description: 'LogSeverityFile is the log severity above which logs\n                  are sent to the log file. [Default: Info]'\n                type: string\n              logSeverityScreen:\n                description: 'LogSeverityScreen is the log severity above which logs\n                  are sent to the stdout. [Default: Info]'\n                type: string\n              logSeveritySys:\n                description: 'LogSeveritySys is the log severity above which logs\n                  are sent to the syslog. Set to None for no logging to syslog. [Default:\n                  Info]'\n                type: string\n              maxIpsetSize:\n                type: integer\n              metadataAddr:\n                description: 'MetadataAddr is the IP address or domain name of the\n                  server that can answer VM queries for cloud-init metadata. In OpenStack,\n                  this corresponds to the machine running nova-api (or in Ubuntu,\n                  nova-api-metadata). A value of none (case insensitive) means that\n                  Felix should not set up any NAT rule for the metadata path. [Default:\n                  127.0.0.1]'\n                type: string\n              metadataPort:\n                description: 'MetadataPort is the port of the metadata server. This,\n                  combined with global.MetadataAddr (if not ''None''), is used to\n                  set up a NAT rule, from 169.254.169.254:80 to MetadataAddr:MetadataPort.\n                  In most cases this should not need to be changed [Default: 8775].'\n                type: integer\n              mtuIfacePattern:\n                description: MTUIfacePattern is a regular expression that controls\n                  which interfaces Felix should scan in order to calculate the host's\n                  MTU. This should not match workload interfaces (usually named cali...).\n                type: string\n              natOutgoingAddress:\n                description: NATOutgoingAddress specifies an address to use when performing\n                  source NAT for traffic in a natOutgoing pool that is leaving the\n                  network. By default the address used is an address on the interface\n                  the traffic is leaving on (ie it uses the iptables MASQUERADE target)\n                type: string\n              natPortRange:\n                anyOf:\n                - type: integer\n                - type: string\n                description: NATPortRange specifies the range of ports that is used\n                  for port mapping when doing outgoing NAT. When unset the default\n                  behavior of the network stack is used.\n                pattern: ^.*\n                x-kubernetes-int-or-string: true\n              netlinkTimeout:\n                type: string\n              openstackRegion:\n                description: 'OpenstackRegion is the name of the region that a particular\n                  Felix belongs to. In a multi-region Calico/OpenStack deployment,\n                  this must be configured somehow for each Felix (here in the datamodel,\n                  or in felix.cfg or the environment on each compute node), and must\n                  match the [calico] openstack_region value configured in neutron.conf\n                  on each node. [Default: Empty]'\n                type: string\n              policySyncPathPrefix:\n                description: 'PolicySyncPathPrefix is used to by Felix to communicate\n                  policy changes to external services, like Application layer policy.\n                  [Default: Empty]'\n                type: string\n              prometheusGoMetricsEnabled:\n                description: 'PrometheusGoMetricsEnabled disables Go runtime metrics\n                  collection, which the Prometheus client does by default, when set\n                  to false. This reduces the number of metrics reported, reducing\n                  Prometheus load. [Default: true]'\n                type: boolean\n              prometheusMetricsEnabled:\n                description: 'PrometheusMetricsEnabled enables the Prometheus metrics\n                  server in Felix if set to true. [Default: false]'\n                type: boolean\n              prometheusMetricsHost:\n                description: 'PrometheusMetricsHost is the host that the Prometheus\n                  metrics server should bind to. [Default: empty]'\n                type: string\n              prometheusMetricsPort:\n                description: 'PrometheusMetricsPort is the TCP port that the Prometheus\n                  metrics server should bind to. [Default: 9091]'\n                type: integer\n              prometheusProcessMetricsEnabled:\n                description: 'PrometheusProcessMetricsEnabled disables process metrics\n                  collection, which the Prometheus client does by default, when set\n                  to false. This reduces the number of metrics reported, reducing\n                  Prometheus load. [Default: true]'\n                type: boolean\n              prometheusWireGuardMetricsEnabled:\n                description: 'PrometheusWireGuardMetricsEnabled disables wireguard\n                  metrics collection, which the Prometheus client does by default,\n                  when set to false. This reduces the number of metrics reported,\n                  reducing Prometheus load. [Default: true]'\n                type: boolean\n              removeExternalRoutes:\n                description: Whether or not to remove device routes that have not\n                  been programmed by Felix. Disabling this will allow external applications\n                  to also add device routes. This is enabled by default which means\n                  we will remove externally added routes.\n                type: boolean\n              reportingInterval:\n                description: 'ReportingInterval is the interval at which Felix reports\n                  its status into the datastore or 0 to disable. Must be non-zero\n                  in OpenStack deployments. [Default: 30s]'\n                type: string\n              reportingTTL:\n                description: 'ReportingTTL is the time-to-live setting for process-wide\n                  status reports. [Default: 90s]'\n                type: string\n              routeRefreshInterval:\n                description: 'RouteRefreshInterval is the period at which Felix re-checks\n                  the routes in the dataplane to ensure that no other process has\n                  accidentally broken Calico''s rules. Set to 0 to disable route refresh.\n                  [Default: 90s]'\n                type: string\n              routeSource:\n                description: 'RouteSource configures where Felix gets its routing\n                  information. - WorkloadIPs: use workload endpoints to construct\n                  routes. - CalicoIPAM: the default - use IPAM data to construct routes.'\n                type: string\n              routeSyncDisabled:\n                description: RouteSyncDisabled will disable all operations performed\n                  on the route table. Set to true to run in network-policy mode only.\n                type: boolean\n              routeTableRange:\n                description: Deprecated in favor of RouteTableRanges. Calico programs\n                  additional Linux route tables for various purposes. RouteTableRange\n                  specifies the indices of the route tables that Calico should use.\n                properties:\n                  max:\n                    type: integer\n                  min:\n                    type: integer\n                required:\n                - max\n                - min\n                type: object\n              routeTableRanges:\n                description: Calico programs additional Linux route tables for various\n                  purposes. RouteTableRanges specifies a set of table index ranges\n                  that Calico should use. Deprecates`RouteTableRange`, overrides `RouteTableRange`.\n                items:\n                  properties:\n                    max:\n                      type: integer\n                    min:\n                      type: integer\n                  required:\n                  - max\n                  - min\n                  type: object\n                type: array\n              serviceLoopPrevention:\n                description: 'When service IP advertisement is enabled, prevent routing\n                  loops to service IPs that are not in use, by dropping or rejecting\n                  packets that do not get DNAT''d by kube-proxy. Unless set to \"Disabled\",\n                  in which case such routing loops continue to be allowed. [Default:\n                  Drop]'\n                type: string\n              sidecarAccelerationEnabled:\n                description: 'SidecarAccelerationEnabled enables experimental sidecar\n                  acceleration [Default: false]'\n                type: boolean\n              usageReportingEnabled:\n                description: 'UsageReportingEnabled reports anonymous Calico version\n                  number and cluster size to projectcalico.org. Logs warnings returned\n                  by the usage server. For example, if a significant security vulnerability\n                  has been discovered in the version of Calico being used. [Default:\n                  true]'\n                type: boolean\n              usageReportingInitialDelay:\n                description: 'UsageReportingInitialDelay controls the minimum delay\n                  before Felix makes a report. [Default: 300s]'\n                type: string\n              usageReportingInterval:\n                description: 'UsageReportingInterval controls the interval at which\n                  Felix makes reports. [Default: 86400s]'\n                type: string\n              useInternalDataplaneDriver:\n                description: UseInternalDataplaneDriver, if true, Felix will use its\n                  internal dataplane programming logic.  If false, it will launch\n                  an external dataplane driver and communicate with it over protobuf.\n                type: boolean\n              vxlanEnabled:\n                description: 'VXLANEnabled overrides whether Felix should create the\n                  VXLAN tunnel device for IPv4 VXLAN networking. Optional as Felix\n                  determines this based on the existing IP pools. [Default: nil (unset)]'\n                type: boolean\n              vxlanMTU:\n                description: 'VXLANMTU is the MTU to set on the IPv4 VXLAN tunnel\n                  device. See Configuring MTU [Default: 1410]'\n                type: integer\n              vxlanMTUV6:\n                description: 'VXLANMTUV6 is the MTU to set on the IPv6 VXLAN tunnel\n                  device. See Configuring MTU [Default: 1390]'\n                type: integer\n              vxlanPort:\n                type: integer\n              vxlanVNI:\n                type: integer\n              wireguardEnabled:\n                description: 'WireguardEnabled controls whether Wireguard is enabled\n                  for IPv4 (encapsulating IPv4 traffic over an IPv4 underlay network).\n                  [Default: false]'\n                type: boolean\n              wireguardEnabledV6:\n                description: 'WireguardEnabledV6 controls whether Wireguard is enabled\n                  for IPv6 (encapsulating IPv6 traffic over an IPv6 underlay network).\n                  [Default: false]'\n                type: boolean\n              wireguardHostEncryptionEnabled:\n                description: 'WireguardHostEncryptionEnabled controls whether Wireguard\n                  host-to-host encryption is enabled. [Default: false]'\n                type: boolean\n              wireguardInterfaceName:\n                description: 'WireguardInterfaceName specifies the name to use for\n                  the IPv4 Wireguard interface. [Default: wireguard.cali]'\n                type: string\n              wireguardInterfaceNameV6:\n                description: 'WireguardInterfaceNameV6 specifies the name to use for\n                  the IPv6 Wireguard interface. [Default: wg-v6.cali]'\n                type: string\n              wireguardKeepAlive:\n                description: 'WireguardKeepAlive controls Wireguard PersistentKeepalive\n                  option. Set 0 to disable. [Default: 0]'\n                type: string\n              wireguardListeningPort:\n                description: 'WireguardListeningPort controls the listening port used\n                  by IPv4 Wireguard. [Default: 51820]'\n                type: integer\n              wireguardListeningPortV6:\n                description: 'WireguardListeningPortV6 controls the listening port\n                  used by IPv6 Wireguard. [Default: 51821]'\n                type: integer\n              wireguardMTU:\n                description: 'WireguardMTU controls the MTU on the IPv4 Wireguard\n                  interface. See Configuring MTU [Default: 1440]'\n                type: integer\n              wireguardMTUV6:\n                description: 'WireguardMTUV6 controls the MTU on the IPv6 Wireguard\n                  interface. See Configuring MTU [Default: 1420]'\n                type: integer\n              wireguardRoutingRulePriority:\n                description: 'WireguardRoutingRulePriority controls the priority value\n                  to use for the Wireguard routing rule. [Default: 99]'\n                type: integer\n              workloadSourceSpoofing:\n                description: WorkloadSourceSpoofing controls whether pods can use\n                  the allowedSourcePrefixes annotation to send traffic with a source\n                  IP address that is not theirs. This is disabled by default. When\n                  set to \"Any\", pods can request any prefix.\n                type: string\n              xdpEnabled:\n                description: 'XDPEnabled enables XDP acceleration for suitable untracked\n                  incoming deny rules. [Default: true]'\n                type: boolean\n              xdpRefreshInterval:\n                description: 'XDPRefreshInterval is the period at which Felix re-checks\n                  all XDP state to ensure that no other process has accidentally broken\n                  Calico''s BPF maps or attached programs. Set to 0 to disable XDP\n                  refresh. [Default: 90s]'\n                type: string\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	globalnetworkpolicies         = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: globalnetworkpolicies.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: GlobalNetworkPolicy\n    listKind: GlobalNetworkPolicyList\n    plural: globalnetworkpolicies\n    singular: globalnetworkpolicy\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            properties:\n              applyOnForward:\n                description: ApplyOnForward indicates to apply the rules in this policy\n                  on forward traffic.\n                type: boolean\n              doNotTrack:\n                description: DoNotTrack indicates whether packets matched by the rules\n                  in this policy should go through the data plane's connection tracking,\n                  such as Linux conntrack.  If True, the rules in this policy are\n                  applied before any data plane connection tracking, and packets allowed\n                  by this policy are marked as not to be tracked.\n                type: boolean\n              egress:\n                description: The ordered set of egress rules.  Each rule contains\n                  a set of packet match criteria and a corresponding action to apply.\n                items:\n                  description: \"A Rule encapsulates a set of match criteria and an\n                    action.  Both selector-based security Policy and security Profiles\n                    reference rules - separated out as a list of rules for both ingress\n                    and egress packet matching. \\n Each positive match criteria has\n                    a negated version, prefixed with \\\"Not\\\". All the match criteria\n                    within a rule must be satisfied for a packet to match. A single\n                    rule can contain the positive and negative version of a match\n                    and both must be satisfied for the rule to match.\"\n                  properties:\n                    action:\n                      type: string\n                    destination:\n                      description: Destination contains the match criteria that apply\n                        to destination entity.\n                      properties:\n                        namespaceSelector:\n                          description: \"NamespaceSelector is an optional field that\n                            contains a selector expression. Only traffic that originates\n                            from (or terminates at) endpoints within the selected\n                            namespaces will be matched. When both NamespaceSelector\n                            and another selector are defined on the same rule, then\n                            only workload endpoints that are matched by both selectors\n                            will be selected by the rule. \\n For NetworkPolicy, an\n                            empty NamespaceSelector implies that the Selector is limited\n                            to selecting only workload endpoints in the same namespace\n                            as the NetworkPolicy. \\n For NetworkPolicy, `global()`\n                            NamespaceSelector implies that the Selector is limited\n                            to selecting only GlobalNetworkSet or HostEndpoint. \\n\n                            For GlobalNetworkPolicy, an empty NamespaceSelector implies\n                            the Selector applies to workload endpoints across all\n                            namespaces.\"\n                          type: string\n                        nets:\n                          description: Nets is an optional field that restricts the\n                            rule to only apply to traffic that originates from (or\n                            terminates at) IP addresses in any of the given subnets.\n                          items:\n                            type: string\n                          type: array\n                        notNets:\n                          description: NotNets is the negated version of the Nets\n                            field.\n                          items:\n                            type: string\n                          type: array\n                        notPorts:\n                          description: NotPorts is the negated version of the Ports\n                            field. Since only some protocols have ports, if any ports\n                            are specified it requires the Protocol match in the Rule\n                            to be set to \"TCP\" or \"UDP\".\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        notSelector:\n                          description: NotSelector is the negated version of the Selector\n                            field.  See Selector field for subtleties with negated\n                            selectors.\n                          type: string\n                        ports:\n                          description: \"Ports is an optional field that restricts\n                            the rule to only apply to traffic that has a source (destination)\n                            port that matches one of these ranges/values. This value\n                            is a list of integers or strings that represent ranges\n                            of ports. \\n Since only some protocols have ports, if\n                            any ports are specified it requires the Protocol match\n                            in the Rule to be set to \\\"TCP\\\" or \\\"UDP\\\".\"\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        selector:\n                          description: \"Selector is an optional field that contains\n                            a selector expression (see Policy for sample syntax).\n                            \\ Only traffic that originates from (terminates at) endpoints\n                            matching the selector will be matched. \\n Note that: in\n                            addition to the negated version of the Selector (see NotSelector\n                            below), the selector expression syntax itself supports\n                            negation.  The two types of negation are subtly different.\n                            One negates the set of matched endpoints, the other negates\n                            the whole match: \\n \\tSelector = \\\"!has(my_label)\\\" matches\n                            packets that are from other Calico-controlled \\tendpoints\n                            that do not have the label \\\"my_label\\\". \\n \\tNotSelector\n                            = \\\"has(my_label)\\\" matches packets that are not from\n                            Calico-controlled \\tendpoints that do have the label \\\"my_label\\\".\n                            \\n The effect is that the latter will accept packets from\n                            non-Calico sources whereas the former is limited to packets\n                            from Calico-controlled endpoints.\"\n                          type: string\n                        serviceAccounts:\n                          description: ServiceAccounts is an optional field that restricts\n                            the rule to only apply to traffic that originates from\n                            (or terminates at) a pod running as a matching service\n                            account.\n                          properties:\n                            names:\n                              description: Names is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account whose name is in the list.\n                              items:\n                                type: string\n                              type: array\n                            selector:\n                              description: Selector is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account that matches the given label selector. If\n                                both Names and Selector are specified then they are\n                                AND'ed.\n                              type: string\n                          type: object\n                        services:\n                          description: \"Services is an optional field that contains\n                            options for matching Kubernetes Services. If specified,\n                            only traffic that originates from or terminates at endpoints\n                            within the selected service(s) will be matched, and only\n                            to/from each endpoint's port. \\n Services cannot be specified\n                            on the same rule as Selector, NotSelector, NamespaceSelector,\n                            Nets, NotNets or ServiceAccounts. \\n Ports and NotPorts\n                            can only be specified with Services on ingress rules.\"\n                          properties:\n                            name:\n                              description: Name specifies the name of a Kubernetes\n                                Service to match.\n                              type: string\n                            namespace:\n                              description: Namespace specifies the namespace of the\n                                given Service. If left empty, the rule will match\n                                within this policy's namespace.\n                              type: string\n                          type: object\n                      type: object\n                    http:\n                      description: HTTP contains match criteria that apply to HTTP\n                        requests.\n                      properties:\n                        methods:\n                          description: Methods is an optional field that restricts\n                            the rule to apply only to HTTP requests that use one of\n                            the listed HTTP Methods (e.g. GET, PUT, etc.) Multiple\n                            methods are OR'd together.\n                          items:\n                            type: string\n                          type: array\n                        paths:\n                          description: 'Paths is an optional field that restricts\n                            the rule to apply to HTTP requests that use one of the\n                            listed HTTP Paths. Multiple paths are OR''d together.\n                            e.g: - exact: /foo - prefix: /bar NOTE: Each entry may\n                            ONLY specify either a `exact` or a `prefix` match. The\n                            validator will check for it.'\n                          items:\n                            description: 'HTTPPath specifies an HTTP path to match.\n                              It may be either of the form: exact: <path>: which matches\n                              the path exactly or prefix: <path-prefix>: which matches\n                              the path prefix'\n                            properties:\n                              exact:\n                                type: string\n                              prefix:\n                                type: string\n                            type: object\n                          type: array\n                      type: object\n                    icmp:\n                      description: ICMP is an optional field that restricts the rule\n                        to apply to a specific type and code of ICMP traffic.  This\n                        should only be specified if the Protocol field is set to \"ICMP\"\n                        or \"ICMPv6\".\n                      properties:\n                        code:\n                          description: Match on a specific ICMP code.  If specified,\n                            the Type value must also be specified. This is a technical\n                            limitation imposed by the kernel's iptables firewall,\n                            which Calico uses to enforce the rule.\n                          type: integer\n                        type:\n                          description: Match on a specific ICMP type.  For example\n                            a value of 8 refers to ICMP Echo Request (i.e. pings).\n                          type: integer\n                      type: object\n                    ipVersion:\n                      description: IPVersion is an optional field that restricts the\n                        rule to only match a specific IP version.\n                      type: integer\n                    metadata:\n                      description: Metadata contains additional information for this\n                        rule\n                      properties:\n                        annotations:\n                          additionalProperties:\n                            type: string\n                          description: Annotations is a set of key value pairs that\n                            give extra information about the rule\n                          type: object\n                      type: object\n                    notICMP:\n                      description: NotICMP is the negated version of the ICMP field.\n                      properties:\n                        code:\n                          description: Match on a specific ICMP code.  If specified,\n                            the Type value must also be specified. This is a technical\n                            limitation imposed by the kernel's iptables firewall,\n                            which Calico uses to enforce the rule.\n                          type: integer\n                        type:\n                          description: Match on a specific ICMP type.  For example\n                            a value of 8 refers to ICMP Echo Request (i.e. pings).\n                          type: integer\n                      type: object\n                    notProtocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      description: NotProtocol is the negated version of the Protocol\n                        field.\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                    protocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      description: \"Protocol is an optional field that restricts the\n                        rule to only apply to traffic of a specific IP protocol. Required\n                        if any of the EntityRules contain Ports (because ports only\n                        apply to certain protocols). \\n Must be one of these string\n                        values: \\\"TCP\\\", \\\"UDP\\\", \\\"ICMP\\\", \\\"ICMPv6\\\", \\\"SCTP\\\",\n                        \\\"UDPLite\\\" or an integer in the range 1-255.\"\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                    source:\n                      description: Source contains the match criteria that apply to\n                        source entity.\n                      properties:\n                        namespaceSelector:\n                          description: \"NamespaceSelector is an optional field that\n                            contains a selector expression. Only traffic that originates\n                            from (or terminates at) endpoints within the selected\n                            namespaces will be matched. When both NamespaceSelector\n                            and another selector are defined on the same rule, then\n                            only workload endpoints that are matched by both selectors\n                            will be selected by the rule. \\n For NetworkPolicy, an\n                            empty NamespaceSelector implies that the Selector is limited\n                            to selecting only workload endpoints in the same namespace\n                            as the NetworkPolicy. \\n For NetworkPolicy, `global()`\n                            NamespaceSelector implies that the Selector is limited\n                            to selecting only GlobalNetworkSet or HostEndpoint. \\n\n                            For GlobalNetworkPolicy, an empty NamespaceSelector implies\n                            the Selector applies to workload endpoints across all\n                            namespaces.\"\n                          type: string\n                        nets:\n                          description: Nets is an optional field that restricts the\n                            rule to only apply to traffic that originates from (or\n                            terminates at) IP addresses in any of the given subnets.\n                          items:\n                            type: string\n                          type: array\n                        notNets:\n                          description: NotNets is the negated version of the Nets\n                            field.\n                          items:\n                            type: string\n                          type: array\n                        notPorts:\n                          description: NotPorts is the negated version of the Ports\n                            field. Since only some protocols have ports, if any ports\n                            are specified it requires the Protocol match in the Rule\n                            to be set to \"TCP\" or \"UDP\".\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        notSelector:\n                          description: NotSelector is the negated version of the Selector\n                            field.  See Selector field for subtleties with negated\n                            selectors.\n                          type: string\n                        ports:\n                          description: \"Ports is an optional field that restricts\n                            the rule to only apply to traffic that has a source (destination)\n                            port that matches one of these ranges/values. This value\n                            is a list of integers or strings that represent ranges\n                            of ports. \\n Since only some protocols have ports, if\n                            any ports are specified it requires the Protocol match\n                            in the Rule to be set to \\\"TCP\\\" or \\\"UDP\\\".\"\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        selector:\n                          description: \"Selector is an optional field that contains\n                            a selector expression (see Policy for sample syntax).\n                            \\ Only traffic that originates from (terminates at) endpoints\n                            matching the selector will be matched. \\n Note that: in\n                            addition to the negated version of the Selector (see NotSelector\n                            below), the selector expression syntax itself supports\n                            negation.  The two types of negation are subtly different.\n                            One negates the set of matched endpoints, the other negates\n                            the whole match: \\n \\tSelector = \\\"!has(my_label)\\\" matches\n                            packets that are from other Calico-controlled \\tendpoints\n                            that do not have the label \\\"my_label\\\". \\n \\tNotSelector\n                            = \\\"has(my_label)\\\" matches packets that are not from\n                            Calico-controlled \\tendpoints that do have the label \\\"my_label\\\".\n                            \\n The effect is that the latter will accept packets from\n                            non-Calico sources whereas the former is limited to packets\n                            from Calico-controlled endpoints.\"\n                          type: string\n                        serviceAccounts:\n                          description: ServiceAccounts is an optional field that restricts\n                            the rule to only apply to traffic that originates from\n                            (or terminates at) a pod running as a matching service\n                            account.\n                          properties:\n                            names:\n                              description: Names is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account whose name is in the list.\n                              items:\n                                type: string\n                              type: array\n                            selector:\n                              description: Selector is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account that matches the given label selector. If\n                                both Names and Selector are specified then they are\n                                AND'ed.\n                              type: string\n                          type: object\n                        services:\n                          description: \"Services is an optional field that contains\n                            options for matching Kubernetes Services. If specified,\n                            only traffic that originates from or terminates at endpoints\n                            within the selected service(s) will be matched, and only\n                            to/from each endpoint's port. \\n Services cannot be specified\n                            on the same rule as Selector, NotSelector, NamespaceSelector,\n                            Nets, NotNets or ServiceAccounts. \\n Ports and NotPorts\n                            can only be specified with Services on ingress rules.\"\n                          properties:\n                            name:\n                              description: Name specifies the name of a Kubernetes\n                                Service to match.\n                              type: string\n                            namespace:\n                              description: Namespace specifies the namespace of the\n                                given Service. If left empty, the rule will match\n                                within this policy's namespace.\n                              type: string\n                          type: object\n                      type: object\n                  required:\n                  - action\n                  type: object\n                type: array\n              ingress:\n                description: The ordered set of ingress rules.  Each rule contains\n                  a set of packet match criteria and a corresponding action to apply.\n                items:\n                  description: \"A Rule encapsulates a set of match criteria and an\n                    action.  Both selector-based security Policy and security Profiles\n                    reference rules - separated out as a list of rules for both ingress\n                    and egress packet matching. \\n Each positive match criteria has\n                    a negated version, prefixed with \\\"Not\\\". All the match criteria\n                    within a rule must be satisfied for a packet to match. A single\n                    rule can contain the positive and negative version of a match\n                    and both must be satisfied for the rule to match.\"\n                  properties:\n                    action:\n                      type: string\n                    destination:\n                      description: Destination contains the match criteria that apply\n                        to destination entity.\n                      properties:\n                        namespaceSelector:\n                          description: \"NamespaceSelector is an optional field that\n                            contains a selector expression. Only traffic that originates\n                            from (or terminates at) endpoints within the selected\n                            namespaces will be matched. When both NamespaceSelector\n                            and another selector are defined on the same rule, then\n                            only workload endpoints that are matched by both selectors\n                            will be selected by the rule. \\n For NetworkPolicy, an\n                            empty NamespaceSelector implies that the Selector is limited\n                            to selecting only workload endpoints in the same namespace\n                            as the NetworkPolicy. \\n For NetworkPolicy, `global()`\n                            NamespaceSelector implies that the Selector is limited\n                            to selecting only GlobalNetworkSet or HostEndpoint. \\n\n                            For GlobalNetworkPolicy, an empty NamespaceSelector implies\n                            the Selector applies to workload endpoints across all\n                            namespaces.\"\n                          type: string\n                        nets:\n                          description: Nets is an optional field that restricts the\n                            rule to only apply to traffic that originates from (or\n                            terminates at) IP addresses in any of the given subnets.\n                          items:\n                            type: string\n                          type: array\n                        notNets:\n                          description: NotNets is the negated version of the Nets\n                            field.\n                          items:\n                            type: string\n                          type: array\n                        notPorts:\n                          description: NotPorts is the negated version of the Ports\n                            field. Since only some protocols have ports, if any ports\n                            are specified it requires the Protocol match in the Rule\n                            to be set to \"TCP\" or \"UDP\".\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        notSelector:\n                          description: NotSelector is the negated version of the Selector\n                            field.  See Selector field for subtleties with negated\n                            selectors.\n                          type: string\n                        ports:\n                          description: \"Ports is an optional field that restricts\n                            the rule to only apply to traffic that has a source (destination)\n                            port that matches one of these ranges/values. This value\n                            is a list of integers or strings that represent ranges\n                            of ports. \\n Since only some protocols have ports, if\n                            any ports are specified it requires the Protocol match\n                            in the Rule to be set to \\\"TCP\\\" or \\\"UDP\\\".\"\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        selector:\n                          description: \"Selector is an optional field that contains\n                            a selector expression (see Policy for sample syntax).\n                            \\ Only traffic that originates from (terminates at) endpoints\n                            matching the selector will be matched. \\n Note that: in\n                            addition to the negated version of the Selector (see NotSelector\n                            below), the selector expression syntax itself supports\n                            negation.  The two types of negation are subtly different.\n                            One negates the set of matched endpoints, the other negates\n                            the whole match: \\n \\tSelector = \\\"!has(my_label)\\\" matches\n                            packets that are from other Calico-controlled \\tendpoints\n                            that do not have the label \\\"my_label\\\". \\n \\tNotSelector\n                            = \\\"has(my_label)\\\" matches packets that are not from\n                            Calico-controlled \\tendpoints that do have the label \\\"my_label\\\".\n                            \\n The effect is that the latter will accept packets from\n                            non-Calico sources whereas the former is limited to packets\n                            from Calico-controlled endpoints.\"\n                          type: string\n                        serviceAccounts:\n                          description: ServiceAccounts is an optional field that restricts\n                            the rule to only apply to traffic that originates from\n                            (or terminates at) a pod running as a matching service\n                            account.\n                          properties:\n                            names:\n                              description: Names is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account whose name is in the list.\n                              items:\n                                type: string\n                              type: array\n                            selector:\n                              description: Selector is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account that matches the given label selector. If\n                                both Names and Selector are specified then they are\n                                AND'ed.\n                              type: string\n                          type: object\n                        services:\n                          description: \"Services is an optional field that contains\n                            options for matching Kubernetes Services. If specified,\n                            only traffic that originates from or terminates at endpoints\n                            within the selected service(s) will be matched, and only\n                            to/from each endpoint's port. \\n Services cannot be specified\n                            on the same rule as Selector, NotSelector, NamespaceSelector,\n                            Nets, NotNets or ServiceAccounts. \\n Ports and NotPorts\n                            can only be specified with Services on ingress rules.\"\n                          properties:\n                            name:\n                              description: Name specifies the name of a Kubernetes\n                                Service to match.\n                              type: string\n                            namespace:\n                              description: Namespace specifies the namespace of the\n                                given Service. If left empty, the rule will match\n                                within this policy's namespace.\n                              type: string\n                          type: object\n                      type: object\n                    http:\n                      description: HTTP contains match criteria that apply to HTTP\n                        requests.\n                      properties:\n                        methods:\n                          description: Methods is an optional field that restricts\n                            the rule to apply only to HTTP requests that use one of\n                            the listed HTTP Methods (e.g. GET, PUT, etc.) Multiple\n                            methods are OR'd together.\n                          items:\n                            type: string\n                          type: array\n                        paths:\n                          description: 'Paths is an optional field that restricts\n                            the rule to apply to HTTP requests that use one of the\n                            listed HTTP Paths. Multiple paths are OR''d together.\n                            e.g: - exact: /foo - prefix: /bar NOTE: Each entry may\n                            ONLY specify either a `exact` or a `prefix` match. The\n                            validator will check for it.'\n                          items:\n                            description: 'HTTPPath specifies an HTTP path to match.\n                              It may be either of the form: exact: <path>: which matches\n                              the path exactly or prefix: <path-prefix>: which matches\n                              the path prefix'\n                            properties:\n                              exact:\n                                type: string\n                              prefix:\n                                type: string\n                            type: object\n                          type: array\n                      type: object\n                    icmp:\n                      description: ICMP is an optional field that restricts the rule\n                        to apply to a specific type and code of ICMP traffic.  This\n                        should only be specified if the Protocol field is set to \"ICMP\"\n                        or \"ICMPv6\".\n                      properties:\n                        code:\n                          description: Match on a specific ICMP code.  If specified,\n                            the Type value must also be specified. This is a technical\n                            limitation imposed by the kernel's iptables firewall,\n                            which Calico uses to enforce the rule.\n                          type: integer\n                        type:\n                          description: Match on a specific ICMP type.  For example\n                            a value of 8 refers to ICMP Echo Request (i.e. pings).\n                          type: integer\n                      type: object\n                    ipVersion:\n                      description: IPVersion is an optional field that restricts the\n                        rule to only match a specific IP version.\n                      type: integer\n                    metadata:\n                      description: Metadata contains additional information for this\n                        rule\n                      properties:\n                        annotations:\n                          additionalProperties:\n                            type: string\n                          description: Annotations is a set of key value pairs that\n                            give extra information about the rule\n                          type: object\n                      type: object\n                    notICMP:\n                      description: NotICMP is the negated version of the ICMP field.\n                      properties:\n                        code:\n                          description: Match on a specific ICMP code.  If specified,\n                            the Type value must also be specified. This is a technical\n                            limitation imposed by the kernel's iptables firewall,\n                            which Calico uses to enforce the rule.\n                          type: integer\n                        type:\n                          description: Match on a specific ICMP type.  For example\n                            a value of 8 refers to ICMP Echo Request (i.e. pings).\n                          type: integer\n                      type: object\n                    notProtocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      description: NotProtocol is the negated version of the Protocol\n                        field.\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                    protocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      description: \"Protocol is an optional field that restricts the\n                        rule to only apply to traffic of a specific IP protocol. Required\n                        if any of the EntityRules contain Ports (because ports only\n                        apply to certain protocols). \\n Must be one of these string\n                        values: \\\"TCP\\\", \\\"UDP\\\", \\\"ICMP\\\", \\\"ICMPv6\\\", \\\"SCTP\\\",\n                        \\\"UDPLite\\\" or an integer in the range 1-255.\"\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                    source:\n                      description: Source contains the match criteria that apply to\n                        source entity.\n                      properties:\n                        namespaceSelector:\n                          description: \"NamespaceSelector is an optional field that\n                            contains a selector expression. Only traffic that originates\n                            from (or terminates at) endpoints within the selected\n                            namespaces will be matched. When both NamespaceSelector\n                            and another selector are defined on the same rule, then\n                            only workload endpoints that are matched by both selectors\n                            will be selected by the rule. \\n For NetworkPolicy, an\n                            empty NamespaceSelector implies that the Selector is limited\n                            to selecting only workload endpoints in the same namespace\n                            as the NetworkPolicy. \\n For NetworkPolicy, `global()`\n                            NamespaceSelector implies that the Selector is limited\n                            to selecting only GlobalNetworkSet or HostEndpoint. \\n\n                            For GlobalNetworkPolicy, an empty NamespaceSelector implies\n                            the Selector applies to workload endpoints across all\n                            namespaces.\"\n                          type: string\n                        nets:\n                          description: Nets is an optional field that restricts the\n                            rule to only apply to traffic that originates from (or\n                            terminates at) IP addresses in any of the given subnets.\n                          items:\n                            type: string\n                          type: array\n                        notNets:\n                          description: NotNets is the negated version of the Nets\n                            field.\n                          items:\n                            type: string\n                          type: array\n                        notPorts:\n                          description: NotPorts is the negated version of the Ports\n                            field. Since only some protocols have ports, if any ports\n                            are specified it requires the Protocol match in the Rule\n                            to be set to \"TCP\" or \"UDP\".\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        notSelector:\n                          description: NotSelector is the negated version of the Selector\n                            field.  See Selector field for subtleties with negated\n                            selectors.\n                          type: string\n                        ports:\n                          description: \"Ports is an optional field that restricts\n                            the rule to only apply to traffic that has a source (destination)\n                            port that matches one of these ranges/values. This value\n                            is a list of integers or strings that represent ranges\n                            of ports. \\n Since only some protocols have ports, if\n                            any ports are specified it requires the Protocol match\n                            in the Rule to be set to \\\"TCP\\\" or \\\"UDP\\\".\"\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        selector:\n                          description: \"Selector is an optional field that contains\n                            a selector expression (see Policy for sample syntax).\n                            \\ Only traffic that originates from (terminates at) endpoints\n                            matching the selector will be matched. \\n Note that: in\n                            addition to the negated version of the Selector (see NotSelector\n                            below), the selector expression syntax itself supports\n                            negation.  The two types of negation are subtly different.\n                            One negates the set of matched endpoints, the other negates\n                            the whole match: \\n \\tSelector = \\\"!has(my_label)\\\" matches\n                            packets that are from other Calico-controlled \\tendpoints\n                            that do not have the label \\\"my_label\\\". \\n \\tNotSelector\n                            = \\\"has(my_label)\\\" matches packets that are not from\n                            Calico-controlled \\tendpoints that do have the label \\\"my_label\\\".\n                            \\n The effect is that the latter will accept packets from\n                            non-Calico sources whereas the former is limited to packets\n                            from Calico-controlled endpoints.\"\n                          type: string\n                        serviceAccounts:\n                          description: ServiceAccounts is an optional field that restricts\n                            the rule to only apply to traffic that originates from\n                            (or terminates at) a pod running as a matching service\n                            account.\n                          properties:\n                            names:\n                              description: Names is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account whose name is in the list.\n                              items:\n                                type: string\n                              type: array\n                            selector:\n                              description: Selector is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account that matches the given label selector. If\n                                both Names and Selector are specified then they are\n                                AND'ed.\n                              type: string\n                          type: object\n                        services:\n                          description: \"Services is an optional field that contains\n                            options for matching Kubernetes Services. If specified,\n                            only traffic that originates from or terminates at endpoints\n                            within the selected service(s) will be matched, and only\n                            to/from each endpoint's port. \\n Services cannot be specified\n                            on the same rule as Selector, NotSelector, NamespaceSelector,\n                            Nets, NotNets or ServiceAccounts. \\n Ports and NotPorts\n                            can only be specified with Services on ingress rules.\"\n                          properties:\n                            name:\n                              description: Name specifies the name of a Kubernetes\n                                Service to match.\n                              type: string\n                            namespace:\n                              description: Namespace specifies the namespace of the\n                                given Service. If left empty, the rule will match\n                                within this policy's namespace.\n                              type: string\n                          type: object\n                      type: object\n                  required:\n                  - action\n                  type: object\n                type: array\n              namespaceSelector:\n                description: NamespaceSelector is an optional field for an expression\n                  used to select a pod based on namespaces.\n                type: string\n              order:\n                description: Order is an optional field that specifies the order in\n                  which the policy is applied. Policies with higher \"order\" are applied\n                  after those with lower order.  If the order is omitted, it may be\n                  considered to be \"infinite\" - i.e. the policy will be applied last.  Policies\n                  with identical order will be applied in alphanumerical order based\n                  on the Policy \"Name\".\n                type: number\n              preDNAT:\n                description: PreDNAT indicates to apply the rules in this policy before\n                  any DNAT.\n                type: boolean\n              selector:\n                description: \"The selector is an expression used to pick pick out\n                  the endpoints that the policy should be applied to. \\n Selector\n                  expressions follow this syntax: \\n \\tlabel == \\\"string_literal\\\"\n                  \\ ->  comparison, e.g. my_label == \\\"foo bar\\\" \\tlabel != \\\"string_literal\\\"\n                  \\  ->  not equal; also matches if label is not present \\tlabel in\n                  { \\\"a\\\", \\\"b\\\", \\\"c\\\", ... }  ->  true if the value of label X is\n                  one of \\\"a\\\", \\\"b\\\", \\\"c\\\" \\tlabel not in { \\\"a\\\", \\\"b\\\", \\\"c\\\",\n                  ... }  ->  true if the value of label X is not one of \\\"a\\\", \\\"b\\\",\n                  \\\"c\\\" \\thas(label_name)  -> True if that label is present \\t! expr\n                  -> negation of expr \\texpr && expr  -> Short-circuit and \\texpr\n                  || expr  -> Short-circuit or \\t( expr ) -> parens for grouping \\tall()\n                  or the empty selector -> matches all endpoints. \\n Label names are\n                  allowed to contain alphanumerics, -, _ and /. String literals are\n                  more permissive but they do not support escape characters. \\n Examples\n                  (with made-up labels): \\n \\ttype == \\\"webserver\\\" && deployment\n                  == \\\"prod\\\" \\ttype in {\\\"frontend\\\", \\\"backend\\\"} \\tdeployment !=\n                  \\\"dev\\\" \\t! has(label_name)\"\n                type: string\n              serviceAccountSelector:\n                description: ServiceAccountSelector is an optional field for an expression\n                  used to select a pod based on service accounts.\n                type: string\n              types:\n                description: \"Types indicates whether this policy applies to ingress,\n                  or to egress, or to both.  When not explicitly specified (and so\n                  the value on creation is empty or nil), Calico defaults Types according\n                  to what Ingress and Egress rules are present in the policy.  The\n                  default is: \\n - [ PolicyTypeIngress ], if there are no Egress rules\n                  (including the case where there are   also no Ingress rules) \\n\n                  - [ PolicyTypeEgress ], if there are Egress rules but no Ingress\n                  rules \\n - [ PolicyTypeIngress, PolicyTypeEgress ], if there are\n                  both Ingress and Egress rules. \\n When the policy is read back again,\n                  Types will always be one of these values, never empty or nil.\"\n                items:\n                  description: PolicyType enumerates the possible values of the PolicySpec\n                    Types field.\n                  type: string\n                type: array\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	globalnetworksets             = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: globalnetworksets.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: GlobalNetworkSet\n    listKind: GlobalNetworkSetList\n    plural: globalnetworksets\n    singular: globalnetworkset\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        description: GlobalNetworkSet contains a set of arbitrary IP sub-networks/CIDRs\n          that share labels to allow rules to refer to them via selectors.  The labels\n          of GlobalNetworkSet are not namespaced.\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: GlobalNetworkSetSpec contains the specification for a NetworkSet\n              resource.\n            properties:\n              nets:\n                description: The list of IP networks that belong to this set.\n                items:\n                  type: string\n                type: array\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	hostendpoints                 = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: hostendpoints.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: HostEndpoint\n    listKind: HostEndpointList\n    plural: hostendpoints\n    singular: hostendpoint\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: HostEndpointSpec contains the specification for a HostEndpoint\n              resource.\n            properties:\n              expectedIPs:\n                description: \"The expected IP addresses (IPv4 and IPv6) of the endpoint.\n                  If \\\"InterfaceName\\\" is not present, Calico will look for an interface\n                  matching any of the IPs in the list and apply policy to that. Note:\n                  \\tWhen using the selector match criteria in an ingress or egress\n                  security Policy \\tor Profile, Calico converts the selector into\n                  a set of IP addresses. For host \\tendpoints, the ExpectedIPs field\n                  is used for that purpose. (If only the interface \\tname is specified,\n                  Calico does not learn the IPs of the interface for use in match\n                  \\tcriteria.)\"\n                items:\n                  type: string\n                type: array\n              interfaceName:\n                description: \"Either \\\"*\\\", or the name of a specific Linux interface\n                  to apply policy to; or empty.  \\\"*\\\" indicates that this HostEndpoint\n                  governs all traffic to, from or through the default network namespace\n                  of the host named by the \\\"Node\\\" field; entering and leaving that\n                  namespace via any interface, including those from/to non-host-networked\n                  local workloads. \\n If InterfaceName is not \\\"*\\\", this HostEndpoint\n                  only governs traffic that enters or leaves the host through the\n                  specific interface named by InterfaceName, or - when InterfaceName\n                  is empty - through the specific interface that has one of the IPs\n                  in ExpectedIPs. Therefore, when InterfaceName is empty, at least\n                  one expected IP must be specified.  Only external interfaces (such\n                  as \\\"eth0\\\") are supported here; it isn't possible for a HostEndpoint\n                  to protect traffic through a specific local workload interface.\n                  \\n Note: Only some kinds of policy are implemented for \\\"*\\\" HostEndpoints;\n                  initially just pre-DNAT policy.  Please check Calico documentation\n                  for the latest position.\"\n                type: string\n              node:\n                description: The node name identifying the Calico node instance.\n                type: string\n              ports:\n                description: Ports contains the endpoint's named ports, which may\n                  be referenced in security policy rules.\n                items:\n                  properties:\n                    name:\n                      type: string\n                    port:\n                      type: integer\n                    protocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                  required:\n                  - name\n                  - port\n                  - protocol\n                  type: object\n                type: array\n              profiles:\n                description: A list of identifiers of security Profile objects that\n                  apply to this endpoint. Each profile is applied in the order that\n                  they appear in this list.  Profile rules are applied after the selector-based\n                  security policy.\n                items:\n                  type: string\n                type: array\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	ipamblocks                    = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: ipamblocks.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: IPAMBlock\n    listKind: IPAMBlockList\n    plural: ipamblocks\n    singular: ipamblock\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: IPAMBlockSpec contains the specification for an IPAMBlock\n              resource.\n            properties:\n              affinity:\n                description: Affinity of the block, if this block has one. If set,\n                  it will be of the form \"host:<hostname>\". If not set, this block\n                  is not affine to a host.\n                type: string\n              allocations:\n                description: Array of allocations in-use within this block. nil entries\n                  mean the allocation is free. For non-nil entries at index i, the\n                  index is the ordinal of the allocation within this block and the\n                  value is the index of the associated attributes in the Attributes\n                  array.\n                items:\n                  type: integer\n                  # TODO: This nullable is manually added in. We should update controller-gen\n                  # to handle []*int properly itself.\n                  nullable: true\n                type: array\n              attributes:\n                description: Attributes is an array of arbitrary metadata associated\n                  with allocations in the block. To find attributes for a given allocation,\n                  use the value of the allocation's entry in the Allocations array\n                  as the index of the element in this array.\n                items:\n                  properties:\n                    handle_id:\n                      type: string\n                    secondary:\n                      additionalProperties:\n                        type: string\n                      type: object\n                  type: object\n                type: array\n              cidr:\n                description: The block's CIDR.\n                type: string\n              deleted:\n                description: Deleted is an internal boolean used to workaround a limitation\n                  in the Kubernetes API whereby deletion will not return a conflict\n                  error if the block has been updated. It should not be set manually.\n                type: boolean\n              sequenceNumber:\n                default: 0\n                description: We store a sequence number that is updated each time\n                  the block is written. Each allocation will also store the sequence\n                  number of the block at the time of its creation. When releasing\n                  an IP, passing the sequence number associated with the allocation\n                  allows us to protect against a race condition and ensure the IP\n                  hasn't been released and re-allocated since the release request.\n                format: int64\n                type: integer\n              sequenceNumberForAllocation:\n                additionalProperties:\n                  format: int64\n                  type: integer\n                description: Map of allocated ordinal within the block to sequence\n                  number of the block at the time of allocation. Kubernetes does not\n                  allow numerical keys for maps, so the key is cast to a string.\n                type: object\n              strictAffinity:\n                description: StrictAffinity on the IPAMBlock is deprecated and no\n                  longer used by the code. Use IPAMConfig StrictAffinity instead.\n                type: boolean\n              unallocated:\n                description: Unallocated is an ordered list of allocations which are\n                  free in the block.\n                items:\n                  type: integer\n                type: array\n            required:\n            - allocations\n            - attributes\n            - cidr\n            - strictAffinity\n            - unallocated\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	ipamconfigs                   = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: ipamconfigs.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: IPAMConfig\n    listKind: IPAMConfigList\n    plural: ipamconfigs\n    singular: ipamconfig\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: IPAMConfigSpec contains the specification for an IPAMConfig\n              resource.\n            properties:\n              autoAllocateBlocks:\n                type: boolean\n              maxBlocksPerHost:\n                description: MaxBlocksPerHost, if non-zero, is the max number of blocks\n                  that can be affine to each host.\n                maximum: 2147483647\n                minimum: 0\n                type: integer\n              strictAffinity:\n                type: boolean\n            required:\n            - autoAllocateBlocks\n            - strictAffinity\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	ipamhandles                   = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: ipamhandles.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: IPAMHandle\n    listKind: IPAMHandleList\n    plural: ipamhandles\n    singular: ipamhandle\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: IPAMHandleSpec contains the specification for an IPAMHandle\n              resource.\n            properties:\n              block:\n                additionalProperties:\n                  type: integer\n                type: object\n              deleted:\n                type: boolean\n              handleID:\n                type: string\n            required:\n            - block\n            - handleID\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	ippools                       = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: ippools.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: IPPool\n    listKind: IPPoolList\n    plural: ippools\n    singular: ippool\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: IPPoolSpec contains the specification for an IPPool resource.\n            properties:\n              allowedUses:\n                description: AllowedUse controls what the IP pool will be used for.  If\n                  not specified or empty, defaults to [\"Tunnel\", \"Workload\"] for back-compatibility\n                items:\n                  type: string\n                type: array\n              blockSize:\n                description: The block size to use for IP address assignments from\n                  this pool. Defaults to 26 for IPv4 and 122 for IPv6.\n                type: integer\n              cidr:\n                description: The pool CIDR.\n                type: string\n              disableBGPExport:\n                description: 'Disable exporting routes from this IP Pool''s CIDR over\n                  BGP. [Default: false]'\n                type: boolean\n              disabled:\n                description: When disabled is true, Calico IPAM will not assign addresses\n                  from this pool.\n                type: boolean\n              ipip:\n                description: 'Deprecated: this field is only used for APIv1 backwards\n                  compatibility. Setting this field is not allowed, this field is\n                  for internal use only.'\n                properties:\n                  enabled:\n                    description: When enabled is true, ipip tunneling will be used\n                      to deliver packets to destinations within this pool.\n                    type: boolean\n                  mode:\n                    description: The IPIP mode.  This can be one of \"always\" or \"cross-subnet\".  A\n                      mode of \"always\" will also use IPIP tunneling for routing to\n                      destination IP addresses within this pool.  A mode of \"cross-subnet\"\n                      will only use IPIP tunneling when the destination node is on\n                      a different subnet to the originating node.  The default value\n                      (if not specified) is \"always\".\n                    type: string\n                type: object\n              ipipMode:\n                description: Contains configuration for IPIP tunneling for this pool.\n                  If not specified, then this is defaulted to \"Never\" (i.e. IPIP tunneling\n                  is disabled).\n                type: string\n              nat-outgoing:\n                description: 'Deprecated: this field is only used for APIv1 backwards\n                  compatibility. Setting this field is not allowed, this field is\n                  for internal use only.'\n                type: boolean\n              natOutgoing:\n                description: When natOutgoing is true, packets sent from Calico networked\n                  containers in this pool to destinations outside of this pool will\n                  be masqueraded.\n                type: boolean\n              nodeSelector:\n                description: Allows IPPool to allocate for a specific node by label\n                  selector.\n                type: string\n              vxlanMode:\n                description: Contains configuration for VXLAN tunneling for this pool.\n                  If not specified, then this is defaulted to \"Never\" (i.e. VXLAN\n                  tunneling is disabled).\n                type: string\n            required:\n            - cidr\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	ipreservations                = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  annotations:\n    controller-gen.kubebuilder.io/version: (devel)\n  creationTimestamp: null\n  name: ipreservations.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: IPReservation\n    listKind: IPReservationList\n    plural: ipreservations\n    singular: ipreservation\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: IPReservationSpec contains the specification for an IPReservation\n              resource.\n            properties:\n              reservedCIDRs:\n                description: ReservedCIDRs is a list of CIDRs and/or IP addresses\n                  that Calico IPAM will exclude from new allocations.\n                items:\n                  type: string\n                type: array\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	kubecontrollersconfigurations = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: kubecontrollersconfigurations.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: KubeControllersConfiguration\n    listKind: KubeControllersConfigurationList\n    plural: kubecontrollersconfigurations\n    singular: kubecontrollersconfiguration\n  preserveUnknownFields: false\n  scope: Cluster\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: KubeControllersConfigurationSpec contains the values of the\n              Kubernetes controllers configuration.\n            properties:\n              controllers:\n                description: Controllers enables and configures individual Kubernetes\n                  controllers\n                properties:\n                  namespace:\n                    description: Namespace enables and configures the namespace controller.\n                      Enabled by default, set to nil to disable.\n                    properties:\n                      reconcilerPeriod:\n                        description: 'ReconcilerPeriod is the period to perform reconciliation\n                          with the Calico datastore. [Default: 5m]'\n                        type: string\n                    type: object\n                  node:\n                    description: Node enables and configures the node controller.\n                      Enabled by default, set to nil to disable.\n                    properties:\n                      hostEndpoint:\n                        description: HostEndpoint controls syncing nodes to host endpoints.\n                          Disabled by default, set to nil to disable.\n                        properties:\n                          autoCreate:\n                            description: 'AutoCreate enables automatic creation of\n                              host endpoints for every node. [Default: Disabled]'\n                            type: string\n                        type: object\n                      leakGracePeriod:\n                        description: 'LeakGracePeriod is the period used by the controller\n                          to determine if an IP address has been leaked. Set to 0\n                          to disable IP garbage collection. [Default: 15m]'\n                        type: string\n                      reconcilerPeriod:\n                        description: 'ReconcilerPeriod is the period to perform reconciliation\n                          with the Calico datastore. [Default: 5m]'\n                        type: string\n                      syncLabels:\n                        description: 'SyncLabels controls whether to copy Kubernetes\n                          node labels to Calico nodes. [Default: Enabled]'\n                        type: string\n                    type: object\n                  policy:\n                    description: Policy enables and configures the policy controller.\n                      Enabled by default, set to nil to disable.\n                    properties:\n                      reconcilerPeriod:\n                        description: 'ReconcilerPeriod is the period to perform reconciliation\n                          with the Calico datastore. [Default: 5m]'\n                        type: string\n                    type: object\n                  serviceAccount:\n                    description: ServiceAccount enables and configures the service\n                      account controller. Enabled by default, set to nil to disable.\n                    properties:\n                      reconcilerPeriod:\n                        description: 'ReconcilerPeriod is the period to perform reconciliation\n                          with the Calico datastore. [Default: 5m]'\n                        type: string\n                    type: object\n                  workloadEndpoint:\n                    description: WorkloadEndpoint enables and configures the workload\n                      endpoint controller. Enabled by default, set to nil to disable.\n                    properties:\n                      reconcilerPeriod:\n                        description: 'ReconcilerPeriod is the period to perform reconciliation\n                          with the Calico datastore. [Default: 5m]'\n                        type: string\n                    type: object\n                type: object\n              debugProfilePort:\n                description: DebugProfilePort configures the port to serve memory\n                  and cpu profiles on. If not specified, profiling is disabled.\n                format: int32\n                type: integer\n              etcdV3CompactionPeriod:\n                description: 'EtcdV3CompactionPeriod is the period between etcdv3\n                  compaction requests. Set to 0 to disable. [Default: 10m]'\n                type: string\n              healthChecks:\n                description: 'HealthChecks enables or disables support for health\n                  checks [Default: Enabled]'\n                type: string\n              logSeverityScreen:\n                description: 'LogSeverityScreen is the log severity above which logs\n                  are sent to the stdout. [Default: Info]'\n                type: string\n              prometheusMetricsPort:\n                description: 'PrometheusMetricsPort is the TCP port that the Prometheus\n                  metrics server should bind to. Set to 0 to disable. [Default: 9094]'\n                type: integer\n            required:\n            - controllers\n            type: object\n          status:\n            description: KubeControllersConfigurationStatus represents the status\n              of the configuration. It's useful for admins to be able to see the actual\n              config that was applied, which can be modified by environment variables\n              on the kube-controllers process.\n            properties:\n              environmentVars:\n                additionalProperties:\n                  type: string\n                description: EnvironmentVars contains the environment variables on\n                  the kube-controllers that influenced the RunningConfig.\n                type: object\n              runningConfig:\n                description: RunningConfig contains the effective config that is running\n                  in the kube-controllers pod, after merging the API resource with\n                  any environment variables.\n                properties:\n                  controllers:\n                    description: Controllers enables and configures individual Kubernetes\n                      controllers\n                    properties:\n                      namespace:\n                        description: Namespace enables and configures the namespace\n                          controller. Enabled by default, set to nil to disable.\n                        properties:\n                          reconcilerPeriod:\n                            description: 'ReconcilerPeriod is the period to perform\n                              reconciliation with the Calico datastore. [Default:\n                              5m]'\n                            type: string\n                        type: object\n                      node:\n                        description: Node enables and configures the node controller.\n                          Enabled by default, set to nil to disable.\n                        properties:\n                          hostEndpoint:\n                            description: HostEndpoint controls syncing nodes to host\n                              endpoints. Disabled by default, set to nil to disable.\n                            properties:\n                              autoCreate:\n                                description: 'AutoCreate enables automatic creation\n                                  of host endpoints for every node. [Default: Disabled]'\n                                type: string\n                            type: object\n                          leakGracePeriod:\n                            description: 'LeakGracePeriod is the period used by the\n                              controller to determine if an IP address has been leaked.\n                              Set to 0 to disable IP garbage collection. [Default:\n                              15m]'\n                            type: string\n                          reconcilerPeriod:\n                            description: 'ReconcilerPeriod is the period to perform\n                              reconciliation with the Calico datastore. [Default:\n                              5m]'\n                            type: string\n                          syncLabels:\n                            description: 'SyncLabels controls whether to copy Kubernetes\n                              node labels to Calico nodes. [Default: Enabled]'\n                            type: string\n                        type: object\n                      policy:\n                        description: Policy enables and configures the policy controller.\n                          Enabled by default, set to nil to disable.\n                        properties:\n                          reconcilerPeriod:\n                            description: 'ReconcilerPeriod is the period to perform\n                              reconciliation with the Calico datastore. [Default:\n                              5m]'\n                            type: string\n                        type: object\n                      serviceAccount:\n                        description: ServiceAccount enables and configures the service\n                          account controller. Enabled by default, set to nil to disable.\n                        properties:\n                          reconcilerPeriod:\n                            description: 'ReconcilerPeriod is the period to perform\n                              reconciliation with the Calico datastore. [Default:\n                              5m]'\n                            type: string\n                        type: object\n                      workloadEndpoint:\n                        description: WorkloadEndpoint enables and configures the workload\n                          endpoint controller. Enabled by default, set to nil to disable.\n                        properties:\n                          reconcilerPeriod:\n                            description: 'ReconcilerPeriod is the period to perform\n                              reconciliation with the Calico datastore. [Default:\n                              5m]'\n                            type: string\n                        type: object\n                    type: object\n                  debugProfilePort:\n                    description: DebugProfilePort configures the port to serve memory\n                      and cpu profiles on. If not specified, profiling is disabled.\n                    format: int32\n                    type: integer\n                  etcdV3CompactionPeriod:\n                    description: 'EtcdV3CompactionPeriod is the period between etcdv3\n                      compaction requests. Set to 0 to disable. [Default: 10m]'\n                    type: string\n                  healthChecks:\n                    description: 'HealthChecks enables or disables support for health\n                      checks [Default: Enabled]'\n                    type: string\n                  logSeverityScreen:\n                    description: 'LogSeverityScreen is the log severity above which\n                      logs are sent to the stdout. [Default: Info]'\n                    type: string\n                  prometheusMetricsPort:\n                    description: 'PrometheusMetricsPort is the TCP port that the Prometheus\n                      metrics server should bind to. Set to 0 to disable. [Default:\n                      9094]'\n                    type: integer\n                required:\n                - controllers\n                type: object\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	networkpolicies               = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: networkpolicies.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: NetworkPolicy\n    listKind: NetworkPolicyList\n    plural: networkpolicies\n    singular: networkpolicy\n  preserveUnknownFields: false\n  scope: Namespaced\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            properties:\n              egress:\n                description: The ordered set of egress rules.  Each rule contains\n                  a set of packet match criteria and a corresponding action to apply.\n                items:\n                  description: \"A Rule encapsulates a set of match criteria and an\n                    action.  Both selector-based security Policy and security Profiles\n                    reference rules - separated out as a list of rules for both ingress\n                    and egress packet matching. \\n Each positive match criteria has\n                    a negated version, prefixed with \\\"Not\\\". All the match criteria\n                    within a rule must be satisfied for a packet to match. A single\n                    rule can contain the positive and negative version of a match\n                    and both must be satisfied for the rule to match.\"\n                  properties:\n                    action:\n                      type: string\n                    destination:\n                      description: Destination contains the match criteria that apply\n                        to destination entity.\n                      properties:\n                        namespaceSelector:\n                          description: \"NamespaceSelector is an optional field that\n                            contains a selector expression. Only traffic that originates\n                            from (or terminates at) endpoints within the selected\n                            namespaces will be matched. When both NamespaceSelector\n                            and another selector are defined on the same rule, then\n                            only workload endpoints that are matched by both selectors\n                            will be selected by the rule. \\n For NetworkPolicy, an\n                            empty NamespaceSelector implies that the Selector is limited\n                            to selecting only workload endpoints in the same namespace\n                            as the NetworkPolicy. \\n For NetworkPolicy, `global()`\n                            NamespaceSelector implies that the Selector is limited\n                            to selecting only GlobalNetworkSet or HostEndpoint. \\n\n                            For GlobalNetworkPolicy, an empty NamespaceSelector implies\n                            the Selector applies to workload endpoints across all\n                            namespaces.\"\n                          type: string\n                        nets:\n                          description: Nets is an optional field that restricts the\n                            rule to only apply to traffic that originates from (or\n                            terminates at) IP addresses in any of the given subnets.\n                          items:\n                            type: string\n                          type: array\n                        notNets:\n                          description: NotNets is the negated version of the Nets\n                            field.\n                          items:\n                            type: string\n                          type: array\n                        notPorts:\n                          description: NotPorts is the negated version of the Ports\n                            field. Since only some protocols have ports, if any ports\n                            are specified it requires the Protocol match in the Rule\n                            to be set to \"TCP\" or \"UDP\".\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        notSelector:\n                          description: NotSelector is the negated version of the Selector\n                            field.  See Selector field for subtleties with negated\n                            selectors.\n                          type: string\n                        ports:\n                          description: \"Ports is an optional field that restricts\n                            the rule to only apply to traffic that has a source (destination)\n                            port that matches one of these ranges/values. This value\n                            is a list of integers or strings that represent ranges\n                            of ports. \\n Since only some protocols have ports, if\n                            any ports are specified it requires the Protocol match\n                            in the Rule to be set to \\\"TCP\\\" or \\\"UDP\\\".\"\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        selector:\n                          description: \"Selector is an optional field that contains\n                            a selector expression (see Policy for sample syntax).\n                            \\ Only traffic that originates from (terminates at) endpoints\n                            matching the selector will be matched. \\n Note that: in\n                            addition to the negated version of the Selector (see NotSelector\n                            below), the selector expression syntax itself supports\n                            negation.  The two types of negation are subtly different.\n                            One negates the set of matched endpoints, the other negates\n                            the whole match: \\n \\tSelector = \\\"!has(my_label)\\\" matches\n                            packets that are from other Calico-controlled \\tendpoints\n                            that do not have the label \\\"my_label\\\". \\n \\tNotSelector\n                            = \\\"has(my_label)\\\" matches packets that are not from\n                            Calico-controlled \\tendpoints that do have the label \\\"my_label\\\".\n                            \\n The effect is that the latter will accept packets from\n                            non-Calico sources whereas the former is limited to packets\n                            from Calico-controlled endpoints.\"\n                          type: string\n                        serviceAccounts:\n                          description: ServiceAccounts is an optional field that restricts\n                            the rule to only apply to traffic that originates from\n                            (or terminates at) a pod running as a matching service\n                            account.\n                          properties:\n                            names:\n                              description: Names is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account whose name is in the list.\n                              items:\n                                type: string\n                              type: array\n                            selector:\n                              description: Selector is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account that matches the given label selector. If\n                                both Names and Selector are specified then they are\n                                AND'ed.\n                              type: string\n                          type: object\n                        services:\n                          description: \"Services is an optional field that contains\n                            options for matching Kubernetes Services. If specified,\n                            only traffic that originates from or terminates at endpoints\n                            within the selected service(s) will be matched, and only\n                            to/from each endpoint's port. \\n Services cannot be specified\n                            on the same rule as Selector, NotSelector, NamespaceSelector,\n                            Nets, NotNets or ServiceAccounts. \\n Ports and NotPorts\n                            can only be specified with Services on ingress rules.\"\n                          properties:\n                            name:\n                              description: Name specifies the name of a Kubernetes\n                                Service to match.\n                              type: string\n                            namespace:\n                              description: Namespace specifies the namespace of the\n                                given Service. If left empty, the rule will match\n                                within this policy's namespace.\n                              type: string\n                          type: object\n                      type: object\n                    http:\n                      description: HTTP contains match criteria that apply to HTTP\n                        requests.\n                      properties:\n                        methods:\n                          description: Methods is an optional field that restricts\n                            the rule to apply only to HTTP requests that use one of\n                            the listed HTTP Methods (e.g. GET, PUT, etc.) Multiple\n                            methods are OR'd together.\n                          items:\n                            type: string\n                          type: array\n                        paths:\n                          description: 'Paths is an optional field that restricts\n                            the rule to apply to HTTP requests that use one of the\n                            listed HTTP Paths. Multiple paths are OR''d together.\n                            e.g: - exact: /foo - prefix: /bar NOTE: Each entry may\n                            ONLY specify either a `exact` or a `prefix` match. The\n                            validator will check for it.'\n                          items:\n                            description: 'HTTPPath specifies an HTTP path to match.\n                              It may be either of the form: exact: <path>: which matches\n                              the path exactly or prefix: <path-prefix>: which matches\n                              the path prefix'\n                            properties:\n                              exact:\n                                type: string\n                              prefix:\n                                type: string\n                            type: object\n                          type: array\n                      type: object\n                    icmp:\n                      description: ICMP is an optional field that restricts the rule\n                        to apply to a specific type and code of ICMP traffic.  This\n                        should only be specified if the Protocol field is set to \"ICMP\"\n                        or \"ICMPv6\".\n                      properties:\n                        code:\n                          description: Match on a specific ICMP code.  If specified,\n                            the Type value must also be specified. This is a technical\n                            limitation imposed by the kernel's iptables firewall,\n                            which Calico uses to enforce the rule.\n                          type: integer\n                        type:\n                          description: Match on a specific ICMP type.  For example\n                            a value of 8 refers to ICMP Echo Request (i.e. pings).\n                          type: integer\n                      type: object\n                    ipVersion:\n                      description: IPVersion is an optional field that restricts the\n                        rule to only match a specific IP version.\n                      type: integer\n                    metadata:\n                      description: Metadata contains additional information for this\n                        rule\n                      properties:\n                        annotations:\n                          additionalProperties:\n                            type: string\n                          description: Annotations is a set of key value pairs that\n                            give extra information about the rule\n                          type: object\n                      type: object\n                    notICMP:\n                      description: NotICMP is the negated version of the ICMP field.\n                      properties:\n                        code:\n                          description: Match on a specific ICMP code.  If specified,\n                            the Type value must also be specified. This is a technical\n                            limitation imposed by the kernel's iptables firewall,\n                            which Calico uses to enforce the rule.\n                          type: integer\n                        type:\n                          description: Match on a specific ICMP type.  For example\n                            a value of 8 refers to ICMP Echo Request (i.e. pings).\n                          type: integer\n                      type: object\n                    notProtocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      description: NotProtocol is the negated version of the Protocol\n                        field.\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                    protocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      description: \"Protocol is an optional field that restricts the\n                        rule to only apply to traffic of a specific IP protocol. Required\n                        if any of the EntityRules contain Ports (because ports only\n                        apply to certain protocols). \\n Must be one of these string\n                        values: \\\"TCP\\\", \\\"UDP\\\", \\\"ICMP\\\", \\\"ICMPv6\\\", \\\"SCTP\\\",\n                        \\\"UDPLite\\\" or an integer in the range 1-255.\"\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                    source:\n                      description: Source contains the match criteria that apply to\n                        source entity.\n                      properties:\n                        namespaceSelector:\n                          description: \"NamespaceSelector is an optional field that\n                            contains a selector expression. Only traffic that originates\n                            from (or terminates at) endpoints within the selected\n                            namespaces will be matched. When both NamespaceSelector\n                            and another selector are defined on the same rule, then\n                            only workload endpoints that are matched by both selectors\n                            will be selected by the rule. \\n For NetworkPolicy, an\n                            empty NamespaceSelector implies that the Selector is limited\n                            to selecting only workload endpoints in the same namespace\n                            as the NetworkPolicy. \\n For NetworkPolicy, `global()`\n                            NamespaceSelector implies that the Selector is limited\n                            to selecting only GlobalNetworkSet or HostEndpoint. \\n\n                            For GlobalNetworkPolicy, an empty NamespaceSelector implies\n                            the Selector applies to workload endpoints across all\n                            namespaces.\"\n                          type: string\n                        nets:\n                          description: Nets is an optional field that restricts the\n                            rule to only apply to traffic that originates from (or\n                            terminates at) IP addresses in any of the given subnets.\n                          items:\n                            type: string\n                          type: array\n                        notNets:\n                          description: NotNets is the negated version of the Nets\n                            field.\n                          items:\n                            type: string\n                          type: array\n                        notPorts:\n                          description: NotPorts is the negated version of the Ports\n                            field. Since only some protocols have ports, if any ports\n                            are specified it requires the Protocol match in the Rule\n                            to be set to \"TCP\" or \"UDP\".\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        notSelector:\n                          description: NotSelector is the negated version of the Selector\n                            field.  See Selector field for subtleties with negated\n                            selectors.\n                          type: string\n                        ports:\n                          description: \"Ports is an optional field that restricts\n                            the rule to only apply to traffic that has a source (destination)\n                            port that matches one of these ranges/values. This value\n                            is a list of integers or strings that represent ranges\n                            of ports. \\n Since only some protocols have ports, if\n                            any ports are specified it requires the Protocol match\n                            in the Rule to be set to \\\"TCP\\\" or \\\"UDP\\\".\"\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        selector:\n                          description: \"Selector is an optional field that contains\n                            a selector expression (see Policy for sample syntax).\n                            \\ Only traffic that originates from (terminates at) endpoints\n                            matching the selector will be matched. \\n Note that: in\n                            addition to the negated version of the Selector (see NotSelector\n                            below), the selector expression syntax itself supports\n                            negation.  The two types of negation are subtly different.\n                            One negates the set of matched endpoints, the other negates\n                            the whole match: \\n \\tSelector = \\\"!has(my_label)\\\" matches\n                            packets that are from other Calico-controlled \\tendpoints\n                            that do not have the label \\\"my_label\\\". \\n \\tNotSelector\n                            = \\\"has(my_label)\\\" matches packets that are not from\n                            Calico-controlled \\tendpoints that do have the label \\\"my_label\\\".\n                            \\n The effect is that the latter will accept packets from\n                            non-Calico sources whereas the former is limited to packets\n                            from Calico-controlled endpoints.\"\n                          type: string\n                        serviceAccounts:\n                          description: ServiceAccounts is an optional field that restricts\n                            the rule to only apply to traffic that originates from\n                            (or terminates at) a pod running as a matching service\n                            account.\n                          properties:\n                            names:\n                              description: Names is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account whose name is in the list.\n                              items:\n                                type: string\n                              type: array\n                            selector:\n                              description: Selector is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account that matches the given label selector. If\n                                both Names and Selector are specified then they are\n                                AND'ed.\n                              type: string\n                          type: object\n                        services:\n                          description: \"Services is an optional field that contains\n                            options for matching Kubernetes Services. If specified,\n                            only traffic that originates from or terminates at endpoints\n                            within the selected service(s) will be matched, and only\n                            to/from each endpoint's port. \\n Services cannot be specified\n                            on the same rule as Selector, NotSelector, NamespaceSelector,\n                            Nets, NotNets or ServiceAccounts. \\n Ports and NotPorts\n                            can only be specified with Services on ingress rules.\"\n                          properties:\n                            name:\n                              description: Name specifies the name of a Kubernetes\n                                Service to match.\n                              type: string\n                            namespace:\n                              description: Namespace specifies the namespace of the\n                                given Service. If left empty, the rule will match\n                                within this policy's namespace.\n                              type: string\n                          type: object\n                      type: object\n                  required:\n                  - action\n                  type: object\n                type: array\n              ingress:\n                description: The ordered set of ingress rules.  Each rule contains\n                  a set of packet match criteria and a corresponding action to apply.\n                items:\n                  description: \"A Rule encapsulates a set of match criteria and an\n                    action.  Both selector-based security Policy and security Profiles\n                    reference rules - separated out as a list of rules for both ingress\n                    and egress packet matching. \\n Each positive match criteria has\n                    a negated version, prefixed with \\\"Not\\\". All the match criteria\n                    within a rule must be satisfied for a packet to match. A single\n                    rule can contain the positive and negative version of a match\n                    and both must be satisfied for the rule to match.\"\n                  properties:\n                    action:\n                      type: string\n                    destination:\n                      description: Destination contains the match criteria that apply\n                        to destination entity.\n                      properties:\n                        namespaceSelector:\n                          description: \"NamespaceSelector is an optional field that\n                            contains a selector expression. Only traffic that originates\n                            from (or terminates at) endpoints within the selected\n                            namespaces will be matched. When both NamespaceSelector\n                            and another selector are defined on the same rule, then\n                            only workload endpoints that are matched by both selectors\n                            will be selected by the rule. \\n For NetworkPolicy, an\n                            empty NamespaceSelector implies that the Selector is limited\n                            to selecting only workload endpoints in the same namespace\n                            as the NetworkPolicy. \\n For NetworkPolicy, `global()`\n                            NamespaceSelector implies that the Selector is limited\n                            to selecting only GlobalNetworkSet or HostEndpoint. \\n\n                            For GlobalNetworkPolicy, an empty NamespaceSelector implies\n                            the Selector applies to workload endpoints across all\n                            namespaces.\"\n                          type: string\n                        nets:\n                          description: Nets is an optional field that restricts the\n                            rule to only apply to traffic that originates from (or\n                            terminates at) IP addresses in any of the given subnets.\n                          items:\n                            type: string\n                          type: array\n                        notNets:\n                          description: NotNets is the negated version of the Nets\n                            field.\n                          items:\n                            type: string\n                          type: array\n                        notPorts:\n                          description: NotPorts is the negated version of the Ports\n                            field. Since only some protocols have ports, if any ports\n                            are specified it requires the Protocol match in the Rule\n                            to be set to \"TCP\" or \"UDP\".\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        notSelector:\n                          description: NotSelector is the negated version of the Selector\n                            field.  See Selector field for subtleties with negated\n                            selectors.\n                          type: string\n                        ports:\n                          description: \"Ports is an optional field that restricts\n                            the rule to only apply to traffic that has a source (destination)\n                            port that matches one of these ranges/values. This value\n                            is a list of integers or strings that represent ranges\n                            of ports. \\n Since only some protocols have ports, if\n                            any ports are specified it requires the Protocol match\n                            in the Rule to be set to \\\"TCP\\\" or \\\"UDP\\\".\"\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        selector:\n                          description: \"Selector is an optional field that contains\n                            a selector expression (see Policy for sample syntax).\n                            \\ Only traffic that originates from (terminates at) endpoints\n                            matching the selector will be matched. \\n Note that: in\n                            addition to the negated version of the Selector (see NotSelector\n                            below), the selector expression syntax itself supports\n                            negation.  The two types of negation are subtly different.\n                            One negates the set of matched endpoints, the other negates\n                            the whole match: \\n \\tSelector = \\\"!has(my_label)\\\" matches\n                            packets that are from other Calico-controlled \\tendpoints\n                            that do not have the label \\\"my_label\\\". \\n \\tNotSelector\n                            = \\\"has(my_label)\\\" matches packets that are not from\n                            Calico-controlled \\tendpoints that do have the label \\\"my_label\\\".\n                            \\n The effect is that the latter will accept packets from\n                            non-Calico sources whereas the former is limited to packets\n                            from Calico-controlled endpoints.\"\n                          type: string\n                        serviceAccounts:\n                          description: ServiceAccounts is an optional field that restricts\n                            the rule to only apply to traffic that originates from\n                            (or terminates at) a pod running as a matching service\n                            account.\n                          properties:\n                            names:\n                              description: Names is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account whose name is in the list.\n                              items:\n                                type: string\n                              type: array\n                            selector:\n                              description: Selector is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account that matches the given label selector. If\n                                both Names and Selector are specified then they are\n                                AND'ed.\n                              type: string\n                          type: object\n                        services:\n                          description: \"Services is an optional field that contains\n                            options for matching Kubernetes Services. If specified,\n                            only traffic that originates from or terminates at endpoints\n                            within the selected service(s) will be matched, and only\n                            to/from each endpoint's port. \\n Services cannot be specified\n                            on the same rule as Selector, NotSelector, NamespaceSelector,\n                            Nets, NotNets or ServiceAccounts. \\n Ports and NotPorts\n                            can only be specified with Services on ingress rules.\"\n                          properties:\n                            name:\n                              description: Name specifies the name of a Kubernetes\n                                Service to match.\n                              type: string\n                            namespace:\n                              description: Namespace specifies the namespace of the\n                                given Service. If left empty, the rule will match\n                                within this policy's namespace.\n                              type: string\n                          type: object\n                      type: object\n                    http:\n                      description: HTTP contains match criteria that apply to HTTP\n                        requests.\n                      properties:\n                        methods:\n                          description: Methods is an optional field that restricts\n                            the rule to apply only to HTTP requests that use one of\n                            the listed HTTP Methods (e.g. GET, PUT, etc.) Multiple\n                            methods are OR'd together.\n                          items:\n                            type: string\n                          type: array\n                        paths:\n                          description: 'Paths is an optional field that restricts\n                            the rule to apply to HTTP requests that use one of the\n                            listed HTTP Paths. Multiple paths are OR''d together.\n                            e.g: - exact: /foo - prefix: /bar NOTE: Each entry may\n                            ONLY specify either a `exact` or a `prefix` match. The\n                            validator will check for it.'\n                          items:\n                            description: 'HTTPPath specifies an HTTP path to match.\n                              It may be either of the form: exact: <path>: which matches\n                              the path exactly or prefix: <path-prefix>: which matches\n                              the path prefix'\n                            properties:\n                              exact:\n                                type: string\n                              prefix:\n                                type: string\n                            type: object\n                          type: array\n                      type: object\n                    icmp:\n                      description: ICMP is an optional field that restricts the rule\n                        to apply to a specific type and code of ICMP traffic.  This\n                        should only be specified if the Protocol field is set to \"ICMP\"\n                        or \"ICMPv6\".\n                      properties:\n                        code:\n                          description: Match on a specific ICMP code.  If specified,\n                            the Type value must also be specified. This is a technical\n                            limitation imposed by the kernel's iptables firewall,\n                            which Calico uses to enforce the rule.\n                          type: integer\n                        type:\n                          description: Match on a specific ICMP type.  For example\n                            a value of 8 refers to ICMP Echo Request (i.e. pings).\n                          type: integer\n                      type: object\n                    ipVersion:\n                      description: IPVersion is an optional field that restricts the\n                        rule to only match a specific IP version.\n                      type: integer\n                    metadata:\n                      description: Metadata contains additional information for this\n                        rule\n                      properties:\n                        annotations:\n                          additionalProperties:\n                            type: string\n                          description: Annotations is a set of key value pairs that\n                            give extra information about the rule\n                          type: object\n                      type: object\n                    notICMP:\n                      description: NotICMP is the negated version of the ICMP field.\n                      properties:\n                        code:\n                          description: Match on a specific ICMP code.  If specified,\n                            the Type value must also be specified. This is a technical\n                            limitation imposed by the kernel's iptables firewall,\n                            which Calico uses to enforce the rule.\n                          type: integer\n                        type:\n                          description: Match on a specific ICMP type.  For example\n                            a value of 8 refers to ICMP Echo Request (i.e. pings).\n                          type: integer\n                      type: object\n                    notProtocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      description: NotProtocol is the negated version of the Protocol\n                        field.\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                    protocol:\n                      anyOf:\n                      - type: integer\n                      - type: string\n                      description: \"Protocol is an optional field that restricts the\n                        rule to only apply to traffic of a specific IP protocol. Required\n                        if any of the EntityRules contain Ports (because ports only\n                        apply to certain protocols). \\n Must be one of these string\n                        values: \\\"TCP\\\", \\\"UDP\\\", \\\"ICMP\\\", \\\"ICMPv6\\\", \\\"SCTP\\\",\n                        \\\"UDPLite\\\" or an integer in the range 1-255.\"\n                      pattern: ^.*\n                      x-kubernetes-int-or-string: true\n                    source:\n                      description: Source contains the match criteria that apply to\n                        source entity.\n                      properties:\n                        namespaceSelector:\n                          description: \"NamespaceSelector is an optional field that\n                            contains a selector expression. Only traffic that originates\n                            from (or terminates at) endpoints within the selected\n                            namespaces will be matched. When both NamespaceSelector\n                            and another selector are defined on the same rule, then\n                            only workload endpoints that are matched by both selectors\n                            will be selected by the rule. \\n For NetworkPolicy, an\n                            empty NamespaceSelector implies that the Selector is limited\n                            to selecting only workload endpoints in the same namespace\n                            as the NetworkPolicy. \\n For NetworkPolicy, `global()`\n                            NamespaceSelector implies that the Selector is limited\n                            to selecting only GlobalNetworkSet or HostEndpoint. \\n\n                            For GlobalNetworkPolicy, an empty NamespaceSelector implies\n                            the Selector applies to workload endpoints across all\n                            namespaces.\"\n                          type: string\n                        nets:\n                          description: Nets is an optional field that restricts the\n                            rule to only apply to traffic that originates from (or\n                            terminates at) IP addresses in any of the given subnets.\n                          items:\n                            type: string\n                          type: array\n                        notNets:\n                          description: NotNets is the negated version of the Nets\n                            field.\n                          items:\n                            type: string\n                          type: array\n                        notPorts:\n                          description: NotPorts is the negated version of the Ports\n                            field. Since only some protocols have ports, if any ports\n                            are specified it requires the Protocol match in the Rule\n                            to be set to \"TCP\" or \"UDP\".\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        notSelector:\n                          description: NotSelector is the negated version of the Selector\n                            field.  See Selector field for subtleties with negated\n                            selectors.\n                          type: string\n                        ports:\n                          description: \"Ports is an optional field that restricts\n                            the rule to only apply to traffic that has a source (destination)\n                            port that matches one of these ranges/values. This value\n                            is a list of integers or strings that represent ranges\n                            of ports. \\n Since only some protocols have ports, if\n                            any ports are specified it requires the Protocol match\n                            in the Rule to be set to \\\"TCP\\\" or \\\"UDP\\\".\"\n                          items:\n                            anyOf:\n                            - type: integer\n                            - type: string\n                            pattern: ^.*\n                            x-kubernetes-int-or-string: true\n                          type: array\n                        selector:\n                          description: \"Selector is an optional field that contains\n                            a selector expression (see Policy for sample syntax).\n                            \\ Only traffic that originates from (terminates at) endpoints\n                            matching the selector will be matched. \\n Note that: in\n                            addition to the negated version of the Selector (see NotSelector\n                            below), the selector expression syntax itself supports\n                            negation.  The two types of negation are subtly different.\n                            One negates the set of matched endpoints, the other negates\n                            the whole match: \\n \\tSelector = \\\"!has(my_label)\\\" matches\n                            packets that are from other Calico-controlled \\tendpoints\n                            that do not have the label \\\"my_label\\\". \\n \\tNotSelector\n                            = \\\"has(my_label)\\\" matches packets that are not from\n                            Calico-controlled \\tendpoints that do have the label \\\"my_label\\\".\n                            \\n The effect is that the latter will accept packets from\n                            non-Calico sources whereas the former is limited to packets\n                            from Calico-controlled endpoints.\"\n                          type: string\n                        serviceAccounts:\n                          description: ServiceAccounts is an optional field that restricts\n                            the rule to only apply to traffic that originates from\n                            (or terminates at) a pod running as a matching service\n                            account.\n                          properties:\n                            names:\n                              description: Names is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account whose name is in the list.\n                              items:\n                                type: string\n                              type: array\n                            selector:\n                              description: Selector is an optional field that restricts\n                                the rule to only apply to traffic that originates\n                                from (or terminates at) a pod running as a service\n                                account that matches the given label selector. If\n                                both Names and Selector are specified then they are\n                                AND'ed.\n                              type: string\n                          type: object\n                        services:\n                          description: \"Services is an optional field that contains\n                            options for matching Kubernetes Services. If specified,\n                            only traffic that originates from or terminates at endpoints\n                            within the selected service(s) will be matched, and only\n                            to/from each endpoint's port. \\n Services cannot be specified\n                            on the same rule as Selector, NotSelector, NamespaceSelector,\n                            Nets, NotNets or ServiceAccounts. \\n Ports and NotPorts\n                            can only be specified with Services on ingress rules.\"\n                          properties:\n                            name:\n                              description: Name specifies the name of a Kubernetes\n                                Service to match.\n                              type: string\n                            namespace:\n                              description: Namespace specifies the namespace of the\n                                given Service. If left empty, the rule will match\n                                within this policy's namespace.\n                              type: string\n                          type: object\n                      type: object\n                  required:\n                  - action\n                  type: object\n                type: array\n              order:\n                description: Order is an optional field that specifies the order in\n                  which the policy is applied. Policies with higher \"order\" are applied\n                  after those with lower order.  If the order is omitted, it may be\n                  considered to be \"infinite\" - i.e. the policy will be applied last.  Policies\n                  with identical order will be applied in alphanumerical order based\n                  on the Policy \"Name\".\n                type: number\n              selector:\n                description: \"The selector is an expression used to pick pick out\n                  the endpoints that the policy should be applied to. \\n Selector\n                  expressions follow this syntax: \\n \\tlabel == \\\"string_literal\\\"\n                  \\ ->  comparison, e.g. my_label == \\\"foo bar\\\" \\tlabel != \\\"string_literal\\\"\n                  \\  ->  not equal; also matches if label is not present \\tlabel in\n                  { \\\"a\\\", \\\"b\\\", \\\"c\\\", ... }  ->  true if the value of label X is\n                  one of \\\"a\\\", \\\"b\\\", \\\"c\\\" \\tlabel not in { \\\"a\\\", \\\"b\\\", \\\"c\\\",\n                  ... }  ->  true if the value of label X is not one of \\\"a\\\", \\\"b\\\",\n                  \\\"c\\\" \\thas(label_name)  -> True if that label is present \\t! expr\n                  -> negation of expr \\texpr && expr  -> Short-circuit and \\texpr\n                  || expr  -> Short-circuit or \\t( expr ) -> parens for grouping \\tall()\n                  or the empty selector -> matches all endpoints. \\n Label names are\n                  allowed to contain alphanumerics, -, _ and /. String literals are\n                  more permissive but they do not support escape characters. \\n Examples\n                  (with made-up labels): \\n \\ttype == \\\"webserver\\\" && deployment\n                  == \\\"prod\\\" \\ttype in {\\\"frontend\\\", \\\"backend\\\"} \\tdeployment !=\n                  \\\"dev\\\" \\t! has(label_name)\"\n                type: string\n              serviceAccountSelector:\n                description: ServiceAccountSelector is an optional field for an expression\n                  used to select a pod based on service accounts.\n                type: string\n              types:\n                description: \"Types indicates whether this policy applies to ingress,\n                  or to egress, or to both.  When not explicitly specified (and so\n                  the value on creation is empty or nil), Calico defaults Types according\n                  to what Ingress and Egress are present in the policy.  The default\n                  is: \\n - [ PolicyTypeIngress ], if there are no Egress rules (including\n                  the case where there are   also no Ingress rules) \\n - [ PolicyTypeEgress\n                  ], if there are Egress rules but no Ingress rules \\n - [ PolicyTypeIngress,\n                  PolicyTypeEgress ], if there are both Ingress and Egress rules.\n                  \\n When the policy is read back again, Types will always be one\n                  of these values, never empty or nil.\"\n                items:\n                  description: PolicyType enumerates the possible values of the PolicySpec\n                    Types field.\n                  type: string\n                type: array\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
	networksets                   = "apiVersion: apiextensions.k8s.io/v1\nkind: CustomResourceDefinition\nmetadata:\n  name: networksets.crd.projectcalico.org\nspec:\n  group: crd.projectcalico.org\n  names:\n    kind: NetworkSet\n    listKind: NetworkSetList\n    plural: networksets\n    singular: networkset\n  preserveUnknownFields: false\n  scope: Namespaced\n  versions:\n  - name: v1\n    schema:\n      openAPIV3Schema:\n        description: NetworkSet is the Namespaced-equivalent of the GlobalNetworkSet.\n        properties:\n          apiVersion:\n            description: 'APIVersion defines the versioned schema of this representation\n              of an object. Servers should convert recognized schemas to the latest\n              internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources'\n            type: string\n          kind:\n            description: 'Kind is a string value representing the REST resource this\n              object represents. Servers may infer this from the endpoint the client\n              submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds'\n            type: string\n          metadata:\n            type: object\n          spec:\n            description: NetworkSetSpec contains the specification for a NetworkSet\n              resource.\n            properties:\n              nets:\n                description: The list of IP networks that belong to this set.\n                items:\n                  type: string\n                type: array\n            type: object\n        type: object\n    served: true\n    storage: true\nstatus:\n  acceptedNames:\n    kind: \"\"\n    plural: \"\"\n  conditions: []\n  storedVersions: []\n"
)
