// Copyright (c) 2023 Tigera, Inc. All rights reserved.

// Code generated by lister-gen. DO NOT EDIT.

package v3

import (
	v3 "github.com/projectcalico/api/pkg/apis/projectcalico/v3"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// IPAMConfigurationLister helps list IPAMConfigurations.
// All objects returned here must be treated as read-only.
type IPAMConfigurationLister interface {
	// List lists all IPAMConfigurations in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v3.IPAMConfiguration, err error)
	// Get retrieves the IPAMConfiguration from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v3.IPAMConfiguration, error)
	IPAMConfigurationListerExpansion
}

// iPAMConfigurationLister implements the IPAMConfigurationLister interface.
type iPAMConfigurationLister struct {
	indexer cache.Indexer
}

// NewIPAMConfigurationLister returns a new IPAMConfigurationLister.
func NewIPAMConfigurationLister(indexer cache.Indexer) IPAMConfigurationLister {
	return &iPAMConfigurationLister{indexer: indexer}
}

// List lists all IPAMConfigurations in the indexer.
func (s *iPAMConfigurationLister) List(selector labels.Selector) (ret []*v3.IPAMConfiguration, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.IPAMConfiguration))
	})
	return ret, err
}

// Get retrieves the IPAMConfiguration from the index for a given name.
func (s *iPAMConfigurationLister) Get(name string) (*v3.IPAMConfiguration, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v3.Resource("ipamconfiguration"), name)
	}
	return obj.(*v3.IPAMConfiguration), nil
}
