28 Oct 2024

#### Known issues

- Issue patching policies due to unintended tier prefix [calico 9437](https://github.com/projectcalico/calico/issues/9437)
- Issue garbage collecting policies due to GC permissions [calico 9527](https://github.com/projectcalico/calico/issues/9527)

#### Tiered policies and k8s AdminNetworkPolicy support

Calico introduces [tiered policy](https://docs.tigera.io/calico/v3.29/network-policy/policy-tiers/tiered-policy) support and support for Kubernetes AdminNetworkPolicy. Tiers are a hierarchical construct used to group policies and enforce higher precedence policies that cannot be circumvented by other teams. They have built-in features that support workload microsegmentation.

The [AdminNetworkPolicy (ANP)](https://docs.tigera.io/calico/v3.29/network-policy/policy-tiers/tiered-policy#adminnetworkpolicy-tier) resource helps administrators set strict security rules for the cluster, i.e. a developer cannot override these rules by creating NetworkPolicies that apply to the same workloads as the AdminNetworkPolicy.

- Add tiered policy support [calico 9085](https://github.com/projectcalico/calico/pull/9085) (@mazdakn)
- Allow users to specify the default action in a tier. [calico 9245](https://github.com/projectcalico/calico/pull/9245) (@mazdakn)
- Add support for the core functionalities of the new k8s AdminNetworkPolicy API. [calico 9206](https://github.com/projectcalico/calico/pull/9206) (@mazdakn)
- Add support for AdminNetworkPolicy egress network CIDRs. [calico 9303](https://github.com/projectcalico/calico/pull/9303) (@mazdakn)

#### nftables dataplane (tech-preview)

Calico introduces tech-preview support for programming policy directly using native [nftables](https://docs.tigera.io/calico/v3.29/getting-started/kubernetes/nftables) tooling on Linux. nftables is the successor to iptables, providing an extended feature set and improved kernel API.

- Tech-preview support for nftables dataplane and nftables kube-proxy compatibility [calico 8780](https://github.com/projectcalico/calico/pull/8780) (@caseydavenport)

#### Bug fixes

**BPF Dataplane**

- Fixed memory leak in BPF endpoint manager. [calico 9309](https://github.com/projectcalico/calico/pull/9309) (@tomastigera)
- ebpf: Fix for Istio ambient mode - traffic that arrives from host should go back through host and not skip iptables [calico 9192](https://github.com/projectcalico/calico/pull/9192) (@tomastigera)
- ebpf: When bpfConntrackBypass is disabled, ensure that iptables rules, which allow 3rd party iptables rules work for traffic originally for the host, are in place. [calico 9188](https://github.com/projectcalico/calico/pull/9188) (@tomastigera)
- ebpf: Fixed frequently attaching BPF programs when pods annotations/labels change and eventually failing due to running out of  tc priority. [calico 9089](https://github.com/projectcalico/calico/pull/9089) (@sridhartigera)
- ebpf: Fix parsing host IP update and re-attach program on all interfaces when there is a host IP update. [calico 9084](https://github.com/projectcalico/calico/pull/9084) (@sridhartigera)
- Fixed Missing routes for UDP services when in dual stack mode. [calico 9050](https://github.com/projectcalico/calico/pull/9050) (@sridhartigera)
- ebpf: Fixed bug that would leave residual logging when log filters were applied and then disabled. [calico 9137](https://github.com/projectcalico/calico/pull/9137) (@tomastigera)
- ebpf: Attach XDP to bond slave devices. [calico 9132](https://github.com/projectcalico/calico/pull/9132) (@sridhartigera)
- ebpf: Fix Felix panic when using non-default BPF map sizes.  Size was not updated in all places resulting in failure to attach programs. [calico 9117](https://github.com/projectcalico/calico/pull/9117) (@fasaxc)
- ebpf: Fixes missing iptables rules that would keep preexisting V6 connections working when switching to ebpf mode [calico 8943](https://github.com/projectcalico/calico/pull/8943) (@tomastigera)
- ebpf: Don't drop, but reject unknown midflow tcp packets with rst [calico 8933](https://github.com/projectcalico/calico/pull/8933) (@tomastigera)
- ebpf: Set bpfin/out.cali MTU to the smallest of all host ifaces including overlay. That means if jumbo frames are used, this device also uses them. [calico 8922](https://github.com/projectcalico/calico/pull/8922) (@tomastigera)
- ebpf: Fix - let the node handle packet when we are not sure about the destination [calico 8921](https://github.com/projectcalico/calico/pull/8921) (@tomastigera)
- ebpf: Cleanup BPF special devices when BPF is turned off [calico 8884](https://github.com/projectcalico/calico/pull/8884) (@tomastigera)
- ebpf: Support for service loop prevention [calico 8876](https://github.com/projectcalico/calico/pull/8876) (@sridhartigera)
- ebpf: Fixed forwarding, NATing and checksumming of related ICMP traffic (icmp errors) [calico 8858](https://github.com/projectcalico/calico/pull/8858) (@tomastigera)
- ebpf: If a bond master device is part of the bpfDataIfacePattern regexp, calico attaches to it and not to the slaves [calico 8803](https://github.com/projectcalico/calico/pull/8803) (@sridhartigera)
- ebpf: Forwarding services via vxlan tunnel uses different source ports for different flows to better utilize bonded devices and CPUs on the receiving side. [calico 8790](https://github.com/projectcalico/calico/pull/8790) (@tomastigera)
- ebpf: Do not panic in dual-stack mode when a node is configured with only one and not both IPs or autodetection is not enabled for one. [calico 8760](https://github.com/projectcalico/calico/pull/8760) (@tomastigera)
- ebpf: Clean up stale icmp6 conntrack entries [calico 8749](https://github.com/projectcalico/calico/pull/8749) (@tomastigera)
- ebpf: Update map definition in sockops program to let libbpf v1.0+ load them successfully. [calico 8693](https://github.com/projectcalico/calico/pull/8693) (@debasishbsws)
- ebpf: Fix map creation during upgrade. [calico 8684](https://github.com/projectcalico/calico/pull/8684) (@sridhartigera)
- ebpf: Fix natOutgoing SNAT for icmp6 [calico 8679](https://github.com/projectcalico/calico/pull/8679) (@sridhartigera)

**Windows**

- Configure kubelet certificate rotation on manually installed Calico for Windows. [calico 9178](https://github.com/projectcalico/calico/pull/9178) (@jxlwqq)
- Added support for non-English language versions of Windows. [calico 9062](https://github.com/projectcalico/calico/pull/9062) (@wayne-cheng)
- Fix non-HPC Calico for Windows startup issue with the CalicoNode service. [calico 9016](https://github.com/projectcalico/calico/pull/9016) (@coutinhop)
- [windows] Skip node IP discovery if --NodeIp parameter is provided to kubelet-service.ps1. [calico 8915](https://github.com/projectcalico/calico/pull/8915) (@wayne-cheng)

**Helm**

- Helm: Fix error parsing kubernetesServiceEndpoint.host as an integer [calico 9067](https://github.com/projectcalico/calico/pull/9067) (@MichalFupso)
- Helm: Fix rendering of KUBERNETES_SERVICE_PORT [calico 8865](https://github.com/projectcalico/calico/pull/8865) (@simonostendorf)
- Fix error when using helm additionalLabels in conjunction with image pull secrets [calico 8785](https://github.com/projectcalico/calico/pull/8785) (@caseydavenport)

**General**

- Fix spurious warning about unexpected inserted rules. [calico 9397](https://github.com/projectcalico/calico/pull/9397) (@fasaxc)
- Fix image in flannel migration manifest [calico 9265](https://github.com/projectcalico/calico/pull/9265) (@radTuti)
- Ignore empty CIDRs specified in the BGPConfiguration. [calico 9230](https://github.com/projectcalico/calico/pull/9230) (@fasaxc)
- Update flannel to version v0.24.4 to fix kube-flannel log spam when  ipv6 is disabled. [calico 9208](https://github.com/projectcalico/calico/pull/9208) (@mkhpalm)
- [etcd mode] Fix issue where Calico nodes failed to decommission if calico-kube-controllers was running on the terminated node. [calico 9190](https://github.com/projectcalico/calico/pull/9190) (@caseydavenport)
- BGP: Prevent the advertisement of local kernel routes learned from eBPF interfaces (bpf*.cali) to peers. [calico 9112](https://github.com/projectcalico/calico/pull/9112) (@mstansberry)
- Fix that shutting down a ticker waited a whole tick.  (Mainly impacts tests.) [calico 9111](https://github.com/projectcalico/calico/pull/9111) (@fasaxc)
- Fix interaction between kube-proxy and Calico's SNAT rules that could cause corrupted VXLAN packets when checksum offload was enabled.  Move Calico's rules after kube-proxy's to make sure kube-proxy's mark bit is cleared if both would have done SNAT. [calico 9091](https://github.com/projectcalico/calico/pull/9091) (@tomastigera)
- Fix that Felix would panic when trying to resync a temporary IP set.  Temporary IP sets are created in certain scenarios after previous failures. [calico 9077](https://github.com/projectcalico/calico/pull/9077) (@fasaxc)
- Fix missing resources in calicoctl command help text [calico 9054](https://github.com/projectcalico/calico/pull/9054) (@caseydavenport)
- Calico now uses the logging framework's built in capability to capture the caller's filename/line number.  This removes a potential source of concurrency bugs. [calico 9044](https://github.com/projectcalico/calico/pull/9044) (@fasaxc)
- Fix that the conversion from Pod to WorkloadEndpoint could mutate the pod labels; this isn't safe if something else has a reference to the Pod (e.g. if we're used with a caching informer). [calico 9039](https://github.com/projectcalico/calico/pull/9039) (@fasaxc)
- Fix 'undefined symbol: xtables_strdup' error when running 'iptables-legacy-save' in the calico-node image. [calico 9022](https://github.com/projectcalico/calico/pull/9022) (@coutinhop)
- Fixed continuous addition/deletion of service routes in eBPF mode. [calico 8983](https://github.com/projectcalico/calico/pull/8983) (@sridhartigera)
- Felix now arranges for VXLAN packets to skip netfilter conntrack. VXLAN uses pseudo random source ports so the "flows" are unidirectional and not meaningful to conntrack. [calico 8977](https://github.com/projectcalico/calico/pull/8977) (@cyclinder)
- Add IPReservation and BGPFilter to etcd datastore migration [calico 8971](https://github.com/projectcalico/calico/pull/8971) (@caseydavenport)
- Don't run pprof on prometheus metrics port [calico 8967](https://github.com/projectcalico/calico/pull/8967) (@caseydavenport)
- Felix: Move log initialisation earlier in start-up sequence to avoid missing some logs. [calico 8944](https://github.com/projectcalico/calico/pull/8944) (@fasaxc)
- Felix now sets the Go runtime's GC threshold to 40% (instead of the more aggressive 20% used previously). This trades slight extra RAM usage for significantly lower GC CPU usage.  The setting is now exposed in the FelixConfiguration as goGCThreshold, along with goMemoryLimitMB.  To get the old behaviour, set goGCThreshold to 20.  If memory usage is not a concern, the value can be set even higher to reduce CPU usage. [calico 8904](https://github.com/projectcalico/calico/pull/8904) (@fasaxc)
- Upgrade bpftool to v7.4 to fix the issue of loading XDP programs in iptables data plane that happens in few distributions. [calico 8880](https://github.com/projectcalico/calico/pull/8880) (@mazdakn)
- Reduce spammy logs in route table [calico 8879](https://github.com/projectcalico/calico/pull/8879) (@caseydavenport)
- Fixed incorrect logging level related to service IPs. [calico 8816](https://github.com/projectcalico/calico/pull/8816) (@mazdakn)
- Fix that Calico would ignore changes to Kubernetes Node InternalIP when using InternalIP node address autodetection. [calico 8728](https://github.com/projectcalico/calico/pull/8728) (@Levi080513)
- ebpf: wg6 traffic is allowed even if blocked by policy [calico 8712](https://github.com/projectcalico/calico/pull/8712) (@tomastigera)
- Fix pods stuck in ContainerCreating state due to  "failed to create host netlink handle: protocol not supported" error on kernels that don't support XFRM. [calico 8710](https://github.com/projectcalico/calico/pull/8710) (@carloslima)
- Fix missing log line numbers in cni-installer log output [calico 8696](https://github.com/projectcalico/calico/pull/8696) (@caseydavenport)
- Restart calico/node if unable to set the NodeNetwork condition. [calico 8673](https://github.com/projectcalico/calico/pull/8673) (@cyclinder)
- Clean up IP addresses of pods with Evicted status. [calico 7713](https://github.com/projectcalico/calico/pull/7713) (@gaopeiliang)

#### Other changes

- ebpf: Faster redirection from host interface to workloads for any included traffic that does not use NAT (CTLB enabled or pod-to-pod) [calico 9213](https://github.com/projectcalico/calico/pull/9213) (@tomastigera)
- Include license file in non-AMD64 images. [calico 8735](https://github.com/projectcalico/calico/pull/8735) (@fasaxc)
- Address GitHub Dependabot security alerts [calico 9108](https://github.com/projectcalico/calico/pull/9108) (@hjiawei)
- Improve cni-plugin binary install verification. [calico 8827](https://github.com/projectcalico/calico/pull/8827) (@coutinhop)
- Felix's route programming now handles routing conflicts deterministically, prioritising routes based on their type.  Conntrack cleanup has been improved; cleanup is now correctly sequenced with route programming when IP addresses move from local to remote workloads. [calico 8418](https://github.com/projectcalico/calico/pull/8418) (@fasaxc)
- In manifest installs, in order to prevent default IP-pools creation, `CALICO_IPV4POOL_CIDR`=`none` and `CALICO_IPV6POOL_CIDR`=`none` environment variable special values are now supported. [calico 8156](https://github.com/projectcalico/calico/pull/8156) (@kruftik)
- The calico-kube-controllers container now runs with `securityContext.runAsNonRoot=true`. [calico 6499](https://github.com/projectcalico/calico/pull/6499) (@ialidzhikov)
- New helm values.yaml field - additionalLabels - allows configuring labels on resources created by the chart. @TheCubicleJockey [calico 8722](https://github.com/projectcalico/calico/pull/8722) (@caseydavenport)
- New Felix config param IPForwarding allows for preventing Felix from enabling IP forwarding on systems that are only using Calico for host protection (and hence don't need to forward traffic to workloads). [calico 9320](https://github.com/projectcalico/calico/pull/9320) (@fasaxc)
- Felix now logs our policy selectors as well as the policy ID. [calico 9187](https://github.com/projectcalico/calico/pull/9187) (@fasaxc)
- Felix's route resync logic has been optimised; it now uses 50% less CPU time and 80% less memory. [calico 9139](https://github.com/projectcalico/calico/pull/9139) (@fasaxc)
- BGPFilter: Add prefix length matching [calico 9114](https://github.com/projectcalico/calico/pull/9114) (@mstansberry)
- Conntrack cleanup debug logs now include more information. [calico 9131](https://github.com/projectcalico/calico/pull/9131) (@fasaxc)
- Log formatting performance has been improved, reducing the overhead of logging. [calico 9055](https://github.com/projectcalico/calico/pull/9055) (@fasaxc)
- Felix now uses less CPU and memory when listing routes from the kernel. [calico 8979](https://github.com/projectcalico/calico/pull/8979) (@fasaxc)
- Adjust default IP set refresh interval from 10s to 90s. [calico 8959](https://github.com/projectcalico/calico/pull/8959) (@caseydavenport)
- apiserver defaults logrus level based on `-v` argument [calico 8697](https://github.com/projectcalico/calico/pull/8697) (@caseydavenport)
- Expose the Go runtime's "GOMAXPROCS" setting via felix configuration.  This may be useful for tuning Felix to take account of CPU limits. [calico 8945](https://github.com/projectcalico/calico/pull/8945) (@fasaxc)

