22 October 2018

#### In-cluster route reflector

With Calico v3.3, you can enable the calico/node container to behave as a route reflector on particular nodes in the cluster. calico/node
in route reflector mode now fully supports route reflector clustering, route reflector peering with external routers, and the
full set of BGP configuration options supported by Calico. This functionality replaces the calico/routereflector container, which
is now deprecated.

#### BGP peer configuration using labels

In Calico v3.3, you can now use node labels and selectors to define BGP peering relationships between calico/node instances. This allows
for easier management of BGP peer configuration in a way that scales automatically with your cluster. Combined with the in-cluster
route reflector feature, this provides a powerful model for defining how routes are distributed within the cluster.

#### IPAM enhancements

When using Calico IPAM, you can now configure the block size allocated to each host for each IP Pool. The default block size of /26 for
IPv4 provides blocks of 64 addresses. For details refer to the Project Calico IP Pool documentation. Additionally, cluster administrators
can now define specific IP pools to be used for particular Kubernetes namespaces using namespace annotations.

#### Support SCTP in Network Policy

Kubernetes 1.12 includes alpha Stream Control Transmission Protocol (SCTP) support. Calico v3.3 supports SCTP in Kubernetes network policies.

#### Other changes

 - All iptables write operations are now protected by the xtables global lock. Previously, the lock was disabled by default. Requires iptables v1.6.2. [felix #1903](https://github.com/projectcalico/felix/pull/1903) (@fasaxc)
 - Where supported, Calico now uses the iptables --random-fully option when programming SNAT and MASQUERADE rules. [felix #1901](https://github.com/projectcalico/felix/pull/1901) (@fasaxc)
 - Support CNI plugin chaining with the CNI bandwidth plugin. [cni-plugin #607](https://github.com/projectcalico/cni-plugin/pull/607) (@420691301)
 - Support specifying IP Pool by name in CNI config and Kubernetes annotations. [cni-plugin #604](https://github.com/projectcalico/cni-plugin/pull/604) (@caseydavenport)
 - Shut down CNI plugin if execution takes over 30 seconds. [cni-plugin #581](https://github.com/projectcalico/cni-plugin/pull/581) (@tomdee)
 - Ability to configure per-host block size in Calico IPAM. [libcalico-go #931](https://github.com/projectcalico/libcalico-go/pull/931) (@tomdee)
 - Ability to select IP Pools based on Kubernetes namespace. [cni-plugin #457](https://github.com/projectcalico/cni-plugin/pull/457) (@rikatz)
 - Ability to configure a floating IP via pod annotations (etcd). [cni-plugin #419](https://github.com/projectcalico/cni-plugin/pull/419) (@bradbeam)
 - Ability to configure a floating IP via pod annotations (k8s api datastore). [libcalico-go #781](https://github.com/projectcalico/libcalico-go/pull/781) (@bradbeam)
 - Enable node controller by default [kube-controllers #220](https://github.com/projectcalico/kube-controllers/pull/220) (@nwt)
 - Enable the serviceaccount controller by default in Kubernetes manifests. [calico #2247](https://github.com/projectcalico/calico/pull/2247) (@robbrockbank)
 - calico/node no longer configures next hop self on all BGP peer configurations. [node #55](https://github.com/projectcalico/node/pull/55) (@neiljerram)
 - Bump CNI version of included plugins to v0.7.1. [cni-plugin #586](https://github.com/projectcalico/cni-plugin/pull/586) (@gyliu513)

#### Notices

- Calico now requires read access to Kubernetes namespaces in order to view namespace annotations. The provided Kubernetes manifests include updated cluster
  roles to provide this access.
