//go:build !ignore_autogenerated
// +build !ignore_autogenerated

// Copyright (c) 2025 Tigera, Inc. All rights reserved.

// Code generated by deepcopy-gen. DO NOT EDIT.

package v3

import (
	numorstring "github.com/projectcalico/api/pkg/lib/numorstring"
	corev1 "k8s.io/api/core/v1"
	networkingv1 "k8s.io/api/networking/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AutoHostEndpointConfig) DeepCopyInto(out *AutoHostEndpointConfig) {
	*out = *in
	if in.Templates != nil {
		in, out := &in.Templates, &out.Templates
		*out = make([]Template, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AutoHostEndpointConfig.
func (in *AutoHostEndpointConfig) DeepCopy() *AutoHostEndpointConfig {
	if in == nil {
		return nil
	}
	out := new(AutoHostEndpointConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPConfiguration) DeepCopyInto(out *BGPConfiguration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPConfiguration.
func (in *BGPConfiguration) DeepCopy() *BGPConfiguration {
	if in == nil {
		return nil
	}
	out := new(BGPConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *BGPConfiguration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPConfigurationList) DeepCopyInto(out *BGPConfigurationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BGPConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPConfigurationList.
func (in *BGPConfigurationList) DeepCopy() *BGPConfigurationList {
	if in == nil {
		return nil
	}
	out := new(BGPConfigurationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *BGPConfigurationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPConfigurationSpec) DeepCopyInto(out *BGPConfigurationSpec) {
	*out = *in
	if in.NodeToNodeMeshEnabled != nil {
		in, out := &in.NodeToNodeMeshEnabled, &out.NodeToNodeMeshEnabled
		*out = new(bool)
		**out = **in
	}
	if in.ASNumber != nil {
		in, out := &in.ASNumber, &out.ASNumber
		*out = new(numorstring.ASNumber)
		**out = **in
	}
	if in.ServiceLoadBalancerIPs != nil {
		in, out := &in.ServiceLoadBalancerIPs, &out.ServiceLoadBalancerIPs
		*out = make([]ServiceLoadBalancerIPBlock, len(*in))
		copy(*out, *in)
	}
	if in.ServiceExternalIPs != nil {
		in, out := &in.ServiceExternalIPs, &out.ServiceExternalIPs
		*out = make([]ServiceExternalIPBlock, len(*in))
		copy(*out, *in)
	}
	if in.ServiceClusterIPs != nil {
		in, out := &in.ServiceClusterIPs, &out.ServiceClusterIPs
		*out = make([]ServiceClusterIPBlock, len(*in))
		copy(*out, *in)
	}
	if in.Communities != nil {
		in, out := &in.Communities, &out.Communities
		*out = make([]Community, len(*in))
		copy(*out, *in)
	}
	if in.PrefixAdvertisements != nil {
		in, out := &in.PrefixAdvertisements, &out.PrefixAdvertisements
		*out = make([]PrefixAdvertisement, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NodeMeshPassword != nil {
		in, out := &in.NodeMeshPassword, &out.NodeMeshPassword
		*out = new(BGPPassword)
		(*in).DeepCopyInto(*out)
	}
	if in.NodeMeshMaxRestartTime != nil {
		in, out := &in.NodeMeshMaxRestartTime, &out.NodeMeshMaxRestartTime
		*out = new(v1.Duration)
		**out = **in
	}
	if in.BindMode != nil {
		in, out := &in.BindMode, &out.BindMode
		*out = new(BindMode)
		**out = **in
	}
	if in.IgnoredInterfaces != nil {
		in, out := &in.IgnoredInterfaces, &out.IgnoredInterfaces
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPConfigurationSpec.
func (in *BGPConfigurationSpec) DeepCopy() *BGPConfigurationSpec {
	if in == nil {
		return nil
	}
	out := new(BGPConfigurationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPDaemonStatus) DeepCopyInto(out *BGPDaemonStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPDaemonStatus.
func (in *BGPDaemonStatus) DeepCopy() *BGPDaemonStatus {
	if in == nil {
		return nil
	}
	out := new(BGPDaemonStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPFilter) DeepCopyInto(out *BGPFilter) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPFilter.
func (in *BGPFilter) DeepCopy() *BGPFilter {
	if in == nil {
		return nil
	}
	out := new(BGPFilter)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *BGPFilter) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPFilterList) DeepCopyInto(out *BGPFilterList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BGPFilter, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPFilterList.
func (in *BGPFilterList) DeepCopy() *BGPFilterList {
	if in == nil {
		return nil
	}
	out := new(BGPFilterList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *BGPFilterList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPFilterPrefixLengthV4) DeepCopyInto(out *BGPFilterPrefixLengthV4) {
	*out = *in
	if in.Min != nil {
		in, out := &in.Min, &out.Min
		*out = new(int32)
		**out = **in
	}
	if in.Max != nil {
		in, out := &in.Max, &out.Max
		*out = new(int32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPFilterPrefixLengthV4.
func (in *BGPFilterPrefixLengthV4) DeepCopy() *BGPFilterPrefixLengthV4 {
	if in == nil {
		return nil
	}
	out := new(BGPFilterPrefixLengthV4)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPFilterPrefixLengthV6) DeepCopyInto(out *BGPFilterPrefixLengthV6) {
	*out = *in
	if in.Min != nil {
		in, out := &in.Min, &out.Min
		*out = new(int32)
		**out = **in
	}
	if in.Max != nil {
		in, out := &in.Max, &out.Max
		*out = new(int32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPFilterPrefixLengthV6.
func (in *BGPFilterPrefixLengthV6) DeepCopy() *BGPFilterPrefixLengthV6 {
	if in == nil {
		return nil
	}
	out := new(BGPFilterPrefixLengthV6)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPFilterRuleV4) DeepCopyInto(out *BGPFilterRuleV4) {
	*out = *in
	if in.PrefixLength != nil {
		in, out := &in.PrefixLength, &out.PrefixLength
		*out = new(BGPFilterPrefixLengthV4)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPFilterRuleV4.
func (in *BGPFilterRuleV4) DeepCopy() *BGPFilterRuleV4 {
	if in == nil {
		return nil
	}
	out := new(BGPFilterRuleV4)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPFilterRuleV6) DeepCopyInto(out *BGPFilterRuleV6) {
	*out = *in
	if in.PrefixLength != nil {
		in, out := &in.PrefixLength, &out.PrefixLength
		*out = new(BGPFilterPrefixLengthV6)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPFilterRuleV6.
func (in *BGPFilterRuleV6) DeepCopy() *BGPFilterRuleV6 {
	if in == nil {
		return nil
	}
	out := new(BGPFilterRuleV6)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPFilterSpec) DeepCopyInto(out *BGPFilterSpec) {
	*out = *in
	if in.ExportV4 != nil {
		in, out := &in.ExportV4, &out.ExportV4
		*out = make([]BGPFilterRuleV4, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ImportV4 != nil {
		in, out := &in.ImportV4, &out.ImportV4
		*out = make([]BGPFilterRuleV4, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ExportV6 != nil {
		in, out := &in.ExportV6, &out.ExportV6
		*out = make([]BGPFilterRuleV6, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ImportV6 != nil {
		in, out := &in.ImportV6, &out.ImportV6
		*out = make([]BGPFilterRuleV6, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPFilterSpec.
func (in *BGPFilterSpec) DeepCopy() *BGPFilterSpec {
	if in == nil {
		return nil
	}
	out := new(BGPFilterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPPassword) DeepCopyInto(out *BGPPassword) {
	*out = *in
	if in.SecretKeyRef != nil {
		in, out := &in.SecretKeyRef, &out.SecretKeyRef
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPPassword.
func (in *BGPPassword) DeepCopy() *BGPPassword {
	if in == nil {
		return nil
	}
	out := new(BGPPassword)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPPeer) DeepCopyInto(out *BGPPeer) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPPeer.
func (in *BGPPeer) DeepCopy() *BGPPeer {
	if in == nil {
		return nil
	}
	out := new(BGPPeer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *BGPPeer) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPPeerList) DeepCopyInto(out *BGPPeerList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BGPPeer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPPeerList.
func (in *BGPPeerList) DeepCopy() *BGPPeerList {
	if in == nil {
		return nil
	}
	out := new(BGPPeerList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *BGPPeerList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BGPPeerSpec) DeepCopyInto(out *BGPPeerSpec) {
	*out = *in
	if in.Password != nil {
		in, out := &in.Password, &out.Password
		*out = new(BGPPassword)
		(*in).DeepCopyInto(*out)
	}
	if in.MaxRestartTime != nil {
		in, out := &in.MaxRestartTime, &out.MaxRestartTime
		*out = new(v1.Duration)
		**out = **in
	}
	if in.NumAllowedLocalASNumbers != nil {
		in, out := &in.NumAllowedLocalASNumbers, &out.NumAllowedLocalASNumbers
		*out = new(int32)
		**out = **in
	}
	if in.TTLSecurity != nil {
		in, out := &in.TTLSecurity, &out.TTLSecurity
		*out = new(byte)
		**out = **in
	}
	if in.Filters != nil {
		in, out := &in.Filters, &out.Filters
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BGPPeerSpec.
func (in *BGPPeerSpec) DeepCopy() *BGPPeerSpec {
	if in == nil {
		return nil
	}
	out := new(BGPPeerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BPFConntrackTimeouts) DeepCopyInto(out *BPFConntrackTimeouts) {
	*out = *in
	if in.CreationGracePeriod != nil {
		in, out := &in.CreationGracePeriod, &out.CreationGracePeriod
		*out = new(BPFConntrackTimeout)
		**out = **in
	}
	if in.TCPSynSent != nil {
		in, out := &in.TCPSynSent, &out.TCPSynSent
		*out = new(BPFConntrackTimeout)
		**out = **in
	}
	if in.TCPEstablished != nil {
		in, out := &in.TCPEstablished, &out.TCPEstablished
		*out = new(BPFConntrackTimeout)
		**out = **in
	}
	if in.TCPFinsSeen != nil {
		in, out := &in.TCPFinsSeen, &out.TCPFinsSeen
		*out = new(BPFConntrackTimeout)
		**out = **in
	}
	if in.TCPResetSeen != nil {
		in, out := &in.TCPResetSeen, &out.TCPResetSeen
		*out = new(BPFConntrackTimeout)
		**out = **in
	}
	if in.UDPTimeout != nil {
		in, out := &in.UDPTimeout, &out.UDPTimeout
		*out = new(BPFConntrackTimeout)
		**out = **in
	}
	if in.GenericTimeout != nil {
		in, out := &in.GenericTimeout, &out.GenericTimeout
		*out = new(BPFConntrackTimeout)
		**out = **in
	}
	if in.ICMPTimeout != nil {
		in, out := &in.ICMPTimeout, &out.ICMPTimeout
		*out = new(BPFConntrackTimeout)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BPFConntrackTimeouts.
func (in *BPFConntrackTimeouts) DeepCopy() *BPFConntrackTimeouts {
	if in == nil {
		return nil
	}
	out := new(BPFConntrackTimeouts)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BlockAffinity) DeepCopyInto(out *BlockAffinity) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BlockAffinity.
func (in *BlockAffinity) DeepCopy() *BlockAffinity {
	if in == nil {
		return nil
	}
	out := new(BlockAffinity)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *BlockAffinity) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BlockAffinityList) DeepCopyInto(out *BlockAffinityList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BlockAffinity, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BlockAffinityList.
func (in *BlockAffinityList) DeepCopy() *BlockAffinityList {
	if in == nil {
		return nil
	}
	out := new(BlockAffinityList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *BlockAffinityList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BlockAffinitySpec) DeepCopyInto(out *BlockAffinitySpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BlockAffinitySpec.
func (in *BlockAffinitySpec) DeepCopy() *BlockAffinitySpec {
	if in == nil {
		return nil
	}
	out := new(BlockAffinitySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeAgentStatus) DeepCopyInto(out *CalicoNodeAgentStatus) {
	*out = *in
	out.BIRDV4 = in.BIRDV4
	out.BIRDV6 = in.BIRDV6
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeAgentStatus.
func (in *CalicoNodeAgentStatus) DeepCopy() *CalicoNodeAgentStatus {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeAgentStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeBGPRouteStatus) DeepCopyInto(out *CalicoNodeBGPRouteStatus) {
	*out = *in
	if in.RoutesV4 != nil {
		in, out := &in.RoutesV4, &out.RoutesV4
		*out = make([]CalicoNodeRoute, len(*in))
		copy(*out, *in)
	}
	if in.RoutesV6 != nil {
		in, out := &in.RoutesV6, &out.RoutesV6
		*out = make([]CalicoNodeRoute, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeBGPRouteStatus.
func (in *CalicoNodeBGPRouteStatus) DeepCopy() *CalicoNodeBGPRouteStatus {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeBGPRouteStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeBGPStatus) DeepCopyInto(out *CalicoNodeBGPStatus) {
	*out = *in
	if in.PeersV4 != nil {
		in, out := &in.PeersV4, &out.PeersV4
		*out = make([]CalicoNodePeer, len(*in))
		copy(*out, *in)
	}
	if in.PeersV6 != nil {
		in, out := &in.PeersV6, &out.PeersV6
		*out = make([]CalicoNodePeer, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeBGPStatus.
func (in *CalicoNodeBGPStatus) DeepCopy() *CalicoNodeBGPStatus {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeBGPStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodePeer) DeepCopyInto(out *CalicoNodePeer) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodePeer.
func (in *CalicoNodePeer) DeepCopy() *CalicoNodePeer {
	if in == nil {
		return nil
	}
	out := new(CalicoNodePeer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeRoute) DeepCopyInto(out *CalicoNodeRoute) {
	*out = *in
	out.LearnedFrom = in.LearnedFrom
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeRoute.
func (in *CalicoNodeRoute) DeepCopy() *CalicoNodeRoute {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeRoute)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeRouteLearnedFrom) DeepCopyInto(out *CalicoNodeRouteLearnedFrom) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeRouteLearnedFrom.
func (in *CalicoNodeRouteLearnedFrom) DeepCopy() *CalicoNodeRouteLearnedFrom {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeRouteLearnedFrom)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeStatus) DeepCopyInto(out *CalicoNodeStatus) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeStatus.
func (in *CalicoNodeStatus) DeepCopy() *CalicoNodeStatus {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CalicoNodeStatus) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeStatusList) DeepCopyInto(out *CalicoNodeStatusList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CalicoNodeStatus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeStatusList.
func (in *CalicoNodeStatusList) DeepCopy() *CalicoNodeStatusList {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeStatusList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CalicoNodeStatusList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeStatusSpec) DeepCopyInto(out *CalicoNodeStatusSpec) {
	*out = *in
	if in.Classes != nil {
		in, out := &in.Classes, &out.Classes
		*out = make([]NodeStatusClassType, len(*in))
		copy(*out, *in)
	}
	if in.UpdatePeriodSeconds != nil {
		in, out := &in.UpdatePeriodSeconds, &out.UpdatePeriodSeconds
		*out = new(uint32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeStatusSpec.
func (in *CalicoNodeStatusSpec) DeepCopy() *CalicoNodeStatusSpec {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeStatusSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CalicoNodeStatusStatus) DeepCopyInto(out *CalicoNodeStatusStatus) {
	*out = *in
	in.LastUpdated.DeepCopyInto(&out.LastUpdated)
	out.Agent = in.Agent
	in.BGP.DeepCopyInto(&out.BGP)
	in.Routes.DeepCopyInto(&out.Routes)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CalicoNodeStatusStatus.
func (in *CalicoNodeStatusStatus) DeepCopy() *CalicoNodeStatusStatus {
	if in == nil {
		return nil
	}
	out := new(CalicoNodeStatusStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterInformation) DeepCopyInto(out *ClusterInformation) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterInformation.
func (in *ClusterInformation) DeepCopy() *ClusterInformation {
	if in == nil {
		return nil
	}
	out := new(ClusterInformation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterInformation) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterInformationList) DeepCopyInto(out *ClusterInformationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterInformation, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterInformationList.
func (in *ClusterInformationList) DeepCopy() *ClusterInformationList {
	if in == nil {
		return nil
	}
	out := new(ClusterInformationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterInformationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterInformationSpec) DeepCopyInto(out *ClusterInformationSpec) {
	*out = *in
	if in.DatastoreReady != nil {
		in, out := &in.DatastoreReady, &out.DatastoreReady
		*out = new(bool)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterInformationSpec.
func (in *ClusterInformationSpec) DeepCopy() *ClusterInformationSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterInformationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Community) DeepCopyInto(out *Community) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Community.
func (in *Community) DeepCopy() *Community {
	if in == nil {
		return nil
	}
	out := new(Community)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControllersConfig) DeepCopyInto(out *ControllersConfig) {
	*out = *in
	if in.Node != nil {
		in, out := &in.Node, &out.Node
		*out = new(NodeControllerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Policy != nil {
		in, out := &in.Policy, &out.Policy
		*out = new(PolicyControllerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.WorkloadEndpoint != nil {
		in, out := &in.WorkloadEndpoint, &out.WorkloadEndpoint
		*out = new(WorkloadEndpointControllerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceAccount != nil {
		in, out := &in.ServiceAccount, &out.ServiceAccount
		*out = new(ServiceAccountControllerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Namespace != nil {
		in, out := &in.Namespace, &out.Namespace
		*out = new(NamespaceControllerConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.LoadBalancer != nil {
		in, out := &in.LoadBalancer, &out.LoadBalancer
		*out = new(LoadBalancerControllerConfig)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControllersConfig.
func (in *ControllersConfig) DeepCopy() *ControllersConfig {
	if in == nil {
		return nil
	}
	out := new(ControllersConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EndpointPort) DeepCopyInto(out *EndpointPort) {
	*out = *in
	out.Protocol = in.Protocol
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EndpointPort.
func (in *EndpointPort) DeepCopy() *EndpointPort {
	if in == nil {
		return nil
	}
	out := new(EndpointPort)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EntityRule) DeepCopyInto(out *EntityRule) {
	*out = *in
	if in.Nets != nil {
		in, out := &in.Nets, &out.Nets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Services != nil {
		in, out := &in.Services, &out.Services
		*out = new(ServiceMatch)
		**out = **in
	}
	if in.Ports != nil {
		in, out := &in.Ports, &out.Ports
		*out = make([]numorstring.Port, len(*in))
		copy(*out, *in)
	}
	if in.NotNets != nil {
		in, out := &in.NotNets, &out.NotNets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.NotPorts != nil {
		in, out := &in.NotPorts, &out.NotPorts
		*out = make([]numorstring.Port, len(*in))
		copy(*out, *in)
	}
	if in.ServiceAccounts != nil {
		in, out := &in.ServiceAccounts, &out.ServiceAccounts
		*out = new(ServiceAccountMatch)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EntityRule.
func (in *EntityRule) DeepCopy() *EntityRule {
	if in == nil {
		return nil
	}
	out := new(EntityRule)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FelixConfiguration) DeepCopyInto(out *FelixConfiguration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FelixConfiguration.
func (in *FelixConfiguration) DeepCopy() *FelixConfiguration {
	if in == nil {
		return nil
	}
	out := new(FelixConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *FelixConfiguration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FelixConfigurationList) DeepCopyInto(out *FelixConfigurationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]FelixConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FelixConfigurationList.
func (in *FelixConfigurationList) DeepCopy() *FelixConfigurationList {
	if in == nil {
		return nil
	}
	out := new(FelixConfigurationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *FelixConfigurationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FelixConfigurationSpec) DeepCopyInto(out *FelixConfigurationSpec) {
	*out = *in
	if in.UseInternalDataplaneDriver != nil {
		in, out := &in.UseInternalDataplaneDriver, &out.UseInternalDataplaneDriver
		*out = new(bool)
		**out = **in
	}
	if in.DataplaneWatchdogTimeout != nil {
		in, out := &in.DataplaneWatchdogTimeout, &out.DataplaneWatchdogTimeout
		*out = new(v1.Duration)
		**out = **in
	}
	if in.IPv6Support != nil {
		in, out := &in.IPv6Support, &out.IPv6Support
		*out = new(bool)
		**out = **in
	}
	if in.RouteRefreshInterval != nil {
		in, out := &in.RouteRefreshInterval, &out.RouteRefreshInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.InterfaceRefreshInterval != nil {
		in, out := &in.InterfaceRefreshInterval, &out.InterfaceRefreshInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.IptablesRefreshInterval != nil {
		in, out := &in.IptablesRefreshInterval, &out.IptablesRefreshInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.IptablesPostWriteCheckInterval != nil {
		in, out := &in.IptablesPostWriteCheckInterval, &out.IptablesPostWriteCheckInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.IptablesLockTimeout != nil {
		in, out := &in.IptablesLockTimeout, &out.IptablesLockTimeout
		*out = new(v1.Duration)
		**out = **in
	}
	if in.IptablesLockProbeInterval != nil {
		in, out := &in.IptablesLockProbeInterval, &out.IptablesLockProbeInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.IpsetsRefreshInterval != nil {
		in, out := &in.IpsetsRefreshInterval, &out.IpsetsRefreshInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.MaxIpsetSize != nil {
		in, out := &in.MaxIpsetSize, &out.MaxIpsetSize
		*out = new(int)
		**out = **in
	}
	if in.IptablesBackend != nil {
		in, out := &in.IptablesBackend, &out.IptablesBackend
		*out = new(IptablesBackend)
		**out = **in
	}
	if in.XDPRefreshInterval != nil {
		in, out := &in.XDPRefreshInterval, &out.XDPRefreshInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.NetlinkTimeout != nil {
		in, out := &in.NetlinkTimeout, &out.NetlinkTimeout
		*out = new(v1.Duration)
		**out = **in
	}
	if in.MetadataPort != nil {
		in, out := &in.MetadataPort, &out.MetadataPort
		*out = new(int)
		**out = **in
	}
	if in.IPIPEnabled != nil {
		in, out := &in.IPIPEnabled, &out.IPIPEnabled
		*out = new(bool)
		**out = **in
	}
	if in.IPIPMTU != nil {
		in, out := &in.IPIPMTU, &out.IPIPMTU
		*out = new(int)
		**out = **in
	}
	if in.VXLANEnabled != nil {
		in, out := &in.VXLANEnabled, &out.VXLANEnabled
		*out = new(bool)
		**out = **in
	}
	if in.VXLANMTU != nil {
		in, out := &in.VXLANMTU, &out.VXLANMTU
		*out = new(int)
		**out = **in
	}
	if in.VXLANMTUV6 != nil {
		in, out := &in.VXLANMTUV6, &out.VXLANMTUV6
		*out = new(int)
		**out = **in
	}
	if in.VXLANPort != nil {
		in, out := &in.VXLANPort, &out.VXLANPort
		*out = new(int)
		**out = **in
	}
	if in.VXLANVNI != nil {
		in, out := &in.VXLANVNI, &out.VXLANVNI
		*out = new(int)
		**out = **in
	}
	if in.AllowVXLANPacketsFromWorkloads != nil {
		in, out := &in.AllowVXLANPacketsFromWorkloads, &out.AllowVXLANPacketsFromWorkloads
		*out = new(bool)
		**out = **in
	}
	if in.AllowIPIPPacketsFromWorkloads != nil {
		in, out := &in.AllowIPIPPacketsFromWorkloads, &out.AllowIPIPPacketsFromWorkloads
		*out = new(bool)
		**out = **in
	}
	if in.ReportingInterval != nil {
		in, out := &in.ReportingInterval, &out.ReportingInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.ReportingTTL != nil {
		in, out := &in.ReportingTTL, &out.ReportingTTL
		*out = new(v1.Duration)
		**out = **in
	}
	if in.EndpointReportingEnabled != nil {
		in, out := &in.EndpointReportingEnabled, &out.EndpointReportingEnabled
		*out = new(bool)
		**out = **in
	}
	if in.EndpointReportingDelay != nil {
		in, out := &in.EndpointReportingDelay, &out.EndpointReportingDelay
		*out = new(v1.Duration)
		**out = **in
	}
	if in.IptablesMarkMask != nil {
		in, out := &in.IptablesMarkMask, &out.IptablesMarkMask
		*out = new(uint32)
		**out = **in
	}
	if in.DisableConntrackInvalidCheck != nil {
		in, out := &in.DisableConntrackInvalidCheck, &out.DisableConntrackInvalidCheck
		*out = new(bool)
		**out = **in
	}
	if in.HealthEnabled != nil {
		in, out := &in.HealthEnabled, &out.HealthEnabled
		*out = new(bool)
		**out = **in
	}
	if in.HealthHost != nil {
		in, out := &in.HealthHost, &out.HealthHost
		*out = new(string)
		**out = **in
	}
	if in.HealthPort != nil {
		in, out := &in.HealthPort, &out.HealthPort
		*out = new(int)
		**out = **in
	}
	if in.HealthTimeoutOverrides != nil {
		in, out := &in.HealthTimeoutOverrides, &out.HealthTimeoutOverrides
		*out = make([]HealthTimeoutOverride, len(*in))
		copy(*out, *in)
	}
	if in.PrometheusMetricsEnabled != nil {
		in, out := &in.PrometheusMetricsEnabled, &out.PrometheusMetricsEnabled
		*out = new(bool)
		**out = **in
	}
	if in.PrometheusMetricsPort != nil {
		in, out := &in.PrometheusMetricsPort, &out.PrometheusMetricsPort
		*out = new(int)
		**out = **in
	}
	if in.PrometheusGoMetricsEnabled != nil {
		in, out := &in.PrometheusGoMetricsEnabled, &out.PrometheusGoMetricsEnabled
		*out = new(bool)
		**out = **in
	}
	if in.PrometheusProcessMetricsEnabled != nil {
		in, out := &in.PrometheusProcessMetricsEnabled, &out.PrometheusProcessMetricsEnabled
		*out = new(bool)
		**out = **in
	}
	if in.PrometheusWireGuardMetricsEnabled != nil {
		in, out := &in.PrometheusWireGuardMetricsEnabled, &out.PrometheusWireGuardMetricsEnabled
		*out = new(bool)
		**out = **in
	}
	if in.FailsafeInboundHostPorts != nil {
		in, out := &in.FailsafeInboundHostPorts, &out.FailsafeInboundHostPorts
		*out = new([]ProtoPort)
		if **in != nil {
			in, out := *in, *out
			*out = make([]ProtoPort, len(*in))
			copy(*out, *in)
		}
	}
	if in.FailsafeOutboundHostPorts != nil {
		in, out := &in.FailsafeOutboundHostPorts, &out.FailsafeOutboundHostPorts
		*out = new([]ProtoPort)
		if **in != nil {
			in, out := *in, *out
			*out = make([]ProtoPort, len(*in))
			copy(*out, *in)
		}
	}
	if in.KubeNodePortRanges != nil {
		in, out := &in.KubeNodePortRanges, &out.KubeNodePortRanges
		*out = new([]numorstring.Port)
		if **in != nil {
			in, out := *in, *out
			*out = make([]numorstring.Port, len(*in))
			copy(*out, *in)
		}
	}
	if in.UsageReportingEnabled != nil {
		in, out := &in.UsageReportingEnabled, &out.UsageReportingEnabled
		*out = new(bool)
		**out = **in
	}
	if in.UsageReportingInitialDelay != nil {
		in, out := &in.UsageReportingInitialDelay, &out.UsageReportingInitialDelay
		*out = new(v1.Duration)
		**out = **in
	}
	if in.UsageReportingInterval != nil {
		in, out := &in.UsageReportingInterval, &out.UsageReportingInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.NATPortRange != nil {
		in, out := &in.NATPortRange, &out.NATPortRange
		*out = new(numorstring.Port)
		**out = **in
	}
	if in.DeviceRouteProtocol != nil {
		in, out := &in.DeviceRouteProtocol, &out.DeviceRouteProtocol
		*out = new(int)
		**out = **in
	}
	if in.RemoveExternalRoutes != nil {
		in, out := &in.RemoveExternalRoutes, &out.RemoveExternalRoutes
		*out = new(bool)
		**out = **in
	}
	if in.ExternalNodesCIDRList != nil {
		in, out := &in.ExternalNodesCIDRList, &out.ExternalNodesCIDRList
		*out = new([]string)
		if **in != nil {
			in, out := *in, *out
			*out = make([]string, len(*in))
			copy(*out, *in)
		}
	}
	if in.DebugDisableLogDropping != nil {
		in, out := &in.DebugDisableLogDropping, &out.DebugDisableLogDropping
		*out = new(bool)
		**out = **in
	}
	if in.DebugSimulateCalcGraphHangAfter != nil {
		in, out := &in.DebugSimulateCalcGraphHangAfter, &out.DebugSimulateCalcGraphHangAfter
		*out = new(v1.Duration)
		**out = **in
	}
	if in.DebugSimulateDataplaneHangAfter != nil {
		in, out := &in.DebugSimulateDataplaneHangAfter, &out.DebugSimulateDataplaneHangAfter
		*out = new(v1.Duration)
		**out = **in
	}
	if in.DebugSimulateDataplaneApplyDelay != nil {
		in, out := &in.DebugSimulateDataplaneApplyDelay, &out.DebugSimulateDataplaneApplyDelay
		*out = new(v1.Duration)
		**out = **in
	}
	if in.DebugHost != nil {
		in, out := &in.DebugHost, &out.DebugHost
		*out = new(string)
		**out = **in
	}
	if in.DebugPort != nil {
		in, out := &in.DebugPort, &out.DebugPort
		*out = new(int)
		**out = **in
	}
	if in.SidecarAccelerationEnabled != nil {
		in, out := &in.SidecarAccelerationEnabled, &out.SidecarAccelerationEnabled
		*out = new(bool)
		**out = **in
	}
	if in.XDPEnabled != nil {
		in, out := &in.XDPEnabled, &out.XDPEnabled
		*out = new(bool)
		**out = **in
	}
	if in.GenericXDPEnabled != nil {
		in, out := &in.GenericXDPEnabled, &out.GenericXDPEnabled
		*out = new(bool)
		**out = **in
	}
	if in.NFTablesMode != nil {
		in, out := &in.NFTablesMode, &out.NFTablesMode
		*out = new(NFTablesMode)
		**out = **in
	}
	if in.NftablesRefreshInterval != nil {
		in, out := &in.NftablesRefreshInterval, &out.NftablesRefreshInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.NftablesMarkMask != nil {
		in, out := &in.NftablesMarkMask, &out.NftablesMarkMask
		*out = new(uint32)
		**out = **in
	}
	if in.BPFEnabled != nil {
		in, out := &in.BPFEnabled, &out.BPFEnabled
		*out = new(bool)
		**out = **in
	}
	if in.BPFDisableUnprivileged != nil {
		in, out := &in.BPFDisableUnprivileged, &out.BPFDisableUnprivileged
		*out = new(bool)
		**out = **in
	}
	if in.BPFConntrackCleanupMode != nil {
		in, out := &in.BPFConntrackCleanupMode, &out.BPFConntrackCleanupMode
		*out = new(BPFConntrackMode)
		**out = **in
	}
	if in.BPFConntrackTimeouts != nil {
		in, out := &in.BPFConntrackTimeouts, &out.BPFConntrackTimeouts
		*out = new(BPFConntrackTimeouts)
		(*in).DeepCopyInto(*out)
	}
	if in.BPFLogFilters != nil {
		in, out := &in.BPFLogFilters, &out.BPFLogFilters
		*out = new(map[string]string)
		if **in != nil {
			in, out := *in, *out
			*out = make(map[string]string, len(*in))
			for key, val := range *in {
				(*out)[key] = val
			}
		}
	}
	if in.BPFConnectTimeLoadBalancingEnabled != nil {
		in, out := &in.BPFConnectTimeLoadBalancingEnabled, &out.BPFConnectTimeLoadBalancingEnabled
		*out = new(bool)
		**out = **in
	}
	if in.BPFConnectTimeLoadBalancing != nil {
		in, out := &in.BPFConnectTimeLoadBalancing, &out.BPFConnectTimeLoadBalancing
		*out = new(BPFConnectTimeLBType)
		**out = **in
	}
	if in.BPFHostNetworkedNATWithoutCTLB != nil {
		in, out := &in.BPFHostNetworkedNATWithoutCTLB, &out.BPFHostNetworkedNATWithoutCTLB
		*out = new(BPFHostNetworkedNATType)
		**out = **in
	}
	if in.BPFDSROptoutCIDRs != nil {
		in, out := &in.BPFDSROptoutCIDRs, &out.BPFDSROptoutCIDRs
		*out = new([]string)
		if **in != nil {
			in, out := *in, *out
			*out = make([]string, len(*in))
			copy(*out, *in)
		}
	}
	if in.BPFExtToServiceConnmark != nil {
		in, out := &in.BPFExtToServiceConnmark, &out.BPFExtToServiceConnmark
		*out = new(int)
		**out = **in
	}
	if in.BPFKubeProxyIptablesCleanupEnabled != nil {
		in, out := &in.BPFKubeProxyIptablesCleanupEnabled, &out.BPFKubeProxyIptablesCleanupEnabled
		*out = new(bool)
		**out = **in
	}
	if in.BPFKubeProxyMinSyncPeriod != nil {
		in, out := &in.BPFKubeProxyMinSyncPeriod, &out.BPFKubeProxyMinSyncPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.BPFKubeProxyEndpointSlicesEnabled != nil {
		in, out := &in.BPFKubeProxyEndpointSlicesEnabled, &out.BPFKubeProxyEndpointSlicesEnabled
		*out = new(bool)
		**out = **in
	}
	if in.BPFPSNATPorts != nil {
		in, out := &in.BPFPSNATPorts, &out.BPFPSNATPorts
		*out = new(numorstring.Port)
		**out = **in
	}
	if in.BPFMapSizeNATFrontend != nil {
		in, out := &in.BPFMapSizeNATFrontend, &out.BPFMapSizeNATFrontend
		*out = new(int)
		**out = **in
	}
	if in.BPFMapSizeNATBackend != nil {
		in, out := &in.BPFMapSizeNATBackend, &out.BPFMapSizeNATBackend
		*out = new(int)
		**out = **in
	}
	if in.BPFMapSizeNATAffinity != nil {
		in, out := &in.BPFMapSizeNATAffinity, &out.BPFMapSizeNATAffinity
		*out = new(int)
		**out = **in
	}
	if in.BPFMapSizeRoute != nil {
		in, out := &in.BPFMapSizeRoute, &out.BPFMapSizeRoute
		*out = new(int)
		**out = **in
	}
	if in.BPFMapSizeConntrack != nil {
		in, out := &in.BPFMapSizeConntrack, &out.BPFMapSizeConntrack
		*out = new(int)
		**out = **in
	}
	if in.BPFMapSizePerCPUConntrack != nil {
		in, out := &in.BPFMapSizePerCPUConntrack, &out.BPFMapSizePerCPUConntrack
		*out = new(int)
		**out = **in
	}
	if in.BPFMapSizeConntrackCleanupQueue != nil {
		in, out := &in.BPFMapSizeConntrackCleanupQueue, &out.BPFMapSizeConntrackCleanupQueue
		*out = new(int)
		**out = **in
	}
	if in.BPFMapSizeIPSets != nil {
		in, out := &in.BPFMapSizeIPSets, &out.BPFMapSizeIPSets
		*out = new(int)
		**out = **in
	}
	if in.BPFMapSizeIfState != nil {
		in, out := &in.BPFMapSizeIfState, &out.BPFMapSizeIfState
		*out = new(int)
		**out = **in
	}
	if in.BPFHostConntrackBypass != nil {
		in, out := &in.BPFHostConntrackBypass, &out.BPFHostConntrackBypass
		*out = new(bool)
		**out = **in
	}
	if in.BPFPolicyDebugEnabled != nil {
		in, out := &in.BPFPolicyDebugEnabled, &out.BPFPolicyDebugEnabled
		*out = new(bool)
		**out = **in
	}
	if in.BPFForceTrackPacketsFromIfaces != nil {
		in, out := &in.BPFForceTrackPacketsFromIfaces, &out.BPFForceTrackPacketsFromIfaces
		*out = new([]string)
		if **in != nil {
			in, out := *in, *out
			*out = make([]string, len(*in))
			copy(*out, *in)
		}
	}
	if in.BPFExcludeCIDRsFromNAT != nil {
		in, out := &in.BPFExcludeCIDRsFromNAT, &out.BPFExcludeCIDRsFromNAT
		*out = new([]string)
		if **in != nil {
			in, out := *in, *out
			*out = make([]string, len(*in))
			copy(*out, *in)
		}
	}
	if in.BPFExportBufferSizeMB != nil {
		in, out := &in.BPFExportBufferSizeMB, &out.BPFExportBufferSizeMB
		*out = new(int)
		**out = **in
	}
	if in.FlowLogsPolicyEvaluationMode != nil {
		in, out := &in.FlowLogsPolicyEvaluationMode, &out.FlowLogsPolicyEvaluationMode
		*out = new(FlowLogsPolicyEvaluationModeType)
		**out = **in
	}
	if in.FlowLogsFlushInterval != nil {
		in, out := &in.FlowLogsFlushInterval, &out.FlowLogsFlushInterval
		*out = new(v1.Duration)
		**out = **in
	}
	if in.FlowLogsCollectorDebugTrace != nil {
		in, out := &in.FlowLogsCollectorDebugTrace, &out.FlowLogsCollectorDebugTrace
		*out = new(bool)
		**out = **in
	}
	if in.FlowLogsGoldmaneServer != nil {
		in, out := &in.FlowLogsGoldmaneServer, &out.FlowLogsGoldmaneServer
		*out = new(string)
		**out = **in
	}
	if in.FlowLogsLocalReporter != nil {
		in, out := &in.FlowLogsLocalReporter, &out.FlowLogsLocalReporter
		*out = new(string)
		**out = **in
	}
	if in.RouteTableRanges != nil {
		in, out := &in.RouteTableRanges, &out.RouteTableRanges
		*out = new(RouteTableRanges)
		if **in != nil {
			in, out := *in, *out
			*out = make([]RouteTableIDRange, len(*in))
			copy(*out, *in)
		}
	}
	if in.RouteTableRange != nil {
		in, out := &in.RouteTableRange, &out.RouteTableRange
		*out = new(RouteTableRange)
		**out = **in
	}
	if in.RouteSyncDisabled != nil {
		in, out := &in.RouteSyncDisabled, &out.RouteSyncDisabled
		*out = new(bool)
		**out = **in
	}
	if in.WireguardEnabled != nil {
		in, out := &in.WireguardEnabled, &out.WireguardEnabled
		*out = new(bool)
		**out = **in
	}
	if in.WireguardEnabledV6 != nil {
		in, out := &in.WireguardEnabledV6, &out.WireguardEnabledV6
		*out = new(bool)
		**out = **in
	}
	if in.WireguardThreadingEnabled != nil {
		in, out := &in.WireguardThreadingEnabled, &out.WireguardThreadingEnabled
		*out = new(bool)
		**out = **in
	}
	if in.WireguardListeningPort != nil {
		in, out := &in.WireguardListeningPort, &out.WireguardListeningPort
		*out = new(int)
		**out = **in
	}
	if in.WireguardListeningPortV6 != nil {
		in, out := &in.WireguardListeningPortV6, &out.WireguardListeningPortV6
		*out = new(int)
		**out = **in
	}
	if in.WireguardRoutingRulePriority != nil {
		in, out := &in.WireguardRoutingRulePriority, &out.WireguardRoutingRulePriority
		*out = new(int)
		**out = **in
	}
	if in.WireguardMTU != nil {
		in, out := &in.WireguardMTU, &out.WireguardMTU
		*out = new(int)
		**out = **in
	}
	if in.WireguardMTUV6 != nil {
		in, out := &in.WireguardMTUV6, &out.WireguardMTUV6
		*out = new(int)
		**out = **in
	}
	if in.WireguardHostEncryptionEnabled != nil {
		in, out := &in.WireguardHostEncryptionEnabled, &out.WireguardHostEncryptionEnabled
		*out = new(bool)
		**out = **in
	}
	if in.WireguardPersistentKeepAlive != nil {
		in, out := &in.WireguardPersistentKeepAlive, &out.WireguardPersistentKeepAlive
		*out = new(v1.Duration)
		**out = **in
	}
	if in.AWSSrcDstCheck != nil {
		in, out := &in.AWSSrcDstCheck, &out.AWSSrcDstCheck
		*out = new(AWSSrcDstCheckOption)
		**out = **in
	}
	if in.FloatingIPs != nil {
		in, out := &in.FloatingIPs, &out.FloatingIPs
		*out = new(FloatingIPType)
		**out = **in
	}
	if in.WindowsManageFirewallRules != nil {
		in, out := &in.WindowsManageFirewallRules, &out.WindowsManageFirewallRules
		*out = new(WindowsManageFirewallRulesMode)
		**out = **in
	}
	if in.GoGCThreshold != nil {
		in, out := &in.GoGCThreshold, &out.GoGCThreshold
		*out = new(int)
		**out = **in
	}
	if in.GoMemoryLimitMB != nil {
		in, out := &in.GoMemoryLimitMB, &out.GoMemoryLimitMB
		*out = new(int)
		**out = **in
	}
	if in.GoMaxProcs != nil {
		in, out := &in.GoMaxProcs, &out.GoMaxProcs
		*out = new(int)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FelixConfigurationSpec.
func (in *FelixConfigurationSpec) DeepCopy() *FelixConfigurationSpec {
	if in == nil {
		return nil
	}
	out := new(FelixConfigurationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalNetworkPolicy) DeepCopyInto(out *GlobalNetworkPolicy) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalNetworkPolicy.
func (in *GlobalNetworkPolicy) DeepCopy() *GlobalNetworkPolicy {
	if in == nil {
		return nil
	}
	out := new(GlobalNetworkPolicy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GlobalNetworkPolicy) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalNetworkPolicyList) DeepCopyInto(out *GlobalNetworkPolicyList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]GlobalNetworkPolicy, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalNetworkPolicyList.
func (in *GlobalNetworkPolicyList) DeepCopy() *GlobalNetworkPolicyList {
	if in == nil {
		return nil
	}
	out := new(GlobalNetworkPolicyList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GlobalNetworkPolicyList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalNetworkPolicySpec) DeepCopyInto(out *GlobalNetworkPolicySpec) {
	*out = *in
	if in.Order != nil {
		in, out := &in.Order, &out.Order
		*out = new(float64)
		**out = **in
	}
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Egress != nil {
		in, out := &in.Egress, &out.Egress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Types != nil {
		in, out := &in.Types, &out.Types
		*out = make([]PolicyType, len(*in))
		copy(*out, *in)
	}
	if in.PerformanceHints != nil {
		in, out := &in.PerformanceHints, &out.PerformanceHints
		*out = make([]PolicyPerformanceHint, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalNetworkPolicySpec.
func (in *GlobalNetworkPolicySpec) DeepCopy() *GlobalNetworkPolicySpec {
	if in == nil {
		return nil
	}
	out := new(GlobalNetworkPolicySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalNetworkSet) DeepCopyInto(out *GlobalNetworkSet) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalNetworkSet.
func (in *GlobalNetworkSet) DeepCopy() *GlobalNetworkSet {
	if in == nil {
		return nil
	}
	out := new(GlobalNetworkSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GlobalNetworkSet) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalNetworkSetList) DeepCopyInto(out *GlobalNetworkSetList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]GlobalNetworkSet, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalNetworkSetList.
func (in *GlobalNetworkSetList) DeepCopy() *GlobalNetworkSetList {
	if in == nil {
		return nil
	}
	out := new(GlobalNetworkSetList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GlobalNetworkSetList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalNetworkSetSpec) DeepCopyInto(out *GlobalNetworkSetSpec) {
	*out = *in
	if in.Nets != nil {
		in, out := &in.Nets, &out.Nets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalNetworkSetSpec.
func (in *GlobalNetworkSetSpec) DeepCopy() *GlobalNetworkSetSpec {
	if in == nil {
		return nil
	}
	out := new(GlobalNetworkSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPMatch) DeepCopyInto(out *HTTPMatch) {
	*out = *in
	if in.Methods != nil {
		in, out := &in.Methods, &out.Methods
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Paths != nil {
		in, out := &in.Paths, &out.Paths
		*out = make([]HTTPPath, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPMatch.
func (in *HTTPMatch) DeepCopy() *HTTPMatch {
	if in == nil {
		return nil
	}
	out := new(HTTPMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPPath) DeepCopyInto(out *HTTPPath) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPPath.
func (in *HTTPPath) DeepCopy() *HTTPPath {
	if in == nil {
		return nil
	}
	out := new(HTTPPath)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HealthTimeoutOverride) DeepCopyInto(out *HealthTimeoutOverride) {
	*out = *in
	out.Timeout = in.Timeout
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HealthTimeoutOverride.
func (in *HealthTimeoutOverride) DeepCopy() *HealthTimeoutOverride {
	if in == nil {
		return nil
	}
	out := new(HealthTimeoutOverride)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostEndpoint) DeepCopyInto(out *HostEndpoint) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostEndpoint.
func (in *HostEndpoint) DeepCopy() *HostEndpoint {
	if in == nil {
		return nil
	}
	out := new(HostEndpoint)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *HostEndpoint) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostEndpointList) DeepCopyInto(out *HostEndpointList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]HostEndpoint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostEndpointList.
func (in *HostEndpointList) DeepCopy() *HostEndpointList {
	if in == nil {
		return nil
	}
	out := new(HostEndpointList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *HostEndpointList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostEndpointSpec) DeepCopyInto(out *HostEndpointSpec) {
	*out = *in
	if in.ExpectedIPs != nil {
		in, out := &in.ExpectedIPs, &out.ExpectedIPs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Profiles != nil {
		in, out := &in.Profiles, &out.Profiles
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Ports != nil {
		in, out := &in.Ports, &out.Ports
		*out = make([]EndpointPort, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostEndpointSpec.
func (in *HostEndpointSpec) DeepCopy() *HostEndpointSpec {
	if in == nil {
		return nil
	}
	out := new(HostEndpointSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ICMPFields) DeepCopyInto(out *ICMPFields) {
	*out = *in
	if in.Type != nil {
		in, out := &in.Type, &out.Type
		*out = new(int)
		**out = **in
	}
	if in.Code != nil {
		in, out := &in.Code, &out.Code
		*out = new(int)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ICMPFields.
func (in *ICMPFields) DeepCopy() *ICMPFields {
	if in == nil {
		return nil
	}
	out := new(ICMPFields)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPAMConfiguration) DeepCopyInto(out *IPAMConfiguration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPAMConfiguration.
func (in *IPAMConfiguration) DeepCopy() *IPAMConfiguration {
	if in == nil {
		return nil
	}
	out := new(IPAMConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IPAMConfiguration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPAMConfigurationList) DeepCopyInto(out *IPAMConfigurationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IPAMConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPAMConfigurationList.
func (in *IPAMConfigurationList) DeepCopy() *IPAMConfigurationList {
	if in == nil {
		return nil
	}
	out := new(IPAMConfigurationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IPAMConfigurationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPAMConfigurationSpec) DeepCopyInto(out *IPAMConfigurationSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPAMConfigurationSpec.
func (in *IPAMConfigurationSpec) DeepCopy() *IPAMConfigurationSpec {
	if in == nil {
		return nil
	}
	out := new(IPAMConfigurationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPIPConfiguration) DeepCopyInto(out *IPIPConfiguration) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPIPConfiguration.
func (in *IPIPConfiguration) DeepCopy() *IPIPConfiguration {
	if in == nil {
		return nil
	}
	out := new(IPIPConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPPool) DeepCopyInto(out *IPPool) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPPool.
func (in *IPPool) DeepCopy() *IPPool {
	if in == nil {
		return nil
	}
	out := new(IPPool)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IPPool) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPPoolList) DeepCopyInto(out *IPPoolList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IPPool, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPPoolList.
func (in *IPPoolList) DeepCopy() *IPPoolList {
	if in == nil {
		return nil
	}
	out := new(IPPoolList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IPPoolList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPPoolSpec) DeepCopyInto(out *IPPoolSpec) {
	*out = *in
	if in.IPIP != nil {
		in, out := &in.IPIP, &out.IPIP
		*out = new(IPIPConfiguration)
		**out = **in
	}
	if in.AllowedUses != nil {
		in, out := &in.AllowedUses, &out.AllowedUses
		*out = make([]IPPoolAllowedUse, len(*in))
		copy(*out, *in)
	}
	if in.AssignmentMode != nil {
		in, out := &in.AssignmentMode, &out.AssignmentMode
		*out = new(AssignmentMode)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPPoolSpec.
func (in *IPPoolSpec) DeepCopy() *IPPoolSpec {
	if in == nil {
		return nil
	}
	out := new(IPPoolSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPReservation) DeepCopyInto(out *IPReservation) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPReservation.
func (in *IPReservation) DeepCopy() *IPReservation {
	if in == nil {
		return nil
	}
	out := new(IPReservation)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IPReservation) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPReservationList) DeepCopyInto(out *IPReservationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IPReservation, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPReservationList.
func (in *IPReservationList) DeepCopy() *IPReservationList {
	if in == nil {
		return nil
	}
	out := new(IPReservationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IPReservationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPReservationSpec) DeepCopyInto(out *IPReservationSpec) {
	*out = *in
	if in.ReservedCIDRs != nil {
		in, out := &in.ReservedCIDRs, &out.ReservedCIDRs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPReservationSpec.
func (in *IPReservationSpec) DeepCopy() *IPReservationSpec {
	if in == nil {
		return nil
	}
	out := new(IPReservationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeControllersConfiguration) DeepCopyInto(out *KubeControllersConfiguration) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeControllersConfiguration.
func (in *KubeControllersConfiguration) DeepCopy() *KubeControllersConfiguration {
	if in == nil {
		return nil
	}
	out := new(KubeControllersConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KubeControllersConfiguration) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeControllersConfigurationList) DeepCopyInto(out *KubeControllersConfigurationList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]KubeControllersConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeControllersConfigurationList.
func (in *KubeControllersConfigurationList) DeepCopy() *KubeControllersConfigurationList {
	if in == nil {
		return nil
	}
	out := new(KubeControllersConfigurationList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *KubeControllersConfigurationList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeControllersConfigurationSpec) DeepCopyInto(out *KubeControllersConfigurationSpec) {
	*out = *in
	if in.EtcdV3CompactionPeriod != nil {
		in, out := &in.EtcdV3CompactionPeriod, &out.EtcdV3CompactionPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.PrometheusMetricsPort != nil {
		in, out := &in.PrometheusMetricsPort, &out.PrometheusMetricsPort
		*out = new(int)
		**out = **in
	}
	in.Controllers.DeepCopyInto(&out.Controllers)
	if in.DebugProfilePort != nil {
		in, out := &in.DebugProfilePort, &out.DebugProfilePort
		*out = new(int32)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeControllersConfigurationSpec.
func (in *KubeControllersConfigurationSpec) DeepCopy() *KubeControllersConfigurationSpec {
	if in == nil {
		return nil
	}
	out := new(KubeControllersConfigurationSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubeControllersConfigurationStatus) DeepCopyInto(out *KubeControllersConfigurationStatus) {
	*out = *in
	in.RunningConfig.DeepCopyInto(&out.RunningConfig)
	if in.EnvironmentVars != nil {
		in, out := &in.EnvironmentVars, &out.EnvironmentVars
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubeControllersConfigurationStatus.
func (in *KubeControllersConfigurationStatus) DeepCopy() *KubeControllersConfigurationStatus {
	if in == nil {
		return nil
	}
	out := new(KubeControllersConfigurationStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LoadBalancerControllerConfig) DeepCopyInto(out *LoadBalancerControllerConfig) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LoadBalancerControllerConfig.
func (in *LoadBalancerControllerConfig) DeepCopy() *LoadBalancerControllerConfig {
	if in == nil {
		return nil
	}
	out := new(LoadBalancerControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NamespaceControllerConfig) DeepCopyInto(out *NamespaceControllerConfig) {
	*out = *in
	if in.ReconcilerPeriod != nil {
		in, out := &in.ReconcilerPeriod, &out.ReconcilerPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NamespaceControllerConfig.
func (in *NamespaceControllerConfig) DeepCopy() *NamespaceControllerConfig {
	if in == nil {
		return nil
	}
	out := new(NamespaceControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkPolicy) DeepCopyInto(out *NetworkPolicy) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkPolicy.
func (in *NetworkPolicy) DeepCopy() *NetworkPolicy {
	if in == nil {
		return nil
	}
	out := new(NetworkPolicy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NetworkPolicy) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkPolicyList) DeepCopyInto(out *NetworkPolicyList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]NetworkPolicy, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkPolicyList.
func (in *NetworkPolicyList) DeepCopy() *NetworkPolicyList {
	if in == nil {
		return nil
	}
	out := new(NetworkPolicyList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NetworkPolicyList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkPolicySpec) DeepCopyInto(out *NetworkPolicySpec) {
	*out = *in
	if in.Order != nil {
		in, out := &in.Order, &out.Order
		*out = new(float64)
		**out = **in
	}
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Egress != nil {
		in, out := &in.Egress, &out.Egress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Types != nil {
		in, out := &in.Types, &out.Types
		*out = make([]PolicyType, len(*in))
		copy(*out, *in)
	}
	if in.PerformanceHints != nil {
		in, out := &in.PerformanceHints, &out.PerformanceHints
		*out = make([]PolicyPerformanceHint, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkPolicySpec.
func (in *NetworkPolicySpec) DeepCopy() *NetworkPolicySpec {
	if in == nil {
		return nil
	}
	out := new(NetworkPolicySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkSet) DeepCopyInto(out *NetworkSet) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkSet.
func (in *NetworkSet) DeepCopy() *NetworkSet {
	if in == nil {
		return nil
	}
	out := new(NetworkSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NetworkSet) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkSetList) DeepCopyInto(out *NetworkSetList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]NetworkSet, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkSetList.
func (in *NetworkSetList) DeepCopy() *NetworkSetList {
	if in == nil {
		return nil
	}
	out := new(NetworkSetList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NetworkSetList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkSetSpec) DeepCopyInto(out *NetworkSetSpec) {
	*out = *in
	if in.Nets != nil {
		in, out := &in.Nets, &out.Nets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkSetSpec.
func (in *NetworkSetSpec) DeepCopy() *NetworkSetSpec {
	if in == nil {
		return nil
	}
	out := new(NetworkSetSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeControllerConfig) DeepCopyInto(out *NodeControllerConfig) {
	*out = *in
	if in.ReconcilerPeriod != nil {
		in, out := &in.ReconcilerPeriod, &out.ReconcilerPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	if in.HostEndpoint != nil {
		in, out := &in.HostEndpoint, &out.HostEndpoint
		*out = new(AutoHostEndpointConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.LeakGracePeriod != nil {
		in, out := &in.LeakGracePeriod, &out.LeakGracePeriod
		*out = new(v1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeControllerConfig.
func (in *NodeControllerConfig) DeepCopy() *NodeControllerConfig {
	if in == nil {
		return nil
	}
	out := new(NodeControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PolicyControllerConfig) DeepCopyInto(out *PolicyControllerConfig) {
	*out = *in
	if in.ReconcilerPeriod != nil {
		in, out := &in.ReconcilerPeriod, &out.ReconcilerPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PolicyControllerConfig.
func (in *PolicyControllerConfig) DeepCopy() *PolicyControllerConfig {
	if in == nil {
		return nil
	}
	out := new(PolicyControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrefixAdvertisement) DeepCopyInto(out *PrefixAdvertisement) {
	*out = *in
	if in.Communities != nil {
		in, out := &in.Communities, &out.Communities
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrefixAdvertisement.
func (in *PrefixAdvertisement) DeepCopy() *PrefixAdvertisement {
	if in == nil {
		return nil
	}
	out := new(PrefixAdvertisement)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Profile) DeepCopyInto(out *Profile) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Profile.
func (in *Profile) DeepCopy() *Profile {
	if in == nil {
		return nil
	}
	out := new(Profile)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Profile) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProfileList) DeepCopyInto(out *ProfileList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Profile, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProfileList.
func (in *ProfileList) DeepCopy() *ProfileList {
	if in == nil {
		return nil
	}
	out := new(ProfileList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ProfileList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProfileSpec) DeepCopyInto(out *ProfileSpec) {
	*out = *in
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Egress != nil {
		in, out := &in.Egress, &out.Egress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.LabelsToApply != nil {
		in, out := &in.LabelsToApply, &out.LabelsToApply
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProfileSpec.
func (in *ProfileSpec) DeepCopy() *ProfileSpec {
	if in == nil {
		return nil
	}
	out := new(ProfileSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProtoPort) DeepCopyInto(out *ProtoPort) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProtoPort.
func (in *ProtoPort) DeepCopy() *ProtoPort {
	if in == nil {
		return nil
	}
	out := new(ProtoPort)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RouteTableIDRange) DeepCopyInto(out *RouteTableIDRange) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RouteTableIDRange.
func (in *RouteTableIDRange) DeepCopy() *RouteTableIDRange {
	if in == nil {
		return nil
	}
	out := new(RouteTableIDRange)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RouteTableRange) DeepCopyInto(out *RouteTableRange) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RouteTableRange.
func (in *RouteTableRange) DeepCopy() *RouteTableRange {
	if in == nil {
		return nil
	}
	out := new(RouteTableRange)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in RouteTableRanges) DeepCopyInto(out *RouteTableRanges) {
	{
		in := &in
		*out = make(RouteTableRanges, len(*in))
		copy(*out, *in)
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RouteTableRanges.
func (in RouteTableRanges) DeepCopy() RouteTableRanges {
	if in == nil {
		return nil
	}
	out := new(RouteTableRanges)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Rule) DeepCopyInto(out *Rule) {
	*out = *in
	if in.IPVersion != nil {
		in, out := &in.IPVersion, &out.IPVersion
		*out = new(int)
		**out = **in
	}
	if in.Protocol != nil {
		in, out := &in.Protocol, &out.Protocol
		*out = new(numorstring.Protocol)
		**out = **in
	}
	if in.ICMP != nil {
		in, out := &in.ICMP, &out.ICMP
		*out = new(ICMPFields)
		(*in).DeepCopyInto(*out)
	}
	if in.NotProtocol != nil {
		in, out := &in.NotProtocol, &out.NotProtocol
		*out = new(numorstring.Protocol)
		**out = **in
	}
	if in.NotICMP != nil {
		in, out := &in.NotICMP, &out.NotICMP
		*out = new(ICMPFields)
		(*in).DeepCopyInto(*out)
	}
	in.Source.DeepCopyInto(&out.Source)
	in.Destination.DeepCopyInto(&out.Destination)
	if in.HTTP != nil {
		in, out := &in.HTTP, &out.HTTP
		*out = new(HTTPMatch)
		(*in).DeepCopyInto(*out)
	}
	if in.Metadata != nil {
		in, out := &in.Metadata, &out.Metadata
		*out = new(RuleMetadata)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Rule.
func (in *Rule) DeepCopy() *Rule {
	if in == nil {
		return nil
	}
	out := new(Rule)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RuleMetadata) DeepCopyInto(out *RuleMetadata) {
	*out = *in
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RuleMetadata.
func (in *RuleMetadata) DeepCopy() *RuleMetadata {
	if in == nil {
		return nil
	}
	out := new(RuleMetadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceAccountControllerConfig) DeepCopyInto(out *ServiceAccountControllerConfig) {
	*out = *in
	if in.ReconcilerPeriod != nil {
		in, out := &in.ReconcilerPeriod, &out.ReconcilerPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceAccountControllerConfig.
func (in *ServiceAccountControllerConfig) DeepCopy() *ServiceAccountControllerConfig {
	if in == nil {
		return nil
	}
	out := new(ServiceAccountControllerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceAccountMatch) DeepCopyInto(out *ServiceAccountMatch) {
	*out = *in
	if in.Names != nil {
		in, out := &in.Names, &out.Names
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceAccountMatch.
func (in *ServiceAccountMatch) DeepCopy() *ServiceAccountMatch {
	if in == nil {
		return nil
	}
	out := new(ServiceAccountMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceClusterIPBlock) DeepCopyInto(out *ServiceClusterIPBlock) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceClusterIPBlock.
func (in *ServiceClusterIPBlock) DeepCopy() *ServiceClusterIPBlock {
	if in == nil {
		return nil
	}
	out := new(ServiceClusterIPBlock)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceExternalIPBlock) DeepCopyInto(out *ServiceExternalIPBlock) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceExternalIPBlock.
func (in *ServiceExternalIPBlock) DeepCopy() *ServiceExternalIPBlock {
	if in == nil {
		return nil
	}
	out := new(ServiceExternalIPBlock)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceLoadBalancerIPBlock) DeepCopyInto(out *ServiceLoadBalancerIPBlock) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceLoadBalancerIPBlock.
func (in *ServiceLoadBalancerIPBlock) DeepCopy() *ServiceLoadBalancerIPBlock {
	if in == nil {
		return nil
	}
	out := new(ServiceLoadBalancerIPBlock)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceMatch) DeepCopyInto(out *ServiceMatch) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceMatch.
func (in *ServiceMatch) DeepCopy() *ServiceMatch {
	if in == nil {
		return nil
	}
	out := new(ServiceMatch)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedGlobalNetworkPolicy) DeepCopyInto(out *StagedGlobalNetworkPolicy) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedGlobalNetworkPolicy.
func (in *StagedGlobalNetworkPolicy) DeepCopy() *StagedGlobalNetworkPolicy {
	if in == nil {
		return nil
	}
	out := new(StagedGlobalNetworkPolicy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *StagedGlobalNetworkPolicy) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedGlobalNetworkPolicyList) DeepCopyInto(out *StagedGlobalNetworkPolicyList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]StagedGlobalNetworkPolicy, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedGlobalNetworkPolicyList.
func (in *StagedGlobalNetworkPolicyList) DeepCopy() *StagedGlobalNetworkPolicyList {
	if in == nil {
		return nil
	}
	out := new(StagedGlobalNetworkPolicyList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *StagedGlobalNetworkPolicyList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedGlobalNetworkPolicySpec) DeepCopyInto(out *StagedGlobalNetworkPolicySpec) {
	*out = *in
	if in.Order != nil {
		in, out := &in.Order, &out.Order
		*out = new(float64)
		**out = **in
	}
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Egress != nil {
		in, out := &in.Egress, &out.Egress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Types != nil {
		in, out := &in.Types, &out.Types
		*out = make([]PolicyType, len(*in))
		copy(*out, *in)
	}
	if in.PerformanceHints != nil {
		in, out := &in.PerformanceHints, &out.PerformanceHints
		*out = make([]PolicyPerformanceHint, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedGlobalNetworkPolicySpec.
func (in *StagedGlobalNetworkPolicySpec) DeepCopy() *StagedGlobalNetworkPolicySpec {
	if in == nil {
		return nil
	}
	out := new(StagedGlobalNetworkPolicySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedKubernetesNetworkPolicy) DeepCopyInto(out *StagedKubernetesNetworkPolicy) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedKubernetesNetworkPolicy.
func (in *StagedKubernetesNetworkPolicy) DeepCopy() *StagedKubernetesNetworkPolicy {
	if in == nil {
		return nil
	}
	out := new(StagedKubernetesNetworkPolicy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *StagedKubernetesNetworkPolicy) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedKubernetesNetworkPolicyList) DeepCopyInto(out *StagedKubernetesNetworkPolicyList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]StagedKubernetesNetworkPolicy, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedKubernetesNetworkPolicyList.
func (in *StagedKubernetesNetworkPolicyList) DeepCopy() *StagedKubernetesNetworkPolicyList {
	if in == nil {
		return nil
	}
	out := new(StagedKubernetesNetworkPolicyList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *StagedKubernetesNetworkPolicyList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedKubernetesNetworkPolicySpec) DeepCopyInto(out *StagedKubernetesNetworkPolicySpec) {
	*out = *in
	in.PodSelector.DeepCopyInto(&out.PodSelector)
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]networkingv1.NetworkPolicyIngressRule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Egress != nil {
		in, out := &in.Egress, &out.Egress
		*out = make([]networkingv1.NetworkPolicyEgressRule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PolicyTypes != nil {
		in, out := &in.PolicyTypes, &out.PolicyTypes
		*out = make([]networkingv1.PolicyType, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedKubernetesNetworkPolicySpec.
func (in *StagedKubernetesNetworkPolicySpec) DeepCopy() *StagedKubernetesNetworkPolicySpec {
	if in == nil {
		return nil
	}
	out := new(StagedKubernetesNetworkPolicySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedNetworkPolicy) DeepCopyInto(out *StagedNetworkPolicy) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedNetworkPolicy.
func (in *StagedNetworkPolicy) DeepCopy() *StagedNetworkPolicy {
	if in == nil {
		return nil
	}
	out := new(StagedNetworkPolicy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *StagedNetworkPolicy) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedNetworkPolicyList) DeepCopyInto(out *StagedNetworkPolicyList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]StagedNetworkPolicy, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedNetworkPolicyList.
func (in *StagedNetworkPolicyList) DeepCopy() *StagedNetworkPolicyList {
	if in == nil {
		return nil
	}
	out := new(StagedNetworkPolicyList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *StagedNetworkPolicyList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StagedNetworkPolicySpec) DeepCopyInto(out *StagedNetworkPolicySpec) {
	*out = *in
	if in.Order != nil {
		in, out := &in.Order, &out.Order
		*out = new(float64)
		**out = **in
	}
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Egress != nil {
		in, out := &in.Egress, &out.Egress
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Types != nil {
		in, out := &in.Types, &out.Types
		*out = make([]PolicyType, len(*in))
		copy(*out, *in)
	}
	if in.PerformanceHints != nil {
		in, out := &in.PerformanceHints, &out.PerformanceHints
		*out = make([]PolicyPerformanceHint, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StagedNetworkPolicySpec.
func (in *StagedNetworkPolicySpec) DeepCopy() *StagedNetworkPolicySpec {
	if in == nil {
		return nil
	}
	out := new(StagedNetworkPolicySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Template) DeepCopyInto(out *Template) {
	*out = *in
	if in.InterfaceCIDRs != nil {
		in, out := &in.InterfaceCIDRs, &out.InterfaceCIDRs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Template.
func (in *Template) DeepCopy() *Template {
	if in == nil {
		return nil
	}
	out := new(Template)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Tier) DeepCopyInto(out *Tier) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Tier.
func (in *Tier) DeepCopy() *Tier {
	if in == nil {
		return nil
	}
	out := new(Tier)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Tier) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TierList) DeepCopyInto(out *TierList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Tier, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TierList.
func (in *TierList) DeepCopy() *TierList {
	if in == nil {
		return nil
	}
	out := new(TierList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TierList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TierSpec) DeepCopyInto(out *TierSpec) {
	*out = *in
	if in.Order != nil {
		in, out := &in.Order, &out.Order
		*out = new(float64)
		**out = **in
	}
	if in.DefaultAction != nil {
		in, out := &in.DefaultAction, &out.DefaultAction
		*out = new(Action)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TierSpec.
func (in *TierSpec) DeepCopy() *TierSpec {
	if in == nil {
		return nil
	}
	out := new(TierSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WorkloadEndpointControllerConfig) DeepCopyInto(out *WorkloadEndpointControllerConfig) {
	*out = *in
	if in.ReconcilerPeriod != nil {
		in, out := &in.ReconcilerPeriod, &out.ReconcilerPeriod
		*out = new(v1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WorkloadEndpointControllerConfig.
func (in *WorkloadEndpointControllerConfig) DeepCopy() *WorkloadEndpointControllerConfig {
	if in == nil {
		return nil
	}
	out := new(WorkloadEndpointControllerConfig)
	in.DeepCopyInto(out)
	return out
}
