22 Aug 2025

#### Bug fixes

- Fix that whisker wouldn't bind to IPv6 addresses. [calico 10840](https://github.com/projectcalico/calico/pull/10840) (@caseydavenport)
- ebpf: Fix race between loading kubernetes services and conntrack cleanup.  If conntrack cleanup ran before services were loaded, all service entries would look stale and get cleaned up. [calico 10724](https://github.com/projectcalico/calico/pull/10724) (@fasaxc)
- Fix confd on Windows by skipping watching endpoint status files. [calico 10703](https://github.com/projectcalico/calico/pull/10703) (@song-jiang)
- ebpf: fixes ICMP response source IP when nodes have multiple IPs assigned [calico 10661](https://github.com/projectcalico/calico/pull/10661) (@tomastigera)
- Fix that CalicoNodeStatus updates could get blocked by datastore errors [calico 10595](https://github.com/projectcalico/calico/pull/10595) (@theboringstuff)

#### Other changes

- Updates k8s to 1.32.8 [calico 10836](https://github.com/projectcalico/calico/pull/10836) (@MichalFupso)
- Update RBAC for kube-controllers to access services/servicestatus for etcd manifest installation. [calico 10792](https://github.com/projectcalico/calico/pull/10792) (@MichalFupso)
- Update k8s to 1.32.8 and go to 1.24.6 [calico 10773](https://github.com/projectcalico/calico/pull/10773) (@MichalFupso)
- ebpf: Squash benign "Not a valid CIDR." log when processing headless services in kube proxy. [calico 10701](https://github.com/projectcalico/calico/pull/10701) (@fasaxc)
- Add validation to guard against catch-all CIDRs (e.g. 0.0.0.0/0) on negated (notnets) policy rules, as those would effectively disallow all addresses. [calico 10688](https://github.com/projectcalico/calico/pull/10688) (@dzacball)
- ebpf: use pre-dnat IP for icmp response on ingress to node. Either it is an external IP or routable from the previous hop. The node can pose as having the VIP. [calico 10677](https://github.com/projectcalico/calico/pull/10677) (@tomastigera)
- Add ReversePeering field to BGPPeer API [calico 10675](https://github.com/projectcalico/calico/pull/10675) (@song-jiang)
- Calico LoadBalancerController will consider service.spec.LoadBalancerClass in determining if IP should be assigned. When in RequestedServicesOnly mode service will be assigned IP if LoadBalancerClass is set to calico. When running is AllServices and RequestedServicesOnly mode and the LoadBalancerClass is set to other value than calico, service will not be assigned an IP [calico 10631](https://github.com/projectcalico/calico/pull/10631) (@MichalFupso)
- Calico packages for Ubuntu Noble are built with separate debug symbols for Calico v3.30 and later. To install, add the `main/debug` component in your `project-calico-ubuntu-master-noble.sources` file alongside the `main` component and then run `apt update` and install the `calico-felix-dbgsym` package. [calico 10622](https://github.com/projectcalico/calico/pull/10622) (@danudey)
