09 Mar 2019

#### Calico IPAM for Kubernetes API datastore

You now have full feature parity for Calico IP address management (IPAM) irrespective of the datastore you are using with your Calico deployment. This enables all of Calico’s
IP address management features including:

- Multiple IP address pools
- Per-pod, per-namespace, and per-node pool specification

Upgrading existing clusters using Calico with host-local IPAM is seamless - simply apply the new v3.6 manifest and you’ll be using Calico IPAM! Note that it is important to
use the updated manifests hosted on [https://docs.projectcalico.org](https://docs.projectcalico.org/v3.6) to ensure upgrade is not disruptive.

GitHub PRs:
 - [libcalico-go #1010](https://github.com/projectcalico/libcalico-go/pull/1010) (@caseydavenport, @briansan)
 - [cni-plugin #683](https://github.com/projectcalico/cni-plugin/pull/683) (@briansan)
 - [cni-plugin #684](https://github.com/projectcalico/cni-plugin/pull/684) (@lwr20, @song-jiang)
 - [kube-controllers #340](https://github.com/projectcalico/kube-controllers/pull/340) (@caseydavenport)

#### OpenStack Enhancements

Calico 3.6 has several enhancements for your OpenStack deployments for better operational efficiency and resiliency.
If you have a multi-region OpenStack deployment, you can choose to map all of those regions into a shared Calico
datastore, which then allows you to define cross-region Calico policies. We’ve improved our documentation about the labels you can use to define Calico policy
in addition to OpenStack security groups, and have added the project parent ID label to facilitate policy between hierarchically organised projects.

GitHub PRs / commits:
 - [networking-calico changes](https://github.com/openstack/networking-calico/compare/3.4.0...3.6.0) (@neiljerram)
 - [libcalico-go #994](https://github.com/projectcalico/libcalico-go/pull/994) (@neiljerram)

#### Selectors with substring matching

With both Kubernetes and OpenStack, you can now write Calico policy with selectors that match on a label value substring instead of the whole
label value.  For example you can write “role starts with ‘Security’” or “role contains ‘Engineer’”, whereas previously you
could only specify a complete match “role == ‘Security Engineer’”.

GitHub PRs:
 - Selector syntax now supports operators for substring matching: "contains", "starts with" and "ends with". [libcalico-go #1036](https://github.com/projectcalico/libcalico-go/pull/1036) (@fasaxc)

#### Bug fixes

 - Fix issue in BIRD readiness reporting which can result in multiple nodes restarting at once [node #162](https://github.com/projectcalico/node/pull/162) (@tathagatachowdhury)
 - Fix kube-controllers performing unnecessary reprogramming of profiles [libcalico-go #1012](https://github.com/projectcalico/libcalico-go/pull/1012) (@song-jiang)
 - calico/node in route reflector mode now advertises service ClusterIPs to peers outside of the cluster. [confd #206](https://github.com/projectcalico/confd/pull/206) (@roshanirathi)

#### Other changes

 - Removed unnecessary logging in Dikastes for HTTP requests. [app-policy #70](https://github.com/projectcalico/app-policy/pull/70) (@song-jiang)
 - Removed support for the K8S_API_TOKEN environment variable [libcalico-go #1023](https://github.com/projectcalico/libcalico-go/pull/1023) (@tathagatachowdhury)
 - OpenStack VM endpoints now have a label for the parent ID of the VM's project. [calico #2411](https://github.com/projectcalico/calico/pull/2411) (@neiljerram)
 - The CALICO_ROUTER_ID environment variable now supports a special value "hash", which derives the router ID from the nodename.  This is useful for IPv6-only systems. [confd #223](https://github.com/projectcalico/confd/pull/223) (@roshanirathi)
 - Update quickstart guide to use Kubernetes API datastore. [calico #2435](https://github.com/projectcalico/calico/pull/2435) (@caseydavenport)
 - Update top-level navigation bar and reorganize existing content to match. [calico #2372](https://github.com/projectcalico/calico/pull/2372) (@emanic)
