24 Jan 2019

#### IP address allocation based on topology

In some cases, it may be desirable to allocate pod IP addresses based on your cluster topology. For example,
you may have pods deployed across several racks and want to minimize the number of routes required in the network,
or you may need to assign addresses in such a way to adhere to some external firewall or company policy.

You can now use IP pools to select a particular group of nodes based on node labels. Workloads deployed to a node will be
assigned an address from within the IP pools which select that node.

Github PR: [libcalico-go #993](https://github.com/projectcalico/libcalico-go/pull/993) (@briansan)

Additionally, Calico now inherits node labels from Kubernetes, so you can take advantage of topology information already present
in your cluster. For more details on how this works, and a step-by-step example,
see the [Calico documentation for this feature.][docs]

GithubPRs: [kube-controllers #336](https://github.com/projectcalico/kube-controllers/pull/336) (@caseydavenport, @briansan), [libcalico-go #1006](https://github.com/projectcalico/libcalico-go/pull/1006) (@fasaxc)

#### Other changes

- CNI plugin now supports ERROR level logging [cni-plugin #676](https://github.com/projectcalico/cni-plugin/pull/676) (@caseydavenport)
- Remove incorrect error logging when deleting a node object [libcalico-go #1007](https://github.com/projectcalico/libcalico-go/pull/1007) (@caseydavenport)


[docs]: https://docs.projectcalico.org/v3.5/usage/assigning-ip-addresses-topology
