/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;

public class DrcRing {
    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private static void drawRing(ArcProto arc, double w, double h, Cell f) {
        double arcW = 6.0;
        PrimitiveNode pin = ((PrimitiveArc)arc).findOverridablePinProto();
        double pinLoX = -arcW / 2.0;
        double pinHiX = w + arcW / 2.0;
        double pinLoY = -arcW / 2.0;
        double pinHiY = h + arcW / 2.0;
        double defSz = Double.POSITIVE_INFINITY;
        PortInst blPort = LayoutLib.newNodeInst(pin, pinLoX, pinLoY, defSz, defSz, 0.0, f).getOnlyPortInst();
        PortInst brPort = LayoutLib.newNodeInst(pin, pinHiX, pinLoY, defSz, defSz, 0.0, f).getOnlyPortInst();
        PortInst tlPort = LayoutLib.newNodeInst(pin, pinLoX, pinHiY, defSz, defSz, 0.0, f).getOnlyPortInst();
        PortInst trPort = LayoutLib.newNodeInst(pin, pinHiX, pinHiY, defSz, defSz, 0.0, f).getOnlyPortInst();
        LayoutLib.newArcInst(arc, arcW, blPort, brPort);
        LayoutLib.newArcInst(arc, arcW, tlPort, trPort);
        LayoutLib.newArcInst(arc, arcW, blPort, tlPort);
        LayoutLib.newArcInst(arc, arcW, brPort, trPort);
    }

    public static Cell makePart(double w, double h, StdCellParams stdCell) {
        String nm = "drcRing_W" + w + "_H" + h + "{lay}";
        Cell ring = stdCell.findPart(nm);
        if (ring != null) {
            return ring;
        }
        ring = stdCell.newPart(nm);
        DrcRing.drawRing(Tech.p1, w, h, ring);
        DrcRing.drawRing(Tech.m1, w, h, ring);
        DrcRing.drawRing(Tech.m2, w, h, ring);
        DrcRing.drawRing(Tech.m3, w, h, ring);
        DrcRing.drawRing(Tech.m4, w, h, ring);
        DrcRing.drawRing(Tech.m5, w, h, ring);
        return ring;
    }
}

