/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LibraryFiles
extends Input {
    protected int nodeProtoCount;
    protected Cell[] nodeProtoList;
    protected double[] cellLambda;
    protected static int totalCells;
    protected static int cellsConstructed;
    protected List scaledCells;
    protected List skewedCells;
    protected int emajor;
    protected int eminor;
    protected int edetail;
    protected Version version;
    protected boolean convertMosisCmosTechnologies;
    private static HashMap libsBeingRead;
    protected static final boolean VERBOSE = false;

    LibraryFiles() {
    }

    public static void initializeLibraryInput() {
        libsBeingRead = new HashMap();
    }

    public boolean readInputLibrary() {
        libsBeingRead.put(this.lib, this);
        this.scaledCells = new ArrayList();
        this.skewedCells = new ArrayList();
        return this.readLib();
    }

    protected void scanNodesForRecursion(Cell cell, FlagSet markCellForNodes, NodeProto[] nil, int start, int end) {
        for (int j = start; j < end; ++j) {
            Cell otherCell;
            NodeProto np = nil[j];
            if (np instanceof PrimitiveNode || (otherCell = (Cell)np) == null || otherCell.isBit(markCellForNodes)) continue;
            LibraryFiles reader = this;
            if (otherCell.getLibrary() != cell.getLibrary()) {
                reader = this.getReaderForLib(otherCell.getLibrary());
            }
            if (reader == null) continue;
            reader.realizeCellsRecursively(otherCell, markCellForNodes, null, 0.0, 0.0);
        }
        cell.setBit(markCellForNodes);
    }

    protected boolean readLib() {
        return true;
    }

    protected View findOldViewName(String viewName) {
        if (this.version.getMajor() < 8) {
            if (viewName.equals("compensated")) {
                return View.LAYOUTCOMP;
            }
            if (viewName.equals("skeleton")) {
                return View.LAYOUTSKEL;
            }
            if (viewName.equals("simulation-snapshot")) {
                return View.DOCWAVE;
            }
            if (viewName.equals("netlist-netlisp-format")) {
                return View.NETLISTNETLISP;
            }
            if (viewName.equals("netlist-rsim-format")) {
                return View.NETLISTRSIM;
            }
            if (viewName.equals("netlist-silos-format")) {
                return View.NETLISTSILOS;
            }
            if (viewName.equals("netlist-quisc-format")) {
                return View.NETLISTQUISC;
            }
            if (viewName.equals("netlist-als-format")) {
                return View.NETLISTALS;
            }
        }
        return null;
    }

    protected Technology findTechnologyName(String name) {
        Technology tech = null;
        if (this.convertMosisCmosTechnologies) {
            if (name.equals("mocmossub")) {
                tech = MoCMOS.tech;
            } else if (name.equals("mocmos")) {
                tech = Technology.findTechnology("mocmosold");
            }
        }
        if (tech == null) {
            tech = Technology.findTechnology(name);
        }
        if (tech == null && name.equals("logic")) {
            tech = Schematics.tech;
        }
        if (tech == null && (name.equals("epic8c") || name.equals("epic7c"))) {
            tech = Technology.findTechnology("epic7s");
        }
        return tech;
    }

    protected Library readExternalLibraryFromFilename(String theFileName) {
        int slashPos;
        int colonPos;
        File libFile = new File(theFileName);
        String libFileName = libFile.getName();
        String libFilePath = libFile.getParent();
        int backSlashPos = libFileName.lastIndexOf(92);
        int charPos = Math.max(backSlashPos, Math.max(colonPos = libFileName.lastIndexOf(58), slashPos = libFileName.lastIndexOf(47)));
        if (charPos >= 0) {
            libFileName = libFileName.substring(charPos + 1);
            libFilePath = "";
        }
        OpenFile.Type importType = OpenFile.Type.ELIB;
        String libName = libFileName;
        if (libName.endsWith(".elib")) {
            libName = libName.substring(0, libName.length() - 5);
        } else if (libName.endsWith(".txt")) {
            libName = libName.substring(0, libName.length() - 4);
            importType = OpenFile.Type.READABLEDUMP;
        } else {
            libFileName = libFileName + ".elib";
        }
        Library elib = Library.findLibrary(libName);
        if (elib == null) {
            StringBuffer errmsg;
            URL externalURL = TextUtils.makeURLToFile(mainLibDirectory + libFileName);
            boolean exists = TextUtils.URLExists(externalURL, errmsg = new StringBuffer());
            if (!exists) {
                Iterator libIt = LibDirs.getLibDirs();
                while (libIt.hasNext() && !(exists = TextUtils.URLExists(externalURL = TextUtils.makeURLToFile((String)libIt.next() + File.separator + libFileName), errmsg))) {
                }
                if (!exists && !(exists = TextUtils.URLExists(externalURL = TextUtils.makeURLToFile(libFile.getPath()), errmsg))) {
                    externalURL = LibFile.getLibFile(libFileName);
                    exists = TextUtils.URLExists(externalURL, errmsg);
                }
            }
            if (!exists) {
                String description;
                System.out.println("Error: cannot find referenced library " + libFile.getPath() + ":");
                System.out.print(errmsg.toString());
                String pt = null;
                while (!((pt = OpenFile.chooseInputFile(OpenFile.Type.ELIB, description = "Reference library '" + libFileName + "'")) == null || (externalURL = TextUtils.makeURLToFile(pt)) != null && (exists = TextUtils.URLExists(externalURL, null)))) {
                }
            }
            if (exists) {
                System.out.println("Reading referenced library " + externalURL.getFile());
                elib = Library.newInstance(libName, externalURL);
            }
            if (elib != null) {
                String oldNote = progress.getNote();
                if (progress != null) {
                    progress.setProgress(0);
                    progress.setNote("Reading referenced library " + libName + "...");
                }
                elib = LibraryFiles.readALibrary(externalURL, elib, importType);
                progress.setProgress((int)((long)(this.byteCount * 100) / this.fileLength));
                progress.setNote(oldNote);
            }
            if (elib == null) {
                System.out.println("Error: cannot find referenced library " + libFile.getPath());
                System.out.println("...Creating new " + libName + " Library instead");
                elib = Library.newInstance(libName, null);
            }
        }
        return elib;
    }

    public static void cleanupLibraryInput() {
        Cell cell;
        Cell cell2;
        progress.setNote("Constructing cell contents...");
        progress.setProgress(0);
        totalCells = 0;
        FlagSet markCellForNodes = NodeProto.getFlagSet(1);
        Iterator it = libsBeingRead.values().iterator();
        while (it.hasNext()) {
            LibraryFiles reader = (LibraryFiles)it.next();
            totalCells += reader.nodeProtoCount;
            for (int cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                cell2 = reader.nodeProtoList[cellIndex];
                if (cell2 == null || cell2.getLibrary() != reader.lib) continue;
                reader.cellLambda[cellIndex] = reader.computeLambda(cell2, cellIndex);
                cell2.setTempInt(cellIndex);
                cell2.clearBit(markCellForNodes);
            }
        }
        cellsConstructed = 0;
        for (int i = 0; i < 20; ++i) {
            boolean unchanged = true;
            Iterator it2 = libsBeingRead.values().iterator();
            while (it2.hasNext()) {
                LibraryFiles reader = (LibraryFiles)it2.next();
                for (int cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                    cell = reader.nodeProtoList[cellIndex];
                    if (cell == null || cell.getLibrary() != reader.lib || !reader.spreadLambda(cell, cellIndex)) continue;
                    unchanged = false;
                }
            }
            if (unchanged) break;
        }
        it = libsBeingRead.values().iterator();
        while (it.hasNext()) {
            LibraryFiles reader = (LibraryFiles)it.next();
            for (int cellIndex = 0; cellIndex < reader.nodeProtoCount; ++cellIndex) {
                cell2 = reader.nodeProtoList[cellIndex];
                if (cell2 == null || cell2.isBit(markCellForNodes)) continue;
                reader.realizeCellsRecursively(cell2, markCellForNodes, null, 0.0, 0.0);
            }
        }
        markCellForNodes.freeFlagSet();
        boolean first = true;
        Iterator it3 = libsBeingRead.values().iterator();
        while (it3.hasNext()) {
            Iterator sIt;
            StringBuffer sb;
            LibraryFiles reader = (LibraryFiles)it3.next();
            if (reader.scaledCells != null && reader.scaledCells.size() != 0) {
                if (first) {
                    System.out.println("WARNING: to accommodate scaling inconsistencies, these cells were created:");
                    first = false;
                }
                sb = new StringBuffer();
                sb.append("   Library " + reader.lib.getName() + ":");
                sIt = reader.scaledCells.iterator();
                while (sIt.hasNext()) {
                    cell = (Cell)sIt.next();
                    sb.append(" " + cell.noLibDescribe());
                }
                System.out.println(sb.toString());
            }
            if (reader.skewedCells == null || reader.skewedCells.size() == 0) continue;
            if (first) {
                System.out.println("ERROR: because of library inconsistencies, these stretched cells were created:");
                first = false;
            }
            sb = new StringBuffer();
            sb.append("   Library " + reader.lib.getName() + ":");
            sIt = reader.skewedCells.iterator();
            while (sIt.hasNext()) {
                cell = (Cell)sIt.next();
                sb.append(" " + cell.noLibDescribe());
            }
            System.out.println(sb.toString());
        }
        LibraryFiles.convertOldLibraries();
    }

    private static void convertOldLibraries() {
        MoCMOS.tech.convertOldState();
    }

    protected LibraryFiles getReaderForLib(Library lib) {
        return (LibraryFiles)libsBeingRead.get(lib);
    }

    protected double computeLambda(Cell cell, int cellIndex) {
        return 1.0;
    }

    protected boolean spreadLambda(Cell cell, int cellIndex) {
        return false;
    }

    protected void realizeCellsRecursively(Cell cell, FlagSet recursiveSetupFlag, String scaledCellName, double scaleX, double scaleY) {
    }

    protected boolean readerHasExport(Cell c, String portName) {
        return false;
    }

    protected static class NodeInstList {
        protected NodeInst[] theNode;
        protected NodeProto[] protoType;
        protected Name[] name;
        protected int[] lowX;
        protected int[] highX;
        protected int[] lowY;
        protected int[] highY;
        protected int[] anchorX;
        protected int[] anchorY;
        protected short[] rotation;
        protected int[] transpose;
        protected int[] userBits;

        protected NodeInstList() {
        }
    }
}

