/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.CIF;
import com.sun.electric.tool.io.output.DXF;
import com.sun.electric.tool.io.output.ECAD;
import com.sun.electric.tool.io.output.EDIF;
import com.sun.electric.tool.io.output.ELIB;
import com.sun.electric.tool.io.output.Eagle;
import com.sun.electric.tool.io.output.FastHenry;
import com.sun.electric.tool.io.output.GDS;
import com.sun.electric.tool.io.output.IRSIM;
import com.sun.electric.tool.io.output.JELIB;
import com.sun.electric.tool.io.output.L;
import com.sun.electric.tool.io.output.LEF;
import com.sun.electric.tool.io.output.MOSSIM;
import com.sun.electric.tool.io.output.Maxwell;
import com.sun.electric.tool.io.output.PAL;
import com.sun.electric.tool.io.output.Pads;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.io.output.ReadableDump;
import com.sun.electric.tool.io.output.Silos;
import com.sun.electric.tool.io.output.Sim;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Tegas;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class Output {
    protected String filePath;
    protected PrintWriter printWriter;
    protected DataOutputStream dataOutputStream;
    private int lineCharCount = 0;
    private int maxWidth = 80;
    private boolean strictWidthLimit = false;
    private char commentChar = '\u0000';
    private String continuationString = "";

    protected boolean writeLib(Library lib) {
        return true;
    }

    protected boolean writeCell(Cell cell, VarContext context) {
        return true;
    }

    public static boolean writeLibrary(Library lib, FileType type, boolean compatibleWith6) {
        block32: {
            String properOutputName;
            block29: {
                block31: {
                    File newFile;
                    int backupScheme;
                    String properOutputNameWithoutExtension;
                    block30: {
                        Technology tech;
                        ArrayList<String> dummyCells = new ArrayList<String>();
                        dummyCells.add("WARNING: Library " + lib.getName() + " contains the following Dummy cells:");
                        Iterator it = lib.getCells();
                        while (it.hasNext()) {
                            Cell c = (Cell)it.next();
                            if (c.getVar(Input.IO_DUMMY_OBJECT) == null) continue;
                            dummyCells.add("   " + c.noLibDescribe());
                        }
                        if (dummyCells.size() > 1) {
                            dummyCells.add("Do you really want to write this library?");
                            Object[] options = new Object[]{"Continue Writing", "Cancel"};
                            int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), dummyCells.toArray(), "Dummy Cells Found in " + lib.getName(), -1, 2, null, options, options[1]);
                            if (val == 1) {
                                return true;
                            }
                        }
                        it = Tool.getListeners();
                        while (it.hasNext()) {
                            Listener listener = (Listener)it.next();
                            listener.writeLibrary(lib);
                        }
                        double largestScale = 0.0;
                        Iterator it2 = Technology.getTechnologies();
                        while (it2.hasNext()) {
                            tech = (Technology)it2.next();
                            if (tech.isScaleRelevant() || tech == Generic.tech || !(tech.getScale() > largestScale)) continue;
                            largestScale = tech.getScale();
                        }
                        it2 = Technology.getTechnologies();
                        while (it2.hasNext()) {
                            tech = (Technology)it2.next();
                            if (tech.isScaleRelevant() || tech == Generic.tech) continue;
                            tech.setScale(largestScale);
                        }
                        URL libFile = lib.getLibFile();
                        if (libFile == null) {
                            libFile = TextUtils.makeURLToFile(lib.getName());
                        }
                        properOutputName = properOutputNameWithoutExtension = TextUtils.getFilePath(libFile) + TextUtils.getFileNameWithoutExtension(libFile);
                        if (type == FileType.ELIB) {
                            properOutputName = properOutputName + ".elib";
                        }
                        if (type == FileType.JELIB) {
                            properOutputName = properOutputName + ".jelib";
                        }
                        if (type == FileType.READABLEDUMP) {
                            properOutputName = properOutputName + ".txt";
                        }
                        if (type != FileType.ELIB && type != FileType.JELIB) break block29;
                        backupScheme = IOTool.getBackupRedundancy();
                        if (backupScheme != 1) break block30;
                        newFile = new File(properOutputName);
                        if (!newFile.exists()) break block31;
                        String backupFileName = properOutputName + "~";
                        File oldFile = new File(backupFileName);
                        boolean canRename = true;
                        if (oldFile.exists() && !oldFile.delete()) {
                            System.out.println("Unable to delete former library file " + oldFile);
                            canRename = false;
                        }
                        if (canRename && !newFile.renameTo(oldFile)) {
                            System.out.println("Unable to rename " + newFile + " to " + oldFile);
                        }
                        break block31;
                    }
                    if (backupScheme == 2 && (newFile = new File(properOutputName)).exists()) {
                        long modified = newFile.lastModified();
                        Date modifiedDate = new Date(modified);
                        SimpleDateFormat sdf = new SimpleDateFormat("-yyyy-MM-dd");
                        for (int i = 0; i < 1000; ++i) {
                            File oldFile;
                            String backupFileName = properOutputNameWithoutExtension + sdf.format(modifiedDate);
                            if (i != 0) {
                                backupFileName = backupFileName + "--" + i;
                            }
                            if ((oldFile = new File(backupFileName = backupFileName + "." + type.getExtensions()[0])).exists()) continue;
                            if (newFile.renameTo(oldFile)) break;
                            System.out.println("Unable to rename " + newFile + " to " + oldFile);
                            break;
                        }
                    }
                }
                if (type == FileType.ELIB) {
                    ELIB out;
                    ELIB elib = new ELIB();
                    if (compatibleWith6) {
                        elib.write6Compatible();
                    }
                    if ((out = elib).openBinaryOutputStream(properOutputName)) {
                        return true;
                    }
                    if (((Output)out).writeLib(lib)) {
                        return true;
                    }
                    if (out.closeBinaryOutputStream()) {
                        return true;
                    }
                } else {
                    JELIB jelib = new JELIB();
                    JELIB out = jelib;
                    if (out.openTextOutputStream(properOutputName)) {
                        return true;
                    }
                    if (((Output)out).writeLib(lib)) {
                        return true;
                    }
                    if (out.closeTextOutputStream()) {
                        return true;
                    }
                }
                break block32;
            }
            if (type == FileType.READABLEDUMP) {
                ReadableDump out = new ReadableDump();
                if (out.openTextOutputStream(properOutputName)) {
                    return true;
                }
                if (((Output)out).writeLib(lib)) {
                    return true;
                }
                if (out.closeTextOutputStream()) {
                    return true;
                }
            } else {
                System.out.println("Unknown export type: " + type);
                return true;
            }
        }
        return false;
    }

    public static void writeCell(Cell cell, VarContext context, String filePath, FileType type) {
        if (type == FileType.CDL) {
            Spice.writeSpiceFile(cell, context, filePath, true);
        } else if (type == FileType.CIF) {
            CIF.writeCIFFile(cell, context, filePath);
        } else if (type == FileType.COSMOS) {
            Sim.writeSimFile(cell, context, filePath, type);
        } else if (type == FileType.DXF) {
            DXF.writeDXFFile(cell, context, filePath);
        } else if (type == FileType.EAGLE) {
            Eagle.writeEagleFile(cell, context, filePath);
        } else if (type == FileType.ECAD) {
            ECAD.writeECADFile(cell, context, filePath);
        } else if (type == FileType.EDIF) {
            EDIF.writeEDIFFile(cell, context, filePath);
        } else if (type == FileType.ESIM) {
            Sim.writeSimFile(cell, context, filePath, type);
        } else if (type == FileType.FASTHENRY) {
            FastHenry.writeFastHenryFile(cell, context, filePath);
        } else if (type == FileType.GDS) {
            GDS.writeGDSFile(cell, context, filePath);
        } else if (type == FileType.IRSIM) {
            IRSIM.writeIRSIMFile(cell, context, filePath);
        } else if (type == FileType.L) {
            L.writeLFile(cell, context, filePath);
        } else if (type == FileType.LEF) {
            LEF.writeLEFFile(cell, context, filePath);
        } else if (type == FileType.MAXWELL) {
            Maxwell.writeMaxwellFile(cell, context, filePath);
        } else if (type == FileType.MOSSIM) {
            MOSSIM.writeMOSSIMFile(cell, context, filePath);
        } else if (type == FileType.PADS) {
            Pads.writePadsFile(cell, context, filePath);
        } else if (type == FileType.PAL) {
            PAL.writePALFile(cell, context, filePath);
        } else if (type == FileType.POSTSCRIPT || type == FileType.EPS) {
            PostScript.writePostScriptFile(cell, context, filePath);
        } else if (type == FileType.RSIM) {
            Sim.writeSimFile(cell, context, filePath, type);
        } else if (type == FileType.SILOS) {
            Silos.writeSilosFile(cell, context, filePath);
        } else if (type == FileType.SKILL) {
            IOTool.writeSkill(cell, filePath);
        } else if (type == FileType.SPICE) {
            Spice.writeSpiceFile(cell, context, filePath, false);
        } else if (type == FileType.TEGAS) {
            Tegas.writeTegasFile(cell, context, filePath);
        } else if (type == FileType.VERILOG) {
            Verilog.writeVerilogFile(cell, context, filePath);
        }
    }

    public static void createFontAssociationVariable(Library lib) {
        int maxIndices = TextDescriptor.ActiveFont.getMaxIndex();
        if (maxIndices == 0) {
            return;
        }
        boolean[] fontFound = new boolean[maxIndices];
        for (int i = 0; i < maxIndices; ++i) {
            fontFound[i] = false;
        }
        Output.checkFontUsage(lib, fontFound);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            Output.checkFontUsage(cell, fontFound);
            Iterator nIt = cell.getNodes();
            while (nIt.hasNext()) {
                NodeInst ni = (NodeInst)nIt.next();
                Output.checkFontUsage(ni, fontFound);
                Output.updateFontUsage(ni.getNameTextDescriptor(), fontFound);
                if (ni.getProto() instanceof Cell) {
                    Output.updateFontUsage(ni.getProtoTextDescriptor(), fontFound);
                }
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    Output.checkFontUsage(pi, fontFound);
                }
            }
            Iterator aIt = cell.getArcs();
            while (aIt.hasNext()) {
                ArcInst ai = (ArcInst)aIt.next();
                Output.checkFontUsage(ai, fontFound);
                Output.updateFontUsage(ai.getNameTextDescriptor(), fontFound);
            }
            Iterator eIt = cell.getPorts();
            while (eIt.hasNext()) {
                Export pp = (Export)eIt.next();
                Output.checkFontUsage(pp, fontFound);
                Output.updateFontUsage(pp.getTextDescriptor(), fontFound);
            }
        }
        ArrayList<String> associations = new ArrayList<String>();
        for (int i = 0; i < maxIndices; ++i) {
            TextDescriptor.ActiveFont af;
            if (!fontFound[i] || (af = TextDescriptor.ActiveFont.findActiveFont(i + 1)) == null) continue;
            String association = Integer.toString(i + 1) + "/" + af.getName();
            associations.add(association);
        }
        int numAssociations = associations.size();
        if (numAssociations == 0) {
            return;
        }
        String[] assocArray = new String[numAssociations];
        int i = 0;
        Iterator it2 = associations.iterator();
        while (it2.hasNext()) {
            assocArray[i++] = (String)it2.next();
        }
        lib.newVar(Library.FONT_ASSOCIATIONS, (Object)assocArray);
    }

    private static void checkFontUsage(ElectricObject eobj, boolean[] fontFound) {
        Iterator it = eobj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            Output.updateFontUsage(var.getTextDescriptor(), fontFound);
        }
    }

    private static void updateFontUsage(TextDescriptor td, boolean[] fontFound) {
        int fontIndex = td.getFace();
        if (fontIndex == 0) {
            return;
        }
        fontFound[fontIndex - 1] = true;
    }

    protected boolean openBinaryOutputStream(String filePath) {
        FileOutputStream fileOutputStream;
        this.filePath = filePath;
        try {
            fileOutputStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not write file " + filePath);
            System.out.println("Reason: " + e.getMessage());
            return true;
        }
        BufferedOutputStream bufStrm = new BufferedOutputStream(fileOutputStream);
        this.dataOutputStream = new DataOutputStream(bufStrm);
        return false;
    }

    protected boolean closeBinaryOutputStream() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing " + this.filePath);
            return true;
        }
        return false;
    }

    protected boolean openTextOutputStream(String filePath) {
        this.filePath = filePath;
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath);
            return true;
        }
        return false;
    }

    protected void emitCopyright(String prefix, String postfix) {
        if (!IOTool.isUseCopyrightMessage()) {
            return;
        }
        String str = IOTool.getCopyrightMessage();
        int start = 0;
        while (start < str.length()) {
            int endPos = str.indexOf(10, start);
            if (endPos < 0) {
                endPos = str.length();
            }
            String oneLine = str.substring(start, endPos);
            this.printWriter.println(prefix + oneLine + postfix);
            start = endPos + 1;
        }
    }

    protected void setOutputWidth(int width, boolean strict) {
        this.maxWidth = width;
        this.strictWidthLimit = strict;
    }

    protected void setCommentChar(char ch) {
        this.commentChar = ch;
    }

    protected void setContinuationString(String str) {
        this.continuationString = str;
    }

    private void writeChunk(String str) {
        int len = str.length();
        if (len <= 0) {
            return;
        }
        this.printWriter.print(str);
        this.lineCharCount += len;
        if (str.charAt(len - 1) == '\n') {
            this.lineCharCount = 0;
        }
    }

    protected void writeWidthLimited(String str) {
        int len;
        while ((len = str.length()) > 0) {
            int i = str.indexOf(10);
            i = i < 0 ? len : ++i;
            if (this.lineCharCount + i < this.maxWidth) {
                String chunk = str;
                if (i < len) {
                    chunk = str.substring(0, i);
                }
                this.writeChunk(chunk);
                if ((str = str.substring(i)).length() != 0) continue;
                break;
            }
            int left = this.maxWidth - this.lineCharCount;
            String exact = str.substring(0, left);
            int splitPos = exact.lastIndexOf(32);
            if (splitPos < 0 && (splitPos = exact.lastIndexOf(44)) < 0 && (splitPos = exact.lastIndexOf(40)) < 0) {
                splitPos = exact.lastIndexOf(41);
            }
            if (splitPos > 0) {
                exact = exact.substring(0, splitPos + 1);
            } else if (!this.strictWidthLimit) {
                splitPos = str.indexOf(32, left);
                if (splitPos < 0 && (splitPos = str.indexOf(44, left)) < 0 && (splitPos = str.indexOf(40, left)) < 0) {
                    splitPos = str.indexOf(41, left);
                }
                if (splitPos > 0) {
                    exact = str.substring(0, splitPos + 1);
                }
            }
            this.writeChunk(exact);
            this.writeChunk("\n");
            if (this.continuationString.length() > 0) {
                this.writeChunk(this.continuationString);
            }
            str = str.substring(exact.length());
        }
    }

    public Rectangle2D getAreaToPrint(Cell cell, boolean reduce, EditWindow wnd) {
        Rectangle2D bounds = cell.getBounds();
        if (wnd != null) {
            bounds = wnd.getBoundsInWindow();
        }
        if (reduce) {
            double wid = bounds.getWidth() * 0.75;
            double hei = bounds.getHeight() * 0.75;
            bounds.setRect(bounds.getCenterX(), bounds.getCenterY(), wid, hei);
        }
        if (IOTool.getPlotArea() != 0) {
            if (wnd == null) {
                System.out.println("No current window: printing entire cell");
            } else if (IOTool.getPlotArea() == 2) {
                bounds = wnd.getDisplayedBounds();
            } else {
                Rectangle2D hBounds = wnd.getHighlighter().getHighlightedArea(wnd);
                if (hBounds == null || hBounds.getWidth() == 0.0 || hBounds.getHeight() == 0.0) {
                    System.out.println("Warning: no highlighted area; printing entire cell");
                } else {
                    bounds = hBounds;
                }
            }
        }
        return bounds;
    }

    protected boolean closeTextOutputStream() {
        this.printWriter.close();
        return false;
    }
}

