/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.ListNccAnnotations;
import com.sun.electric.tool.ncc.NccBottomUp;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.basic.NccUtils;
import java.util.Date;

public class Ncc {
    private void prln(String s) {
        System.out.println(s);
    }

    private Ncc() {
    }

    private NccResult compare1(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, NccOptions options) {
        if (options.operation == 3) {
            ListNccAnnotations.doYourJob(cell1, cell2);
            return new NccResult(true, true, true, null);
        }
        Date before = new Date();
        NccResult result = new NccResult(false, false, false, null);
        if (options.operation == 2) {
            this.prln("Flat NCC top cell");
            result = NccUtils.compareAndPrintStatus(cell1, ctxt1, cell2, ctxt2, null, options);
        } else if (options.operation == 1) {
            this.prln("Flat NCC every cell in the design");
            result = NccBottomUp.compare(cell1, cell2, false, options.skipPassed, options);
        } else if (options.operation == 0) {
            this.prln("Hierarchical NCC every cell in the design");
            result = NccBottomUp.compare(cell1, cell2, true, options.skipPassed, options);
        } else {
            LayoutLib.error(true, "bad operation: " + options.operation);
            return result;
        }
        System.out.println("Summary for all cells: " + result.summary(options.checkSizes));
        Date after = new Date();
        System.out.println("NCC command completed in: " + NccUtils.hourMinSec(before, after) + ".");
        return result;
    }

    public static NccResult compare(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, NccOptions options) {
        if (ctxt1 == null) {
            ctxt1 = VarContext.globalContext;
        }
        if (ctxt2 == null) {
            ctxt2 = VarContext.globalContext;
        }
        Ncc ncc = new Ncc();
        return ncc.compare1(cell1, ctxt1, cell2, ctxt2, options);
    }
}

