/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Spread
extends EDialog {
    NodeInst ni;
    private JButton cancel;
    private ButtonGroup direction;
    private JLabel jLabel1;
    private JButton ok;
    private JTextField spreadAmount;
    private JRadioButton spreadDown;
    private JRadioButton spreadLeft;
    private JRadioButton spreadRight;
    private JRadioButton spreadUp;

    public static void showSpreadDialog() {
        Cell cell = WindowFrame.needCurCell();
        EditWindow wnd = EditWindow.getCurrent();
        NodeInst ni = (NodeInst)wnd.getHighlighter().getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        Spread dialog = new Spread((Frame)TopLevel.getCurrentJFrame(), true, ni);
        dialog.setVisible(true);
    }

    public Spread(Frame parent, boolean modal, NodeInst ni) {
        super(parent, modal);
        this.ni = ni;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.spreadUp.setSelected(true);
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void initComponents() {
        this.direction = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.spreadAmount = new JTextField();
        this.spreadUp = new JRadioButton();
        this.spreadDown = new JRadioButton();
        this.spreadLeft = new JRadioButton();
        this.spreadRight = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Spread About Highlighted");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Spread.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Spread.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Spread.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Distance to spread:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.spreadAmount.setColumns(8);
        this.spreadAmount.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadAmount, gridBagConstraints);
        this.spreadUp.setText("Spread up");
        this.direction.add(this.spreadUp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadUp, gridBagConstraints);
        this.spreadDown.setText("Spread down");
        this.direction.add(this.spreadDown);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadDown, gridBagConstraints);
        this.spreadLeft.setText("Spread left");
        this.direction.add(this.spreadLeft);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadLeft, gridBagConstraints);
        this.spreadRight.setText("Spread right");
        this.direction.add(this.spreadRight);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadRight, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        SpreadJob job = new SpreadJob(this);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SpreadJob
    extends Job {
        Spread dialog;

        protected SpreadJob(Spread dialog) {
            super("Spread Circuitry", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            char direction = '\u0000';
            if (this.dialog.spreadUp.isSelected()) {
                direction = 'u';
            } else if (this.dialog.spreadDown.isSelected()) {
                direction = 'd';
            } else if (this.dialog.spreadLeft.isSelected()) {
                direction = 'l';
            } else if (this.dialog.spreadRight.isSelected()) {
                direction = 'r';
            }
            double amount = TextUtils.atof(this.dialog.spreadAmount.getText());
            Cell cell = WindowFrame.needCurCell();
            NodeInst ni = this.dialog.ni;
            if (ni == null) {
                return false;
            }
            SizeOffset so = ni.getSizeOffset();
            double sLx = ni.getTrueCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
            double sHx = ni.getTrueCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
            double sLy = ni.getTrueCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
            double sHy = ni.getTrueCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
            CircuitChanges.spreadCircuitry(cell, ni, direction, amount, sLx, sHx, sLy, sHy);
            return true;
        }
    }
}

