/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.Main;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LibraryPalette;
import com.sun.electric.tool.user.ui.TechPalette;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.RootPaneContainer;

public class PaletteFrame
implements DatabaseChangeListener,
MouseListener {
    private Container container;
    private JPanel paletteSwitcher;
    private TechPalette techPalette;
    private LibraryPalette libraryPalette;
    private JComboBox techSelector;
    private JComboBox librarySelector;
    private JRadioButton techRadioButton;
    private JRadioButton libraryRadioButton;
    private ButtonGroup radioButtonGroup;
    private Dimension libraryPaletteSize;
    private JPopupMenu libraryPopup;
    private static Dimension minSize;
    private static final String TECHPALETTE = "Tech Palette";
    private static final String LIBRARYPALETTE = "Library Palette";

    private PaletteFrame() {
    }

    public static PaletteFrame newInstance() {
        PaletteFrame palette = new PaletteFrame();
        if (TopLevel.isMDIMode()) {
            JInternalFrame jInternalFrame = new JInternalFrame("Components", true, false, false, false);
            palette.container = jInternalFrame;
            jInternalFrame.setAutoscrolls(true);
            jInternalFrame.setFrameIcon(TopLevel.getFrameIcon());
        } else {
            JFrame jFrame = new JFrame("Components");
            palette.container = jFrame;
            jFrame.setDefaultCloseOperation(0);
        }
        if (minSize == null) {
            Dimension frameSize;
            Dimension screenSize = TopLevel.getScreenSize();
            int screenHeight = (int)screenSize.getHeight();
            minSize = frameSize = new Dimension(100, (int)((double)screenHeight * 0.9));
        }
        palette.libraryPaletteSize = minSize;
        palette.container.setSize(minSize);
        palette.container.setLocation(0, 0);
        palette.initComponents();
        if (TopLevel.isMDIMode()) {
            if (!Main.BATCHMODE) {
                ((JInternalFrame)palette.container).show();
            }
            TopLevel.addToDesktop((JInternalFrame)palette.container);
        } else if (!Main.BATCHMODE) {
            ((JFrame)palette.container).setVisible(true);
        }
        Undo.addDatabaseChangeListener(palette);
        return palette;
    }

    private void initComponents() {
        Container content = ((RootPaneContainer)((Object)this.container)).getContentPane();
        content.setLayout(new GridBagLayout());
        this.techRadioButton = new JRadioButton();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.techRadioButton, gridBagConstraints);
        this.libraryRadioButton = new JRadioButton();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.libraryRadioButton, gridBagConstraints);
        this.radioButtonGroup = new ButtonGroup();
        this.radioButtonGroup.add(this.techRadioButton);
        this.radioButtonGroup.add(this.libraryRadioButton);
        this.techRadioButton.setSelected(true);
        this.techSelector = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.techSelector, gridBagConstraints);
        this.librarySelector = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.librarySelector, gridBagConstraints);
        this.paletteSwitcher = new JPanel(new CardLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.paletteSwitcher, gridBagConstraints);
        this.techSelector.setLightWeightPopupEnabled(false);
        this.librarySelector.setLightWeightPopupEnabled(false);
        this.techPalette = new TechPalette();
        this.techPalette.setFocusable(true);
        this.libraryPalette = new LibraryPalette(minSize);
        this.paletteSwitcher.add((Component)this.techPalette, TECHPALETTE);
        this.paletteSwitcher.add((Component)this.libraryPalette, LIBRARYPALETTE);
        List techList = Technology.getTechnologiesSortedByName();
        Iterator it = techList.iterator();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            if (tech == Generic.tech) continue;
            this.techSelector.addItem(tech.getTechName());
        }
        this.techSelector.setSelectedItem(Technology.getCurrent().getTechName());
        PaletteControlListener l = new PaletteControlListener(this);
        this.techRadioButton.addActionListener(l);
        this.techSelector.addActionListener(l);
        this.librarySelector.addActionListener(l);
        this.libraryRadioButton.addActionListener(l);
        this.librarySelector.addMouseListener(this);
        this.updateLibrarySelector();
    }

    private void updateLibrarySelector() {
        this.librarySelector.removeAllItems();
        List libList = Library.getVisibleLibrariesSortedByName();
        Iterator it = libList.iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            this.librarySelector.addItem(lib.getName());
        }
        Library current = Library.getCurrent();
        if (current != null) {
            this.librarySelector.setSelectedItem(current.getName());
        }
        this.libraryPalette.setLibrary(current);
    }

    public void setCursor(Cursor cursor) {
        this.techPalette.setCursor(cursor);
        this.libraryPalette.setCursor(cursor);
    }

    public Rectangle getPaletteLocation() {
        return this.container.getBounds();
    }

    public void arcProtoChanged() {
        this.techPalette.repaint();
    }

    public static void autoTechnologySwitch(Cell cell) {
        if (cell.getView().isTextView()) {
            return;
        }
        Technology tech = cell.getTechnology();
        if (tech != null && tech != Technology.getCurrent() && User.isAutoTechnologySwitch()) {
            tech.setCurrent();
            TopLevel.getPaletteFrame().techSelector.setSelectedItem(tech.getTechName());
        }
    }

    public void switchToPalette(String paletteName) {
        if (this.libraryPalette.isVisible()) {
            this.libraryPaletteSize = this.container.getSize();
        }
        CardLayout layout = (CardLayout)this.paletteSwitcher.getLayout();
        if (paletteName == TECHPALETTE) {
            layout.show(this.paletteSwitcher, TECHPALETTE);
        }
        if (paletteName == LIBRARYPALETTE) {
            layout.show(this.paletteSwitcher, LIBRARYPALETTE);
            this.setSize(this.libraryPaletteSize);
        }
    }

    public void loadForTechnology() {
        Technology tech = Technology.getCurrent();
        Dimension size = this.techPalette.loadForTechnology(tech);
        if (this.techPalette.isVisible()) {
            this.setSize(size);
        }
    }

    public void loadForLibrary(Library lib) {
        this.libraryPalette.setLibrary(lib);
    }

    private void setSize(Dimension size) {
        if (size.getWidth() < minSize.getWidth()) {
            size.setSize(minSize.getWidth(), size.getHeight());
        }
        if (size.getHeight() < minSize.getHeight()) {
            size.setSize(size.getWidth(), minSize.getHeight());
        }
        this.container.setSize(size);
    }

    public void databaseChanged(Undo.Change evt) {
    }

    public boolean isGUIListener() {
        return true;
    }

    public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
        boolean libChanged = false;
        Iterator it = batch.getChanges();
        while (it.hasNext()) {
            Undo.Change change = (Undo.Change)it.next();
            if (change.getType() == Undo.Type.LIBRARYKILL || change.getType() == Undo.Type.LIBRARYNEW) {
                libChanged = true;
                break;
            }
            if (change.getType() != Undo.Type.OBJECTRENAME || !(change.getObject() instanceof Library)) continue;
            libChanged = true;
            break;
        }
        if (libChanged) {
            this.updateLibrarySelector();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Object source;
        if (e.isShiftDown() || e.isControlDown() || e.isAltDown()) {
            return;
        }
        if (e.isMetaDown() && (source = e.getSource()) == this.librarySelector) {
            this.initLibraryPopup();
            this.libraryPopup.show(this.librarySelector, e.getX(), e.getY());
        }
    }

    private void initLibraryPopup() {
        if (this.libraryPopup != null) {
            return;
        }
        this.libraryPopup = new JPopupMenu();
        JMenuItem m = new JMenuItem("Set current");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PaletteFrame.this.selectedLibSetCurrent();
            }
        });
        this.libraryPopup.add(m);
        m = new JMenuItem("Save");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PaletteFrame.this.selectedLibSave();
            }
        });
        this.libraryPopup.add(m);
        m = new JMenuItem("Save as...");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PaletteFrame.this.selectedLibSaveAs();
            }
        });
        this.libraryPopup.add(m);
        m = new JMenuItem("Rename");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PaletteFrame.this.selectedLibRename();
            }
        });
        this.libraryPopup.add(m);
        m = new JMenuItem("Close");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PaletteFrame.this.selectedLibClose();
            }
        });
        this.libraryPopup.add(m);
    }

    private Library getSelectedLib() {
        String libName = (String)this.librarySelector.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            System.out.println("No such library \"" + libName + "\"");
        }
        return lib;
    }

    private void selectedLibSetCurrent() {
        Library lib = this.getSelectedLib();
        if (lib == null) {
            return;
        }
        lib.setCurrent();
    }

    private void selectedLibSave() {
        Library lib = this.getSelectedLib();
        if (lib == null) {
            return;
        }
        FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true);
    }

    private void selectedLibSaveAs() {
        Library lib = this.getSelectedLib();
        if (lib == null) {
            return;
        }
        FileMenu.saveAsLibraryCommand(lib);
    }

    private void selectedLibRename() {
        Library lib = this.getSelectedLib();
        if (lib == null) {
            return;
        }
        CircuitChanges.renameLibrary(lib);
    }

    private void selectedLibClose() {
        Library lib = this.getSelectedLib();
        if (lib == null) {
            return;
        }
        FileMenu.closeLibraryCommand(lib);
    }

    public static PlaceNodeListener placeInstance(Object obj, PlaceNodeEventListener palette, boolean export) {
        NodeProto np = null;
        NodeInst ni = null;
        String placeText = null;
        String whatToCreate = null;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return null;
        }
        if (obj instanceof String) {
            placeText = (String)obj;
            whatToCreate = Variable.betterVariableName(placeText);
            obj = Generic.tech.invisiblePinNode;
        }
        if (obj instanceof NodeProto) {
            Cell cell;
            Cell iconCell;
            np = (NodeProto)obj;
            if (np instanceof Cell && (iconCell = (cell = (Cell)np).iconView()) != null && iconCell != cell) {
                int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Don't you really want to place the icon " + iconCell.describe() + "?");
                if (response == 2) {
                    return null;
                }
                if (response == 0) {
                    np = iconCell;
                    obj = np;
                }
            }
        } else if (obj instanceof NodeInst) {
            ni = (NodeInst)obj;
            np = ni.getProto();
            whatToCreate = ni.getFunction() + " node";
        }
        if (np != null) {
            EventListener oldListener = WindowFrame.getListener();
            Cursor oldCursor = TopLevel.getCurrentCursor();
            if (whatToCreate != null) {
                System.out.println("Click to create " + whatToCreate);
            } else if (np instanceof Cell) {
                System.out.println("Click to create an instance of cell " + np.describe());
            } else {
                System.out.println("Click to create node " + np.describe());
            }
            EventListener newListener = oldListener;
            if (newListener != null && newListener instanceof PlaceNodeListener) {
                ((PlaceNodeListener)newListener).setParameter(np);
                ((PlaceNodeListener)newListener).makePortWhenCreated(export);
            } else {
                newListener = new PlaceNodeListener(obj, oldListener, oldCursor, palette);
                ((PlaceNodeListener)newListener).makePortWhenCreated(export);
                WindowFrame.setListener(newListener);
            }
            if (placeText != null) {
                ((PlaceNodeListener)newListener).setTextNode(placeText);
            }
            if (palette != null) {
                palette.placeNodeStarted(obj);
            }
            TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(12));
            return (PlaceNodeListener)newListener;
        }
        return null;
    }

    public static class PlaceNewNode
    extends Job {
        Object toDraw;
        Point2D where;
        Cell cell;
        String varName;
        boolean export;

        public PlaceNewNode(String description, Object toDraw, Point2D where, Cell cell, String varName, boolean export) {
            super(description, User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.toDraw = toDraw;
            this.where = where;
            this.cell = cell;
            this.varName = varName;
            this.export = export;
            this.startJob();
        }

        public boolean doIt() {
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter highlighter = wnd.getHighlighter();
            NodeProto np = null;
            NodeInst ni = null;
            if (this.toDraw instanceof NodeProto) {
                np = (NodeProto)this.toDraw;
            } else if (this.toDraw instanceof NodeInst) {
                ni = (NodeInst)this.toDraw;
                np = ni.getProto();
            }
            if (np == null) {
                return false;
            }
            double width = np.getDefWidth();
            double height = np.getDefHeight();
            if (this.varName != null) {
                height = 0.0;
                width = 0.0;
            }
            int defAngle = 0;
            int techBits = 0;
            if (ni != null) {
                defAngle = ni.getAngle();
                techBits = ni.getTechSpecific();
            } else if (np instanceof PrimitiveNode && (defAngle = ((PrimitiveNode)np).getDefPlacementAngle()) >= 3600) {
                defAngle %= 3600;
                width = -width;
            }
            NodeInst newNi = NodeInst.makeInstance(np, this.where, width, height, this.cell, defAngle, null, techBits);
            if (newNi == null) {
                return false;
            }
            if (np == Generic.tech.cellCenterNode || np == Generic.tech.essentialBoundsNode) {
                newNi.setHardSelect();
            }
            if (this.varName != null) {
                Variable var = newNi.newVar(this.varName, (Object)"text");
                if (var != null) {
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getAnnotationTextDescriptor(null);
                    var.setTextDescriptor(td);
                    Highlight h = highlighter.addText(newNi, this.cell, var, null);
                }
            } else {
                Variable var;
                if (np == Schematics.tech.resistorNode) {
                    var = newNi.newVar(Schematics.SCHEM_RESISTANCE, (Object)"100");
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                    var.setTextDescriptor(td);
                } else if (np == Schematics.tech.capacitorNode) {
                    var = newNi.newVar(Schematics.SCHEM_CAPACITANCE, (Object)"100M");
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                    var.setTextDescriptor(td);
                } else if (np == Schematics.tech.inductorNode) {
                    var = newNi.newVar(Schematics.SCHEM_INDUCTANCE, (Object)"100");
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                    var.setTextDescriptor(td);
                } else if (np == Schematics.tech.diodeNode) {
                    var = newNi.newVar(Schematics.SCHEM_DIODE, (Object)"10");
                    var.setDisplay(true);
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                    var.setTextDescriptor(td);
                } else if (np == Schematics.tech.transistorNode || np == Schematics.tech.transistor4Node) {
                    if (newNi.isFET()) {
                        var = newNi.newVar(Schematics.ATTR_WIDTH, (Object)"2");
                        var.setDisplay(true);
                        TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                        td.setOff(0.5, -1.0);
                        var.setTextDescriptor(td);
                        var = newNi.newVar(Schematics.ATTR_LENGTH, (Object)"2");
                        var.setDisplay(true);
                        td = TextDescriptor.getNodeTextDescriptor(null);
                        td.setOff(-0.5, -1.0);
                        if (td.getSize().isAbsolute()) {
                            td.setAbsSize((int)(td.getSize().getSize() - 2.0));
                        } else {
                            td.setRelSize(td.getSize().getSize() - 0.5);
                        }
                        var.setTextDescriptor(td);
                    } else {
                        var = newNi.newVar(Schematics.ATTR_AREA, (Object)"10");
                        var.setDisplay(true);
                        TextDescriptor td = TextDescriptor.getNodeTextDescriptor(null);
                        var.setTextDescriptor(td);
                    }
                }
                ElectricObject eObj = newNi;
                if (newNi.getNumPortInsts() > 0) {
                    eObj = (ElectricObject)newNi.getPortInsts().next();
                }
                highlighter.addElectricObject(eObj, this.cell);
            }
            highlighter.finished();
            if (this.export) {
                ExportChanges.newExportCommand();
                System.out.println("SHOULD EXPORT IT NOW");
            }
            return true;
        }
    }

    public static class PlaceNodeListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private int oldx;
        private int oldy;
        private Point2D drawnLoc;
        private boolean doingMotionDrag;
        private Object toDraw;
        private EventListener oldListener;
        private Cursor oldCursor;
        private String textNode;
        private boolean makePort;
        private PlaceNodeEventListener palette;

        private PlaceNodeListener(Object toDraw, EventListener oldListener, Cursor oldCursor, PlaceNodeEventListener palette) {
            this.toDraw = toDraw;
            this.oldListener = oldListener;
            this.oldCursor = oldCursor;
            this.textNode = null;
            this.makePort = false;
            this.palette = palette;
        }

        public void makePortWhenCreated(boolean m) {
            this.makePort = m;
        }

        public void setParameter(Object toDraw) {
            this.toDraw = toDraw;
        }

        public void setTextNode(String varName) {
            this.textNode = varName;
        }

        public void mouseReleased(MouseEvent evt) {
            if (!(evt.getSource() instanceof EditWindow)) {
                return;
            }
            EditWindow wnd = (EditWindow)evt.getSource();
            this.oldx = evt.getX();
            this.oldy = evt.getY();
            if (wnd.getCell() == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create node: this window has no cell in it");
                return;
            }
            Point2D where = wnd.screenToDatabase(this.oldx, this.oldy);
            EditWindow.gridAlign(where);
            NodeInst ni = null;
            NodeProto np = null;
            if (this.toDraw instanceof NodeProto) {
                np = (NodeProto)this.toDraw;
            } else if (this.toDraw instanceof NodeInst) {
                ni = (NodeInst)this.toDraw;
                np = ni.getProto();
            }
            String descript = "Create ";
            descript = np instanceof Cell ? descript + ((Cell)np).noLibDescribe() : descript + np.getName() + " Primitive";
            wnd.getHighlighter().clear();
            PlaceNewNode job = new PlaceNewNode(descript, this.toDraw, where, wnd.getCell(), this.textNode, this.makePort);
            this.finished(wnd, false);
        }

        public void finished(EditWindow wnd, boolean cancelled) {
            if (wnd != null) {
                Highlighter highlighter = wnd.getHighlighter();
                highlighter.clear();
                highlighter.finished();
            }
            WindowFrame.setListener(this.oldListener);
            TopLevel.setCurrentCursor(this.oldCursor);
            if (this.palette != null) {
                this.palette.placeNodeFinished(cancelled);
            }
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
            if (evt.getSource() instanceof EditWindow) {
                EditWindow wnd = (EditWindow)evt.getSource();
                wnd.showDraggedBox(this.toDraw, evt.getX(), evt.getY());
            }
        }

        public void mouseDragged(MouseEvent evt) {
            if (evt.getSource() instanceof EditWindow) {
                EditWindow wnd = (EditWindow)evt.getSource();
                wnd.showDraggedBox(this.toDraw, evt.getX(), evt.getY());
            }
        }

        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        public void keyPressed(KeyEvent evt) {
            int chr = evt.getKeyCode();
            if (chr == 65 || chr == 27) {
                this.finished(EditWindow.getCurrent(), true);
            }
        }

        public void keyReleased(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }
    }

    public static interface PlaceNodeEventListener {
        public void placeNodeStarted(Object var1);

        public void placeNodeFinished(boolean var1);
    }

    private static class PaletteControlListener
    implements ActionListener {
        PaletteFrame palette;

        PaletteControlListener(PaletteFrame palette) {
            this.palette = palette;
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == this.palette.techSelector) {
                String techName = (String)this.palette.techSelector.getSelectedItem();
                Technology tech = Technology.findTechnology(techName);
                if (tech != null) {
                    tech.setCurrent();
                    this.palette.loadForTechnology();
                }
            } else if (source == this.palette.librarySelector) {
                String libName = (String)this.palette.librarySelector.getSelectedItem();
                Library lib = Library.findLibrary(libName);
                if (lib != null) {
                    this.palette.loadForLibrary(lib);
                }
            } else if (source == this.palette.techRadioButton) {
                this.palette.switchToPalette(PaletteFrame.TECHPALETTE);
                this.palette.loadForTechnology();
            } else if (source == this.palette.libraryRadioButton) {
                this.palette.switchToPalette(PaletteFrame.LIBRARYPALETTE);
                String libName = (String)this.palette.librarySelector.getSelectedItem();
                Library lib = Library.findLibrary(libName);
                if (lib != null) {
                    this.palette.loadForLibrary(lib);
                }
            }
        }
    }
}

