/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellContents;
import com.sun.electric.database.Cell_;
import com.sun.electric.database.DatabaseChangeThread;
import com.sun.electric.database.DatabaseThread;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.text.Name;

public class NodeInst_ {
    final int id;
    public final CellContents parent;
    Cell_ proto;
    ImmutableNodeInst d;
    static final /* synthetic */ boolean $assertionsDisabled;

    NodeInst_(int id, CellContents parent, ImmutableNodeInst d) {
        if (!($assertionsDisabled || d != null && parent.nodes[id] == null)) {
            throw new AssertionError();
        }
        this.id = id;
        this.parent = parent;
        parent.nodes[id] = this;
        this.d = d;
        this.proto = ((DatabaseThread)Thread.currentThread()).cells[d.protoId];
        if (!$assertionsDisabled && this.proto == null) {
            throw new AssertionError();
        }
    }

    void unlink() {
        if (!$assertionsDisabled && this.parent.nodes[this.id] != this) {
            throw new AssertionError();
        }
        this.d = null;
        this.parent.nodes[this.id] = null;
    }

    public Name getName() {
        this.checkAlive();
        return this.d.name;
    }

    public EPoint getAnchor() {
        this.checkAlive();
        return this.d.anchor;
    }

    public void rename(Name name) {
        DatabaseChangeThread thread = this.parent.cell.thread.checkChanging();
        if (name == null) {
            throw new IllegalArgumentException("Node name is null");
        }
        if (this.parent.orderedNodes.containsKey(name) && !name.equals(this.d.name)) {
            throw new IllegalArgumentException("Node " + name + " exists");
        }
        this.parent.orderedNodes.remove(this.d.name);
        this.parent.orderedNodes.put(name, this);
        this.parent.cell.nodes[this.id] = this.d = this.d.withName(name, 0);
        thread.endChanging();
    }

    public void setAnchor(EPoint anchor) {
        DatabaseChangeThread thread = this.parent.cell.thread.checkChanging();
        this.parent.cell.nodes[this.id] = this.d = this.d.withAnchor(anchor);
        thread.endChanging();
    }

    public void kill() {
        DatabaseChangeThread thread = this.parent.cell.thread.checkChanging();
        this.parent.orderedNodes.remove(this.d.name);
        this.unlink();
        this.parent.cell.nodes[this.id] = null;
        thread.endChanging();
    }

    public boolean isAlive() {
        return this.d != null && this.parent.cell.thread == Thread.currentThread() && this.parent.cell.thread.valid;
    }

    void checkAlive() {
        this.parent.cell.thread.checkRunning();
        if (this.d == null) {
            throw new IllegalStateException("Not alive");
        }
    }

    void checkChanging() {
        if (this.parent.cell.thread != Thread.currentThread()) {
            throw new IllegalStateException("Other thread");
        }
        if (!(this.parent.cell.thread instanceof DatabaseChangeThread)) {
            throw new IllegalStateException("Readonly thread");
        }
        if (this.d == null) {
            throw new IllegalStateException("Not alive");
        }
    }

    void restore(ImmutableNodeInst d) {
        if (d.protoId != this.proto.id) {
            this.proto = this.parent.cell.thread.cells[d.protoId];
        }
        if (!$assertionsDisabled && this.proto == null) {
            throw new AssertionError();
        }
        this.d = d;
    }

    void check() {
        if (!$assertionsDisabled && this.d == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.proto != this.parent.cell.thread.cells[this.proto.id]) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.proto == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.proto.id != this.d.protoId) {
            throw new AssertionError();
        }
    }

    void checkLinked() {
        if (!$assertionsDisabled && this.parent.nodes[this.id] != this) {
            throw new AssertionError();
        }
        this.parent.checkLinked();
    }

    static {
        $assertionsDisabled = !NodeInst_.class.desiredAssertionStatus();
    }
}

