/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class Netlist {
    NetCell netCell;
    boolean shortResistors;
    int expectedModCount;
    final int[] netMap;
    final int[] nm_net;
    private Network[] networks;

    Netlist(NetCell netCell, boolean shortResistors, int size) {
        this.netCell = netCell;
        this.shortResistors = shortResistors;
        this.expectedModCount = netCell.modCount;
        this.netMap = new int[size];
        for (int i = 0; i < this.netMap.length; ++i) {
            this.netMap[i] = i;
        }
        this.nm_net = new int[this.netMap.length];
    }

    Netlist(NetCell netCell, boolean shortResistors, Netlist other) {
        this.netCell = netCell;
        this.shortResistors = shortResistors;
        this.expectedModCount = netCell.modCount;
        this.netMap = (int[])other.netMap.clone();
        this.nm_net = new int[this.netMap.length];
    }

    void initNetworks() {
        int i;
        Netlist.closureMap(this.netMap);
        int k = 0;
        for (i = 0; i < this.netMap.length; ++i) {
            if (this.netMap[i] != i) continue;
            ++k;
        }
        if (this.networks == null || this.networks.length != k) {
            this.networks = new Network[k];
        }
        Arrays.fill(this.networks, null);
        k = 0;
        for (i = 0; i < this.netMap.length; ++i) {
            if (this.netMap[i] == i) {
                this.networks[k] = new Network(this, k);
                this.nm_net[i] = k++;
                continue;
            }
            this.nm_net[i] = this.nm_net[this.netMap[i]];
        }
    }

    final void connectMap(int a1, int a2) {
        Netlist.connectMap(this.netMap, a1, a2);
    }

    private static void connectMap(int[] map, int a1, int a2) {
        int k;
        int m1 = a1;
        while (map[m1] != m1) {
            m1 = map[m1];
        }
        int m2 = a2;
        while (map[m2] != m2) {
            m2 = map[m2];
        }
        int m = m1 < m2 ? m1 : m2;
        while (true) {
            k = map[a1];
            map[a1] = m;
            if (a1 == k) break;
            a1 = k;
        }
        while (true) {
            k = map[a2];
            map[a2] = m;
            if (a2 == k) break;
            a2 = k;
        }
    }

    private static void closureMap(int[] map) {
        for (int i = 0; i < map.length; ++i) {
            map[i] = map[map[i]];
        }
    }

    Network getNetworkByMap(int mapOffset) {
        return this.networks[this.nm_net[mapOffset]];
    }

    private final void checkForModification() {
        if (this.expectedModCount != this.netCell.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    public static Nodable getNodableFor(NodeInst ni, int arrayIndex) {
        Cell parent = ni.getParent();
        NetCell netCell = NetworkTool.getNetCell(parent);
        if (netCell == null) {
            return null;
        }
        Iterator it = netCell.getNodables();
        while (it.hasNext()) {
            Nodable no = (Nodable)it.next();
            if (!no.contains(ni, arrayIndex)) continue;
            return no;
        }
        return null;
    }

    public boolean getShortResistors() {
        return this.shortResistors;
    }

    public Iterator getNodables() {
        this.checkForModification();
        return this.netCell.getNodables();
    }

    public Netlist getNetlist(Nodable no) {
        NodeProto np = no.getProto();
        if (!(np instanceof Cell)) {
            return null;
        }
        return NetworkTool.getNetlist((Cell)np, this.shortResistors);
    }

    public Global.Set getGlobals() {
        this.checkForModification();
        return this.netCell.getGlobals();
    }

    public int getNumNetworks() {
        this.checkForModification();
        return this.networks.length;
    }

    public Network getNetwork(int netIndex) {
        this.checkForModification();
        return this.networks[netIndex];
    }

    public Iterator getNetworks() {
        this.checkForModification();
        return Arrays.asList(this.networks).iterator();
    }

    int getNetIndex(Global global) {
        this.checkForModification();
        int netMapIndex = this.netCell.getNetMapOffset(global);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(Nodable no, Global global) {
        this.checkForModification();
        int netMapIndex = this.netCell.getNetMapOffset(no, global);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(Nodable no, PortProto portProto, int busIndex) {
        this.checkForModification();
        if (no.getParent() != this.netCell.cell) {
            return -1;
        }
        if (portProto.getParent() != no.getProto()) {
            System.out.println("Netlist.getNetwork: invalid argument portProto");
            return -1;
        }
        if (busIndex < 0 || busIndex >= this.netCell.getBusWidth(no, portProto)) {
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(no, portProto, busIndex);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(Export export, int busIndex) {
        this.checkForModification();
        if (export.getParent() != this.netCell.cell) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= export.getNameKey().busWidth()) {
            System.out.println("Nodable.getNetwork: invalid arguments busIndex=" + busIndex + " export=" + export);
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(export, busIndex);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    int getNetIndex(ArcInst ai, int busIndex) {
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return -1;
        }
        int netMapIndex = this.netCell.getNetMapOffset(ai, busIndex);
        if (netMapIndex < 0) {
            return -1;
        }
        return this.nm_net[netMapIndex];
    }

    public Network getNetwork(Global global) {
        int netIndex = this.getNetIndex(global);
        if (netIndex < 0) {
            return null;
        }
        return this.networks[netIndex];
    }

    public Network getNetwork(Nodable no, Global global) {
        int netIndex = this.getNetIndex(no, global);
        if (netIndex < 0) {
            return null;
        }
        return this.networks[netIndex];
    }

    public Network getNetwork(Nodable no, PortProto portProto, int busIndex) {
        if (no == null || portProto == null) {
            return null;
        }
        if (no instanceof NodeInst && !((NodeInst)no).isLinked()) {
            return null;
        }
        if (portProto instanceof Export && !((Export)portProto).isLinked()) {
            return null;
        }
        int netIndex = this.getNetIndex(no, portProto, busIndex);
        if (netIndex < 0) {
            return null;
        }
        return this.networks[netIndex];
    }

    public boolean portsConnected(Nodable no, PortProto port1, PortProto port2) {
        if (no == null || port1 == null || port2 == null) {
            return false;
        }
        if (no instanceof NodeInst && !((NodeInst)no).isLinked()) {
            return false;
        }
        if (port1 instanceof Export && !((Export)port1).isLinked()) {
            return false;
        }
        if (port2 instanceof Export && !((Export)port2).isLinked()) {
            return false;
        }
        int busWidth = this.netCell.getBusWidth(no, port1);
        if (this.netCell.getBusWidth(no, port2) != busWidth) {
            return false;
        }
        for (int i = 0; i < busWidth; ++i) {
            if (this.getNetIndex(no, port1, i) == this.getNetIndex(no, port2, i)) continue;
            return false;
        }
        return true;
    }

    public Network getNetwork(PortInst pi) {
        if (!pi.isLinked()) {
            return null;
        }
        PortProto portProto = pi.getPortProto();
        if (portProto.getNameKey().isBus()) {
            System.out.println("PortInst.getNetwork() was called for instance of bus port " + portProto.getName());
            return null;
        }
        return this.getNetwork(pi.getNodeInst(), portProto, 0);
    }

    public Network getNetwork(Export export, int busIndex) {
        if (!export.isLinked()) {
            return null;
        }
        int netIndex = this.getNetIndex(export, busIndex);
        if (netIndex < 0) {
            return null;
        }
        return this.networks[netIndex];
    }

    public Network getNetwork(ArcInst ai, int busIndex) {
        if (!ai.isLinked()) {
            return null;
        }
        int netIndex = this.getNetIndex(ai, busIndex);
        if (netIndex < 0) {
            return null;
        }
        return this.networks[netIndex];
    }

    public boolean sameNetwork(ArcInst ai1, ArcInst ai2) {
        int busWidth2;
        if (ai1 == null || ai2 == null) {
            return false;
        }
        if (!ai1.isLinked()) {
            return false;
        }
        if (!ai2.isLinked()) {
            return false;
        }
        int busWidth1 = this.netCell.getBusWidth(ai1);
        if (busWidth1 != (busWidth2 = this.netCell.getBusWidth(ai2))) {
            return false;
        }
        for (int i = 0; i < busWidth1; ++i) {
            if (this.getNetIndex(ai1, i) == this.getNetIndex(ai2, i)) continue;
            return false;
        }
        return true;
    }

    public boolean sameNetwork(Nodable no, PortProto pp, ArcInst ai) {
        int busWidth2;
        if (no == null || pp == null || ai == null) {
            return false;
        }
        if (no instanceof NodeInst && !((NodeInst)no).isLinked()) {
            return false;
        }
        if (pp instanceof Export && !((Export)pp).isLinked()) {
            return false;
        }
        if (!ai.isLinked()) {
            return false;
        }
        int busWidth1 = this.netCell.getBusWidth(no, pp);
        if (busWidth1 != (busWidth2 = this.netCell.getBusWidth(ai))) {
            return false;
        }
        for (int i = 0; i < busWidth1; ++i) {
            if (this.getNetIndex(no, pp, i) == this.getNetIndex(ai, i)) continue;
            return false;
        }
        return true;
    }

    public boolean sameNetwork(Nodable no1, PortProto pp1, Nodable no2, PortProto pp2) {
        int busWidth2;
        if (no1 == null || pp1 == null || no2 == null || pp2 == null) {
            return false;
        }
        if (no1 instanceof NodeInst && !((NodeInst)no1).isLinked()) {
            return false;
        }
        if (pp1 instanceof Export && !((Export)pp1).isLinked()) {
            return false;
        }
        if (no2 instanceof NodeInst && !((NodeInst)no2).isLinked()) {
            return false;
        }
        if (pp2 instanceof Export && !((Export)pp2).isLinked()) {
            return false;
        }
        int busWidth1 = this.netCell.getBusWidth(no1, pp1);
        if (busWidth1 != (busWidth2 = this.netCell.getBusWidth(no2, pp2))) {
            return false;
        }
        for (int i = 0; i < busWidth1; ++i) {
            if (this.getNetIndex(no1, pp1, i) == this.getNetIndex(no2, pp2, i)) continue;
            return false;
        }
        return true;
    }

    public String getNetworkName(ArcInst ai) {
        if (ai == null || !ai.isLinked()) {
            return null;
        }
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return null;
        }
        int busWidth = this.netCell.getBusWidth(ai);
        if (busWidth > 1) {
            return this.netCell.getBusName(ai).toString();
        }
        Network network = this.getNetwork(ai, 0);
        if (network == null) {
            return null;
        }
        return network.describe(false);
    }

    public Name getBusName(ArcInst ai) {
        if (ai == null || !ai.isLinked()) {
            return null;
        }
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return null;
        }
        int busWidth = this.netCell.getBusWidth(ai);
        if (busWidth <= 1) {
            return null;
        }
        return this.netCell.getBusName(ai);
    }

    public int getBusWidth(Export e) {
        if (e == null || !e.isLinked()) {
            return 0;
        }
        return e.getNameKey().busWidth();
    }

    public int getBusWidth(ArcInst ai) {
        if (ai == null || !ai.isLinked()) {
            return 0;
        }
        this.checkForModification();
        if (ai.getParent() != this.netCell.cell) {
            return 0;
        }
        return this.netCell.getBusWidth(ai);
    }

    public String toString() {
        return "Netlist of " + this.netCell.cell;
    }
}

