/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.ArchSim;
import com.sun.electric.tool.io.output.CIF;
import com.sun.electric.tool.io.output.DXF;
import com.sun.electric.tool.io.output.ECAD;
import com.sun.electric.tool.io.output.EDIF;
import com.sun.electric.tool.io.output.ELIB;
import com.sun.electric.tool.io.output.Eagle;
import com.sun.electric.tool.io.output.FastHenry;
import com.sun.electric.tool.io.output.GDS;
import com.sun.electric.tool.io.output.HPGL;
import com.sun.electric.tool.io.output.IRSIM;
import com.sun.electric.tool.io.output.JELIB;
import com.sun.electric.tool.io.output.L;
import com.sun.electric.tool.io.output.LEF;
import com.sun.electric.tool.io.output.MOSSIM;
import com.sun.electric.tool.io.output.Maxwell;
import com.sun.electric.tool.io.output.PAL;
import com.sun.electric.tool.io.output.Pads;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.io.output.ReadableDump;
import com.sun.electric.tool.io.output.Silos;
import com.sun.electric.tool.io.output.Sim;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Tegas;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class Output {
    static final Comparator CONNECTIONS_ORDER = new OrderedConnections();
    static final Comparator EXPORTS_ORDER = new OrderedExports();
    protected String filePath;
    protected PrintWriter printWriter;
    protected DataOutputStream dataOutputStream;
    HashMap objInfo;
    int[] faceMap;
    TreeMap nameSpace;
    private int lineCharCount = 0;
    private int maxWidth = 80;
    private boolean strictWidthLimit = false;
    private char commentChar = '\u0000';
    private String continuationString = "";

    public static void exportCellCommand(Cell cell, VarContext context, String filePath, FileType type) {
        new OutputCellInfo(cell, context, filePath, type, true);
    }

    protected boolean writeLib(Library lib) {
        return true;
    }

    protected boolean writeCell(Cell cell, VarContext context) {
        return true;
    }

    public static boolean writeLibrary(Library lib, FileType type, boolean compatibleWith6) {
        block32: {
            String properOutputName;
            block29: {
                block31: {
                    File newFile;
                    int backupScheme;
                    String properOutputNameWithoutExtension;
                    block30: {
                        Technology tech;
                        ArrayList<String> dummyCells = new ArrayList<String>();
                        dummyCells.add("WARNING: " + lib + " contains the following Dummy cells:");
                        Iterator it = lib.getCells();
                        while (it.hasNext()) {
                            Cell c = (Cell)it.next();
                            if (c.getVar(Input.IO_DUMMY_OBJECT) == null) continue;
                            dummyCells.add("   " + c.noLibDescribe());
                        }
                        if (dummyCells.size() > 1) {
                            dummyCells.add("Do you really want to write this library?");
                            Object[] options = new Object[]{"Continue Writing", "Cancel"};
                            int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), dummyCells.toArray(), "Dummy Cells Found in " + lib, -1, 2, null, options, options[1]);
                            if (val == 1) {
                                return true;
                            }
                        }
                        it = Tool.getListeners();
                        while (it.hasNext()) {
                            Listener listener = (Listener)it.next();
                            listener.writeLibrary(lib);
                        }
                        double largestScale = 0.0;
                        Iterator it2 = Technology.getTechnologies();
                        while (it2.hasNext()) {
                            tech = (Technology)it2.next();
                            if (tech.isScaleRelevant() || tech == Generic.tech || !(tech.getScale() > largestScale)) continue;
                            largestScale = tech.getScale();
                        }
                        it2 = Technology.getTechnologies();
                        while (it2.hasNext()) {
                            tech = (Technology)it2.next();
                            if (tech.isScaleRelevant() || tech == Generic.tech) continue;
                            tech.setScale(largestScale);
                        }
                        URL libFile = lib.getLibFile();
                        if (libFile == null) {
                            libFile = TextUtils.makeURLToFile(lib.getName());
                        }
                        properOutputName = properOutputNameWithoutExtension = TextUtils.getFilePath(libFile) + TextUtils.getFileNameWithoutExtension(libFile);
                        if (type == FileType.ELIB) {
                            properOutputName = properOutputName + ".elib";
                        }
                        if (type == FileType.JELIB) {
                            properOutputName = properOutputName + ".jelib";
                        }
                        if (type == FileType.READABLEDUMP) {
                            properOutputName = properOutputName + ".txt";
                        }
                        if (type != FileType.ELIB && type != FileType.JELIB) break block29;
                        backupScheme = IOTool.getBackupRedundancy();
                        if (backupScheme != 1) break block30;
                        newFile = new File(properOutputName);
                        if (!newFile.exists()) break block31;
                        String backupFileName = properOutputName + "~";
                        File oldFile = new File(backupFileName);
                        boolean canRename = true;
                        if (oldFile.exists() && !oldFile.delete()) {
                            System.out.println("Unable to delete former library file " + oldFile);
                            canRename = false;
                        }
                        if (canRename && !newFile.renameTo(oldFile)) {
                            System.out.println("Unable to rename " + newFile + " to " + oldFile);
                        }
                        break block31;
                    }
                    if (backupScheme == 2 && (newFile = new File(properOutputName)).exists()) {
                        long modified = newFile.lastModified();
                        Date modifiedDate = new Date(modified);
                        SimpleDateFormat sdf = new SimpleDateFormat("-yyyy-MM-dd");
                        for (int i = 0; i < 1000; ++i) {
                            File oldFile;
                            String backupFileName = properOutputNameWithoutExtension + sdf.format(modifiedDate);
                            if (i != 0) {
                                backupFileName = backupFileName + "--" + i;
                            }
                            if ((oldFile = new File(backupFileName = backupFileName + "." + type.getExtensions()[0])).exists()) continue;
                            if (newFile.renameTo(oldFile)) break;
                            System.out.println("Unable to rename " + newFile + " to " + oldFile);
                            break;
                        }
                    }
                }
                if (type == FileType.ELIB) {
                    ELIB out;
                    ELIB elib = new ELIB();
                    if (compatibleWith6) {
                        elib.write6Compatible();
                    }
                    if ((out = elib).openBinaryOutputStream(properOutputName)) {
                        return true;
                    }
                    if (((Output)out).writeLib(lib)) {
                        return true;
                    }
                    if (out.closeBinaryOutputStream()) {
                        return true;
                    }
                } else {
                    JELIB jelib = new JELIB();
                    JELIB out = jelib;
                    if (out.openTextOutputStream(properOutputName)) {
                        return true;
                    }
                    if (((Output)out).writeLib(lib)) {
                        return true;
                    }
                    if (out.closeTextOutputStream()) {
                        return true;
                    }
                }
                break block32;
            }
            if (type == FileType.READABLEDUMP) {
                ReadableDump out = new ReadableDump();
                if (out.openTextOutputStream(properOutputName)) {
                    return true;
                }
                if (((Output)out).writeLib(lib)) {
                    return true;
                }
                if (out.closeTextOutputStream()) {
                    return true;
                }
            } else {
                System.out.println("Unknown export type: " + type);
                return true;
            }
        }
        return false;
    }

    private static void writeCell(OutputCellInfo cellJob) {
        if (cellJob.type == FileType.ARCHSIM) {
            ArchSim.writeArchSimFile(cellJob);
        } else if (cellJob.type == FileType.CDL) {
            Spice.writeSpiceFile(cellJob, true);
        } else if (cellJob.type == FileType.CIF) {
            CIF.writeCIFFile(cellJob);
        } else if (cellJob.type == FileType.COSMOS) {
            Sim.writeSimFile(cellJob);
        } else if (cellJob.type == FileType.DXF) {
            DXF.writeDXFFile(cellJob);
        } else if (cellJob.type == FileType.EAGLE) {
            Eagle.writeEagleFile(cellJob);
        } else if (cellJob.type == FileType.ECAD) {
            ECAD.writeECADFile(cellJob);
        } else if (cellJob.type == FileType.EDIF) {
            EDIF.writeEDIFFile(cellJob);
        } else if (cellJob.type == FileType.ESIM || cellJob.type == FileType.RSIM) {
            Sim.writeSimFile(cellJob);
        } else if (cellJob.type == FileType.FASTHENRY) {
            FastHenry.writeFastHenryFile(cellJob);
        } else if (cellJob.type == FileType.HPGL) {
            HPGL.writeHPGLFile(cellJob);
        } else if (cellJob.type == FileType.GDS) {
            GDS.writeGDSFile(cellJob);
        } else if (cellJob.type == FileType.IRSIM) {
            IRSIM.writeIRSIMFile(cellJob);
        } else if (cellJob.type == FileType.L) {
            L.writeLFile(cellJob);
        } else if (cellJob.type == FileType.LEF) {
            LEF.writeLEFFile(cellJob);
        } else if (cellJob.type == FileType.MAXWELL) {
            Maxwell.writeMaxwellFile(cellJob);
        } else if (cellJob.type == FileType.MOSSIM) {
            MOSSIM.writeMOSSIMFile(cellJob);
        } else if (cellJob.type == FileType.PADS) {
            Pads.writePadsFile(cellJob);
        } else if (cellJob.type == FileType.PAL) {
            PAL.writePALFile(cellJob);
        } else if (cellJob.type == FileType.POSTSCRIPT || cellJob.type == FileType.EPS) {
            PostScript.writePostScriptFile(cellJob);
        } else if (cellJob.type == FileType.SILOS) {
            Silos.writeSilosFile(cellJob);
        } else if (cellJob.type == FileType.SKILL) {
            IOTool.writeSkill(cellJob.cell, cellJob.filePath, false);
        } else if (cellJob.type == FileType.SKILLEXPORTSONLY) {
            IOTool.writeSkill(cellJob.cell, cellJob.filePath, true);
        } else if (cellJob.type == FileType.SPICE) {
            Spice.writeSpiceFile(cellJob, false);
        } else if (cellJob.type == FileType.TEGAS) {
            Tegas.writeTegasFile(cellJob);
        } else if (cellJob.type == FileType.VERILOG) {
            Verilog.writeVerilogFile(cellJob);
        }
    }

    void gatherReferencedObjects(Library lib, boolean needVars) {
        this.objInfo = new HashMap();
        this.nameSpace = needVars ? new TreeMap(TextUtils.STRING_NUMBER_ORDER) : null;
        Iterator cIt = lib.getCells();
        while (cIt.hasNext()) {
            Cell cell = (Cell)cIt.next();
            this.gatherCell(cell);
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeProto np;
                NodeInst ni = (NodeInst)it.next();
                if (ni.getName() == null) {
                    System.out.println("ERROR: " + cell + " has " + ni + " with no name");
                }
                if ((np = ni.getProto()) instanceof Cell) {
                    this.gatherCell((Cell)np);
                } else {
                    this.gatherObj(np);
                    this.gatherObj(((PrimitiveNode)np).getTechnology());
                }
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    this.gatherVariables(pi);
                }
                this.gatherVariables(ni);
                if (!needVars) continue;
                this.gatherFont(ni.getTextDescriptor(NodeInst.NODE_NAME_TD));
                this.gatherFont(ni.getTextDescriptor(NodeInst.NODE_PROTO_TD));
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ArcProto ap = ai.getProto();
                this.gatherObj(ap);
                this.gatherObj(ap.getTechnology());
                this.gatherVariables(ai);
                if (!needVars) continue;
                this.gatherFont(ai.getTextDescriptor(ArcInst.ARC_NAME_TD));
            }
            it = cell.getPorts();
            while (it.hasNext()) {
                Export e = (Export)it.next();
                this.gatherVariables(e);
                if (!needVars) continue;
                this.gatherFont(e.getTextDescriptor(Export.EXPORT_NAME_TD));
            }
            this.gatherVariables(cell);
        }
        this.gatherVariables(lib);
        Iterator it = Tool.getTools();
        while (it.hasNext()) {
            this.gatherMeaningPrefs(it.next());
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            this.gatherMeaningPrefs(it.next());
        }
        if (needVars) {
            this.putNameSpace(Library.FONT_ASSOCIATIONS.getName());
            this.putNameSpace(NodeInst.NODE_NAME.getName());
            this.putNameSpace(ArcInst.ARC_NAME.getName());
            short varIndex = 0;
            Iterator it2 = this.nameSpace.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry e = it2.next();
                short s = varIndex;
                varIndex = (short)(varIndex + 1);
                e.setValue(new Short(s));
            }
        }
    }

    private void gatherVariables(ElectricObject eObj) {
        Iterator it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (this.nameSpace != null) {
                this.putNameSpace(this.diskName(var));
            }
            this.gatherFont(var.getTextDescriptor());
            Object value = var.getObject();
            if (value == null) continue;
            int length = value instanceof Object[] ? ((Object[])value).length : 1;
            for (int i = 0; i < length; ++i) {
                Object v;
                Object object = v = value instanceof Object[] ? ((Object[])value)[i] : value;
                if (v == null) continue;
                if (v instanceof Technology || v instanceof Tool) {
                    this.gatherObj(v);
                    continue;
                }
                if (v instanceof PrimitiveNode) {
                    this.gatherObj(v);
                    this.gatherObj(((PrimitiveNode)v).getTechnology());
                    continue;
                }
                if (v instanceof PrimitivePort) {
                    PrimitiveNode pn = (PrimitiveNode)((PrimitivePort)v).getParent();
                    this.gatherObj(pn);
                    this.gatherObj(pn.getTechnology());
                    continue;
                }
                if (v instanceof ArcProto) {
                    this.gatherObj(v);
                    this.gatherObj(((ArcProto)v).getTechnology());
                    continue;
                }
                if (!(v instanceof ElectricObject)) continue;
                this.gatherObj(v);
                Cell cell = ((ElectricObject)v).whichCell();
                if (cell == null) continue;
                this.gatherCell(cell);
            }
        }
    }

    private void gatherMeaningPrefs(Object obj) {
        Iterator it = Pref.getMeaningVariables(obj).iterator();
        while (it.hasNext()) {
            this.gatherObj(obj);
            Pref pref = (Pref)it.next();
            String name = pref.getPrefName();
            if (this.nameSpace == null) continue;
            this.putNameSpace(name);
        }
    }

    private void gatherCell(Cell cell) {
        this.gatherObj(cell);
        this.gatherObj(cell.getLibrary());
        this.gatherObj(cell.getView());
    }

    private void gatherFont(TextDescriptor td) {
        int face = td.getFace();
        if (face != 0) {
            this.gatherObj(TextDescriptor.ActiveFont.findActiveFont(face));
        }
    }

    private void gatherObj(Object obj) {
        this.objInfo.put(obj, null);
    }

    void putObjIndex(Object obj, int index) {
        this.objInfo.put(obj, new Integer(index));
    }

    void putNameSpace(String name) {
        this.nameSpace.put(name, null);
    }

    String diskName(Variable var) {
        if (!(var.getOwner() instanceof PortInst)) {
            return var.getKey().getName();
        }
        PortInst pi = (PortInst)var.getOwner();
        String portName = pi.getPortProto().getName();
        StringBuffer sb = new StringBuffer("ATTRP_");
        for (int i = 0; i < portName.length(); ++i) {
            char ch = portName.charAt(i);
            if (ch == '\\' || ch == '_') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append('_');
        sb.append(var.getKey().getName());
        return sb.toString();
    }

    String[] createFontAssociation() {
        int maxIndices = TextDescriptor.ActiveFont.getMaxIndex();
        this.faceMap = new int[maxIndices + 1];
        TreeMap<String, TextDescriptor.ActiveFont> sortedFonts = new TreeMap<String, TextDescriptor.ActiveFont>();
        for (int i = 1; i <= maxIndices; ++i) {
            TextDescriptor.ActiveFont af = TextDescriptor.ActiveFont.findActiveFont(i);
            if (!this.objInfo.containsKey(af)) continue;
            sortedFonts.put(af.getName(), af);
        }
        if (sortedFonts.size() == 0) {
            return null;
        }
        String[] fontAssociation = new String[sortedFonts.size()];
        int face = 0;
        Iterator it = sortedFonts.values().iterator();
        while (it.hasNext()) {
            TextDescriptor.ActiveFont af = (TextDescriptor.ActiveFont)it.next();
            this.faceMap[af.getIndex()] = ++face;
            fontAssociation[face - 1] = face + "/" + af.getName();
        }
        return fontAssociation;
    }

    protected boolean openBinaryOutputStream(String filePath) {
        FileOutputStream fileOutputStream;
        this.filePath = filePath;
        try {
            fileOutputStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not write file " + filePath);
            System.out.println("Reason: " + e.getMessage());
            return true;
        }
        BufferedOutputStream bufStrm = new BufferedOutputStream(fileOutputStream);
        this.dataOutputStream = new DataOutputStream(bufStrm);
        return false;
    }

    protected boolean closeBinaryOutputStream() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing " + this.filePath);
            return true;
        }
        return false;
    }

    protected boolean openTextOutputStream(String filePath) {
        this.filePath = filePath;
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath);
            return true;
        }
        return false;
    }

    protected boolean closeTextOutputStream() {
        this.printWriter.close();
        return false;
    }

    protected void emitCopyright(String prefix, String postfix) {
        if (!IOTool.isUseCopyrightMessage()) {
            return;
        }
        String str = IOTool.getCopyrightMessage();
        int start = 0;
        while (start < str.length()) {
            int endPos = str.indexOf(10, start);
            if (endPos < 0) {
                endPos = str.length();
            }
            String oneLine = str.substring(start, endPos);
            this.printWriter.println(prefix + oneLine + postfix);
            start = endPos + 1;
        }
    }

    protected void setOutputWidth(int width, boolean strict) {
        this.maxWidth = width;
        this.strictWidthLimit = strict;
    }

    protected void setCommentChar(char ch) {
        this.commentChar = ch;
    }

    protected void setContinuationString(String str) {
        this.continuationString = str;
    }

    private void writeChunk(String str) {
        int len = str.length();
        if (len <= 0) {
            return;
        }
        this.printWriter.print(str);
        this.lineCharCount += len;
        if (str.charAt(len - 1) == '\n') {
            this.lineCharCount = 0;
        }
    }

    protected void writeWidthLimited(String str) {
        int len;
        while ((len = str.length()) > 0) {
            int i = str.indexOf(10);
            i = i < 0 ? len : ++i;
            if (this.lineCharCount + i < this.maxWidth) {
                String chunk = str;
                if (i < len) {
                    chunk = str.substring(0, i);
                }
                this.writeChunk(chunk);
                if ((str = str.substring(i)).length() != 0) continue;
                break;
            }
            int left = this.maxWidth - this.lineCharCount;
            String exact = str.substring(0, left);
            int splitPos = exact.lastIndexOf(32);
            if (splitPos < 0 && (splitPos = exact.lastIndexOf(44)) < 0 && (splitPos = exact.lastIndexOf(40)) < 0) {
                splitPos = exact.lastIndexOf(41);
            }
            if (splitPos > 0) {
                exact = exact.substring(0, splitPos + 1);
            } else if (!this.strictWidthLimit) {
                splitPos = str.indexOf(32, left);
                if (splitPos < 0 && (splitPos = str.indexOf(44, left)) < 0 && (splitPos = str.indexOf(40, left)) < 0) {
                    splitPos = str.indexOf(41, left);
                }
                if (splitPos > 0) {
                    exact = str.substring(0, splitPos + 1);
                }
            }
            this.writeChunk(exact);
            this.writeChunk("\n");
            if (this.continuationString.length() > 0) {
                this.writeChunk(this.continuationString);
            }
            str = str.substring(exact.length());
        }
    }

    public Rectangle2D getAreaToPrint(Cell cell, boolean reduce, EditWindow wnd) {
        Rectangle2D bounds = cell.getBounds();
        if (wnd != null) {
            bounds = wnd.getBoundsInWindow();
        }
        if (reduce) {
            double wid = bounds.getWidth() * 0.75;
            double hei = bounds.getHeight() * 0.75;
            bounds.setRect(bounds.getCenterX(), bounds.getCenterY(), wid, hei);
        }
        if (IOTool.getPlotArea() != 0) {
            if (wnd == null) {
                System.out.println("No current window: printing entire cell");
            } else if (IOTool.getPlotArea() == 2) {
                bounds = wnd.getDisplayedBounds();
            } else {
                Rectangle2D hBounds = wnd.getHighlighter().getHighlightedArea(wnd);
                if (hBounds == null || hBounds.getWidth() == 0.0 || hBounds.getHeight() == 0.0) {
                    System.out.println("Warning: no highlighted area; printing entire cell");
                } else {
                    bounds = hBounds;
                }
            }
        }
        return bounds;
    }

    protected static class OutputCellInfo
    extends Job {
        Cell cell;
        VarContext context;
        String filePath;
        FileType type;

        public OutputCellInfo(Cell cell, VarContext context, String filePath, FileType type, boolean startJob) {
            super("Export " + cell + " (" + type + ")", IOTool.getIOTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.context = context;
            this.filePath = filePath;
            this.type = type;
            if (startJob) {
                this.startJob();
            }
        }

        public boolean doIt() {
            Output.writeCell(this);
            return true;
        }
    }

    static class OrderedExports
    implements Comparator {
        OrderedExports() {
        }

        public int compare(Object o1, Object o2) {
            int i2;
            Export e1 = (Export)o1;
            Export e2 = (Export)o2;
            int i1 = e1.getOriginalPort().getPortProto().getPortIndex();
            int cmp = i1 - (i2 = e2.getOriginalPort().getPortProto().getPortIndex());
            if (cmp != 0) {
                return cmp;
            }
            return e1.getPortIndex() - e2.getPortIndex();
        }
    }

    static class OrderedConnections
    implements Comparator {
        OrderedConnections() {
        }

        public int compare(Object o1, Object o2) {
            int i2;
            Connection c1 = (Connection)o1;
            Connection c2 = (Connection)o2;
            int i1 = c1.getPortInst().getPortProto().getPortIndex();
            int cmp = i1 - (i2 = c2.getPortInst().getPortProto().getPortIndex());
            if (cmp != 0) {
                return cmp;
            }
            cmp = c1.getArc().getArcIndex() - c2.getArc().getArcIndex();
            if (cmp != 0) {
                return cmp;
            }
            return c1.getEndIndex() - c2.getEndIndex();
        }
    }
}

