/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.netlist.Mos;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SerialParallelMerge {
    private NccGlobals globals;

    private SerialParallelMerge(NccGlobals globals) {
        this.globals = globals;
    }

    private boolean serialMerge() {
        int numMerged = 0;
        EquivRecord wires = this.globals.getWires();
        if (wires != null) {
            Iterator it = wires.getCircuits();
            while (it.hasNext()) {
                Circuit ckt = (Circuit)it.next();
                Iterator ni = ckt.getNetObjs();
                while (ni.hasNext()) {
                    Wire w = (Wire)ni.next();
                    if (!Mos.joinOnWire(w)) continue;
                    ++numMerged;
                }
            }
        }
        this.globals.status2("    Serial merged " + numMerged + " Transistors");
        return numMerged > 0;
    }

    private int parallelMergeAllCandidatesInSet(Collection parts) {
        Iterator it;
        int numMerged = 0;
        LinkedList pts = new LinkedList(parts);
        while ((it = pts.iterator()).hasNext()) {
            Part first = (Part)it.next();
            it.remove();
            while (it.hasNext()) {
                Part p = (Part)it.next();
                if (!first.parallelMerge(p)) continue;
                it.remove();
                ++numMerged;
            }
        }
        return numMerged;
    }

    private int parallelMergeEachSetInMap(Map map) {
        int numMerged = 0;
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Set j = (Set)map.get(it.next());
            numMerged += this.parallelMergeAllCandidatesInSet(j);
        }
        return numMerged;
    }

    private int parallelMergePartsOnWire(Wire w) {
        if (w.isDeleted()) {
            return 0;
        }
        HashMap<Integer, HashSet<Part>> map = new HashMap<Integer, HashSet<Part>>();
        Iterator it = w.getParts();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            if (p.isDeleted()) continue;
            Integer code = p.hashCodeForParallelMerge();
            HashSet<Part> set = (HashSet<Part>)map.get(code);
            if (set == null) {
                set = new HashSet<Part>();
                map.put(code, set);
            }
            set.add(p);
        }
        return this.parallelMergeEachSetInMap(map);
    }

    private boolean parallelMerge() {
        int numMerged = 0;
        EquivRecord er = this.globals.getWires();
        if (er != null) {
            Iterator it = er.getCircuits();
            while (it.hasNext()) {
                Circuit ckt = (Circuit)it.next();
                Iterator ni = ckt.getNetObjs();
                while (ni.hasNext()) {
                    Wire w = (Wire)ni.next();
                    numMerged += this.parallelMergePartsOnWire(w);
                }
            }
        }
        this.globals.status2("    Parallel merged " + numMerged + " Parts");
        return numMerged > 0;
    }

    private int countUndeletedParts(EquivRecord parts) {
        int numParts = 0;
        Iterator it = parts.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = (Circuit)it.next();
            numParts += ckt.numUndeletedNetObjs();
        }
        return numParts;
    }

    private void serialParallelMerge() {
        EquivRecord parts = this.globals.getParts();
        if (parts == null) {
            return;
        }
        int numParts = this.countUndeletedParts(parts);
        this.globals.status2("--- NCC starting merge process with " + numParts + " Parts");
        boolean first = true;
        int tripNumber = 1;
        while (true) {
            this.globals.status2("  parallel and series merge trip " + tripNumber);
            boolean progress = this.parallelMerge();
            if (!first && !progress) break;
            first = false;
            progress = this.serialMerge();
            if (!progress) break;
            ++tripNumber;
        }
        numParts = this.countUndeletedParts(parts);
        this.globals.status2("--- NCC finishing merge process with " + numParts + " Parts");
        this.globals.status2("");
    }

    private static void putInFinalForm(EquivRecord er) {
        if (er == null) {
            return;
        }
        Iterator it = er.getCircuits();
        while (it.hasNext()) {
            ((Circuit)it.next()).putInFinalForm();
        }
    }

    public static void doYourJob(NccGlobals globals) {
        SerialParallelMerge sp = new SerialParallelMerge(globals);
        sp.serialParallelMerge();
        SerialParallelMerge.putInFinalForm(globals.getParts());
        SerialParallelMerge.putInFinalForm(globals.getWires());
    }
}

