/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyNodeMerge;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.SizeOffset;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class PolyBase
implements Shape,
PolyNodeMerge {
    private Poly.Type style;
    protected Point2D[] points;
    private Layer layer;
    protected Rectangle2D bounds;
    private PortProto pp;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private static Comparator AREA_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            PolyBase p1 = (PolyBase)o1;
            PolyBase p2 = (PolyBase)o2;
            double diff = p1.getArea() - p2.getArea();
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }
    };

    public PolyBase(Point2D[] points) {
        this.initialize(points);
    }

    public PolyBase(double cX, double cY, double width, double height) {
        double halfWidth = width / 2.0;
        double halfHeight = height / 2.0;
        this.initialize(PolyBase.makePoints(cX - halfWidth, cX + halfWidth, cY - halfHeight, cY + halfHeight));
    }

    public PolyBase(Rectangle2D rect) {
        this.initialize(PolyBase.makePoints(rect));
    }

    public static Point2D[] makePoints(double lX, double hX, double lY, double hY) {
        Point2D[] points = new Point2D.Double[]{new Point2D.Double(lX, lY), new Point2D.Double(hX, lY), new Point2D.Double(hX, hY), new Point2D.Double(lX, hY)};
        return points;
    }

    public static Point2D[] makePoints(Rectangle2D rect) {
        double lX = rect.getMinX();
        double hX = rect.getMaxX();
        double lY = rect.getMinY();
        double hY = rect.getMaxY();
        Point2D[] points = new Point2D.Double[]{new Point2D.Double(lX, lY), new Point2D.Double(hX, lY), new Point2D.Double(hX, hY), new Point2D.Double(lX, hY)};
        return points;
    }

    private void initialize(Point2D[] points) {
        this.style = Poly.Type.CLOSED;
        this.points = points;
        this.layer = null;
        this.bounds = null;
        this.pp = null;
    }

    public Poly.Type getStyle() {
        return this.style;
    }

    public void setStyle(Poly.Type style) {
        this.style = style;
    }

    public Point2D[] getPoints() {
        return this.points;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public PortProto getPort() {
        return this.pp;
    }

    public void setPort(PortProto pp) {
        this.pp = pp;
    }

    public void transform(AffineTransform af) {
        double det;
        if (af.getType() == 0) {
            return;
        }
        if ((this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) && (det = af.getDeterminant()) < 0.0) {
            for (int i = 0; i < this.points.length; i += 3) {
                double x = this.points[i + 1].getX();
                double y = this.points[i + 1].getY();
                this.points[i + 1].setLocation(this.points[i + 2].getX(), this.points[i + 2].getY());
                this.points[i + 2].setLocation(x, y);
            }
        }
        af.transform(this.points, 0, this.points, 0, this.points.length);
        this.bounds = null;
    }

    public Rectangle2D getBox() {
        if (this.points.length == 4) {
            if (this.style != Poly.Type.FILLED && this.style != Poly.Type.CLOSED && this.style != Poly.Type.TEXTBOX && this.style != Poly.Type.CROSSED) {
                return null;
            }
        } else if (this.points.length == 5) {
            if (this.style != Poly.Type.FILLED && this.style != Poly.Type.CLOSED && this.style != Poly.Type.OPENED && this.style != Poly.Type.OPENEDT1 && this.style != Poly.Type.OPENEDT2 && this.style != Poly.Type.OPENEDT3) {
                return null;
            }
            if (this.points[0].getX() != this.points[4].getX() || this.points[0].getY() != this.points[4].getY()) {
                return null;
            }
        } else {
            return null;
        }
        if (this.points[0].getX() == this.points[1].getX() && this.points[2].getX() == this.points[3].getX() && this.points[0].getY() == this.points[3].getY() && this.points[1].getY() == this.points[2].getY()) {
            return this.getBounds2D();
        }
        if (this.points[0].getX() == this.points[3].getX() && this.points[1].getX() == this.points[2].getX() && this.points[0].getY() == this.points[1].getY() && this.points[2].getY() == this.points[3].getY()) {
            return this.getBounds2D();
        }
        return null;
    }

    public double getMinSize() {
        Rectangle2D box = this.getBox();
        if (box == null) {
            return 0.0;
        }
        return Math.min(box.getWidth(), box.getHeight());
    }

    public double getMaxSize() {
        Rectangle2D box = this.getBox();
        if (box == null) {
            return 0.0;
        }
        return Math.max(box.getWidth(), box.getHeight());
    }

    public boolean polySame(PolyBase polyOther) {
        Point2D[] pointsO;
        Point2D[] points = this.getPoints();
        if (points.length != (pointsO = polyOther.getPoints()).length) {
            return false;
        }
        Rectangle2D box = this.getBox();
        Rectangle2D boxO = polyOther.getBox();
        if (box != null && boxO != null) {
            return box.equals(boxO);
        }
        if (box != null || boxO != null) {
            return false;
        }
        for (int i = 0; i < points.length; ++i) {
            if (points[i].equals(pointsO[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isInside(Point2D pt) {
        if (this.style == Poly.Type.FILLED || this.style == Poly.Type.CLOSED || this.style == Poly.Type.CROSSED || this.style.isText()) {
            Rectangle2D bounds = this.getBox();
            if (bounds != null) {
                if (DBMath.pointInRect(pt, bounds)) {
                    return true;
                }
                return bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0 && DBMath.areEquals(pt.getX(), bounds.getX()) && DBMath.areEquals(pt.getY(), bounds.getY());
            }
            double ang = 0.0;
            double angd = 0.0;
            Point2D lastPoint = this.points[this.points.length - 1];
            if (DBMath.areEquals(pt, lastPoint)) {
                return true;
            }
            int lastp = DBMath.figureAngle(pt, lastPoint);
            for (int i = 0; i < this.points.length; ++i) {
                Point2D thisPoint = this.points[i];
                if (DBMath.areEquals(pt, thisPoint)) {
                    return true;
                }
                if (DBMath.isOnLine(thisPoint, lastPoint, pt)) {
                    return true;
                }
                int thisp = DBMath.figureAngle(pt, thisPoint);
                int tang = lastp - thisp;
                if (tang < -1800) {
                    tang += 3600;
                }
                if (tang > 1800) {
                    tang -= 3600;
                }
                ang += (double)tang;
                lastp = thisp;
                lastPoint = thisPoint;
            }
            boolean oldCalculation = !((ang = Math.abs(ang)) <= (double)this.points.length);
            return oldCalculation;
        }
        if (this.style == Poly.Type.CROSS || this.style == Poly.Type.BIGCROSS) {
            return DBMath.areEquals(this.getCenterX(), pt.getX()) && DBMath.areEquals(this.getCenterY(), pt.getY());
        }
        if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3 || this.style == Poly.Type.VECTORS) {
            int i;
            for (i = 0; i < this.points.length; ++i) {
                if (!DBMath.areEquals(pt, this.points[i])) continue;
                return true;
            }
            if (this.style == Poly.Type.VECTORS) {
                for (i = 0; i < this.points.length; i += 2) {
                    if (!DBMath.isOnLine(this.points[i], this.points[i + 1], pt)) continue;
                    return true;
                }
            } else {
                for (i = 1; i < this.points.length; ++i) {
                    if (!DBMath.isOnLine(this.points[i - 1], this.points[i], pt)) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.style == Poly.Type.CIRCLE || this.style == Poly.Type.THICKCIRCLE || this.style == Poly.Type.DISC) {
            double dist = this.points[0].distance(this.points[1]);
            double odist = this.points[0].distance(pt);
            return odist < dist;
        }
        if (this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) {
            double wantdist;
            double angrange;
            int startangle;
            int ang = DBMath.figureAngle(this.points[0], pt);
            int endangle = DBMath.figureAngle(this.points[0], this.points[1]);
            if (endangle > (startangle = DBMath.figureAngle(this.points[0], this.points[2]))) {
                if (ang < startangle || ang > endangle) {
                    return false;
                }
                angrange = endangle - startangle;
            } else {
                if (ang < startangle && ang > endangle) {
                    return false;
                }
                angrange = 3600 - startangle + endangle;
            }
            double dist = this.points[0].distance(pt);
            if (ang == startangle || angrange == 0.0) {
                wantdist = this.points[0].distance(this.points[1]);
            } else if (ang == endangle) {
                wantdist = this.points[0].distance(this.points[2]);
            } else {
                double startdist = this.points[0].distance(this.points[1]);
                double enddist = this.points[0].distance(this.points[2]);
                wantdist = enddist == startdist ? startdist : startdist + (double)(ang - startangle) / angrange * (enddist - startdist);
            }
            return DBMath.areEquals(dist, wantdist);
        }
        return false;
    }

    public boolean isInside(Rectangle2D bounds) {
        if (this.style == Poly.Type.CIRCLE || this.style == Poly.Type.THICKCIRCLE || this.style == Poly.Type.DISC) {
            Point2D ctr = this.points[0];
            double dx = Math.abs(ctr.getX() - this.points[1].getX());
            double dy = Math.abs(ctr.getY() - this.points[1].getY());
            double rad = Math.max(dx, dy);
            if (!DBMath.pointInRect(new Point2D.Double(ctr.getX() + rad, ctr.getY() + rad), bounds)) {
                return false;
            }
            return DBMath.pointInRect(new Point2D.Double(ctr.getX() - rad, ctr.getY() - rad), bounds);
        }
        for (int i = 0; i < this.points.length; ++i) {
            if (DBMath.pointInRect(this.points[i], bounds)) continue;
            return false;
        }
        return true;
    }

    public boolean isPointOnCorner(Point2D point) {
        for (int i = 0; i < this.points.length; ++i) {
            if (!DBMath.areEquals(point, this.points[i])) continue;
            return true;
        }
        return false;
    }

    public void reducePortPoly(PortInst pi, double wid, int angle) {
        double swap;
        PortOriginal fp = new PortOriginal(pi);
        AffineTransform trans = fp.getTransformToTop();
        NodeInst ni = fp.getBottomNodeInst();
        if (this.getStyle() != Poly.Type.FILLED && this.getStyle() != Poly.Type.CROSSED && this.getStyle() != Poly.Type.DISC) {
            return;
        }
        if (ni.getTrace() != null) {
            return;
        }
        double realWid = wid / 2.0;
        Rectangle2D portBounds = this.getBox();
        if (portBounds == null) {
            if (this.getStyle() == Poly.Type.DISC) {
                double dist = this.points[0].distance(this.points[1]);
                dist = Math.max(0.0, dist - realWid);
                this.points[1].setLocation(this.points[0].getX() + dist, this.points[0].getY());
                return;
            }
            return;
        }
        double bx = portBounds.getMinX();
        double ux = portBounds.getMaxX();
        double by = portBounds.getMinY();
        double uy = portBounds.getMaxY();
        double cx = portBounds.getCenterX();
        double cy = portBounds.getCenterY();
        SizeOffset so = ni.getSizeOffset();
        Rectangle2D nodeBounds = ni.getBounds();
        Point2D.Double lowerLeft = new Point2D.Double(nodeBounds.getMinX() + so.getLowXOffset(), nodeBounds.getMinY() + so.getLowYOffset());
        trans.transform(lowerLeft, lowerLeft);
        Point2D.Double upperRight = new Point2D.Double(nodeBounds.getMaxX() - so.getHighXOffset(), nodeBounds.getMaxY() - so.getHighYOffset());
        trans.transform(upperRight, upperRight);
        double lx = ((Point2D)lowerLeft).getX();
        double hx = ((Point2D)upperRight).getX();
        double ly = ((Point2D)lowerLeft).getY();
        double hy = ((Point2D)upperRight).getY();
        if (lx > hx) {
            swap = lx;
            lx = hx;
            hx = swap;
        }
        if (ly > hy) {
            swap = ly;
            ly = hy;
            hy = swap;
        }
        if (angle != 0 && angle != 1800) {
            lx = Math.max(bx, lx + realWid);
            if ((hx = Math.min(ux, hx - realWid)) < lx) {
                hx = lx = (hx + lx) / 2.0;
            }
            if (ux >= lx && bx <= hx) {
                for (int j = 0; j < this.points.length; ++j) {
                    double x = this.points[j].getX();
                    if (x < lx) {
                        x = lx;
                    }
                    if (x > hx) {
                        x = hx;
                    }
                    this.points[j].setLocation(x, this.points[j].getY());
                }
            }
        }
        if (angle != 900 && angle != 2700) {
            ly = Math.max(by, ly + realWid);
            if ((hy = Math.min(uy, hy - realWid)) < ly) {
                hy = ly = (hy + ly) / 2.0;
            }
            if (uy >= ly && by <= hy) {
                for (int j = 0; j < this.points.length; ++j) {
                    double y = this.points[j].getY();
                    if (y < ly) {
                        y = ly;
                    }
                    if (y > hy) {
                        y = hy;
                    }
                    this.points[j].setLocation(this.points[j].getX(), y);
                }
            }
        }
    }

    public static Poly.Type rotateType(Poly.Type origType, ElectricObject eObj) {
        if (origType == Poly.Type.TEXTCENT || origType == Poly.Type.TEXTBOX) {
            return origType;
        }
        NodeInst ni = null;
        if (eObj instanceof NodeInst) {
            ni = (NodeInst)eObj;
        } else if (eObj instanceof Export) {
            Export pp = (Export)eObj;
            ni = pp.getOriginalPort().getNodeInst();
        } else {
            return origType;
        }
        int nodeAngle = ni.getAngle();
        if (nodeAngle == 0 && !ni.isMirroredAboutXAxis() && !ni.isMirroredAboutYAxis()) {
            return origType;
        }
        if (nodeAngle % 900 != 0) {
            return origType;
        }
        int origAngle = origType.getTextAngle();
        if (ni.isMirroredAboutXAxis() != ni.isMirroredAboutYAxis() && (origAngle % 1800 == 0 || origAngle % 1800 == 1350)) {
            origAngle += 1800;
        }
        Orientation orient = Orientation.fromJava(nodeAngle, ni.isMirroredAboutXAxis(), ni.isMirroredAboutYAxis());
        AffineTransform trans = orient.pureRotate();
        Point2D.Double pt = new Point2D.Double(100.0, 0.0);
        trans.transform(pt, pt);
        int xAngle = GenMath.figureAngle(new Point2D.Double(0.0, 0.0), pt);
        if (ni.isMirroredAboutXAxis() != ni.isMirroredAboutYAxis() && origAngle % 1800 == 450) {
            xAngle += 900;
        }
        int angle = (origAngle + xAngle) % 3600;
        Poly.Type style = Poly.Type.getTextTypeFromAngle(angle);
        return style;
    }

    public static Poly.Type unRotateType(Poly.Type origType, ElectricObject eObj) {
        if (origType == Poly.Type.TEXTCENT || origType == Poly.Type.TEXTBOX) {
            return origType;
        }
        NodeInst ni = null;
        if (eObj instanceof NodeInst) {
            ni = (NodeInst)eObj;
        } else if (eObj instanceof Export) {
            Export pp = (Export)eObj;
            ni = pp.getOriginalPort().getNodeInst();
        } else {
            return origType;
        }
        int nodeAngle = ni.getAngle();
        if (nodeAngle == 0 && !ni.isMirroredAboutXAxis() && !ni.isMirroredAboutYAxis()) {
            return origType;
        }
        if (nodeAngle % 900 != 0) {
            return origType;
        }
        int angle = origType.getTextAngle();
        int rotAngle = ni.getAngle();
        if (ni.isMirroredAboutXAxis() != ni.isMirroredAboutYAxis()) {
            rotAngle = -rotAngle;
        }
        Orientation orient = Orientation.fromJava(rotAngle, ni.isMirroredAboutXAxis(), ni.isMirroredAboutYAxis());
        AffineTransform trans = orient.pureRotate();
        Point2D.Double pt = new Point2D.Double(100.0, 0.0);
        trans.transform(pt, pt);
        int xAngle = GenMath.figureAngle(new Point2D.Double(0.0, 0.0), pt);
        if (ni.isMirroredAboutXAxis() != ni.isMirroredAboutYAxis() && (angle % 1800 == 0 || angle % 1800 == 1350)) {
            angle += 1800;
        }
        angle = (angle - xAngle + 3600) % 3600;
        Poly.Type style = Poly.Type.getTextTypeFromAngle(angle);
        return style;
    }

    protected double getTextScale(EditWindow_ wnd, GlyphVector gv, Poly.Type style, double lX, double hX, double lY, double hY) {
        Rectangle2D glyphBounds;
        double textWidth;
        double textScale = 1.0 / wnd.getScale();
        if (style == Poly.Type.TEXTBOX && (textWidth = (glyphBounds = gv.getVisualBounds()).getWidth() * textScale) > hX - lX) {
            textScale *= (hX - lX) / textWidth;
        }
        return textScale;
    }

    public double polyDistance(double x, double y) {
        return this.polyDistance(new Rectangle2D.Double(x, y, 0.0, 0.0));
    }

    public double polyDistance(Rectangle2D otherBounds) {
        Rectangle2D polyBounds = this.getBounds2D();
        double polyCX = polyBounds.getCenterX();
        double polyCY = polyBounds.getCenterY();
        Point2D.Double polyCenter = new Point2D.Double(polyCX, polyCY);
        Poly.Type localStyle = this.style;
        boolean thisIsPoint = polyBounds.getWidth() == 0.0 && polyBounds.getHeight() == 0.0;
        boolean otherIsPoint = otherBounds.getWidth() == 0.0 && otherBounds.getHeight() == 0.0;
        double otherCX = otherBounds.getCenterX();
        double otherCY = otherBounds.getCenterY();
        Point2D.Double otherPt = new Point2D.Double(otherCX, otherCY);
        if (thisIsPoint) {
            if (otherIsPoint ? polyCX == otherCX && polyCY == otherCY : otherBounds.contains(polyCenter)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Poly.Type.FILLED || localStyle == Poly.Type.CROSSED || localStyle.isText()) {
            if (otherIsPoint) {
                if (this.isInside(otherPt)) {
                    return otherPt.distance(polyCenter) - Double.MAX_VALUE;
                }
                Rectangle2D box = this.getBox();
                if (box != null) {
                    polyCX = otherCX > box.getMaxX() ? otherCX - box.getMaxX() : (otherCX < box.getMinX() ? box.getMinX() - otherCX : 0.0);
                    polyCY = otherCY > box.getMaxY() ? otherCY - box.getMaxY() : (otherCY < box.getMinY() ? box.getMinY() - otherCY : 0.0);
                    if (polyCX == 0.0 || polyCY == 0.0) {
                        return polyCX + polyCY;
                    }
                    ((Point2D)polyCenter).setLocation(polyCX, polyCY);
                    return polyCenter.distance(new Point2D.Double(0.0, 0.0));
                }
                localStyle = Poly.Type.CLOSED;
            } else {
                if (otherBounds.intersects(polyBounds)) {
                    return Double.MIN_VALUE;
                }
                return otherPt.distance(polyCenter);
            }
        }
        if (localStyle == Poly.Type.CLOSED) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                Point2D lastPt = this.points[this.points.length - 1];
                for (int i = 0; i < this.points.length; ++i) {
                    Point2D thisPt;
                    double dist;
                    if (i != 0) {
                        lastPt = this.points[i - 1];
                    }
                    if (!((dist = DBMath.distToLine(lastPt, thisPt = this.points[i], otherPt)) < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (otherBounds.intersects(polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Poly.Type.OPENED || localStyle == Poly.Type.OPENEDT1 || localStyle == Poly.Type.OPENEDT2 || localStyle == Poly.Type.OPENEDT3) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                for (int i = 1; i < this.points.length; ++i) {
                    Point2D lastPt = this.points[i - 1];
                    Point2D thisPt = this.points[i];
                    double dist = DBMath.distToLine(lastPt, thisPt, otherPt);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (GenMath.rectsIntersect(otherBounds, polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Poly.Type.VECTORS) {
            if (otherIsPoint) {
                double bestDist = Double.MAX_VALUE;
                for (int i = 0; i < this.points.length; i += 2) {
                    Point2D lastPt = this.points[i];
                    Point2D thisPt = this.points[i + 1];
                    double dist = DBMath.distToLine(lastPt, thisPt, otherPt);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                return bestDist;
            }
            if (GenMath.rectsIntersect(otherBounds, polyBounds)) {
                return Double.MIN_VALUE;
            }
            return otherPt.distance(polyCenter);
        }
        if (localStyle == Poly.Type.CIRCLE || localStyle == Poly.Type.THICKCIRCLE || localStyle == Poly.Type.DISC) {
            double odist = this.points[0].distance(this.points[1]);
            double dist = this.points[0].distance(otherPt);
            if (otherIsPoint) {
                if (localStyle == Poly.Type.DISC && dist < odist) {
                    return dist - Double.MAX_VALUE;
                }
                return Math.abs(dist - odist);
            }
            if (this.points[0].getX() + dist < otherBounds.getMinX()) {
                return dist;
            }
            if (this.points[0].getX() - dist > otherBounds.getMaxX()) {
                return dist;
            }
            if (this.points[0].getY() + dist < otherBounds.getMinY()) {
                return dist;
            }
            if (this.points[0].getY() - dist > otherBounds.getMaxY()) {
                return dist;
            }
            return Double.MIN_VALUE;
        }
        if (localStyle == Poly.Type.CIRCLEARC || localStyle == Poly.Type.THICKCIRCLEARC) {
            if (otherIsPoint) {
                double sdist = otherPt.distance(this.points[1]);
                double edist = otherPt.distance(this.points[2]);
                double dist = Math.min(sdist, edist);
                int pang = DBMath.figureAngle(this.points[0], otherPt);
                int sang = DBMath.figureAngle(this.points[0], this.points[1]);
                int eang = DBMath.figureAngle(this.points[0], this.points[2]);
                if (eang > sang ? pang < eang && pang > sang : pang < eang || pang > sang) {
                    return dist;
                }
                double odist = this.points[0].distance(this.points[1]);
                dist = this.points[0].distance(otherPt);
                return Math.abs(dist - odist);
            }
            Point2D[] savePoints = this.points;
            this.clipArc(otherBounds.getMinX(), otherBounds.getMaxX(), otherBounds.getMinY(), otherBounds.getMaxY());
            Point2D[] newPoints = this.points;
            this.points = savePoints;
            if (newPoints.length > 0) {
                return Double.MIN_VALUE;
            }
            double dist = this.points[0].distance(this.points[1]);
            return this.points[0].distance(otherPt) - dist;
        }
        return otherPt.distance(polyCenter);
    }

    public double separationBox(PolyBase polyOther) {
        Rectangle2D thisBounds = this.getBox();
        Rectangle2D otherBounds = polyOther.getBox();
        if (thisBounds == null || otherBounds == null) {
            return -1.0;
        }
        int dir = -1;
        double lX1 = thisBounds.getMinX();
        double hX1 = thisBounds.getMaxX();
        double lY1 = thisBounds.getMinY();
        double hY1 = thisBounds.getMaxY();
        double lX2 = otherBounds.getMinX();
        double hX2 = otherBounds.getMaxX();
        double lY2 = otherBounds.getMinY();
        double hY2 = otherBounds.getMaxY();
        double[][] points1 = new double[][]{{thisBounds.getMinX(), thisBounds.getMinY()}, {thisBounds.getMaxX(), thisBounds.getMaxY()}};
        double[][] points2 = new double[][]{{otherBounds.getMinX(), otherBounds.getMinY()}, {otherBounds.getMaxX(), otherBounds.getMaxY()}};
        double pdx = Math.max(lX2 - hX1, lX1 - hX2);
        double pdy = Math.max(lY2 - hY1, lY1 - hY2);
        double pdx1 = Math.max(points2[0][0] - points1[1][0], points1[0][0] - points2[1][0]);
        double pdy1 = Math.max(points2[0][1] - points1[1][1], points1[0][1] - points2[1][1]);
        if (pdx1 != pdx || pdy1 != pdy) {
            System.out.println("Error in separtionBox");
        }
        double pd = pdx > 0.0 && pdy > 0.0 ? Math.sqrt(pdx * pdx + pdy * pdy) : Math.max(pdx, pdy);
        return pd;
    }

    public double separation(PolyBase polyOther) {
        double pd;
        Point2D c;
        int i;
        if (this.intersects(polyOther)) {
            return 0.0;
        }
        double minPD1 = this.separationBox(polyOther);
        double minPD = 0.0;
        for (i = 0; i < this.points.length; ++i) {
            c = polyOther.closestPoint(this.points[i]);
            pd = c.distance(this.points[i]);
            if (pd <= 0.0) {
                return 0.0;
            }
            if (i == 0) {
                minPD = pd;
                continue;
            }
            if (!(pd < minPD)) continue;
            minPD = pd;
        }
        for (i = 0; i < polyOther.points.length; ++i) {
            c = this.closestPoint(polyOther.points[i]);
            pd = c.distance(polyOther.points[i]);
            if (pd <= 0.0) {
                return 0.0;
            }
            if (!(pd < minPD)) continue;
            minPD = pd;
        }
        if (minPD1 != -1.0 && minPD != minPD1) {
            System.out.println("Error in calculation in Poly.separation");
            this.separationBox(polyOther);
        }
        return minPD;
    }

    public Point2D closestPoint(Point2D pt) {
        Rectangle2D bounds;
        Poly.Type localStyle = this.style;
        if (localStyle == Poly.Type.FILLED || localStyle == Poly.Type.CROSSED || localStyle == Poly.Type.TEXTCENT || localStyle.isText()) {
            bounds = this.getBox();
            if (bounds != null) {
                double x = pt.getX();
                double y = pt.getY();
                if (x < bounds.getMinX()) {
                    x = bounds.getMinX();
                }
                if (x > bounds.getMaxX()) {
                    x = bounds.getMaxX();
                }
                if (y < bounds.getMinY()) {
                    y = bounds.getMinY();
                }
                if (y > bounds.getMaxY()) {
                    y = bounds.getMaxY();
                }
                return new Point2D.Double(x, y);
            }
            if (localStyle == Poly.Type.FILLED && this.isInside(pt)) {
                return pt;
            }
            localStyle = Poly.Type.CLOSED;
        }
        if (localStyle == Poly.Type.CLOSED) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 0; i < this.points.length; ++i) {
                int lastI = i == 0 ? this.points.length - 1 : i - 1;
                Point2D pc = DBMath.closestPointToSegment(this.points[lastI], this.points[i], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        if (localStyle == Poly.Type.OPENED || localStyle == Poly.Type.OPENEDT1 || localStyle == Poly.Type.OPENEDT2 || localStyle == Poly.Type.OPENEDT3) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 1; i < this.points.length; ++i) {
                Point2D pc = DBMath.closestPointToSegment(this.points[i - 1], this.points[i], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        if (localStyle == Poly.Type.VECTORS) {
            double bestDist = Double.MAX_VALUE;
            Point2D.Double bestPoint = new Point2D.Double();
            for (int i = 0; i < this.points.length; i += 2) {
                Point2D pc = DBMath.closestPointToSegment(this.points[i], this.points[i + 1], pt);
                double dist = pc.distance(pt);
                if (dist > bestDist) continue;
                bestDist = dist;
                bestPoint.setLocation(pc);
            }
            return bestPoint;
        }
        bounds = this.getBounds2D();
        return new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
    }

    public boolean contains(double x, double y) {
        return this.isInside(new Point2D.Double(x, y));
    }

    public boolean contains(Point2D p) {
        return this.isInside(p);
    }

    public boolean contains(double lX, double lY, double w, double h) {
        double hX = lX + w;
        double hY = lY + h;
        for (int i = 0; i < this.points.length; ++i) {
            int last = i - 1;
            if (last < 0) {
                last = this.points.length - 1;
            }
            Point2D.Double thisPt = new Point2D.Double(this.points[i].getX(), this.points[i].getY());
            Point2D.Double lastPt = new Point2D.Double(this.points[last].getX(), this.points[last].getY());
            boolean invisible = GenMath.clipLine(lastPt, thisPt, lX, hX, lY, hY);
            if (invisible || ((Point2D)lastPt).getX() == ((Point2D)thisPt).getX() && (((Point2D)thisPt).getX() <= lX || ((Point2D)thisPt).getX() >= hX) || ((Point2D)lastPt).getY() == ((Point2D)thisPt).getY() && (((Point2D)thisPt).getY() <= lY || ((Point2D)thisPt).getY() >= hY)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x, double y, double w, double h) {
        throw new Error("intersects method not implemented in Poly.intersects()");
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(PolyBase polyOther) {
        Rectangle2D thisBounds = this.getBounds2D();
        Rectangle2D otherBounds = polyOther.getBounds2D();
        if (thisBounds.getMaxX() < otherBounds.getMinX() || otherBounds.getMaxX() < thisBounds.getMinX() || thisBounds.getMaxY() < otherBounds.getMinY() || otherBounds.getMaxY() < thisBounds.getMinY()) {
            return false;
        }
        int count = this.points.length;
        for (int i = 0; i < count; ++i) {
            Point2D p = null;
            if (i == 0) {
                if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3 || this.style == Poly.Type.VECTORS) continue;
                p = this.points[count - 1];
            } else {
                p = this.points[i - 1];
            }
            Point2D t = this.points[i];
            if (this.style == Poly.Type.VECTORS && (i & 1) != 0) {
                ++i;
            }
            if (p.getX() == t.getX() && p.getY() == t.getY() || Math.min(p.getX(), t.getX()) > otherBounds.getMaxX() || Math.max(p.getX(), t.getX()) < otherBounds.getMinX() || Math.min(p.getY(), t.getY()) > otherBounds.getMaxY() || Math.max(p.getY(), t.getY()) < otherBounds.getMinY() || !polyOther.lineIntersect(p, t)) continue;
            return true;
        }
        return false;
    }

    private boolean lineIntersect(Point2D p1, Point2D t1) {
        int count = this.points.length;
        for (int i = 0; i < count; ++i) {
            int ang;
            Point2D p2 = null;
            if (i == 0) {
                if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3 || this.style == Poly.Type.VECTORS) continue;
                p2 = this.points[count - 1];
            } else {
                p2 = this.points[i - 1];
            }
            Point2D t2 = this.points[i];
            if (this.style == Poly.Type.VECTORS && (i & 1) != 0) {
                ++i;
            }
            if (t2.getX() == p1.getX() && t2.getY() == p1.getY()) {
                return true;
            }
            if (t2.getX() == t1.getX() && t2.getY() == t1.getY()) {
                return true;
            }
            if (p2.getX() == t2.getX() && p2.getY() == t2.getY()) continue;
            if (p2.getX() == t2.getX()) {
                if (Math.min(p1.getX(), t1.getX()) > p2.getX() || Math.max(p1.getX(), t1.getX()) < p2.getX()) continue;
                if (p1.getX() == t1.getX()) {
                    if (Math.min(p1.getY(), t1.getY()) > Math.max(p2.getY(), t2.getY()) || Math.max(p1.getY(), t1.getY()) < Math.min(p2.getY(), t2.getY())) continue;
                    return true;
                }
                if (p1.getY() == t1.getY()) {
                    if (Math.min(p2.getY(), t2.getY()) > p1.getY() || Math.max(p2.getY(), t2.getY()) < p1.getY()) continue;
                    return true;
                }
                ang = DBMath.figureAngle(p1, t1);
                Point2D inter = DBMath.intersect(p2, 900, p1, ang);
                if (inter == null || inter.getX() != p2.getX() || inter.getY() < Math.min(p2.getY(), t2.getY()) || inter.getY() > Math.max(p2.getY(), t2.getY())) continue;
                return true;
            }
            if (p2.getY() == t2.getY()) {
                if (Math.min(p1.getY(), t1.getY()) > p2.getY() || Math.max(p1.getY(), t1.getY()) < p2.getY()) continue;
                if (p1.getY() == t1.getY()) {
                    if (Math.min(p1.getX(), t1.getX()) > Math.max(p2.getX(), t2.getX()) || Math.max(p1.getX(), t1.getX()) < Math.min(p2.getX(), t2.getX())) continue;
                    return true;
                }
                if (p1.getX() == t1.getX()) {
                    if (Math.min(p2.getX(), t2.getX()) > p1.getX() || Math.max(p2.getX(), t2.getX()) < p1.getX()) continue;
                    return true;
                }
                ang = DBMath.figureAngle(p1, t1);
                Point2D inter = DBMath.intersect(p2, 0, p1, ang);
                if (inter == null || inter.getY() != p2.getY() || inter.getX() < Math.min(p2.getX(), t2.getX()) || inter.getX() > Math.max(p2.getX(), t2.getX())) continue;
                return true;
            }
            if (Math.min(p1.getX(), t1.getX()) > Math.max(p2.getX(), t2.getX()) || Math.max(p1.getX(), t1.getX()) < Math.min(p2.getX(), t2.getX()) || Math.min(p1.getY(), t1.getY()) > Math.max(p2.getY(), t2.getY()) || Math.max(p1.getY(), t1.getY()) < Math.min(p2.getY(), t2.getY())) continue;
            int ang1 = DBMath.figureAngle(p1, t1);
            int ang2 = DBMath.figureAngle(p2, t2);
            Point2D inter = DBMath.intersect(p2, ang2, p1, ang1);
            if (inter == null || inter.getX() < Math.min(p2.getX(), t2.getX()) || inter.getX() > Math.max(p2.getX(), t2.getX()) || inter.getY() < Math.min(p2.getY(), t2.getY()) || inter.getY() > Math.max(p2.getY(), t2.getY()) || inter.getX() < Math.min(p1.getX(), t1.getX()) || inter.getX() > Math.max(p1.getX(), t1.getX()) || inter.getY() < Math.min(p1.getY(), t1.getY()) || inter.getY() > Math.max(p1.getY(), t1.getY())) continue;
            return true;
        }
        return false;
    }

    public double getPerimeter() {
        double perim = 0.0;
        int start = 0;
        if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3) {
            start = 1;
        }
        for (int i = start; i < this.points.length; ++i) {
            int j = i - 1;
            if (j < 0) {
                j = this.points.length - 1;
            }
            perim += this.points[i].distance(this.points[j]);
        }
        return perim;
    }

    public double getMaxLength() {
        double max = 0.0;
        int start = 0;
        if (this.style == Poly.Type.OPENED || this.style == Poly.Type.OPENEDT1 || this.style == Poly.Type.OPENEDT2 || this.style == Poly.Type.OPENEDT3) {
            start = 1;
        }
        for (int i = start; i < this.points.length; ++i) {
            double distance;
            int j = i - 1;
            if (j < 0) {
                j = this.points.length - 1;
            }
            if (!(max < (distance = this.points[i].distance(this.points[j])))) continue;
            max = distance;
        }
        return max;
    }

    public double getArea() {
        if (this.style == Poly.Type.FILLED || this.style == Poly.Type.CLOSED || this.style == Poly.Type.CROSSED || this.style.isText()) {
            Rectangle2D bounds = this.getBox();
            if (bounds != null) {
                double area = bounds.getWidth() * bounds.getHeight();
                double sign = 0.0;
                sign = this.points[0].getX() == this.points[1].getX() ? (this.points[2].getX() - this.points[1].getX()) * (this.points[1].getY() - this.points[0].getY()) : (this.points[1].getX() - this.points[0].getX()) * (this.points[1].getY() - this.points[2].getY());
                return Math.abs(area);
            }
            return GenMath.getAreaOfPoints(this.points);
        }
        return 0.0;
    }

    public double getCenterX() {
        Rectangle2D b = this.getBounds2D();
        return b.getCenterX();
    }

    public double getCenterY() {
        Rectangle2D b = this.getBounds2D();
        return b.getCenterY();
    }

    public Rectangle2D getBounds2D() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        return this.bounds;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        Rectangle2D r = this.getBounds2D();
        return new Rectangle((int)r.getMinX(), (int)r.getMinY(), (int)r.getWidth(), (int)r.getHeight());
    }

    private void calcBounds() {
        this.bounds = null;
        if (this.style == Poly.Type.CIRCLE || this.style == Poly.Type.THICKCIRCLE || this.style == Poly.Type.DISC) {
            double cX = this.points[0].getX();
            double cY = this.points[0].getY();
            double radius = this.points[0].distance(this.points[1]);
            double diameter = radius * 2.0;
            this.bounds = new Rectangle2D.Double(cX - radius, cY - radius, diameter, diameter);
            return;
        }
        if (this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) {
            this.bounds = GenMath.arcBBox(this.points[1], this.points[2], this.points[0]);
            return;
        }
        if (this.points.length > 0) {
            double lY;
            double lX;
            double hX = lX = this.points[0].getX();
            double hY = lY = this.points[0].getY();
            for (int i = 1; i < this.points.length; ++i) {
                double x = this.points[i].getX();
                double y = this.points[i].getY();
                if (x < lX) {
                    lX = x;
                }
                if (x > hX) {
                    hX = x;
                }
                if (y < lY) {
                    lY = y;
                }
                if (!(y > hY)) continue;
                hY = y;
            }
            this.bounds = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle2D.Double();
        }
    }

    public void roundPoints() {
        this.bounds = null;
        for (int i = 0; i < this.points.length; ++i) {
            Point2D point = this.points[i];
            point.setLocation(DBMath.round(point.getX()), DBMath.round(point.getY()));
        }
    }

    public List getSortedLoops() {
        List set = PolyBase.getPointsInArea(new Area(this), this.layer, true, false, null);
        ArrayList list = new ArrayList(set);
        Collections.sort(list, AREA_COMPARATOR);
        return list;
    }

    public static List getPointsInArea(Area area, Layer layer, boolean simple, boolean includeLastPoint, List polyList) {
        if (area == null) {
            return null;
        }
        if (polyList == null) {
            polyList = new ArrayList<PolyBase>();
        }
        double[] coords = new double[6];
        ArrayList<Point2D> pointList = new ArrayList<Point2D>();
        Point2D.Double lastMoveTo = null;
        boolean isSingular = area.isSingular();
        ArrayList<PolyBase> toDelete = new ArrayList<PolyBase>();
        PathIterator pIt = area.getPathIterator(null);
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                if (includeLastPoint && lastMoveTo != null) {
                    pointList.add(lastMoveTo);
                }
                Point2D[] points = new Point2D[pointList.size()];
                int i = 0;
                Iterator it = pointList.iterator();
                while (it.hasNext()) {
                    points[i++] = (Point2D)it.next();
                }
                PolyBase poly = new PolyBase(points);
                poly.setLayer(layer);
                poly.setStyle(Poly.Type.FILLED);
                lastMoveTo = null;
                toDelete.clear();
                if (!simple && !isSingular) {
                    Iterator it2 = polyList.iterator();
                    while (it2.hasNext()) {
                        PolyBase pn = (PolyBase)it2.next();
                        if (!pn.contains((Point2D)pointList.get(0)) && !poly.contains(pn.getPoints()[0])) continue;
                        points = pn.getPoints();
                        for (i = 0; i < points.length; ++i) {
                            pointList.add(points[i]);
                        }
                        Point2D[] newPoints = new Point2D[pointList.size()];
                        System.arraycopy(pointList.toArray(), 0, newPoints, 0, pointList.size());
                        poly = new PolyBase(newPoints);
                        toDelete.add(pn);
                    }
                }
                if (poly != null) {
                    polyList.add(poly);
                }
                polyList.removeAll(toDelete);
                pointList.clear();
            } else if (type == 0 || type == 1) {
                Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                pointList.add(pt);
                if (type == 0) {
                    lastMoveTo = pt;
                }
            }
            pIt.next();
        }
        return polyList;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PolyPathIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Poly poly = (Poly)obj;
        if (this.getLayer() != poly.getLayer()) {
            return false;
        }
        boolean geometryCheck = this.polySame(poly);
        return geometryCheck;
    }

    public static int cropBox(Rectangle2D bounds, Rectangle2D PUBox) {
        double yoverlap;
        boolean uhY;
        double bX = PUBox.getMinX();
        double uX = PUBox.getMaxX();
        double bY = PUBox.getMinY();
        double uY = PUBox.getMaxY();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        if (!(DBMath.isGreaterThan(hX, bX) && DBMath.isGreaterThan(hY, bY) && DBMath.isGreaterThan(uX, lX) && DBMath.isGreaterThan(uY, lY))) {
            return 0;
        }
        boolean blX = !DBMath.isGreaterThan(bX, lX);
        boolean uhX = !DBMath.isGreaterThan(hX, uX);
        boolean blY = !DBMath.isGreaterThan(bY, lY);
        boolean bl = uhY = !DBMath.isGreaterThan(hY, uY);
        if (blX && uhX && blY && uhY) {
            return 1;
        }
        double xoverlap = Math.min(hX, uX) - Math.max(lX, bX);
        if (xoverlap > (yoverlap = Math.min(hY, uY) - Math.max(lY, bY))) {
            if (blX && uhX) {
                if (!DBMath.isGreaterThan(hY, uY)) {
                    hY = bY;
                }
                if (blY) {
                    lY = uY;
                }
                if (!DBMath.isGreaterThan(hY, lY)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
        } else if (blY && uhY) {
            if (!DBMath.isGreaterThan(hX, uX)) {
                hX = bX;
            }
            if (blX) {
                lX = uX;
            }
            if (!DBMath.isGreaterThan(hX, lX)) {
                return 1;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            return 0;
        }
        return -1;
    }

    public static int cropBoxComplete(Rectangle2D bounds, Rectangle2D PUBox, boolean parasitic) {
        boolean uhY;
        double bX = PUBox.getMinX();
        double uX = PUBox.getMaxX();
        double bY = PUBox.getMinY();
        double uY = PUBox.getMaxY();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        if (!(DBMath.isGreaterThan(hX, bX) && DBMath.isGreaterThan(hY, bY) && DBMath.isGreaterThan(uX, lX) && DBMath.isGreaterThan(uY, lY))) {
            return -2;
        }
        boolean blX = !DBMath.isGreaterThan(bX, lX);
        boolean uhX = !DBMath.isGreaterThan(hX, uX);
        boolean blY = !DBMath.isGreaterThan(bY, lY);
        boolean bl = uhY = !DBMath.isGreaterThan(hY, uY);
        if (blX && uhX && blY && uhY) {
            return 1;
        }
        if (bX <= lX) {
            lX = uX;
        }
        if (bY >= lY) {
            hY = bY;
        }
        if (uY <= hY) {
            lY = hY;
        }
        if (hX <= uX) {
            hX = bX;
        }
        bounds.setRect(lX, lY, hX - lX, hY - lY);
        return 0;
    }

    public static int halfCropBox(Rectangle2D bounds, Rectangle2D limit) {
        boolean uhY;
        double bX = limit.getMinX();
        double uX = limit.getMaxX();
        double bY = limit.getMinY();
        double uY = limit.getMaxY();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        if (!(DBMath.isGreaterThan(hX, bX) && DBMath.isGreaterThan(hY, bY) && DBMath.isGreaterThan(uX, lX) && DBMath.isGreaterThan(uY, lY))) {
            return 0;
        }
        boolean blX = !DBMath.isGreaterThan(bX, lX);
        boolean uhX = !DBMath.isGreaterThan(hX, uX);
        boolean blY = !DBMath.isGreaterThan(bY, lY);
        boolean bl = uhY = !DBMath.isGreaterThan(hY, uY);
        if (blX && uhX && blY && uhY) {
            double lxe = lX - bX;
            double hxe = uX - hX;
            double lye = lY - bY;
            double hye = uY - hY;
            double biggestExt = Math.max(Math.max(lxe, hxe), Math.max(lye, hye));
            if (DBMath.areEquals(biggestExt, 0.0)) {
                return 1;
            }
            if (DBMath.areEquals(lxe, biggestExt)) {
                if (!DBMath.isGreaterThan(hX, lX = (lX + uX) / 2.0)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (DBMath.areEquals(hxe, biggestExt)) {
                if (!DBMath.isGreaterThan(hX = (hX + bX) / 2.0, lX)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (DBMath.areEquals(lye, biggestExt)) {
                if (!DBMath.isGreaterThan(hY, lY = (lY + uY) / 2.0)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (DBMath.areEquals(hye, biggestExt)) {
                if (!DBMath.isGreaterThan(hY = (hY + bY) / 2.0, lY)) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
        }
        boolean crops = false;
        if (blX && uhX) {
            if (!DBMath.isGreaterThan(hY, uY)) {
                hY = (hY + bY) / 2.0;
            }
            if (blY) {
                lY = (lY + uY) / 2.0;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            crops = true;
        }
        if (blY && uhY) {
            if (!DBMath.isGreaterThan(hX, uX)) {
                hX = (hX + bX) / 2.0;
            }
            if (blX) {
                lX = (lX + uX) / 2.0;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            crops = true;
        }
        if (!crops) {
            return -1;
        }
        return 0;
    }

    public void clipArc(double lx, double hx, double ly, double hy) {
        int i;
        AngleList al;
        int i2;
        double plx = this.bounds.getMinX();
        double phx = this.bounds.getMaxX();
        double ply = this.bounds.getMinY();
        double phy = this.bounds.getMaxY();
        if (plx >= lx && phx <= hx && ply >= ly && phy <= hy) {
            return;
        }
        if (plx > hx || phx < lx || ply > hy || phy < ly) {
            this.points = new Point2D[0];
            return;
        }
        double xc = this.points[0].getX();
        double yc = this.points[0].getY();
        double xp = this.points[1].getX();
        double yp = this.points[1].getY();
        ArrayList<AngleList> curveList = new ArrayList<AngleList>();
        if (this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) {
            AngleList al1 = new AngleList(this.points[1]);
            double dx = xp - xc;
            double dy = yp - yc;
            if (dx == 0.0 && dy == 0.0) {
                System.out.println("Domain error doing circle/circle tangents");
                this.points = new Point2D[0];
                return;
            }
            al1.angle = Math.atan2(dy, dx);
            curveList.add(al1);
            AngleList al2 = new AngleList(this.points[2]);
            dx = al1.x - xc;
            dy = al1.y - yc;
            if (dx == 0.0 && dy == 0.0) {
                System.out.println("Domain error doing circle/circle tangents");
                this.points = new Point2D[0];
                return;
            }
            al2.angle = Math.atan2(dy, dx);
            curveList.add(al2);
        }
        int initialCount = curveList.size();
        Point2D.Double i1 = new Point2D.Double(lx, ly);
        Point2D.Double i22 = new Point2D.Double(lx, hy);
        int ints = this.circlelineintersection(this.points[0], this.points[1], i1, i22, 0.0);
        if (ints > 0) {
            curveList.add(new AngleList(i1));
        }
        if (ints > 1) {
            curveList.add(new AngleList(i22));
        }
        if ((ints = this.circlelineintersection(this.points[0], this.points[1], i1 = new Point2D.Double(lx, hy), i22 = new Point2D.Double(hx, hy), 0.0)) > 0) {
            curveList.add(new AngleList(i1));
        }
        if (ints > 1) {
            curveList.add(new AngleList(i22));
        }
        if ((ints = this.circlelineintersection(this.points[0], this.points[1], i1 = new Point2D.Double(hx, hy), i22 = new Point2D.Double(hx, ly), 0.0)) > 0) {
            curveList.add(new AngleList(i1));
        }
        if (ints > 1) {
            curveList.add(new AngleList(i22));
        }
        if ((ints = this.circlelineintersection(this.points[0], this.points[1], i1 = new Point2D.Double(hx, ly), i22 = new Point2D.Double(lx, ly), 0.0)) > 0) {
            curveList.add(new AngleList(i1));
        }
        if (ints > 1) {
            curveList.add(new AngleList(i22));
        }
        if (curveList.size() == initialCount) {
            this.points = new Point2D[0];
            return;
        }
        for (i2 = initialCount; i2 < curveList.size(); ++i2) {
            al = (AngleList)curveList.get(i2);
            if (al.y == yc && al.x == xc) {
                System.out.println("Warning: instability ahead");
                this.points = new Point2D[0];
                return;
            }
            double dx = al.x - xc;
            double dy = al.y - yc;
            if (dx == 0.0 && dy == 0.0) {
                System.out.println("Domain error doing circle/circle tangents");
                this.points = new Point2D[0];
                return;
            }
            al.angle = Math.atan2(dy, dx);
        }
        if (this.style == Poly.Type.CIRCLEARC || this.style == Poly.Type.THICKCIRCLEARC) {
            int j = 2;
            AngleList al0 = (AngleList)curveList.get(0);
            AngleList al1 = (AngleList)curveList.get(1);
            for (i = 2; i < curveList.size(); ++i) {
                AngleList al2 = (AngleList)curveList.get(i);
                if (al0.angle > al1.angle ? al2.angle > al0.angle || al2.angle < al1.angle : al2.angle > al0.angle && al2.angle < al1.angle) continue;
                AngleList alj = (AngleList)curveList.get(j);
                alj.x = al2.x;
                alj.y = al2.y;
                alj.angle = al2.angle;
                ++j;
            }
            while (curveList.size() > j) {
                curveList.remove(curveList.size() - 1);
            }
            al0 = (AngleList)curveList.get(0);
            for (i = 0; i < curveList.size(); ++i) {
                AngleList al3 = (AngleList)curveList.get(i);
                if (!(al3.angle > al0.angle)) continue;
                al3.angle -= Math.PI * 2;
            }
        } else {
            for (i2 = 0; i2 < curveList.size(); ++i2) {
                al = (AngleList)curveList.get(i2);
                if (!(al.angle > 0.0)) continue;
                al.angle -= Math.PI * 2;
            }
        }
        Collections.sort(curveList, new AngleListDescending());
        if (this.style != Poly.Type.CIRCLEARC && this.style != Poly.Type.THICKCIRCLEARC) {
            AngleList al0 = (AngleList)curveList.get(0);
            AngleList alNew = new AngleList(new Point2D.Double(al0.x, al0.y));
            alNew.angle = al0.angle - Math.PI * 2;
            curveList.add(alNew);
        }
        double radius = this.points[0].distance(this.points[1]);
        ArrayList<Point2D.Double> newIn = new ArrayList<Point2D.Double>();
        for (i = 1; i < curveList.size(); ++i) {
            double midAngle;
            int prev = i - 1;
            AngleList al4 = (AngleList)curveList.get(i);
            AngleList alP = (AngleList)curveList.get(prev);
            for (midAngle = (alP.angle + al4.angle) / 2.0; midAngle < -Math.PI; midAngle += Math.PI * 2) {
            }
            double midx = xc + radius * Math.cos(midAngle);
            double midy = yc + radius * Math.sin(midAngle);
            if (midx < lx || midx > hx || midy < ly || midy > hy) continue;
            newIn.add(new Point2D.Double(xc, yc));
            newIn.add(new Point2D.Double(alP.x, alP.y));
            newIn.add(new Point2D.Double(al4.x, al4.y));
        }
        this.points = new Point2D[newIn.size()];
        for (i = 0; i < newIn.size(); ++i) {
            this.points[i] = (Point2D)newIn.get(i);
        }
        if (this.style == Poly.Type.THICKCIRCLE) {
            this.style = Poly.Type.THICKCIRCLEARC;
        } else if (this.style == Poly.Type.CIRCLE) {
            this.style = Poly.Type.CIRCLEARC;
        }
    }

    private int circlelineintersection(Point2D ctr, Point2D edge, Point2D from, Point2D to, double tolerance) {
        double radius;
        double fy;
        double fx;
        double icx = ctr.getX();
        double icy = ctr.getY();
        double isx = edge.getX();
        double isy = edge.getY();
        double lx1 = from.getX();
        double ly1 = from.getY();
        double lx2 = to.getX();
        double ly2 = to.getY();
        double segx = 0.0;
        double segy = 0.0;
        if (ly1 == ly2) {
            segx = icx;
            segy = ly1;
        } else if (lx1 == lx2) {
            segx = lx1;
            segy = icy;
        } else {
            fx = lx1 - lx2;
            fy = ly1 - ly2;
            double m = fy / fx;
            double b = -lx1;
            b *= m;
            double mi = -1.0 / m;
            double bi = -icx;
            bi *= mi;
            segx = ((bi += icy) - (b += ly1)) / (m - mi);
            segy = m * segx + b;
        }
        if (segx == icx && segy == icy) {
            fx = isx - icx;
            fy = isy - icy;
            radius = Math.sqrt(fx * fx + fy * fy);
            fx = lx2 - lx1;
            fy = ly2 - ly1;
            if (fx == 0.0 && fy == 0.0) {
                System.out.println("Domain error doing circle/line intersection");
                return 0;
            }
            double angle = Math.atan2(fy, fx);
            from.setLocation(icx + Math.cos(angle) * radius, icy + Math.sin(angle) * radius);
            to.setLocation(icx + Math.cos(-angle) * radius, icy + Math.sin(-angle) * radius);
        } else {
            fx = isx - icx;
            fy = isy - icy;
            radius = Math.sqrt(fx * fx + fy * fy);
            fx = segx - icx;
            fy = segy - icy;
            double adjacent = Math.sqrt(fx * fx + fy * fy);
            if (Math.abs(adjacent - radius) < tolerance) {
                from.setLocation(segx, segy);
                return 1;
            }
            if (adjacent > radius) {
                return 0;
            }
            if (radius == 0.0) {
                from.setLocation(icx, icy);
                to.setLocation(icx, icy);
            } else {
                double angle = Math.acos(adjacent / radius);
                fx = segx - icx;
                fy = segy - icy;
                if (fx == 0.0 && fy == 0.0) {
                    System.out.println("Domain error doing line/circle intersection");
                    return 0;
                }
                double intangle = Math.atan2(fy, fx);
                double a1 = intangle - angle;
                double a2 = intangle + angle;
                from.setLocation(icx + Math.cos(a1) * radius, icy + Math.sin(a1) * radius);
                to.setLocation(icx + Math.cos(a2) * radius, icy + Math.sin(a2) * radius);
            }
        }
        if (from.getX() == to.getX() && from.getY() == to.getY()) {
            return 1;
        }
        return 2;
    }

    public PolyBase getPolygon() {
        return this;
    }

    private static class AngleListDescending
    implements Comparator {
        private AngleListDescending() {
        }

        public int compare(Object o1, Object o2) {
            AngleList c1 = (AngleList)o1;
            AngleList c2 = (AngleList)o2;
            double diff = c2.angle - c1.angle;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }
    }

    private static class AngleList {
        private double angle;
        private double x;
        private double y;

        AngleList(Point2D pt) {
            this.x = pt.getX();
            this.y = pt.getY();
        }
    }

    private class PolyPathIterator
    implements PathIterator {
        int idx = 0;
        AffineTransform trans;

        public PolyPathIterator(PolyBase p, AffineTransform at) {
            this.trans = at;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.idx > PolyBase.this.points.length;
        }

        public void next() {
            ++this.idx;
        }

        public int currentSegment(float[] coords) {
            if (this.idx >= PolyBase.this.points.length) {
                return 4;
            }
            coords[0] = (float)PolyBase.this.points[this.idx].getX();
            coords[1] = (float)PolyBase.this.points[this.idx].getY();
            if (this.trans != null) {
                this.trans.transform(coords, 0, coords, 0, 1);
            }
            return this.idx == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            if (this.idx >= PolyBase.this.points.length) {
                return 4;
            }
            coords[0] = PolyBase.this.points[this.idx].getX();
            coords[1] = PolyBase.this.points[this.idx].getY();
            if (this.trans != null) {
                this.trans.transform(coords, 0, coords, 0, 1);
            }
            return this.idx == 0 ? 0 : 1;
        }
    }
}

