/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.NetEquivalence;
import com.sun.electric.tool.user.User;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NccBackAnnotate {
    public static void backAnnotateNetNamesJob(NccResult result) {
        if (result == null) {
            return;
        }
        BackAnnotateJob job = new BackAnnotateJob(result, 0);
        job.startJob();
    }

    public static void backAnnotateNetNames(NccResult result) {
        if (result == null) {
            return;
        }
        NetEquivalence equivs = result.getNetEquivalence();
        NccGlobals globals = result.getGlobalData();
        Cell[] rootCells = globals.getRootCells();
        if (rootCells.length != 2) {
            return;
        }
        int i = 1;
        Cell layCell = rootCells[i];
        if (layCell.getView() != View.LAYOUT) {
            i = 0;
        }
        if ((layCell = rootCells[i]).getView() != View.LAYOUT) {
            return;
        }
        VarContext context = globals.getRootContexts()[i];
        NccBackAnnotate.backAnnotateNetNames(equivs);
    }

    private static void backAnnotateNetNames(NetEquivalence equivs) {
        if (equivs.equivNets.length == 0) {
            return;
        }
        if (equivs.equivNets[0].length == 0) {
            return;
        }
        int lay = 0;
        int sch = 1;
        Network net = equivs.equivNets[lay][0].getNet();
        if (net.getParent().getView() != View.LAYOUT) {
            lay = 1;
        }
        if ((net = equivs.equivNets[lay][0].getNet()).getParent().getView() != View.LAYOUT) {
            return;
        }
        sch = lay == 1 ? 0 : 1;
        HashMap<String, Network> backAnnotated = new HashMap<String, Network>();
        HashMap<ArcInst, String> newArcNames = new HashMap<ArcInst, String>();
        for (int i = 0; i < equivs.equivNets[0].length; ++i) {
            Iterator arcIt;
            Network layNet = equivs.equivNets[lay][i].getNet();
            String layName = layNet.getName();
            Network schNet = equivs.equivNets[sch][i].getNet();
            String schName = schNet.getName();
            System.out.print("(" + layNet.getParent().describe(false) + ")lay:\t" + layName + "\t(" + schNet.getParent().describe(false) + ")sch:");
            Iterator it = schNet.getNames();
            while (it.hasNext()) {
                System.out.print("\t" + (String)it.next());
            }
            System.out.println();
            if (layNet.isExported() || layName.indexOf(64) == -1 || schName.indexOf(64) != -1) continue;
            Cell layCell = layNet.getParent();
            boolean skip = false;
            Iterator it2 = layNet.getNetlist().getNetworks();
            while (it2.hasNext()) {
                net = (Network)it2.next();
                if (!net.hasName(schName)) continue;
                skip = true;
                break;
            }
            if (skip || backAnnotated.containsKey(layCell.describe(false) + layName) || !(arcIt = layNet.getArcs()).hasNext()) continue;
            ArcInst ai = (ArcInst)arcIt.next();
            newArcNames.put(ai, schName);
            System.out.println("Back-annotated in cell " + layCell.describe(true) + ", net '" + layName + "' to '" + schName + "'");
            backAnnotated.put(layCell.describe(false) + layName, layNet);
        }
        Iterator it = newArcNames.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ArcInst ai = (ArcInst)entry.getKey();
            String name = (String)entry.getValue();
            ai.setName(name);
        }
    }

    private static class BackAnnotateJob
    extends Job {
        private NccResult result;
        private int type;

        private BackAnnotateJob(NccResult result, int type) {
            super("BackAnnotateJob", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.result = result;
            this.type = type;
        }

        public boolean doIt() {
            switch (this.type) {
                case 0: {
                    NccBackAnnotate.backAnnotateNetNames(this.result);
                }
            }
            return true;
        }
    }
}

