/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.netlist.PartType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PartTypeTable {
    private int numTypes = 0;
    private int log2NumTypes;
    private ArrayList types = new ArrayList();
    private HashMap nameToType = new HashMap();
    private HashMap longNameToType = new HashMap();

    private void add(String typeName, String longTypeName) {
        PartType t = new PartType(this.numTypes++, typeName);
        LayoutLib.error(this.nameToType.containsKey(typeName), "duplicate type name");
        this.nameToType.put(typeName, t);
        LayoutLib.error(this.longNameToType.containsKey(longTypeName), "duplicate long type name");
        this.longNameToType.put(longTypeName, t);
        this.types.add(t);
        this.log2NumTypes = (int)Math.ceil(Math.log(this.numTypes) / Math.log(2.0));
    }

    public PartTypeTable(String[][] typeNames) {
        for (int i = 0; i < typeNames.length; ++i) {
            this.add(typeNames[i][0], typeNames[i][1]);
        }
    }

    public int log2NumTypes() {
        return this.log2NumTypes;
    }

    public Iterator iterator() {
        return this.types.iterator();
    }

    public PartType get(String nm) {
        return (PartType)this.nameToType.get(nm);
    }

    public PartType getTypeFromLongName(String nm) {
        return (PartType)this.longNameToType.get(nm);
    }
}

