/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Quick {
    private static final double TINYDELTA = DBMath.getEpsilon() * 1.1;
    private static final Variable.Key DRC_ANNOTATION_KEY = Variable.newKey("ATTR_DRC");
    private HashMap<NodeInst, CheckInst> checkInsts = null;
    private HashMap<Cell, CheckProto> checkProtos = null;
    private HashMap<Network, Integer[]> networkLists = null;
    private HashMap<Layer, DRCTemplate> minAreaLayerMap = new HashMap();
    private HashMap<Layer, DRCTemplate> enclosedAreaLayerMap = new HashMap();
    private HashMap<Layer, DRCTemplate> slotSizeLayerMap = new HashMap();
    private DRC.CheckDRCJob job;
    private HashMap<Cell, Cell> cellsMap = new HashMap();
    private HashMap<Geometric, Geometric> nodesMap = new HashMap();
    private int activeBits = 0;
    private boolean inMemory = DRC.isDatesStoredInMemory();
    private GeometryHandler.GHMode mergeMode = GeometryHandler.GHMode.ALGO_SWEEP;
    private Map<Layer, NodeInst> od2Layers = new HashMap<Layer, NodeInst>(3);
    private List<InstanceInter> instanceInteractionList = new ArrayList<InstanceInter>();
    private Map<Cell, Area> exclusionMap = new HashMap<Cell, Area>();
    private int numberOfThreads;
    private DRC.DRCCheckMode errorTypeSearch;
    private double minAllowedResolution;
    private boolean ignoreCenterCuts;
    private double worstInteractionDistance;
    private int checkTimeStamp;
    private int checkNetNumber;
    private int totalMsgFound;
    private NodeInst tinyNodeInst;
    private Geometric tinyGeometric;
    private HashMap<Cell, Date> goodDRCDate = new HashMap();
    private HashMap<Cell, Cell> cleanDRCDate = new HashMap();
    private ErrorLogger errorLogger;
    private boolean interactiveLogger = false;
    private Cell topCell;
    private Technology layersValidTech = null;
    private boolean[] layersValid;
    private Technology layerInterTech = null;
    private HashMap<PrimitiveNode, boolean[]> layersInterNodes = null;
    private HashMap<ArcProto, boolean[]> layersInterArcs = null;

    public Quick(DRC.CheckDRCJob job, GeometryHandler.GHMode mode) {
        this.job = job;
        this.mergeMode = mode;
    }

    public static ErrorLogger checkDesignRules(ErrorLogger errorLog, Cell cell, Geometric[] geomsToCheck, boolean[] validity, Rectangle2D bounds) {
        if (errorLog == null) {
            errorLog = DRC.getDRCErrorLogger(true, false);
        }
        return Quick.checkDesignRules(errorLog, cell, geomsToCheck, validity, bounds, null, GeometryHandler.GHMode.ALGO_SWEEP);
    }

    public static ErrorLogger checkDesignRules(ErrorLogger errorLog, Cell cell, Geometric[] geomsToCheck, boolean[] validity, Rectangle2D bounds, DRC.CheckDRCJob drcJob, GeometryHandler.GHMode mode) {
        Quick q = new Quick(drcJob, mode);
        return q.doCheck(errorLog, cell, geomsToCheck, validity, bounds);
    }

    private ErrorLogger doCheck(ErrorLogger errorLog, Cell cell, Geometric[] geomsToCheck, boolean[] validity, Rectangle2D bounds) {
        int count;
        Technology tech = cell.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        this.activeBits = DRC.getActiveBits(tech);
        System.out.println("Running DRC with " + DRC.explainBits(this.activeBits));
        this.inMemory = DRC.isDatesStoredInMemory();
        this.interactiveLogger = DRC.isInteractiveLoggingOn();
        this.minAllowedResolution = tech.getResolution();
        if (rules == null || rules.getNumberOfRules() == 0) {
            return this.errorLogger;
        }
        this.errorTypeSearch = DRC.getErrorType();
        this.ignoreCenterCuts = DRC.isIgnoreCenterCuts();
        this.numberOfThreads = DRC.getNumberOfThreads();
        this.topCell = cell;
        int n = count = geomsToCheck != null ? geomsToCheck.length : 0;
        if (count > 0) {
            this.errorTypeSearch = DRC.DRCCheckMode.ERROR_CHECK_CELL;
            this.numberOfThreads = 1;
        }
        this.cacheValidLayers(tech);
        this.buildLayerInteractions(tech);
        this.instanceInteractionList.clear();
        this.worstInteractionDistance = DRC.getWorstSpacingDistance(tech, -1);
        this.minAreaLayerMap.clear();
        this.enclosedAreaLayerMap.clear();
        this.slotSizeLayerMap.clear();
        this.cellsMap.clear();
        this.nodesMap.clear();
        if (!DRC.isIgnoreAreaChecking() && this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_CELL) {
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                DRCTemplate slotRule;
                DRCTemplate enclosedAreaRule;
                Layer layer = it.next();
                DRCTemplate minAreaRule = DRC.getMinValue(layer, DRCTemplate.DRCRuleType.MINAREA);
                if (minAreaRule != null) {
                    this.minAreaLayerMap.put(layer, minAreaRule);
                }
                if ((enclosedAreaRule = DRC.getMinValue(layer, DRCTemplate.DRCRuleType.MINENCLOSEDAREA)) != null) {
                    this.enclosedAreaLayerMap.put(layer, enclosedAreaRule);
                }
                if ((slotRule = DRC.getMinValue(layer, DRCTemplate.DRCRuleType.SLOTSIZE)) == null) continue;
                this.slotSizeLayerMap.put(layer, slotRule);
            }
        }
        this.checkProtos = new HashMap();
        this.checkInsts = new HashMap();
        Netlist netlist = cell.getNetlist(false);
        CheckProto cp = this.checkEnumerateProtos(cell, netlist);
        if (cp.treeParameterized && this.numberOfThreads > 1) {
            System.out.println("Parameterized layout being used: multiprocessor decomposition disabled");
            this.numberOfThreads = 1;
        }
        cp.hierInstanceCount = 1;
        this.checkTimeStamp = 0;
        this.checkEnumerateInstances(cell);
        this.networkLists = new HashMap();
        for (Map.Entry<Cell, CheckProto> e : this.checkProtos.entrySet()) {
            NodeProto np;
            NodeInst ni;
            Iterator<Object> nIt;
            Cell libCell = e.getKey();
            CheckProto subCP = e.getValue();
            if (subCP.hierInstanceCount > 0) {
                nIt = subCP.netlist.getNetworks();
                while (nIt.hasNext()) {
                    Network net = (Network)nIt.next();
                    Integer[] netNumbers = new Integer[subCP.hierInstanceCount];
                    for (int i = 0; i < subCP.hierInstanceCount; ++i) {
                        netNumbers[i] = new Integer(0);
                    }
                    this.networkLists.put(net, netNumbers);
                }
            }
            nIt = libCell.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                np = ni.getProto();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                CheckInst ci = this.checkInsts.get(ni);
                CheckProto ocp = this.getCheckProto((Cell)np);
                ci.offset = ocp.totalPerCell;
            }
            ++this.checkTimeStamp;
            nIt = libCell.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                np = ni.getProto();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                CheckProto ocp = this.getCheckProto((Cell)np);
                if (ocp.timeStamp == this.checkTimeStamp) continue;
                CheckInst ci = this.checkInsts.get(ni);
                ocp.timeStamp = this.checkTimeStamp;
                ocp.totalPerCell += subCP.hierInstanceCount * ci.multiplier;
            }
        }
        this.checkTimeStamp = 0;
        this.checkNetNumber = 1;
        HashMap<Network, Integer> enumeratedNets = new HashMap<Network, Integer>();
        Iterator<Network> nIt = cp.netlist.getNetworks();
        while (nIt.hasNext()) {
            Network net = nIt.next();
            enumeratedNets.put(net, new Integer(this.checkNetNumber));
            ++this.checkNetNumber;
        }
        this.checkEnumerateNetworks(cell, cp, 0, enumeratedNets);
        if (count <= 0) {
            System.out.println("Found " + this.checkNetNumber + " networks");
        }
        this.exclusionMap.clear();
        this.accumulateExclusion(cell);
        this.errorLogger = errorLog;
        int logsFound = 0;
        int totalErrors = 0;
        if (count == 0) {
            totalErrors = this.checkThisCell(cell, 0, bounds);
            this.errorLogger.sortLogs();
        } else {
            if (validity == null) {
                logsFound = this.errorLogger.getNumLogs();
            }
            this.checkTheseGeometrics(cell, count, geomsToCheck, validity);
        }
        if (this.errorLogger != null) {
            this.errorLogger.termLogging(true);
            logsFound = this.errorLogger.getNumLogs() - logsFound;
        }
        if (this.job == null || !this.job.checkAbort()) {
            DRC.addDRCUpdate(this.activeBits, this.goodDRCDate, this.cleanDRCDate, null);
        }
        return this.errorLogger;
    }

    private int checkThisCell(Cell cell, int globalIndex, Rectangle2D bounds) {
        if (this.job != null && this.job.checkAbort()) {
            return -1;
        }
        if (this.cellsMap.get(cell) != null) {
            return 0;
        }
        int prevErrors = 0;
        int prevWarns = 0;
        if (this.errorLogger != null) {
            prevErrors = this.errorLogger.getNumErrors();
            prevWarns = this.errorLogger.getNumWarnings();
        }
        this.cellsMap.put(cell, cell);
        Variable drcVar = cell.getVar(DRC_ANNOTATION_KEY);
        if (drcVar != null && drcVar.getObject().toString().startsWith("black")) {
            return this.totalMsgFound;
        }
        boolean allSubCellsStillOK = true;
        Area area = this.exclusionMap.get(cell);
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance() || ni.isIconOfParent() || area != null && area.contains(ni.getBounds())) continue;
            Rectangle2D subBounds = bounds;
            if (subBounds != null) {
                if (!ni.getBounds().intersects(bounds)) continue;
                AffineTransform trans = ni.rotateIn();
                AffineTransform xTrnI = ni.translateIn();
                trans.preConcatenate(xTrnI);
                subBounds = new Rectangle2D.Double();
                subBounds.setRect(bounds);
                DBMath.transformRect(subBounds, trans);
            }
            CheckProto cp = this.getCheckProto((Cell)np);
            if (cp.cellChecked && !cp.cellParameterized) continue;
            CheckInst ci = this.checkInsts.get(ni);
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            int retval = this.checkThisCell((Cell)np, localIndex, subBounds);
            if (retval < 0) {
                return retval;
            }
            if (retval <= 0 && this.goodDRCDate.get(np) == null) continue;
            allSubCellsStillOK = false;
        }
        CheckProto cp = this.getCheckProto(cell);
        cp.cellChecked = true;
        Date lastGoodDate = DRC.getLastDRCDateBasedOnBits(cell, this.activeBits, !this.inMemory);
        if (allSubCellsStillOK && DRC.isCellDRCDateGood(cell, lastGoodDate)) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        System.out.println("Checking " + cell);
        this.totalMsgFound = 0;
        if (cell == this.topCell && !DRC.isIgnoreAreaChecking() && this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_CELL) {
            this.totalMsgFound = this.checkMinArea(cell);
        }
        Iterator<NodeInst> it2 = cell.getNodes();
        while (it2.hasNext()) {
            boolean ret;
            NodeInst ni = it2.next();
            if (bounds != null && !ni.getBounds().intersects(bounds) || area != null && area.contains(ni.getBounds()) || !(ret = ni.isCellInstance() ? this.checkCellInst(ni, globalIndex) : this.checkNodeInst(ni, globalIndex))) continue;
            ++this.totalMsgFound;
            if (this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_CELL) continue;
            break;
        }
        Technology cellTech = cell.getTechnology();
        Iterator<ArcInst> it3 = cell.getArcs();
        while (it3.hasNext()) {
            ArcInst ai = it3.next();
            Technology tech = ai.getProto().getTechnology();
            if (tech != cellTech) {
                this.reportError(DRCErrorType.TECHMIXWARN, " belongs to " + tech.getTechName(), cell, 0.0, 0.0, null, null, ai, null, null, null, null);
                continue;
            }
            if (bounds != null && !ai.getBounds().intersects(bounds) || !this.checkArcInst(cp, ai, globalIndex)) continue;
            ++this.totalMsgFound;
            if (this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_CELL) continue;
            break;
        }
        if (this.totalMsgFound > 0) {
            this.cleanDRCDate.put(cell, cell);
        } else if (lastGoodDate == null) {
            this.goodDRCDate.put(cell, new Date());
        }
        if (this.errorLogger != null) {
            int localErrors = this.errorLogger.getNumErrors() - prevErrors;
            int localWarnings = this.errorLogger.getNumWarnings() - prevWarns;
            long endTime = System.currentTimeMillis();
            if (localErrors == 0 && localWarnings == 0) {
                System.out.println("\tNo errors/warnings found");
            } else {
                if (localErrors > 0) {
                    System.out.println("\tFOUND " + localErrors + " ERRORS");
                }
                if (localWarnings > 0) {
                    System.out.println("\tFOUND " + localWarnings + " WARNINGS");
                }
            }
            if (Job.getDebug()) {
                System.out.println("\t(took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            }
        }
        return this.totalMsgFound;
    }

    private boolean checkResolution(PolyBase poly, Cell cell, Geometric geom) {
        Point2D[] points;
        if (this.minAllowedResolution == 0.0) {
            return false;
        }
        int count = 0;
        String resolutionError = "";
        for (Point2D point : points = poly.getPoints()) {
            if (DBMath.hasRemainder(point.getX(), this.minAllowedResolution)) {
                ++count;
                resolutionError = TextUtils.formatDouble(Math.abs(point.getX() / this.minAllowedResolution % 1.0 * this.minAllowedResolution)) + "(X=" + point.getX() + ")";
                break;
            }
            if (!DBMath.hasRemainder(point.getY(), this.minAllowedResolution)) continue;
            ++count;
            resolutionError = TextUtils.formatDouble(Math.abs(point.getY() / this.minAllowedResolution % 1.0 * this.minAllowedResolution)) + "(Y=" + point.getY() + ")";
            break;
        }
        if (count == 0) {
            return false;
        }
        Layer layer = poly.getLayer();
        this.reportError(DRCErrorType.RESOLUTION, " resolution of " + resolutionError + " less than " + this.minAllowedResolution + " on layer " + layer.getName(), cell, 0.0, 0.0, null, null, geom, null, null, null, null);
        return true;
    }

    private boolean coverByExclusion(Geometric geo) {
        Cell cell = geo.getParent();
        Area area = this.exclusionMap.get(cell);
        return area != null && area.contains(geo.getBounds());
    }

    private boolean coverByExclusion(Poly poly, Cell parent) {
        Point2D[] pts;
        Area area = this.exclusionMap.get(parent);
        if (area == null) {
            return false;
        }
        for (Point2D point : pts = poly.getPoints()) {
            if (area.contains(point)) continue;
            return false;
        }
        System.out.println("DRC Exclusion found in coverByExclusion");
        return true;
    }

    private boolean checkNodeInst(NodeInst ni, int globalIndex) {
        Cell cell = ni.getParent();
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        NodeProto np = ni.getProto();
        Technology tech = np.getTechnology();
        AffineTransform trans = ni.rotateOut();
        boolean errorsFound = false;
        if (NodeInst.isSpecialNode(ni)) {
            return false;
        }
        if (np.getFunction() == PrimitiveNode.Function.PIN) {
            return false;
        }
        if (this.coverByExclusion(ni)) {
            return false;
        }
        if (this.nodesMap.get(ni) != null) {
            return false;
        }
        this.nodesMap.put(ni, ni);
        if (np instanceof PrimitiveNode && DRC.isForbiddenNode(((PrimitiveNode)np).getPrimNodeIndexInTech(), -1, DRCTemplate.DRCRuleType.FORBIDDEN, tech)) {
            this.reportError(DRCErrorType.FORBIDDEN, " is not allowed by selected foundry", cell, -1.0, -1.0, null, null, ni, null, null, null, null);
            if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                return true;
            }
            errorsFound = true;
        }
        Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, this.ignoreCenterCuts, null);
        this.convertPseudoLayers(ni, nodeInstPolyList);
        int tot = nodeInstPolyList.length;
        boolean isTransistor = np.getFunction().isTransistor();
        for (int j = 0; j < tot; ++j) {
            int netNumber;
            Poly poly = nodeInstPolyList[j];
            Layer layer = poly.getLayer();
            if (layer == null || this.coverByExclusion(poly, cell)) continue;
            boolean ret = this.checkOD2Combination(tech, ni, layer);
            if (ret) {
                return true;
            }
            poly.transform(trans);
            ret = this.checkResolution(poly, cell, ni);
            if (ret) {
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.badBox(poly, layer, netNumber = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex), tech, ni, trans, cell, globalIndex)) {
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkMinWidth(ni, layer, poly, tot == 1)) {
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            boolean bl = ret = !isTransistor && this.checkSelectOverPolysilicon(ni, layer, poly, cell);
            if (ret) {
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkExtensionRule(ni, layer, poly, cell)) {
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            if (tech != this.layersValidTech || this.layersValid[layer.getIndex()]) continue;
            this.reportError(DRCErrorType.BADLAYERERROR, null, cell, 0.0, 0.0, null, poly, ni, layer, null, null, null);
            if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                return true;
            }
            errorsFound = true;
        }
        PrimitiveNode.NodeSizeRule sizeRule = DRC.getMinSize(np);
        if (sizeRule != null && (DBMath.isGreaterThan(sizeRule.getWidth(), ni.getXSize()) || DBMath.isGreaterThan(sizeRule.getHeight(), ni.getYSize()))) {
            SizeOffset so = ni.getSizeOffset();
            double minSize = 0.0;
            double actual = 0.0;
            String msg = "X axis";
            if (sizeRule.getWidth() - ni.getXSize() > sizeRule.getHeight() - ni.getYSize()) {
                minSize = sizeRule.getWidth() - so.getLowXOffset() - so.getHighXOffset();
                actual = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
            } else {
                msg = "Y axis";
                minSize = sizeRule.getHeight() - so.getLowYOffset() - so.getHighYOffset();
                actual = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
            }
            this.reportError(DRCErrorType.MINSIZEERROR, msg, cell, minSize, actual, sizeRule.getRuleName(), null, ni, null, null, null, null);
            errorsFound = true;
        }
        return errorsFound;
    }

    private boolean checkOD2Combination(Technology tech, NodeInst ni, Layer layer) {
        int funExtras = layer.getFunctionExtras();
        boolean notOk = false;
        if (layer.getFunction().isImplant() && (funExtras & 0x800000) != 0) {
            this.od2Layers.put(layer, ni);
            if (this.od2Layers.size() != 1) {
                for (Map.Entry<Layer, NodeInst> e : this.od2Layers.entrySet()) {
                    Layer lay1 = e.getKey();
                    if (lay1 == layer || !DRC.isForbiddenNode(lay1.getIndex(), layer.getIndex(), DRCTemplate.DRCRuleType.FORBIDDEN, tech)) continue;
                    NodeInst node = e.getValue();
                    String message = "- combination of layers '" + layer.getName() + "' and '" + lay1.getName() + "' (in '" + node.getParent().getName() + ":" + node.getName() + "') not allowed by selected foundry";
                    this.reportError(DRCErrorType.FORBIDDEN, message, ni.getParent(), -1.0, -1.0, null, null, ni, null, null, node, null);
                    return true;
                }
            }
        }
        return notOk;
    }

    private boolean checkArcInst(CheckProto cp, ArcInst ai, int globalIndex) {
        Network net = cp.netlist.getNetwork(ai, 0);
        if (net == null) {
            return false;
        }
        Integer[] netNumbers = this.networkLists.get(net);
        if (this.nodesMap.get(ai) != null) {
            if (Job.LOCALDEBUGFLAG) {
                System.out.println("Done already arc " + ai.getName());
            }
            return false;
        }
        this.nodesMap.put(ai, ai);
        Technology tech = ai.getProto().getTechnology();
        Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
        boolean errorsFound = false;
        for (Poly poly : arcInstPolyList) {
            boolean ret;
            Layer layer = poly.getLayer();
            if (layer == null || layer.isNonElectrical() || !(ret = this.checkResolution(poly, ai.getParent(), ai))) continue;
            if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                return true;
            }
            errorsFound = true;
        }
        this.cropActiveArc(ai, arcInstPolyList);
        int tot = arcInstPolyList.length;
        for (int j = 0; j < tot; ++j) {
            Poly poly = arcInstPolyList[j];
            Layer layer = poly.getLayer();
            if (layer == null || layer.isNonElectrical()) continue;
            int layerNum = layer.getIndex();
            int netNumber = netNumbers[globalIndex];
            boolean ret = this.badBox(poly, layer, netNumber, tech, ai, DBMath.MATID, ai.getParent(), globalIndex);
            if (ret) {
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkMinWidth(ai, layer, poly, tot == 1)) {
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkSelectOverPolysilicon(ai, layer, poly, ai.getParent())) {
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                errorsFound = true;
            }
            if (tech != this.layersValidTech || this.layersValid[layerNum]) continue;
            this.reportError(DRCErrorType.BADLAYERERROR, null, ai.getParent(), 0.0, 0.0, null, tot == 1 ? null : poly, ai, layer, null, null, null);
            if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                return true;
            }
            errorsFound = true;
        }
        return errorsFound;
    }

    private boolean checkCellInst(NodeInst ni, int globalIndex) {
        AffineTransform upTrans = ni.translateOut(ni.rotateOut());
        CheckInst ci = this.checkInsts.get(ni);
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        boolean errorFound = false;
        Rectangle2D nodeBounds = ni.getBounds();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(nodeBounds.getMinX() - this.worstInteractionDistance, nodeBounds.getMinY() - this.worstInteractionDistance, nodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nodeBounds.getHeight() + this.worstInteractionDistance * 2.0);
        this.instanceInteractionList.clear();
        Iterator<RTBounds> it = ni.getParent().searchIterator(searchBounds);
        while (it.hasNext()) {
            Rectangle2D nearNodeBounds;
            Rectangle2D.Double subBounds;
            boolean ret;
            NodeInst oNi;
            RTBounds geom = it.next();
            if (geom == ni || !(geom instanceof NodeInst) || (oNi = (NodeInst)geom).getNodeIndex() <= ni.getNodeIndex() || !oNi.isCellInstance() || this.checkInteraction(ni, null, oNi, null, null) || !(ret = this.checkCellInstContents(subBounds = new Rectangle2D.Double((nearNodeBounds = oNi.getBounds()).getMinX() - this.worstInteractionDistance, nearNodeBounds.getMinY() - this.worstInteractionDistance, nearNodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nearNodeBounds.getHeight() + this.worstInteractionDistance * 2.0), ni, upTrans, localIndex, oNi, null, globalIndex, null))) continue;
            errorFound = true;
        }
        return errorFound;
    }

    private boolean checkCellInstContents(Rectangle2D bounds, NodeInst thisNi, AffineTransform upTrans, int globalIndex, NodeInst oNi, NodeInst oNiParent, int topGlobalIndex, NodeInst triggerNi) {
        if (this.job != null && this.job.checkAbort()) {
            return true;
        }
        Cell cell = (Cell)thisNi.getProto();
        boolean logsFound = false;
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        Technology cellTech = cell.getTechnology();
        Rectangle2D bb = (Rectangle2D)bounds.clone();
        AffineTransform downTrans = thisNi.transformIn();
        DBMath.transformRect(bb, downTrans);
        Iterator<RTBounds> it = cell.searchIterator(bb);
        while (it.hasNext()) {
            int j;
            RTBounds geom = it.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                NodeProto np = ni.getProto();
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.isCellInstance()) {
                    if (this.checkInteraction(ni, thisNi, oNi, oNiParent, triggerNi)) continue;
                    AffineTransform subUpTrans = ni.translateOut(ni.rotateOut());
                    subUpTrans.preConcatenate(upTrans);
                    CheckInst ci = this.checkInsts.get(ni);
                    int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                    boolean ret = this.checkCellInstContents(bb, ni, subUpTrans, localIndex, oNi, oNiParent, topGlobalIndex, triggerNi == null ? ni : triggerNi);
                    if (!ret) continue;
                    if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                        return true;
                    }
                    logsFound = true;
                    continue;
                }
                AffineTransform rTrans = ni.rotateOut();
                rTrans.preConcatenate(upTrans);
                Technology tech = np.getTechnology();
                Poly[] primPolyList = tech.getShapeOfNode(ni, true, this.ignoreCenterCuts, null);
                this.convertPseudoLayers(ni, primPolyList);
                for (Poly poly : primPolyList) {
                    Layer layer = poly.getLayer();
                    if (layer == null) {
                        if (!Job.LOCALDEBUGFLAG) continue;
                        System.out.println("When is this case?");
                        continue;
                    }
                    poly.transform(rTrans);
                    int net = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex);
                    boolean ret = this.badSubBox(poly, layer, net, tech, ni, rTrans, globalIndex, oNi, topGlobalIndex);
                    if (!ret) continue;
                    if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                        return true;
                    }
                    logsFound = true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            Technology tech = ai.getProto().getTechnology();
            if (tech != cellTech) {
                this.reportError(DRCErrorType.TECHMIXWARN, " belongs to " + tech.getTechName(), cell, 0.0, 0.0, null, null, ai, null, null, null, null);
                continue;
            }
            Poly[] arcPolyList = tech.getShapeOfArc(ai);
            int tot = arcPolyList.length;
            for (j = 0; j < tot; ++j) {
                arcPolyList[j].transform(upTrans);
            }
            this.cropActiveArc(ai, arcPolyList);
            for (j = 0; j < tot; ++j) {
                boolean ret;
                Poly poly = arcPolyList[j];
                Layer layer = poly.getLayer();
                if (layer == null || layer.isNonElectrical()) continue;
                Network jNet = netlist.getNetwork(ai, 0);
                int net = -1;
                if (jNet != null) {
                    Integer[] netList = this.networkLists.get(jNet);
                    net = netList[globalIndex];
                }
                if (!(ret = this.badSubBox(poly, layer, net, tech, ai, upTrans, globalIndex, oNi, topGlobalIndex))) continue;
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_CELL) {
                    return true;
                }
                logsFound = true;
            }
        }
        return logsFound;
    }

    private boolean badSubBox(Poly poly, Layer layer, int net, Technology tech, Geometric geom, AffineTransform trans, int globalIndex, NodeInst oNi, int topGlobalIndex) {
        double maxSize = poly.getMaxSize();
        double bound = DRC.getMaxSurround(layer, maxSize);
        if (bound < 0.0) {
            return false;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(poly.getBounds2D());
        AffineTransform downTrans = oNi.rotateIn();
        AffineTransform tTransI = oNi.translateIn();
        downTrans.preConcatenate(tTransI);
        DBMath.transformRect(bounds, downTrans);
        AffineTransform upTrans = oNi.translateOut(oNi.rotateOut());
        CheckInst ci = this.checkInsts.get(oNi);
        int localIndex = topGlobalIndex * ci.multiplier + ci.localIndex + ci.offset;
        boolean baseMulti = false;
        if (geom instanceof NodeInst) {
            baseMulti = tech.isMultiCutCase((NodeInst)geom);
        }
        ((Rectangle2D)bounds).setRect(bounds.getMinX() - bound, bounds.getMinY() - bound, ((RectangularShape)bounds).getWidth() + bound * 2.0, ((RectangularShape)bounds).getHeight() + bound * 2.0);
        return this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, bounds, (Cell)oNi.getProto(), localIndex, oNi.getParent(), topGlobalIndex, upTrans, baseMulti, false);
    }

    private boolean badBox(Poly poly, Layer layer, int net, Technology tech, Geometric geom, AffineTransform trans, Cell cell, int globalIndex) {
        double maxSize = poly.getMaxSize();
        double bound = DRC.getMaxSurround(layer, maxSize);
        if (bound < 0.0) {
            return false;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(poly.getBounds2D());
        boolean baseMulti = false;
        if (geom instanceof NodeInst) {
            baseMulti = tech.isMultiCutCase((NodeInst)geom);
        }
        ((Rectangle2D)bounds).setRect(bounds.getMinX() - bound, bounds.getMinY() - bound, ((RectangularShape)bounds).getWidth() + bound * 2.0, ((RectangularShape)bounds).getHeight() + bound * 2.0);
        return this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, bounds, cell, globalIndex, cell, globalIndex, DBMath.MATID, baseMulti, true);
    }

    private boolean badBoxInArea(Poly poly, Layer layer, Technology tech, int net, Geometric geom, AffineTransform trans, int globalIndex, Rectangle2D bounds, Cell cell, int cellGlobalIndex, Cell topCell, int topGlobalIndex, AffineTransform upTrans, boolean baseMulti, boolean sameInstance) {
        Rectangle2D.Double rBound = new Rectangle2D.Double();
        ((Rectangle2D)rBound).setRect(bounds);
        DBMath.transformRect(rBound, upTrans);
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        Rectangle2D.Double subBound = new Rectangle2D.Double();
        boolean foundError = false;
        if (geom instanceof NodeInst && NodeInst.isSpecialNode((NodeInst)geom)) {
            return false;
        }
        Iterator<RTBounds> it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            Geometric nGeom = (Geometric)it.next();
            if (nGeom == geom && sameInstance || this.coverByExclusion(nGeom)) continue;
            if (nGeom instanceof NodeInst) {
                NodeInst ni = (NodeInst)nGeom;
                NodeProto np = ni.getProto();
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.isCellInstance()) {
                    AffineTransform rTransI = ni.rotateIn();
                    AffineTransform tTransI = ni.translateIn();
                    rTransI.preConcatenate(tTransI);
                    ((Rectangle2D)subBound).setRect(bounds);
                    DBMath.transformRect(subBound, rTransI);
                    CheckInst ci = this.checkInsts.get(ni);
                    int localIndex = cellGlobalIndex * ci.multiplier + ci.localIndex + ci.offset;
                    AffineTransform subTrans = ni.translateOut(ni.rotateOut());
                    subTrans.preConcatenate(upTrans);
                    if (!this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, subBound, (Cell)np, localIndex, topCell, topGlobalIndex, subTrans, baseMulti, sameInstance)) continue;
                    foundError = true;
                    if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                    return true;
                }
                if (np.getTechnology() != tech || !this.checkLayerWithNode(layer, np)) continue;
                boolean touch = sameInstance && nGeom.isConnected(geom);
                AffineTransform rTrans = ni.rotateOut();
                rTrans.preConcatenate(upTrans);
                Poly[] subPolyList = tech.getShapeOfNode(ni, true, this.ignoreCenterCuts, null);
                this.convertPseudoLayers(ni, subPolyList);
                int tot = subPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    subPolyList[i].transform(rTrans);
                }
                boolean multi = baseMulti;
                if (!multi) {
                    multi = tech.isMultiCutCase(ni);
                }
                int multiInt = multi ? 1 : 0;
                for (int j = 0; j < tot; ++j) {
                    boolean ret;
                    Rectangle2D nPolyRect;
                    Poly npoly = subPolyList[j];
                    Layer nLayer = npoly.getLayer();
                    if (nLayer == null || this.coverByExclusion(npoly, nGeom.getParent()) || DBMath.isGreaterThan((nPolyRect = npoly.getBounds2D()).getMinX(), rBound.getMaxX()) || DBMath.isGreaterThan(rBound.getMinX(), nPolyRect.getMaxX()) || DBMath.isGreaterThan(nPolyRect.getMinY(), rBound.getMaxY()) || DBMath.isGreaterThan(rBound.getMinY(), nPolyRect.getMaxY())) continue;
                    int nNet = this.getDRCNetNumber(netlist, npoly.getPort(), ni, cellGlobalIndex);
                    boolean con = false;
                    if (nNet >= 0 && nNet == net) {
                        con = true;
                    }
                    if (ret = this.checkExtensionGateRule(geom, layer, poly, nLayer, npoly, netlist)) {
                        foundError = true;
                        if (this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                            return true;
                        }
                    }
                    if (ret = this.checkCutSizes(np, geom, layer, poly, nGeom, nLayer, npoly, topCell)) {
                        foundError = true;
                        if (this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                            return true;
                        }
                    }
                    if (con && touch) {
                        Rectangle2D trueBox2;
                        boolean maytouch = this.mayTouch(tech, con, layer, nLayer);
                        Rectangle2D trueBox1 = poly.getBox();
                        if (trueBox1 == null) {
                            trueBox1 = poly.getBounds2D();
                        }
                        if ((trueBox2 = npoly.getBox()) == null) {
                            trueBox1 = npoly.getBounds2D();
                        }
                        if (!(ret = this.checkMinDefects(cell, maytouch, geom, poly, trueBox1, layer, nGeom, npoly, trueBox2, nLayer, topCell))) continue;
                        foundError = true;
                        if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                        return true;
                    }
                    boolean edge = false;
                    DRCTemplate theRule = this.getSpacingRule(layer, poly, geom, nLayer, npoly, ni, con, multiInt);
                    if (theRule == null) {
                        theRule = DRC.getEdgeRule(layer, nLayer);
                        edge = true;
                    }
                    if (theRule == null || !(ret = this.checkDist(tech, topCell, topGlobalIndex, poly, layer, net, geom, trans, globalIndex, npoly, nLayer, nNet, nGeom, rTrans, cellGlobalIndex, con, theRule, edge))) continue;
                    foundError = true;
                    if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                    return true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)nGeom;
            ArcProto ap = ai.getProto();
            if (ap.getTechnology() != tech || !this.checkLayerWithArc(layer, ap)) continue;
            boolean touch = sameInstance && nGeom.isConnected(geom);
            Network jNet = netlist.getNetwork(ai, 0);
            Integer[] netNumbers = this.networkLists.get(jNet);
            int nNet = netNumbers[cellGlobalIndex];
            boolean con = false;
            if (net >= 0 && nNet == net) {
                con = true;
            }
            Poly[] subPolyList = tech.getShapeOfArc(ai);
            int tot = subPolyList.length;
            for (int i = 0; i < tot; ++i) {
                subPolyList[i].transform(upTrans);
            }
            this.cropActiveArc(ai, subPolyList);
            boolean multi = baseMulti;
            int multiInt = multi ? 1 : 0;
            for (int j = 0; j < tot; ++j) {
                Rectangle2D nPolyRect;
                Poly nPoly = subPolyList[j];
                Layer nLayer = nPoly.getLayer();
                if (nLayer == null || this.coverByExclusion(nPoly, nGeom.getParent()) || (nPolyRect = nPoly.getBounds2D()).getMinX() > rBound.getMaxX() || nPolyRect.getMaxX() < rBound.getMinX() || nPolyRect.getMinY() > rBound.getMaxY() || nPolyRect.getMaxY() < rBound.getMinY()) continue;
                boolean ret = false;
                if (con && touch) {
                    Rectangle2D trueBox2;
                    boolean maytouch = this.mayTouch(tech, con, layer, nLayer);
                    Rectangle2D trueBox1 = poly.getBox();
                    if (trueBox1 == null) {
                        trueBox1 = poly.getBounds2D();
                    }
                    if ((trueBox2 = nPoly.getBox()) == null) {
                        trueBox1 = nPoly.getBounds2D();
                    }
                    if (!(ret = this.checkMinDefects(cell, maytouch, geom, poly, trueBox1, layer, nGeom, nPoly, trueBox2, nLayer, topCell))) continue;
                    foundError = true;
                    if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                    return true;
                }
                boolean edge = false;
                DRCTemplate theRule = this.getSpacingRule(layer, poly, geom, nLayer, nPoly, ai, con, multiInt);
                if (theRule == null) {
                    theRule = DRC.getEdgeRule(layer, nLayer);
                    edge = true;
                }
                if (theRule == null) continue;
                ret = this.checkDist(tech, topCell, topGlobalIndex, poly, layer, net, geom, trans, globalIndex, nPoly, nLayer, nNet, nGeom, upTrans, cellGlobalIndex, con, theRule, edge);
                if (ret) {
                    foundError = true;
                    if (this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                        return true;
                    }
                }
                if (!(ret = this.checkExtensionGateRule(geom, layer, poly, nLayer, nPoly, netlist))) continue;
                foundError = true;
                if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) continue;
                return true;
            }
        }
        return foundError;
    }

    private boolean checkMinDefects(Cell cell, boolean maytouch, Geometric geom1, Poly poly1, Rectangle2D trueBox1, Layer layer1, Geometric geom2, Poly poly2, Rectangle2D trueBox2, Layer layer2, Cell topCell) {
        if (trueBox1 == null || trueBox2 == null) {
            return false;
        }
        if (!maytouch) {
            return false;
        }
        double pdx = Math.max(trueBox2.getMinX() - trueBox1.getMaxX(), trueBox1.getMinX() - trueBox2.getMaxX());
        double pdy = Math.max(trueBox2.getMinY() - trueBox1.getMaxY(), trueBox1.getMinY() - trueBox2.getMaxY());
        double pd = Math.max(pdx, pdy);
        if (pdx == 0.0 && pdy == 0.0) {
            pd = 0.0;
        }
        boolean foundError = false;
        if (pd > 0.0) {
            return false;
        }
        DRCTemplate wRule = DRC.getMinValue(layer1, DRCTemplate.DRCRuleType.MINWID);
        if (wRule == null) {
            return false;
        }
        double minWidth = wRule.getValue(0);
        double lxb = Math.max(trueBox1.getMinX(), trueBox2.getMinX());
        double hxb = Math.min(trueBox1.getMaxX(), trueBox2.getMaxX());
        double lyb = Math.max(trueBox1.getMinY(), trueBox2.getMinY());
        double hyb = Math.min(trueBox1.getMaxY(), trueBox2.getMaxY());
        Point2D.Double lowB = new Point2D.Double(lxb, lyb);
        Point2D.Double highB = new Point2D.Double(hxb, hyb);
        Rectangle2D.Double bounds = new Rectangle2D.Double(lxb, lyb, hxb - lxb, hyb - lyb);
        if (bounds.equals(trueBox1) || bounds.equals(trueBox2)) {
            return false;
        }
        double actual = lowB.distance(highB);
        if (actual != 0.0 && DBMath.isGreaterThan(minWidth, actual) && this.foundSmallSizeDefect(cell, geom1, poly1, layer1, geom2, poly2, pd, lxb, lyb, hxb, hyb)) {
            this.reportError(DRCErrorType.MINWIDTHERROR, null, topCell, minWidth, actual, wRule.ruleName, new Poly(bounds), null, layer1, null, null, layer2);
            foundError = true;
        }
        return foundError;
    }

    private boolean foundSmallSizeDefect(Cell cell, Geometric geom1, Poly poly1, Layer layer1, Geometric geom2, Poly poly2, double pd, double lxb, double lyb, double hxb, double hyb) {
        boolean foundError = false;
        boolean[] pointsFound = new boolean[2];
        pointsFound[1] = false;
        pointsFound[0] = false;
        Point2D.Double lowB = new Point2D.Double(lxb, lyb);
        Point2D.Double highB = new Point2D.Double(hxb, hyb);
        Rectangle2D.Double bounds = new Rectangle2D.Double(lxb, lyb, hxb - lxb, hyb - lyb);
        Poly rebuild = new Poly(bounds);
        Point2D pt1 = new Point2D.Double(lxb - TINYDELTA, lyb - TINYDELTA);
        Point2D pt2 = new Point2D.Double(lxb - TINYDELTA, hyb + TINYDELTA);
        Point2D pt1d = (Point2D)pt1.clone();
        Point2D pt2d = (Point2D)pt2.clone();
        Rectangle2D.Double search = new Rectangle2D.Double(DBMath.round(lxb - TINYDELTA), DBMath.round(lyb - TINYDELTA), DBMath.round(hxb - lxb + 2.0 * TINYDELTA), DBMath.round(hyb - lyb + 2.0 * TINYDELTA));
        if (pd == 0.0) {
            pt1 = lowB;
            pt2 = highB;
            pt1d = lowB;
            pt2d = highB;
        } else {
            double delta;
            Point2D[] points = rebuild.getPoints();
            int[] cornerPoints = new int[2];
            int corners = 0;
            for (int i = 0; i < points.length && corners < 2; ++i) {
                if (DBMath.pointInsideRect(points[i], poly1.getBounds2D()) || DBMath.pointInsideRect(points[i], poly2.getBounds2D())) continue;
                cornerPoints[corners++] = i;
            }
            if (corners != 2) {
                throw new Error("Wrong corners in Quick.foundSmallSizeDefect()");
            }
            pt1 = points[cornerPoints[0]];
            pt2 = points[cornerPoints[1]];
            double d = delta = (pt2.getY() - pt1.getY()) / (pt2.getX() - pt1.getX()) > 0.0 ? 1.0 : -1.0;
            if (pt1.getX() < pt2.getX()) {
                pt1d = new Point2D.Double(pt1.getX() - TINYDELTA, -delta * TINYDELTA + pt1.getY());
                pt2d = new Point2D.Double(pt2.getX() + TINYDELTA, delta * TINYDELTA + pt2.getY());
            } else {
                pt1d = new Point2D.Double(pt2.getX() - TINYDELTA, -delta * TINYDELTA + pt2.getY());
                pt2d = new Point2D.Double(pt1.getX() + TINYDELTA, delta * TINYDELTA + pt1.getY());
            }
        }
        if (DBMath.areEquals(pt1.getX(), pt2.getX()) || DBMath.areEquals(pt1.getY(), pt2.getY())) {
            return false;
        }
        this.lookForLayerNew(geom1, poly1, geom2, poly2, cell, layer1, DBMath.MATID, search, pt1d, pt2d, null, pointsFound, false);
        if (!pointsFound[0] && !pointsFound[1]) {
            foundError = true;
        }
        return foundError;
    }

    private boolean mayTouch(Technology tech, boolean con, Layer layer1, Layer layer2) {
        boolean maytouch = false;
        if (tech.sameLayer(layer1, layer2)) {
            Layer.Function fun = layer1.getFunction();
            if (con) {
                if (!fun.isContact()) {
                    maytouch = true;
                }
            } else if (fun.isSubstrate()) {
                maytouch = true;
            } else {
                int funExtras = layer1.getFunctionExtras();
                if (fun.isDiff() && (funExtras & 0x800000) != 0) {
                    if (Job.LOCALDEBUGFLAG) {
                        System.out.println("Thick active found in Quick.checkDist");
                    }
                    maytouch = true;
                }
            }
        }
        return maytouch;
    }

    private boolean checkDist(Technology tech, Cell cell, int globalIndex, Poly poly1, Layer layer1, int net1, Geometric geom1, AffineTransform trans1, int globalIndex1, Poly poly2, Layer layer2, int net2, Geometric geom2, AffineTransform trans2, int globalIndex2, boolean con, DRCTemplate theRule, boolean edge) {
        Rectangle2D isBox2;
        Rectangle2D trueBox2;
        this.tinyNodeInst = null;
        Poly origPoly1 = poly1;
        Poly origPoly2 = poly2;
        Rectangle2D isBox1 = poly1.getBox();
        Rectangle2D trueBox1 = isBox1;
        if (trueBox1 == null) {
            trueBox1 = poly1.getBounds2D();
        }
        if ((trueBox2 = (isBox2 = poly2.getBox())) == null) {
            trueBox2 = poly2.getBounds2D();
        }
        boolean errorFound = false;
        boolean maytouch = this.mayTouch(tech, con, layer1, layer2);
        double pd = 0.0;
        boolean overlap = false;
        if (isBox1 != null && isBox2 != null) {
            double pdx = Math.max(trueBox2.getMinX() - trueBox1.getMaxX(), trueBox1.getMinX() - trueBox2.getMaxX());
            double pdy = Math.max(trueBox2.getMinY() - trueBox1.getMaxY(), trueBox1.getMinY() - trueBox2.getMaxY());
            pd = DBMath.round(Math.max(pdx, pdy));
            if (DBMath.areEquals(pdx, 0.0) && DBMath.areEquals(pdy, 0.0)) {
                pd = 0.0;
            }
            boolean bl = overlap = pd < 0.0;
            if (maytouch && this.checkMinDefects(cell, maytouch, geom1, poly1, trueBox1, layer2, geom2, poly2, trueBox2, layer2, cell)) {
                if (this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
                    return true;
                }
                errorFound = true;
            }
            trueBox1 = new Rectangle2D.Double(trueBox1.getMinX(), trueBox1.getMinY(), trueBox1.getWidth(), trueBox1.getHeight());
            trueBox2 = new Rectangle2D.Double(trueBox2.getMinX(), trueBox2.getMinY(), trueBox2.getWidth(), trueBox2.getHeight());
            boolean geom1IsNode = geom1 instanceof NodeInst;
            boolean geom2IsNode = geom2 instanceof NodeInst;
            if (!geom1IsNode && this.cropArcInst((ArcInst)geom1, layer1, trans1, trueBox1, overlap)) {
                return errorFound;
            }
            if (!geom2IsNode && this.cropArcInst((ArcInst)geom2, layer2, trans2, trueBox2, overlap)) {
                return errorFound;
            }
            if (geom1IsNode && this.cropNodeInst((NodeInst)geom1, globalIndex1, trans1, layer2, net2, geom2, trueBox2)) {
                return errorFound;
            }
            if (geom2 instanceof NodeInst && this.cropNodeInst((NodeInst)geom2, globalIndex2, trans2, layer1, net1, geom1, trueBox1)) {
                return errorFound;
            }
            poly1 = new Poly(trueBox1);
            poly1.setStyle(Poly.Type.FILLED);
            poly2 = new Poly(trueBox2);
            poly2.setStyle(Poly.Type.FILLED);
            double lX1 = trueBox1.getMinX();
            double hX1 = trueBox1.getMaxX();
            double lY1 = trueBox1.getMinY();
            double hY1 = trueBox1.getMaxY();
            double lX2 = trueBox2.getMinX();
            double hX2 = trueBox2.getMaxX();
            double lY2 = trueBox2.getMinY();
            double hY2 = trueBox2.getMaxY();
            if (edge) {
                double pdedge = Math.min(Math.min(Math.min(Math.abs(lX1 - lX2), Math.abs(lX1 - hX2)), Math.min(Math.abs(hX1 - lX2), Math.abs(hX1 - hX2))), Math.min(Math.min(Math.abs(lY1 - lY2), Math.abs(lY1 - hY2)), Math.min(Math.abs(hY1 - lY2), Math.abs(hY1 - hY2))));
                pd = Math.max(pd, pdedge);
            } else {
                pdx = Math.max(lX2 - hX1, lX1 - hX2);
                pdy = Math.max(lY2 - hY1, lY1 - hY2);
                if (pdx == 0.0 && pdy == 0.0) {
                    pd = 0.0;
                } else {
                    pd = DBMath.round(Math.max(pdx, pdy));
                    if (pd < theRule.getValue(0) && pd > 0.0) {
                        pd = poly1.separation(poly2);
                    }
                }
            }
        } else {
            Poly.Type style = poly1.getStyle();
            if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
                return errorFound;
            }
            style = poly2.getStyle();
            if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
                return errorFound;
            }
            double pd1 = poly1.separation(poly2);
            if (pd1 != (pd = poly1.intersects(poly2) ? 0.0 : poly1.separation(poly2))) {
                System.out.println("Wrong case in non-nonmanhattan, Quick.");
            }
        }
        DRCErrorType errorType = DRCErrorType.SPACINGERROR;
        if (theRule.ruleType == DRCTemplate.DRCRuleType.SURROUND) {
            if (pd > 0.0) {
                return errorFound;
            }
            pd = Math.abs(pd);
            errorType = DRCErrorType.SURROUNDERROR;
        }
        if (!DBMath.isGreaterThan(theRule.getValue(0), pd)) {
            return errorFound;
        }
        if (theRule.ruleType != DRCTemplate.DRCRuleType.SURROUND) {
            if (this.activeOnTransistor(poly1, layer1, net1, poly2, layer2, net2, cell, globalIndex)) {
                return errorFound;
            }
            if (tech.polyCoverByAnyVTLayer(cell, theRule, tech, new Poly[]{poly1, poly2}, new Layer[]{layer1, layer2}, new Geometric[]{geom1, geom2}, this.ignoreCenterCuts)) {
                return errorFound;
            }
            if (tech.sameLayer(layer1, layer2) && maytouch) {
                if (pd <= 0.0) {
                    return errorFound;
                }
                boolean newR = this.lookForCrossPolygons(geom1, poly1, geom2, poly2, layer1, cell, overlap);
                if (Job.LOCALDEBUGFLAG) {
                    boolean oldR;
                    Point2D.Double pt1 = new Point2D.Double();
                    Point2D.Double pt2 = new Point2D.Double();
                    int intervening = this.findInterveningPoints(poly1, poly2, pt1, pt2, false);
                    if (intervening == 0 && !newR) {
                        System.out.println("DIfferent");
                        this.lookForCrossPolygons(geom1, poly1, geom2, poly2, layer1, cell, overlap);
                    }
                    boolean needBoth = true;
                    if (intervening == 1) {
                        needBoth = false;
                    }
                    if (this.lookForPoints(pt1, pt2, layer1, cell, needBoth) && !newR) {
                        System.out.println("DIfferent");
                        this.lookForPoints(pt1, pt2, layer1, cell, needBoth);
                        this.lookForCrossPolygons(geom1, poly1, geom2, poly2, layer1, cell, overlap);
                    }
                    if ((oldR = this.lookForPoints(pt1, pt2, layer1, cell, needBoth)) != newR) {
                        System.out.println("DIfferent 2");
                    }
                }
                if (newR) {
                    return errorFound;
                }
                errorType = DRCErrorType.NOTCHERROR;
            }
        }
        String msg = null;
        if (!(this.tinyNodeInst == null || this.tinyNodeInst != geom1 && this.tinyNodeInst != geom2 || this.tinyGeometric != geom1 && this.tinyGeometric != geom2)) {
            msg = this.tinyNodeInst + " is too small for the " + this.tinyGeometric;
        }
        this.reportError(errorType, msg, cell, theRule.getValue(0), pd, theRule.ruleName, origPoly1, geom1, layer1, origPoly2, geom2, layer2);
        return true;
    }

    private void checkTheseGeometrics(Cell cell, int count, Geometric[] geomsToCheck, boolean[] validity) {
        CheckProto cp = this.getCheckProto(cell);
        for (int i = 0; i < count; ++i) {
            Geometric geomToCheck = geomsToCheck[i];
            boolean errors = false;
            if (geomToCheck instanceof NodeInst) {
                NodeInst ni = (NodeInst)geomToCheck;
                errors = ni.isCellInstance() ? this.checkThisCellPlease(ni) : this.checkNodeInst(ni, 0);
            } else {
                ArcInst ai = (ArcInst)geomToCheck;
                errors = this.checkArcInst(cp, ai, 0);
            }
            if (validity == null) continue;
            validity[i] = !errors;
        }
    }

    private boolean checkThisCellPlease(NodeInst ni) {
        Cell cell = ni.getParent();
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        int globalIndex = 0;
        AffineTransform upTrans = ni.translateOut(ni.rotateOut());
        CheckInst ci = this.checkInsts.get(ni);
        if (ci == null) {
            return false;
        }
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        Rectangle2D nodeBounds = ni.getBounds();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(nodeBounds.getMinX() - this.worstInteractionDistance, nodeBounds.getMinY() - this.worstInteractionDistance, nodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nodeBounds.getHeight() + this.worstInteractionDistance * 2.0);
        Iterator<RTBounds> it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            Rectangle2D subNodeBounds;
            Rectangle2D.Double subBounds;
            NodeInst oNi;
            Geometric geom = (Geometric)it.next();
            if (geom == ni || !(geom instanceof ArcInst ? this.checkGeomAgainstInstance(netlist, geom, ni) : ((oNi = (NodeInst)geom).getProto() instanceof PrimitiveNode ? this.checkGeomAgainstInstance(netlist, geom, ni) : this.checkCellInstContents(subBounds = new Rectangle2D.Double((subNodeBounds = oNi.getBounds()).getMinX() - this.worstInteractionDistance, subNodeBounds.getMinY() - this.worstInteractionDistance, subNodeBounds.getWidth() + this.worstInteractionDistance * 2.0, subNodeBounds.getHeight() + this.worstInteractionDistance * 2.0), ni, upTrans, localIndex, oNi, null, globalIndex, null)))) continue;
            return true;
        }
        return false;
    }

    private boolean checkGeomAgainstInstance(Netlist netlist, Geometric geom, NodeInst ni) {
        NodeProto np = ni.getProto();
        int globalIndex = 0;
        Cell subCell = geom.getParent();
        boolean baseMulti = false;
        Technology tech = null;
        Poly[] nodeInstPolyList = null;
        AffineTransform trans = DBMath.MATID;
        if (geom instanceof NodeInst) {
            NodeInst oNi = (NodeInst)geom;
            if (NodeInst.isSpecialNode(oNi)) {
                return false;
            }
            tech = oNi.getProto().getTechnology();
            trans = oNi.rotateOut();
            nodeInstPolyList = tech.getShapeOfNode(oNi, true, this.ignoreCenterCuts, null);
            this.convertPseudoLayers(oNi, nodeInstPolyList);
            baseMulti = tech.isMultiCutCase(oNi);
        } else {
            ArcInst oAi = (ArcInst)geom;
            tech = oAi.getProto().getTechnology();
            nodeInstPolyList = tech.getShapeOfArc(oAi);
        }
        if (nodeInstPolyList == null) {
            return false;
        }
        int tot = nodeInstPolyList.length;
        CheckInst ci = this.checkInsts.get(ni);
        if (ci == null) {
            return false;
        }
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        for (int j = 0; j < tot; ++j) {
            int net;
            double maxSize;
            double bound;
            Poly poly = nodeInstPolyList[j];
            Layer polyLayer = poly.getLayer();
            if (polyLayer == null || (bound = DRC.getMaxSurround(polyLayer, maxSize = poly.getMaxSize())) < 0.0) continue;
            if (geom instanceof NodeInst) {
                net = this.getDRCNetNumber(netlist, poly.getPort(), (NodeInst)geom, globalIndex);
            } else {
                ArcInst oAi = (ArcInst)geom;
                Network jNet = netlist.getNetwork(oAi, 0);
                Integer[] netNumbers = this.networkLists.get(jNet);
                net = netNumbers[globalIndex];
            }
            Rectangle2D polyBounds = poly.getBounds2D();
            Rectangle2D.Double subBounds = new Rectangle2D.Double(polyBounds.getMinX() - bound, polyBounds.getMinY() - bound, polyBounds.getWidth() + bound * 2.0, polyBounds.getHeight() + bound * 2.0);
            AffineTransform tempTrans = ni.rotateIn();
            AffineTransform tTransI = ni.translateIn();
            tempTrans.preConcatenate(tTransI);
            DBMath.transformRect(subBounds, tempTrans);
            AffineTransform subTrans = ni.translateOut(ni.rotateOut());
            if (!this.badBoxInArea(poly, polyLayer, tech, net, geom, trans, globalIndex, subBounds, (Cell)np, localIndex, subCell, globalIndex, subTrans, baseMulti, false)) continue;
            return true;
        }
        return false;
    }

    private boolean checkInteraction(NodeInst ni1, NodeInst n1Parent, NodeInst ni2, NodeInst n2Parent, NodeInst triggerNi) {
        if (this.errorTypeSearch == DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE) {
            return false;
        }
        CheckProto cp = this.getCheckProto((Cell)ni1.getProto());
        if (cp.cellParameterized) {
            return false;
        }
        cp = this.getCheckProto((Cell)ni2.getProto());
        if (cp.cellParameterized) {
            return false;
        }
        InstanceInter dii = new InstanceInter();
        if (ni1.getNodeIndex() < ni2.getNodeIndex()) {
            NodeInst swapni = ni1;
            ni1 = ni2;
            ni2 = swapni;
        } else if (ni1 == ni2) {
            int node1Orientation = ni1.getAngle();
            if (ni1.isMirroredAboutXAxis()) {
                node1Orientation += 3600;
            }
            if (ni1.isMirroredAboutYAxis()) {
                node1Orientation += 7200;
            }
            int node2Orientation = ni2.getAngle();
            if (ni2.isMirroredAboutXAxis()) {
                node2Orientation += 3600;
            }
            if (ni2.isMirroredAboutYAxis()) {
                node2Orientation += 7200;
            }
            if (node1Orientation < node2Orientation) {
                NodeInst swapNI = ni1;
                ni1 = ni2;
                ni2 = swapNI;
                System.out.println("Check this case in Quick.checkInteraction");
            }
        }
        dii.cell1 = (Cell)ni1.getProto();
        dii.or1 = ni1.getOrient();
        dii.cell2 = (Cell)ni2.getProto();
        dii.or2 = ni2.getOrient();
        dii.dx = ni2.getAnchorCenterX() - ni1.getAnchorCenterX();
        dii.dy = ni2.getAnchorCenterY() - ni1.getAnchorCenterY();
        dii.n1Parent = n1Parent;
        dii.n2Parent = n2Parent;
        dii.triggerNi = triggerNi;
        if (this.findInteraction(dii)) {
            return true;
        }
        this.instanceInteractionList.add(dii);
        return false;
    }

    private boolean findInteraction(InstanceInter dii) {
        for (InstanceInter thisII : this.instanceInteractionList) {
            if (thisII.cell1 != dii.cell1 || thisII.cell2 != dii.cell2 || !thisII.or1.equals(dii.or1) || !thisII.or2.equals(dii.or2) || thisII.dx != dii.dx || thisII.dy != dii.dy || thisII.n1Parent != dii.n1Parent || thisII.n2Parent != dii.n2Parent || dii.triggerNi != thisII.triggerNi) continue;
            return true;
        }
        return false;
    }

    private CheckProto checkEnumerateProtos(Cell cell, Netlist netlist) {
        CheckProto cp = this.getCheckProto(cell);
        if (cp != null) {
            return cp;
        }
        cp = new CheckProto();
        cp.instanceCount = 0;
        cp.timeStamp = 0;
        cp.hierInstanceCount = 0;
        cp.totalPerCell = 0;
        cp.cellChecked = false;
        cp.cellParameterized = false;
        cp.treeParameterized = false;
        cp.netlist = netlist;
        if (cell.getParameters().hasNext()) {
            cp.cellParameterized = true;
            cp.treeParameterized = true;
        }
        this.checkProtos.put(cell, cp);
        Iterator<NodeInst> nIt = cell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            Cell subCell = (Cell)ni.getProto();
            CheckInst ci = new CheckInst();
            this.checkInsts.put(ni, ci);
            CheckProto subCP = this.checkEnumerateProtos(subCell, netlist.getNetlist(ni));
            if (!subCP.treeParameterized) continue;
            cp.treeParameterized = true;
        }
        return cp;
    }

    private final CheckProto getCheckProto(Cell cell) {
        return this.checkProtos.get(cell);
    }

    private void checkEnumerateInstances(Cell cell) {
        NodeProto np;
        NodeInst ni;
        if (this.job != null && this.job.checkAbort()) {
            return;
        }
        ++this.checkTimeStamp;
        ArrayList<CheckProto> subCheckProtos = new ArrayList<CheckProto>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            np = ni.getProto();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            CheckProto cp = this.getCheckProto((Cell)np);
            if (cp.timeStamp != this.checkTimeStamp) {
                cp.timeStamp = this.checkTimeStamp;
                cp.instanceCount = 0;
                cp.nodesInCell = new ArrayList<CheckInst>();
                subCheckProtos.add(cp);
            }
            CheckInst ci = this.checkInsts.get(ni);
            ++cp.instanceCount;
            ci.localIndex = ci.localIndex;
            cp.nodesInCell.add(ci);
        }
        for (CheckProto cp : subCheckProtos) {
            cp.hierInstanceCount += cp.instanceCount;
            for (CheckInst ci : cp.nodesInCell) {
                ci.multiplier = cp.instanceCount;
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            np = ni.getProto();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            this.checkEnumerateInstances((Cell)np);
        }
    }

    private void checkEnumerateNetworks(Cell cell, CheckProto cp, int globalIndex, HashMap<Network, Integer> enumeratedNets) {
        Iterator<Network> nIt = cp.netlist.getNetworks();
        while (nIt.hasNext()) {
            Network net = nIt.next();
            Integer netNumber = enumeratedNets.get(net);
            Integer[] netNumbers = this.networkLists.get(net);
            netNumbers[globalIndex] = netNumber;
        }
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            CheckInst ci = this.checkInsts.get(ni);
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            Cell subCell = (Cell)np;
            CheckProto subCP = this.getCheckProto(subCell);
            HashMap<Network, Integer> subEnumeratedNets = new HashMap<Network, Integer>();
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                Export subPP = (Export)pi.getPortProto();
                Network net = cp.netlist.getNetwork(ni, subPP, 0);
                if (net == null) continue;
                Integer netNumber = enumeratedNets.get(net);
                Network subNet = subCP.netlist.getNetwork(subPP, 0);
                subEnumeratedNets.put(subNet, netNumber);
            }
            Iterator<Network> nIt2 = subCP.netlist.getNetworks();
            while (nIt2.hasNext()) {
                Network net = nIt2.next();
                if (subEnumeratedNets.get(net) != null) continue;
                subEnumeratedNets.put(net, new Integer(this.checkNetNumber++));
            }
            this.checkEnumerateNetworks(subCell, subCP, localIndex, subEnumeratedNets);
        }
    }

    private boolean checkExtensionWithNeighbors(Cell cell, Geometric geom, Poly poly, Layer layer, Rectangle2D bounds, DRCTemplate minWidthRule, int dir, boolean onlyOne) {
        Point2D.Double right3;
        Point2D.Double right2;
        Point2D.Double right1;
        Point2D.Double left3;
        Point2D.Double left2;
        Point2D.Double left1;
        double actual = 0.0;
        String msg = "";
        if (dir == 0) {
            actual = bounds.getWidth();
            msg = "(X axis)";
            double leftW = bounds.getMinX() - TINYDELTA;
            left1 = new Point2D.Double(leftW, bounds.getMinY());
            left2 = new Point2D.Double(leftW, bounds.getMaxY());
            left3 = new Point2D.Double(leftW, bounds.getCenterY());
            double rightW = bounds.getMaxX() + TINYDELTA;
            right1 = new Point2D.Double(rightW, bounds.getMinY());
            right2 = new Point2D.Double(rightW, bounds.getMaxY());
            right3 = new Point2D.Double(rightW, bounds.getCenterY());
        } else {
            actual = bounds.getHeight();
            msg = "(Y axis)";
            double leftH = bounds.getMinY() - TINYDELTA;
            left1 = new Point2D.Double(bounds.getMinX(), leftH);
            left2 = new Point2D.Double(bounds.getMaxX(), leftH);
            left3 = new Point2D.Double(bounds.getCenterX(), leftH);
            double rightH = bounds.getMaxY() + TINYDELTA;
            right1 = new Point2D.Double(bounds.getMinX(), rightH);
            right2 = new Point2D.Double(bounds.getMaxX(), rightH);
            right3 = new Point2D.Double(bounds.getCenterX(), rightH);
        }
        boolean[] pointsFound = new boolean[3];
        pointsFound[2] = false;
        pointsFound[1] = false;
        pointsFound[0] = false;
        Rectangle2D.Double newBounds = new Rectangle2D.Double(bounds.getMinX() - TINYDELTA, bounds.getMinY() - TINYDELTA, bounds.getWidth() + TINYDELTA * 2.0, bounds.getHeight() + TINYDELTA * 2.0);
        boolean zeroWide = bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0;
        boolean overlapLayer = this.lookForLayer(poly, cell, layer, DBMath.MATID, newBounds, left1, left2, left3, pointsFound);
        if (overlapLayer) {
            return false;
        }
        pointsFound[2] = false;
        pointsFound[1] = false;
        pointsFound[0] = false;
        overlapLayer = this.lookForLayer(poly, cell, layer, DBMath.MATID, newBounds, right1, right2, right3, pointsFound);
        if (overlapLayer) {
            return false;
        }
        DRCErrorType errorType = DRCErrorType.MINWIDTHERROR;
        String extraMsg = msg;
        String rule = minWidthRule.ruleName;
        if (zeroWide) {
            if (overlapLayer) {
                extraMsg = " but covered by other layer";
            }
            errorType = DRCErrorType.ZEROLENGTHARCWARN;
            rule = null;
        }
        this.reportError(errorType, extraMsg, cell, minWidthRule.getValue(0), actual, rule, onlyOne ? null : poly, geom, layer, null, null, null);
        return !overlapLayer;
    }

    private boolean checkMinWidth(Geometric geom, Layer layer, Poly poly, boolean onlyOne) {
        Cell cell = geom.getParent();
        DRCTemplate minWidthRule = DRC.getMinValue(layer, DRCTemplate.DRCRuleType.MINWID);
        if (minWidthRule == null) {
            return false;
        }
        double minWidthValue = minWidthRule.getValue(0);
        Rectangle2D bounds = poly.getBox();
        if (bounds != null) {
            boolean tooSmallWidth = DBMath.isGreaterThan(minWidthValue, bounds.getWidth());
            boolean tooSmallHeight = DBMath.isGreaterThan(minWidthValue, bounds.getHeight());
            if (!tooSmallWidth && !tooSmallHeight) {
                return false;
            }
            boolean foundError = false;
            if (tooSmallWidth && this.checkExtensionWithNeighbors(cell, geom, poly, layer, bounds, minWidthRule, 0, onlyOne)) {
                foundError = true;
            }
            if (tooSmallHeight && this.checkExtensionWithNeighbors(cell, geom, poly, layer, bounds, minWidthRule, 1, onlyOne)) {
                foundError = true;
            }
            return foundError;
        }
        Poly.Type style = poly.getStyle();
        if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
            return false;
        }
        bounds = poly.getBounds2D();
        double actual = Math.min(bounds.getWidth(), bounds.getHeight());
        if (actual < minWidthValue) {
            this.reportError(DRCErrorType.MINWIDTHERROR, null, cell, minWidthValue, actual, minWidthRule.ruleName, onlyOne ? null : poly, geom, layer, null, null, null);
            return true;
        }
        Point2D[] points = poly.getPoints();
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            Point2D to;
            Point2D from = i == 0 ? points[count - 1] : points[i - 1];
            if (from.equals(to = points[i])) continue;
            double ang = DBMath.figureAngleRadians(from, to);
            Point2D.Double center = new Point2D.Double((from.getX() + to.getX()) / 2.0, (from.getY() + to.getY()) / 2.0);
            double perpang = ang + 1.5707963267948966;
            for (int j = 0; j < count; ++j) {
                double fdy;
                double fdx;
                Point2D inter;
                double rOAng;
                double rAng;
                Point2D oTo;
                Point2D oFrom;
                if (j == i || (oFrom = j == 0 ? points[count - 1] : points[j - 1]).equals(oTo = points[j])) continue;
                double oAng = DBMath.figureAngleRadians(oFrom, oTo);
                for (rAng = ang; rAng > Math.PI; rAng -= Math.PI) {
                }
                for (rOAng = oAng; rOAng > Math.PI; rOAng -= Math.PI) {
                }
                if (DBMath.doublesEqual(rAng, rOAng) && (DBMath.isOnLine(from, to, oFrom) || DBMath.isOnLine(from, to, oTo) || DBMath.isOnLine(oFrom, oTo, from) || DBMath.isOnLine(oFrom, oTo, to)) || (inter = DBMath.intersectRadians(center, perpang, oFrom, oAng)) == null || inter.getX() < Math.min(oFrom.getX(), oTo.getX()) || inter.getX() > Math.max(oFrom.getX(), oTo.getX()) || inter.getY() < Math.min(oFrom.getY(), oTo.getY()) || inter.getY() > Math.max(oFrom.getY(), oTo.getY()) || !((actual = DBMath.round(Math.sqrt((fdx = ((Point2D)center).getX() - inter.getX()) * fdx + (fdy = ((Point2D)center).getY() - inter.getY()) * fdy))) < minWidthValue)) continue;
                if (poly.isInside(new Point2D.Double((((Point2D)center).getX() + inter.getX()) / 2.0, (((Point2D)center).getY() + inter.getY()) / 2.0))) {
                    this.reportError(DRCErrorType.MINWIDTHERROR, null, cell, minWidthValue, actual, minWidthRule.ruleName, onlyOne ? null : poly, geom, layer, null, null, null);
                } else {
                    this.reportError(DRCErrorType.NOTCHERROR, null, cell, minWidthValue, actual, minWidthRule.ruleName, onlyOne ? null : poly, geom, layer, poly, geom, layer);
                }
                return true;
            }
        }
        return false;
    }

    private int checkMinAreaLayer(GeometryHandler merge, Cell cell, Layer layer, boolean addError, HashMap<Layer, Layer> minAreaLayerMapDone, HashMap<Layer, Layer> enclosedAreaLayerMapDone) {
        int errorFound = 0;
        DRCTemplate minAreaRule = this.minAreaLayerMap.get(layer);
        DRCTemplate encloseAreaRule = this.enclosedAreaLayerMap.get(layer);
        DRCTemplate slotSizeRule = this.slotSizeLayerMap.get(layer);
        if (minAreaRule == null && encloseAreaRule == null && slotSizeRule == null) {
            return 0;
        }
        Collection<PolyBase> set = merge.getObjects(layer, false, true);
        if (set == null) {
            return 0;
        }
        boolean minAreaDone = true;
        boolean enclosedAreaDone = true;
        for (PolyBase obj : set) {
            if (obj == null) {
                throw new Error("wrong condition in Quick.checkMinArea()");
            }
            List<PolyBase> list = obj.getSortedLoops();
            DRCTemplate evenRule = list.size() % 2 == 0 ? encloseAreaRule : minAreaRule;
            DRCTemplate oddRule = evenRule == minAreaRule ? encloseAreaRule : minAreaRule;
            int i = 0;
            for (PolyBase listObj : list) {
                DRCErrorType errorType;
                double area = listObj.getArea();
                DRCTemplate minRule = i % 2 == 0 ? evenRule : oddRule;
                PolyBase simplePn = listObj;
                ++i;
                if (minRule == minAreaRule && slotSizeRule != null) {
                    double length = listObj.getMaxLength();
                    if (!DBMath.isGreaterThan(length, slotSizeRule.getValue(0))) continue;
                    if (addError) {
                        this.reportError(DRCErrorType.SLOTSIZEERROR, null, cell, slotSizeRule.getValue(0), length, slotSizeRule.ruleName, simplePn, null, layer, null, null, null);
                    }
                    ++errorFound;
                }
                if (minRule == null || !DBMath.isGreaterThan(minRule.getValue(0), area)) continue;
                ++errorFound;
                DRCErrorType dRCErrorType = errorType = minRule == minAreaRule ? DRCErrorType.MINAREAERROR : DRCErrorType.ENCLOSEDAREAERROR;
                if (errorType == DRCErrorType.MINAREAERROR) {
                    minAreaDone = false;
                } else if (errorType == DRCErrorType.ENCLOSEDAREAERROR) {
                    enclosedAreaDone = false;
                }
                if (!addError) continue;
                this.reportError(errorType, null, cell, minRule.getValue(0), area, minRule.ruleName, simplePn, null, layer, null, null, null);
            }
        }
        if (minAreaDone && minAreaLayerMapDone != null) {
            minAreaLayerMapDone.put(layer, layer);
        }
        if (enclosedAreaDone && enclosedAreaLayerMapDone != null) {
            enclosedAreaLayerMapDone.put(layer, layer);
        }
        return errorFound;
    }

    private int checkMinArea(Cell cell) {
        CheckProto cp = this.getCheckProto(cell);
        int errorFound = 0;
        if (this.minAreaLayerMap.isEmpty() && this.enclosedAreaLayerMap.isEmpty()) {
            return 0;
        }
        GeometryHandler selectMerge = GeometryHandler.createGeometryHandler(this.mergeMode, 0);
        HashMap<NodeInst, NodeInst> notExportedNodes = new HashMap<NodeInst, NodeInst>();
        HashMap<NodeInst, NodeInst> checkedNodes = new HashMap<NodeInst, NodeInst>();
        errorFound = this.errorLogger.getNumErrors();
        QuickAreaEnumerator quickArea = new QuickAreaEnumerator(cp.netlist, selectMerge, notExportedNodes, checkedNodes, this.mergeMode);
        quickArea.setPreProcessFlag(false);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, quickArea);
        if (this.job != null && this.job.checkAbort()) {
            return 0;
        }
        errorFound = this.errorLogger.getNumErrors() - errorFound;
        quickArea = new QuickAreaEnumerator(null, notExportedNodes, checkedNodes, this.mergeMode);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, quickArea);
        selectMerge.postProcess(true);
        for (Layer layer : selectMerge.getKeySet()) {
            errorFound += this.checkMinAreaLayer(selectMerge, cell, layer, true, null, null);
        }
        return errorFound;
    }

    private int findInterveningPoints(Poly poly1, Poly poly2, Point2D pt1, Point2D pt2, boolean newFix) {
        Rectangle2D isBox1 = poly1.getBox();
        Rectangle2D isBox2 = poly2.getBox();
        if (newFix) {
            if (isBox1 == null) {
                isBox1 = poly1.getBounds2D();
            }
            if (isBox2 == null) {
                isBox2 = poly2.getBounds2D();
            }
        }
        if (isBox1 != null && isBox2 != null) {
            if (isBox1.getMinX() > isBox2.getMaxX() || isBox2.getMinX() > isBox1.getMaxX()) {
                if (isBox1.getMinY() <= isBox2.getMaxY() && isBox2.getMinY() <= isBox1.getMaxY()) {
                    double yf1 = Math.max(isBox1.getMinY(), isBox2.getMinY());
                    double yf2 = Math.min(isBox1.getMaxY(), isBox2.getMaxY());
                    if (isBox1.getMinX() > isBox2.getMaxX()) {
                        double x = (isBox1.getMinX() + isBox2.getMaxX()) / 2.0;
                        pt1.setLocation(x, yf1);
                        pt2.setLocation(x, yf2);
                    } else {
                        double x = (isBox2.getMinX() + isBox1.getMaxX()) / 2.0;
                        pt1.setLocation(x, yf1);
                        pt2.setLocation(x, yf2);
                    }
                    return 2;
                }
            } else if (isBox1.getMinY() > isBox2.getMaxY() || isBox2.getMinY() > isBox1.getMaxY()) {
                if (isBox1.getMinX() <= isBox2.getMaxX() && isBox2.getMinX() <= isBox1.getMaxX()) {
                    double xf1 = Math.max(isBox1.getMinX(), isBox2.getMinX());
                    double xf2 = Math.min(isBox1.getMaxX(), isBox2.getMaxX());
                    if (isBox1.getMinY() > isBox2.getMaxY()) {
                        double y = (isBox1.getMinY() + isBox2.getMaxY()) / 2.0;
                        pt1.setLocation(xf1, y);
                        pt2.setLocation(xf2, y);
                    } else {
                        double y = (isBox2.getMinY() + isBox1.getMaxY()) / 2.0;
                        pt1.setLocation(xf1, y);
                        pt2.setLocation(xf2, y);
                    }
                    return 2;
                }
            } else if (isBox1.getMinX() == isBox2.getMaxX() || isBox2.getMinX() == isBox1.getMaxX() || isBox1.getMinY() == isBox2.getMaxY() || isBox2.getMinY() == isBox2.getMaxY()) {
                double xc = isBox2.getMinX();
                if (isBox1.getMinX() == isBox2.getMaxX()) {
                    xc = isBox1.getMinX();
                }
                double yc = isBox2.getMinY();
                if (isBox1.getMinY() == isBox2.getMaxY()) {
                    yc = isBox1.getMinY();
                }
                double xPlus = xc + TINYDELTA;
                double yPlus = yc + TINYDELTA;
                pt1.setLocation(xPlus, yPlus);
                pt2.setLocation(xPlus, yPlus);
                if ((xPlus < isBox1.getMinX() || xPlus > isBox1.getMaxX() || yPlus < isBox1.getMinY() || yPlus > isBox1.getMaxY()) && (xPlus < isBox2.getMinX() || xPlus > isBox2.getMaxX() || yPlus < isBox2.getMinY() || yPlus > isBox2.getMaxY())) {
                    return 1;
                }
                pt1.setLocation(xc + TINYDELTA, yc - TINYDELTA);
                pt2.setLocation(xc - TINYDELTA, yc + TINYDELTA);
                return 1;
            }
            if (isBox1.getMinX() > isBox2.getMaxX()) {
                if (isBox1.getMinY() > isBox2.getMaxY()) {
                    pt1.setLocation(isBox1.getMinX(), isBox1.getMinY());
                    pt2.setLocation(isBox2.getMaxX(), isBox2.getMaxY());
                    return 1;
                }
                if (isBox2.getMinY() > isBox1.getMaxY()) {
                    pt1.setLocation(isBox1.getMinX(), isBox1.getMaxY());
                    pt2.setLocation(isBox2.getMaxX(), isBox2.getMinY());
                    return 1;
                }
            }
            if (isBox2.getMinX() > isBox1.getMaxX()) {
                if (isBox1.getMinY() > isBox2.getMaxY()) {
                    pt1.setLocation(isBox1.getMaxX(), isBox1.getMinY());
                    pt2.setLocation(isBox2.getMinX(), isBox2.getMaxY());
                    return 1;
                }
                if (isBox2.getMinY() > isBox1.getMaxY()) {
                    pt1.setLocation(isBox1.getMaxX(), isBox1.getMaxY());
                    pt2.setLocation(isBox2.getMinX(), isBox2.getMinY());
                    return 1;
                }
            }
        }
        isBox1 = poly1.getBounds2D();
        isBox2 = poly2.getBounds2D();
        pt1.setLocation((isBox1.getMinX() + isBox1.getMaxX()) / 2.0, (isBox2.getMinY() + isBox2.getMaxY()) / 2.0);
        pt2.setLocation((isBox2.getMinX() + isBox2.getMaxX()) / 2.0, (isBox1.getMinY() + isBox1.getMaxY()) / 2.0);
        return 1;
    }

    private boolean lookForPoints(Point2D pt1, Point2D pt2, Layer layer, Cell cell, boolean needBoth) {
        Point2D.Double pt3 = new Point2D.Double((pt1.getX() + pt2.getX()) / 2.0, (pt1.getY() + pt2.getY()) / 2.0);
        double flx = Math.min(pt1.getX(), pt2.getX());
        double fhx = Math.max(pt1.getX(), pt2.getX());
        double fly = Math.min(pt1.getY(), pt2.getY());
        double fhy = Math.max(pt1.getY(), pt2.getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(flx, fly, fhx - flx, fhy - fly);
        boolean[] pointsFound = new boolean[3];
        pointsFound[2] = false;
        pointsFound[1] = false;
        pointsFound[0] = false;
        boolean allFound = this.lookForLayer(null, cell, layer, DBMath.MATID, bounds, pt1, pt2, pt3, pointsFound);
        return needBoth ? allFound : pointsFound[0] || pointsFound[1];
    }

    private boolean lookForCrossPolygons(Geometric geo1, Poly poly1, Geometric geo2, Poly poly2, Layer layer, Cell cell, boolean overlap) {
        Point2D.Double pt1 = new Point2D.Double();
        Point2D.Double pt2 = new Point2D.Double();
        this.findInterveningPoints(poly1, poly2, pt1, pt2, true);
        double flx = Math.min(((Point2D)pt1).getX(), ((Point2D)pt2).getX());
        double fhx = Math.max(((Point2D)pt1).getX(), ((Point2D)pt2).getX());
        double fly = Math.min(((Point2D)pt1).getY(), ((Point2D)pt2).getY());
        double fhy = Math.max(((Point2D)pt1).getY(), ((Point2D)pt2).getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(DBMath.round(flx - TINYDELTA), DBMath.round(fly - TINYDELTA), DBMath.round(fhx - flx + 2.0 * TINYDELTA), DBMath.round(fhy - fly + 2.0 * TINYDELTA));
        boolean[] pointsFound = new boolean[2];
        pointsFound[1] = false;
        pointsFound[0] = false;
        boolean allFound = this.lookForLayerNew(geo1, poly1, geo2, poly2, cell, layer, DBMath.MATID, bounds, pt1, pt2, null, pointsFound, overlap);
        return allFound;
    }

    private boolean lookForLayer(Poly thisPoly, Cell cell, Layer layer, AffineTransform moreTrans, Rectangle2D bounds, Point2D pt1, Point2D pt2, Point2D pt3, boolean[] pointsFound) {
        boolean skip = false;
        Rectangle2D.Double newBounds = new Rectangle2D.Double();
        Iterator<RTBounds> it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            int j;
            RTBounds g = it.next();
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.isCellInstance()) {
                    AffineTransform rotI = ni.rotateIn();
                    AffineTransform transI = ni.translateIn();
                    rotI.preConcatenate(transI);
                    ((Rectangle2D)newBounds).setRect(bounds);
                    DBMath.transformRect(newBounds, rotI);
                    AffineTransform trans = ni.translateOut(ni.rotateOut());
                    trans.preConcatenate(moreTrans);
                    if (!this.lookForLayer(thisPoly, (Cell)ni.getProto(), layer, trans, newBounds, pt1, pt2, pt3, pointsFound)) continue;
                    return true;
                }
                AffineTransform bound = ni.rotateOut();
                bound.preConcatenate(moreTrans);
                Technology tech = ni.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfNode(ni, false, this.ignoreCenterCuts, null)) {
                    boolean newR;
                    if (!tech.sameLayer(poly.getLayer(), layer) || thisPoly != null && poly.polySame(thisPoly)) continue;
                    poly.transform(bound);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    boolean bl = newR = j == pointsFound.length;
                    if (!newR) continue;
                    return true;
                }
            } else {
                ArcInst ai = (ArcInst)g;
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai)) {
                    boolean newR;
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(moreTrans);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    boolean bl = newR = j == pointsFound.length;
                    if (!newR) continue;
                    return true;
                }
            }
            for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
            }
            if (j != pointsFound.length) continue;
            System.out.println("When?");
            return true;
        }
        if (skip) {
            System.out.println("This case in lookForLayerNew antes");
        }
        return false;
    }

    private boolean lookForLayerNew(Geometric geo1, Poly poly1, Geometric geo2, Poly poly2, Cell cell, Layer layer, AffineTransform moreTrans, Rectangle2D bounds, Point2D pt1, Point2D pt2, Point2D pt3, boolean[] pointsFound, boolean overlap) {
        Rectangle2D.Double newBounds = new Rectangle2D.Double();
        Iterator<RTBounds> it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            int j;
            RTBounds g = it.next();
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.isCellInstance()) {
                    AffineTransform rotI = ni.rotateIn();
                    AffineTransform transI = ni.translateIn();
                    rotI.preConcatenate(transI);
                    ((Rectangle2D)newBounds).setRect(bounds);
                    DBMath.transformRect(newBounds, rotI);
                    AffineTransform trans = ni.translateOut(ni.rotateOut());
                    trans.preConcatenate(moreTrans);
                    if (!this.lookForLayerNew(geo1, poly1, geo2, poly2, (Cell)ni.getProto(), layer, trans, newBounds, pt1, pt2, pt3, pointsFound, overlap)) continue;
                    return true;
                }
                AffineTransform bound = ni.rotateOut();
                bound.preConcatenate(moreTrans);
                Technology tech = ni.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfNode(ni, false, this.ignoreCenterCuts, null)) {
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(bound);
                    if (poly1 != null && !overlap && poly.polySame(poly1) || poly2 != null && !overlap && poly.polySame(poly2)) continue;
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    if (j == pointsFound.length) {
                        return true;
                    }
                    break;
                }
            } else {
                ArcInst ai = (ArcInst)g;
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai)) {
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(moreTrans);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    if (j == pointsFound.length) {
                        return true;
                    }
                    break;
                }
            }
            for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
            }
            if (j != pointsFound.length) continue;
            System.out.println("When?");
            return true;
        }
        return false;
    }

    private boolean checkCutSizes(NodeProto np, Geometric geom, Layer layer, Poly poly, Geometric nGeom, Layer nLayer, Poly nPoly, Cell topCell) {
        String ruleName;
        if (!(np instanceof PrimitiveNode && layer == nLayer && layer.getFunction().isContact() && nLayer.getFunction().isContact())) {
            return false;
        }
        PrimitiveNode nty = (PrimitiveNode)np;
        Technology.NodeLayer cutLayer = nty.findMulticut();
        if (cutLayer == null) {
            return false;
        }
        double cutSizeX = cutLayer.getMulticutSizeX();
        double cutSizeY = cutLayer.getMulticutSizeY();
        Rectangle2D box1 = poly.getBounds2D();
        Rectangle2D box2 = nPoly.getBounds2D();
        double pdx = Math.max(box2.getMinX() - box1.getMaxX(), box1.getMinX() - box2.getMaxX());
        double pdy = Math.max(box2.getMinY() - box1.getMaxY(), box1.getMinY() - box2.getMaxY());
        double pd = Math.max(pdx, pdy);
        if (pdx == 0.0 && pdy == 0.0) {
            pd = 0.0;
        }
        if (pd > 0.0) {
            return false;
        }
        boolean foundError = false;
        double minX = Math.min(box1.getMinX(), box2.getMinX());
        double minY = Math.min(box1.getMinY(), box2.getMinY());
        double maxX = Math.max(box1.getMaxX(), box2.getMaxX());
        double maxY = Math.max(box1.getMaxY(), box2.getMaxY());
        Rectangle2D.Double rect = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        DRCTemplate rule = DRC.getRules(nty.getTechnology()).getRule(layer.getIndex(), DRCTemplate.DRCRuleType.MINWID);
        String string = ruleName = rule != null ? rule.ruleName : "for contacts";
        if (DBMath.isGreaterThan(((RectangularShape)rect).getWidth(), cutSizeX)) {
            this.reportError(DRCErrorType.CUTERROR, "along X", topCell, cutSizeX, ((RectangularShape)rect).getWidth(), ruleName, new Poly(rect), null, layer, null, null, nLayer);
            foundError = true;
        }
        if (DBMath.isGreaterThan(((RectangularShape)rect).getHeight(), cutSizeY)) {
            this.reportError(DRCErrorType.CUTERROR, "along Y", topCell, cutSizeY, ((RectangularShape)rect).getHeight(), ruleName, new Poly(rect), null, layer, null, null, layer);
            foundError = true;
        }
        return foundError;
    }

    private boolean checkExtensionGateRule(Geometric geom, Layer layer, Poly poly, Layer nLayer, Poly nPoly, Netlist netlist) {
        return false;
    }

    private Poly[] getShapeOfGeometric(Geometric geom, Layer layer) {
        Poly[] primPolyList = null;
        Layer.Function.Set drcLayers = new Layer.Function.Set(layer.getFunction());
        if (geom instanceof NodeInst) {
            NodeInst ni = (NodeInst)geom;
            NodeProto np = ni.getProto();
            Technology tech = np.getTechnology();
            primPolyList = tech.getShapeOfNode(ni, true, this.ignoreCenterCuts, drcLayers);
        } else if (geom instanceof ArcInst) {
            ArcInst ai = (ArcInst)geom;
            primPolyList = ai.getProto().getTechnology().getShapeOfArc(ai, drcLayers);
        }
        return primPolyList;
    }

    private boolean checkExtensionRule(Geometric geom, Layer layer, Poly poly, Cell cell) {
        return false;
    }

    private void checkExtensionOverlapRule(Geometric geom, Layer layer, Cell cell, Area baseArea, Area extensionArea, Area overlapArea, Rectangle2D polyBnd) {
        Iterator<RTBounds> sIt = cell.searchIterator(polyBnd);
        while (sIt.hasNext()) {
            Geometric g = (Geometric)sIt.next();
            if (g == geom) continue;
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                NodeProto np = ni.getProto();
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.isCellInstance()) {
                    AffineTransform cellDownTrans = ni.transformIn();
                    AffineTransform cellUpTrans = ni.transformOut();
                    DBMath.transformRect(polyBnd, cellDownTrans);
                    extensionArea.transform(cellDownTrans);
                    overlapArea.transform(cellDownTrans);
                    this.checkExtensionOverlapRule(geom, layer, (Cell)np, baseArea, extensionArea, overlapArea, polyBnd);
                    DBMath.transformRect(polyBnd, cellUpTrans);
                    extensionArea.transform(cellUpTrans);
                    overlapArea.transform(cellUpTrans);
                    continue;
                }
            }
            for (Poly nPoly : this.getShapeOfGeometric(g, layer)) {
                Area nPolyArea = new Area(nPoly);
                Area interPolyArea = (Area)nPolyArea.clone();
                interPolyArea.intersect(baseArea);
                overlapArea.add(interPolyArea);
                Area extenPolyArea = (Area)nPolyArea.clone();
                extenPolyArea.subtract(interPolyArea);
                extensionArea.add(extenPolyArea);
            }
        }
    }

    private boolean checkSelectOverPolysilicon(Geometric geom, Layer layer, Poly poly, Cell cell) {
        if (DRC.isIgnoreExtensionRuleChecking()) {
            return false;
        }
        if (!layer.getFunction().isPoly()) {
            return false;
        }
        DRCTemplate minOverlapRule = DRC.getMinValue(layer, DRCTemplate.DRCRuleType.EXTENSION);
        if (minOverlapRule == null) {
            return false;
        }
        double minOverlapValue = minOverlapRule.getValue(0);
        Rectangle2D polyBnd = poly.getBounds2D();
        Area polyArea = new Area(poly);
        boolean found = polyArea.isEmpty();
        ArrayList<Point2D> checkExtraPoints = new ArrayList<Point2D>();
        if (!(found = this.checkThisCellExtensionRule(geom, layer, poly, null, cell, polyArea, polyBnd, minOverlapRule, found, checkExtraPoints))) {
            List<PolyBase> polyList = PolyBase.getPointsInArea(polyArea, layer, true, true, null);
            for (PolyBase nPoly : polyList) {
                this.reportError(DRCErrorType.LAYERSURROUNDERROR, "Polysilicon not covered, ", cell, minOverlapValue, -1.0, minOverlapRule.ruleName, nPoly, geom, layer, null, null, null);
            }
        } else {
            Point2D[] extraPoints = new Point2D[checkExtraPoints.size()];
            checkExtraPoints.toArray(extraPoints);
            boolean[] founds = new boolean[checkExtraPoints.size()];
            Arrays.fill(founds, false);
            Rectangle2D.Double ruleBnd = new Rectangle2D.Double(polyBnd.getMinX() - minOverlapValue, polyBnd.getMinY() - minOverlapValue, polyBnd.getWidth() + minOverlapValue * 2.0, polyBnd.getHeight() + minOverlapValue * 2.0);
            boolean foundAll = this.allPointsContainedInLayer(geom, cell, ruleBnd, null, extraPoints, founds);
            if (!foundAll) {
                this.reportError(DRCErrorType.LAYERSURROUNDERROR, "No enough surround, ", geom.getParent(), minOverlapValue, -1.0, minOverlapRule.ruleName, poly, geom, layer, null, null, null);
            }
        }
        return !found;
    }

    private boolean checkThisCellExtensionRule(Geometric geom, Layer layer, Poly poly, Layer.Function.Set drcLayers, Cell cell, Area polyArea, Rectangle2D polyBnd, DRCTemplate minOverlapRule, boolean found, List<Point2D> checkExtraPoints) {
        boolean[] founds = new boolean[4];
        Iterator<RTBounds> sIt = cell.searchIterator(polyBnd);
        while (!found && sIt.hasNext()) {
            RTBounds g = sIt.next();
            if (g == geom) continue;
            if (!(g instanceof NodeInst)) {
                if (!Job.LOCALDEBUGFLAG || DRC.isIgnoreExtensionRuleChecking()) continue;
                System.out.println("Skipping arcs!");
                continue;
            }
            NodeInst ni = (NodeInst)g;
            NodeProto np = ni.getProto();
            if (NodeInst.isSpecialNode(ni)) continue;
            if (ni.isCellInstance()) {
                AffineTransform cellDownTrans = ni.transformIn();
                AffineTransform cellUpTrans = ni.transformOut();
                DBMath.transformRect(polyBnd, cellDownTrans);
                polyArea.transform(cellDownTrans);
                poly.transform(cellDownTrans);
                ArrayList<Point2D> newExtraPoints = new ArrayList<Point2D>();
                found = this.checkThisCellExtensionRule(geom, layer, poly, drcLayers, (Cell)np, polyArea, polyBnd, minOverlapRule, found, newExtraPoints);
                for (Point2D point : newExtraPoints) {
                    cellUpTrans.transform(point, point);
                    checkExtraPoints.add(point);
                }
                DBMath.transformRect(polyBnd, cellUpTrans);
                polyArea.transform(cellUpTrans);
                poly.transform(cellUpTrans);
            } else {
                Technology tech = np.getTechnology();
                for (Poly nPoly : tech.getShapeOfNode(ni, true, this.ignoreCenterCuts, drcLayers)) {
                    if (drcLayers == null && !nPoly.getLayer().getFunction().isImplant()) continue;
                    Area distPolyArea = (Area)polyArea.clone();
                    Area nPolyArea = new Area(nPoly);
                    polyArea.subtract(nPolyArea);
                    distPolyArea.subtract(polyArea);
                    if (distPolyArea.isEmpty()) continue;
                    Rectangle2D interRect = distPolyArea.getBounds2D();
                    Rectangle2D.Double ruleBnd = new Rectangle2D.Double(interRect.getMinX() - minOverlapRule.getValue(0), interRect.getMinY() - minOverlapRule.getValue(0), interRect.getWidth() + minOverlapRule.getValue(0) * 2.0, interRect.getHeight() + minOverlapRule.getValue(0) * 2.0);
                    PolyBase extPoly = new PolyBase(ruleBnd);
                    PolyBase distPoly = new PolyBase(interRect);
                    Arrays.fill(founds, false);
                    Point2D[] points = extPoly.getPoints();
                    Point2D[] distPoints = distPoly.getPoints();
                    if (distPoints.length != points.length) {
                        System.out.println("This case is not valid in Quick.checkThisCellExtensionRule");
                    }
                    for (int i = 0; i < points.length; ++i) {
                        found = poly.isPointOnCorner(distPoints[i]);
                        if (found) continue;
                        founds[i] = true;
                    }
                    boolean foundAll = this.allPointsContainedInLayer(geom, cell, ruleBnd, drcLayers, points, founds);
                    if (foundAll) continue;
                    for (int i = 0; i < founds.length; ++i) {
                        if (founds[i]) continue;
                        checkExtraPoints.add(points[i]);
                    }
                }
            }
            found = polyArea.isEmpty();
        }
        return found;
    }

    private boolean allPointsContainedInLayer(Geometric geom, Cell cell, Rectangle2D ruleBnd, Layer.Function.Set drcLayers, Point2D[] points, boolean[] founds) {
        Iterator<RTBounds> sIt = cell.searchIterator(ruleBnd);
        while (sIt.hasNext()) {
            RTBounds g = sIt.next();
            if (g == geom || !(g instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)g;
            NodeProto np = ni.getProto();
            if (NodeInst.isSpecialNode(ni)) continue;
            if (ni.isCellInstance()) {
                AffineTransform cellDownTrans = ni.transformIn();
                AffineTransform cellUpTrans = ni.transformOut();
                DBMath.transformRect(ruleBnd, cellDownTrans);
                cellDownTrans.transform(points, 0, points, 0, points.length);
                boolean allFound = this.allPointsContainedInLayer(geom, (Cell)np, ruleBnd, drcLayers, points, founds);
                DBMath.transformRect(ruleBnd, cellUpTrans);
                cellUpTrans.transform(points, 0, points, 0, points.length);
                if (!allFound) continue;
                return true;
            }
            Technology tech = np.getTechnology();
            for (Poly nPoly : tech.getShapeOfNode(ni, true, this.ignoreCenterCuts, drcLayers)) {
                if (!nPoly.getLayer().getFunction().isImplant()) continue;
                boolean allFound = true;
                for (int i = 0; i < points.length; ++i) {
                    if (!founds[i]) {
                        founds[i] = nPoly.contains(points[i]);
                    }
                    if (founds[i]) continue;
                    allFound = false;
                }
                if (!allFound) continue;
                return true;
            }
        }
        return false;
    }

    private boolean activeOnTransistor(Poly poly1, Layer layer1, int net1, Poly poly2, Layer layer2, int net2, Cell cell, int globalIndex) {
        if (net1 == net2) {
            return false;
        }
        Layer.Function fun = layer1.getFunction();
        int funExtras = layer1.getFunctionExtras();
        if (!(fun.isDiff() || fun.isContact() && (funExtras & 0x10000) != 0)) {
            return false;
        }
        funExtras = layer2.getFunctionExtras();
        fun = layer2.getFunction();
        if (!(fun.isDiff() || fun.isContact() && (funExtras & 0x10000) != 0)) {
            return false;
        }
        Rectangle2D bounds1 = poly1.getBounds2D();
        Rectangle2D bounds2 = poly2.getBounds2D();
        Rectangle2D.union(bounds1, bounds2, bounds1);
        return this.activeOnTransistorRecurse(bounds1, net1, net2, cell, globalIndex, DBMath.MATID);
    }

    private boolean activeOnTransistorRecurse(Rectangle2D bounds, int net1, int net2, Cell cell, int globalIndex, AffineTransform trans) {
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        Rectangle2D.Double subBounds = new Rectangle2D.Double();
        Iterator<RTBounds> sIt = cell.searchIterator(bounds);
        while (sIt.hasNext()) {
            RTBounds g = sIt.next();
            if (!(g instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)g;
            NodeProto np = ni.getProto();
            if (ni.isCellInstance()) {
                AffineTransform rTransI = ni.rotateIn();
                AffineTransform tTransI = ni.translateIn();
                rTransI.preConcatenate(tTransI);
                ((Rectangle2D)subBounds).setRect(bounds);
                DBMath.transformRect(subBounds, rTransI);
                CheckInst ci = this.checkInsts.get(ni);
                int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                boolean ret = this.activeOnTransistorRecurse(subBounds, net1, net2, (Cell)np, localIndex, trans);
                if (!ret) continue;
                return true;
            }
            if (!ni.isFET()) continue;
            Rectangle2D nodeBounds = ni.getBounds();
            double cX = nodeBounds.getCenterX();
            double cY = nodeBounds.getCenterY();
            if (cX < bounds.getMinX() || cX > bounds.getMaxX() || cY < bounds.getMinY() || cY > bounds.getMaxY()) continue;
            PortProto badport = np.getPort(0);
            Network badNet = netlist.getNetwork(ni, badport, 0);
            boolean on1 = false;
            boolean on2 = false;
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                Integer[] netNumbers;
                int net;
                PortInst pi = it.next();
                PortProto po = pi.getPortProto();
                String name = po.getName();
                boolean found = false;
                boolean oldFound = false;
                Network piNet = netlist.getNetwork(pi);
                if (name.indexOf("poly") != -1) {
                    found = true;
                }
                if (piNet == badNet) {
                    oldFound = true;
                }
                if (Job.LOCALDEBUGFLAG && oldFound != found) {
                    System.out.println("Here is different in activeOnTransistorRecurse");
                }
                if (found || (net = (netNumbers = this.networkLists.get(piNet))[globalIndex].intValue()) < 0) continue;
                if (net == net1) {
                    on1 = true;
                }
                if (net != net2) continue;
                on2 = true;
            }
            if (!on1 || !on2) continue;
            return true;
        }
        return false;
    }

    private boolean cropNodeInst(NodeInst ni, int globalIndex, AffineTransform trans, Layer nLayer, int nNet, Geometric nGeom, Rectangle2D bound) {
        Technology tech = ni.getProto().getTechnology();
        Poly[] cropNodePolyList = tech.getShapeOfNode(ni, true, this.ignoreCenterCuts, null);
        this.convertPseudoLayers(ni, cropNodePolyList);
        int tot = cropNodePolyList.length;
        if (tot < 0) {
            return false;
        }
        boolean[] rotated = new boolean[tot];
        Arrays.fill(rotated, false);
        boolean isConnected = false;
        Netlist netlist = this.getCheckProto((Cell)ni.getParent()).netlist;
        for (int j = 0; j < tot; ++j) {
            int net;
            Poly poly = cropNodePolyList[j];
            if (!tech.sameLayer(poly.getLayer(), nLayer)) continue;
            poly.transform(trans);
            rotated[j] = true;
            if (nNet >= 0 && (poly.getPort() == null || (net = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex)) >= 0 && net != nNet)) continue;
            isConnected = true;
            break;
        }
        if (!isConnected) {
            return false;
        }
        boolean allgone = false;
        for (int j = 0; j < tot; ++j) {
            Rectangle2D polyBox;
            Poly poly = cropNodePolyList[j];
            if (!tech.sameLayer(poly.getLayer(), nLayer)) continue;
            if (!rotated[j]) {
                poly.transform(trans);
            }
            if ((polyBox = poly.getBox()) == null) continue;
            int temp = Poly.cropBox(bound, polyBox);
            if (temp > 0) {
                allgone = true;
                break;
            }
            if (temp >= 0) continue;
            this.tinyNodeInst = ni;
            this.tinyGeometric = nGeom;
        }
        return allgone;
    }

    private boolean cropArcInst(ArcInst ai, Layer lay, AffineTransform inTrans, Rectangle2D bounds, boolean overlap) {
        for (int i = 0; i < 2; ++i) {
            PortInst pi = ai.getPortInst(i);
            PortOriginal fp = new PortOriginal(pi, inTrans);
            NodeInst ni = fp.getBottomNodeInst();
            NodeProto np = ni.getProto();
            AffineTransform trans = fp.getTransformToTop();
            Technology tech = np.getTechnology();
            Poly[] cropArcPolyList = null;
            for (Poly poly : tech.getShapeOfNode(ni, false, this.ignoreCenterCuts, null)) {
                if (!tech.sameLayer(poly.getLayer(), lay)) continue;
                poly.transform(trans);
                Rectangle2D polyBox = poly.getBox();
                if (polyBox == null) continue;
                int temp = Poly.halfCropBox(bounds, polyBox);
                if (temp > 0) {
                    return true;
                }
                if (temp >= 0) continue;
                this.tinyNodeInst = ni;
                this.tinyGeometric = ai;
            }
        }
        return false;
    }

    private void cropActiveArc(ArcInst ai, Poly[] pList) {
        int tot = pList.length;
        int diffPoly = -1;
        for (int j = 0; j < tot; ++j) {
            Layer.Function fun;
            Poly poly = pList[j];
            Layer layer = poly.getLayer();
            if (layer == null || !(fun = layer.getFunction()).isDiff()) continue;
            diffPoly = j;
            break;
        }
        if (diffPoly < 0) {
            return;
        }
        Poly poly = pList[diffPoly];
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return;
        }
        polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
        boolean cropped = false;
        boolean halved = false;
        for (int i = 0; i < 2; ++i) {
            PortInst pi = ai.getPortInst(i);
            NodeInst ni = pi.getNodeInst();
            if (!ni.isFET()) continue;
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            for (Poly nPoly : tech.getShapeOfNode(ni, false, this.ignoreCenterCuts, null)) {
                int result;
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                Rectangle2D nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int n = result = halved ? Poly.cropBox(polyBounds, nPolyBounds) : Poly.halfCropBox(polyBounds, nPolyBounds);
                if (result == 1) {
                    poly.setLayer(null);
                    return;
                }
                cropped = true;
                halved = true;
            }
        }
        if (cropped) {
            Poly.Type style = poly.getStyle();
            Layer layer = poly.getLayer();
            poly = new Poly(polyBounds);
            poly.setStyle(style);
            poly.setLayer(layer);
            pList[diffPoly] = poly;
        }
    }

    private void convertPseudoLayers(NodeInst ni, Poly[] pList) {
        if (ni.getProto().getFunction() != PrimitiveNode.Function.PIN) {
            return;
        }
        if (ni.hasConnections()) {
            return;
        }
        if (!ni.hasExports()) {
            return;
        }
        for (Poly poly : pList) {
            Layer layer = poly.getLayer();
            if (layer == null) continue;
            poly.setLayer(layer.getNonPseudoLayer());
        }
    }

    private void cacheValidLayers(Technology tech) {
        if (tech == null) {
            return;
        }
        if (this.layersValidTech == tech) {
            return;
        }
        this.layersValidTech = tech;
        int numLayers = tech.getNumLayers();
        this.layersValid = new boolean[numLayers];
        for (int i = 0; i < numLayers; ++i) {
            this.layersValid[i] = false;
        }
        Iterator<Comparable<PrimitiveNode>> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np.isNotUsed()) continue;
            Technology.NodeLayer[] layers = np.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                Layer layer = layers[i].getLayer();
                this.layersValid[layer.getIndex()] = true;
            }
        }
        it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            if (ap.isNotUsed()) continue;
            Iterator<Layer> lIt = ap.getLayerIterator();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                this.layersValid[layer.getIndex()] = true;
            }
        }
    }

    private DRCTemplate getSpacingRule(Layer layer1, Poly poly1, Geometric geo1, Layer layer2, Poly poly2, Geometric geo2, boolean con, int multi) {
        if (!con && layer1 == layer2) {
            Layer.Function fun = layer1.getFunction();
            con = fun.isSubstrate();
        }
        double[] values = layer1.getTechnology().getSpacingDistances(poly1, poly2);
        return DRC.getSpacingRule(layer1, geo1, layer2, geo2, con, multi, values[0], values[1]);
    }

    private int getDRCNetNumber(Netlist netlist, PortProto pp, NodeInst ni, int globalIndex) {
        if (pp == null) {
            return -1;
        }
        Network net = netlist.getNetwork(ni, pp, 0);
        Integer[] nets = this.networkLists.get(net);
        if (nets == null) {
            return -1;
        }
        return nets[globalIndex];
    }

    private void buildLayerInteractions(Technology tech) {
        Technology old = this.layerInterTech;
        if (this.layerInterTech == tech) {
            return;
        }
        this.layerInterTech = tech;
        int numLayers = tech.getNumLayers();
        if (this.layersInterNodes != null && old != null && this.job != null) {
            this.errorLogger.logWarning("Switching from '" + old.getTechName() + "' to '" + tech.getTechName() + "' in DRC process. Check for non desired nodes in ", this.job.cell, -1);
        }
        this.layersInterNodes = new HashMap();
        Iterator<Comparable<PrimitiveNode>> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np.isNotUsed()) continue;
            boolean[] layersInNode = new boolean[numLayers];
            Arrays.fill(layersInNode, false);
            Technology.NodeLayer[] layers = np.getLayers();
            Technology.NodeLayer[] eLayers = np.getElectricalLayers();
            if (eLayers != null) {
                layers = eLayers;
            }
            for (Technology.NodeLayer l : layers) {
                Layer layer = l.getLayer();
                if (layer.isNonElectrical()) continue;
                Iterator<Layer> lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer oLayer = lIt.next();
                    if (oLayer.isNonElectrical() || !DRC.isAnySpacingRule(layer, oLayer)) continue;
                    layersInNode[oLayer.getIndex()] = true;
                }
            }
            this.layersInterNodes.put(np, layersInNode);
        }
        this.layersInterArcs = new HashMap();
        it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            boolean[] layersInArc = new boolean[numLayers];
            Arrays.fill(layersInArc, false);
            Iterator<Layer> alIt = ap.getLayerIterator();
            while (alIt.hasNext()) {
                Layer layer = alIt.next();
                Iterator<Layer> lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer oLayer = lIt.next();
                    if (!DRC.isAnySpacingRule(layer, oLayer)) continue;
                    layersInArc[oLayer.getIndex()] = true;
                }
            }
            this.layersInterArcs.put(ap, layersInArc);
        }
    }

    private boolean checkLayerWithNode(Layer layer, NodeProto np) {
        this.buildLayerInteractions(np.getTechnology());
        boolean[] validLayers = this.layersInterNodes.get(np);
        if (validLayers == null) {
            return false;
        }
        return validLayers[layer.getIndex()];
    }

    private boolean checkLayerWithArc(Layer layer, ArcProto ap) {
        this.buildLayerInteractions(ap.getTechnology());
        boolean[] validLayers = this.layersInterArcs.get(ap);
        if (validLayers == null) {
            return false;
        }
        return validLayers[layer.getIndex()];
    }

    private void accumulateExclusion(Cell cell) {
        Area area = null;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            if (np == Generic.tech.drcNode) {
                Poly[] list = cell.getTechnology().getShapeOfNode(ni, true, true, null);
                Area thisArea = new Area(list[0]);
                if (area == null) {
                    area = thisArea;
                    continue;
                }
                area.add(thisArea);
                continue;
            }
            if (!ni.isCellInstance()) continue;
            this.accumulateExclusion((Cell)np);
        }
        this.exclusionMap.put(cell, area);
    }

    private boolean checkExclusionMap(Cell cell, List<PolyBase> polyList, List<Geometric> geomList, StringBuffer DRCexclusionMsg) {
        Area area = this.exclusionMap.get(cell);
        if (area == null) {
            return false;
        }
        int count = 0;
        int i = -1;
        for (PolyBase thisPoly : polyList) {
            ++i;
            if (thisPoly == null) continue;
            boolean found = area.contains(thisPoly.getBounds2D());
            if (found) {
                ++count;
                continue;
            }
            DRCexclusionMsg.append("\n\t(DRC Exclusion in '" + cell.getName() + "' does not completely contain " + geomList.get(i) + ")");
        }
        return count >= 1;
    }

    private void reportError(DRCErrorType errorType, String msg, Cell cell, double limit, double actual, String rule, PolyBase poly1, Geometric geom1, Layer layer1, PolyBase poly2, Geometric geom2, Layer layer2) {
        boolean onlyWarning;
        if (this.errorLogger == null) {
            return;
        }
        StringBuffer DRCexclusionMsg = new StringBuffer();
        if (this.exclusionMap.get(cell) != null) {
            boolean found;
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>(2);
            ArrayList<Geometric> geomList = new ArrayList<Geometric>(2);
            polyList.add(poly1);
            geomList.add(geom1);
            if (poly2 != null) {
                polyList.add(poly2);
                geomList.add(geom2);
            }
            if (found = this.checkExclusionMap(cell, polyList, geomList, DRCexclusionMsg)) {
                return;
            }
        }
        Cell np1 = geom1 != null ? geom1.getParent() : null;
        Cell np2 = geom2 != null ? geom2.getParent() : null;
        boolean bl = onlyWarning = errorType == DRCErrorType.ZEROLENGTHARCWARN || errorType == DRCErrorType.TECHMIXWARN;
        if (geom2 != null && this.errorTypeSearch != DRC.DRCCheckMode.ERROR_CHECK_EXHAUSTIVE && this.errorLogger.findMessage(cell, geom1, geom2.getParent(), geom2, !onlyWarning)) {
            return;
        }
        StringBuffer errorMessage = new StringBuffer();
        int sortLayer = cell.hashCode();
        if (errorType == DRCErrorType.SPACINGERROR || errorType == DRCErrorType.NOTCHERROR || errorType == DRCErrorType.SURROUNDERROR) {
            if (errorType == DRCErrorType.SPACINGERROR) {
                errorMessage.append("Spacing");
            } else if (errorType == DRCErrorType.SURROUNDERROR) {
                errorMessage.append("Surround");
            } else {
                errorMessage.append("Notch");
            }
            if (layer1 == layer2) {
                errorMessage.append(" (layer '" + layer1.getName() + "')");
            }
            errorMessage.append(": ");
            if (np1 != np2) {
                errorMessage.append(np1 + ", ");
            } else if (np1 != cell) {
                errorMessage.append("[in " + np1 + "] ");
            }
            errorMessage.append(geom1);
            if (layer1 != layer2) {
                errorMessage.append(", layer '" + layer1.getName() + "'");
            }
            if (actual < 0.0) {
                errorMessage.append(" OVERLAPS (BY " + TextUtils.formatDouble(limit - actual) + ") ");
            } else if (actual == 0.0) {
                errorMessage.append(" TOUCHES ");
            } else {
                errorMessage.append(" LESS (BY " + TextUtils.formatDouble(limit - actual) + ") THAN " + TextUtils.formatDouble(limit) + " TO ");
            }
            if (np1 != np2) {
                errorMessage.append(np2 + ", ");
            }
            errorMessage.append(geom2);
            if (layer1 != layer2) {
                errorMessage.append(", layer '" + layer2.getName() + "'");
            }
            if (msg != null) {
                errorMessage.append("; " + msg);
            }
        } else {
            StringBuffer errorMessagePart2 = null;
            switch (errorType) {
                case RESOLUTION: {
                    errorMessage.append("Resolution error:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case FORBIDDEN: {
                    errorMessage.append("Forbidden error:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case SLOTSIZEERROR: {
                    errorMessage.append("Slot size error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" BIGGER THAN " + TextUtils.formatDouble(limit) + " IN LENGTH (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINAREAERROR: {
                    errorMessage.append("Minimum area error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " IN AREA (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case ENCLOSEDAREAERROR: {
                    errorMessage.append("Enclosed area error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " IN AREA (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case TECHMIXWARN: {
                    errorMessage.append("Technology mixture warning:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case ZEROLENGTHARCWARN: {
                    errorMessage.append("Zero width warning:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case CUTERROR: {
                    errorMessage.append("Maximum cut error" + (msg != null ? "(" + msg + "):" : ""));
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" BIGGER THAN " + TextUtils.formatDouble(limit) + " WIDE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINWIDTHERROR: {
                    errorMessage.append("Minimum width/height error" + (msg != null ? "(" + msg + "):" : ""));
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " WIDE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINSIZEERROR: {
                    errorMessage.append("Minimum size error on " + msg + ":");
                    errorMessagePart2 = new StringBuffer(" LESS THAN " + TextUtils.formatDouble(limit) + " IN SIZE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case BADLAYERERROR: {
                    errorMessage.append("Invalid layer ('" + layer1.getName() + "'):");
                    break;
                }
                case LAYERSURROUNDERROR: {
                    errorMessage.append("Layer surround error: " + msg);
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    String layerName = layer2 != null ? layer2.getName() : "Select";
                    errorMessagePart2.append(" NEEDS SURROUND OF LAYER '" + layerName + "' BY " + limit);
                }
            }
            errorMessage.append(" " + cell + " ");
            if (geom1 != null) {
                errorMessage.append(geom1);
            }
            if (layer1 != null) {
                sortLayer = layer1.getIndex();
            }
            errorMessage.append(errorMessagePart2);
        }
        if (rule != null && rule.length() > 0) {
            errorMessage.append(" [rule '" + rule + "']");
        }
        errorMessage.append(DRCexclusionMsg);
        ArrayList<Geometric> geomList = new ArrayList<Geometric>();
        ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
        if (poly1 != null) {
            polyList.add(poly1);
        } else if (geom1 != null) {
            geomList.add(geom1);
        }
        if (poly2 != null) {
            polyList.add(poly2);
        } else if (geom2 != null) {
            geomList.add(geom2);
        }
        if (onlyWarning) {
            this.errorLogger.logWarning(errorMessage.toString(), geomList, null, null, null, polyList, cell, sortLayer);
        } else {
            this.errorLogger.logError(errorMessage.toString(), geomList, null, null, null, polyList, cell, sortLayer);
        }
        if (this.interactiveLogger) {
            Job.getUserInterface().termLogging(this.errorLogger, false, false);
        }
    }

    private class QuickAreaEnumerator
    extends HierarchyEnumerator.Visitor {
        private GeometryHandler otherTypeMerge;
        private Layer polyLayer;
        private Layer.Function.Set activeLayers = new Layer.Function.Set(Layer.Function.DIFFP, Layer.Function.DIFFN);
        private HashMap<NodeInst, NodeInst> notExportedNodes;
        private HashMap<NodeInst, NodeInst> checkedNodes;
        private GeometryHandler.GHMode mode;
        private boolean preProcess = false;
        private boolean doneAll = false;
        private boolean doingNonExport = false;
        private Map<Network, QuickAreaBucket> buckets = new HashMap<Network, QuickAreaBucket>();

        @Override
        public HierarchyEnumerator.CellInfo newCellInfo() {
            return new QuickAreaCellInfo();
        }

        public QuickAreaEnumerator(Netlist netlist, GeometryHandler selectMerge, HashMap<NodeInst, NodeInst> notExportedNodes, HashMap<NodeInst, NodeInst> checkedNodes, GeometryHandler.GHMode mode) {
            this.otherTypeMerge = selectMerge;
            this.notExportedNodes = notExportedNodes;
            this.checkedNodes = checkedNodes;
            this.mode = mode;
            Iterator<Network> netIt = netlist.getNetworks();
            while (netIt.hasNext()) {
                Network net = netIt.next();
                this.buckets.put(net, new QuickAreaBucket(net));
            }
        }

        public void setPreProcessFlag(boolean f) {
            this.preProcess = f;
        }

        public QuickAreaEnumerator(GeometryHandler selectMerge, HashMap<NodeInst, NodeInst> notExportedNodes, HashMap<NodeInst, NodeInst> checkedNodes, GeometryHandler.GHMode mode) {
            this.otherTypeMerge = selectMerge;
            this.notExportedNodes = notExportedNodes;
            this.checkedNodes = checkedNodes;
            this.mode = mode;
            this.doingNonExport = true;
            for (NodeInst ni : notExportedNodes.keySet()) {
                Cell cell = ni.getParent();
                CheckProto cp = Quick.this.getCheckProto(cell);
                Iterator<PortInst> itP = ni.getPortInsts();
                while (itP.hasNext()) {
                    PortInst pi = itP.next();
                    Network net = cp.netlist.getNetwork(pi);
                    if (this.buckets.get(net) != null) continue;
                    this.buckets.put(net, new QuickAreaBucket(net));
                }
            }
        }

        private boolean areAllLayersDone() {
            if (!this.doneAll) {
                boolean done = true;
                for (QuickAreaBucket bucket : this.buckets.values()) {
                    for (Layer layer : bucket.minAreaLayerMapDone.keySet()) {
                        if (bucket.minAreaLayerMapDone.get(layer) != null) continue;
                        done = false;
                        break;
                    }
                    if (done) {
                        for (Layer layer : bucket.enclosedAreaLayerMapDone.keySet()) {
                            if (bucket.enclosedAreaLayerMapDone.get(layer) != null) continue;
                            done = false;
                            break;
                        }
                    }
                    if (done) continue;
                    break;
                }
                this.doneAll = done;
            }
            return this.doneAll;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (Quick.this.job != null && Quick.this.job.checkAbort()) {
                return false;
            }
            if (!this.preProcess && (this.doneAll || this.areAllLayersDone())) {
                return false;
            }
            if (info.getCell() == Quick.this.topCell) {
                for (QuickAreaBucket bucket : this.buckets.values()) {
                    bucket.mainMerge = GeometryHandler.createGeometryHandler(this.mode, info.getCell().getTechnology().getNumLayers());
                }
            }
            AffineTransform rTrans = info.getTransformToRoot();
            QuickAreaCellInfo areaInfo = (QuickAreaCellInfo)info;
            List<QuickAreaBucket> theseBuckets = areaInfo.getValidNetworks();
            ArrayList<QuickAreaBucket> onlyTheseBuckets = new ArrayList<QuickAreaBucket>();
            Iterator<ArcInst> it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                Network aNet = info.getNetlist().getNetwork(ai, 0);
                if (aNet == null) continue;
                onlyTheseBuckets.clear();
                for (QuickAreaBucket bucket : theseBuckets) {
                    boolean found = false;
                    Iterator<Export> arcIt = aNet.getExports();
                    while (!found && arcIt.hasNext()) {
                        Export exp = arcIt.next();
                        Network net = info.getNetlist().getNetwork(exp, 0);
                        found = HierarchyEnumerator.searchNetworkInParent(net, info, bucket.jNet);
                    }
                    if (!found && aNet != bucket.jNet) continue;
                    onlyTheseBuckets.add(bucket);
                }
                if (onlyTheseBuckets.size() == 0) continue;
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai)) {
                    Layer layer = poly.getLayer();
                    if (layer.getFunction().isPoly()) {
                        if (this.polyLayer == null) {
                            this.polyLayer = layer;
                        }
                        layer = this.polyLayer;
                    }
                    for (QuickAreaBucket bucket : onlyTheseBuckets) {
                        if (bucket.skipLayer(layer)) continue;
                        assert (!this.preProcess);
                        poly.transform(rTrans);
                        this.addElement(bucket, poly, layer, false);
                    }
                }
            }
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            if (this.preProcess || this.doneAll || Quick.this.job != null && Quick.this.job.checkAbort()) {
                return;
            }
            boolean isTopCell = info.getCell() == Quick.this.topCell;
            for (QuickAreaBucket bucket : this.buckets.values()) {
                if (!isTopCell && bucket.merged) continue;
                bucket.mainMerge.postProcess(true);
                bucket.merged = true;
                for (Layer layer : bucket.mainMerge.getKeySet()) {
                    if (bucket.skipLayer(layer)) continue;
                    Quick.this.checkMinAreaLayer(bucket.mainMerge, info.getCell(), layer, isTopCell, bucket.minAreaLayerMapDone, bucket.enclosedAreaLayerMapDone);
                    if (!this.areAllLayersDone()) continue;
                    return;
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (Quick.this.job != null && Quick.this.job.checkAbort()) {
                return false;
            }
            if (this.doneAll) {
                return false;
            }
            NodeInst ni = no.getNodeInst();
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            NodeProto np = ni.getProto();
            if (this.doingNonExport && !this.notExportedNodes.containsKey(ni)) {
                return false;
            }
            if (!(np instanceof PrimitiveNode)) {
                return true;
            }
            Cell cell = info.getCell();
            AffineTransform trans = ni.rotateOut();
            AffineTransform root = info.getTransformToRoot();
            if (root.getType() != 0) {
                trans.preConcatenate(root);
            }
            PrimitiveNode pNp = (PrimitiveNode)np;
            boolean forceChecking = false;
            ArrayList<QuickAreaBucket> onlyTheseBuckets = new ArrayList<QuickAreaBucket>();
            QuickAreaCellInfo areaInfo = (QuickAreaCellInfo)info;
            List<QuickAreaBucket> theseBuckets = areaInfo.getValidNetworks();
            if (!theseBuckets.isEmpty()) {
                boolean pureNode;
                boolean bl = pureNode = pNp.getFunction() == PrimitiveNode.Function.NODE;
                if (np instanceof PrimitiveNode) {
                    if (NodeInst.isSpecialNode(ni)) {
                        return false;
                    }
                    forceChecking = pNp.isPureSubstrateNode();
                }
                boolean notExported = false;
                Network thisNet = null;
                boolean found = false;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    PortProto pp = pi.getPortProto();
                    boolean isExported = pp instanceof Export && ((Export)pp).getParent() == cell;
                    thisNet = info.getNetlist().getNetwork(pi);
                    QuickAreaBucket thisBucket = null;
                    for (QuickAreaBucket bucket : theseBuckets) {
                        boolean thisFound = HierarchyEnumerator.searchNetworkInParent(thisNet, info, bucket.jNet);
                        if (!thisFound) continue;
                        thisBucket = bucket;
                        break;
                    }
                    if (thisBucket != null) {
                        onlyTheseBuckets.add(thisBucket);
                    }
                    if (isExported) continue;
                    notExported = true;
                }
                found = !onlyTheseBuckets.isEmpty();
                boolean bl2 = notExported = notExported && !forceChecking && !pureNode && info.getParentInfo() != null;
                if (!found && !forceChecking) {
                    if (this.notExportedNodes != null && notExported) {
                        assert (!this.doingNonExport);
                        this.notExportedNodes.put(ni, ni);
                    }
                    return false;
                }
            } else {
                if (this.doingNonExport) {
                    return false;
                }
                if (this.notExportedNodes.containsKey(ni)) {
                    System.out.println("NI " + ni + " in " + cell);
                }
                this.notExportedNodes.put(ni, ni);
                if (this.checkedNodes.containsKey(ni)) {
                    return false;
                }
                return false;
            }
            this.notExportedNodes.remove(ni);
            this.checkedNodes.put(ni, ni);
            if (onlyTheseBuckets.size() == 0) {
                return false;
            }
            Technology tech = pNp.getTechnology();
            boolean isTransistor = pNp.getFunction().isTransistor();
            Poly activePoly = null;
            if (isTransistor) {
                Poly[] list = tech.getShapeOfNode(ni, false, true, this.activeLayers);
                assert (list.length == 1);
                activePoly = list[0];
            }
            for (Poly poly : tech.getShapeOfNode(ni, true, true, null)) {
                Layer layer = poly.getLayer();
                if (layer.getFunction().isPoly()) {
                    if (this.polyLayer == null) {
                        this.polyLayer = layer;
                    }
                    layer = this.polyLayer;
                }
                PortProto pp = poly.getPort();
                boolean found = forceChecking && layer.getFunction().isSubstrate();
                Network net = info.getNetlist().getNetwork(ni, pp, 0);
                for (QuickAreaBucket bucket : onlyTheseBuckets) {
                    if (bucket.skipLayer(layer)) continue;
                    if (bucket.jNet != null) {
                        boolean thisFound = found;
                        if (!thisFound && pp != null) {
                            thisFound = HierarchyEnumerator.searchNetworkInParent(net, info, bucket.jNet);
                        }
                        if (!thisFound) continue;
                    }
                    assert (!this.preProcess);
                    poly.roundPoints();
                    poly.transform(trans);
                    if (activePoly != null && layer.getFunction().isDiff()) {
                        poly = activePoly;
                    }
                    this.addElement(bucket, poly, layer, true);
                }
            }
            return true;
        }

        private void addElement(QuickAreaBucket bucket, Poly poly, Layer layer, boolean isNode) {
            Poly obj = poly;
            if (isNode && this.otherTypeMerge == null || layer.getFunction().isMetal() || layer.getFunction().isPoly()) {
                bucket.merged = false;
                bucket.mainMerge.add(layer, obj);
            } else {
                this.otherTypeMerge.add(layer, obj);
            }
        }

        class QuickAreaCellInfo
        extends HierarchyEnumerator.CellInfo {
            List<QuickAreaBucket> theseBuckets = null;

            QuickAreaCellInfo() {
            }

            List<QuickAreaBucket> getValidNetworks() {
                if (this.theseBuckets == null) {
                    this.theseBuckets = new ArrayList<QuickAreaBucket>();
                    for (QuickAreaBucket bucket : QuickAreaEnumerator.this.buckets.values()) {
                        Network net;
                        boolean found = false;
                        Iterator<Network> it = this.getNetlist().getNetworks();
                        while (it.hasNext() && !(found = HierarchyEnumerator.searchNetworkInParent(net = it.next(), this, bucket.jNet))) {
                        }
                        if (!found) continue;
                        this.theseBuckets.add(bucket);
                    }
                }
                return this.theseBuckets;
            }
        }

        private class QuickAreaBucket {
            boolean merged = false;
            GeometryHandler mainMerge;
            Network jNet;
            HashMap<Layer, Layer> minAreaLayerMapDone = new HashMap();
            HashMap<Layer, Layer> enclosedAreaLayerMapDone = new HashMap();

            QuickAreaBucket(Network net) {
                this.jNet = net;
                for (Layer layer : Quick.this.minAreaLayerMap.keySet()) {
                    this.minAreaLayerMapDone.put(layer, null);
                }
                for (Layer layer : Quick.this.enclosedAreaLayerMap.keySet()) {
                    this.enclosedAreaLayerMapDone.put(layer, null);
                }
            }

            private boolean skipLayer(Layer layer) {
                boolean minEDone;
                boolean noMinEnc;
                boolean noMinArea = Quick.this.minAreaLayerMap.get(layer) == null;
                boolean bl = noMinEnc = Quick.this.enclosedAreaLayerMap.get(layer) == null;
                if (noMinArea && noMinEnc) {
                    return true;
                }
                if (QuickAreaEnumerator.this.preProcess) {
                    this.minAreaLayerMapDone.put(layer, null);
                    this.enclosedAreaLayerMapDone.put(layer, null);
                    return true;
                }
                boolean minADone = noMinArea || this.minAreaLayerMapDone.get(layer) != null;
                boolean bl2 = minEDone = noMinEnc || this.enclosedAreaLayerMapDone.get(layer) != null;
                return minADone && minEDone;
            }
        }
    }

    private static class InstanceInter {
        Cell cell1;
        Cell cell2;
        Orientation or1;
        Orientation or2;
        double dx;
        double dy;
        NodeInst n1Parent;
        NodeInst n2Parent;
        NodeInst triggerNi;

        private InstanceInter() {
        }
    }

    private static class CheckProto {
        int timeStamp;
        int instanceCount;
        int hierInstanceCount;
        int totalPerCell;
        boolean cellChecked;
        boolean cellParameterized;
        boolean treeParameterized;
        List<CheckInst> nodesInCell;
        Netlist netlist;

        private CheckProto() {
        }
    }

    private static class CheckInst {
        int localIndex;
        int multiplier;
        int offset;

        private CheckInst() {
        }
    }

    private static enum DRCErrorType {
        SPACINGERROR,
        MINWIDTHERROR,
        NOTCHERROR,
        MINSIZEERROR,
        BADLAYERERROR,
        LAYERSURROUNDERROR,
        MINAREAERROR,
        ENCLOSEDAREAERROR,
        SURROUNDERROR,
        FORBIDDEN,
        RESOLUTION,
        CUTERROR,
        SLOTSIZEERROR,
        ZEROLENGTHARCWARN,
        TECHMIXWARN;

    }
}

