/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.spicenetlist;

import com.sun.electric.tool.io.input.spicenetlist.SpiceInstance;
import com.sun.electric.tool.io.input.spicenetlist.SpiceSubckt;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class SpiceNetlistReader {
    private File file;
    BufferedReader reader = null;
    private StringBuffer lines = null;
    private int lineno;
    private HashMap<String, String> options = new LinkedHashMap<String, String>();
    private HashMap<String, String> globalParams = new LinkedHashMap<String, String>();
    private List<SpiceInstance> topLevelInstances = new ArrayList<SpiceInstance>();
    private HashMap<String, SpiceSubckt> subckts = new LinkedHashMap<String, SpiceSubckt>();
    private List<String> globalNets = new ArrayList<String>();
    private SpiceSubckt currentSubckt;

    public HashMap<String, String> getOptions() {
        return this.options;
    }

    public HashMap<String, String> getGlobalParams() {
        return this.globalParams;
    }

    public List<SpiceInstance> getTopLevelInstances() {
        return this.topLevelInstances;
    }

    public Collection<SpiceSubckt> getSubckts() {
        return this.subckts.values();
    }

    public List<String> getGlobalNets() {
        return this.globalNets;
    }

    public SpiceSubckt getSubckt(String name) {
        return this.subckts.get(name.toLowerCase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFile(String fileName, boolean verbose) throws FileNotFoundException {
        this.file = new File(fileName);
        this.reader = new BufferedReader(new FileReader(fileName));
        this.lines = new StringBuffer();
        this.currentSubckt = null;
        this.lineno = 0;
        try {
            block4: while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    this.reader.close();
                    return;
                }
                String[] tokens = this.getTokens(line = line.trim());
                if (tokens.length == 0) continue;
                String keyword = tokens[0].toLowerCase();
                if (keyword.equals(".include")) {
                    if (tokens.length < 2) {
                        this.prErr("No file specified for .include");
                        continue;
                    }
                    String ifile = tokens[1];
                    if (!ifile.startsWith("/") && !ifile.startsWith("\\")) {
                        File newFile = new File(this.file.getParent(), ifile);
                        ifile = newFile.getPath();
                    }
                    File saveFile = this.file;
                    BufferedReader saveReader = this.reader;
                    StringBuffer saveLines = this.lines;
                    int saveLine = this.lineno;
                    try {
                        if (verbose) {
                            System.out.println("Reading include file " + ifile);
                        }
                        this.readFile(ifile, verbose);
                    }
                    catch (FileNotFoundException e) {
                        this.file = saveFile;
                        this.lineno = saveLine;
                        this.prErr("Include file does not exist: " + ifile);
                    }
                    this.file = saveFile;
                    this.reader = saveReader;
                    this.lines = saveLines;
                    this.lineno = saveLine;
                    continue;
                }
                if (keyword.startsWith(".opt")) {
                    this.parseOptions(this.options, 1, tokens);
                    continue;
                }
                if (keyword.equals(".param")) {
                    this.parseParams(this.globalParams, 1, tokens);
                    continue;
                }
                if (keyword.equals(".subckt")) {
                    this.currentSubckt = this.parseSubckt(tokens);
                    if (this.currentSubckt != null && this.subckts.containsKey(this.currentSubckt.getName().toLowerCase())) {
                        this.prErr("Subckt " + this.currentSubckt.getName() + " already defined");
                        continue;
                    }
                    this.subckts.put(this.currentSubckt.getName().toLowerCase(), this.currentSubckt);
                    continue;
                }
                if (keyword.equals(".global")) {
                    int i = 1;
                    while (true) {
                        if (i >= tokens.length) continue block4;
                        if (!this.globalNets.contains(tokens[i])) {
                            this.globalNets.add(tokens[i]);
                        }
                        ++i;
                    }
                }
                if (keyword.startsWith(".ends")) {
                    this.currentSubckt = null;
                    continue;
                }
                if (keyword.startsWith(".end")) continue;
                if (keyword.startsWith("x")) {
                    SpiceInstance inst = this.parseSubcktInstance(tokens);
                    this.addInstance(inst);
                    continue;
                }
                if (keyword.startsWith("r")) {
                    SpiceInstance inst = this.parseResistor(tokens);
                    this.addInstance(inst);
                    continue;
                }
                if (keyword.startsWith("c")) {
                    SpiceInstance inst = this.parseCapacitor(tokens);
                    this.addInstance(inst);
                    continue;
                }
                if (keyword.startsWith("m")) {
                    SpiceInstance inst = this.parseMosfet(tokens);
                    this.addInstance(inst);
                    continue;
                }
                if (keyword.equals(".protect") || keyword.equals(".unprotect")) continue;
                this.prWarn("Parser does not recognize: " + line);
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file " + this.file.getPath() + ": " + e.getMessage());
        }
    }

    private void prErr(String msg) {
        System.out.println("Error (" + this.getLocation() + "): " + msg);
    }

    private void prWarn(String msg) {
        System.out.println("Warning (" + this.getLocation() + "): " + msg);
    }

    private String getLocation() {
        return this.file.getName() + ":" + this.lineno;
    }

    private String[] getTokens(String line) {
        int i;
        ArrayList<String> tokens = new ArrayList<String>();
        int start = 0;
        boolean inquotes = false;
        int inparens = 0;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (inquotes) {
                if (c != '\'' || inparens > 0) continue;
                tokens.add(line.substring(start, i));
                start = i + 1;
                inquotes = false;
                continue;
            }
            if (c == '\'') {
                if (inparens > 0) continue;
                inquotes = true;
                if (start != i) {
                    this.prErr("Improper use of open quote '");
                    break;
                }
                start = i + 1;
                continue;
            }
            if (Character.isWhitespace(c) && inparens == 0) {
                if (start < i) {
                    tokens.add(line.substring(start, i));
                }
                start = i + 1;
                continue;
            }
            if (c == '(') {
                ++inparens;
                continue;
            }
            if (c == ')') {
                if (inparens == 0) {
                    this.prErr("Too many ')'s");
                    break;
                }
                --inparens;
                continue;
            }
            if (c == '=') {
                if (start < i) {
                    tokens.add(line.substring(start, i));
                }
                tokens.add("=");
                start = i + 1;
                continue;
            }
            if (c == '*') break;
        }
        if (start < i) {
            tokens.add(line.substring(start, i));
        }
        if (inparens != 0) {
            this.prErr("Unmatched parentheses");
        }
        ArrayList<String> joined = new ArrayList<String>();
        for (int j = 0; j < tokens.size(); ++j) {
            if (((String)tokens.get(j)).equals("=")) {
                if (j == 0) {
                    this.prErr("No right hand side to assignment");
                    continue;
                }
                if (j == tokens.size() - 1) {
                    this.prErr("No left hand side to assignment");
                    continue;
                }
                int last = joined.size() - 1;
                joined.set(last, (String)joined.get(last) + "=" + (String)tokens.get(++j));
                continue;
            }
            joined.add((String)tokens.get(j));
        }
        String[] ret = new String[joined.size()];
        for (int k = 0; k < joined.size(); ++k) {
            ret[k] = (String)joined.get(k);
        }
        return ret;
    }

    private void parseOptions(HashMap<String, String> map, int start, String[] tokens) {
        for (int i = start; i < tokens.length; ++i) {
            int e = tokens[i].indexOf(61);
            String pname = tokens[i];
            String value = "true";
            if (e > 0) {
                pname = tokens[i].substring(0, e);
                value = tokens[i].substring(e + 1);
            }
            if (pname == null || value == null) {
                this.prErr("Bad option value: " + tokens[i]);
                continue;
            }
            map.put(pname.toLowerCase(), value);
        }
    }

    private void parseParams(HashMap<String, String> map, int start, String[] tokens) {
        for (int i = start; i < tokens.length; ++i) {
            this.parseParam(map, tokens[i], null);
        }
    }

    private void parseParam(HashMap<String, String> map, String parval, String defaultParName) {
        int e = parval.indexOf(61);
        String pname = defaultParName;
        String value = parval;
        if (e > 0) {
            pname = parval.substring(0, e);
            value = parval.substring(e + 1);
            if (defaultParName != null && !defaultParName.equalsIgnoreCase(pname)) {
                this.prWarn("Expected param " + defaultParName + ", but got " + pname);
            }
        }
        if (pname == null || value == null) {
            this.prErr("Badly formatted param=val: " + parval);
            return;
        }
        map.put(pname.toLowerCase(), value);
    }

    private SpiceSubckt parseSubckt(String[] parts) {
        int i;
        SpiceSubckt subckt = new SpiceSubckt(parts[1]);
        for (i = 2; i < parts.length && parts[i].indexOf(61) <= 0; ++i) {
            subckt.addPort(parts[i]);
        }
        this.parseParams(subckt.getParams(), i, parts);
        return subckt;
    }

    private SpiceInstance parseSubcktInstance(String[] parts) {
        int i;
        String name = parts[0].substring(1);
        ArrayList<String> nets = new ArrayList<String>();
        for (i = 1; i < parts.length && !parts[i].contains("="); ++i) {
            nets.add(parts[i]);
        }
        String subcktName = (String)nets.remove(nets.size() - 1);
        SpiceSubckt subckt = this.subckts.get(subcktName.toLowerCase());
        if (subckt == null) {
            this.prErr("Cannot find subckt for " + subcktName);
            return null;
        }
        SpiceInstance inst = new SpiceInstance(subckt, name);
        for (String net : nets) {
            inst.addNet(net);
        }
        this.parseParams(inst.getParams(), i, parts);
        if (inst.getNets().size() != subckt.getPorts().size()) {
            this.prErr("Number of ports do not match: " + inst.getNets().size() + " (instance " + name + ") vs " + subckt.getPorts().size() + " (subckt " + subckt.getName() + ")");
        }
        return inst;
    }

    private void addInstance(SpiceInstance inst) {
        if (inst == null) {
            return;
        }
        if (this.currentSubckt != null) {
            this.currentSubckt.addInstance(inst);
        } else {
            this.topLevelInstances.add(inst);
        }
    }

    private SpiceInstance parseResistor(String[] parts) {
        if (parts.length < 4) {
            this.prErr("Not enough arguments for resistor");
            return null;
        }
        SpiceInstance inst = new SpiceInstance(parts[0]);
        for (int i = 1; i < 3; ++i) {
            inst.addNet(parts[i]);
        }
        this.parseParam(inst.getParams(), parts[3], "r");
        return inst;
    }

    private SpiceInstance parseCapacitor(String[] parts) {
        if (parts.length < 4) {
            this.prErr("Not enough arguments for capacitor");
            return null;
        }
        SpiceInstance inst = new SpiceInstance(parts[0]);
        for (int i = 1; i < 3; ++i) {
            inst.addNet(parts[i]);
        }
        this.parseParam(inst.getParams(), parts[3], "c");
        return inst;
    }

    private SpiceInstance parseMosfet(String[] parts) {
        int i;
        if (parts.length < 8) {
            this.prErr("Not enough arguments for mosfet");
            return null;
        }
        SpiceInstance inst = new SpiceInstance(parts[0]);
        for (i = 1; i < 5; ++i) {
            inst.addNet(parts[i]);
        }
        String model = parts[i];
        inst.getParams().put("model", model);
        this.parseParams(inst.getParams(), ++i, parts);
        return inst;
    }

    private void parseComment(String line) {
        if (this.currentSubckt == null) {
            return;
        }
        String[] parts = line.split("\\s+");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equalsIgnoreCase("PORT") || i + 2 >= parts.length) continue;
            String dir = parts[i + 1];
            String port = parts[i + 2];
            SpiceSubckt.PortType type = SpiceSubckt.PortType.valueOf(dir);
            if (type != null) {
                this.currentSubckt.setPortType(port, type);
            }
            return;
        }
    }

    private String readLine() throws IOException {
        String line;
        while (true) {
            ++this.lineno;
            line = this.reader.readLine();
            if (line == null) {
                if (this.lines.length() == 0) {
                    return null;
                }
                return this.removeString();
            }
            if ((line = line.trim()).startsWith("*")) {
                this.parseComment(line);
                continue;
            }
            if (line.startsWith("+")) {
                this.lines.append(" ");
                this.lines.append(line.substring(1));
                continue;
            }
            if (this.lines.length() != 0) break;
            this.lines.append(line);
        }
        String ret = this.removeString();
        this.lines.append(line);
        return ret;
    }

    private String removeString() {
        String ret = this.lines.toString();
        this.lines.delete(0, this.lines.length());
        return ret;
    }

    public void writeFile(String fileName) {
        if (fileName == null) {
            this.write(System.out);
        } else {
            try {
                PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName)));
                this.write(out);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public void write(PrintStream out) {
        out.println("* Spice netlist");
        for (String key : this.options.keySet()) {
            String value = this.options.get(key);
            if (value == null) {
                out.println(".option " + key);
                continue;
            }
            out.println(".option " + key + "=" + this.options.get(key));
        }
        out.println();
        for (String key : this.globalParams.keySet()) {
            out.println(".param " + key + "=" + this.globalParams.get(key));
        }
        out.println();
        for (String net : this.globalNets) {
            out.println(".global " + net);
        }
        out.println();
        for (String subcktName : this.subckts.keySet()) {
            SpiceSubckt subckt = this.subckts.get(subcktName);
            subckt.write(out);
            out.println();
        }
        for (SpiceInstance inst : this.topLevelInstances) {
            inst.write(out);
        }
        out.println();
        out.println(".end");
        if (out != System.out) {
            out.close();
        }
    }

    static void multiLinePrint(PrintStream out, boolean isComment, String str) {
        char contChar = '+';
        if (isComment) {
            contChar = '*';
        }
        int lastSpace = -1;
        int count = 0;
        boolean insideQuotes = false;
        int lineStart = 0;
        for (int pt = 0; pt < str.length(); ++pt) {
            char chr = str.charAt(pt);
            if (chr == '\n') {
                out.print(str.substring(lineStart, pt + 1));
                count = 0;
                lastSpace = -1;
                lineStart = pt + 1;
                continue;
            }
            if (chr == ' ' && !insideQuotes) {
                lastSpace = pt;
            }
            if (chr == '\'') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (++count < 78 || insideQuotes || lastSpace <= -1) continue;
            String partial = str.substring(lineStart, lastSpace + 1);
            out.print(partial + "\n" + contChar);
            count -= partial.length();
            lineStart = lastSpace + 1;
            lastSpace = -1;
        }
        if (lineStart < str.length()) {
            String partial = str.substring(lineStart);
            out.print(partial);
        }
    }

    public static void main(String[] args) {
        SpiceNetlistReader reader = new SpiceNetlistReader();
        try {
            reader.readFile("/import/async/cad/2006/bic/jkg/bic/testSims/test_clk_regen.spi", true);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        reader.writeFile("/tmp/output.spi");
    }
}

