/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HPGL
extends Output {
    private static final double SCALE = 100.0;
    private HashMap<Layer, List<PolyBase>> cellGeoms;
    private HashMap<Layer, Integer> penNumbers;
    private Cell cell;
    private EditWindow_ wnd;
    private int currentLineType;
    private int currentPen;
    private boolean fillEmitted;
    private PenColor[] penColorTable;

    public static void writeHPGLFile(Cell cell, VarContext context, String filePath) {
        HPGL out = new HPGL();
        out.cell = cell;
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        HPGLVisitor visitor = out.makeHPGLVisitor();
        out.start();
        HierarchyEnumerator.enumerateCell(cell, context, visitor);
        out.done();
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    private HPGL() {
    }

    protected void start() {
        this.cellGeoms = new HashMap();
        this.currentLineType = -1;
        this.currentPen = -1;
        this.fillEmitted = false;
        UserInterface ui = Job.getUserInterface();
        this.wnd = ui.getCurrentEditWindow_();
        if (this.wnd != null && this.wnd.getCell() != this.cell) {
            this.wnd = null;
        }
        this.initPenData();
    }

    protected void done() {
        Rectangle2D printBounds = this.getAreaToPrint(this.cell, false, this.wnd);
        if (printBounds == null) {
            return;
        }
        this.writeLine("\u001b%0BBPIN");
        this.writeLine("LA1,4,2,4QLMC0");
        Set<Layer> layerSet = this.cellGeoms.keySet();
        this.writeLine("NP" + layerSet.size());
        this.penNumbers = new HashMap();
        int index = 1;
        for (Layer layer : layerSet) {
            Color col;
            this.penNumbers.put(layer, new Integer(index));
            if (layer == null) {
                col = Color.BLACK;
            } else {
                EGraphics desc = layer.getGraphics();
                col = desc.getTransparentLayer() == 0 ? desc.getColor() : EGraphics.getColorFromIndex(EGraphics.makeIndex(desc.getTransparentLayer()));
                if (col == null) continue;
            }
            int r = col.getRed();
            int g = col.getGreen();
            int b = col.getBlue();
            this.writeLine("PC" + index + "," + r + "," + g + "," + b);
            ++index;
        }
        this.writeLine("IP;");
        this.writeLine("SC" + this.makeCoord(printBounds.getMinX()) + ",1," + this.makeCoord(printBounds.getMinY()) + ",1,2;");
        for (Layer layer : layerSet) {
            List<PolyBase> geoms = this.cellGeoms.get(layer);
            for (PolyBase poly : geoms) {
                this.emitPoly(poly);
            }
        }
        this.writeLine("PUSP0PG;");
    }

    private HPGLVisitor makeHPGLVisitor() {
        HPGLVisitor visitor = new HPGLVisitor(this);
        return visitor;
    }

    private void emitPoly(PolyBase poly) {
        Layer layer = poly.getLayer();
        Poly.Type style = poly.getStyle();
        Point2D[] points = poly.getPoints();
        if (style == Poly.Type.FILLED) {
            Rectangle2D box = poly.getBox();
            if (box != null) {
                if (box.getWidth() == 0.0) {
                    if (box.getHeight() != 0.0) {
                        this.emitLine(box.getMinX(), box.getMinY(), box.getMinX(), box.getMaxY(), layer);
                    }
                    return;
                }
                if (box.getHeight() == 0.0) {
                    this.emitLine(box.getMinX(), box.getMinY(), box.getMaxX(), box.getMinY(), layer);
                    return;
                }
            }
            if (points.length <= 1) {
                return;
            }
            if (points.length == 2) {
                this.emitLine(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY(), layer);
                return;
            }
            this.emitFilledPolygon(points, layer);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int k;
            Rectangle2D box = poly.getBox();
            if (box != null) {
                this.emitLine(box.getMinX(), box.getMinY(), box.getMinX(), box.getMaxY(), layer);
                this.emitLine(box.getMinX(), box.getMaxY(), box.getMaxX(), box.getMaxY(), layer);
                this.emitLine(box.getMaxX(), box.getMaxY(), box.getMaxX(), box.getMinY(), layer);
                if (style == Poly.Type.CLOSED || points.length == 5) {
                    this.emitLine(box.getMaxX(), box.getMinY(), box.getMinX(), box.getMinY(), layer);
                }
                return;
            }
            for (k = 1; k < points.length; ++k) {
                this.emitLine(points[k - 1].getX(), points[k - 1].getY(), points[k].getX(), points[k].getY(), layer);
            }
            if (style == Poly.Type.CLOSED) {
                k = points.length - 1;
                this.emitLine(points[k].getX(), points[k].getY(), points[0].getX(), points[0].getY(), layer);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int k = 0; k < points.length; k += 2) {
                this.emitLine(points[k].getX(), points[k].getY(), points[k + 1].getX(), points[k + 1].getY(), layer);
            }
            return;
        }
        if (style == Poly.Type.CROSS || style == Poly.Type.BIGCROSS) {
            double x = poly.getCenterX();
            double y = poly.getCenterY();
            this.emitLine(x - 5.0, y, x + 5.0, y, layer);
            this.emitLine(x, y + 5.0, x, y - 5.0, layer);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            Rectangle2D box = poly.getBounds2D();
            this.emitLine(box.getMinX(), box.getMinY(), box.getMinX(), box.getMaxY(), layer);
            this.emitLine(box.getMinX(), box.getMaxY(), box.getMaxX(), box.getMaxY(), layer);
            this.emitLine(box.getMaxX(), box.getMaxY(), box.getMaxX(), box.getMinY(), layer);
            this.emitLine(box.getMaxX(), box.getMinY(), box.getMinX(), box.getMinY(), layer);
            this.emitLine(box.getMaxX(), box.getMaxY(), box.getMinX(), box.getMinY(), layer);
            this.emitLine(box.getMaxX(), box.getMinY(), box.getMinX(), box.getMaxY(), layer);
            return;
        }
        if (style == Poly.Type.DISC) {
            this.emitDisc(points[0], points[1], layer);
            style = Poly.Type.CIRCLE;
        }
        if (style == Poly.Type.CIRCLE || style == Poly.Type.THICKCIRCLE) {
            this.emitCircle(points[0], points[1], layer);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            this.emitArc(points[0], points[1], points[2], layer);
            return;
        }
        if (style.isText()) {
            EditWindow0 wnd = null;
            Poly textPoly = (Poly)poly;
            double size = textPoly.getTextDescriptor().getTrueSize(wnd);
            Rectangle2D box = textPoly.getBounds2D();
            this.emitText(style, box.getMinX(), box.getMaxX(), box.getMinY(), box.getMaxY(), size, textPoly.getString(), layer);
            return;
        }
    }

    void emitLine(double x1, double y1, double x2, double y2, Layer layer) {
        this.doPenSelection(layer);
        this.movePen(x1, y1);
        this.drawPen(x2, y2);
    }

    private void emitArc(Point2D center, Point2D p1, Point2D p2, Layer layer) {
        double endAngle;
        double startAngle = GenMath.figureAngle(center, p1);
        double amt = startAngle > (endAngle = (double)GenMath.figureAngle(center, p2)) ? (startAngle - endAngle + 5.0) / 10.0 : (startAngle - endAngle + 3600.0 + 5.0) / 10.0;
        this.doPenSelection(layer);
        this.movePen(p1.getX(), p1.getY());
        this.writeLine("PD;");
        this.writeLine("AA " + this.makeCoord(center.getX()) + " " + this.makeCoord(center.getY()) + " " + (int)(-amt) + ";");
        this.writeLine("PU;");
    }

    private void emitCircle(Point2D at, Point2D e, Layer layer) {
        double radius = at.distance(e);
        this.doPenSelection(layer);
        this.movePen(at.getX(), at.getY());
        this.writeLine("PD;");
        this.writeLine("CI " + this.makeCoord(radius) + ";");
        this.writeLine("PU;");
    }

    private void emitDisc(Point2D at, Point2D e, Layer layer) {
        int fillType = this.doFillSelection(layer);
        double radius = at.distance(e);
        this.movePen(at.getX(), at.getY());
        this.writeLine("PD;");
        this.writeLine("PM;");
        this.writeLine("CI " + this.makeCoord(radius) + ";");
        this.writeLine("PM2;");
        if (fillType != 0) {
            this.writeLine("FP;");
        }
        if (fillType != 1) {
            this.writeLine("EP;");
        }
        this.writeLine("PU;");
    }

    private void emitFilledPolygon(Point2D[] points, Layer layer) {
        if (points.length <= 1) {
            return;
        }
        int fillType = this.doFillSelection(layer);
        double firstX = points[0].getX();
        double firstY = points[0].getY();
        this.movePen(firstX, firstY);
        this.writeLine("PM;");
        for (int i = 1; i < points.length; ++i) {
            this.drawPen(points[i].getX(), points[i].getY());
        }
        this.drawPen(firstX, firstY);
        this.writeLine("PM2;");
        if (fillType != 0) {
            this.writeLine("FP;");
        }
        if (fillType != 1) {
            this.writeLine("EP;");
        }
    }

    private void emitText(Poly.Type type, double xl, double xh, double yl, double yh, double size, String text, Layer layer) {
        this.writeLine("SI " + TextUtils.formatDouble(size * 0.01 / 1.3) + "," + TextUtils.formatDouble(size * 0.01) + ";");
        this.doPenSelection(layer);
        if (type == Poly.Type.TEXTBOTLEFT) {
            this.movePen(xl, yl);
            this.writeLine("LO1;");
        } else if (type == Poly.Type.TEXTLEFT) {
            this.movePen(xl, (yl + yh) / 2.0);
            this.writeLine("LO2;");
        } else if (type == Poly.Type.TEXTTOPLEFT) {
            this.movePen(xh, yl);
            this.writeLine("LO3;");
        } else if (type == Poly.Type.TEXTBOT) {
            this.movePen((xl + xh) / 2.0, yl);
            this.writeLine("LO4;");
        } else if (type == Poly.Type.TEXTCENT || type == Poly.Type.TEXTBOX) {
            this.movePen((xl + xh) / 2.0, (yl + yh) / 2.0);
            this.writeLine("LO5;");
        } else if (type == Poly.Type.TEXTTOP) {
            this.movePen((xl + xh) / 2.0, yh);
            this.writeLine("LO6;");
        } else if (type == Poly.Type.TEXTBOTRIGHT) {
            this.movePen(xh, yl);
            this.writeLine("LO7;");
        } else if (type == Poly.Type.TEXTRIGHT) {
            this.movePen(xh, (yl + yh) / 2.0);
            this.writeLine("LO8;");
        } else if (type == Poly.Type.TEXTTOPRIGHT) {
            this.movePen(xh, yh);
            this.writeLine("LO9;");
        }
        this.writeLine("LB " + text + "\u0003");
    }

    private void initPenData() {
        this.penColorTable = new PenColor[256];
        for (int i = 0; i < 256; ++i) {
            this.penColorTable[i] = new PenColor();
            this.penColorTable[i].lineType = 0;
            this.penColorTable[i].fillType = 3;
            this.penColorTable[i].fillDist = this.makeCoord(i * 2);
            this.penColorTable[i].fillAngle = i * 10 % 360;
        }
    }

    private int getPenNumber(Layer layer) {
        Integer ind = this.penNumbers.get(layer);
        if (ind == null) {
            return 0;
        }
        return ind;
    }

    private int doFillSelection(Layer layer) {
        this.doPenSelection(layer);
        int fillType = this.penColorTable[this.currentPen].fillType;
        if (!this.fillEmitted) {
            int fillAngle = this.penColorTable[this.currentPen].fillAngle;
            int fillDist = this.penColorTable[this.currentPen].fillDist;
            this.writeLine("FT " + fillType + "," + fillDist + "," + fillAngle + ";");
            this.fillEmitted = true;
        }
        return fillType;
    }

    private void doPenSelection(Layer layer) {
        int pen;
        int desiredPen = pen = this.getPenNumber(layer);
        int lineType = this.penColorTable[pen].lineType;
        if (desiredPen < 1) {
            desiredPen = 1;
        }
        if (desiredPen != this.currentPen) {
            this.writeLine("SP" + desiredPen + ";");
            this.currentPen = desiredPen;
            this.fillEmitted = false;
        }
        if (lineType != this.currentLineType) {
            if (lineType == 0) {
                this.writeLine("LT;");
            } else {
                this.writeLine("LT" + lineType + ";");
            }
            this.currentLineType = lineType;
        }
    }

    private void movePen(double x, double y) {
        this.writeLine("PU" + this.makeCoord(x) + "," + this.makeCoord(y) + ";");
    }

    private void drawPen(double x, double y) {
        this.writeLine("PD" + this.makeCoord(x) + "," + this.makeCoord(y) + ";");
    }

    private int makeCoord(double v) {
        return (int)Math.round(v * 100.0);
    }

    private void writeLine(String line) {
        this.printWriter.print(line + "\r\n");
    }

    private class HPGLVisitor
    extends HierarchyEnumerator.Visitor {
        private HPGL outGeom;

        HPGLVisitor(HPGL outGeom) {
            this.outGeom = outGeom;
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = (NodeInst)no;
            return !ni.isCellInstance() || ni.isExpanded();
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            AffineTransform trans = info.getTransformToRoot();
            PolyMerge merge = new PolyMerge();
            Iterator<Geometric> it = info.getCell().getNodes();
            while (it.hasNext()) {
                Poly poly;
                NodeInst ni = it.next();
                AffineTransform nodeTrans = ni.rotateOut(trans);
                if (!ni.isCellInstance()) {
                    PrimitiveNode prim = (PrimitiveNode)ni.getProto();
                    Technology tech = prim.getTechnology();
                    Poly[] polys = tech.getShapeOfNode(ni);
                    for (int i = 0; i < polys.length; ++i) {
                        polys[i].transform(nodeTrans);
                    }
                    this.addPolys(polys, merge);
                    Poly[] textPolys = ni.getDisplayableVariables(HPGL.this.wnd);
                    for (int i = 0; i < textPolys.length; ++i) {
                        textPolys[i].transform(nodeTrans);
                    }
                    this.addPolys(textPolys, merge);
                } else if (!ni.isExpanded()) {
                    Cell subCell = (Cell)ni.getProto();
                    AffineTransform subTrans = ni.translateOut(nodeTrans);
                    ERectangle bounds = subCell.getBounds();
                    poly = new Poly(bounds.getCenterX(), bounds.getCenterY(), ni.getXSize(), ni.getYSize());
                    poly.transform(subTrans);
                    poly.setStyle(Poly.Type.CLOSED);
                    List<PolyBase> layerList = this.getListForLayer(null);
                    layerList.add(poly);
                    poly = new Poly(bounds.getCenterX(), bounds.getCenterY(), ni.getXSize(), ni.getYSize());
                    poly.transform(subTrans);
                    poly.setStyle(Poly.Type.TEXTBOX);
                    TextDescriptor td = TextDescriptor.getInstanceTextDescriptor().withAbsSize(24);
                    poly.setTextDescriptor(td);
                    poly.setString(ni.getProto().describe(false));
                    layerList.add(poly);
                }
                if (!info.isRootCell() || !User.isTextVisibilityOnExport()) continue;
                int exportDisplayLevel = User.getExportDisplayLevel();
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    poly = e.getNamePoly();
                    List<PolyBase> layerList = this.getListForLayer(null);
                    if (exportDisplayLevel == 2) {
                        poly.setStyle(Poly.Type.CROSS);
                        layerList.add(poly);
                        continue;
                    }
                    if (exportDisplayLevel == 1) {
                        String portName = e.getShortName();
                        poly.setString(portName);
                    }
                    layerList.add(poly);
                }
            }
            it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ArcProto ap = ai.getProto();
                Technology tech = ap.getTechnology();
                this.addPolys(tech.getShapeOfArc(ai), merge);
                this.addPolys(ai.getDisplayableVariables(HPGL.this.wnd), merge);
            }
            for (Layer layer : merge.getKeySet()) {
                List<PolyBase> layerList = this.getListForLayer(layer);
                List<PolyBase> geom = merge.getMergedPoints(layer, true);
                for (PolyBase poly : geom) {
                    layerList.add(poly);
                }
            }
        }

        private void addPolys(Poly[] polys, PolyMerge merge) {
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer layer = poly.getLayer();
                if (layer == null || poly.getStyle() != Poly.Type.FILLED) {
                    List<PolyBase> layerList = this.getListForLayer(layer);
                    layerList.add(poly);
                    continue;
                }
                merge.addPolygon(layer, poly);
            }
        }

        private List<PolyBase> getListForLayer(Layer layer) {
            ArrayList layerList = (ArrayList)this.outGeom.cellGeoms.get(layer);
            if (layerList == null) {
                layerList = new ArrayList();
                this.outGeom.cellGeoms.put(layer, layerList);
            }
            return layerList;
        }
    }

    private static class PenColor {
        private int lineType;
        private int fillType;
        private int fillDist;
        private int fillAngle;

        private PenColor() {
        }
    }
}

