/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.BusParameters;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Export
extends ElectricObject
implements PortProto,
Comparable<Export> {
    public static final Export[] NULL_ARRAY = new Export[0];
    public static final Variable.Key EXPORT_NAME = Variable.newKey("EXPORT_name");
    public static final Variable.Key EXPORT_REFERENCE_NAME = Variable.newKey("EXPORT_reference_name");
    private ImmutableExport d;
    private final Cell parent;
    private int portIndex;
    private PortInst originalPort;

    Export(ImmutableExport d, Cell parent) {
        this.parent = parent;
        this.d = d;
        assert (d.exportId.parentId == parent.getId());
        this.originalPort = parent.getPortInst(d.originalNodeId, d.originalPortId);
    }

    private Object writeReplace() {
        return new ExportKey(this);
    }

    public static Export newInstance(Cell parent, PortInst portInst, String protoName) {
        return Export.newInstance(parent, portInst, protoName, null, true);
    }

    public static Export newInstance(Cell parent, PortInst portInst, String protoName, PortCharacteristic characteristic) {
        return Export.newInstance(parent, portInst, protoName, characteristic, true);
    }

    public static Export newInstance(Cell parent, PortInst portInst, String protoName, PortCharacteristic characteristic, boolean createOnIcon) {
        Cell icon;
        PortCharacteristic newCharacteristic;
        ExportId exportId;
        if (protoName == null) {
            return null;
        }
        boolean busNamesAllowed = parent.busNamesAllowed();
        Name protoNameKey = ImmutableExport.validExportName(protoName, busNamesAllowed);
        if (protoNameKey == null && (protoNameKey = ImmutableExport.validExportName(protoName = protoName.replace(':', '_'), busNamesAllowed)) == null) {
            System.out.println("Bad export name " + protoName + " : " + Name.checkName(protoName));
            return null;
        }
        if (parent.findExport(protoName) != null) {
            String oldName = protoName;
            if ((protoName = ElectricObject.uniqueObjectName(protoName, parent, PortProto.class, false)) == null) {
                System.out.println(parent + " already has an export named " + oldName + ", export was not created");
                return null;
            }
            System.out.println(parent + " already has an export named " + oldName + ", making new export named " + protoName);
            assert (parent.findExport(protoName) == null);
        }
        if ((exportId = parent.getD().cellId.newPortId(protoName)).inDatabase(parent.getDatabase()) != null) {
            exportId = parent.getD().cellId.randomExportId(protoName);
        }
        PortProto originalProto = portInst.getPortProto();
        boolean alwaysDrawn = false;
        boolean bodyOnly = false;
        if (originalProto instanceof Export) {
            Export e = (Export)originalProto;
            alwaysDrawn = e.isAlwaysDrawn();
            bodyOnly = e.isBodyOnly();
        }
        if ((newCharacteristic = characteristic) == null) {
            newCharacteristic = originalProto.getCharacteristic();
        }
        Export pp = Export.newInstance(parent, exportId, protoName, Export.smartPlacement(portInst), portInst, alwaysDrawn, bodyOnly, newCharacteristic, null);
        if (createOnIcon && (icon = parent.iconView()) != null && icon.findExport(protoName) == null) {
            ERectangle bounds = parent.getBounds();
            double locX = portInst.getPoly().getCenterX();
            double locY = portInst.getPoly().getCenterY();
            ERectangle iconBounds = icon.getBounds();
            double newlocX = (locX - bounds.getMinX()) / ((RectangularShape)bounds).getWidth() * ((RectangularShape)iconBounds).getWidth() + iconBounds.getMinX();
            newlocX = DBMath.toNearest(newlocX, Job.getUserInterface().getGridAlignment().getWidth());
            double bodyDX = User.getIconGenLeadLength();
            double distToXEdge = locX - bounds.getMinX();
            if (locX >= bounds.getCenterX()) {
                bodyDX = -bodyDX;
                distToXEdge = ((RectangularShape)bounds).getMaxX() - locX;
            }
            double newlocY = (locY - bounds.getMinY()) / ((RectangularShape)bounds).getHeight() * ((RectangularShape)iconBounds).getHeight() + iconBounds.getMinY();
            newlocY = DBMath.toNearest(newlocY, Job.getUserInterface().getGridAlignment().getHeight());
            double bodyDY = User.getIconGenLeadLength();
            double distToYEdge = locY - bounds.getMinY();
            if (locY >= bounds.getCenterY()) {
                bodyDY = -bodyDY;
                distToYEdge = ((RectangularShape)bounds).getMaxY() - locY;
            }
            if (distToXEdge > distToYEdge) {
                bodyDX = 0.0;
            } else {
                bodyDY = 0.0;
            }
            Point2D.Double point = new Point2D.Double(newlocX, newlocY);
            Job.getUserInterface().alignToGrid(point);
            newlocX = ((Point2D)point).getX();
            newlocY = ((Point2D)point).getY();
            int exportTech = User.getIconGenExportTech();
            boolean drawLeads = User.isIconGenDrawLeads();
            int exportStyle = User.getIconGenExportStyle();
            int exportLocation = User.getIconGenExportLocation();
            boolean ad = User.isIconsAlwaysDrawn();
            int rotation = ViewChanges.iconTextRotation(pp, User.getIconGenInputRot(), User.getIconGenOutputRot(), User.getIconGenBidirRot(), User.getIconGenPowerRot(), User.getIconGenGroundRot(), User.getIconGenClockRot());
            if (!ViewChanges.makeIconExport(pp, 0, newlocX, newlocY, newlocX + bodyDX, newlocY + bodyDY, icon, exportTech, drawLeads, exportStyle, exportLocation, rotation, ad)) {
                System.out.println("Warning: Failed to create associated export in icon " + icon.describe(true));
            }
        }
        return pp;
    }

    public static Export newInstance(Cell parent, ExportId exportId, String name, TextDescriptor nameTextDescriptor, PortInst originalPort, boolean alwaysDrawn, boolean bodyOnly, PortCharacteristic characteristic, ErrorLogger errorLogger) {
        assert (parent.isLinked());
        String errorMsg = null;
        if (exportId.inDatabase(parent.getDatabase()) != null) {
            errorMsg = parent + " already has exportId " + exportId.externalId;
            System.out.println(errorMsg);
            errorLogger.logError(errorMsg, parent, 1);
            return null;
        }
        if (name == null) {
            name = exportId.externalId;
        }
        if (originalPort == null || !originalPort.isLinked()) {
            System.out.println("Null port on Export " + name + " in " + parent);
            return null;
        }
        NodeInst originalNode = originalPort.getNodeInst();
        PortProto subpp = originalPort.getPortProto();
        if (originalNode.getParent() != parent || subpp.getParent() != originalNode.getProto()) {
            System.out.println("Bad port on Export " + name + " in " + parent);
            return null;
        }
        if (ImmutableExport.validExportName(name, parent.busNamesAllowed()) == null) {
            errorMsg = parent + " has bad export name " + name + " ";
            String newName = Export.repairExportName(parent, name);
            if (newName == null) {
                newName = Export.repairExportName(parent, "X");
            }
            if (newName == null) {
                errorMsg = errorMsg + " removed ";
                System.out.println(errorMsg);
                errorLogger.logError(errorMsg, parent, 1);
                return null;
            }
            errorMsg = errorMsg + " renamed to " + newName;
            name = newName;
        }
        if (nameTextDescriptor == null) {
            nameTextDescriptor = TextDescriptor.getExportTextDescriptor();
        }
        ImmutableExport d = ImmutableExport.newInstance(exportId, Name.findName(name), nameTextDescriptor, originalNode.getD().nodeId, subpp.getId(), alwaysDrawn, bodyOnly, characteristic);
        Export e = new Export(d, parent);
        assert (e.originalPort == originalPort);
        originalNode.redoGeometric();
        parent.addExport(e);
        if (errorMsg != null) {
            System.out.println(errorMsg);
            if (errorLogger != null) {
                errorLogger.logError(errorMsg, e, 1);
            }
        }
        Constraints.getCurrent().newObject(e);
        return e;
    }

    public void kill() {
        this.parent.killExports(Collections.singleton(this));
    }

    public void rename(String newName) {
        Name newNameKey;
        this.checkChanging();
        Cell cell = this.originalPort.getNodeInst().getParent();
        String dupName = ElectricObject.uniqueObjectName(newName, cell, PortProto.class, false);
        if (!dupName.equals(newName)) {
            System.out.println(cell + " already has an export named " + newName + ", making new export named " + dupName);
            newName = dupName;
        }
        if ((newNameKey = ImmutableExport.validExportName(newName, cell.busNamesAllowed())) == null) {
            System.out.println("Bad export name " + newName + " : " + Name.checkName(newName));
            return;
        }
        Name oldName = this.getNameKey();
        this.parent.moveExport(this.portIndex, newName);
        this.setD(this.d.withName(newNameKey), true);
        Cell iconCell = cell.iconView();
        if (iconCell != null && iconCell != cell) {
            Iterator<Export> it = iconCell.getExports();
            while (it.hasNext()) {
                Export pp = it.next();
                if (!pp.getName().equals(oldName.toString())) continue;
                pp.rename(newName);
                break;
            }
        }
    }

    public boolean move(PortInst newPi) {
        this.checkChanging();
        NodeInst newno = newPi.getNodeInst();
        PortProto newsubpt = newPi.getPortProto();
        if (newno.getParent() != this.parent) {
            return true;
        }
        if (newsubpt.getParent() != newno.getProto()) {
            return true;
        }
        if (this.doesntConnect(newsubpt.getBasePort())) {
            return true;
        }
        ImmutableExport oldD = this.d;
        this.lowLevelModify(this.d.withOriginalPort(newno.getD().nodeId, newsubpt.getId()));
        Constraints.getCurrent().modifyExport(this, oldD);
        this.changeallports();
        return false;
    }

    public void lowLevelModify(ImmutableExport d) {
        boolean moved;
        assert (this.isLinked());
        boolean renamed = this.getNameKey() != d.name;
        boolean bl = moved = this.d.originalNodeId != d.originalNodeId || this.d.originalPortId != d.originalPortId;
        if (moved) {
            NodeInst origNode = this.getOriginalPort().getNodeInst();
            origNode.redoGeometric();
        }
        if (renamed) {
            this.parent.moveExport(this.portIndex, d.name.toString());
        }
        this.setD(d, false);
        if (moved) {
            this.originalPort = this.parent.getPortInst(d.originalNodeId, d.originalPortId);
            this.originalPort.getNodeInst().redoGeometric();
        }
    }

    void setPortIndex(int portIndex) {
        this.portIndex = portIndex;
    }

    public void copyStateBits(Export other) {
        this.setAlwaysDrawn(other.isAlwaysDrawn());
        this.setBodyOnly(other.isBodyOnly());
        this.setCharacteristic(other.getCharacteristic());
    }

    public Poly getNamePoly() {
        Poly poly = this.getOriginalPort().getPoly();
        double cX = poly.getCenterX();
        double cY = poly.getCenterY();
        TextDescriptor td = this.getTextDescriptor(EXPORT_NAME);
        double offX = td.getXOff();
        double offY = td.getYOff();
        AbstractTextDescriptor.Position pos = td.getPos();
        Poly.Type style = pos.getPolyType();
        Point2D[] pointList = new Point2D.Double[1];
        NodeInst ni = this.getOriginalPort().getNodeInst();
        if (!ni.getOrient().equals(Orientation.IDENT)) {
            pointList[0] = new Point2D.Double(cX, cY);
            AffineTransform trans = ni.rotateIn();
            trans.transform(pointList[0], pointList[0]);
            pointList[0].setLocation(pointList[0].getX() + offX, pointList[0].getY() + offY);
            trans = ni.rotateOut();
            trans.transform(pointList[0], pointList[0]);
        } else {
            pointList[0] = new Point2D.Double(cX + offX, cY + offY);
        }
        poly = new Poly(pointList);
        poly.setStyle(style);
        poly.setPort(this);
        poly.setString(this.getName());
        poly.setTextDescriptor(td);
        poly.setDisplayedText(new DisplayedText(this, EXPORT_NAME));
        return poly;
    }

    @Override
    public Cell whichCell() {
        return this.parent;
    }

    @Override
    public ImmutableExport getD() {
        return this.d;
    }

    boolean setD(ImmutableExport newD, boolean notify) {
        this.checkChanging();
        ImmutableExport oldD = this.d;
        if (newD == oldD) {
            return false;
        }
        if (this.parent != null) {
            this.parent.setContentsModified();
            this.d = newD;
            if (notify) {
                Constraints.getCurrent().modifyExport(this, oldD);
            }
        } else {
            this.d = newD;
        }
        return true;
    }

    void setDInUndo(ImmutableExport newD) {
        this.checkUndoing();
        if (newD == this.d) {
            return;
        }
        this.d = newD;
        if (this.originalPort.getNodeInst().getD().nodeId != this.d.originalNodeId || this.originalPort.getPortProto().getId() != this.d.originalPortId) {
            this.originalPort = this.parent.getPortInst(this.d.originalNodeId, this.d.originalPortId);
        }
    }

    @Override
    public void addVar(Variable var) {
        this.setD(this.d.withVariable(var), true);
    }

    @Override
    public void delVar(Variable.Key key) {
        this.setD(this.d.withoutVariable(key), true);
    }

    @Override
    public void copyVarsFrom(ElectricObject other) {
        super.copyVarsFrom(other);
        if (this.getParent().isIcon()) {
            Iterator<Variable> it = this.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                if (var.getKey() != BusParameters.EXPORT_BUS_TEMPLATE) continue;
                this.delVar(var.getKey());
                break;
            }
        }
    }

    @Override
    public ExportId getId() {
        return this.d.exportId;
    }

    @Override
    public Cell getParent() {
        return this.parent;
    }

    public int getChronIndex() {
        return this.d.exportId.chronIndex;
    }

    @Override
    public int getPortIndex() {
        return this.portIndex;
    }

    @Override
    public TextDescriptor getTextDescriptor(Variable.Key varKey) {
        if (varKey == EXPORT_NAME) {
            return this.d.nameDescriptor;
        }
        return super.getTextDescriptor(varKey);
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        if (varKey == EXPORT_NAME) {
            this.setD(this.d.withNameDescriptor(td), true);
            return;
        }
        super.setTextDescriptor(varKey, td);
    }

    @Override
    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == EXPORT_NAME) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    private static TextDescriptor smartPlacement(PortInst originalPort) {
        int smartVertical = User.getSmartVerticalPlacementExport();
        int smartHorizontal = User.getSmartHorizontalPlacementExport();
        if (smartVertical == 0 && smartHorizontal == 0) {
            return TextDescriptor.getExportTextDescriptor();
        }
        double dx = 0.0;
        double dy = 0.0;
        NodeInst ni = originalPort.getNodeInst();
        Rectangle2D nodeBounds = ni.getBounds();
        Iterator<Connection> it = originalPort.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            ArcInst ai = con.getArc();
            Rectangle2D arcBounds = ai.getBounds();
            dx = arcBounds.getCenterX() - nodeBounds.getCenterX();
            dy = arcBounds.getCenterY() - nodeBounds.getCenterY();
        }
        if (smartHorizontal == 2) {
            dx = -dx;
        } else if (smartHorizontal != 1) {
            dx = 0.0;
        }
        if (smartVertical == 2) {
            dy = -dy;
        } else if (smartVertical != 1) {
            dy = 0.0;
        }
        TextDescriptor td = TextDescriptor.getExportTextDescriptor();
        return td.withPos(td.getPos().align(Double.compare(dx, 0.0), Double.compare(dy, 0.0)));
    }

    @Override
    public Name getNameKey() {
        return this.d.name;
    }

    @Override
    public String getName() {
        return this.d.name.toString();
    }

    public String getShortName() {
        return Export.getShortName(this.getNameKey().toString());
    }

    public static String getShortName(String name) {
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (TextUtils.isLetterOrDigit(ch)) continue;
            return name.substring(0, i);
        }
        return name;
    }

    private static String repairExportName(Cell parent, String name) {
        int openIndex;
        String newName = null;
        int oldBusWidth = Name.findName(name).busWidth();
        if (!parent.busNamesAllowed()) {
            oldBusWidth = 1;
        }
        if ((openIndex = name.indexOf(91)) >= 0) {
            int lastOpenIndex;
            int afterOpenIndex;
            for (afterOpenIndex = openIndex + 1; afterOpenIndex < name.length() && name.charAt(afterOpenIndex) == '['; ++afterOpenIndex) {
            }
            int closeIndex = name.lastIndexOf(93);
            if (closeIndex < 0 && (lastOpenIndex = name.lastIndexOf(91)) > afterOpenIndex) {
                closeIndex = lastOpenIndex;
            }
            if (afterOpenIndex < closeIndex) {
                newName = name.substring(0, openIndex) + name.substring(closeIndex + 1) + "[" + name.substring(afterOpenIndex, closeIndex) + "]";
            }
        }
        if (Export.validExportName(newName, oldBusWidth) && Export.validExportName(newName = ElectricObject.uniqueObjectName(newName, parent, PortProto.class, false), oldBusWidth)) {
            return newName;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '[' || ch == ']' || ch == ':' || ch == ',' || ch == '@') {
                ch = 'X';
            }
            sb.append(ch);
        }
        newName = sb.toString();
        if (Export.validExportName(newName, oldBusWidth) && Export.validExportName(newName = ElectricObject.uniqueObjectName(newName, parent, PortProto.class, false), oldBusWidth)) {
            return newName;
        }
        return null;
    }

    private static boolean validExportName(String name, int busWidth) {
        Name nameKey = ImmutableExport.validExportName(name, true);
        return nameKey != null && nameKey.busWidth() == busWidth;
    }

    @Override
    public int compareTo(Export that) {
        int cmp;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        return this.d.name.toString().compareTo(that.d.name.toString());
    }

    @Override
    public String toString() {
        return "export '" + this.getName() + "'";
    }

    public PortInst getOriginalPort() {
        return this.originalPort;
    }

    @Override
    public PrimitivePort getBasePort() {
        PortProto pp = this.originalPort.getPortProto();
        return pp.getBasePort();
    }

    @Override
    public boolean connectsTo(ArcProto arc) {
        return this.getBasePort().connectsTo(arc);
    }

    @Override
    public PortCharacteristic getCharacteristic() {
        return this.d.characteristic;
    }

    public void setCharacteristic(PortCharacteristic characteristic) {
        this.setD(this.d.withCharacteristic(characteristic), true);
    }

    @Override
    public boolean isPower() {
        PortCharacteristic ch = this.getCharacteristic();
        if (ch == PortCharacteristic.PWR) {
            return true;
        }
        if (ch != PortCharacteristic.UNKNOWN) {
            return false;
        }
        return this.isNamedPower();
    }

    public boolean isNamedPower() {
        String name = TextUtils.canonicString(this.getName());
        if (name.indexOf("vdd") >= 0) {
            return true;
        }
        if (name.indexOf("vcc") >= 0) {
            return true;
        }
        if (name.indexOf("pwr") >= 0) {
            return true;
        }
        return name.indexOf("power") >= 0;
    }

    @Override
    public boolean isGround() {
        PortCharacteristic ch = this.getCharacteristic();
        if (ch == PortCharacteristic.GND) {
            return true;
        }
        if (ch != PortCharacteristic.UNKNOWN) {
            return false;
        }
        return this.isNamedGround();
    }

    public boolean isNamedGround() {
        String name = TextUtils.canonicString(this.getName());
        if (name.indexOf("vss") >= 0) {
            return true;
        }
        if (name.indexOf("gnd") >= 0) {
            return true;
        }
        return name.indexOf("ground") >= 0;
    }

    public boolean isGlobalPartition() {
        return this.originalPort.getNodeInst().getProto() == Schematics.tech().globalPartitionNode;
    }

    public void setAlwaysDrawn(boolean b) {
        this.setD(this.d.withAlwaysDrawn(b), true);
    }

    public boolean isAlwaysDrawn() {
        return this.d.alwaysDrawn;
    }

    public void setBodyOnly(boolean b) {
        this.setD(this.d.withBodyOnly(b), true);
    }

    public boolean isBodyOnly() {
        return this.d.bodyOnly;
    }

    @Override
    public boolean isLinked() {
        try {
            return this.parent.isLinked() && this.parent.getPort(this.portIndex) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public EDatabase getDatabase() {
        return this.parent.getDatabase();
    }

    public PortProto getEquivalent() {
        Cell equiv = this.parent.getEquivalent();
        if (equiv == this.parent) {
            return this;
        }
        if (equiv == null) {
            return null;
        }
        return equiv.findPortProto(this.getNameKey());
    }

    public Export getEquivalentPort(Cell otherCell) {
        if (this.parent == otherCell) {
            return this;
        }
        return otherCell.findExport(this.getName());
    }

    public boolean doesntConnect(PrimitivePort newPP) {
        Iterator<NodeInst> it = this.parent.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            PortInst pi = ni.findPortInstFromProto(this);
            Iterator<Connection> cIt = pi.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                if (newPP.connectsTo(con.getArc().getProto())) continue;
                System.out.println(con.getArc() + " in " + ni.getParent() + " cannot connect to port " + this.getName());
                return true;
            }
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export oPP = eIt.next();
                if (oPP.getOriginalPort().getPortProto() != this || !oPP.doesntConnect(newPP)) continue;
                return true;
            }
        }
        return false;
    }

    private void changeallports() {
        Export opp;
        this.recursivelyChangeAllPorts();
        if (this.parent.isIcon()) {
            Export opp2;
            Cell onp = this.parent.contentsView();
            if (onp != null && (opp2 = this.getEquivalentPort(onp)) != null) {
                opp2.setCharacteristic(this.getCharacteristic());
                opp2.recursivelyChangeAllPorts();
            }
            return;
        }
        Cell onp = this.parent.iconView();
        if (onp != null && (opp = this.getEquivalentPort(onp)) != null) {
            opp.setCharacteristic(this.getCharacteristic());
            opp.recursivelyChangeAllPorts();
        }
    }

    private void recursivelyChangeAllPorts() {
        this.parent.recursivelyChangeAllPorts(Collections.singleton(this));
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortProto no = (PortProto)obj;
        if (!this.getNameKey().equals(no.getNameKey())) {
            if (buffer != null) {
                buffer.append("'" + this + "' and '" + no + "' do not have same name\n");
            }
            return false;
        }
        PortCharacteristic noC = no.getCharacteristic();
        if (!this.getCharacteristic().getName().equals(noC.getName())) {
            if (buffer != null) {
                buffer.append("'" + this + "' and '" + no + "' do not have same characteristic\n");
            }
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExportKey
    extends EObjectInputStream.Key<Export> {
        public ExportKey() {
        }

        private ExportKey(Export export) {
            super(export);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, Export export) throws IOException {
            ExportId exportId = export.getId();
            if (export.getDatabase() != out.getDatabase() || !export.isLinked()) {
                throw new NotSerializableException(export + " not linked");
            }
            out.writeObject(exportId);
        }

        @Override
        public Export readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            ExportId exportId = (ExportId)in.readObject();
            Export export = exportId.inDatabase(in.getDatabase());
            if (export == null) {
                throw new InvalidObjectException(exportId + " not linked");
            }
            return export;
        }
    }
}

