/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiTaskJob<TaskKey, TaskResult, Result>
extends Job {
    private transient LinkedHashMap<TaskKey, TaskJob> tasks;
    private Consumer<Result> consumer;

    public MultiTaskJob(String jobName, Tool t, Job.Type jobType, Consumer<Result> c) {
        super(jobName, t, jobType, null, null, Job.Priority.USER);
        this.consumer = c;
    }

    public abstract void prepareTasks() throws JobException;

    public abstract TaskResult runTask(TaskKey var1) throws JobException;

    public abstract Result mergeTaskResults(Map<TaskKey, TaskResult> var1) throws JobException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTask(String taskName, TaskKey taskKey) {
        TaskJob task = new TaskJob(taskName, taskKey);
        MultiTaskJob multiTaskJob = this;
        synchronized (multiTaskJob) {
            if (this.tasks.containsKey(taskKey)) {
                throw new IllegalArgumentException();
            }
            this.tasks.put(taskKey, task);
        }
        task.startJobOnMyResult();
    }

    @Override
    public final boolean doIt() throws JobException {
        this.tasks = new LinkedHashMap();
        this.prepareTasks();
        new MergeJob().startJob();
        return true;
    }

    private class MergeJob
    extends Job {
        private Result result;

        private MergeJob() {
            super(MultiTaskJob.this.ejob.jobName + "merge", MultiTaskJob.this.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
        }

        public boolean doIt() throws JobException {
            LinkedHashMap<Object, Object> taskResults = new LinkedHashMap<Object, Object>();
            for (TaskJob task : MultiTaskJob.this.tasks.values()) {
                if (task.taskResult == null) continue;
                taskResults.put(task.taskKey, task.taskResult);
            }
            this.result = MultiTaskJob.this.mergeTaskResults(taskResults);
            if (MultiTaskJob.this.consumer != null) {
                MultiTaskJob.this.consumer.consume(this.result);
            }
            return true;
        }

        public void abort() {
            MultiTaskJob.this.abort();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskJob
    extends Job {
        private final transient TaskKey taskKey;
        private transient TaskResult taskResult;

        private TaskJob(String taskName, TaskKey tK) {
            super(taskName, MultiTaskJob.this.tool, Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.taskKey = tK;
        }

        @Override
        public boolean doIt() throws JobException {
            this.taskResult = MultiTaskJob.this.runTask(this.taskKey);
            return true;
        }

        @Override
        public void abort() {
            MultiTaskJob.this.abort();
        }
    }
}

