/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;

public class MyTreeNode
implements TreeNode {
    private MyTreeNode parent;
    private ArrayList children;
    private String name;
    private String comment;
    private int childCount;
    private static final Pattern splitter = Pattern.compile("\\.");

    public MyTreeNode(String name, String comment) {
        this.setName(name);
        this.comment = comment;
        this.parent = null;
        this.children = new ArrayList();
        this.childCount = 0;
    }

    public String toString() {
        return this.name;
    }

    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    String getComment() {
        return this.comment;
    }

    void addChild(MyTreeNode newNode) {
        if (newNode == null) {
            return;
        }
        this.children.add(newNode);
        newNode.parent = this;
        ++this.childCount;
    }

    public Enumeration children() {
        return new ChildEnumerator(this.children);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public MyTreeNode getChildAt(int index) {
        if (index < 0 || index >= this.children.size()) {
            return null;
        }
        return (MyTreeNode)this.children.get(index);
    }

    public int getChildCount() {
        return this.childCount;
    }

    public MyTreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode child) {
        return this.children.indexOf(child);
    }

    public boolean isLeaf() {
        return this.children.size() <= 0;
    }

    public MyTreeNode[] getHierarchy() {
        ArrayList<MyTreeNode> paths = new ArrayList<MyTreeNode>();
        for (MyTreeNode node = this; node != null; node = node.getParent()) {
            paths.add(0, node);
        }
        MyTreeNode[] ret = new MyTreeNode[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            ret[i] = (MyTreeNode)paths.get(i);
        }
        return ret;
    }

    public String getPathString(int startLevel) {
        StringBuffer sb = new StringBuffer();
        MyTreeNode[] nodes = this.getHierarchy();
        for (int i = startLevel; i < nodes.length; ++i) {
            sb.append(nodes[i].getName() + '.');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static MyTreeNode getNode(MyTreeNode root, String path) {
        MyTreeNode node = root;
        MyTreeNode nextNode = null;
        String[] pathNames = splitter.split(path);
        if (path.equals("")) {
            System.out.println("MyTreeNode.getNode() WARNING: cannot use this method to find root node");
        }
        for (int depth = 0; depth < pathNames.length; ++depth) {
            boolean found = false;
            String name = pathNames[depth];
            for (int ind = 0; ind < node.getChildCount(); ++ind) {
                MyTreeNode child = node.getChildAt(ind);
                if (!child.getName().equals(name)) continue;
                if (found) {
                    Infrastructure.fatal("Two nodes with name " + name + " in path " + path);
                }
                nextNode = child;
                found = true;
            }
            if (!found) {
                return null;
            }
            node = nextNode;
        }
        return node;
    }

    private void addDescendentsToList(MyTreeNode node, List list) {
        int numKids = node.getChildCount();
        for (int ind = 0; ind < numKids; ++ind) {
            MyTreeNode kid = node.getChildAt(ind);
            list.add(kid);
            this.addDescendentsToList(kid, list);
        }
    }

    public MyTreeNode[] getDescendents() {
        ArrayList kidList = new ArrayList();
        this.addDescendentsToList(this, kidList);
        MyTreeNode[] descendents = new MyTreeNode[kidList.size()];
        for (int ind = 0; ind < kidList.size(); ++ind) {
            descendents[ind] = (MyTreeNode)kidList.get(ind);
        }
        return descendents;
    }

    void compare(MyTreeNode that, String thisFile, String thatFile) {
        if (!this.getName().equals(that.getName())) {
            System.out.println("**** Node names differ: '" + this.getPathString(1) + "' in " + thisFile + ", but '" + that.getPathString(1) + "' in " + thatFile);
        }
    }

    public static void main(String[] args) throws Exception {
        MyTreeNode level0 = new MyTreeNode("level0", "frog");
        MyTreeNode level1a = new MyTreeNode("level1a", "frog");
        MyTreeNode level1b = new MyTreeNode("level1b", "frog");
        MyTreeNode level2 = new MyTreeNode("level2", "frog");
        level0.addChild(level1a);
        level0.addChild(level1b);
        level1b.addChild(level2);
        String path = level0.getPathString(0);
        System.out.println("path string, starting at level 0: " + path);
        path = level0.getPathString(1);
        System.out.println("path string, starting at level 1 (should fail): " + path);
        MyTreeNode tryFind = MyTreeNode.getNode(level0, "");
        System.out.println("tryFind = " + tryFind);
        tryFind = MyTreeNode.getNode(level0, "level0");
        System.out.println("tryFind = " + tryFind + "\n");
        path = level1b.getPathString(0);
        System.out.println("path string, starting at level 0: " + path);
        path = level1b.getPathString(1);
        System.out.println("path string, starting at level 1: " + path);
        tryFind = MyTreeNode.getNode(level0, path);
        System.out.println("tryFind = " + tryFind + "\n");
        path = level2.getPathString(0);
        System.out.println("path string, starting at level 0: " + path);
        path = level2.getPathString(1);
        System.out.println("path string, starting at level 1: " + path);
        tryFind = MyTreeNode.getNode(level0, path);
        System.out.println("tryFind = " + tryFind);
    }

    public static class ChildEnumerator
    implements Enumeration {
        private ArrayList list;
        private int index = 0;

        public ChildEnumerator(ArrayList list) {
            this.list = list;
        }

        public boolean hasMoreElements() {
            return this.index < this.list.size();
        }

        public Object nextElement() {
            if (this.index < this.list.size()) {
                Object obj = this.list.get(this.index);
                ++this.index;
                return obj;
            }
            return null;
        }
    }
}

