/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.CachingPageStorage;

public class MemoryPageStorage
extends CachingPageStorage {
    private CachedPageImpl[] pages = new CachedPageImpl[1];
    private int numpages = 0;

    public MemoryPageStorage(int pagesize) {
        super(pagesize);
    }

    public int getNumPages() {
        return this.numpages;
    }

    public int createPage() {
        if (this.numpages >= this.pages.length) {
            CachedPageImpl[] newpages = new CachedPageImpl[this.pages.length * 2];
            System.arraycopy(this.pages, 0, newpages, 0, this.pages.length);
            this.pages = newpages;
        }
        this.pages[this.numpages] = new CachedPageImpl(this.numpages);
        return this.numpages++;
    }

    public void fsync(int pageid) {
    }

    public void fsync() {
    }

    public void writePage(int pageid, byte[] buf, int ofs) {
        System.arraycopy(buf, ofs, this.pages[pageid].buf, 0, this.getPageSize());
    }

    public void readPage(int pageid, byte[] buf, int ofs) {
        System.arraycopy(this.pages[pageid].buf, 0, buf, ofs, this.getPageSize());
    }

    public synchronized void close() {
        this.pages = null;
    }

    public CachingPageStorage.CachedPage getPage(int pageid, boolean readBytes) {
        return this.pages[pageid];
    }

    private class CachedPageImpl
    extends CachingPageStorage.CachedPage {
        private int pageid;
        private byte[] buf;
        private boolean dirty;

        public CachedPageImpl(int pageid) {
            this.pageid = pageid;
            this.buf = new byte[MemoryPageStorage.this.getPageSize()];
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getPageId() {
            return this.pageid;
        }

        public void touch() {
        }

        public void setDirty() {
            this.dirty = true;
        }

        public void flush() {
            this.dirty = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }
}

