/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.tool.io.input.EpicReaderProcess;
import com.sun.electric.tool.io.input.EpicReaderSig;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

class EpicReaderContext {
    private ArrayList<EpicReaderSig> signals = new ArrayList();
    private LinkedHashMap<String, EpicReaderContext> subs = new LinkedHashMap();

    EpicReaderContext() {
    }

    EpicReaderSig addSig(String path, char separator, byte type, int sigNum) {
        EpicReaderContext ctx;
        int indexOfSep = path.indexOf(separator);
        if (indexOfSep == -1) {
            if (type == 73) {
                path = "i(" + path + ")";
            }
            EpicReaderSig sig = new EpicReaderSig(type, path, sigNum);
            this.signals.add(sig);
            return sig;
        }
        String subName = path.substring(0, indexOfSep);
        if (subName.length() > 0 && subName.charAt(0) == 'x') {
            subName = subName.substring(1);
        }
        if ((ctx = this.subs.get(subName)) == null) {
            ctx = new EpicReaderContext();
            this.subs.put(subName, ctx);
        }
        path = path.substring(indexOfSep + 1);
        return ctx.addSig(path, separator, type, sigNum);
    }

    void writeSigs(EpicReaderProcess reader) throws IOException {
        DataOutputStream stdOut = reader.stdOut;
        for (EpicReaderSig epicReaderSig : this.signals) {
            stdOut.writeByte(epicReaderSig.type);
            stdOut.writeInt(epicReaderSig.sigNum);
            reader.writeString(epicReaderSig.name);
        }
        for (Map.Entry entry : this.subs.entrySet()) {
            String subName = (String)entry.getKey();
            EpicReaderContext sub = (EpicReaderContext)entry.getValue();
            stdOut.writeByte(68);
            reader.writeString(subName);
            sub.writeSigs(reader);
            stdOut.writeByte(85);
        }
    }
}

