/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.simulation.test.TextUtils;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class FDIrregular
extends PlacementFrame {
    protected List<ProxyNode> nodesToPlace;
    protected Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap;
    private static final boolean DEBUGSTATUS = true;
    private static final boolean DEBUGMODE = true;
    private static final boolean DEBUGPLOW = false;
    private static List<PlacementFrame.PlacementNode> debugPlacementNodes;
    private static List<PlacementAdapter.PlacementConnection> debugAllConnections;
    private static Map<String, NodeInst> placementMap;
    private static String plannedMoveNodeName;
    private static Map<ProxyNode, PlacementAdapter.PlacementNode> backMap;

    @Override
    public String getAlgorithmName() {
        return "Force-directed-Irregular";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks, String cellName, Job job) {
        this.setParamterValues(4, 240);
        this.nodesToPlace = new ArrayList<ProxyNode>(placementNodes.size());
        this.proxyMap = new HashMap<PlacementFrame.PlacementNode, ProxyNode>();
        for (PlacementFrame.PlacementNode p : placementNodes) {
            ProxyNode proxy = new ProxyNode(p);
            this.nodesToPlace.add(proxy);
            this.proxyMap.put(p, proxy);
        }
        RTNode rTree = this.makeRTree();
        for (ProxyNode pNode : this.nodesToPlace) {
            for (ProxyNode pn : this.nodesToPlace) {
                pn.clearProposed();
            }
            rTree = this.plow(pNode, 0.0, 0.0, rTree, null);
            for (ProxyNode pn : this.nodesToPlace) {
                if (!pn.isProposed()) continue;
                pn.acceptProposed();
            }
        }
        this.runIrregularPlacement(placementNodes, allNetworks);
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            ProxyNode p = this.proxyMap.get(pn);
            pn.setPlacement(p.getX(), p.getY());
            pn.setOrientation(p.getOrientation());
        }
    }

    private void runIrregularPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks) {
        ArrayList<PlacementAdapter.PlacementConnection> allConnections = new ArrayList<PlacementAdapter.PlacementConnection>();
        for (PlacementFrame.PlacementNetwork pNet : allNetworks) {
            List<PlacementAdapter.PlacementConnection> cons = PlacementAdapter.getOptimalConnections(pNet);
            for (PlacementAdapter.PlacementConnection con : cons) {
                allConnections.add(con);
            }
        }
        this.initializeDebugging(placementNodes, allConnections);
    }

    private double placementStep(List<PlacementAdapter.PlacementConnection> allConnections) {
        System.out.println("+++ PLACEMENT STEP +++");
        ProxyPair importantMove = this.sortForces(allConnections);
        if (importantMove != null) {
            System.out.println("  FORCING MOVE OF " + importantMove.nodeToMove + " BY (" + TextUtils.formatDouble(importantMove.nodeToMove.getForceX()) + "," + TextUtils.formatDouble(importantMove.nodeToMove.getForceY()) + ")");
            for (ProxyNode pn : this.nodesToPlace) {
                pn.clearProposed();
            }
            RTNode rTree = this.makeRTree();
            this.plow(importantMove.nodeToMove, importantMove.nodeToMove.getForceX(), importantMove.nodeToMove.getForceY(), rTree, importantMove.otherNode);
            for (ProxyNode pn : this.nodesToPlace) {
                if (!pn.isProposed()) continue;
                pn.acceptProposed();
            }
            return 1.0;
        }
        double networkMetricBefore = this.getCurrentHPWL(allConnections);
        double networkMetricAfter = this.doForceDirectedMultiple(allConnections, networkMetricBefore);
        if (networkMetricAfter >= 0.0) {
            return networkMetricBefore - networkMetricAfter;
        }
        networkMetricAfter = this.doForceDirected(allConnections, networkMetricBefore);
        if (networkMetricAfter >= 0.0) {
            return networkMetricBefore - networkMetricAfter;
        }
        System.out.println("  TRYING TO FILL EMPTY SPACE");
        this.fillEmptySpace();
        networkMetricAfter = this.doForceDirected(allConnections, networkMetricBefore);
        if (networkMetricAfter >= 0.0) {
            return networkMetricBefore - networkMetricAfter;
        }
        System.out.println("  CANNOT FIND ANYTHING TO DO");
        return -1.0;
    }

    private ProxyPair sortForces(List<PlacementAdapter.PlacementConnection> allConnections) {
        for (ProxyNode pNode : this.nodesToPlace) {
            pNode.clearForceVector();
        }
        for (PlacementAdapter.PlacementConnection pCon : allConnections) {
            PlacementFrame.PlacementPort p1 = pCon.getP1();
            ProxyNode pn1 = this.proxyMap.get(p1.getPlacementNode());
            Orientation o1 = pn1.getOrientation();
            Point2D off1 = o1.transformPoint(new Point2D.Double(p1.getOffX(), p1.getOffY()));
            double x1 = pn1.getX() + off1.getX();
            double y1 = pn1.getY() + off1.getY();
            PlacementFrame.PlacementPort p2 = pCon.getP2();
            ProxyNode pn2 = this.proxyMap.get(p2.getPlacementNode());
            Orientation o2 = pn2.getOrientation();
            Point2D off2 = o2.transformPoint(new Point2D.Double(p2.getOffX(), p2.getOffY()));
            double x2 = pn2.getX() + off2.getX();
            double y2 = pn2.getY() + off2.getY();
            Point2D.Double from2 = new Point2D.Double(x1, y1);
            Point2D.Double to2 = new Point2D.Double(x2, y2);
            double lX1 = pn1.getX() - pn1.getWidth() / 2.0;
            double hX1 = pn1.getX() + pn1.getWidth() / 2.0;
            double lY1 = pn1.getY() - pn1.getHeight() / 2.0;
            double hY1 = pn1.getY() + pn1.getHeight() / 2.0;
            GenMath.clipLine(to2, from2, lX1, hX1, lY1, hY1);
            x1 = ((Point2D)to2).getX();
            y1 = ((Point2D)to2).getY();
            ((Point2D)to2).setLocation(x2, y2);
            double lX2 = pn2.getX() - pn2.getWidth() / 2.0;
            double hX2 = pn2.getX() + pn2.getWidth() / 2.0;
            double lY2 = pn2.getY() - pn2.getHeight() / 2.0;
            double hY2 = pn2.getY() + pn2.getHeight() / 2.0;
            GenMath.clipLine(from2, to2, lX2, hX2, lY2, hY2);
            x2 = ((Point2D)from2).getX();
            y2 = ((Point2D)from2).getY();
            if (x1 == x2 && y1 == y2) {
                if (lX1 == hX2 || lX2 == hX1) {
                    y1 = pn1.getY() + off1.getY();
                    y2 = pn2.getY() + off2.getY();
                } else if (lY1 == hY2 || lY2 == hY1) {
                    x1 = pn1.getX() + off1.getX();
                    x2 = pn2.getX() + off2.getX();
                }
            }
            pn1.accumulateForce(x2 - x1, y2 - y1, pn2);
            pn2.accumulateForce(x1 - x2, y1 - y2, pn1);
        }
        ProxyNode bestImportantMove = null;
        ProxyNode bestOther = null;
        double bestDist = 0.0;
        for (ProxyNode node : this.nodesToPlace) {
            double dist;
            ProxyNode other = node.normalizeForce();
            if (other == null || !((dist = Math.sqrt(node.getForceX() * node.getForceX() + node.getForceY() * node.getForceY())) > bestDist)) continue;
            bestDist = dist;
            bestImportantMove = node;
            bestOther = other;
        }
        if (bestImportantMove != null) {
            return new ProxyPair(bestImportantMove, bestOther);
        }
        Collections.sort(this.nodesToPlace, new ProxyMovement());
        return null;
    }

    private void fillEmptySpace() {
        RTNode rTree = this.makeRTree();
        for (ProxyNode node : this.nodesToPlace) {
            if (!node.hasForce()) continue;
            Point2D.Double delta = new Point2D.Double(node.getForceX(), node.getForceY());
            this.greatestMove(node, delta, rTree);
            if (Math.abs(((Point2D)delta).getX()) < Math.abs(((Point2D)delta).getY())) {
                node.setForce(0.0, ((Point2D)delta).getY());
                continue;
            }
            node.setForce(((Point2D)delta).getX(), 0.0);
        }
        Collections.sort(this.nodesToPlace, new ProxyMovement());
    }

    private void greatestMove(ProxyNode node, Point2D delta, RTNode rTree) {
        double amt;
        PlaceBound sBound;
        RTNode.Search sea;
        ERectangle search;
        double dX = delta.getX();
        double dY = delta.getY();
        double nodeLX = node.getX() - node.getWidth() / 2.0;
        double nodeLY = node.getY() - node.getHeight() / 2.0;
        if (dX < 0.0) {
            search = ERectangle.fromLambda(nodeLX + dX, nodeLY, node.getWidth() - dX, node.getHeight());
            sea = new RTNode.Search(search, rTree, true);
            while (sea.hasNext()) {
                sBound = (PlaceBound)sea.next();
                if (sBound.pn == node || sBound.bound.getMinY() >= search.getMaxY() || sBound.bound.getMaxY() <= search.getMinY()) continue;
                amt = -(DBMath.round(nodeLX) - sBound.bound.getMaxX());
                if (amt > 0.0) {
                    amt = 0.0;
                }
                if (!(amt > dX)) continue;
                dX = amt;
            }
        } else if (dX > 0.0) {
            search = ERectangle.fromLambda(nodeLX, nodeLY, node.getWidth() + dX, node.getHeight());
            sea = new RTNode.Search(search, rTree, true);
            while (sea.hasNext()) {
                sBound = (PlaceBound)sea.next();
                if (sBound.pn == node || sBound.bound.getMinY() >= search.getMaxY() || sBound.bound.getMaxY() <= search.getMinY()) continue;
                amt = sBound.bound.getMinX() - DBMath.round(nodeLX + node.getWidth());
                if (amt < 0.0) {
                    amt = 0.0;
                }
                if (!(amt < dX)) continue;
                dX = amt;
            }
        }
        if (dY < 0.0) {
            search = ERectangle.fromLambda(nodeLX, nodeLY + dY, node.getWidth(), node.getHeight() - dY);
            sea = new RTNode.Search(search, rTree, true);
            while (sea.hasNext()) {
                sBound = (PlaceBound)sea.next();
                if (sBound.pn == node || sBound.bound.getMinX() >= search.getMaxX() || sBound.bound.getMaxX() <= search.getMinX()) continue;
                amt = -(DBMath.round(nodeLY) - sBound.bound.getMaxY());
                if (amt > 0.0) {
                    amt = 0.0;
                }
                if (!(amt > dY)) continue;
                dY = amt;
            }
        } else if (dY > 0.0) {
            search = ERectangle.fromLambda(nodeLX, nodeLY, node.getWidth(), node.getHeight() + dY);
            sea = new RTNode.Search(search, rTree, true);
            while (sea.hasNext()) {
                sBound = (PlaceBound)sea.next();
                if (sBound.pn == node || sBound.bound.getMinX() >= search.getMaxX() || sBound.bound.getMaxX() <= search.getMinX()) continue;
                amt = sBound.bound.getMinY() - DBMath.round(nodeLY + node.getHeight());
                if (amt < 0.0) {
                    amt = 0.0;
                }
                if (!(amt < dY)) continue;
                dY = amt;
            }
        }
        delta.setLocation(dX, dY);
    }

    private double doForceDirectedMultiple(List<PlacementAdapter.PlacementConnection> allConnections, double networkMetricBefore) {
        ProxyNode biggestMoveNode;
        for (ProxyNode pn : this.nodesToPlace) {
            pn.saveOriginalConfiguration();
        }
        RTNode rTree = this.makeRTree();
        int bestStep = -1;
        double bestGain = 0.0;
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            biggestMoveNode = this.nodesToPlace.get(i);
            for (ProxyNode pn : this.nodesToPlace) {
                pn.clearProposed();
            }
            rTree = this.plow(biggestMoveNode, biggestMoveNode.getForceX(), biggestMoveNode.getForceY(), rTree, null);
            double smallestHPWL = this.adjustOrientation(biggestMoveNode, allConnections);
            for (ProxyNode pn : this.nodesToPlace) {
                if (!pn.isProposed()) continue;
                pn.adjustForce(pn.getX() - pn.getProposedX(), pn.getY() - pn.getProposedY());
                pn.acceptProposed();
            }
            double gain = networkMetricBefore - smallestHPWL;
            if (!(gain > bestGain)) continue;
            bestStep = i;
            bestGain = gain;
        }
        for (ProxyNode pn : this.nodesToPlace) {
            pn.restoreOriginalConfiguration();
        }
        if (bestStep > 0) {
            System.out.println("  MAKING " + (bestStep + 1) + " MULTIPLE MOVES");
            rTree = this.makeRTree();
            for (int i = 0; i <= bestStep; ++i) {
                biggestMoveNode = this.nodesToPlace.get(i);
                for (ProxyNode pn : this.nodesToPlace) {
                    pn.clearProposed();
                }
                rTree = this.plow(biggestMoveNode, biggestMoveNode.getForceX(), biggestMoveNode.getForceY(), rTree, null);
                this.adjustOrientation(biggestMoveNode, allConnections);
                for (ProxyNode pn : this.nodesToPlace) {
                    if (!pn.isProposed()) continue;
                    pn.adjustForce(pn.getX() - pn.getProposedX(), pn.getY() - pn.getProposedY());
                    pn.acceptProposed();
                }
            }
            double networkMetricAfter = networkMetricBefore - bestGain;
            return networkMetricAfter;
        }
        System.out.println("  CANNOT MAKE MULTIPLE MOVES");
        return -1.0;
    }

    private double doForceDirected(List<PlacementAdapter.PlacementConnection> allConnections, double networkMetricBefore) {
        for (ProxyNode biggestMoveNode : this.nodesToPlace) {
            for (ProxyNode pn : this.nodesToPlace) {
                pn.clearProposed();
            }
            RTNode rTree = this.makeRTree();
            rTree = this.plow(biggestMoveNode, biggestMoveNode.getForceX(), biggestMoveNode.getForceY(), rTree, null);
            double smallestHPWL = this.adjustOrientation(biggestMoveNode, allConnections);
            double gain = networkMetricBefore - smallestHPWL;
            if (!(gain > 0.0)) continue;
            for (ProxyNode pn : this.nodesToPlace) {
                if (!pn.isProposed()) continue;
                pn.acceptProposed();
            }
            System.out.println("  MAKING SINGLE MOVE OF NODE " + biggestMoveNode);
            return smallestHPWL;
        }
        System.out.println("  CANNOT MAKE A SINGLE MOVE");
        return -1.0;
    }

    private double adjustOrientation(ProxyNode biggestMoveNode, List<PlacementAdapter.PlacementConnection> allConnections) {
        GenMath.MutableDouble networkMetricAfter = new GenMath.MutableDouble(0.0);
        GenMath.MutableDouble networkMetricAfterR180 = new GenMath.MutableDouble(0.0);
        GenMath.MutableDouble networkMetricAfterFx = new GenMath.MutableDouble(0.0);
        GenMath.MutableDouble networkMetricAfterFy = new GenMath.MutableDouble(0.0);
        for (PlacementAdapter.PlacementConnection con : allConnections) {
            this.netLength(con, biggestMoveNode, networkMetricAfter, networkMetricAfterR180, networkMetricAfterFx, networkMetricAfterFy);
        }
        double smallestHPWL = networkMetricAfter.doubleValue();
        double unrotHPWL = smallestHPWL;
        if (unrotHPWL != (smallestHPWL = Math.min(Math.min(smallestHPWL, networkMetricAfterR180.doubleValue()), Math.min(networkMetricAfterFx.doubleValue(), networkMetricAfterFy.doubleValue())))) {
            if (networkMetricAfterR180.doubleValue() == smallestHPWL) {
                biggestMoveNode.setProposedOrientationChange(Orientation.RR);
            } else if (networkMetricAfterFx.doubleValue() == smallestHPWL) {
                biggestMoveNode.setProposedOrientationChange(Orientation.X);
            } else if (networkMetricAfterFy.doubleValue() == smallestHPWL) {
                biggestMoveNode.setProposedOrientationChange(Orientation.Y);
            }
        }
        return smallestHPWL;
    }

    private RTNode makeRTree() {
        RTNode root2 = RTNode.makeTopLevel();
        for (ProxyNode pNode : this.nodesToPlace) {
            ERectangle bounds = ERectangle.fromLambda(pNode.getX() - pNode.getWidth() / 2.0, pNode.getY() - pNode.getHeight() / 2.0, pNode.getWidth(), pNode.getHeight());
            pNode.setRTNode(bounds);
            root2 = RTNode.linkGeom(null, root2, pNode.getRTNode());
        }
        return root2;
    }

    private RTNode plow(ProxyNode pNode, double dX, double dY, RTNode rTree, ProxyNode fixed) {
        double prevX = pNode.getProposedX();
        double prevY = pNode.getProposedY();
        if (!pNode.isProposed()) {
            pNode.setProposedOrientationChange(Orientation.IDENT);
        }
        pNode.setProposed(pNode.getProposedX() + dX, pNode.getProposedY() + dY);
        rTree = RTNode.unLinkGeom(null, rTree, pNode.getRTNode());
        ERectangle pBound = ERectangle.fromLambda(pNode.getProposedX() - pNode.getWidth() / 2.0, pNode.getProposedY() - pNode.getHeight() / 2.0, pNode.getWidth(), pNode.getHeight());
        pNode.setRTNode(pBound);
        rTree = RTNode.linkGeom(null, rTree, pNode.getRTNode());
        ERectangle search = ERectangle.fromLambda(Math.min(prevX, pNode.getProposedX()) - pNode.getWidth() / 2.0, Math.min(prevY, pNode.getProposedY()) - pNode.getHeight() / 2.0, pNode.getWidth() + Math.abs(dX), pNode.getHeight() + Math.abs(dY));
        boolean blocked = true;
        block0: while (blocked) {
            blocked = false;
            pBound = ERectangle.fromLambda(pNode.getProposedX() - pNode.getWidth() / 2.0, pNode.getProposedY() - pNode.getHeight() / 2.0, pNode.getWidth(), pNode.getHeight());
            RTNode.Search sea = new RTNode.Search(search, rTree, true);
            while (sea.hasNext()) {
                double leastMotion;
                double upMotion;
                double downMotion;
                double rightMotion;
                PlaceBound sBound = (PlaceBound)sea.next();
                ProxyNode inArea = sBound.pn;
                if (inArea == pNode || pBound.getMinX() >= sBound.bound.getMaxX() || pBound.getMaxX() <= sBound.bound.getMinX() || pBound.getMinY() >= sBound.bound.getMaxY() || pBound.getMaxY() <= sBound.bound.getMinY()) continue;
                double leftMotion = sBound.bound.getMaxX() - pBound.getMinX();
                if (this.blocksFixed(pNode, -leftMotion, 0.0, fixed)) {
                    leftMotion = Double.MAX_VALUE;
                }
                if (this.blocksFixed(pNode, rightMotion = pBound.getMaxX() - sBound.bound.getMinX(), 0.0, fixed)) {
                    rightMotion = Double.MAX_VALUE;
                }
                if (this.blocksFixed(pNode, 0.0, -(downMotion = sBound.bound.getMaxY() - pBound.getMinY()), fixed)) {
                    downMotion = Double.MAX_VALUE;
                }
                if (this.blocksFixed(pNode, 0.0, upMotion = pBound.getMaxY() - sBound.bound.getMinY(), fixed)) {
                    upMotion = Double.MAX_VALUE;
                }
                if (leftMotion == (leastMotion = Math.min(Math.min(leftMotion, rightMotion), Math.min(upMotion, downMotion)))) {
                    rTree = this.plow(inArea, -leftMotion, 0.0, rTree, null);
                } else if (rightMotion == leastMotion) {
                    rTree = this.plow(inArea, rightMotion, 0.0, rTree, null);
                } else if (upMotion == leastMotion) {
                    rTree = this.plow(inArea, 0.0, upMotion, rTree, null);
                } else if (downMotion == leastMotion) {
                    rTree = this.plow(inArea, 0.0, -downMotion, rTree, null);
                }
                blocked = true;
                continue block0;
            }
        }
        return rTree;
    }

    private boolean blocksFixed(ProxyNode pn, double dX, double dY, ProxyNode fixed) {
        if (fixed == null) {
            return false;
        }
        double pnLX = pn.getProposedX() + dX - pn.getProposedWidth() / 2.0;
        double pnHX = pn.getProposedX() + dX + pn.getProposedWidth() / 2.0;
        double pnLY = pn.getProposedY() + dY - pn.getProposedHeight() / 2.0;
        double pnHY = pn.getProposedY() + dY + pn.getProposedHeight() / 2.0;
        double fixLX = fixed.getProposedX() - fixed.getProposedWidth() / 2.0;
        double fixHX = fixed.getProposedX() + fixed.getProposedWidth() / 2.0;
        double fixLY = fixed.getProposedY() - fixed.getProposedHeight() / 2.0;
        double fixHY = fixed.getProposedY() + fixed.getProposedHeight() / 2.0;
        return !(pnLX >= fixHX || pnHX <= fixLX || pnLY >= fixHY) && !(pnHY <= fixLY);
    }

    private double getCurrentHPWL(List<PlacementAdapter.PlacementConnection> allConnections) {
        double hpwl = 0.0;
        for (PlacementAdapter.PlacementConnection con : allConnections) {
            PlacementFrame.PlacementPort p1 = con.getP1();
            ProxyNode pn1 = this.proxyMap.get(p1.getPlacementNode());
            Point2D off1 = pn1.getOrientation().transformPoint(new Point2D.Double(p1.getOffX(), p1.getOffY()));
            double x1 = pn1.getX() + off1.getX();
            double y1 = pn1.getY() + off1.getY();
            PlacementFrame.PlacementPort p2 = con.getP2();
            ProxyNode pn2 = this.proxyMap.get(p2.getPlacementNode());
            Point2D off2 = pn2.getOrientation().transformPoint(new Point2D.Double(p2.getOffX(), p2.getOffY()));
            double x2 = pn2.getX() + off2.getX();
            double y2 = pn2.getY() + off2.getY();
            hpwl += Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        }
        return hpwl;
    }

    private void netLength(PlacementAdapter.PlacementConnection con, ProxyNode current, GenMath.MutableDouble unrot, GenMath.MutableDouble rot180, GenMath.MutableDouble flipX, GenMath.MutableDouble flipY) {
        PlacementFrame.PlacementPort p1 = con.getP1();
        ProxyNode pn1 = this.proxyMap.get(p1.getPlacementNode());
        double x1 = pn1.getProposedX();
        double y1 = pn1.getProposedY();
        Point2D.Double pureOffset1 = new Point2D.Double(p1.getOffX(), p1.getOffY());
        Orientation o1 = pn1.getProposedOrientation();
        PlacementFrame.PlacementPort p2 = con.getP2();
        ProxyNode pn2 = this.proxyMap.get(p2.getPlacementNode());
        double x2 = pn2.getProposedX();
        double y2 = pn2.getProposedY();
        Point2D.Double pureOffset2 = new Point2D.Double(p2.getOffX(), p2.getOffY());
        Orientation o2 = pn2.getProposedOrientation();
        Point2D off1 = o1.transformPoint(pureOffset1);
        double x1U = x1 + off1.getX();
        double y1U = y1 + off1.getY();
        Point2D off2 = o2.transformPoint(pureOffset2);
        double x2U = x2 + off2.getX();
        double y2U = y2 + off2.getY();
        double dist = Math.sqrt((x1U - x2U) * (x1U - x2U) + (y1U - y2U) * (y1U - y2U));
        unrot.setValue(unrot.doubleValue() + dist);
        if (pn1 == current) {
            Orientation o180 = this.rot180(o1);
            Point2D off180 = o180.transformPoint(pureOffset1);
            double x1R180 = x1 + off180.getX();
            double y1R180 = y1 + off180.getY();
            double dist180 = Math.sqrt((x1R180 - x2U) * (x1R180 - x2U) + (y1R180 - y2U) * (y1R180 - y2U));
            rot180.setValue(rot180.doubleValue() + dist180);
            Orientation oFx = this.flipX(o1);
            Point2D offFx = oFx.transformPoint(pureOffset1);
            double x1Fx = x1 + offFx.getX();
            double y1Fx = y1 + offFx.getY();
            double distFx = Math.sqrt((x1Fx - x2U) * (x1Fx - x2U) + (y1Fx - y2U) * (y1Fx - y2U));
            flipX.setValue(flipX.doubleValue() + distFx);
            Orientation oFy = this.flipY(o1);
            Point2D offFy = oFy.transformPoint(pureOffset1);
            double x1Fy = x1 + offFy.getX();
            double y1Fy = y1 + offFy.getY();
            double distFy = Math.sqrt((x1Fy - x2U) * (x1Fy - x2U) + (y1Fy - y2U) * (y1Fy - y2U));
            flipY.setValue(flipY.doubleValue() + distFy);
        } else if (pn2 == current) {
            Orientation o180 = this.rot180(o2);
            Point2D off180 = o180.transformPoint(pureOffset2);
            double x2R180 = x2 + off180.getX();
            double y2R180 = y2 + off180.getY();
            double dist180 = Math.sqrt((x2R180 - x1U) * (x2R180 - x1U) + (y2R180 - y1U) * (y2R180 - y1U));
            rot180.setValue(rot180.doubleValue() + dist180);
            Orientation oFx = this.flipX(o2);
            Point2D offFx = oFx.transformPoint(pureOffset2);
            double x2Fx = x2 + offFx.getX();
            double y2Fx = y2 + offFx.getY();
            double distFx = Math.sqrt((x2Fx - x1U) * (x2Fx - x1U) + (y2Fx - y1U) * (y2Fx - y1U));
            flipX.setValue(flipX.doubleValue() + distFx);
            Orientation oFy = this.flipY(o2);
            Point2D offFy = oFy.transformPoint(pureOffset2);
            double x2Fy = x2 + offFy.getX();
            double y2Fy = y2 + offFy.getY();
            double distFy = Math.sqrt((x2Fy - x1U) * (x2Fy - x1U) + (y2Fy - y1U) * (y2Fy - y1U));
            flipY.setValue(flipY.doubleValue() + distFy);
        } else {
            rot180.setValue(unrot.doubleValue() + dist);
            flipX.setValue(unrot.doubleValue() + dist);
            flipY.setValue(unrot.doubleValue() + dist);
        }
    }

    private Orientation rot180(Orientation o) {
        return Orientation.RR.concatenate(o);
    }

    private Orientation flipX(Orientation o) {
        return Orientation.X.concatenate(o);
    }

    private Orientation flipY(Orientation o) {
        return Orientation.Y.concatenate(o);
    }

    private void initializeDebugging(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementAdapter.PlacementConnection> allConnections) {
        debugPlacementNodes = placementNodes;
        debugAllConnections = allConnections;
        backMap = new HashMap<ProxyNode, PlacementAdapter.PlacementNode>();
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            PlacementAdapter.PlacementNode pnReal = (PlacementAdapter.PlacementNode)pn;
            backMap.put(this.proxyMap.get(pn), pnReal);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PlacementProgress();
            }
        });
    }

    private static class MakeIntermediateMove
    extends Job {
        private MakeIntermediateMove() {
            super("Place cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Cell cell = null;
            for (PlacementFrame.PlacementNode plNode : debugPlacementNodes) {
                NodeInst newNI;
                PlacementAdapter.PlacementNode pan = (PlacementAdapter.PlacementNode)plNode;
                NodeInst bmNI = pan.getOriginal();
                if (bmNI == null || (newNI = (NodeInst)placementMap.get(bmNI.getName())) == null) continue;
                double xPos = plNode.getPlacementX();
                double yPos = plNode.getPlacementY();
                Orientation orient = plNode.getPlacementOrientation();
                if (pan.getOriginal().isCellInstance()) {
                    Cell placementCell = (Cell)pan.getOriginal().getProto();
                    ERectangle bounds = placementCell.getBounds();
                    Point2D.Double centerOffset = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                    orient.pureRotate().transform(centerOffset, centerOffset);
                    xPos -= ((Point2D)centerOffset).getX();
                    yPos -= ((Point2D)centerOffset).getY();
                }
                if (newNI.getAnchorCenterX() == xPos && newNI.getAnchorCenterY() == yPos) continue;
                double dX = xPos - newNI.getAnchorCenterX();
                double dY = yPos - newNI.getAnchorCenterY();
                boolean flipX = newNI.getOrient().isXMirrored() != plNode.getPlacementOrientation().isXMirrored();
                boolean flipY = newNI.getOrient().isYMirrored() != plNode.getPlacementOrientation().isYMirrored();
                int deltaAngle = plNode.getPlacementOrientation().getAngle() - newNI.getOrient().getAngle();
                Orientation deltaO = Orientation.fromJava(deltaAngle, flipX, flipY);
                newNI.modifyInstance(dX, dY, 0.0, 0.0, deltaO);
                cell = newNI.getParent();
            }
            if (cell != null) {
                ArrayList<ArcInst> allArcs = new ArrayList<ArcInst>();
                Iterator<ArcInst> it = cell.getArcs();
                while (it.hasNext()) {
                    allArcs.add(it.next());
                }
                for (ArcInst ai : allArcs) {
                    ai.kill();
                }
                ImmutableArcInst a = Generic.tech().unrouted_arc.getDefaultInst(cell.getEditingPreferences());
                long gridExtend = a.getGridExtendOverMin();
                for (PlacementAdapter.PlacementConnection pc : debugAllConnections) {
                    PlacementFrame.PlacementNode plNode1 = pc.getP1().getPlacementNode();
                    PlacementFrame.PlacementPort thisPp1 = pc.getP1();
                    PlacementAdapter.PlacementNode pan1 = (PlacementAdapter.PlacementNode)plNode1;
                    NodeInst bmNI1 = pan1.getOriginal();
                    NodeInst newNi1 = (NodeInst)placementMap.get(bmNI1.getName());
                    PlacementAdapter.PlacementPort pp1 = (PlacementAdapter.PlacementPort)thisPp1;
                    PortInst thisPi1 = newNi1.findPortInstFromProto(pp1.getPortProto());
                    EPoint pt1 = thisPi1.getCenter();
                    PlacementFrame.PlacementNode plNode2 = pc.getP2().getPlacementNode();
                    PlacementFrame.PlacementPort thisPp2 = pc.getP2();
                    PlacementAdapter.PlacementNode pan2 = (PlacementAdapter.PlacementNode)plNode2;
                    NodeInst bmNI2 = pan2.getOriginal();
                    NodeInst newNi2 = (NodeInst)placementMap.get(bmNI2.getName());
                    PlacementAdapter.PlacementPort pp2 = (PlacementAdapter.PlacementPort)thisPp2;
                    PortInst thisPi2 = newNi2.findPortInstFromProto(pp2.getPortProto());
                    EPoint pt2 = thisPi2.getCenter();
                    ArcInst.newInstanceNoCheck(cell, Generic.tech().unrouted_arc, null, null, thisPi1, thisPi2, pt1, pt2, gridExtend, -1, a.flags);
                }
            }
            return true;
        }

        @Override
        public void terminateOK() {
            NodeInst newNI = (NodeInst)placementMap.get(plannedMoveNodeName);
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter h = wnd.getHighlighter();
            h.clear();
            if (newNI != null) {
                Rectangle2D area = newNI.getBounds();
                h.addArea(area, wnd.getCell());
            }
            h.finished();
        }
    }

    public class PlacementProgress
    extends EDialog {
        private JButton theBut;
        private boolean planned;

        public PlacementProgress() {
            super((Frame)TopLevel.getCurrentJFrame(), false);
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Debug Placement");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    PlacementProgress.this.closeDialog(evt);
                }
            });
            this.theBut = new JButton("Plan Move");
            this.theBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PlacementProgress.this.planMove();
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.theBut, gridBagConstraints);
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
            this.planned = false;
        }

        @Override
        protected void escapePressed() {
            this.closeDialog(null);
        }

        private void planMove() {
            if (this.planned) {
                this.theBut.setText("Plan Move");
                for (PlacementFrame.PlacementNode pn : debugPlacementNodes) {
                    ProxyNode p = FDIrregular.this.proxyMap.get(pn);
                    pn.setPlacement(p.getX(), p.getY());
                    pn.setOrientation(p.getOrientation());
                }
                new MakeIntermediateMove();
                this.planned = false;
                return;
            }
            placementMap = PlacementAdapter.getPlacementMap();
            this.theBut.setText("Do Move");
            this.planned = true;
            double changed = FDIrregular.this.placementStep(debugAllConnections);
            if (DBMath.round(changed) <= 0.0) {
                return;
            }
            System.out.println("  STEP IMPROVED BY " + TextUtils.formatDouble(changed));
            plannedMoveNodeName = null;
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter h = wnd.getHighlighter();
            h.clear();
            for (ProxyNode pn : FDIrregular.this.nodesToPlace) {
                NodeInst bmNI = ((PlacementAdapter.PlacementNode)backMap.get(pn)).getOriginal();
                NodeInst newNI = (NodeInst)placementMap.get(bmNI.getName());
                if (newNI == null) continue;
                Rectangle2D area = newNI.getBounds();
                Poly poly = new Poly(area);
                h.addPoly(poly, wnd.getCell(), Color.GREEN);
                Point2D[] pts = new Point2D[]{new Point2D.Double(area.getCenterX(), area.getCenterY()), new Point2D.Double(pn.x, pn.y)};
                Poly polyL = new Poly(pts);
                h.addPoly(polyL, wnd.getCell(), Color.CYAN);
            }
            h.finished();
        }

        private void closeDialog(WindowEvent evt) {
            this.setVisible(false);
            this.dispose();
        }
    }

    class ProxyNode {
        private double x;
        private double y;
        private Orientation orientation;
        private double width;
        private double height;
        private boolean moved;
        private double newX;
        private double newY;
        private Orientation newOrientation;
        private Orientation deltaOrientation;
        private double newWidth;
        private double newHeight;
        private double origX;
        private double origY;
        private Orientation origOrientation;
        private double origWidth;
        private double origHeight;
        private double origDX;
        private double origDY;
        private double dX;
        private double dY;
        private int numMoved;
        private double[] dXQ;
        private double[] dYQ;
        private int[] numMovedQ;
        private ProxyNode[] otherQ;
        private PlacementFrame.PlacementNode original;
        private PlaceBound rtNode;

        public ProxyNode(PlacementFrame.PlacementNode node) {
            this.original = node;
            NodeInst ni = ((PlacementAdapter.PlacementNode)node).getOriginal();
            this.x = DBMath.round(ni.getTrueCenterX());
            this.y = DBMath.round(ni.getTrueCenterY());
            this.orientation = ni.getOrient();
            NodeProto np = ((PlacementAdapter.PlacementNode)node).getType();
            Rectangle2D spacing = null;
            if (np instanceof Cell) {
                spacing = ((Cell)np).findEssentialBounds();
            }
            if (spacing == null) {
                this.width = node.getWidth();
                this.height = node.getHeight();
            } else {
                this.width = spacing.getWidth();
                this.height = spacing.getHeight();
            }
            if (ni.getOrient().getAngle() == 900 || ni.getOrient().getAngle() == 2700) {
                double swap = this.width;
                this.width = this.height;
                this.height = swap;
            }
            this.dXQ = new double[8];
            this.dYQ = new double[8];
            this.numMovedQ = new int[8];
            this.otherQ = new ProxyNode[8];
        }

        public String toString() {
            NodeInst ni = ((PlacementAdapter.PlacementNode)this.original).getOriginal();
            return ni.describe(false);
        }

        public String getNodeName() {
            NodeInst ni = ((PlacementAdapter.PlacementNode)this.original).getOriginal();
            return ni.getName();
        }

        public void clearForceVector() {
            this.dY = 0.0;
            this.dX = 0.0;
            this.numMoved = 0;
            for (int i = 0; i < 8; ++i) {
                this.dYQ[i] = 0.0;
                this.dXQ[i] = 0.0;
                this.numMovedQ[i] = 0;
                this.otherQ[i] = null;
            }
        }

        public void accumulateForce(double addX, double addY, ProxyNode other) {
            this.dX += addX;
            this.dY += addY;
            ++this.numMoved;
            int quadrant = -1;
            if (addX == 0.0) {
                if (addY > 0.0) {
                    quadrant = 2;
                } else if (addY < 0.0) {
                    quadrant = 6;
                }
            } else {
                quadrant = addX > 0.0 ? (addY == 0.0 ? 0 : (addY > 0.0 ? 1 : 7)) : (addY == 0.0 ? 4 : (addY > 0.0 ? 3 : 5));
            }
            if (quadrant >= 0) {
                int n = quadrant;
                this.dXQ[n] = this.dXQ[n] + addX;
                int n2 = quadrant;
                this.dYQ[n2] = this.dYQ[n2] + addY;
                if (this.numMovedQ[quadrant] == 0) {
                    this.otherQ[quadrant] = other;
                } else if (this.otherQ[quadrant] != other) {
                    this.otherQ[quadrant] = null;
                }
                int n3 = quadrant;
                this.numMovedQ[n3] = this.numMovedQ[n3] + 1;
            }
        }

        public void adjustForce(double offX, double offY) {
            this.dX += offX;
            this.dY += offY;
        }

        public void setForce(double x2, double y) {
            this.dX = x2;
            this.dY = y;
        }

        public ProxyNode normalizeForce() {
            if (this.numMoved != 0) {
                this.dX /= (double)this.numMoved;
                this.dY /= (double)this.numMoved;
            }
            if (this.numMoved == 1 && (this.dX != 0.0 || this.dY != 0.0)) {
                for (int i = 0; i < 8; ++i) {
                    if (this.otherQ[i] == null) continue;
                    return this.otherQ[i];
                }
            }
            int biggestQuadrant = -1;
            int numInBiggestQuadrant = 0;
            for (int i = 0; i < 8; ++i) {
                if (this.otherQ[i] != null && this.numMovedQ[i] > numInBiggestQuadrant) {
                    numInBiggestQuadrant = this.numMovedQ[i];
                    biggestQuadrant = i;
                }
                if (this.numMovedQ[i] <= 0) continue;
                int n = i;
                this.dXQ[n] = this.dXQ[n] / (double)this.numMovedQ[i];
                int n2 = i;
                this.dYQ[n2] = this.dYQ[n2] / (double)this.numMovedQ[i];
            }
            if (biggestQuadrant >= 0 && numInBiggestQuadrant * 2 > this.numMoved) {
                this.dX = this.dXQ[biggestQuadrant];
                this.dY = this.dYQ[biggestQuadrant];
                return this.otherQ[biggestQuadrant];
            }
            return null;
        }

        public boolean hasForce() {
            return this.numMoved != 0;
        }

        public double getForceX() {
            return DBMath.round(this.dX);
        }

        public double getForceY() {
            return DBMath.round(this.dY);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public Orientation getOrientation() {
            return this.orientation;
        }

        public void setRTNode(ERectangle bounds) {
            this.rtNode = new PlaceBound(bounds, this);
        }

        public PlaceBound getRTNode() {
            return this.rtNode;
        }

        public void clearProposed() {
            this.moved = false;
        }

        public boolean isProposed() {
            return this.moved;
        }

        public void setProposed(double x2, double y) {
            this.newX = DBMath.round(x2);
            this.newY = DBMath.round(y);
            this.moved = true;
        }

        public void setProposedOrientationChange(Orientation delta) {
            this.deltaOrientation = delta;
            this.newOrientation = delta.concatenate(this.orientation);
            int deltaAng = Math.abs(this.orientation.getAngle() - this.newOrientation.getAngle());
            if (deltaAng == 900 || deltaAng == 2700) {
                this.newWidth = this.height;
                this.newHeight = this.width;
            } else {
                this.newWidth = this.width;
                this.newHeight = this.height;
            }
        }

        public double getProposedX() {
            if (this.moved) {
                return this.newX;
            }
            return this.x;
        }

        public double getProposedY() {
            if (this.moved) {
                return this.newY;
            }
            return this.y;
        }

        public Orientation getProposedOrientation() {
            if (this.moved) {
                return this.newOrientation;
            }
            return this.orientation;
        }

        public Orientation getProposedOrientationChange() {
            if (this.moved) {
                return this.deltaOrientation;
            }
            return Orientation.IDENT;
        }

        public double getProposedWidth() {
            if (this.moved) {
                return this.newWidth;
            }
            return this.width;
        }

        public double getProposedHeight() {
            if (this.moved) {
                return this.newHeight;
            }
            return this.height;
        }

        public void acceptProposed() {
            this.x = this.newX;
            this.y = this.newY;
            this.orientation = this.newOrientation;
            this.width = this.newWidth;
            this.height = this.newHeight;
            this.moved = false;
        }

        public void saveOriginalConfiguration() {
            this.origX = this.x;
            this.origY = this.y;
            this.origOrientation = this.orientation;
            this.origWidth = this.width;
            this.origHeight = this.height;
            this.origDX = this.dX;
            this.origDY = this.dY;
        }

        public void restoreOriginalConfiguration() {
            this.x = this.origX;
            this.y = this.origY;
            this.orientation = this.origOrientation;
            this.width = this.origWidth;
            this.height = this.origHeight;
            this.dX = this.origDX;
            this.dY = this.origDY;
        }
    }

    private static class PlaceBound
    implements RTBounds {
        private ERectangle bound;
        private ProxyNode pn;

        PlaceBound(ERectangle bound, ProxyNode pn) {
            this.bound = bound;
            this.pn = pn;
        }

        @Override
        public ERectangle getBounds() {
            return this.bound;
        }

        public String toString() {
            return "Node " + this.pn;
        }
    }

    private class ProxyMovement
    implements Comparator<ProxyNode> {
        private ProxyMovement() {
        }

        @Override
        public int compare(ProxyNode c1, ProxyNode c2) {
            double r2;
            double x1 = c1.getForceX();
            double y1 = c1.getForceY();
            double x2 = c2.getForceX();
            double y2 = c2.getForceY();
            double r1 = Math.sqrt(x1 * x1 + y1 * y1);
            if (r1 == (r2 = Math.sqrt(x2 * x2 + y2 * y2))) {
                return 0;
            }
            if (r1 < r2) {
                return 1;
            }
            return -1;
        }
    }

    private static class ProxyPair {
        ProxyNode nodeToMove;
        ProxyNode otherNode;

        ProxyPair(ProxyNode me, ProxyNode you) {
            this.nodeToMove = me;
            this.otherNode = you;
        }
    }
}

