/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.util.math.Orientation;
import java.util.Iterator;

public class Inv350 {
    private static final double inY = 0.0;
    private static final double p1_nd_sp = 0.0;
    private static final double p1m1_met_wid = 0.8;
    private static final double m1m2_m1_wid = 0.9;
    private static final double totWidN = 1.1;
    private static final double totWidP = 1.7;
    private static final String nm = "inv{lay}";
    private static final double wellOverhangDiff = 1.2;
    private static final double m1_m1_sp = 0.45;
    private static final double m1_wid = 0.5;
    private static final double pd_p1_sp = 0.4;
    private static final double nd_p1_sp = 0.4;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        TrackRouterH outH;
        int i;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        Inv350.error(!threshold.equals("") && !threshold.equals("LT") && !threshold.equals("HT"), "Inv: threshold not \"\", \"LT\", or \"HT\": " + threshold);
        String nm = "inv" + threshold + (stdCell.getDoubleStrapGate() ? "_strap" : "");
        sz = stdCell.checkMinStrength(sz, threshold.equals("LT") ? 0.5 : 1.0, nm);
        double p1m1_wid = tech.getP1Width();
        double p1_p1_sp = tech.getP1ToP1Space();
        double exp_wid = 0.9;
        double in_wid = 0.8;
        double outHiY = 0.0 + (in_wid / 2.0 + 0.45 + exp_wid / 2.0);
        double outLoY = 0.0 - (in_wid / 2.0 + 0.45 + exp_wid / 2.0);
        double outsideSpace = stdCell.getDoubleStrapGate() ? 0.0 + p1m1_wid + p1_p1_sp / 2.0 : 1.2;
        double tranHiInnerY = 1.2;
        double tranLoInnerY = -1.2;
        double tranHiOuterY = Math.min(stdCell.getCellTop() - outsideSpace, stdCell.getVddY() - stdCell.getVddWidth() / 2.0 - 0.45);
        double tranLoOuterY = Math.max(stdCell.getCellBot() + outsideSpace, stdCell.getGndY() + stdCell.getGndWidth() / 2.0 + 0.45);
        double spaceAvail = tranHiOuterY - tranHiInnerY;
        double lamPerSz = threshold.equals("HT") ? 3.4 : 1.7;
        double totWidP = sz * lamPerSz;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWidP, 1);
        spaceAvail = tranLoInnerY - tranLoOuterY;
        lamPerSz = threshold.equals("LT") ? 2.2 : 1.1;
        double totWidN = sz * lamPerSz;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWidN, 1);
        Cell inv = stdCell.findPart(nm, sz);
        if (inv != null) {
            return inv;
        }
        inv = stdCell.newPart(nm, sz);
        double inX = 0.675;
        Export eIn = LayoutLib.newExport(inv, "in", ep, PortCharacteristic.IN, tech.m1(), exp_wid, inX, 0.0);
        double mosX = tech.getDiffContWidth() / 2.0 + tech.getSelectSurroundDiffInTrans() + tech.getSelectSpacingRule() / 2.0;
        double nmosY = tranLoInnerY - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, 1, fwN.gateWid, null, 'C', inv, tech, ep);
        double pmosY = tranHiInnerY + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, null, 'C', inv, tech, ep);
        double rightestGateX = Math.max(nmos.getGate(nmos.nbGates() - 1, 'T').getCenter().getX(), pmos.getGate(pmos.nbGates() - 1, 'B').getCenter().getX());
        double outX = rightestGateX + 0.4 + 0.45 + exp_wid / 2.0;
        double outY = 0.0;
        Export eOut = LayoutLib.newExport(inv, "out", ep, PortCharacteristic.OUT, tech.m1(), exp_wid, outX, outY);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, inv);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, inv);
        TrackRouterH in = new TrackRouterH(tech.p1(), tech.getP1M1Width(), 0.0, tech, ep, inv);
        in.connect(eIn);
        for (i = 0; i < pmos.nbGates(); ++i) {
            in.connect(pmos.getGate(i, 'B'));
        }
        for (i = 0; i < nmos.nbGates(); ++i) {
            in.connect(nmos.getGate(i, 'T'));
        }
        TrackRouterH outHi = outH = new TrackRouterH(tech.m1(), exp_wid, outY, tech, ep, inv);
        outHi.connect(eOut);
        for (int i2 = 1; i2 < pmos.nbSrcDrns(); i2 += 2) {
            outHi.connect(pmos.getSrcDrn(i2));
        }
        TrackRouterH outLo = outH;
        outLo.connect(eOut);
        for (int i3 = 1; i3 < nmos.nbSrcDrns(); i3 += 2) {
            outLo.connect(nmos.getSrcDrn(i3));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 0.25 + 0.225;
        stdCell.addNmosWell(wellMinX, wellMaxX, inv);
        stdCell.addPmosWell(wellMinX, wellMaxX, inv);
        double boundsLeftX = 0.0;
        double boundsRightX = outX + exp_wid / 2.0 + 0.225;
        EPoint gndLeft = EPoint.fromLambda(boundsLeftX, stdCell.getGndY());
        EPoint gndRight = EPoint.fromLambda(boundsRightX, stdCell.getGndY());
        EPoint vddLeft = EPoint.fromLambda(boundsLeftX, stdCell.getVddY());
        EPoint vddRight = EPoint.fromLambda(boundsRightX, stdCell.getVddY());
        NodeInst gndPinLeft = NodeInst.newInstance(tech.m1pin(), ep, gndLeft, 0.0, 0.0, inv);
        NodeInst gndPinRight = NodeInst.newInstance(tech.m1pin(), ep, gndRight, 0.0, 0.0, inv);
        NodeInst vddPinLeft = NodeInst.newInstance(tech.m1pin(), ep, vddLeft, 0.0, 0.0, inv);
        NodeInst vddPinRight = NodeInst.newInstance(tech.m1pin(), ep, vddRight, 0.0, 0.0, inv);
        ArcInst gndArcLeft = ArcInst.makeInstance(tech.m1(), ep, gndPinLeft.getOnlyPortInst(), inv.findExport("gnd").getOriginalPort());
        gndArcLeft.setLambdaBaseWidth(stdCell.getGndWidth());
        gndArcLeft.setTailExtended(false);
        gndArcLeft.setHeadExtended(false);
        ArcInst gndArcRight = ArcInst.makeInstance(tech.m1(), ep, gndPinRight.getOnlyPortInst(), inv.findExport("gnd").getOriginalPort());
        gndArcRight.setLambdaBaseWidth(stdCell.getGndWidth());
        gndArcRight.setTailExtended(false);
        gndArcRight.setHeadExtended(false);
        ArcInst vddArcLeft = ArcInst.makeInstance(tech.m1(), ep, vddPinLeft.getOnlyPortInst(), inv.findExport("vdd").getOriginalPort());
        vddArcLeft.setLambdaBaseWidth(stdCell.getVddWidth());
        vddArcLeft.setTailExtended(false);
        vddArcLeft.setHeadExtended(false);
        ArcInst vddArcRight = ArcInst.makeInstance(tech.m1(), ep, vddPinRight.getOnlyPortInst(), inv.findExport("vdd").getOriginalPort());
        vddArcRight.setLambdaBaseWidth(stdCell.getVddWidth());
        vddArcRight.setTailExtended(false);
        vddArcRight.setHeadExtended(false);
        NodeInst deviceMark = NodeInst.newInstance(tech.getTechnology().findNodeProto("DeviceMark-Node"), ep, EPoint.fromLambda((boundsRightX + boundsLeftX) / 2.0, (stdCell.getVddY() + stdCell.getGndY()) / 2.0), boundsRightX - boundsLeftX, stdCell.getVddY() - stdCell.getGndY(), inv);
        stdCell.addEssentialBounds(boundsLeftX, boundsRightX, inv);
        Iterator<Export> it = inv.getExports();
        while (it.hasNext()) {
            Export e = it.next();
            TextDescriptor td = e.getTextDescriptor(Export.EXPORT_NAME).withRelSize(0.5);
            e.setTextDescriptor(Export.EXPORT_NAME, td);
        }
        double gridTran = 0.1;
        double epsWidP = fwP.gateWid * (double)fwP.nbFolds - totWidP;
        int nfixWidP = (int)Math.rint(epsWidP / gridTran);
        for (int i4 = pmos.nbGates() - nfixWidP; i4 < pmos.nbGates(); ++i4) {
            pmos.getGate(i4, 'B').getNodeInst().modifyInstance(0.0, 0.0, -gridTran, 0.0, Orientation.IDENT);
            pmos.getSrcDrn(i4 + 1).getNodeInst().modifyInstance(0.0, 0.0, 0.0, -gridTran, Orientation.IDENT);
        }
        double epsWidN = fwN.gateWid * (double)fwN.nbFolds - totWidN;
        int nfixWidN = (int)Math.rint(epsWidN / gridTran);
        for (int i5 = nmos.nbGates() - nfixWidN; i5 < nmos.nbGates(); ++i5) {
            nmos.getGate(i5, 'T').getNodeInst().modifyInstance(0.0, 0.0, -gridTran, 0.0, Orientation.IDENT);
            nmos.getSrcDrn(i5 + 1).getNodeInst().modifyInstance(0.0, 0.0, 0.0, -gridTran, Orientation.IDENT);
        }
        System.out.println(inv.getName() + " " + nfixWidP + " " + nfixWidN);
        LayerCoverageTool.LayerCoveragePreferences lcp = new LayerCoverageTool.LayerCoveragePreferences(true);
        LayerCoverageTool.layerCoverageCommand(LayerCoverageTool.LCMode.IMPLANT, GeometryHandler.GHMode.ALGO_SWEEP, inv, false, lcp);
        stdCell.doNCC(inv, nm + "{sch}");
        return inv;
    }
}

