/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.RoutingDebug;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ZoomAndPanListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    public static ZoomAndPanListener theOne = new ZoomAndPanListener();
    private int startX;
    private int startY;
    private int lastX;
    private int lastY;
    private ToolBar.CursorMode mode;
    private static double[] panningAmounts = new double[]{0.15, 0.3, 0.6};

    private ZoomAndPanListener() {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        SeaOfGatesEngine.SearchVertex sv;
        if (!ClickZoomWireListener.isRightMouse(evt) && User.isRoutingMode() && (sv = RoutingDebug.findDebugSearchVertex(evt)) != null) {
            RoutingDebug.showSelectedSV(sv);
        }
        this.lastX = this.startX = evt.getX();
        this.lastY = this.startY = evt.getY();
        this.mode = ToolBar.getCursorMode();
        if (this.mode == ToolBar.CursorMode.ZOOM) {
            if ((evt.getModifiers() & 2) != 0) {
                this.mode = ToolBar.CursorMode.PAN;
            }
        } else if (this.mode == ToolBar.CursorMode.PAN && (evt.getModifiers() & 2) != 0) {
            this.mode = ToolBar.CursorMode.ZOOM;
        }
        if (this.mode == ToolBar.CursorMode.ZOOM && evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            if (!ClickZoomWireListener.isRightMouse(evt)) {
                wnd.setStartDrag(this.startX, this.startY);
                wnd.setEndDrag(this.startX, this.startY);
                wnd.setDoingAreaDrag();
            }
        }
        ZoomAndPanListener.setProperCursor(evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        SeaOfGatesEngine.SearchVertex sv;
        if (User.isRoutingMode() && (sv = RoutingDebug.findDebugSearchVertex(evt)) != null) {
            RoutingDebug.previewSelectedSV(sv, false);
        }
        ZoomAndPanListener.setProperCursor(evt);
    }

    public static void setProperCursor(MouseEvent evt) {
        if (ToolBar.getCursorMode() == ToolBar.CursorMode.ZOOM) {
            if ((evt.getModifiers() & 1) != 0) {
                TopLevel.setCurrentCursor(ToolBar.zoomOutCursor);
            } else {
                TopLevel.setCurrentCursor(ToolBar.zoomCursor);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        ZoomAndPanListener.setProperCursor(evt);
        int newX = evt.getX();
        int newY = evt.getY();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            if (wnd == null) {
                return;
            }
            double scale = wnd.getScale();
            if (this.mode == ToolBar.CursorMode.ZOOM) {
                wnd.setEndDrag(newX, newY);
                wnd.repaint();
                if (ClickZoomWireListener.isRightMouse(evt)) {
                    int deltaY = newY - this.lastY;
                    double dY = (double)deltaY / 20.0;
                    scale = dY < 0.0 ? (scale -= scale * dY) : (scale *= Math.exp(-dY));
                    wnd.setScale(scale);
                    wnd.getSavedFocusBrowser().updateCurrentFocus();
                    wnd.fullRepaint();
                }
            } else if (this.mode == ToolBar.CursorMode.PAN) {
                Point2D pt = wnd.getScheduledOffset();
                wnd.setOffset(new Point2D.Double(pt.getX() - (double)(newX - this.lastX) / scale, pt.getY() + (double)(newY - this.lastY) / scale));
                wnd.getSavedFocusBrowser().updateCurrentFocus();
                wnd.fullRepaint();
            }
            this.lastX = newX;
            this.lastY = newY;
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        ZoomAndPanListener.setProperCursor(evt);
        if (this.mode != ToolBar.CursorMode.ZOOM) {
            return;
        }
        if (ClickZoomWireListener.isRightMouse(evt)) {
            return;
        }
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            if (wnd == null) {
                return;
            }
            Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
            Point2D end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
            double minSelX = Math.min(start.getX(), end.getX());
            double maxSelX = Math.max(start.getX(), end.getX());
            double minSelY = Math.min(start.getY(), end.getY());
            double maxSelY = Math.max(start.getY(), end.getY());
            if ((evt.getModifiers() & 1) != 0) {
                wnd.setScale(wnd.getScale() * 0.5);
                Point2D.Double offset = new Point2D.Double((minSelX + maxSelX) / 2.0, (minSelY + maxSelY) / 2.0);
                if (wnd.isInPlaceEdit()) {
                    wnd.getInPlaceTransformOut().transform(offset, offset);
                }
                wnd.setOffset(offset);
                wnd.getSavedFocusBrowser().updateCurrentFocus();
                wnd.fullRepaint();
                TopLevel.setCurrentCursor(ToolBar.zoomCursor);
            } else {
                boolean onePoint = true;
                Rectangle2D.Double bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                    onePoint = false;
                }
                if (Math.abs(wnd.getStartDrag().getX() - wnd.getEndDrag().getX()) > 10.0 || Math.abs(wnd.getStartDrag().getY() - wnd.getEndDrag().getY()) > 10.0) {
                    onePoint = false;
                }
                if (!onePoint) {
                    wnd.focusScreen(bounds);
                } else {
                    System.out.println("To zoom-in, drag an area");
                }
            }
            wnd.clearDoingAreaDrag();
            wnd.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        double scale = wnd.getScale();
        int rotation = evt.getWheelRotation();
        double dY = (double)rotation / 10.0;
        scale = dY < 0.0 ? (scale -= scale * dY) : (scale *= Math.exp(-dY));
        wnd.setScale(scale);
        wnd.getSavedFocusBrowser().updateCurrentFocus();
        wnd.fullRepaint();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (chr == 27 && evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            wnd.clearDoingAreaDrag();
            wnd.repaint();
            this.mode = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    public static void redrawDisplay() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        wnd.fullRepaint();
    }

    public static void panXOrY(int direction, WindowFrame wf, int ticks) {
        wf.getContent().panXOrY(direction, panningAmounts, ticks);
    }

    public static void centerSelection() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            return;
        }
        wnd.setOffset(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
        wnd.getSavedFocusBrowser().updateCurrentFocus();
        wnd.fullRepaint();
    }

    public static void centerCursor(WindowFrame wf) {
        wf.getContent().centerCursor();
    }
}

