/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;

public class ObjectQTree {
    private static int MAX_NUM_CHILDREN = 4;
    private static int MAX_NUM_NODES = 10;
    private ObjectQNode root;

    public ObjectQTree(Rectangle2D box) {
        this.root = new ObjectQNode(box);
    }

    public boolean add(Object newObj, Rectangle2D rect) {
        return this.root.insert(new ObjectNode(newObj, rect));
    }

    public void print() {
        if (this.root != null) {
            this.root.print();
        }
    }

    public Set find(Rectangle2D searchB) {
        return this.root.find(searchB, null);
    }

    private static class ObjectQNode {
        private Set<ObjectNode> nodes;
        private ObjectQNode[] children;
        private Rectangle2D box;

        private ObjectQNode(Rectangle2D b) {
            this.box = b;
        }

        public void print() {
            System.out.println("Node Box " + this.box.toString());
            if (this.nodes != null) {
                for (ObjectNode node : this.nodes) {
                    System.out.println("Node " + node.elem.toString());
                }
            }
            if (this.children != null) {
                for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                    if (this.children[i] == null) continue;
                    System.out.print("Quadrant " + i);
                    this.children[i].print();
                }
            }
        }

        protected boolean insertInAllChildren(double centerX, double centerY, ObjectNode obj) {
            int loc = GenMath.getQuadrants(centerX, centerY, obj.getBounds());
            boolean inserted = false;
            double w = this.box.getWidth() / 2.0;
            double h = this.box.getHeight() / 2.0;
            double x2 = this.box.getX();
            double y = this.box.getY();
            for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                if ((loc >> i & 1) != 1) continue;
                Rectangle2D bb = GenMath.getQTreeBox(x2, y, w, h, centerX, centerY, i);
                if (this.children[i] == null) {
                    this.children[i] = new ObjectQNode(bb);
                }
                boolean done = this.children[i].insert(obj);
                inserted = inserted ? inserted : done;
            }
            return inserted;
        }

        protected Set<Object> find(Rectangle2D searchBox, Set<Object> list2) {
            block5: {
                block4: {
                    if (!this.box.intersects(searchBox)) {
                        return list2;
                    }
                    if (list2 == null) {
                        list2 = new HashSet<Object>();
                    }
                    if (this.children == null) break block4;
                    for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                        list2 = this.children[i].find(searchBox, list2);
                    }
                    break block5;
                }
                if (this.nodes == null) break block5;
                for (ObjectNode node : this.nodes) {
                    if (!node.intersectsWithBox(searchBox)) continue;
                    list2.add(node.elem);
                }
            }
            return list2;
        }

        protected boolean insert(ObjectNode obj) {
            boolean inserted;
            if (!obj.intersectsWithBox(this.box)) {
                return false;
            }
            double centerX = this.box.getCenterX();
            double centerY = this.box.getCenterY();
            if (this.children != null) {
                return this.insertInAllChildren(centerX, centerY, obj);
            }
            if (this.nodes == null) {
                this.nodes = new HashSet<ObjectNode>();
            }
            if (this.nodes.size() < MAX_NUM_NODES) {
                inserted = this.nodes.add(obj);
            } else {
                this.children = new ObjectQNode[MAX_NUM_CHILDREN];
                double w = this.box.getWidth() / 2.0;
                double h = this.box.getHeight() / 2.0;
                double x2 = this.box.getX();
                double y = this.box.getY();
                for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                    Rectangle2D bb = GenMath.getQTreeBox(x2, y, w, h, centerX, centerY, i);
                    this.children[i] = new ObjectQNode(bb);
                    for (ObjectNode node : this.nodes) {
                        this.children[i].insert(node);
                    }
                }
                this.nodes = null;
                inserted = this.insertInAllChildren(centerX, centerY, obj);
            }
            return inserted;
        }
    }

    private static class ObjectNode {
        private Object elem;
        private Rectangle2D rect;
        private boolean isEmpty;

        ObjectNode(Object e, Rectangle2D r) {
            this.elem = e;
            this.rect = r;
            this.isEmpty = r.isEmpty();
        }

        boolean intersectsWithBox(Rectangle2D box) {
            if (!this.isEmpty) {
                return box.intersects(this.rect);
            }
            return DBMath.pointInRect(new Point2D.Double(this.rect.getMinX(), this.rect.getMinY()), box);
        }

        Rectangle2D getBounds() {
            return this.rect;
        }
    }
}

