/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.tool.user.ErrorLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

class ValidationLayers {
    private Technology layersValidTech = null;
    private boolean[] layersValid;
    private Technology layerInterTech = null;
    private HashMap<PrimitiveNode, boolean[]> layersInterNodes = null;
    private HashMap<ArcProto, boolean[]> layersInterArcs = null;
    private ErrorLogger errorLogger;
    private Cell topCell;
    private XMLRules currentRules;

    ValidationLayers(ErrorLogger logger, Cell cell, XMLRules rules) {
        this.topCell = cell;
        this.errorLogger = logger;
        this.currentRules = rules;
        this.layersValidTech = rules.getTechnology();
        this.fillValidLayers();
        this.cacheValidLayers(this.layersValidTech);
        this.buildLayerInteractions(this.layersValidTech);
    }

    private void fillValidLayers() {
        int numLayers = this.layersValidTech.getNumLayers();
        this.layersValid = new boolean[numLayers];
        for (int i = 0; i < numLayers; ++i) {
            this.layersValid[i] = false;
        }
        Iterator<Comparable<PrimitiveNode>> it = this.layersValidTech.getNodes();
        while (it.hasNext()) {
            Technology.NodeLayer[] layers;
            PrimitiveNode np = it.next();
            if (np.isNotUsed()) continue;
            for (Technology.NodeLayer l : layers = np.getNodeLayers()) {
                Layer layer = l.getLayer();
                this.layersValid[layer.getIndex()] = true;
            }
        }
        it = this.layersValidTech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            if (ap.isNotUsed()) continue;
            Iterator<Layer> lIt = ap.getLayerIterator();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                this.layersValid[layer.getIndex()] = true;
            }
        }
    }

    boolean isABadLayer(Technology tech, int layerNumber) {
        return tech == this.layersValidTech && !this.layersValid[layerNumber];
    }

    void cacheValidLayers(Technology tech) {
        if (tech == null) {
            return;
        }
        if (this.layersValidTech == tech) {
            return;
        }
        this.layersValidTech = tech;
        this.fillValidLayers();
    }

    void buildLayerInteractions(Technology tech) {
        Technology old = this.layerInterTech;
        if (this.layerInterTech == tech) {
            return;
        }
        this.layerInterTech = tech;
        int numLayers = tech.getNumLayers();
        if (this.layersInterNodes != null && old != null) {
            this.errorLogger.logWarning("Switching from '" + old.getTechName() + "' to '" + tech.getTechName() + "' in DRC process. Check for non desired nodes in ", this.topCell, -1);
        }
        this.layersInterNodes = new HashMap();
        Iterator<Comparable<PrimitiveNode>> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np.isNotUsed()) continue;
            boolean[] layersInNode = new boolean[numLayers];
            Arrays.fill(layersInNode, false);
            Technology.NodeLayer[] layers = np.getNodeLayers();
            Technology.NodeLayer[] eLayers = np.getElectricalLayers();
            if (eLayers != null) {
                layers = eLayers;
            }
            for (Technology.NodeLayer l : layers) {
                Layer layer = l.getLayer();
                if (layer.isNonElectrical()) continue;
                Iterator<Layer> lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer oLayer = lIt.next();
                    if (oLayer.isNonElectrical() || !this.currentRules.isAnySpacingRule(layer, oLayer)) continue;
                    layersInNode[oLayer.getIndex()] = true;
                }
            }
            this.layersInterNodes.put(np, layersInNode);
        }
        this.layersInterArcs = new HashMap();
        it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            boolean[] layersInArc = new boolean[numLayers];
            Arrays.fill(layersInArc, false);
            Iterator<Layer> alIt = ap.getLayerIterator();
            while (alIt.hasNext()) {
                Layer layer = alIt.next();
                Iterator<Layer> lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer oLayer = lIt.next();
                    if (!this.currentRules.isAnySpacingRule(layer, oLayer)) continue;
                    layersInArc[oLayer.getIndex()] = true;
                }
            }
            this.layersInterArcs.put(ap, layersInArc);
        }
    }

    boolean checkLayerWithNode(Layer layer, NodeProto np) {
        this.buildLayerInteractions(np.getTechnology());
        boolean[] validLayers = this.layersInterNodes.get(np);
        if (validLayers == null) {
            return false;
        }
        return validLayers[layer.getIndex()];
    }

    boolean checkLayerWithArc(Layer layer, ArcProto ap) {
        this.buildLayerInteractions(ap.getTechnology());
        boolean[] validLayers = this.layersInterArcs.get(ap);
        if (validLayers == null) {
            return false;
        }
        return validLayers[layer.getIndex()];
    }
}

