/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.utils.concurrent;

import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.CircularArray;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.IDEStructure;
import java.util.concurrent.atomic.AtomicReference;

public class DEQueue<T>
extends IDEStructure<T> {
    private static final int LOG_CAPACITY = 4;
    private volatile CircularArray items = new CircularArray(4);
    private volatile int bottom = 0;
    private AtomicReference<Integer> top = new AtomicReference<Integer>(0);

    @Override
    public void add(T item) {
        CircularArray currentTasks;
        int oldBottom = this.bottom;
        int oldTop = this.top.get();
        int size2 = oldBottom - oldTop;
        if (size2 >= (currentTasks = this.items).getCapacity() - 1) {
            this.items = currentTasks = currentTasks.resize(oldBottom, oldTop);
        }
        this.items.add(oldBottom, (Runnable)item);
        this.bottom = oldBottom + 1;
        this.size = new Integer(this.size + 1);
    }

    @Override
    public T get() throws EmptyException {
        --this.bottom;
        int oldTop = this.top.get();
        int newTop = oldTop + 1;
        int size2 = this.bottom - oldTop;
        if (size2 < 0) {
            this.bottom = oldTop;
            return null;
        }
        Runnable item = this.items.get(this.bottom);
        if (size2 > 0) {
            this.size = new Integer(this.size - 1);
            return (T)item;
        }
        if (!this.top.compareAndSet(new Integer(oldTop), new Integer(newTop))) {
            item = null;
        }
        this.bottom = oldTop + 1;
        this.size = new Integer(this.size - 1);
        return (T)item;
    }

    @Override
    public T getFromTop() throws EmptyException {
        int oldTop = this.top.get();
        int newTop = oldTop + 1;
        int oldBottom = this.bottom;
        int size2 = oldBottom - oldTop;
        if (size2 <= 0) {
            return null;
        }
        Runnable item = this.items.get(oldTop);
        if (this.top.compareAndSet(new Integer(oldTop), new Integer(newTop))) {
            this.size = new Integer(this.size - 1);
            return (T)item;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        int localBottom = this.bottom;
        int localTop = this.top.get();
        return localBottom <= localTop;
    }
}

