/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Route
extends ArrayList<RouteElement> {
    private RouteElementPort routeStart;
    private RouteElementPort routeEnd;
    private boolean routeReversed;

    public Route() {
        this.routeStart = null;
        this.routeEnd = null;
        this.routeReversed = false;
    }

    public Route(Collection<RouteElement> c) {
        super(c);
        if (c instanceof Route) {
            Route r = (Route)c;
            this.routeStart = r.getStart();
            this.routeEnd = r.getEnd();
        } else {
            this.routeStart = null;
            this.routeEnd = null;
        }
    }

    public void setStart(RouteElementPort startRE) {
        if (!this.contains(startRE)) {
            this.add(startRE);
        }
        this.routeStart = startRE;
    }

    public RouteElementPort getStart() {
        return this.routeStart;
    }

    public void setEnd(RouteElementPort endRE) {
        if (!this.contains(endRE)) {
            this.add(endRE);
        }
        this.routeEnd = endRE;
    }

    public RouteElementPort getEnd() {
        return this.routeEnd;
    }

    public void reverseRoute() {
        RouteElementPort re = this.routeStart;
        this.routeStart = this.routeEnd;
        this.routeEnd = re;
        this.routeReversed = !this.routeReversed;
    }

    public boolean isRouteReversed() {
        return this.routeReversed;
    }

    public boolean replacePin(RouteElementPort pin, RouteElementPort replacement, PolyMerge stayInside, EditingPreferences ep) {
        if (this.replaceBisectPin(pin, replacement)) {
            return true;
        }
        return this.replaceExistingRedundantPin(pin, replacement, stayInside, ep);
    }

    public boolean replaceBisectPin(RouteElementPort bisectPin, RouteElementPort replacement) {
        if (!bisectPin.isBisectArcPin()) {
            return false;
        }
        assert (this.contains(bisectPin));
        boolean success2 = true;
        for (RouteElement re : this) {
            RouteElementArc reArc;
            if (!(re instanceof RouteElementArc) || (reArc = (RouteElementArc)re).replaceArcEnd(bisectPin, replacement)) continue;
            success2 = false;
        }
        return success2;
    }

    public boolean replaceExistingRedundantPin(RouteElementPort pinRE, RouteElementPort replacementRE, PolyMerge stayInside, EditingPreferences ep) {
        if (pinRE.getAction() != RouteElement.RouteElementAction.existingPortInst) {
            return false;
        }
        PortInst pi = pinRE.getPortInst();
        NodeInst ni = pi.getNodeInst();
        if (!ni.getProto().getFunction().isPin()) {
            return false;
        }
        if (pi.getExports().hasNext()) {
            return false;
        }
        ArrayList<RouteElementArc> newElements = new ArrayList<RouteElementArc>();
        Cell cell = replacementRE.getCell();
        boolean replace = true;
        if (!pi.hasConnections() && !ni.getTrueCenter().equals(replacementRE.getLocation())) {
            return false;
        }
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            Connection conn = it.next();
            if (replacementRE.getPortProto().connectsTo(conn.getArc().getProto())) {
                if (conn.getLocation().equals(replacementRE.getLocation())) {
                    ArcInst ai = conn.getArc();
                    int otherEnd = 1 - conn.getEndIndex();
                    RouteElementPort otherPort = RouteElementPort.existingPortInst(ai.getPortInst(otherEnd), ai.getPortInst(otherEnd).getPoly(), ep);
                    RouteElementArc newArc = conn.getEndIndex() == 1 ? RouteElementArc.newArc(cell, ai.getProto(), ai.getLambdaBaseWidth(), replacementRE, otherPort, conn.getLocation(), ai.getLocation(otherEnd), ai.getName(), ai.getTextDescriptor(ArcInst.ARC_NAME), ai, ai.isHeadExtended(), ai.isTailExtended(), stayInside) : RouteElementArc.newArc(cell, ai.getProto(), ai.getLambdaBaseWidth(), otherPort, replacementRE, ai.getLocation(otherEnd), conn.getLocation(), ai.getName(), ai.getTextDescriptor(ArcInst.ARC_NAME), ai, ai.isHeadExtended(), ai.isTailExtended(), stayInside);
                    newArc.setArcAngle(ai.getAngle());
                    RouteElementArc delArc = RouteElementArc.deleteArc(ai, ep);
                    newElements.add(newArc);
                    newElements.add(delArc);
                    continue;
                }
                replace = false;
                break;
            }
            replace = false;
            break;
        }
        if (replace) {
            RouteElementPort delPort = RouteElementPort.deleteNode(ni, ep);
            this.add(delPort);
            for (RouteElementArc e : newElements) {
                this.add(e);
            }
        }
        return replace;
    }
}

