/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.result.EquivRecReport;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.SizeMismatch;
import com.sun.electric.tool.user.ncc.ExportAssertionFailures;
import com.sun.electric.tool.user.ncc.ExportConflict;
import com.sun.electric.tool.user.ncc.ExportMismatch;
import com.sun.electric.tool.user.ncc.UnrecognizedPart;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NccGuiInfo
implements Serializable {
    static final long serialVersionUID = 0L;
    private NccResult nccResult;
    private boolean swapCells = false;
    private List<ExportMismatch> exportMismatches = new LinkedList<ExportMismatch>();
    private List<SizeMismatch.Mismatch> sizeMismatches = new LinkedList<SizeMismatch.Mismatch>();
    private int numExportsValidOnlyWhenTopologyMismatch = 0;
    private List<ExportAssertionFailures> exportAssertionFailures = new LinkedList<ExportAssertionFailures>();
    private List<ExportConflict.NetworkConflict> networkExportConflicts = new LinkedList<ExportConflict.NetworkConflict>();
    private List<ExportConflict.CharactConflict> charactExportConflicts = new LinkedList<ExportConflict.CharactConflict>();
    private List<UnrecognizedPart> unrecognizedParts = new LinkedList<UnrecognizedPart>();
    private List<EquivRecReport> partRecReports = new ArrayList<EquivRecReport>();
    private List<EquivRecReport> wireRecReports = new ArrayList<EquivRecReport>();

    public void setNccResult(NccResult r) {
        this.nccResult = r;
    }

    public int getTotalMismatchCount() {
        int eqvRecCount = this.partRecReports.size() + this.wireRecReports.size();
        return this.getValidExportMismatchCount() + eqvRecCount + this.sizeMismatches.size() + this.exportAssertionFailures.size() + this.networkExportConflicts.size() + this.charactExportConflicts.size() + this.unrecognizedParts.size();
    }

    public boolean isSwapCells() {
        return this.swapCells;
    }

    public String[] getNames() {
        return this.nccResult.getRootCellNames();
    }

    public Cell[] getCells() {
        return this.nccResult.getRootCells();
    }

    public VarContext[] getContexts() {
        return this.nccResult.getRootContexts();
    }

    public NccResult.CellSummary getCellSummary() {
        return this.nccResult.getCellSummary();
    }

    public void addExportMismatch(ExportMismatch em) {
        this.exportMismatches.add(em);
        if (em.isValidOnlyWhenTopologyMismatch()) {
            ++this.numExportsValidOnlyWhenTopologyMismatch;
        }
    }

    public List<ExportMismatch> getExportMismatches() {
        return this.exportMismatches;
    }

    public void setPartRecReports(List<EquivRecReport> badParts) {
        this.partRecReports = badParts;
    }

    public List<EquivRecReport> getPartRecReports() {
        return this.partRecReports;
    }

    public void setWireRecReports(List<EquivRecReport> badWires) {
        this.wireRecReports = badWires;
    }

    public List<EquivRecReport> getWireRecReports() {
        return this.wireRecReports;
    }

    public boolean isHashFailuresPrinted() {
        if (this.partRecReports.size() != 0) {
            return this.partRecReports.get(0).hashMismatch();
        }
        if (this.wireRecReports.size() != 0) {
            return this.wireRecReports.get(0).hashMismatch();
        }
        return false;
    }

    public boolean hasLocalPartitionMismatches() {
        if (this.partRecReports.size() != 0) {
            return !this.partRecReports.get(0).hashMismatch();
        }
        if (this.wireRecReports.size() != 0) {
            return !this.wireRecReports.get(0).hashMismatch();
        }
        return false;
    }

    public boolean isExportMatch() {
        return this.nccResult.exportMatch();
    }

    public boolean isSizeMatch() {
        return this.nccResult.sizeMatch();
    }

    public boolean isTopologyMatch() {
        return this.nccResult.topologyMatch();
    }

    public boolean isSizeChecked() {
        return this.nccResult.getOptions().checkSizes;
    }

    public int getValidExportMismatchCount() {
        if (this.isTopologyMatch()) {
            return this.exportMismatches.size() - this.numExportsValidOnlyWhenTopologyMismatch;
        }
        return this.exportMismatches.size();
    }

    public List<SizeMismatch.Mismatch> getSizeMismatches() {
        return this.sizeMismatches;
    }

    public void setSizeMismatches(List<SizeMismatch.Mismatch> sizeMismatches) {
        this.sizeMismatches = sizeMismatches;
    }

    public void addExportAssertionFailure(Cell cell, VarContext context, Object[][] items, String[][] names) {
        this.exportAssertionFailures.add(new ExportAssertionFailures(cell, context, items, names));
    }

    public List<ExportAssertionFailures> getExportAssertionFailures() {
        return this.exportAssertionFailures;
    }

    public void addNetworkExportConflict(ExportConflict.NetworkConflict conf) {
        this.networkExportConflicts.add(conf);
    }

    public List<ExportConflict.NetworkConflict> getNetworkExportConflicts() {
        return this.networkExportConflicts;
    }

    public void addCharactExportConflict(ExportConflict.CharactConflict conf) {
        this.charactExportConflicts.add(conf);
    }

    public List<ExportConflict.CharactConflict> getCharactExportConflicts() {
        return this.charactExportConflicts;
    }

    public void addUnrecognizedPart(UnrecognizedPart mos) {
        this.unrecognizedParts.add(mos);
    }

    public List<UnrecognizedPart> getUnrecognizedParts() {
        return this.unrecognizedParts;
    }
}

