/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.KeyBindingManager;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.KeyBindings;
import com.sun.electric.tool.user.ui.KeyStrokePair;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class EMenuBar
extends EMenu {
    private Preferences prefs;
    Map<String, EMenuItem> menuItems = new HashMap<String, EMenuItem>();
    public final KeyBindingManager keyBindingManager;
    private final EMenu hiddenMenu;
    private final List<EMenuItem> updatableItems = new ArrayList<EMenuItem>();

    EMenuBar(String name, EMenu hiddenMenu, List<EMenuItem> items) {
        super(name, items);
        this.hiddenMenu = hiddenMenu;
        this.prefs = Preferences.userNodeForPackage(EMenuBar.class);
        this.keyBindingManager = new KeyBindingManager(name + "MenuKeyBinding-", this.prefs);
        this.path = new int[0];
        int indexInParent = 0;
        for (EMenuItem item : items) {
            if (item == null) continue;
            item.registerTree(this, this.path, indexInParent++);
        }
        if (hiddenMenu != null) {
            hiddenMenu.registerTree(this, this.path, -1);
        }
    }

    public EMenu getHiddenMenu() {
        return this.hiddenMenu;
    }

    public String getDescription(int[] path) {
        StringBuilder sb = new StringBuilder();
        int topIndex = path[0];
        EMenuItem item = topIndex >= 0 ? (EMenuItem)this.items.get(topIndex) : this.hiddenMenu;
        sb.append(item.getText());
        for (int i = 1; i < path.length; ++i) {
            EMenu menu = item;
            item = menu.items.get(path[i]);
            sb.append(" | ");
            sb.append(item.getText());
        }
        return sb.toString();
    }

    void registerKeyBindings(EMenuItem menuItem) {
        String key = menuItem.getDescription();
        this.menuItems.put(key, menuItem);
        KeyStroke[] bindings = menuItem.getAccelerators();
        for (int i = 0; i < bindings.length; ++i) {
            this.addDefaultKeyBinding(menuItem, bindings[i]);
        }
        this.keyBindingManager.addActionListener(key, menuItem);
    }

    void registerUpdatable(EMenuItem menuItem) {
        this.updatableItems.add(menuItem);
    }

    public void updateAllButtons() {
        for (EMenuItem item : this.updatableItems) {
            item.updateJMenuItems();
        }
    }

    public KeyBindings getKeyBindings(EMenuItem item) {
        return this.keyBindingManager.getKeyBindings(item.getDescription());
    }

    private void addDefaultKeyBinding(EMenuItem item, KeyStroke stroke) {
        String description = item.getDescription();
        this.keyBindingManager.addDefaultKeyBinding(description, KeyStrokePair.getKeyStrokePair(null, stroke));
    }

    public void addUserKeyBinding(EMenuItem item, KeyStroke stroke, KeyStroke prefixStroke) {
        String description = item.getDescription();
        this.keyBindingManager.addUserKeyBinding(description, KeyStrokePair.getKeyStrokePair(prefixStroke, stroke));
        this.updateAccelerator(item);
    }

    public void resetKeyBindings(EMenuItem item) {
        this.keyBindingManager.resetKeyBindings(item.getDescription());
        this.updateAccelerator(item);
    }

    public void resetAllKeyBindings() {
        for (EMenuItem item : this.menuItems.values()) {
            this.resetKeyBindings(item);
        }
    }

    public void removeKeyBinding(String actionDesc, KeyStrokePair pair) {
        this.keyBindingManager.removeKeyBinding(actionDesc, pair);
        EMenuItem item = this.menuItems.get(actionDesc);
        if (item != null) {
            this.updateAccelerator(item);
        }
    }

    public void restoreSavedBindings(boolean initialCall) {
        this.keyBindingManager.restoreSavedBindings(initialCall);
        for (EMenuItem item : this.menuItems.values()) {
            this.updateAccelerator(item);
        }
    }

    private void updateAccelerator(EMenuItem item) {
        String actionDesc = item.getDescription();
        KeyBindings bindings = this.keyBindingManager.getKeyBindings(actionDesc);
        KeyStroke accelerator = null;
        if (bindings != null) {
            Iterator<KeyStrokePair> it = bindings.getUsingDefaultKeys() ? bindings.getDefaultKeyStrokePairs() : bindings.getKeyStrokePairs();
            while (it.hasNext()) {
                KeyStrokePair pair = it.next();
                if (pair.getPrefixStroke() != null) continue;
                accelerator = pair.getStroke();
                break;
            }
        }
        item.setAccelerator(accelerator);
    }

    public KeyBindingManager.KeyMaps getKeyMaps() {
        return this.keyBindingManager.getKeyMaps();
    }

    public Instance genInstance() {
        return new Instance();
    }

    public class Instance
    extends JMenuBar {
        boolean ignoreKeyBindings = false;
        boolean ignoreTextEditKeys = false;

        public Instance() {
            for (EMenuItem item : EMenuBar.this.getItems()) {
                this.add(item.genMenu());
            }
        }

        public EMenuBar getMenuBarGroup() {
            return EMenuBar.this;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            int code = e.getKeyCode();
            char ch = e.getKeyChar();
            ActivityLogger.logMessage("ProcessKeyBinding " + e.getID() + " when=" + e.getWhen() + " modifiers=" + Integer.toHexString(e.getModifiersEx()) + " code=" + Integer.toHexString(code) + " char=" + Integer.toHexString(ch) + (' ' < ch && ch < '\u007f' ? "(" + ch + ")" : "") + " " + this.ignoreKeyBindings + " " + this.ignoreTextEditKeys);
            if (this.ignoreKeyBindings) {
                return false;
            }
            if (this.ignoreTextEditKeys && !e.isControlDown() && !e.isMetaDown() && !e.isAltDown()) {
                return false;
            }
            boolean retValue = false;
            if (!retValue) {
                retValue = EMenuBar.this.keyBindingManager.processKeyEvent(e);
            }
            return retValue;
        }

        public void setIgnoreKeyBindings(boolean b) {
            this.ignoreKeyBindings = b;
        }

        public boolean getIgnoreKeyBindings() {
            return this.ignoreKeyBindings;
        }

        public void setIgnoreTextEditKeys(boolean b) {
            this.ignoreTextEditKeys = b;
        }

        public boolean getIgnoreTextEditKeys() {
            return this.ignoreTextEditKeys;
        }

        JMenuItem findMenuItem(int[] path) {
            int topIndex = path[0];
            if (topIndex < 0) {
                return null;
            }
            JMenuItem item = (JMenuItem)this.getComponent(topIndex);
            for (int i = 1; i < path.length; ++i) {
                JMenu menu = (JMenu)item;
                item = (JMenuItem)menu.getMenuComponent(path[i]);
            }
            return item;
        }

        public void finished() {
            for (int i = 0; i < this.getMenuCount(); ++i) {
                JMenu menu = this.getMenu(i);
                if (menu == null) continue;
                this.disposeofMenu(menu);
            }
            this.removeAll();
        }

        private void disposeofMenu(JMenu menu) {
            for (int j = 0; j < menu.getItemCount(); ++j) {
                JMenuItem item = menu.getItem(j);
                if (item == null) continue;
                if (item instanceof JMenu) {
                    this.disposeofMenu((JMenu)item);
                    continue;
                }
                this.disposeofMenuItem(item);
            }
            menu.removeAll();
        }

        private void disposeofMenuItem(JMenuItem item) {
            ActionListener[] listeners = item.getActionListeners();
            for (int k = 0; k < listeners.length; ++k) {
                ActionListener listener = listeners[k];
                item.removeActionListener(listener);
            }
        }
    }
}

